# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud_agile.models.author import Author
from devopso.clients.jira_cloud_agile.models.issue_id_or_keys_association import IssueIdOrKeysAssociation
from devopso.clients.jira_cloud_agile.models.reviewer import Reviewer
from typing import Optional, Set
from typing_extensions import Self

class PullRequest(BaseModel):
    """
    Represents a pull request
    """ # noqa: E501
    id: StrictStr = Field(description="The ID of this entity. Will be used for cross entity linking. Must be unique by entity type within a repository, i.e., only one commit can have ID 'X' in repository 'Y'. But adding, e.g., a branch with ID 'X' to repository 'Y' is acceptable. Only alphanumeric characters, and '~.-_', are allowed. Max length is 1024 characters")
    issue_keys: Optional[Annotated[List[StrictStr], Field(min_length=1, max_length=500)]] = Field(default=None, description="List of issues keys that this entity is associated with. They must be valid Jira issue keys.", alias="issueKeys")
    associations: Optional[List[IssueIdOrKeysAssociation]] = Field(default=None, description="The Jira issue keys or IDs to associate the pull request with.")
    update_sequence_id: StrictInt = Field(description="An ID used to apply an ordering to updates for this entity in the case of out-of-order receipt of update requests. This can be any monotonically increasing number. A suggested implementation is to use epoch millis from the provider system, but other alternatives are valid (e.g. a provider could store a counter against each entity and increment that on each update to Jira). Updates for an entity that are received with an updateSqeuenceId lower than what is currently stored will be ignored.", alias="updateSequenceId")
    status: StrictStr = Field(description="The status of the pull request. In the case of concurrent updates, priority is given in the order OPEN, MERGED, DECLINED, UNKNOWN")
    title: Annotated[str, Field(strict=True, max_length=1024)] = Field(description="Title of the pull request. Max length is 1024 characters.")
    author: Author
    comment_count: StrictInt = Field(description="The number of comments on the pull request", alias="commentCount")
    source_branch: Annotated[str, Field(strict=True, max_length=255)] = Field(description="The name of the source branch of this PR. Max length is 255 characters.", alias="sourceBranch")
    source_branch_url: Optional[Annotated[str, Field(strict=True, max_length=2000)]] = Field(default=None, description="The url of the source branch of this PR. This is used to match this PR against the branch. Max length is 2000 characters.", alias="sourceBranchUrl")
    last_update: StrictStr = Field(description="The most recent update to this PR. Formatted as a UTC ISO 8601 date time format.", alias="lastUpdate")
    destination_branch: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="The name of destination branch of this PR. Max length is 255 characters.", alias="destinationBranch")
    destination_branch_url: Optional[Annotated[str, Field(strict=True, max_length=2000)]] = Field(default=None, description="The url of the destination branch of this PR. Max length is 2000 characters.", alias="destinationBranchUrl")
    reviewers: Optional[List[Reviewer]] = Field(default=None, description="The list of reviewers of this pull request")
    url: Annotated[str, Field(strict=True, max_length=2000)] = Field(description="The URL of this pull request. Max length is 2000 characters.")
    display_id: Annotated[str, Field(strict=True, max_length=255)] = Field(description="Shortened identifier for this pull request, used for display. Max length is 255 characters.", alias="displayId")
    __properties: ClassVar[List[str]] = ["id", "issueKeys", "associations", "updateSequenceId", "status", "title", "author", "commentCount", "sourceBranch", "sourceBranchUrl", "lastUpdate", "destinationBranch", "destinationBranchUrl", "reviewers", "url", "displayId"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['OPEN', 'MERGED', 'DECLINED', 'UNKNOWN']):
            raise ValueError("must be one of enum values ('OPEN', 'MERGED', 'DECLINED', 'UNKNOWN')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PullRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in associations (list)
        _items = []
        if self.associations:
            for _item_associations in self.associations:
                if _item_associations:
                    _items.append(_item_associations.to_dict())
            _dict['associations'] = _items
        # override the default output from pydantic by calling `to_dict()` of author
        if self.author:
            _dict['author'] = self.author.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in reviewers (list)
        _items = []
        if self.reviewers:
            for _item_reviewers in self.reviewers:
                if _item_reviewers:
                    _items.append(_item_reviewers.to_dict())
            _dict['reviewers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PullRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "issueKeys": obj.get("issueKeys"),
            "associations": [IssueIdOrKeysAssociation.from_dict(_item) for _item in obj["associations"]] if obj.get("associations") is not None else None,
            "updateSequenceId": obj.get("updateSequenceId"),
            "status": obj.get("status"),
            "title": obj.get("title"),
            "author": Author.from_dict(obj["author"]) if obj.get("author") is not None else None,
            "commentCount": obj.get("commentCount"),
            "sourceBranch": obj.get("sourceBranch"),
            "sourceBranchUrl": obj.get("sourceBranchUrl"),
            "lastUpdate": obj.get("lastUpdate"),
            "destinationBranch": obj.get("destinationBranch"),
            "destinationBranchUrl": obj.get("destinationBranchUrl"),
            "reviewers": [Reviewer.from_dict(_item) for _item in obj["reviewers"]] if obj.get("reviewers") is not None else None,
            "url": obj.get("url"),
            "displayId": obj.get("displayId")
        })
        return _obj


