# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud_agile.models.remote_link_data_associations_inner import RemoteLinkDataAssociationsInner
from devopso.clients.jira_cloud_agile.models.remote_link_status import RemoteLinkStatus
from typing import Optional, Set
from typing_extensions import Self

class RemoteLinkData(BaseModel):
    """
    Data related to a single Remote Link. 
    """ # noqa: E501
    schema_version: Optional[StrictStr] = Field(default='1.0', description="The schema version used for this data.  Placeholder to support potential schema changes in the future. ", alias="schemaVersion")
    id: Annotated[str, Field(strict=True, max_length=255)] = Field(description="The identifier for the Remote Link. Must be unique for a given Provider. ")
    update_sequence_number: StrictInt = Field(description="An ID used to apply an ordering to updates for this Remote Link in the case of out-of-order receipt of update requests.  It must be a monotonically increasing number. For example, epoch time could be one way to generate the `updateSequenceNumber`.  Updates for a Remote Link that is received with an `updateSqeuenceNumber` less than or equal to what is currently stored will be ignored. ", alias="updateSequenceNumber")
    display_name: Annotated[str, Field(strict=True, max_length=255)] = Field(description="The human-readable name for the Remote Link.  Will be shown in the UI. ", alias="displayName")
    url: Annotated[str, Field(strict=True, max_length=2000)] = Field(description="The URL to this Remote Link in your system. ")
    type: StrictStr = Field(description="The type of the Remote Link. The current supported types are 'document', 'alert', 'test', 'security', 'logFile', 'prototype', 'coverage', 'bugReport' and 'other' ")
    description: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="An optional description to attach to this Remote Link.  This may be anything that makes sense in your system. ")
    last_updated: datetime = Field(description="The last-updated timestamp to present to the user as a summary of when Remote Link was last updated. ", alias="lastUpdated")
    associations: Optional[Annotated[List[RemoteLinkDataAssociationsInner], Field(min_length=1, max_length=2)]] = Field(default=None, description="The entities to associate the Remote Link information with. ")
    status: Optional[RemoteLinkStatus] = None
    action_ids: Optional[Annotated[List[StrictStr], Field(max_length=10)]] = Field(default=None, description="Optional list of actionIds. They are associated with the actions the provider is able to provide when they registered. Indicates which actions this Remote Link has.  If any actions have a templateUrl that requires string substitution, then `attributeMap` must be passed in. ", alias="actionIds")
    attribute_map: Optional[Dict[str, StrictStr]] = Field(default=None, description="Map of key/values (string to string mapping). This is used to build the urls for actions from the templateUrl the provider registered their available actions with. ", alias="attributeMap")
    __properties: ClassVar[List[str]] = ["schemaVersion", "id", "updateSequenceNumber", "displayName", "url", "type", "description", "lastUpdated", "associations", "status", "actionIds", "attributeMap"]

    @field_validator('schema_version')
    def schema_version_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['1.0']):
            raise ValueError("must be one of enum values ('1.0')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['document', 'alert', 'test', 'security', 'logFile', 'prototype', 'coverage', 'bugReport', 'other']):
            raise ValueError("must be one of enum values ('document', 'alert', 'test', 'security', 'logFile', 'prototype', 'coverage', 'bugReport', 'other')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RemoteLinkData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in associations (list)
        _items = []
        if self.associations:
            for _item_associations in self.associations:
                if _item_associations:
                    _items.append(_item_associations.to_dict())
            _dict['associations'] = _items
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RemoteLinkData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "schemaVersion": obj.get("schemaVersion") if obj.get("schemaVersion") is not None else '1.0',
            "id": obj.get("id"),
            "updateSequenceNumber": obj.get("updateSequenceNumber"),
            "displayName": obj.get("displayName"),
            "url": obj.get("url"),
            "type": obj.get("type"),
            "description": obj.get("description"),
            "lastUpdated": obj.get("lastUpdated"),
            "associations": [RemoteLinkDataAssociationsInner.from_dict(_item) for _item in obj["associations"]] if obj.get("associations") is not None else None,
            "status": RemoteLinkStatus.from_dict(obj["status"]) if obj.get("status") is not None else None,
            "actionIds": obj.get("actionIds"),
            "attributeMap": obj.get("attributeMap")
        })
        return _obj


