# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud_agile.models.branch import Branch
from devopso.clients.jira_cloud_agile.models.commit import Commit
from devopso.clients.jira_cloud_agile.models.pull_request import PullRequest
from typing import Optional, Set
from typing_extensions import Self

class Repository(BaseModel):
    """
    Represents a repository, containing development information such as commits, pull requests, and branches.
    """ # noqa: E501
    name: Annotated[str, Field(strict=True, max_length=255)] = Field(description="The name of this repository. Max length is 255 characters.")
    description: Optional[Annotated[str, Field(strict=True, max_length=1024)]] = Field(default=None, description="Description of this repository. Max length is 1024 characters.")
    fork_of: Optional[Annotated[str, Field(strict=True, max_length=1024)]] = Field(default=None, description="The ID of the repository this repository was forked from, if it's a fork. Max length is 1024 characters.", alias="forkOf")
    url: Annotated[str, Field(strict=True, max_length=2000)] = Field(description="The URL of this repository. Max length is 2000 characters.")
    commits: Optional[Annotated[List[Commit], Field(min_length=0, max_length=400)]] = Field(default=None, description="List of commits to update in this repository. Must not contain duplicate entity IDs. Maximum number of commits is 400")
    branches: Optional[Annotated[List[Branch], Field(min_length=0, max_length=400)]] = Field(default=None, description="List of branches to update in this repository. Must not contain duplicate entity IDs. Maximum number of branches is 400.")
    pull_requests: Optional[Annotated[List[PullRequest], Field(min_length=0, max_length=400)]] = Field(default=None, description="List of pull requests to update in this repository. Must not contain duplicate entity IDs. Maximum number of pull requests is 400", alias="pullRequests")
    avatar: Optional[Annotated[str, Field(strict=True, max_length=2000)]] = Field(default=None, description="The URL of the avatar for this repository. Max length is 2000 characters.")
    avatar_description: Optional[Annotated[str, Field(strict=True, max_length=1024)]] = Field(default=None, description="Description of the avatar for this repository. Max length is 1024 characters.", alias="avatarDescription")
    id: Annotated[str, Field(strict=True, max_length=1024)] = Field(description="The ID of this entity. Will be used for cross entity linking. Must be unique by entity type within a repository, i.e., only one commit can have ID 'X' in repository 'Y'. But adding, e.g., a branch with ID 'X' to repository 'Y' is acceptable. Only alphanumeric characters, and '~.-_', are allowed. Max length is 1024 characters.")
    update_sequence_id: StrictInt = Field(description=" An ID used to apply an ordering to updates for this entity in the case of out-of-order receipt of update requests. This can be any monotonically increasing number. A suggested implementation is to use epoch millis from the provider system, but other alternatives are valid (e.g. a provider could store a counter against each entity and increment that on each update to Jira). Updates for an entity that are received with an updateSqeuenceId lower than what is currently stored will be ignored.", alias="updateSequenceId")
    __properties: ClassVar[List[str]] = ["name", "description", "forkOf", "url", "commits", "branches", "pullRequests", "avatar", "avatarDescription", "id", "updateSequenceId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Repository from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in commits (list)
        _items = []
        if self.commits:
            for _item_commits in self.commits:
                if _item_commits:
                    _items.append(_item_commits.to_dict())
            _dict['commits'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in branches (list)
        _items = []
        if self.branches:
            for _item_branches in self.branches:
                if _item_branches:
                    _items.append(_item_branches.to_dict())
            _dict['branches'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in pull_requests (list)
        _items = []
        if self.pull_requests:
            for _item_pull_requests in self.pull_requests:
                if _item_pull_requests:
                    _items.append(_item_pull_requests.to_dict())
            _dict['pullRequests'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Repository from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "forkOf": obj.get("forkOf"),
            "url": obj.get("url"),
            "commits": [Commit.from_dict(_item) for _item in obj["commits"]] if obj.get("commits") is not None else None,
            "branches": [Branch.from_dict(_item) for _item in obj["branches"]] if obj.get("branches") is not None else None,
            "pullRequests": [PullRequest.from_dict(_item) for _item in obj["pullRequests"]] if obj.get("pullRequests") is not None else None,
            "avatar": obj.get("avatar"),
            "avatarDescription": obj.get("avatarDescription"),
            "id": obj.get("id"),
            "updateSequenceId": obj.get("updateSequenceId")
        })
        return _obj


