# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud_agile.models.entity_error import EntityError
from devopso.clients.jira_cloud_agile.models.error_message import ErrorMessage
from typing import Optional, Set
from typing_extensions import Self

class RepositoryErrors(BaseModel):
    """
    Represents errors related to a particular repository and its entities
    """ # noqa: E501
    error_messages: Optional[List[ErrorMessage]] = Field(default=None, description="Repository errors", alias="errorMessages")
    commits: Optional[List[EntityError]] = Field(default=None, description="Commits errors")
    branches: Optional[List[EntityError]] = Field(default=None, description="Branches errors")
    pull_requests: Optional[List[EntityError]] = Field(default=None, description="Pull requests errors", alias="pullRequests")
    __properties: ClassVar[List[str]] = ["errorMessages", "commits", "branches", "pullRequests"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RepositoryErrors from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in error_messages (list)
        _items = []
        if self.error_messages:
            for _item_error_messages in self.error_messages:
                if _item_error_messages:
                    _items.append(_item_error_messages.to_dict())
            _dict['errorMessages'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in commits (list)
        _items = []
        if self.commits:
            for _item_commits in self.commits:
                if _item_commits:
                    _items.append(_item_commits.to_dict())
            _dict['commits'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in branches (list)
        _items = []
        if self.branches:
            for _item_branches in self.branches:
                if _item_branches:
                    _items.append(_item_branches.to_dict())
            _dict['branches'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in pull_requests (list)
        _items = []
        if self.pull_requests:
            for _item_pull_requests in self.pull_requests:
                if _item_pull_requests:
                    _items.append(_item_pull_requests.to_dict())
            _dict['pullRequests'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RepositoryErrors from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "errorMessages": [ErrorMessage.from_dict(_item) for _item in obj["errorMessages"]] if obj.get("errorMessages") is not None else None,
            "commits": [EntityError.from_dict(_item) for _item in obj["commits"]] if obj.get("commits") is not None else None,
            "branches": [EntityError.from_dict(_item) for _item in obj["branches"]] if obj.get("branches") is not None else None,
            "pullRequests": [EntityError.from_dict(_item) for _item in obj["pullRequests"]] if obj.get("pullRequests") is not None else None
        })
        return _obj


