# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud_agile.models.issue_bean import IssueBean
from devopso.clients.jira_cloud_agile.models.issue_bean_schema_value import IssueBeanSchemaValue
from typing import Optional, Set
from typing_extensions import Self

class SearchResults(BaseModel):
    """
    The result of a JQL search.
    """ # noqa: E501
    expand: Optional[StrictStr] = Field(default=None, description="Expand options that include additional search result details in the response.")
    issues: Optional[List[IssueBean]] = Field(default=None, description="The list of issues found by the search.")
    max_results: Optional[StrictInt] = Field(default=None, description="The maximum number of results that could be on the page.", alias="maxResults")
    names: Optional[Dict[str, StrictStr]] = Field(default=None, description="The ID and name of each field in the search results.")
    var_schema: Optional[Dict[str, IssueBeanSchemaValue]] = Field(default=None, description="The schema describing the field types in the search results.", alias="schema")
    start_at: Optional[StrictInt] = Field(default=None, description="The index of the first item returned on the page.", alias="startAt")
    total: Optional[StrictInt] = Field(default=None, description="The number of results on the page.")
    warning_messages: Optional[List[StrictStr]] = Field(default=None, description="Any warnings related to the JQL query.", alias="warningMessages")
    __properties: ClassVar[List[str]] = ["expand", "issues", "maxResults", "names", "schema", "startAt", "total", "warningMessages"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SearchResults from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "expand",
            "issues",
            "max_results",
            "names",
            "var_schema",
            "start_at",
            "total",
            "warning_messages",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in issues (list)
        _items = []
        if self.issues:
            for _item_issues in self.issues:
                if _item_issues:
                    _items.append(_item_issues.to_dict())
            _dict['issues'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in var_schema (dict)
        _field_dict = {}
        if self.var_schema:
            for _key_var_schema in self.var_schema:
                if self.var_schema[_key_var_schema]:
                    _field_dict[_key_var_schema] = self.var_schema[_key_var_schema].to_dict()
            _dict['schema'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SearchResults from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "expand": obj.get("expand"),
            "issues": [IssueBean.from_dict(_item) for _item in obj["issues"]] if obj.get("issues") is not None else None,
            "maxResults": obj.get("maxResults"),
            "names": obj.get("names"),
            "schema": dict(
                (_k, IssueBeanSchemaValue.from_dict(_v))
                for _k, _v in obj["schema"].items()
            )
            if obj.get("schema") is not None
            else None,
            "startAt": obj.get("startAt"),
            "total": obj.get("total"),
            "warningMessages": obj.get("warningMessages")
        })
        return _obj


