# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud_agile.models.issue_bean_transitions_inner_to_all_of_scope import IssueBeanTransitionsInnerToAllOfScope
from devopso.clients.jira_cloud_agile.models.issue_bean_transitions_inner_to_all_of_status_category import IssueBeanTransitionsInnerToAllOfStatusCategory
from typing import Optional, Set
from typing_extensions import Self

class StatusDetails(BaseModel):
    """
    A status.
    """ # noqa: E501
    description: Optional[StrictStr] = Field(default=None, description="The description of the status.")
    icon_url: Optional[StrictStr] = Field(default=None, description="The URL of the icon used to represent the status.", alias="iconUrl")
    id: Optional[StrictStr] = Field(default=None, description="The ID of the status.")
    name: Optional[StrictStr] = Field(default=None, description="The name of the status.")
    scope: Optional[IssueBeanTransitionsInnerToAllOfScope] = None
    var_self: Optional[StrictStr] = Field(default=None, description="The URL of the status.", alias="self")
    status_category: Optional[IssueBeanTransitionsInnerToAllOfStatusCategory] = Field(default=None, alias="statusCategory")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["description", "iconUrl", "id", "name", "scope", "self", "statusCategory"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StatusDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "description",
            "icon_url",
            "id",
            "name",
            "var_self",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of scope
        if self.scope:
            _dict['scope'] = self.scope.to_dict()
        # override the default output from pydantic by calling `to_dict()` of status_category
        if self.status_category:
            _dict['statusCategory'] = self.status_category.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StatusDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "iconUrl": obj.get("iconUrl"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "scope": IssueBeanTransitionsInnerToAllOfScope.from_dict(obj["scope"]) if obj.get("scope") is not None else None,
            "self": obj.get("self"),
            "statusCategory": IssueBeanTransitionsInnerToAllOfStatusCategory.from_dict(obj["statusCategory"]) if obj.get("statusCategory") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


