# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud_agile.models.entity_ids import EntityIds
from devopso.clients.jira_cloud_agile.models.issue_id_or_keys_association import IssueIdOrKeysAssociation
from devopso.clients.jira_cloud_agile.models.repository_errors import RepositoryErrors
from typing import Optional, Set
from typing_extensions import Self

class StoreDevinfoResult(BaseModel):
    """
    The result of a successful store development information request
    """ # noqa: E501
    accepted_devinfo_entities: Optional[Dict[str, EntityIds]] = Field(default=None, description="The IDs of devinfo entities that have been accepted for submission grouped by their repository IDs. Note that a devinfo entity that isn't updated due to it's updateSequenceId being out of order is not considered a failed submission.", alias="acceptedDevinfoEntities")
    failed_devinfo_entities: Optional[Dict[str, RepositoryErrors]] = Field(default=None, description="IDs of devinfo entities that have not been accepted for submission and caused error descriptions, usually due to a problem with the request data. The entities (if present) will be grouped by their repository id and type. Entity IDs are listed with errors associated with that devinfo entity that have prevented it being submitted. ", alias="failedDevinfoEntities")
    unknown_issue_keys: Optional[List[StrictStr]] = Field(default=None, description="Issue keys that are not known on this Jira instance (if any). These may be invalid keys (e.g. `UTF-8` is sometimes incorrectly identified as a Jira issue key), or they may be for projects that no longer exist. If a devinfo entity has been associated with issue keys other than those in this array it will still be stored against those valid keys. ", alias="unknownIssueKeys")
    unknown_associations: Optional[List[IssueIdOrKeysAssociation]] = Field(default=None, description="Associations that are not known on this Jira instance (if any).  These may be invalid keys (e.g. `UTF-8` is sometimes incorrectly identified as a Jira issue key), or they may be for projects that no longer exist.  If a development information entity has been associated with any other association other than those in this array it will still be stored against those valid associations. If a development information entity was only associated with the associations in this array, it is deemed to be invalid and it won't be persisted. ", alias="unknownAssociations")
    __properties: ClassVar[List[str]] = ["acceptedDevinfoEntities", "failedDevinfoEntities", "unknownIssueKeys", "unknownAssociations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StoreDevinfoResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in accepted_devinfo_entities (dict)
        _field_dict = {}
        if self.accepted_devinfo_entities:
            for _key_accepted_devinfo_entities in self.accepted_devinfo_entities:
                if self.accepted_devinfo_entities[_key_accepted_devinfo_entities]:
                    _field_dict[_key_accepted_devinfo_entities] = self.accepted_devinfo_entities[_key_accepted_devinfo_entities].to_dict()
            _dict['acceptedDevinfoEntities'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in failed_devinfo_entities (dict)
        _field_dict = {}
        if self.failed_devinfo_entities:
            for _key_failed_devinfo_entities in self.failed_devinfo_entities:
                if self.failed_devinfo_entities[_key_failed_devinfo_entities]:
                    _field_dict[_key_failed_devinfo_entities] = self.failed_devinfo_entities[_key_failed_devinfo_entities].to_dict()
            _dict['failedDevinfoEntities'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in unknown_associations (list)
        _items = []
        if self.unknown_associations:
            for _item_unknown_associations in self.unknown_associations:
                if _item_unknown_associations:
                    _items.append(_item_unknown_associations.to_dict())
            _dict['unknownAssociations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StoreDevinfoResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "acceptedDevinfoEntities": dict(
                (_k, EntityIds.from_dict(_v))
                for _k, _v in obj["acceptedDevinfoEntities"].items()
            )
            if obj.get("acceptedDevinfoEntities") is not None
            else None,
            "failedDevinfoEntities": dict(
                (_k, RepositoryErrors.from_dict(_v))
                for _k, _v in obj["failedDevinfoEntities"].items()
            )
            if obj.get("failedDevinfoEntities") is not None
            else None,
            "unknownIssueKeys": obj.get("unknownIssueKeys"),
            "unknownAssociations": [IssueIdOrKeysAssociation.from_dict(_item) for _item in obj["unknownAssociations"]] if obj.get("unknownAssociations") is not None else None
        })
        return _obj


