# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud_agile.models.build_key import BuildKey
from devopso.clients.jira_cloud_agile.models.issue_id_or_keys_association import IssueIdOrKeysAssociation
from devopso.clients.jira_cloud_agile.models.rejected_build import RejectedBuild
from typing import Optional, Set
from typing_extensions import Self

class SubmitBuildsResponse(BaseModel):
    """
    The result of a successful `submitBuilds` request. 
    """ # noqa: E501
    accepted_builds: Optional[List[BuildKey]] = Field(default=None, description="The keys of builds that have been accepted for submission. A build key is a composite key that consists of `pipelineId` and `buildNumber`.  A build may be rejected if it was only associated with unknown issue keys, or if the submitted data for that build does not match the required schema.  Note that a build that isn't updated due to it's `updateSequenceNumber` being out of order is not considered a failed submission. ", alias="acceptedBuilds")
    rejected_builds: Optional[List[RejectedBuild]] = Field(default=None, description="Details of builds that have not been accepted for submission.  A build may be rejected if it was only associated with unknown issue keys, or if the submitted data for the build does not match the required schema. ", alias="rejectedBuilds")
    unknown_issue_keys: Optional[List[Annotated[str, Field(strict=True)]]] = Field(default=None, description="Issue keys that are not known on this Jira instance (if any).  These may be invalid keys (e.g. `UTF-8` is sometimes incorrectly identified as a Jira issue key), or they may be for projects that no longer exist.  If a build has been associated with issue keys other than those in this array it will still be stored against those valid keys. If a build was only associated with issue keys deemed to be invalid it won't be persisted. ", alias="unknownIssueKeys")
    unknown_associations: Optional[List[IssueIdOrKeysAssociation]] = Field(default=None, description="Associations that are not known on this Jira instance (if any).  These may be invalid keys (e.g. `UTF-8` is sometimes incorrectly identified as a Jira issue key), or they may be for projects that no longer exist.  If a build has been associated with any other association other than those in this array it will still be stored against those valid associations. If a build was only associated with the associations in this array, it is deemed to be invalid and it won't be persisted. ", alias="unknownAssociations")
    __properties: ClassVar[List[str]] = ["acceptedBuilds", "rejectedBuilds", "unknownIssueKeys", "unknownAssociations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SubmitBuildsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in accepted_builds (list)
        _items = []
        if self.accepted_builds:
            for _item_accepted_builds in self.accepted_builds:
                if _item_accepted_builds:
                    _items.append(_item_accepted_builds.to_dict())
            _dict['acceptedBuilds'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in rejected_builds (list)
        _items = []
        if self.rejected_builds:
            for _item_rejected_builds in self.rejected_builds:
                if _item_rejected_builds:
                    _items.append(_item_rejected_builds.to_dict())
            _dict['rejectedBuilds'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in unknown_associations (list)
        _items = []
        if self.unknown_associations:
            for _item_unknown_associations in self.unknown_associations:
                if _item_unknown_associations:
                    _items.append(_item_unknown_associations.to_dict())
            _dict['unknownAssociations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SubmitBuildsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "acceptedBuilds": [BuildKey.from_dict(_item) for _item in obj["acceptedBuilds"]] if obj.get("acceptedBuilds") is not None else None,
            "rejectedBuilds": [RejectedBuild.from_dict(_item) for _item in obj["rejectedBuilds"]] if obj.get("rejectedBuilds") is not None else None,
            "unknownIssueKeys": obj.get("unknownIssueKeys"),
            "unknownAssociations": [IssueIdOrKeysAssociation.from_dict(_item) for _item in obj["unknownAssociations"]] if obj.get("unknownAssociations") is not None else None
        })
        return _obj


