# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud_agile.models.deployment_data import DeploymentData
from devopso.clients.jira_cloud_agile.models.provider_metadata2 import ProviderMetadata2
from typing import Optional, Set
from typing_extensions import Self

class SubmitDeploymentRequest(BaseModel):
    """
    The payload used to submit (update / insert) deployment data.
    """ # noqa: E501
    properties: Optional[Dict[str, Annotated[str, Field(strict=True, max_length=255)]]] = Field(default=None, description="Properties assigned to deployment data that can then be used for delete / query operations.  Examples might be an account or user ID that can then be used to clean up data if an account is removed from the Provider system.  Properties are supplied as key/value pairs, and a maximum of 5 properties can be supplied, keys cannot contain ':' or start with '_'. ")
    deployments: Annotated[List[DeploymentData], Field(min_length=1, max_length=100)] = Field(description="A list of deployments to submit to Jira.  Each deployment may be associated with one or more Jira issue keys, and will be associated with any properties included in this request. ")
    provider_metadata: Optional[ProviderMetadata2] = Field(default=None, alias="providerMetadata")
    __properties: ClassVar[List[str]] = ["properties", "deployments", "providerMetadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SubmitDeploymentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in deployments (list)
        _items = []
        if self.deployments:
            for _item_deployments in self.deployments:
                if _item_deployments:
                    _items.append(_item_deployments.to_dict())
            _dict['deployments'] = _items
        # override the default output from pydantic by calling `to_dict()` of provider_metadata
        if self.provider_metadata:
            _dict['providerMetadata'] = self.provider_metadata.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SubmitDeploymentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "properties": obj.get("properties"),
            "deployments": [DeploymentData.from_dict(_item) for _item in obj["deployments"]] if obj.get("deployments") is not None else None,
            "providerMetadata": ProviderMetadata2.from_dict(obj["providerMetadata"]) if obj.get("providerMetadata") is not None else None
        })
        return _obj


