# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud_agile.models.submit_deployments_response1_details_inner import SubmitDeploymentsResponse1DetailsInner
from typing import Optional, Set
from typing_extensions import Self

class SubmitDeploymentsResponse1(BaseModel):
    """
    The current gating status for the given Deployment. 
    """ # noqa: E501
    deployment_sequence_number: Optional[StrictInt] = Field(default=None, description="This is the identifier for the Deployment. ", alias="deploymentSequenceNumber")
    pipeline_id: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="The ID of the Deployment's pipeline. ", alias="pipelineId")
    environment_id: Optional[StrictStr] = Field(default=None, description="The ID of the Deployment's environment. ", alias="environmentId")
    updated_timestamp: Optional[datetime] = Field(default=None, description="Time the deployment gating status was updated. ", alias="updatedTimestamp")
    gating_status: Optional[StrictStr] = Field(default=None, description="The gating status ", alias="gatingStatus")
    details: Optional[List[SubmitDeploymentsResponse1DetailsInner]] = None
    __properties: ClassVar[List[str]] = ["deploymentSequenceNumber", "pipelineId", "environmentId", "updatedTimestamp", "gatingStatus", "details"]

    @field_validator('gating_status')
    def gating_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['allowed', 'prevented', 'awaiting', 'invalid']):
            raise ValueError("must be one of enum values ('allowed', 'prevented', 'awaiting', 'invalid')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SubmitDeploymentsResponse1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in details (list)
        _items = []
        if self.details:
            for _item_details in self.details:
                if _item_details:
                    _items.append(_item_details.to_dict())
            _dict['details'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SubmitDeploymentsResponse1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "deploymentSequenceNumber": obj.get("deploymentSequenceNumber"),
            "pipelineId": obj.get("pipelineId"),
            "environmentId": obj.get("environmentId"),
            "updatedTimestamp": obj.get("updatedTimestamp"),
            "gatingStatus": obj.get("gatingStatus"),
            "details": [SubmitDeploymentsResponse1DetailsInner.from_dict(_item) for _item in obj["details"]] if obj.get("details") is not None else None
        })
        return _obj


