# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class SubmitDeploymentsResponse1DetailsInner(BaseModel):
    """
    Details related to the gating status 
    """ # noqa: E501
    type: StrictStr = Field(description="The type of the gating status details. ")
    issue_key: Annotated[str, Field(strict=True)] = Field(description="An issue key that references an issue in Jira. ", alias="issueKey")
    issue_link: Annotated[str, Field(strict=True, max_length=2000)] = Field(description="A full HTTPS link to the Jira issue for the change request gating this Deployment. This field is provided if the details type is issue. ", alias="issueLink")
    __properties: ClassVar[List[str]] = ["type", "issueKey", "issueLink"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['issue']):
            raise ValueError("must be one of enum values ('issue')")
        return value

    @field_validator('issue_key')
    def issue_key_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^\w{1,255}-\d{1,255}$", value):
            raise ValueError(r"must validate the regular expression /^\w{1,255}-\d{1,255}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SubmitDeploymentsResponse1DetailsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SubmitDeploymentsResponse1DetailsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "issueKey": obj.get("issueKey"),
            "issueLink": obj.get("issueLink")
        })
        return _obj


