# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud_agile.models.error_message1 import ErrorMessage1
from typing import Optional, Set
from typing_extensions import Self

class SubmitDevopsComponentsResponse(BaseModel):
    """
    The result of a successful submitDevopsComponents request. 
    """ # noqa: E501
    accepted_components: Optional[List[StrictStr]] = Field(default=None, description="The IDs of Components that have been accepted for submission.  A Component may be rejected if it was only associated with unknown project keys.  Note that a Component that isn't updated due to it's updateSequenceNumber being out of order is not considered a failed submission. ", alias="acceptedComponents")
    failed_components: Optional[Dict[str, List[ErrorMessage1]]] = Field(default=None, description="Details of Components that have not been accepted for submission, usually due to a problem with the request data.  The object (if present) will be keyed by Component ID and include any errors associated with that Component that have prevented it being submitted. ", alias="failedComponents")
    unknown_project_keys: Optional[List[Annotated[str, Field(strict=True)]]] = Field(default=None, description="Project keys that are not known on this Jira instance (if any).  These may be invalid keys (e.g. `UTF` is sometimes incorrectly identified as a Jira project key), or they may be for projects that no longer exist.  If a Component has been associated with project keys other than those in this array it will still be stored against those valid keys. If a Component was only associated with project keys deemed to be invalid it won't be persisted. ", alias="unknownProjectKeys")
    __properties: ClassVar[List[str]] = ["acceptedComponents", "failedComponents", "unknownProjectKeys"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SubmitDevopsComponentsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in failed_components (dict of array)
        _field_dict_of_array = {}
        if self.failed_components:
            for _key_failed_components in self.failed_components:
                if self.failed_components[_key_failed_components] is not None:
                    _field_dict_of_array[_key_failed_components] = [
                        _item.to_dict() for _item in self.failed_components[_key_failed_components]
                    ]
            _dict['failedComponents'] = _field_dict_of_array
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SubmitDevopsComponentsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "acceptedComponents": obj.get("acceptedComponents"),
            "failedComponents": dict(
                (_k,
                        [ErrorMessage1.from_dict(_item) for _item in _v]
                        if _v is not None
                        else None
                )
                for _k, _v in obj.get("failedComponents", {}).items()
            ),
            "unknownProjectKeys": obj.get("unknownProjectKeys")
        })
        return _obj


