# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from devopso.clients.jira_cloud_agile.models.error_message1 import ErrorMessage1
from devopso.clients.jira_cloud_agile.models.vulnerability_details_add_associations_inner import VulnerabilityDetailsAddAssociationsInner
from typing import Optional, Set
from typing_extensions import Self

class SubmitVulnerabilitiesResponse(BaseModel):
    """
    The result of a successful submitVulnerabilities request. 
    """ # noqa: E501
    accepted_vulnerabilities: Optional[List[StrictStr]] = Field(default=None, description="The IDs of Vulnerabilities that have been accepted for submission.  A Vulnerability may be rejected if it was only associated with unknown project keys.  Note that a Vulnerability that isn't updated due to it's updateSequenceNumber being out of order is not considered a failed submission. ", alias="acceptedVulnerabilities")
    failed_vulnerabilities: Optional[Dict[str, List[ErrorMessage1]]] = Field(default=None, description="Details of Vulnerabilities that have not been accepted for submission, usually due to a problem with the request data.  The object (if present) will be keyed by Vulnerability ID and include any errors associated with that Vulnerability that have prevented it being submitted. ", alias="failedVulnerabilities")
    unknown_associations: Optional[List[VulnerabilityDetailsAddAssociationsInner]] = Field(default=None, description="Associations (e.g. Service IDs) that are not known on this Jira instance (if any).  If a Vulnerability has been associated with any other association other than those in this array it will still be stored against those valid associations. If a Vulnerability was only associated with the associations in this array, it is deemed to be invalid and it won't be persisted. ", alias="unknownAssociations")
    __properties: ClassVar[List[str]] = ["acceptedVulnerabilities", "failedVulnerabilities", "unknownAssociations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SubmitVulnerabilitiesResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in failed_vulnerabilities (dict of array)
        _field_dict_of_array = {}
        if self.failed_vulnerabilities:
            for _key_failed_vulnerabilities in self.failed_vulnerabilities:
                if self.failed_vulnerabilities[_key_failed_vulnerabilities] is not None:
                    _field_dict_of_array[_key_failed_vulnerabilities] = [
                        _item.to_dict() for _item in self.failed_vulnerabilities[_key_failed_vulnerabilities]
                    ]
            _dict['failedVulnerabilities'] = _field_dict_of_array
        # override the default output from pydantic by calling `to_dict()` of each item in unknown_associations (list)
        _items = []
        if self.unknown_associations:
            for _item_unknown_associations in self.unknown_associations:
                if _item_unknown_associations:
                    _items.append(_item_unknown_associations.to_dict())
            _dict['unknownAssociations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SubmitVulnerabilitiesResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "acceptedVulnerabilities": obj.get("acceptedVulnerabilities"),
            "failedVulnerabilities": dict(
                (_k,
                        [ErrorMessage1.from_dict(_item) for _item in _v]
                        if _v is not None
                        else None
                )
                for _k, _v in obj.get("failedVulnerabilities", {}).items()
            ),
            "unknownAssociations": [VulnerabilityDetailsAddAssociationsInner.from_dict(_item) for _item in obj["unknownAssociations"]] if obj.get("unknownAssociations") is not None else None
        })
        return _obj


