# coding: utf-8

"""
    Jira Software Cloud API

    Jira Software Cloud REST API documentation

    The version of the OpenAPI document: 1001.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from devopso.clients.jira_cloud_agile.models.identifier import Identifier
from devopso.clients.jira_cloud_agile.models.vulnerability_additional_info import VulnerabilityAdditionalInfo
from devopso.clients.jira_cloud_agile.models.vulnerability_details_add_associations_inner import VulnerabilityDetailsAddAssociationsInner
from devopso.clients.jira_cloud_agile.models.vulnerability_severity import VulnerabilitySeverity
from typing import Optional, Set
from typing_extensions import Self

class VulnerabilityDetails(BaseModel):
    """
    Data related to a specific vulnerability in a specific workspace that the vulnerability is present in. Must specify at least one association. 
    """ # noqa: E501
    schema_version: StrictStr = Field(description="The VulnerabilityData schema version used for this vulnerability data.  Placeholder to support potential schema changes in the future. ", alias="schemaVersion")
    id: Annotated[str, Field(strict=True, max_length=255)] = Field(description="The identifier for the Vulnerability. Must be unique for a given Provider. ")
    update_sequence_number: StrictInt = Field(description="An ID used to apply an ordering to updates for this Vulnerability in the case of out-of-order receipt of update requests.  This can be any monotonically increasing number. A suggested implementation is to use epoch millis from the Provider system, but other alternatives are valid (e.g. a Provider could store a counter against each Vulnerability and increment that on each update to Jira).  Updates for a Vulnerability that are received with an updateSequenceId lower than what is currently stored will be ignored. ", alias="updateSequenceNumber")
    container_id: Annotated[str, Field(strict=True, max_length=255)] = Field(description="The identifier of the Container where this Vulnerability was found. Must be unique for a given Provider. This must follow this regex pattern: `[a-zA-Z0-9\\\\-_.~@:{}=]+(/[a-zA-Z0-9\\\\-_.~@:{}=]+)*` ", alias="containerId")
    display_name: Annotated[str, Field(strict=True, max_length=255)] = Field(description="The human-readable name for the Vulnerability. Will be shown in the UI.  If not provided, will use the ID for display. ", alias="displayName")
    description: Annotated[str, Field(strict=True, max_length=5000)] = Field(description="A description of the issue in markdown format that will be shown in the UI and used when creating Jira Issues. HTML tags are not supported in the markdown format. For creating a new line `\\n` can be used. Read more about the accepted markdown transformations [here](https://atlaskit.atlassian.com/packages/editor/editor-markdown-transformer). ")
    url: Annotated[str, Field(strict=True, max_length=2000)] = Field(description="A URL users can use to link to a summary view of this vulnerability, if appropriate.  This could be any location that makes sense in the Provider system (e.g. if the summary information comes from a specific project, it might make sense to link the user to the vulnerability in that project). ")
    type: StrictStr = Field(description="The type of Vulnerability detected.")
    introduced_date: datetime = Field(description="The timestamp to present to the user that shows when the Vulnerability was introduced.  Expected format is an RFC3339 formatted string. ", alias="introducedDate")
    last_updated: datetime = Field(description="The last-updated timestamp to present to the user the last time the Vulnerability was updated.  Expected format is an RFC3339 formatted string. ", alias="lastUpdated")
    severity: VulnerabilitySeverity
    identifiers: Optional[Annotated[List[Identifier], Field(min_length=1, max_length=100)]] = Field(default=None, description="The identifying information for the Vulnerability. ")
    status: StrictStr = Field(description="The current status of the Vulnerability. ")
    additional_info: Optional[VulnerabilityAdditionalInfo] = Field(default=None, alias="additionalInfo")
    add_associations: Optional[Annotated[List[VulnerabilityDetailsAddAssociationsInner], Field(min_length=0, max_length=1)]] = Field(default=None, description="The associations (e.g. Jira issue) to add in addition to the currently stored associations of the Security Vulnerability. ", alias="addAssociations")
    remove_associations: Optional[Annotated[List[VulnerabilityDetailsAddAssociationsInner], Field(min_length=0, max_length=1)]] = Field(default=None, description="The associations (e.g. Jira issue) to remove from currently stored associations of the Security Vulnerability. ", alias="removeAssociations")
    associations_last_updated: Optional[datetime] = Field(default=None, description="An ISO-8601 Date-time string representing the last time the provider updated associations on this entity.  Expected format is an RFC3339 formatted string. ", alias="associationsLastUpdated")
    associations_update_sequence_number: Optional[StrictInt] = Field(default=None, description="A sequence number to compare when writing entity associations to the database.  This can be any monotonically increasing number. A highly recommended implementation is to use epoch millis.  This is an optional field. If it is not provided it will default to being equal to the corresponding entity's `updateSequenceNumber`.  Associations are written following a LastWriteWins strategy, association that are received with an associationsUpdateSequenceNumber lower than what is currently stored will be ignored. ", alias="associationsUpdateSequenceNumber")
    __properties: ClassVar[List[str]] = ["schemaVersion", "id", "updateSequenceNumber", "containerId", "displayName", "description", "url", "type", "introducedDate", "lastUpdated", "severity", "identifiers", "status", "additionalInfo", "addAssociations", "removeAssociations", "associationsLastUpdated", "associationsUpdateSequenceNumber"]

    @field_validator('schema_version')
    def schema_version_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['1.0']):
            raise ValueError("must be one of enum values ('1.0')")
        return value

    @field_validator('container_id')
    def container_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"[a-zA-Z0-9\-_.~@:{}=]+(\/[a-zA-Z0-9\-_.~@:{}=]+)*", value):
            raise ValueError(r"must validate the regular expression /[a-zA-Z0-9\-_.~@:{}=]+(\/[a-zA-Z0-9\-_.~@:{}=]+)*/")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['sca', 'sast', 'dast', 'unknown']):
            raise ValueError("must be one of enum values ('sca', 'sast', 'dast', 'unknown')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['open', 'closed', 'ignored', 'unknown']):
            raise ValueError("must be one of enum values ('open', 'closed', 'ignored', 'unknown')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VulnerabilityDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of severity
        if self.severity:
            _dict['severity'] = self.severity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in identifiers (list)
        _items = []
        if self.identifiers:
            for _item_identifiers in self.identifiers:
                if _item_identifiers:
                    _items.append(_item_identifiers.to_dict())
            _dict['identifiers'] = _items
        # override the default output from pydantic by calling `to_dict()` of additional_info
        if self.additional_info:
            _dict['additionalInfo'] = self.additional_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in add_associations (list)
        _items = []
        if self.add_associations:
            for _item_add_associations in self.add_associations:
                if _item_add_associations:
                    _items.append(_item_add_associations.to_dict())
            _dict['addAssociations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in remove_associations (list)
        _items = []
        if self.remove_associations:
            for _item_remove_associations in self.remove_associations:
                if _item_remove_associations:
                    _items.append(_item_remove_associations.to_dict())
            _dict['removeAssociations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VulnerabilityDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "schemaVersion": obj.get("schemaVersion") if obj.get("schemaVersion") is not None else '1.0',
            "id": obj.get("id"),
            "updateSequenceNumber": obj.get("updateSequenceNumber"),
            "containerId": obj.get("containerId"),
            "displayName": obj.get("displayName"),
            "description": obj.get("description"),
            "url": obj.get("url"),
            "type": obj.get("type"),
            "introducedDate": obj.get("introducedDate"),
            "lastUpdated": obj.get("lastUpdated"),
            "severity": VulnerabilitySeverity.from_dict(obj["severity"]) if obj.get("severity") is not None else None,
            "identifiers": [Identifier.from_dict(_item) for _item in obj["identifiers"]] if obj.get("identifiers") is not None else None,
            "status": obj.get("status"),
            "additionalInfo": VulnerabilityAdditionalInfo.from_dict(obj["additionalInfo"]) if obj.get("additionalInfo") is not None else None,
            "addAssociations": [VulnerabilityDetailsAddAssociationsInner.from_dict(_item) for _item in obj["addAssociations"]] if obj.get("addAssociations") is not None else None,
            "removeAssociations": [VulnerabilityDetailsAddAssociationsInner.from_dict(_item) for _item in obj["removeAssociations"]] if obj.get("removeAssociations") is not None else None,
            "associationsLastUpdated": obj.get("associationsLastUpdated"),
            "associationsUpdateSequenceNumber": obj.get("associationsUpdateSequenceNumber")
        })
        return _obj


