from rest_requests.json import JSON, diff


def test_diff():

    jsons: list[JSON] = [
        {
            "a": 1,
            "b": {"c": 2, "d": 3},
            "e": [1, 2, 3],
            "f": {},
            "g": {"a": 0},
            "h": [1, 2],
            "i": 1,
        },
        {
            "a": 1,
            "b": {"c": 2, "d": 4},
            "e": [1, 2, 4],
            "f": None,
            "g": {"b": 1},
            "h": [1],
            "i": 1,
        },
        {
            "a": 2,
            "b": {"c": 3, "d": 3},
            "e": [1, 3, 3],
            "f": True,
            "g": {},
            "h": [],
            "i": 1.0,
        },
    ]

    expected = {
        ("a",): [1, 1, 2],
        ("b", "c"): [2, 2, 3],
        ("b", "d"): [3, 4, 3],
        ("e", 1): [2, 2, 3],
        ("e", 2): [3, 4, 3],
        ("f",): [{}, None, True],
        ("g",): [{"a": 0}, {"b": 1}, {}],
        ("h",): [[1, 2], [1], []],
        ("i",): [1, 1, 1.0],
    }

    assert diff(jsons) == expected
