# Copyright (c) Microsoft Corporation.
# Licensed under the MIT License.
"""In-memory intermediate representation for ONNX graphs."""

__all__ = [
    # Modules
    "serde",
    "traversal",
    "convenience",
    "external_data",
    "tape",
    # IR classes
    "Tensor",
    "ExternalTensor",
    "StringTensor",
    "LazyTensor",
    "SymbolicDim",
    "Shape",
    "TensorType",
    "OptionalType",
    "SequenceType",
    "SparseTensorType",
    "TypeAndShape",
    "Value",
    "Attr",
    "RefAttr",
    "Node",
    "Function",
    "Graph",
    "GraphView",
    "Model",
    # Constructors
    "AttrFloat32",
    "AttrFloat32s",
    "AttrGraph",
    "AttrGraphs",
    "AttrInt64",
    "AttrInt64s",
    "AttrSparseTensor",
    "AttrSparseTensors",
    "AttrString",
    "AttrStrings",
    "AttrTensor",
    "AttrTensors",
    "AttrTypeProto",
    "AttrTypeProtos",
    "Input",
    # Protocols
    "ArrayCompatible",
    "DLPackCompatible",
    "TensorProtocol",
    "ValueProtocol",
    "ModelProtocol",
    "NodeProtocol",
    "GraphProtocol",
    "GraphViewProtocol",
    "AttributeProtocol",
    "ReferenceAttributeProtocol",
    "SparseTensorProtocol",
    "SymbolicDimProtocol",
    "ShapeProtocol",
    "TypeProtocol",
    "MapTypeProtocol",
    "FunctionProtocol",
    # Enums
    "AttributeType",
    "DataType",
    # Types
    "OperatorIdentifier",
    # Protobuf compatible types
    "TensorProtoTensor",
    # Conversion functions
    "from_proto",
    "from_onnx_text",
    "to_proto",
    # Convenience constructors
    "tensor",
    "node",
    # Pass infrastructure
    "passes",
    # IO
    "load",
    "save",
]

from onnx_ir import (
    ArrayCompatible,
    Attr,
    AttrFloat32,
    AttrFloat32s,
    AttrGraph,
    AttrGraphs,
    AttributeProtocol,
    AttributeType,
    AttrInt64,
    AttrInt64s,
    AttrSparseTensor,
    AttrSparseTensors,
    AttrString,
    AttrStrings,
    AttrTensor,
    AttrTensors,
    AttrTypeProto,
    AttrTypeProtos,
    DataType,
    DLPackCompatible,
    ExternalTensor,
    Function,
    FunctionProtocol,
    Graph,
    GraphProtocol,
    GraphView,
    GraphViewProtocol,
    Input,
    LazyTensor,
    MapTypeProtocol,
    Model,
    ModelProtocol,
    Node,
    NodeProtocol,
    OperatorIdentifier,
    OptionalType,
    RefAttr,
    ReferenceAttributeProtocol,
    SequenceType,
    Shape,
    ShapeProtocol,
    SparseTensorProtocol,
    SparseTensorType,
    StringTensor,
    SymbolicDim,
    SymbolicDimProtocol,
    Tensor,
    TensorProtocol,
    TensorProtoTensor,
    TensorType,
    TypeAndShape,
    TypeProtocol,
    Value,
    ValueProtocol,
    convenience,
    external_data,
    from_onnx_text,
    from_proto,
    load,
    node,
    passes,
    save,
    serde,
    tape,
    tensor,
    to_proto,
    traversal,
)
