# Standard library imports

# Third party imports
import opengeode as og
import opengeode_io as og_io
import opengeode_inspector as og_inspector
import opengeode_geosciences as og_gs
import opengeode_geosciencesio as og_gs_io
import geode_viewables as g_v

# Local application imports

mesh = "mesh"
model = "model"

points = "points"
edges = "edges"
polygons = "polygons"
polyhedrons = "polyhedrons"


def geode_objects_dict():
    return {
        "BRep": {
            "class": og.BRep,
            "input_factory": og.BRepInputFactory,
            "output_factory": og.BRepOutputFactory,
            "missing_files": og.check_brep_missing_files,
            "is_loadable": og.is_brep_loadable,
            "load": og.load_brep,
            "is_saveable": og.is_brep_saveable,
            "save": og.save_brep,
            "builder": og.BRepBuilder,
            "crs": {
                "assign": og_gs.assign_brep_geographic_coordinate_system_info,
                "convert": og_gs.convert_brep_coordinate_reference_system,
                "create": og.create_brep_coordinate_system,
            },
            "object_type": model,
            "is_3D": True,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_brep,
            "save_light_viewable": g_v.save_light_viewable_brep,
            "inspector": og_inspector.inspect_brep,
        },
        "CrossSection": {
            "parent": "Section",
            "class": og_gs.CrossSection,
            "input_factory": og_gs.CrossSectionInputFactory,
            "output_factory": og_gs.CrossSectionOutputFactory,
            "missing_files": og_gs.check_cross_section_missing_files,
            "is_loadable": og_gs.is_cross_section_loadable,
            "load": og_gs.load_cross_section,
            "is_saveable": og_gs.is_cross_section_saveable,
            "save": og_gs.save_cross_section,
            "builder": og_gs.CrossSectionBuilder,
            "crs": {
                "assign": og_gs.assign_section_geographic_coordinate_system_info,
                "convert": og_gs.convert_section_coordinate_reference_system,
                "create": og.create_section_coordinate_system,
            },
            "object_type": model,
            "is_3D": False,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_cross_section,
            "save_light_viewable": g_v.save_light_viewable_cross_section,
            "inspector": og_inspector.inspect_section,
        },
        "EdgedCurve2D": {
            "class": og.EdgedCurve2D,
            "input_factory": og.EdgedCurveInputFactory2D,
            "output_factory": og.EdgedCurveOutputFactory2D,
            "missing_files": og.check_edged_curve_missing_files2D,
            "is_loadable": og.is_edged_curve_loadable2D,
            "load": og.load_edged_curve2D,
            "is_saveable": og.is_edged_curve_saveable2D,
            "save": og.save_edged_curve2D,
            "builder": og.EdgedCurveBuilder2D.create,
            "crs": {
                "assign": og_gs.assign_edged_curve_geographic_coordinate_system_info2D,
                "convert": og_gs.convert_edged_curve_coordinate_reference_system2D,
                "create": og.create_edged_curve_coordinate_system2D,
            },
            "object_type": mesh,
            "elements": [points, edges],
            "is_3D": False,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_edged_curve2D,
            "save_light_viewable": g_v.save_light_viewable_edged_curve2D,
            "inspector": og_inspector.inspect_edged_curve2D,
        },
        "EdgedCurve3D": {
            "class": og.EdgedCurve3D,
            "input_factory": og.EdgedCurveInputFactory3D,
            "output_factory": og.EdgedCurveOutputFactory3D,
            "missing_files": og.check_edged_curve_missing_files3D,
            "is_loadable": og.is_edged_curve_loadable3D,
            "load": og.load_edged_curve3D,
            "is_saveable": og.is_edged_curve_saveable3D,
            "save": og.save_edged_curve3D,
            "builder": og.EdgedCurveBuilder3D.create,
            "crs": {
                "assign": og_gs.assign_edged_curve_geographic_coordinate_system_info3D,
                "convert": og_gs.convert_edged_curve_coordinate_reference_system3D,
                "create": og.create_edged_curve_coordinate_system3D,
            },
            "object_type": mesh,
            "elements": [points, edges],
            "is_3D": True,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_edged_curve3D,
            "save_light_viewable": g_v.save_light_viewable_edged_curve3D,
            "inspector": og_inspector.inspect_edged_curve3D,
        },
        "Graph": {
            "class": og.Graph,
            "input_factory": og.GraphInputFactory,
            "output_factory": og.GraphOutputFactory,
            "missing_files": og.check_graph_missing_files,
            "is_loadable": og.is_graph_loadable,
            "load": og.load_graph,
            "is_saveable": og.is_graph_saveable,
            "save": og.save_graph,
            "builder": og.GraphBuilder.create,
            "object_type": mesh,
            "is_3D": False,
            "is_viewable": False,
        },
        "HybridSolid3D": {
            "class": og.HybridSolid3D,
            "input_factory": og.HybridSolidInputFactory3D,
            "output_factory": og.HybridSolidOutputFactory3D,
            "missing_files": og.check_hybrid_solid_missing_files3D,
            "is_loadable": og.is_hybrid_solid_loadable3D,
            "load": og.load_hybrid_solid3D,
            "is_saveable": og.is_hybrid_solid_saveable3D,
            "save": og.save_hybrid_solid3D,
            "builder": og.HybridSolidBuilder3D.create,
            "crs": {
                "assign": og_gs.assign_solid_mesh_geographic_coordinate_system_info3D,
                "convert": og_gs.convert_solid_mesh_coordinate_reference_system3D,
                "create": og.create_solid_mesh_coordinate_system3D,
            },
            "object_type": mesh,
            "elements": [points, polyhedrons],
            "is_3D": True,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_hybrid_solid3D,
            "save_light_viewable": g_v.save_light_viewable_hybrid_solid3D,
            "inspector": og_inspector.inspect_solid3D,
        },
        "ImplicitCrossSection": {
            "parent": "CrossSection",
            "class": og_gs.ImplicitCrossSection,
            "input_factory": og_gs.ImplicitCrossSectionInputFactory,
            "output_factory": og_gs.ImplicitCrossSectionOutputFactory,
            "missing_files": og_gs.check_implicit_cross_section_missing_files,
            "is_loadable": og_gs.is_implicit_cross_section_loadable,
            "load": og_gs.load_implicit_cross_section,
            "is_saveable": og_gs.is_implicit_cross_section_saveable,
            "save": og_gs.save_implicit_cross_section,
            "builder": og_gs.ImplicitCrossSectionBuilder,
            "crs": {
                "assign": og_gs.assign_section_geographic_coordinate_system_info,
                "convert": og_gs.convert_section_coordinate_reference_system,
                "create": og.create_section_coordinate_system,
            },
            "object_type": model,
            "is_3D": False,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_implicit_cross_section,
            "save_light_viewable": g_v.save_light_viewable_implicit_cross_section,
            "inspector": og_inspector.inspect_section,
        },
        "ImplicitStructuralModel": {
            "parent": "StructuralModel",
            "class": og_gs.ImplicitStructuralModel,
            "input_factory": og_gs.ImplicitStructuralModelInputFactory,
            "output_factory": og_gs.ImplicitStructuralModelOutputFactory,
            "missing_files": og_gs.check_implicit_structural_model_missing_files,
            "is_loadable": og_gs.is_implicit_structural_model_loadable,
            "load": og_gs.load_implicit_structural_model,
            "is_saveable": og_gs.is_implicit_structural_model_saveable,
            "save": og_gs.save_implicit_structural_model,
            "builder": og_gs.ImplicitStructuralModelBuilder,
            "crs": {
                "assign": og_gs.assign_brep_geographic_coordinate_system_info,
                "convert": og_gs.convert_brep_coordinate_reference_system,
                "create": og.create_brep_coordinate_system,
            },
            "object_type": model,
            "is_3D": True,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_implicit_structural_model,
            "save_light_viewable": g_v.save_light_viewable_implicit_structural_model,
            "inspector": og_inspector.inspect_brep,
        },
        "LightRegularGrid2D": {
            "class": og.LightRegularGrid2D,
            "input_factory": og.LightRegularGridInputFactory2D,
            "output_factory": og.LightRegularGridOutputFactory2D,
            "missing_files": og.check_light_regular_grid_missing_files2D,
            "is_loadable": og.is_light_regular_grid_loadable2D,
            "load": og.load_light_regular_grid2D,
            "is_saveable": og.is_light_regular_grid_saveable2D,
            "save": og.save_light_regular_grid2D,
            "object_type": mesh,
            "elements": [points, polygons],
            "is_3D": False,
            "is_viewable": True,
            "save_viewable": g_v.save_light_viewable_light_regular_grid2D,
            "save_light_viewable": g_v.save_light_viewable_light_regular_grid2D,
        },
        "LightRegularGrid3D": {
            "class": og.LightRegularGrid3D,
            "input_factory": og.LightRegularGridInputFactory3D,
            "output_factory": og.LightRegularGridOutputFactory3D,
            "missing_files": og.check_light_regular_grid_missing_files3D,
            "is_loadable": og.is_light_regular_grid_loadable3D,
            "load": og.load_light_regular_grid3D,
            "is_saveable": og.is_light_regular_grid_saveable3D,
            "save": og.save_light_regular_grid3D,
            "object_type": mesh,
            "elements": [points, polyhedrons],
            "is_3D": True,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_light_regular_grid3D,
            "save_light_viewable": g_v.save_light_viewable_light_regular_grid3D,
        },
        "PointSet2D": {
            "class": og.PointSet2D,
            "input_factory": og.PointSetInputFactory2D,
            "output_factory": og.PointSetOutputFactory2D,
            "missing_files": og.check_point_set_missing_files2D,
            "is_loadable": og.is_point_set_loadable2D,
            "load": og.load_point_set2D,
            "is_saveable": og.is_point_set_saveable2D,
            "save": og.save_point_set2D,
            "builder": og.PointSetBuilder2D.create,
            "crs": {
                "assign": og_gs.assign_point_set_geographic_coordinate_system_info2D,
                "convert": og_gs.convert_point_set_coordinate_reference_system2D,
                "create": og.create_point_set_coordinate_system2D,
            },
            "object_type": mesh,
            "elements": [points],
            "is_3D": False,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_point_set2D,
            "save_light_viewable": g_v.save_light_viewable_point_set2D,
            "inspector": og_inspector.inspect_point_set2D,
        },
        "PointSet3D": {
            "class": og.PointSet3D,
            "input_factory": og.PointSetInputFactory3D,
            "output_factory": og.PointSetOutputFactory3D,
            "missing_files": og.check_point_set_missing_files3D,
            "is_loadable": og.is_point_set_loadable3D,
            "load": og.load_point_set3D,
            "is_saveable": og.is_point_set_saveable3D,
            "save": og.save_point_set3D,
            "builder": og.PointSetBuilder3D.create,
            "crs": {
                "assign": og_gs.assign_point_set_geographic_coordinate_system_info3D,
                "convert": og_gs.convert_point_set_coordinate_reference_system3D,
                "create": og.create_point_set_coordinate_system3D,
            },
            "object_type": mesh,
            "elements": [points],
            "is_3D": True,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_point_set3D,
            "save_light_viewable": g_v.save_light_viewable_point_set3D,
            "inspector": og_inspector.inspect_point_set3D,
        },
        "PolygonalSurface2D": {
            "class": og.PolygonalSurface2D,
            "input_factory": og.PolygonalSurfaceInputFactory2D,
            "output_factory": og.PolygonalSurfaceOutputFactory2D,
            "missing_files": og.check_polygonal_surface_missing_files2D,
            "is_loadable": og.is_polygonal_surface_loadable2D,
            "load": og.load_polygonal_surface2D,
            "is_saveable": og.is_polygonal_surface_saveable2D,
            "save": og.save_polygonal_surface2D,
            "builder": og.PolygonalSurfaceBuilder2D.create,
            "crs": {
                "assign": og_gs.assign_surface_mesh_geographic_coordinate_system_info2D,
                "convert": og_gs.convert_surface_mesh_coordinate_reference_system2D,
                "create": og.create_surface_mesh_coordinate_system2D,
            },
            "object_type": mesh,
            "elements": [points, polygons],
            "is_3D": False,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_polygonal_surface2D,
            "save_light_viewable": g_v.save_light_viewable_polygonal_surface2D,
            "inspector": og_inspector.inspect_surface2D,
        },
        "PolygonalSurface3D": {
            "class": og.PolygonalSurface3D,
            "input_factory": og.PolygonalSurfaceInputFactory3D,
            "output_factory": og.PolygonalSurfaceOutputFactory3D,
            "missing_files": og.check_polygonal_surface_missing_files3D,
            "is_loadable": og.is_polygonal_surface_loadable3D,
            "load": og.load_polygonal_surface3D,
            "is_saveable": og.is_polygonal_surface_saveable3D,
            "save": og.save_polygonal_surface3D,
            "builder": og.PolygonalSurfaceBuilder3D.create,
            "crs": {
                "assign": og_gs.assign_surface_mesh_geographic_coordinate_system_info3D,
                "convert": og_gs.convert_surface_mesh_coordinate_reference_system3D,
                "create": og.create_surface_mesh_coordinate_system3D,
            },
            "object_type": mesh,
            "elements": [points, polygons],
            "is_3D": True,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_polygonal_surface3D,
            "save_light_viewable": g_v.save_light_viewable_polygonal_surface3D,
            "inspector": og_inspector.inspect_surface3D,
        },
        "PolyhedralSolid3D": {
            "class": og.PolyhedralSolid3D,
            "input_factory": og.PolyhedralSolidInputFactory3D,
            "output_factory": og.PolyhedralSolidOutputFactory3D,
            "missing_files": og.check_polyhedral_solid_missing_files3D,
            "is_loadable": og.is_polyhedral_solid_loadable3D,
            "load": og.load_polyhedral_solid3D,
            "is_saveable": og.is_polyhedral_solid_saveable3D,
            "save": og.save_polyhedral_solid3D,
            "builder": og.PolyhedralSolidBuilder3D.create,
            "crs": {
                "assign": og_gs.assign_solid_mesh_geographic_coordinate_system_info3D,
                "convert": og_gs.convert_solid_mesh_coordinate_reference_system3D,
                "create": og.create_solid_mesh_coordinate_system3D,
            },
            "object_type": mesh,
            "elements": [points, polyhedrons],
            "is_3D": True,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_polyhedral_solid3D,
            "save_light_viewable": g_v.save_light_viewable_polyhedral_solid3D,
            "inspector": og_inspector.inspect_solid3D,
        },
        "RasterImage2D": {
            "class": og.RasterImage2D,
            "input_factory": og.RasterImageInputFactory2D,
            "output_factory": og.RasterImageOutputFactory2D,
            "missing_files": og.check_raster_image_missing_files2D,
            "is_loadable": og.is_raster_image_loadable2D,
            "load": og.load_raster_image2D,
            "is_saveable": og.is_raster_image_saveable2D,
            "save": og.save_raster_image2D,
            "object_type": mesh,
            "is_3D": False,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_raster_image2D,
        },
        "RasterImage3D": {
            "class": og.RasterImage3D,
            "input_factory": og.RasterImageInputFactory3D,
            "output_factory": og.RasterImageOutputFactory3D,
            "missing_files": og.check_raster_image_missing_files3D,
            "is_loadable": og.is_raster_image_loadable3D,
            "load": og.load_raster_image3D,
            "is_saveable": og.is_raster_image_saveable3D,
            "save": og.save_raster_image3D,
            "object_type": mesh,
            "is_3D": False,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_raster_image3D,
        },
        "RegularGrid2D": {
            "class": og.RegularGrid2D,
            "input_factory": og.RegularGridInputFactory2D,
            "output_factory": og.RegularGridOutputFactory2D,
            "missing_files": og.check_regular_grid_missing_files2D,
            "is_loadable": og.is_regular_grid_loadable2D,
            "load": og.load_regular_grid2D,
            "is_saveable": og.is_regular_grid_saveable2D,
            "save": og.save_regular_grid2D,
            "builder": og.RegularGridBuilder2D.create,
            "crs": {
                "assign": og_gs.assign_surface_mesh_geographic_coordinate_system_info2D,
                "convert": og_gs.convert_surface_mesh_coordinate_reference_system2D,
                "create": og.create_surface_mesh_coordinate_system2D,
            },
            "object_type": mesh,
            "elements": [points, polygons],
            "is_3D": False,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_regular_grid2D,
            "save_light_viewable": g_v.save_light_viewable_regular_grid2D,
        },
        "RegularGrid3D": {
            "class": og.RegularGrid3D,
            "input_factory": og.RegularGridInputFactory3D,
            "output_factory": og.RegularGridOutputFactory3D,
            "missing_files": og.check_regular_grid_missing_files3D,
            "is_loadable": og.is_regular_grid_loadable3D,
            "load": og.load_regular_grid3D,
            "is_saveable": og.is_regular_grid_saveable3D,
            "save": og.save_regular_grid3D,
            "builder": og.RegularGridBuilder3D.create,
            "crs": {
                "assign": og_gs.assign_solid_mesh_geographic_coordinate_system_info3D,
                "convert": og_gs.convert_solid_mesh_coordinate_reference_system3D,
                "create": og.create_surface_mesh_coordinate_system3D,
            },
            "object_type": mesh,
            "elements": [points, polyhedrons],
            "is_3D": True,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_regular_grid3D,
            "save_light_viewable": g_v.save_light_viewable_regular_grid3D,
        },
        "Section": {
            "class": og.Section,
            "input_factory": og.SectionInputFactory,
            "output_factory": og.SectionOutputFactory,
            "missing_files": og.check_section_missing_files,
            "is_loadable": og.is_section_loadable,
            "load": og.load_section,
            "is_saveable": og.is_section_saveable,
            "save": og.save_section,
            "builder": og.SectionBuilder,
            "crs": {
                "assign": og_gs.assign_section_geographic_coordinate_system_info,
                "convert": og_gs.convert_section_coordinate_reference_system,
                "create": og.create_section_coordinate_system,
            },
            "object_type": model,
            "is_3D": False,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_section,
            "save_light_viewable": g_v.save_light_viewable_section,
            "inspector": og_inspector.inspect_section,
        },
        "StructuralModel": {
            "parent": "BRep",
            "class": og_gs.StructuralModel,
            "input_factory": og_gs.StructuralModelInputFactory,
            "output_factory": og_gs.StructuralModelOutputFactory,
            "missing_files": og_gs.check_structural_model_missing_files,
            "is_loadable": og_gs.is_structural_model_loadable,
            "load": og_gs.load_structural_model,
            "is_saveable": og_gs.is_structural_model_saveable,
            "save": og_gs.save_structural_model,
            "builder": og_gs.StructuralModelBuilder,
            "crs": {
                "assign": og_gs.assign_brep_geographic_coordinate_system_info,
                "convert": og_gs.convert_brep_coordinate_reference_system,
                "create": og.create_brep_coordinate_system,
            },
            "object_type": model,
            "is_3D": True,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_structural_model,
            "save_light_viewable": g_v.save_light_viewable_structural_model,
            "inspector": og_inspector.inspect_brep,
        },
        "TetrahedralSolid3D": {
            "class": og.TetrahedralSolid3D,
            "input_factory": og.TetrahedralSolidInputFactory3D,
            "output_factory": og.TetrahedralSolidOutputFactory3D,
            "missing_files": og.check_tetrahedral_solid_missing_files3D,
            "is_loadable": og.is_tetrahedral_solid_loadable3D,
            "load": og.load_tetrahedral_solid3D,
            "is_saveable": og.is_tetrahedral_solid_saveable3D,
            "save": og.save_tetrahedral_solid3D,
            "builder": og.TetrahedralSolidBuilder3D.create,
            "crs": {
                "assign": og_gs.assign_solid_mesh_geographic_coordinate_system_info3D,
                "convert": og_gs.convert_solid_mesh_coordinate_reference_system3D,
                "create": og.create_solid_mesh_coordinate_system3D,
            },
            "object_type": mesh,
            "elements": [points, polyhedrons],
            "is_3D": True,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_tetrahedral_solid3D,
            "save_light_viewable": g_v.save_light_viewable_tetrahedral_solid3D,
            "inspector": og_inspector.inspect_solid3D,
        },
        "TriangulatedSurface2D": {
            "class": og.TriangulatedSurface2D,
            "input_factory": og.TriangulatedSurfaceInputFactory2D,
            "output_factory": og.TriangulatedSurfaceOutputFactory2D,
            "missing_files": og.check_triangulated_surface_missing_files2D,
            "is_loadable": og.is_triangulated_surface_loadable2D,
            "load": og.load_triangulated_surface2D,
            "is_saveable": og.is_triangulated_surface_saveable2D,
            "save": og.save_triangulated_surface2D,
            "builder": og.TriangulatedSurfaceBuilder2D.create,
            "crs": {
                "assign": og_gs.assign_surface_mesh_geographic_coordinate_system_info2D,
                "convert": og_gs.convert_surface_mesh_coordinate_reference_system2D,
                "create": og.create_surface_mesh_coordinate_system2D,
            },
            "object_type": mesh,
            "elements": [points, polygons],
            "is_3D": False,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_triangulated_surface2D,
            "save_light_viewable": g_v.save_light_viewable_triangulated_surface2D,
            "inspector": og_inspector.inspect_surface2D,
        },
        "TriangulatedSurface3D": {
            "class": og.TriangulatedSurface3D,
            "input_factory": og.TriangulatedSurfaceInputFactory3D,
            "output_factory": og.TriangulatedSurfaceOutputFactory3D,
            "missing_files": og.check_triangulated_surface_missing_files3D,
            "is_loadable": og.is_triangulated_surface_loadable3D,
            "load": og.load_triangulated_surface3D,
            "is_saveable": og.is_triangulated_surface_saveable3D,
            "save": og.save_triangulated_surface3D,
            "builder": og.TriangulatedSurfaceBuilder3D.create,
            "crs": {
                "assign": og_gs.assign_surface_mesh_geographic_coordinate_system_info3D,
                "convert": og_gs.convert_surface_mesh_coordinate_reference_system3D,
                "create": og.create_surface_mesh_coordinate_system3D,
            },
            "object_type": mesh,
            "elements": [points, polygons],
            "is_3D": True,
            "is_viewable": True,
            "save_viewable": g_v.save_viewable_triangulated_surface3D,
            "save_light_viewable": g_v.save_light_viewable_triangulated_surface3D,
            "inspector": og_inspector.inspect_surface3D,
        },
        "VertexSet": {
            "class": og.VertexSet,
            "input_factory": og.VertexSetInputFactory,
            "output_factory": og.VertexSetOutputFactory,
            "missing_files": og.check_vertex_set_missing_files,
            "is_loadable": og.is_vertex_set_loadable,
            "load": og.load_vertex_set,
            "is_saveable": og.is_vertex_set_saveable,
            "save": og.save_vertex_set,
            "builder": og.VertexSetBuilder.create,
            "object_type": mesh,
            "is_3D": False,
            "is_viewable": False,
        },
    }
