The Tapjacking Vulnerability is a security flaw that allows an attacker to overlay malicious content or interfaces on top of legitimate applications, tricking users into interacting with the attacker's content instead. This can lead to various malicious activities, such as stealing sensitive information, capturing login credentials, or performing unauthorized actions on the user's behalf.


Below are examples of incorrect overlay handling:


=== "resource.xml"
  ```xml
  <Button
          android:id="@+id/buttonLogin"
          android:layout_width="wrap_content"
          android:layout_height="wrap_content"
          android:layout_marginTop="20dp"
          android:text="LOGIN"
          app:layout_constraintBottom_toTopOf="@id/textViewRegister"
          app:layout_constraintLeft_toLeftOf="parent"
          app:layout_constraintRight_toRightOf="parent"
          app:layout_constraintTop_toBottomOf="@id/textInputPasswordL"
          android:filterTouchesWhenObscured="false"/> // vulnerable
  ```

=== "JAVA"
  ```java
  public class YourActivity extends AppCompatActivity {
  
      @Override
      public void onCreate(Bundle savedInstanceState) {
          super.onCreate(savedInstanceState);
          setContentView(R.layout.activity_your_layout);
  
          Button yourButton = findViewById(R.id.yourButtonId);
          yourButton.setOnClickListener(new View.OnClickListener() {
              @Override
              public void onClick(View view) {
                  // Handle button click
              }
          });
      }
  }
  ```

=== "KOTLIN"
  ```kotlin
  class YourActivity : AppCompatActivity() {
  
      override fun onCreate(savedInstanceState: Bundle?) {
          super.onCreate(savedInstanceState)
          setContentView(R.layout.activity_your_layout)
  
          val yourButton: Button = findViewById(R.id.yourButtonId)
          yourButton.setOnClickListener {
              // Handle button click
          }
      }
  }
  ```
