To mitigate Tapjacking vulnerabilities in mobile applications, consider the following recommendations:

* **Enable Touch Filtering**: Set the `android:filterTouchesWhenObscured` attribute to `true` for UI elements, such as buttons involved in authentication processes. This prevents touch events from being dispatched to obscured views, reducing the risk of Tapjacking attacks.

**Note:** Android S (12, SDK 31) and higher prevent tapjacking attacks by default, by blocking touch events from non-trusted overlays from another UID.


Below are examples of secure overlay handling:


=== "resource.xml"
  ```xml
  <Button
          android:id="@+id/buttonLogin"
          android:layout_width="wrap_content"
          android:layout_height="wrap_content"
          android:layout_marginTop="20dp"
          android:text="LOGIN"
          app:layout_constraintBottom_toTopOf="@id/textViewRegister"
          app:layout_constraintLeft_toLeftOf="parent"
          app:layout_constraintRight_toRightOf="parent"
          app:layout_constraintTop_toBottomOf="@id/textInputPasswordL"
          android:filterTouchesWhenObscured="true"/>
  ```

=== "JAVA"
  ```java
  public class YourActivity extends AppCompatActivity {
  
      @Override
      public void onCreate(Bundle savedInstanceState) {
          super.onCreate(savedInstanceState);
          setContentView(R.layout.activity_your_layout);
  
          Button yourButton = findViewById(R.id.yourButtonId);
          yourButton.filterTouchesWhenObscured = true
          yourButton.setOnClickListener(new View.OnClickListener() {
              @Override
              public void onClick(View view) {
                  // Handle button click
              }
          });
      }
  }
  ```

=== "KOTLIN"
  ```kotlin
  class YourActivity : AppCompatActivity() {
  
      override fun onCreate(savedInstanceState: Bundle?) {
          super.onCreate(savedInstanceState)
          setContentView(R.layout.activity_your_layout)
  
          val yourButton: Button = findViewById(R.id.yourButtonId)
          yourButton.isFilterTouchesWhenObscured = true
          yourButton.setOnClickListener {
              // Handle button click
          }
      }
  }
  ```
