"""Revision reflecting the state of databases created with ostorlab<0.11.2.
Useful as a starting point for future migrations.

Revision ID: 35cd577ef0e5
Revises:
Create Date: 2022-10-26 16:00:52.792734

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "35cd577ef0e5"
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "scan",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("title", sa.String(length=255), nullable=True),
        sa.Column("asset", sa.String(length=255), nullable=True),
        sa.Column("created_time", sa.DateTime(), nullable=True),
        sa.Column(
            "progress",
            sa.Enum(
                "NOT_STARTED",
                "IN_PROGRESS",
                "STOPPED",
                "DONE",
                "ERROR",
                name="scanprogress",
            ),
            nullable=True,
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "scan_status",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("created_time", sa.DateTime(), nullable=True),
        sa.Column("key", sa.String(length=255), nullable=True),
        sa.Column("value", sa.Text(), nullable=True),
        sa.Column("scan_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["scan_id"],
            ["scan.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "vulnerability",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("technical_detail", sa.Text(), nullable=True),
        sa.Column(
            "risk_rating",
            sa.Enum(
                "HIGH",
                "MEDIUM",
                "LOW",
                "POTENTIALLY",
                "HARDENING",
                "SECURE",
                "IMPORTANT",
                "INFO",
                name="riskrating",
            ),
            nullable=True,
        ),
        sa.Column("cvss_v3_vector", sa.String(length=1024), nullable=True),
        sa.Column("dna", sa.String(length=256), nullable=True),
        sa.Column("title", sa.String(length=256), nullable=True),
        sa.Column("short_description", sa.Text(), nullable=True),
        sa.Column("description", sa.Text(), nullable=True),
        sa.Column("recommendation", sa.Text(), nullable=True),
        sa.Column("scan_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["scan_id"],
            ["scan.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("vulnerability")
    op.drop_table("scan_status")
    op.drop_table("scan")
    # ### end Alembic commands ###
