"""Add agent group definition model

Revision ID: 4d13d49d324c
Revises: 7d12204c3f27
Create Date: 2024-05-28 12:54:15.316781

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "4d13d49d324c"
down_revision = "7d12204c3f27"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "agent",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("key", sa.String(length=255), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "agent_group",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=255), nullable=True),
        sa.Column("description", sa.Text(), nullable=True),
        sa.Column("created_time", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "agent_argument",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=255), nullable=True),
        sa.Column("type", sa.String(length=255), nullable=True),
        sa.Column("description", sa.Text(), nullable=True),
        sa.Column("value", sa.LargeBinary(), nullable=True),
        sa.Column("agent_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["agent_id"],
            ["agent.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "agent_group_mapping",
        sa.Column("agent_id", sa.Integer(), nullable=False),
        sa.Column("agent_group_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["agent_group_id"],
            ["agent_group.id"],
        ),
        sa.ForeignKeyConstraint(
            ["agent_id"],
            ["agent.id"],
        ),
        sa.PrimaryKeyConstraint("agent_id", "agent_group_id"),
    )
    with op.batch_alter_table("scan", schema=None) as batch_op:
        batch_op.add_column(sa.Column("agent_group_id", sa.Integer(), nullable=True))
        batch_op.create_foreign_key(
            "fk_scan_agent_group_id_agent_group",
            "agent_group",
            ["agent_group_id"],
            ["id"],
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("scan", schema=None) as batch_op:
        batch_op.drop_constraint(
            "fk_scan_agent_group_id_agent_group", type_="foreignkey"
        )
        batch_op.drop_column("agent_group_id")

    op.drop_table("agent_group_mapping")
    op.drop_table("agent_argument")
    op.drop_table("agent_group")
    op.drop_table("agent")
    # ### end Alembic commands ###
