"""Switch asset types to enum

Revision ID: 69c7d2f49a4e
Revises: b31a27c8584f
Create Date: 2024-06-26 18:21:23.093382

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "69c7d2f49a4e"
down_revision = "b31a27c8584f"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("asset_type", schema=None) as batch_op:
        batch_op.alter_column(
            "type",
            existing_type=sa.VARCHAR(length=255),
            type_=sa.Enum(
                "ANDROID_FILE",
                "IOS_FILE",
                "ANDROID_STORE",
                "IOS_STORE",
                "LINK",
                "IP",
                "DOMAIN",
                "FILE",
                name="assettypeenum",
            ),
            existing_nullable=True,
        )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("asset_type", schema=None) as batch_op:
        batch_op.alter_column(
            "type",
            existing_type=sa.Enum(
                "ANDROID_FILE",
                "IOS_FILE",
                "ANDROID_STORE",
                "IOS_STORE",
                "LINK",
                "IP",
                "DOMAIN",
                "FILE",
                name="assettypeenum",
            ),
            type_=sa.VARCHAR(length=255),
            existing_nullable=True,
        )
    # ### end Alembic commands ###
