"""Add exploitation and post exploitation details

Revision ID: c3231845f850
Revises: d47f712dab53
Create Date: 2025-03-26 10:59:07.006256

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "c3231845f850"
down_revision = "d47f712dab53"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("agent_argument", schema=None) as batch_op:
        batch_op.alter_column(
            "value",
            existing_type=sa.TEXT(),
            type_=sa.LargeBinary(),
            existing_nullable=True,
        )

    with op.batch_alter_table("vulnerability", schema=None) as batch_op:
        batch_op.add_column(sa.Column("exploitation_detail", sa.Text(), nullable=True))
        batch_op.add_column(
            sa.Column("post_exploitation_detail", sa.Text(), nullable=True)
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("vulnerability", schema=None) as batch_op:
        batch_op.drop_column("post_exploitation_detail")
        batch_op.drop_column("exploitation_detail")

    with op.batch_alter_table("agent_argument", schema=None) as batch_op:
        batch_op.alter_column(
            "value",
            existing_type=sa.LargeBinary(),
            type_=sa.TEXT(),
            existing_nullable=True,
        )

    # ### end Alembic commands ###
