import { Pipeline, PipelineType } from "aws-cdk-lib/aws-codepipeline";
import type { IRepository } from "aws-cdk-lib/aws-ecr";
import type { IBaseService } from "aws-cdk-lib/aws-ecs";
import type { IBucket } from "aws-cdk-lib/aws-s3";
import { Construct } from "constructs";
/**
 * Properties for the ContainerImagePipeline constructor.
 */
export interface ContainerImagePipelineProps {
    /**
     * The ECR repository where images will be pushed.
     */
    readonly repository: IRepository;
    /**
     * The ECS service to update when an image is pushed to the ECR repository.
     */
    readonly service: IBaseService;
    /**
     * The name of the container in the task definition to update.
     */
    readonly container: string;
    /**
     * The container image tag to observe for changes in the ECR repository.
     *
     * @default - "latest"
     */
    readonly tag?: string;
    /**
     * The pipeline type (V1 or V2).
     *
     * @default - V1
     */
    readonly pipelineType?: PipelineType;
    /**
     * A custom bucket for artifacts.
     *
     * @default - A new bucket will be created
     */
    readonly artifactBucket?: IBucket;
}
/**
 * Allows images pushed to an ECR repo to trigger updates to an ECS service.
 *
 * This construct produces a CodePipeline pipeline using the "ECR Source"
 * action, an "ECS Deploy" action, and a custom Lambda handler in between that
 * transforms the JSON from the "Source" action into the JSON needed for the
 * "Deploy" action.
 */
export declare class ContainerImagePipeline extends Construct {
    /**
     * The CodePipeline pipeline
     */
    readonly pipeline: Pipeline;
    /**
     * Creates a new ContainerImagePipeline.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param props - Initialization properties for this construct.
     */
    constructor(scope: Construct, id: string, props: ContainerImagePipelineProps);
}
