"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _Starter_startable, _Starter_lines, _Starter_registered, _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Starter = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Orchestrates the startup process of EC2 instances.
 *
 * A `Starter` is a registry for add-ons. Each add-on can add permissions to the
 * role, network rules to the security group, or scripts to the user data.
 *
 * Scripts are prioritized, so add-ons can be registered out of order but their
 * scripts will appear in the user data in order of priority.
 */
class Starter {
    /**
     * Create a Starter for an auto-scaling group.
     *
     * @param group - The auto-scaling group
     * @returns a new Starter
     */
    static forAutoScalingGroup(group) {
        return new Starter(group);
    }
    /**
     * Create a Starter for a Launch Template.
     *
     * The launch template _must_ have a defined user data property, or this
     * method will throw an error.
     *
     * @param template - The launch template
     * @returns a new Starter
     * @throws Error if the Launch Template user data is undefined
     */
    static forLaunchTemplate(template) {
        if (!template.userData) {
            throw new Error("You must supply a Launch Template with user data");
        }
        return new Starter(template);
    }
    /**
     * Create a Starter for a single EC2 instance3
     *
     * @param instance - The instance
     * @returns a new Starter
     */
    static forInstance(instance) {
        return new Starter(instance);
    }
    /**
     * @ignore
     */
    constructor(startable) {
        _Starter_startable.set(this, void 0);
        _Starter_lines.set(this, []);
        _Starter_registered.set(this, false);
        __classPrivateFieldSet(this, _Starter_startable, startable, "f");
    }
    /**
     * @ignore
     */
    registerUserData() {
        if (__classPrivateFieldGet(this, _Starter_registered, "f")) {
            return;
        }
        __classPrivateFieldGet(this, _Starter_startable, "f").userData.addCommands(aws_cdk_lib_1.Lazy.string({ produce: () => this.orderedLines.join("\n") }));
        __classPrivateFieldSet(this, _Starter_registered, true, "f");
    }
    get grantPrincipal() {
        return __classPrivateFieldGet(this, _Starter_startable, "f").grantPrincipal;
    }
    get connections() {
        return __classPrivateFieldGet(this, _Starter_startable, "f").connections;
    }
    /**
     * All lines of the startup script in priority order.
     */
    get orderedLines() {
        const lines = [...__classPrivateFieldGet(this, _Starter_lines, "f")];
        lines.sort((a, b) => a.priority - b.priority);
        return lines.map((a) => a.lines).flat();
    }
    /**
     * Add one or more commands to the user data at a specific priority.
     *
     * @param priority - The priority of these lines (lower executes earlier)
     * @param commands - The lines to add
     * @returns provides a fluent interface
     */
    addScript(priority, ...commands) {
        this.registerUserData();
        __classPrivateFieldGet(this, _Starter_lines, "f").push({ priority, lines: commands });
        return this;
    }
    /**
     * Register add-ons with this Starter.
     *
     * @param addons - The add-ons to register
     * @returns provides a fluent interface
     */
    withAddOns(...addons) {
        for (const addon of addons) {
            addon.configure(this);
        }
        return this;
    }
}
exports.Starter = Starter;
_Starter_startable = new WeakMap(), _Starter_lines = new WeakMap(), _Starter_registered = new WeakMap(), _a = JSII_RTTI_SYMBOL_1;
Starter[_a] = { fqn: "shady-island.configuration.Starter", version: "0.1.62" };
//# sourceMappingURL=data:application/json;base64,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