import * as https from "https";
import { SecretsManagerClient } from "@aws-sdk/client-secrets-manager";
export declare function parseJsonArrayFromEnv(variableName: string): string[];
export declare function fetchSecret<T = Record<string, any>>(arn: string, client: SecretsManagerClient): Promise<T>;
export declare function fetchAllSecrets<T = Record<string, any>>(arns: string[], client: SecretsManagerClient): Promise<T[]>;
/**
 * Reads an HTTPS resource into a string.
 *
 * We need this function since newer RDS CA certificates aren't in Lambda.
 *
 * @see https://github.com/aws/aws-lambda-base-images/issues/123
 */
export declare function readRemote(url: string, options?: https.RequestOptions): Promise<Buffer>;
