#include <ROL_DynamicObjective.hpp>
#include <ROL_DynamicObjective_CheckInterface.hpp>
#include <ROL_Elementwise_Function.hpp>
#include <ROL_Elementwise_Reduce.hpp>
#include <ROL_TimeStamp.hpp>
#include <ROL_Vector.hpp>
#include <Teuchos_RCPDecl.hpp>
#include <functional>
#include <memory>
#include <ostream>
#include <sstream> // __str__
#include <string>
#include <vector>

#include <functional>
#include <pybind11/pybind11.h>
#include <string>
#include <Teuchos_RCP.hpp>


#ifndef BINDER_PYBIND11_TYPE_CASTER
	#define BINDER_PYBIND11_TYPE_CASTER
	PYBIND11_DECLARE_HOLDER_TYPE(T, Teuchos::RCP<T>, false)
	PYBIND11_DECLARE_HOLDER_TYPE(T, T*, false)
	PYBIND11_MAKE_OPAQUE(Teuchos::RCP<void>)
#endif

void bind_pyrol_48(std::function< pybind11::module &(std::string const &namespace_) > &M)
{
	{ // ROL::details::DynamicObjective_CheckInterface file:ROL_DynamicObjective_CheckInterface.hpp line:26
		pybind11::class_<ROL::details::DynamicObjective_CheckInterface<double>, Teuchos::RCP<ROL::details::DynamicObjective_CheckInterface<double>>> cl(M("ROL::details"), "DynamicObjective_CheckInterface_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<class ROL::DynamicObjective<double> &>(), pybind11::arg("obj") );

		cl.def( pybind11::init<class ROL::DynamicObjective<double> &, struct ROL::TimeStamp<double> &>(), pybind11::arg("obj"), pybind11::arg("ts") );

		cl.def( pybind11::init( [](ROL::details::DynamicObjective_CheckInterface<double> const &o){ return new ROL::details::DynamicObjective_CheckInterface<double>(o); } ) );
		cl.def("update_uo", (class std::function<void (const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::update_uo, "C++: ROL::details::DynamicObjective_CheckInterface<double>::update_uo(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (const class ROL::Vector<double> &)>", pybind11::arg("un"), pybind11::arg("z"));
		cl.def("update_un", (class std::function<void (const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::update_un, "C++: ROL::details::DynamicObjective_CheckInterface<double>::update_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"));
		cl.def("update_z", (class std::function<void (const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::update_z, "C++: ROL::details::DynamicObjective_CheckInterface<double>::update_z(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("un"));
		cl.def("value_uo", (class std::function<double (const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::value_uo, "C++: ROL::details::DynamicObjective_CheckInterface<double>::value_uo(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<double (const class ROL::Vector<double> &)>", pybind11::arg("un"), pybind11::arg("z"));
		cl.def("value_un", (class std::function<double (const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::value_un, "C++: ROL::details::DynamicObjective_CheckInterface<double>::value_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<double (const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"));
		cl.def("value_z", (class std::function<double (const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::value_z, "C++: ROL::details::DynamicObjective_CheckInterface<double>::value_z(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<double (const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("un"));
		cl.def("gradient_uo", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::gradient_uo, "C++: ROL::details::DynamicObjective_CheckInterface<double>::gradient_uo(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("un"), pybind11::arg("z"));
		cl.def("gradient_un", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::gradient_un, "C++: ROL::details::DynamicObjective_CheckInterface<double>::gradient_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"));
		cl.def("gradient_z", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::gradient_z, "C++: ROL::details::DynamicObjective_CheckInterface<double>::gradient_z(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("un"));
		cl.def("gradient_uo_uo", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::gradient_uo_uo, "C++: ROL::details::DynamicObjective_CheckInterface<double>::gradient_uo_uo(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("un"), pybind11::arg("z"));
		cl.def("gradient_uo_un", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::gradient_uo_un, "C++: ROL::details::DynamicObjective_CheckInterface<double>::gradient_uo_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"));
		cl.def("gradient_uo_z", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::gradient_uo_z, "C++: ROL::details::DynamicObjective_CheckInterface<double>::gradient_uo_z(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("un"));
		cl.def("gradient_un_uo", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::gradient_un_uo, "C++: ROL::details::DynamicObjective_CheckInterface<double>::gradient_un_uo(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("un"), pybind11::arg("z"));
		cl.def("gradient_un_un", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::gradient_un_un, "C++: ROL::details::DynamicObjective_CheckInterface<double>::gradient_un_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"));
		cl.def("gradient_un_z", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::gradient_un_z, "C++: ROL::details::DynamicObjective_CheckInterface<double>::gradient_un_z(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("un"));
		cl.def("gradient_z_uo", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::gradient_z_uo, "C++: ROL::details::DynamicObjective_CheckInterface<double>::gradient_z_uo(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("un"), pybind11::arg("z"));
		cl.def("gradient_z_un", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::gradient_z_un, "C++: ROL::details::DynamicObjective_CheckInterface<double>::gradient_z_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"));
		cl.def("gradient_z_z", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::gradient_z_z, "C++: ROL::details::DynamicObjective_CheckInterface<double>::gradient_z_z(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("un"));
		cl.def("hessVec_uo_uo", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::hessVec_uo_uo, "C++: ROL::details::DynamicObjective_CheckInterface<double>::hessVec_uo_uo(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("un"), pybind11::arg("z"));
		cl.def("hessVec_uo_un", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::hessVec_uo_un, "C++: ROL::details::DynamicObjective_CheckInterface<double>::hessVec_uo_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"));
		cl.def("hessVec_uo_z", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::hessVec_uo_z, "C++: ROL::details::DynamicObjective_CheckInterface<double>::hessVec_uo_z(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("un"));
		cl.def("hessVec_un_uo", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::hessVec_un_uo, "C++: ROL::details::DynamicObjective_CheckInterface<double>::hessVec_un_uo(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("un"), pybind11::arg("z"));
		cl.def("hessVec_un_un", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::hessVec_un_un, "C++: ROL::details::DynamicObjective_CheckInterface<double>::hessVec_un_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"));
		cl.def("hessVec_un_z", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::hessVec_un_z, "C++: ROL::details::DynamicObjective_CheckInterface<double>::hessVec_un_z(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("un"));
		cl.def("hessVec_z_uo", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::hessVec_z_uo, "C++: ROL::details::DynamicObjective_CheckInterface<double>::hessVec_z_uo(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("un"), pybind11::arg("z"));
		cl.def("hessVec_z_un", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::hessVec_z_un, "C++: ROL::details::DynamicObjective_CheckInterface<double>::hessVec_z_un(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("z"));
		cl.def("hessVec_z_z", (class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)> (ROL::details::DynamicObjective_CheckInterface<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &)) &ROL::details::DynamicObjective_CheckInterface<double>::hessVec_z_z, "C++: ROL::details::DynamicObjective_CheckInterface<double>::hessVec_z_z(const class ROL::Vector<double> &, const class ROL::Vector<double> &) --> class std::function<void (class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &)>", pybind11::arg("uo"), pybind11::arg("un"));
	}
}
