#include <ROL_AbsoluteValue.hpp>
#include <ROL_AlmostSureConstraint.hpp>
#include <ROL_Arcsine.hpp>
#include <ROL_BPOE.hpp>
#include <ROL_BatchManager.hpp>
#include <ROL_Beta.hpp>
#include <ROL_BoundConstraint.hpp>
#include <ROL_CVaR.hpp>
#include <ROL_Cauchy.hpp>
#include <ROL_ChebyshevSpectral.hpp>
#include <ROL_Chi2Divergence.hpp>
#include <ROL_CoherentEntropicRisk.hpp>
#include <ROL_Constraint.hpp>
#include <ROL_ConstraintFromObjective.hpp>
#include <ROL_ConvexCombinationRiskMeasure.hpp>
#include <ROL_DeviationMeasureFactory.hpp>
#include <ROL_DeviationMeasureInfo.hpp>
#include <ROL_Dirac.hpp>
#include <ROL_Distribution.hpp>
#include <ROL_DistributionFactory.hpp>
#include <ROL_Elementwise_Function.hpp>
#include <ROL_Elementwise_Reduce.hpp>
#include <ROL_EntropicRisk.hpp>
#include <ROL_ErrorMeasureFactory.hpp>
#include <ROL_ErrorMeasureInfo.hpp>
#include <ROL_ExpectationQuad.hpp>
#include <ROL_ExpectationQuadDeviation.hpp>
#include <ROL_ExpectationQuadError.hpp>
#include <ROL_ExpectationQuadRegret.hpp>
#include <ROL_ExpectationQuadRisk.hpp>
#include <ROL_Exponential.hpp>
#include <ROL_FDivergence.hpp>
#include <ROL_Fejer2Quadrature.hpp>
#include <ROL_Gamma.hpp>
#include <ROL_GaussChebyshev1Quadrature.hpp>
#include <ROL_GaussChebyshev2Quadrature.hpp>
#include <ROL_GaussChebyshev3Quadrature.hpp>
#include <ROL_GaussLegendreQuadrature.hpp>
#include <ROL_Gaussian.hpp>
#include <ROL_GenMoreauYosidaCVaR.hpp>
#include <ROL_HMCR.hpp>
#include <ROL_KLDivergence.hpp>
#include <ROL_Kumaraswamy.hpp>
#include <ROL_Laplace.hpp>
#include <ROL_LogExponentialQuadrangle.hpp>
#include <ROL_LogQuantileQuadrangle.hpp>
#include <ROL_Logistic.hpp>
#include <ROL_MeanDeviation.hpp>
#include <ROL_MeanDeviationFromTarget.hpp>
#include <ROL_MeanSemiDeviation.hpp>
#include <ROL_MeanSemiDeviationFromTarget.hpp>
#include <ROL_MeanValueConstraint.hpp>
#include <ROL_MeanValueObjective.hpp>
#include <ROL_MeanVariance.hpp>
#include <ROL_MeanVarianceFromTarget.hpp>
#include <ROL_MeanVarianceQuadrangle.hpp>
#include <ROL_MixedCVaR.hpp>
#include <ROL_MoreauYosidaCVaR.hpp>
#include <ROL_Objective.hpp>
#include <ROL_Objective_SimOpt.hpp>
#include <ROL_Parabolic.hpp>
#include <ROL_PlusFunction.hpp>
#include <ROL_PositiveFunction.hpp>
#include <ROL_ProbabilityFactory.hpp>
#include <ROL_ProbabilityInfo.hpp>
#include <ROL_Quadrature1D.hpp>
#include <ROL_QuantileQuadrangle.hpp>
#include <ROL_QuantileRadius.hpp>
#include <ROL_RaisedCosine.hpp>
#include <ROL_RandVarFunctional.hpp>
#include <ROL_RandVarFunctionalFactory.hpp>
#include <ROL_RandVarFunctionalInfo.hpp>
#include <ROL_RegretMeasureFactory.hpp>
#include <ROL_RegretMeasureInfo.hpp>
#include <ROL_RiskBoundConstraint.hpp>
#include <ROL_RiskLessConstraint.hpp>
#include <ROL_RiskLessObjective.hpp>
#include <ROL_RiskMeasureFactory.hpp>
#include <ROL_RiskMeasureInfo.hpp>
#include <ROL_RiskNeutralConstraint.hpp>
#include <ROL_RiskVector.hpp>
#include <ROL_SampleGenerator.hpp>
#include <ROL_ScalarController.hpp>
#include <ROL_SecondOrderCVaR.hpp>
#include <ROL_SimulatedBoundConstraint.hpp>
#include <ROL_SimulatedVector.hpp>
#include <ROL_Smale.hpp>
#include <ROL_SmoothedPOE.hpp>
#include <ROL_SmoothedWorstCaseQuadrangle.hpp>
#include <ROL_SpectralRisk.hpp>
#include <ROL_StdBoundConstraint.hpp>
#include <ROL_StdVector.hpp>
#include <ROL_StochasticConstraint.hpp>
#include <ROL_StochasticObjective.hpp>
#include <ROL_Triangle.hpp>
#include <ROL_TruncatedExponential.hpp>
#include <ROL_TruncatedGaussian.hpp>
#include <ROL_TruncatedMeanQuadrangle.hpp>
#include <ROL_Uniform.hpp>
#include <ROL_UpdateType.hpp>
#include <ROL_Vector.hpp>
#include <ROL_VectorController.hpp>
#include <Teuchos_ENull.hpp>
#include <Teuchos_FilteredIterator.hpp>
#include <Teuchos_ParameterEntry.hpp>
#include <Teuchos_ParameterEntryValidator.hpp>
#include <Teuchos_ParameterList.hpp>
#include <Teuchos_ParameterListModifier.hpp>
#include <Teuchos_PtrDecl.hpp>
#include <Teuchos_RCPDecl.hpp>
#include <Teuchos_RCPNode.hpp>
#include <Teuchos_StringIndexedOrderedValueObjectContainer.hpp>
#include <Teuchos_any.hpp>
#include <deque>
#include <ios>
#include <iterator>
#include <locale>
#include <memory>
#include <ostream>
#include <sstream> // __str__
#include <streambuf>
#include <string>
#include <vector>

#include <functional>
#include <pybind11/pybind11.h>
#include <string>
#include <Teuchos_RCP.hpp>


#ifndef BINDER_PYBIND11_TYPE_CASTER
	#define BINDER_PYBIND11_TYPE_CASTER
	PYBIND11_DECLARE_HOLDER_TYPE(T, Teuchos::RCP<T>, false)
	PYBIND11_DECLARE_HOLDER_TYPE(T, T*, false)
	PYBIND11_MAKE_OPAQUE(Teuchos::RCP<void>)
#endif

// ROL::Distribution file:ROL_Distribution.hpp line:21
struct PyCallBack_ROL_Distribution_double_t : public ROL::Distribution<double> {
	using ROL::Distribution<double>::Distribution;

	double evaluatePDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Distribution<double> *>(this), "evaluatePDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Distribution::evaluatePDF(a0);
	}
	double evaluateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Distribution<double> *>(this), "evaluateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Distribution::evaluateCDF(a0);
	}
	double integrateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Distribution<double> *>(this), "integrateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Distribution::integrateCDF(a0);
	}
	double invertCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Distribution<double> *>(this), "invertCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Distribution::invertCDF(a0);
	}
	double moment(const unsigned long a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Distribution<double> *>(this), "moment");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Distribution::moment(a0);
	}
	double lowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Distribution<double> *>(this), "lowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Distribution::lowerBound();
	}
	double upperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Distribution<double> *>(this), "upperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Distribution::upperBound();
	}
	void test(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Distribution<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Distribution::test(a0);
	}
};

// ROL::Objective_SimOpt file:ROL_Objective_SimOpt.hpp line:25
struct PyCallBack_ROL_Objective_SimOpt_double_t : public ROL::Objective_SimOpt<double> {
	using ROL::Objective_SimOpt<double>::Objective_SimOpt;

	void update(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, bool a2, int a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective_SimOpt::update(a0, a1, a2, a3);
	}
	void update(const class ROL::Vector<double> & a0, bool a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective_SimOpt::update(a0, a1, a2);
	}
	void update(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, enum ROL::UpdateType a2, int a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective_SimOpt::update(a0, a1, a2, a3);
	}
	void update(const class ROL::Vector<double> & a0, enum ROL::UpdateType a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective_SimOpt::update(a0, a1, a2);
	}
	double value(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "value");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		pybind11::pybind11_fail("Tried to call pure virtual function \"Objective_SimOpt::value\"");
	}
	double value(const class ROL::Vector<double> & a0, double & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "value");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Objective_SimOpt::value(a0, a1);
	}
	void gradient_1(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "gradient_1");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective_SimOpt::gradient_1(a0, a1, a2, a3);
	}
	void gradient_2(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "gradient_2");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective_SimOpt::gradient_2(a0, a1, a2, a3);
	}
	void gradient(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "gradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective_SimOpt::gradient(a0, a1, a2);
	}
	void hessVec_11(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "hessVec_11");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective_SimOpt::hessVec_11(a0, a1, a2, a3, a4);
	}
	void hessVec_12(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "hessVec_12");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective_SimOpt::hessVec_12(a0, a1, a2, a3, a4);
	}
	void hessVec_21(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "hessVec_21");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective_SimOpt::hessVec_21(a0, a1, a2, a3, a4);
	}
	void hessVec_22(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "hessVec_22");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective_SimOpt::hessVec_22(a0, a1, a2, a3, a4);
	}
	void hessVec(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "hessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective_SimOpt::hessVec(a0, a1, a2, a3);
	}
	double dirDeriv(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "dirDeriv");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Objective::dirDeriv(a0, a1, a2);
	}
	void invHessVec(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "invHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::invHessVec(a0, a1, a2, a3);
	}
	void precond(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "precond");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::precond(a0, a1, a2, a3);
	}
	void prox(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "prox");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::prox(a0, a1, a2, a3);
	}
	void proxJacVec(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "proxJacVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::proxJacVec(a0, a1, a2, a3, a4);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool a2, std::ostream & a3, const int a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4, const int a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool a3, std::ostream & a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool a2, std::ostream & a3, const int a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4, const int a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool a3, std::ostream & a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<double> checkHessSym(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "checkHessSym");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Objective::checkHessSym(a0, a1, a2, a3, a4);
	}
	class std::vector<double> checkHessSym(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "checkHessSym");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Objective::checkHessSym(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkProxJacVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double a2, bool a3, std::ostream & a4, int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "checkProxJacVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkProxJacVec(a0, a1, a2, a3, a4, a5);
	}
	void setParameter(const class std::vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Objective_SimOpt<double> *>(this), "setParameter");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::setParameter(a0);
	}
};

// ROL::MeanValueObjective file:ROL_MeanValueObjective.hpp line:19
struct PyCallBack_ROL_MeanValueObjective_double_t : public ROL::MeanValueObjective<double> {
	using ROL::MeanValueObjective<double>::MeanValueObjective;

	void update(const class ROL::Vector<double> & a0, enum ROL::UpdateType a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanValueObjective::update(a0, a1, a2);
	}
	void update(const class ROL::Vector<double> & a0, bool a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanValueObjective::update(a0, a1, a2);
	}
	double value(const class ROL::Vector<double> & a0, double & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "value");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return MeanValueObjective::value(a0, a1);
	}
	void gradient(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "gradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanValueObjective::gradient(a0, a1, a2);
	}
	void hessVec(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "hessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanValueObjective::hessVec(a0, a1, a2, a3);
	}
	void precond(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "precond");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanValueObjective::precond(a0, a1, a2, a3);
	}
	double dirDeriv(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "dirDeriv");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Objective::dirDeriv(a0, a1, a2);
	}
	void invHessVec(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "invHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::invHessVec(a0, a1, a2, a3);
	}
	void prox(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "prox");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::prox(a0, a1, a2, a3);
	}
	void proxJacVec(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "proxJacVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::proxJacVec(a0, a1, a2, a3, a4);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool a2, std::ostream & a3, const int a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4, const int a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool a3, std::ostream & a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool a2, std::ostream & a3, const int a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4, const int a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool a3, std::ostream & a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<double> checkHessSym(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "checkHessSym");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Objective::checkHessSym(a0, a1, a2, a3, a4);
	}
	class std::vector<double> checkHessSym(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "checkHessSym");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Objective::checkHessSym(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkProxJacVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double a2, bool a3, std::ostream & a4, int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "checkProxJacVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkProxJacVec(a0, a1, a2, a3, a4, a5);
	}
	void setParameter(const class std::vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueObjective<double> *>(this), "setParameter");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::setParameter(a0);
	}
};

// ROL::RandVarFunctional file:ROL_RandVarFunctional.hpp line:47
struct PyCallBack_ROL_RandVarFunctional_double_t : public ROL::RandVarFunctional<double> {
	using ROL::RandVarFunctional<double>::RandVarFunctional;

	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RandVarFunctional<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RandVarFunctional<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RandVarFunctional<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RandVarFunctional<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RandVarFunctional<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::initialize(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RandVarFunctional<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RandVarFunctional<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RandVarFunctional<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::updateValue(a0, a1, a2, a3);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RandVarFunctional<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::updateGradient(a0, a1, a2, a3);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RandVarFunctional<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RandVarFunctional<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::getValue(a0, a1, a2);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RandVarFunctional<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::getGradient(a0, a1, a2, a3, a4);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RandVarFunctional<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
};

// ROL::StdVector file:ROL_StdVector.hpp line:27
struct PyCallBack_ROL_StdVector_double_double_t : public ROL::StdVector<double,double> {
	using ROL::StdVector<double,double>::StdVector;

	void set(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdVector<double,double> *>(this), "set");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StdVector::set(a0);
	}
	void plus(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdVector<double,double> *>(this), "plus");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StdVector::plus(a0);
	}
	void axpy(const double a0, const class ROL::Vector<double> & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdVector<double,double> *>(this), "axpy");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StdVector::axpy(a0, a1);
	}
	void scale(const double a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdVector<double,double> *>(this), "scale");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StdVector::scale(a0);
	}
	double dot(const class ROL::Vector<double> & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdVector<double,double> *>(this), "dot");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return StdVector::dot(a0);
	}
	double norm() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdVector<double,double> *>(this), "norm");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return StdVector::norm();
	}
	class Teuchos::RCP<class ROL::Vector<double> > clone() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdVector<double,double> *>(this), "clone");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<class Teuchos::RCP<class ROL::Vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class Teuchos::RCP<class ROL::Vector<double> >> caster;
				return pybind11::detail::cast_ref<class Teuchos::RCP<class ROL::Vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class Teuchos::RCP<class ROL::Vector<double> >>(std::move(o));
		}
		return StdVector::clone();
	}
	class Teuchos::RCP<class ROL::Vector<double> > basis(const int a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdVector<double,double> *>(this), "basis");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<class Teuchos::RCP<class ROL::Vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class Teuchos::RCP<class ROL::Vector<double> >> caster;
				return pybind11::detail::cast_ref<class Teuchos::RCP<class ROL::Vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class Teuchos::RCP<class ROL::Vector<double> >>(std::move(o));
		}
		return StdVector::basis(a0);
	}
	int dimension() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdVector<double,double> *>(this), "dimension");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<int>::value) {
				static pybind11::detail::override_caster_t<int> caster;
				return pybind11::detail::cast_ref<int>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<int>(std::move(o));
		}
		return StdVector::dimension();
	}
	void applyUnary(const class ROL::Elementwise::UnaryFunction<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdVector<double,double> *>(this), "applyUnary");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StdVector::applyUnary(a0);
	}
	void applyBinary(const class ROL::Elementwise::BinaryFunction<double> & a0, const class ROL::Vector<double> & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdVector<double,double> *>(this), "applyBinary");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StdVector::applyBinary(a0, a1);
	}
	double reduce(const class ROL::Elementwise::ReductionOp<double> & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdVector<double,double> *>(this), "reduce");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return StdVector::reduce(a0);
	}
	void setScalar(const double a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdVector<double,double> *>(this), "setScalar");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StdVector::setScalar(a0);
	}
	void randomize(const double a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdVector<double,double> *>(this), "randomize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StdVector::randomize(a0, a1);
	}
	void print(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdVector<double,double> *>(this), "print");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StdVector::print(a0);
	}
	void zero() override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdVector<double,double> *>(this), "zero");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Vector::zero();
	}
	const class ROL::Vector<double> & dual() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdVector<double,double> *>(this), "dual");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<const class ROL::Vector<double> &>::value) {
				static pybind11::detail::override_caster_t<const class ROL::Vector<double> &> caster;
				return pybind11::detail::cast_ref<const class ROL::Vector<double> &>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<const class ROL::Vector<double> &>(std::move(o));
		}
		return Vector::dual();
	}
	double apply(const class ROL::Vector<double> & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdVector<double,double> *>(this), "apply");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Vector::apply(a0);
	}
	class std::vector<double> checkVector(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool a2, std::ostream & a3) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdVector<double,double> *>(this), "checkVector");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Vector::checkVector(a0, a1, a2, a3);
	}
};

// ROL::RiskVector file:ROL_RiskVector.hpp line:20
struct PyCallBack_ROL_RiskVector_double_t : public ROL::RiskVector<double> {
	using ROL::RiskVector<double>::RiskVector;

	void set(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskVector<double> *>(this), "set");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskVector::set(a0);
	}
	void plus(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskVector<double> *>(this), "plus");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskVector::plus(a0);
	}
	void scale(const double a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskVector<double> *>(this), "scale");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskVector::scale(a0);
	}
	void axpy(const double a0, const class ROL::Vector<double> & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskVector<double> *>(this), "axpy");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskVector::axpy(a0, a1);
	}
	double dot(const class ROL::Vector<double> & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskVector<double> *>(this), "dot");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RiskVector::dot(a0);
	}
	double norm() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskVector<double> *>(this), "norm");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RiskVector::norm();
	}
	class Teuchos::RCP<class ROL::Vector<double> > clone() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskVector<double> *>(this), "clone");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<class Teuchos::RCP<class ROL::Vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class Teuchos::RCP<class ROL::Vector<double> >> caster;
				return pybind11::detail::cast_ref<class Teuchos::RCP<class ROL::Vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class Teuchos::RCP<class ROL::Vector<double> >>(std::move(o));
		}
		return RiskVector::clone();
	}
	const class ROL::Vector<double> & dual() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskVector<double> *>(this), "dual");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<const class ROL::Vector<double> &>::value) {
				static pybind11::detail::override_caster_t<const class ROL::Vector<double> &> caster;
				return pybind11::detail::cast_ref<const class ROL::Vector<double> &>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<const class ROL::Vector<double> &>(std::move(o));
		}
		return RiskVector::dual();
	}
	class Teuchos::RCP<class ROL::Vector<double> > basis(const int a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskVector<double> *>(this), "basis");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<class Teuchos::RCP<class ROL::Vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class Teuchos::RCP<class ROL::Vector<double> >> caster;
				return pybind11::detail::cast_ref<class Teuchos::RCP<class ROL::Vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class Teuchos::RCP<class ROL::Vector<double> >>(std::move(o));
		}
		return RiskVector::basis(a0);
	}
	void applyUnary(const class ROL::Elementwise::UnaryFunction<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskVector<double> *>(this), "applyUnary");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskVector::applyUnary(a0);
	}
	void applyBinary(const class ROL::Elementwise::BinaryFunction<double> & a0, const class ROL::Vector<double> & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskVector<double> *>(this), "applyBinary");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskVector::applyBinary(a0, a1);
	}
	double reduce(const class ROL::Elementwise::ReductionOp<double> & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskVector<double> *>(this), "reduce");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RiskVector::reduce(a0);
	}
	void setScalar(const double a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskVector<double> *>(this), "setScalar");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskVector::setScalar(a0);
	}
	void randomize(const double a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskVector<double> *>(this), "randomize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskVector::randomize(a0, a1);
	}
	int dimension() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskVector<double> *>(this), "dimension");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<int>::value) {
				static pybind11::detail::override_caster_t<int> caster;
				return pybind11::detail::cast_ref<int>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<int>(std::move(o));
		}
		return RiskVector::dimension();
	}
	void zero() override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskVector<double> *>(this), "zero");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Vector::zero();
	}
	double apply(const class ROL::Vector<double> & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskVector<double> *>(this), "apply");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Vector::apply(a0);
	}
	void print(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskVector<double> *>(this), "print");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Vector::print(a0);
	}
	class std::vector<double> checkVector(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool a2, std::ostream & a3) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskVector<double> *>(this), "checkVector");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Vector::checkVector(a0, a1, a2, a3);
	}
};

// ROL::PositiveFunction file:ROL_PositiveFunction.hpp line:16
struct PyCallBack_ROL_PositiveFunction_double_t : public ROL::PositiveFunction<double> {
	using ROL::PositiveFunction<double>::PositiveFunction;

	double evaluate(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PositiveFunction<double> *>(this), "evaluate");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		pybind11::pybind11_fail("Tried to call pure virtual function \"PositiveFunction::evaluate\"");
	}
};

// ROL::Dirac file:ROL_Dirac.hpp line:19
struct PyCallBack_ROL_Dirac_double_t : public ROL::Dirac<double> {
	using ROL::Dirac<double>::Dirac;

	double evaluatePDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Dirac<double> *>(this), "evaluatePDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Dirac::evaluatePDF(a0);
	}
	double evaluateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Dirac<double> *>(this), "evaluateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Dirac::evaluateCDF(a0);
	}
	double integrateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Dirac<double> *>(this), "integrateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Dirac::integrateCDF(a0);
	}
	double invertCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Dirac<double> *>(this), "invertCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Dirac::invertCDF(a0);
	}
	double moment(const unsigned long a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Dirac<double> *>(this), "moment");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Dirac::moment(a0);
	}
	double lowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Dirac<double> *>(this), "lowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Dirac::lowerBound();
	}
	double upperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Dirac<double> *>(this), "upperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Dirac::upperBound();
	}
	void test(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Dirac<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Dirac::test(a0);
	}
};

// ROL::Gaussian file:ROL_Gaussian.hpp line:19
struct PyCallBack_ROL_Gaussian_double_t : public ROL::Gaussian<double> {
	using ROL::Gaussian<double>::Gaussian;

	double evaluatePDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Gaussian<double> *>(this), "evaluatePDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Gaussian::evaluatePDF(a0);
	}
	double evaluateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Gaussian<double> *>(this), "evaluateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Gaussian::evaluateCDF(a0);
	}
	double integrateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Gaussian<double> *>(this), "integrateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Gaussian::integrateCDF(a0);
	}
	double invertCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Gaussian<double> *>(this), "invertCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Gaussian::invertCDF(a0);
	}
	double moment(const unsigned long a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Gaussian<double> *>(this), "moment");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Gaussian::moment(a0);
	}
	double lowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Gaussian<double> *>(this), "lowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Gaussian::lowerBound();
	}
	double upperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Gaussian<double> *>(this), "upperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Gaussian::upperBound();
	}
	void test(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Gaussian<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Gaussian::test(a0);
	}
};

// ROL::TruncatedGaussian file:ROL_TruncatedGaussian.hpp line:21
struct PyCallBack_ROL_TruncatedGaussian_double_t : public ROL::TruncatedGaussian<double> {
	using ROL::TruncatedGaussian<double>::TruncatedGaussian;

	double evaluatePDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::TruncatedGaussian<double> *>(this), "evaluatePDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return TruncatedGaussian::evaluatePDF(a0);
	}
	double evaluateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::TruncatedGaussian<double> *>(this), "evaluateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return TruncatedGaussian::evaluateCDF(a0);
	}
	double integrateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::TruncatedGaussian<double> *>(this), "integrateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return TruncatedGaussian::integrateCDF(a0);
	}
	double invertCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::TruncatedGaussian<double> *>(this), "invertCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return TruncatedGaussian::invertCDF(a0);
	}
	double moment(const unsigned long a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::TruncatedGaussian<double> *>(this), "moment");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return TruncatedGaussian::moment(a0);
	}
	double lowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::TruncatedGaussian<double> *>(this), "lowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return TruncatedGaussian::lowerBound();
	}
	double upperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::TruncatedGaussian<double> *>(this), "upperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return TruncatedGaussian::upperBound();
	}
	void test(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::TruncatedGaussian<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return TruncatedGaussian::test(a0);
	}
};

// ROL::Uniform file:ROL_Uniform.hpp line:19
struct PyCallBack_ROL_Uniform_double_t : public ROL::Uniform<double> {
	using ROL::Uniform<double>::Uniform;

	double evaluatePDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Uniform<double> *>(this), "evaluatePDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Uniform::evaluatePDF(a0);
	}
	double evaluateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Uniform<double> *>(this), "evaluateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Uniform::evaluateCDF(a0);
	}
	double integrateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Uniform<double> *>(this), "integrateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Uniform::integrateCDF(a0);
	}
	double invertCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Uniform<double> *>(this), "invertCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Uniform::invertCDF(a0);
	}
	double moment(const unsigned long a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Uniform<double> *>(this), "moment");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Uniform::moment(a0);
	}
	double lowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Uniform<double> *>(this), "lowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Uniform::lowerBound();
	}
	double upperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Uniform<double> *>(this), "upperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Uniform::upperBound();
	}
	void test(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Uniform<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Uniform::test(a0);
	}
};

// ROL::Logistic file:ROL_Logistic.hpp line:19
struct PyCallBack_ROL_Logistic_double_t : public ROL::Logistic<double> {
	using ROL::Logistic<double>::Logistic;

	double evaluatePDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Logistic<double> *>(this), "evaluatePDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Logistic::evaluatePDF(a0);
	}
	double evaluateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Logistic<double> *>(this), "evaluateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Logistic::evaluateCDF(a0);
	}
	double integrateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Logistic<double> *>(this), "integrateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Logistic::integrateCDF(a0);
	}
	double invertCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Logistic<double> *>(this), "invertCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Logistic::invertCDF(a0);
	}
	double moment(const unsigned long a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Logistic<double> *>(this), "moment");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Logistic::moment(a0);
	}
	double lowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Logistic<double> *>(this), "lowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Logistic::lowerBound();
	}
	double upperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Logistic<double> *>(this), "upperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Logistic::upperBound();
	}
	void test(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Logistic<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Logistic::test(a0);
	}
};

// ROL::Triangle file:ROL_Triangle.hpp line:19
struct PyCallBack_ROL_Triangle_double_t : public ROL::Triangle<double> {
	using ROL::Triangle<double>::Triangle;

	double evaluatePDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Triangle<double> *>(this), "evaluatePDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Triangle::evaluatePDF(a0);
	}
	double evaluateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Triangle<double> *>(this), "evaluateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Triangle::evaluateCDF(a0);
	}
	double integrateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Triangle<double> *>(this), "integrateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Triangle::integrateCDF(a0);
	}
	double invertCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Triangle<double> *>(this), "invertCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Triangle::invertCDF(a0);
	}
	double moment(const unsigned long a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Triangle<double> *>(this), "moment");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Triangle::moment(a0);
	}
	double lowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Triangle<double> *>(this), "lowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Triangle::lowerBound();
	}
	double upperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Triangle<double> *>(this), "upperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Triangle::upperBound();
	}
	void test(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Triangle<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Triangle::test(a0);
	}
};

// ROL::Parabolic file:ROL_Parabolic.hpp line:19
struct PyCallBack_ROL_Parabolic_double_t : public ROL::Parabolic<double> {
	using ROL::Parabolic<double>::Parabolic;

	double evaluatePDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Parabolic<double> *>(this), "evaluatePDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Parabolic::evaluatePDF(a0);
	}
	double evaluateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Parabolic<double> *>(this), "evaluateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Parabolic::evaluateCDF(a0);
	}
	double integrateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Parabolic<double> *>(this), "integrateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Parabolic::integrateCDF(a0);
	}
	double invertCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Parabolic<double> *>(this), "invertCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Parabolic::invertCDF(a0);
	}
	double moment(const unsigned long a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Parabolic<double> *>(this), "moment");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Parabolic::moment(a0);
	}
	double lowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Parabolic<double> *>(this), "lowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Parabolic::lowerBound();
	}
	double upperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Parabolic<double> *>(this), "upperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Parabolic::upperBound();
	}
	void test(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Parabolic<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Parabolic::test(a0);
	}
};

// ROL::RaisedCosine file:ROL_RaisedCosine.hpp line:19
struct PyCallBack_ROL_RaisedCosine_double_t : public ROL::RaisedCosine<double> {
	using ROL::RaisedCosine<double>::RaisedCosine;

	double evaluatePDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RaisedCosine<double> *>(this), "evaluatePDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RaisedCosine::evaluatePDF(a0);
	}
	double evaluateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RaisedCosine<double> *>(this), "evaluateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RaisedCosine::evaluateCDF(a0);
	}
	double integrateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RaisedCosine<double> *>(this), "integrateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RaisedCosine::integrateCDF(a0);
	}
	double invertCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RaisedCosine<double> *>(this), "invertCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RaisedCosine::invertCDF(a0);
	}
	double moment(const unsigned long a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RaisedCosine<double> *>(this), "moment");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RaisedCosine::moment(a0);
	}
	double lowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RaisedCosine<double> *>(this), "lowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RaisedCosine::lowerBound();
	}
	double upperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RaisedCosine<double> *>(this), "upperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RaisedCosine::upperBound();
	}
	void test(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RaisedCosine<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RaisedCosine::test(a0);
	}
};

// ROL::Laplace file:ROL_Laplace.hpp line:19
struct PyCallBack_ROL_Laplace_double_t : public ROL::Laplace<double> {
	using ROL::Laplace<double>::Laplace;

	double evaluatePDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Laplace<double> *>(this), "evaluatePDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Laplace::evaluatePDF(a0);
	}
	double evaluateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Laplace<double> *>(this), "evaluateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Laplace::evaluateCDF(a0);
	}
	double integrateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Laplace<double> *>(this), "integrateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Laplace::integrateCDF(a0);
	}
	double invertCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Laplace<double> *>(this), "invertCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Laplace::invertCDF(a0);
	}
	double moment(const unsigned long a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Laplace<double> *>(this), "moment");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Laplace::moment(a0);
	}
	double lowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Laplace<double> *>(this), "lowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Laplace::lowerBound();
	}
	double upperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Laplace<double> *>(this), "upperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Laplace::upperBound();
	}
	void test(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Laplace<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Laplace::test(a0);
	}
};

// ROL::Cauchy file:ROL_Cauchy.hpp line:19
struct PyCallBack_ROL_Cauchy_double_t : public ROL::Cauchy<double> {
	using ROL::Cauchy<double>::Cauchy;

	double evaluatePDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Cauchy<double> *>(this), "evaluatePDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Cauchy::evaluatePDF(a0);
	}
	double evaluateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Cauchy<double> *>(this), "evaluateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Cauchy::evaluateCDF(a0);
	}
	double integrateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Cauchy<double> *>(this), "integrateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Cauchy::integrateCDF(a0);
	}
	double invertCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Cauchy<double> *>(this), "invertCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Cauchy::invertCDF(a0);
	}
	double moment(const unsigned long a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Cauchy<double> *>(this), "moment");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Cauchy::moment(a0);
	}
	double lowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Cauchy<double> *>(this), "lowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Cauchy::lowerBound();
	}
	double upperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Cauchy<double> *>(this), "upperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Cauchy::upperBound();
	}
	void test(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Cauchy<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Cauchy::test(a0);
	}
};

// ROL::Smale file:ROL_Smale.hpp line:19
struct PyCallBack_ROL_Smale_double_t : public ROL::Smale<double> {
	using ROL::Smale<double>::Smale;

	double evaluatePDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Smale<double> *>(this), "evaluatePDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Smale::evaluatePDF(a0);
	}
	double evaluateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Smale<double> *>(this), "evaluateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Smale::evaluateCDF(a0);
	}
	double integrateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Smale<double> *>(this), "integrateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Smale::integrateCDF(a0);
	}
	double invertCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Smale<double> *>(this), "invertCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Smale::invertCDF(a0);
	}
	double moment(const unsigned long a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Smale<double> *>(this), "moment");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Smale::moment(a0);
	}
	double lowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Smale<double> *>(this), "lowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Smale::lowerBound();
	}
	double upperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Smale<double> *>(this), "upperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Smale::upperBound();
	}
	void test(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Smale<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Smale::test(a0);
	}
};

// ROL::Arcsine file:ROL_Arcsine.hpp line:19
struct PyCallBack_ROL_Arcsine_double_t : public ROL::Arcsine<double> {
	using ROL::Arcsine<double>::Arcsine;

	double evaluatePDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Arcsine<double> *>(this), "evaluatePDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Arcsine::evaluatePDF(a0);
	}
	double evaluateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Arcsine<double> *>(this), "evaluateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Arcsine::evaluateCDF(a0);
	}
	double integrateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Arcsine<double> *>(this), "integrateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Arcsine::integrateCDF(a0);
	}
	double invertCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Arcsine<double> *>(this), "invertCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Arcsine::invertCDF(a0);
	}
	double moment(const unsigned long a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Arcsine<double> *>(this), "moment");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Arcsine::moment(a0);
	}
	double lowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Arcsine<double> *>(this), "lowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Arcsine::lowerBound();
	}
	double upperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Arcsine<double> *>(this), "upperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Arcsine::upperBound();
	}
	void test(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Arcsine<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Arcsine::test(a0);
	}
};

// ROL::Kumaraswamy file:ROL_Kumaraswamy.hpp line:21
struct PyCallBack_ROL_Kumaraswamy_double_t : public ROL::Kumaraswamy<double> {
	using ROL::Kumaraswamy<double>::Kumaraswamy;

	double evaluatePDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Kumaraswamy<double> *>(this), "evaluatePDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Kumaraswamy::evaluatePDF(a0);
	}
	double evaluateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Kumaraswamy<double> *>(this), "evaluateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Kumaraswamy::evaluateCDF(a0);
	}
	double integrateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Kumaraswamy<double> *>(this), "integrateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Kumaraswamy::integrateCDF(a0);
	}
	double invertCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Kumaraswamy<double> *>(this), "invertCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Kumaraswamy::invertCDF(a0);
	}
	double moment(const unsigned long a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Kumaraswamy<double> *>(this), "moment");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Kumaraswamy::moment(a0);
	}
	double lowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Kumaraswamy<double> *>(this), "lowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Kumaraswamy::lowerBound();
	}
	double upperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Kumaraswamy<double> *>(this), "upperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Kumaraswamy::upperBound();
	}
	void test(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Kumaraswamy<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Kumaraswamy::test(a0);
	}
};

// ROL::Exponential file:ROL_Exponential.hpp line:19
struct PyCallBack_ROL_Exponential_double_t : public ROL::Exponential<double> {
	using ROL::Exponential<double>::Exponential;

	double evaluatePDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Exponential<double> *>(this), "evaluatePDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Exponential::evaluatePDF(a0);
	}
	double evaluateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Exponential<double> *>(this), "evaluateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Exponential::evaluateCDF(a0);
	}
	double integrateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Exponential<double> *>(this), "integrateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Exponential::integrateCDF(a0);
	}
	double invertCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Exponential<double> *>(this), "invertCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Exponential::invertCDF(a0);
	}
	double moment(const unsigned long a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Exponential<double> *>(this), "moment");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Exponential::moment(a0);
	}
	double lowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Exponential<double> *>(this), "lowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Exponential::lowerBound();
	}
	double upperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Exponential<double> *>(this), "upperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Exponential::upperBound();
	}
	void test(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Exponential<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Exponential::test(a0);
	}
};

// ROL::TruncatedExponential file:ROL_TruncatedExponential.hpp line:19
struct PyCallBack_ROL_TruncatedExponential_double_t : public ROL::TruncatedExponential<double> {
	using ROL::TruncatedExponential<double>::TruncatedExponential;

	double evaluatePDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::TruncatedExponential<double> *>(this), "evaluatePDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return TruncatedExponential::evaluatePDF(a0);
	}
	double evaluateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::TruncatedExponential<double> *>(this), "evaluateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return TruncatedExponential::evaluateCDF(a0);
	}
	double integrateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::TruncatedExponential<double> *>(this), "integrateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return TruncatedExponential::integrateCDF(a0);
	}
	double invertCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::TruncatedExponential<double> *>(this), "invertCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return TruncatedExponential::invertCDF(a0);
	}
	double moment(const unsigned long a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::TruncatedExponential<double> *>(this), "moment");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return TruncatedExponential::moment(a0);
	}
	double lowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::TruncatedExponential<double> *>(this), "lowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return TruncatedExponential::lowerBound();
	}
	double upperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::TruncatedExponential<double> *>(this), "upperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return TruncatedExponential::upperBound();
	}
	void test(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::TruncatedExponential<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return TruncatedExponential::test(a0);
	}
};

// ROL::Gamma file:ROL_Gamma.hpp line:21
struct PyCallBack_ROL_Gamma_double_t : public ROL::Gamma<double> {
	using ROL::Gamma<double>::Gamma;

	double evaluatePDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Gamma<double> *>(this), "evaluatePDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Gamma::evaluatePDF(a0);
	}
	double evaluateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Gamma<double> *>(this), "evaluateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Gamma::evaluateCDF(a0);
	}
	double integrateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Gamma<double> *>(this), "integrateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Gamma::integrateCDF(a0);
	}
	double invertCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Gamma<double> *>(this), "invertCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Gamma::invertCDF(a0);
	}
	double moment(const unsigned long a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Gamma<double> *>(this), "moment");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Gamma::moment(a0);
	}
	double lowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Gamma<double> *>(this), "lowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Gamma::lowerBound();
	}
	double upperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Gamma<double> *>(this), "upperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Gamma::upperBound();
	}
	void test(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Gamma<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Gamma::test(a0);
	}
};

// ROL::Beta file:ROL_Beta.hpp line:21
struct PyCallBack_ROL_Beta_double_t : public ROL::Beta<double> {
	using ROL::Beta<double>::Beta;

	double evaluatePDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Beta<double> *>(this), "evaluatePDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Beta::evaluatePDF(a0);
	}
	double evaluateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Beta<double> *>(this), "evaluateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Beta::evaluateCDF(a0);
	}
	double integrateCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Beta<double> *>(this), "integrateCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Beta::integrateCDF(a0);
	}
	double invertCDF(const double a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Beta<double> *>(this), "invertCDF");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Beta::invertCDF(a0);
	}
	double moment(const unsigned long a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Beta<double> *>(this), "moment");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Beta::moment(a0);
	}
	double lowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Beta<double> *>(this), "lowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Beta::lowerBound();
	}
	double upperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Beta<double> *>(this), "upperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Beta::upperBound();
	}
	void test(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Beta<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Beta::test(a0);
	}
};

// ROL::PlusFunction file:ROL_PlusFunction.hpp line:21
struct PyCallBack_ROL_PlusFunction_double_t : public ROL::PlusFunction<double> {
	using ROL::PlusFunction<double>::PlusFunction;

	double evaluate(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::PlusFunction<double> *>(this), "evaluate");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return PlusFunction::evaluate(a0, a1);
	}
};

// ROL::CVaR file:ROL_CVaR.hpp line:44
struct PyCallBack_ROL_CVaR_double_t : public ROL::CVaR<double> {
	using ROL::CVaR<double>::CVaR;

	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CVaR<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return CVaR::updateValue(a0, a1, a2, a3);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CVaR<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return CVaR::updateGradient(a0, a1, a2, a3);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CVaR<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return CVaR::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CVaR<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return CVaR::getValue(a0, a1, a2);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CVaR<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return CVaR::getGradient(a0, a1, a2, a3, a4);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CVaR<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return CVaR::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CVaR<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CVaR<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CVaR<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CVaR<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CVaR<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::initialize(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CVaR<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CVaR<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::MixedCVaR file:ROL_MixedCVaR.hpp line:54
struct PyCallBack_ROL_MixedCVaR_double_t : public ROL::MixedCVaR<double> {
	using ROL::MixedCVaR<double>::MixedCVaR;

	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MixedCVaR<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MixedCVaR::initialize(a0);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MixedCVaR<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return MixedCVaR::computeStatistic(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MixedCVaR<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MixedCVaR::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MixedCVaR<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return MixedCVaR::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MixedCVaR<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MixedCVaR::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MixedCVaR<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MixedCVaR::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MixedCVaR<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MixedCVaR::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MixedCVaR<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MixedCVaR::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MixedCVaR<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MixedCVaR<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MixedCVaR<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MixedCVaR<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MixedCVaR<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
};

// ROL::SpectralRisk file:ROL_SpectralRisk.hpp line:55
struct PyCallBack_ROL_SpectralRisk_double_t : public ROL::SpectralRisk<double> {
	using ROL::SpectralRisk<double>::SpectralRisk;

	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SpectralRisk<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SpectralRisk<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::setHessVecStorage(a0, a1);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SpectralRisk<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::setSample(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SpectralRisk<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SpectralRisk<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::resetStorage(a0);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SpectralRisk<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::initialize(a0);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SpectralRisk<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return SpectralRisk::computeStatistic(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SpectralRisk<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::updateValue(a0, a1, a2, a3);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SpectralRisk<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::updateGradient(a0, a1, a2, a3);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SpectralRisk<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SpectralRisk<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return SpectralRisk::getValue(a0, a1, a2);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SpectralRisk<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::getGradient(a0, a1, a2, a3, a4);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SpectralRisk<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
};

// ROL::Quadrature1D file:ROL_Quadrature1D.hpp line:18
struct PyCallBack_ROL_Quadrature1D_double_t : public ROL::Quadrature1D<double> {
	using ROL::Quadrature1D<double>::Quadrature1D;

	class std::vector<class std::vector<double> > test(const bool a0, std::ostream & a1) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Quadrature1D<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		pybind11::pybind11_fail("Tried to call pure virtual function \"Quadrature1D::test\"");
	}
};

// ROL::GaussLegendreQuadrature file:ROL_GaussLegendreQuadrature.hpp line:18
struct PyCallBack_ROL_GaussLegendreQuadrature_double_t : public ROL::GaussLegendreQuadrature<double> {
	using ROL::GaussLegendreQuadrature<double>::GaussLegendreQuadrature;

	class std::vector<class std::vector<double> > test(const bool a0, std::ostream & a1) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::GaussLegendreQuadrature<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return GaussLegendreQuadrature::test(a0, a1);
	}
};

// ROL::Fejer2Quadrature file:ROL_Fejer2Quadrature.hpp line:18
struct PyCallBack_ROL_Fejer2Quadrature_double_t : public ROL::Fejer2Quadrature<double> {
	using ROL::Fejer2Quadrature<double>::Fejer2Quadrature;

	class std::vector<class std::vector<double> > test(const bool a0, std::ostream & a1) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Fejer2Quadrature<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Fejer2Quadrature::test(a0, a1);
	}
};

// ROL::SecondOrderCVaR file:ROL_SecondOrderCVaR.hpp line:51
struct PyCallBack_ROL_SecondOrderCVaR_double_t : public ROL::SecondOrderCVaR<double> {
	using ROL::SecondOrderCVaR<double>::SecondOrderCVaR;

	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SecondOrderCVaR<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SecondOrderCVaR<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::setHessVecStorage(a0, a1);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SecondOrderCVaR<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::setSample(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SecondOrderCVaR<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SecondOrderCVaR<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::resetStorage(a0);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SecondOrderCVaR<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::initialize(a0);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SecondOrderCVaR<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return SpectralRisk::computeStatistic(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SecondOrderCVaR<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::updateValue(a0, a1, a2, a3);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SecondOrderCVaR<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::updateGradient(a0, a1, a2, a3);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SecondOrderCVaR<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SecondOrderCVaR<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return SpectralRisk::getValue(a0, a1, a2);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SecondOrderCVaR<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::getGradient(a0, a1, a2, a3, a4);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SecondOrderCVaR<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
};

// ROL::GaussChebyshev1Quadrature file:ROL_GaussChebyshev1Quadrature.hpp line:18
struct PyCallBack_ROL_GaussChebyshev1Quadrature_double_t : public ROL::GaussChebyshev1Quadrature<double> {
	using ROL::GaussChebyshev1Quadrature<double>::GaussChebyshev1Quadrature;

	class std::vector<class std::vector<double> > test(const bool a0, std::ostream & a1) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::GaussChebyshev1Quadrature<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return GaussChebyshev1Quadrature::test(a0, a1);
	}
};

// ROL::GaussChebyshev2Quadrature file:ROL_GaussChebyshev2Quadrature.hpp line:19
struct PyCallBack_ROL_GaussChebyshev2Quadrature_double_t : public ROL::GaussChebyshev2Quadrature<double> {
	using ROL::GaussChebyshev2Quadrature<double>::GaussChebyshev2Quadrature;

	class std::vector<class std::vector<double> > test(const bool a0, std::ostream & a1) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::GaussChebyshev2Quadrature<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return GaussChebyshev2Quadrature::test(a0, a1);
	}
};

// ROL::GaussChebyshev3Quadrature file:ROL_GaussChebyshev3Quadrature.hpp line:19
struct PyCallBack_ROL_GaussChebyshev3Quadrature_double_t : public ROL::GaussChebyshev3Quadrature<double> {
	using ROL::GaussChebyshev3Quadrature<double>::GaussChebyshev3Quadrature;

	class std::vector<class std::vector<double> > test(const bool a0, std::ostream & a1) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::GaussChebyshev3Quadrature<double> *>(this), "test");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return GaussChebyshev3Quadrature::test(a0, a1);
	}
};

// ROL::ChebyshevSpectral file:ROL_ChebyshevSpectral.hpp line:63
struct PyCallBack_ROL_ChebyshevSpectral_double_t : public ROL::ChebyshevSpectral<double> {
	using ROL::ChebyshevSpectral<double>::ChebyshevSpectral;

	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ChebyshevSpectral<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ChebyshevSpectral<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::setHessVecStorage(a0, a1);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ChebyshevSpectral<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::setSample(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ChebyshevSpectral<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ChebyshevSpectral<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::resetStorage(a0);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ChebyshevSpectral<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::initialize(a0);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ChebyshevSpectral<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return SpectralRisk::computeStatistic(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ChebyshevSpectral<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::updateValue(a0, a1, a2, a3);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ChebyshevSpectral<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::updateGradient(a0, a1, a2, a3);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ChebyshevSpectral<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ChebyshevSpectral<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return SpectralRisk::getValue(a0, a1, a2);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ChebyshevSpectral<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::getGradient(a0, a1, a2, a3, a4);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ChebyshevSpectral<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SpectralRisk::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
};

// ROL::QuantileRadius file:ROL_QuantileRadius.hpp line:21
struct PyCallBack_ROL_QuantileRadius_double_t : public ROL::QuantileRadius<double> {
	using ROL::QuantileRadius<double>::QuantileRadius;

	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::QuantileRadius<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return QuantileRadius::initialize(a0);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::QuantileRadius<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return QuantileRadius::computeStatistic(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::QuantileRadius<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return QuantileRadius::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::QuantileRadius<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return QuantileRadius::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::QuantileRadius<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return QuantileRadius::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::QuantileRadius<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return QuantileRadius::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::QuantileRadius<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return QuantileRadius::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::QuantileRadius<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return QuantileRadius::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::QuantileRadius<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::QuantileRadius<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::QuantileRadius<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::QuantileRadius<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::QuantileRadius<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
};

// ROL::HMCR file:ROL_HMCR.hpp line:41
struct PyCallBack_ROL_HMCR_double_t : public ROL::HMCR<double> {
	using ROL::HMCR<double>::HMCR;

	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::HMCR<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return HMCR::initialize(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::HMCR<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return HMCR::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::HMCR<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return HMCR::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::HMCR<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return HMCR::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::HMCR<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return HMCR::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::HMCR<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return HMCR::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::HMCR<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return HMCR::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::HMCR<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::HMCR<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::HMCR<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::HMCR<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::HMCR<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::HMCR<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::EntropicRisk file:ROL_EntropicRisk.hpp line:32
struct PyCallBack_ROL_EntropicRisk_double_t : public ROL::EntropicRisk<double> {
	using ROL::EntropicRisk<double>::EntropicRisk;

	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::EntropicRisk<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return EntropicRisk::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::EntropicRisk<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return EntropicRisk::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::EntropicRisk<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return EntropicRisk::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::EntropicRisk<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return EntropicRisk::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::EntropicRisk<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return EntropicRisk::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::EntropicRisk<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return EntropicRisk::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::EntropicRisk<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::EntropicRisk<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::EntropicRisk<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::EntropicRisk<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::EntropicRisk<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::initialize(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::EntropicRisk<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::EntropicRisk<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::CoherentEntropicRisk file:ROL_CoherentEntropicRisk.hpp line:33
struct PyCallBack_ROL_CoherentEntropicRisk_double_t : public ROL::CoherentEntropicRisk<double> {
	using ROL::CoherentEntropicRisk<double>::CoherentEntropicRisk;

	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CoherentEntropicRisk<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return CoherentEntropicRisk::initialize(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CoherentEntropicRisk<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return CoherentEntropicRisk::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CoherentEntropicRisk<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return CoherentEntropicRisk::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CoherentEntropicRisk<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return CoherentEntropicRisk::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CoherentEntropicRisk<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return CoherentEntropicRisk::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CoherentEntropicRisk<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return CoherentEntropicRisk::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CoherentEntropicRisk<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return CoherentEntropicRisk::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CoherentEntropicRisk<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CoherentEntropicRisk<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CoherentEntropicRisk<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CoherentEntropicRisk<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CoherentEntropicRisk<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::CoherentEntropicRisk<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::AbsoluteValue file:ROL_AbsoluteValue.hpp line:28
struct PyCallBack_ROL_AbsoluteValue_double_t : public ROL::AbsoluteValue<double> {
	using ROL::AbsoluteValue<double>::AbsoluteValue;

	double evaluate(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::AbsoluteValue<double> *>(this), "evaluate");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return AbsoluteValue::evaluate(a0, a1);
	}
};

// ROL::MeanDeviationFromTarget file:ROL_MeanDeviationFromTarget.hpp line:42
struct PyCallBack_ROL_MeanDeviationFromTarget_double_t : public ROL::MeanDeviationFromTarget<double> {
	using ROL::MeanDeviationFromTarget<double>::MeanDeviationFromTarget;

	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviationFromTarget<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanDeviationFromTarget::initialize(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviationFromTarget<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanDeviationFromTarget::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviationFromTarget<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return MeanDeviationFromTarget::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviationFromTarget<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanDeviationFromTarget::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviationFromTarget<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanDeviationFromTarget::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviationFromTarget<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanDeviationFromTarget::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviationFromTarget<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanDeviationFromTarget::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviationFromTarget<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviationFromTarget<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviationFromTarget<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviationFromTarget<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviationFromTarget<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviationFromTarget<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::MeanDeviation file:ROL_MeanDeviation.hpp line:46
struct PyCallBack_ROL_MeanDeviation_double_t : public ROL::MeanDeviation<double> {
	using ROL::MeanDeviation<double>::MeanDeviation;

	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviation<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanDeviation::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviation<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanDeviation::setHessVecStorage(a0, a1);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviation<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanDeviation::initialize(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviation<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanDeviation::updateValue(a0, a1, a2, a3);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviation<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanDeviation::updateGradient(a0, a1, a2, a3);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviation<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanDeviation::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviation<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return MeanDeviation::getValue(a0, a1, a2);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviation<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanDeviation::getGradient(a0, a1, a2, a3, a4);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviation<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanDeviation::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviation<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviation<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviation<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanDeviation<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::MeanVarianceFromTarget file:ROL_MeanVarianceFromTarget.hpp line:43
struct PyCallBack_ROL_MeanVarianceFromTarget_double_t : public ROL::MeanVarianceFromTarget<double> {
	using ROL::MeanVarianceFromTarget<double>::MeanVarianceFromTarget;

	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVarianceFromTarget<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanVarianceFromTarget::updateValue(a0, a1, a2, a3);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVarianceFromTarget<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanVarianceFromTarget::updateGradient(a0, a1, a2, a3);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVarianceFromTarget<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanVarianceFromTarget::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVarianceFromTarget<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVarianceFromTarget<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVarianceFromTarget<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVarianceFromTarget<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVarianceFromTarget<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::initialize(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVarianceFromTarget<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVarianceFromTarget<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVarianceFromTarget<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::getValue(a0, a1, a2);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVarianceFromTarget<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::getGradient(a0, a1, a2, a3, a4);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVarianceFromTarget<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
};

// ROL::MeanVariance file:ROL_MeanVariance.hpp line:44
struct PyCallBack_ROL_MeanVariance_double_t : public ROL::MeanVariance<double> {
	using ROL::MeanVariance<double>::MeanVariance;

	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVariance<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanVariance::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVariance<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanVariance::setHessVecStorage(a0, a1);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVariance<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanVariance::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVariance<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return MeanVariance::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVariance<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanVariance::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVariance<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanVariance::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVariance<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanVariance::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVariance<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanVariance::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVariance<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVariance<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVariance<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::initialize(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVariance<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVariance<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::MeanSemiDeviation file:ROL_MeanSemiDeviation.hpp line:38
struct PyCallBack_ROL_MeanSemiDeviation_double_t : public ROL::MeanSemiDeviation<double> {
	using ROL::MeanSemiDeviation<double>::MeanSemiDeviation;

	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviation<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanSemiDeviation::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviation<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanSemiDeviation::setHessVecStorage(a0, a1);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviation<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanSemiDeviation::initialize(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviation<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanSemiDeviation::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviation<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return MeanSemiDeviation::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviation<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanSemiDeviation::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviation<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanSemiDeviation::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviation<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanSemiDeviation::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviation<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanSemiDeviation::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviation<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviation<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviation<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviation<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::MeanSemiDeviationFromTarget file:ROL_MeanSemiDeviationFromTarget.hpp line:38
struct PyCallBack_ROL_MeanSemiDeviationFromTarget_double_t : public ROL::MeanSemiDeviationFromTarget<double> {
	using ROL::MeanSemiDeviationFromTarget<double>::MeanSemiDeviationFromTarget;

	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviationFromTarget<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanSemiDeviationFromTarget::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviationFromTarget<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return MeanSemiDeviationFromTarget::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviationFromTarget<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanSemiDeviationFromTarget::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviationFromTarget<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanSemiDeviationFromTarget::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviationFromTarget<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanSemiDeviationFromTarget::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviationFromTarget<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanSemiDeviationFromTarget::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviationFromTarget<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviationFromTarget<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviationFromTarget<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviationFromTarget<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviationFromTarget<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::initialize(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviationFromTarget<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanSemiDeviationFromTarget<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::ExpectationQuad file:ROL_ExpectationQuad.hpp line:53
struct PyCallBack_ROL_ExpectationQuad_double_t : public ROL::ExpectationQuad<double> {
	using ROL::ExpectationQuad<double>::ExpectationQuad;

	double regret(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuad<double> *>(this), "regret");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		pybind11::pybind11_fail("Tried to call pure virtual function \"ExpectationQuad::regret\"");
	}
	double error(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuad<double> *>(this), "error");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return ExpectationQuad::error(a0, a1);
	}
	void check() override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuad<double> *>(this), "check");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuad::check();
	}
};

// ROL::ExpectationQuadRisk file:ROL_ExpectationQuadRisk.hpp line:55
struct PyCallBack_ROL_ExpectationQuadRisk_double_t : public ROL::ExpectationQuadRisk<double> {
	using ROL::ExpectationQuadRisk<double>::ExpectationQuadRisk;

	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRisk<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadRisk::updateValue(a0, a1, a2, a3);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRisk<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadRisk::updateGradient(a0, a1, a2, a3);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRisk<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadRisk::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRisk<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return ExpectationQuadRisk::getValue(a0, a1, a2);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRisk<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadRisk::getGradient(a0, a1, a2, a3, a4);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRisk<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadRisk::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRisk<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRisk<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRisk<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRisk<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRisk<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::initialize(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRisk<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRisk<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::LogQuantileQuadrangle file:ROL_LogQuantileQuadrangle.hpp line:42
struct PyCallBack_ROL_LogQuantileQuadrangle_double_t : public ROL::LogQuantileQuadrangle<double> {
	using ROL::LogQuantileQuadrangle<double>::LogQuantileQuadrangle;

	double error(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::LogQuantileQuadrangle<double> *>(this), "error");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return LogQuantileQuadrangle::error(a0, a1);
	}
	double regret(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::LogQuantileQuadrangle<double> *>(this), "regret");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return LogQuantileQuadrangle::regret(a0, a1);
	}
	void check() override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::LogQuantileQuadrangle<double> *>(this), "check");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return LogQuantileQuadrangle::check();
	}
};

// ROL::SmoothedWorstCaseQuadrangle file:ROL_SmoothedWorstCaseQuadrangle.hpp line:55
struct PyCallBack_ROL_SmoothedWorstCaseQuadrangle_double_t : public ROL::SmoothedWorstCaseQuadrangle<double> {
	using ROL::SmoothedWorstCaseQuadrangle<double>::SmoothedWorstCaseQuadrangle;

	double error(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SmoothedWorstCaseQuadrangle<double> *>(this), "error");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return SmoothedWorstCaseQuadrangle::error(a0, a1);
	}
	double regret(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SmoothedWorstCaseQuadrangle<double> *>(this), "regret");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return SmoothedWorstCaseQuadrangle::regret(a0, a1);
	}
	void check() override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SmoothedWorstCaseQuadrangle<double> *>(this), "check");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SmoothedWorstCaseQuadrangle::check();
	}
};

// ROL::TruncatedMeanQuadrangle file:ROL_TruncatedMeanQuadrangle.hpp line:18
struct PyCallBack_ROL_TruncatedMeanQuadrangle_double_t : public ROL::TruncatedMeanQuadrangle<double> {
	using ROL::TruncatedMeanQuadrangle<double>::TruncatedMeanQuadrangle;

	double error(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::TruncatedMeanQuadrangle<double> *>(this), "error");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return TruncatedMeanQuadrangle::error(a0, a1);
	}
	double regret(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::TruncatedMeanQuadrangle<double> *>(this), "regret");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return TruncatedMeanQuadrangle::regret(a0, a1);
	}
	void check() override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::TruncatedMeanQuadrangle<double> *>(this), "check");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return TruncatedMeanQuadrangle::check();
	}
};

// ROL::MoreauYosidaCVaR file:ROL_MoreauYosidaCVaR.hpp line:71
struct PyCallBack_ROL_MoreauYosidaCVaR_double_t : public ROL::MoreauYosidaCVaR<double> {
	using ROL::MoreauYosidaCVaR<double>::MoreauYosidaCVaR;

	double error(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MoreauYosidaCVaR<double> *>(this), "error");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return MoreauYosidaCVaR::error(a0, a1);
	}
	double regret(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MoreauYosidaCVaR<double> *>(this), "regret");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return MoreauYosidaCVaR::regret(a0, a1);
	}
	void check() override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MoreauYosidaCVaR<double> *>(this), "check");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MoreauYosidaCVaR::check();
	}
};

// ROL::GenMoreauYosidaCVaR file:ROL_GenMoreauYosidaCVaR.hpp line:71
struct PyCallBack_ROL_GenMoreauYosidaCVaR_double_t : public ROL::GenMoreauYosidaCVaR<double> {
	using ROL::GenMoreauYosidaCVaR<double>::GenMoreauYosidaCVaR;

	double error(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::GenMoreauYosidaCVaR<double> *>(this), "error");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return GenMoreauYosidaCVaR::error(a0, a1);
	}
	double regret(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::GenMoreauYosidaCVaR<double> *>(this), "regret");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return GenMoreauYosidaCVaR::regret(a0, a1);
	}
	void check() override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::GenMoreauYosidaCVaR<double> *>(this), "check");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return GenMoreauYosidaCVaR::check();
	}
};

// ROL::LogExponentialQuadrangle file:ROL_LogExponentialQuadrangle.hpp line:47
struct PyCallBack_ROL_LogExponentialQuadrangle_double_t : public ROL::LogExponentialQuadrangle<double> {
	using ROL::LogExponentialQuadrangle<double>::LogExponentialQuadrangle;

	double error(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::LogExponentialQuadrangle<double> *>(this), "error");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return LogExponentialQuadrangle::error(a0, a1);
	}
	double regret(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::LogExponentialQuadrangle<double> *>(this), "regret");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return LogExponentialQuadrangle::regret(a0, a1);
	}
	void check() override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::LogExponentialQuadrangle<double> *>(this), "check");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuad::check();
	}
};

// ROL::MeanVarianceQuadrangle file:ROL_MeanVarianceQuadrangle.hpp line:44
struct PyCallBack_ROL_MeanVarianceQuadrangle_double_t : public ROL::MeanVarianceQuadrangle<double> {
	using ROL::MeanVarianceQuadrangle<double>::MeanVarianceQuadrangle;

	double error(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVarianceQuadrangle<double> *>(this), "error");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return MeanVarianceQuadrangle::error(a0, a1);
	}
	double regret(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVarianceQuadrangle<double> *>(this), "regret");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return MeanVarianceQuadrangle::regret(a0, a1);
	}
	void check() override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanVarianceQuadrangle<double> *>(this), "check");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuad::check();
	}
};

// ROL::FDivergence file:ROL_FDivergence.hpp line:53
struct PyCallBack_ROL_FDivergence_double_t : public ROL::FDivergence<double> {
	using ROL::FDivergence<double>::FDivergence;

	double Fprimal(double a0, int a1) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::FDivergence<double> *>(this), "Fprimal");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		pybind11::pybind11_fail("Tried to call pure virtual function \"FDivergence::Fprimal\"");
	}
	double Fdual(double a0, int a1) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::FDivergence<double> *>(this), "Fdual");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		pybind11::pybind11_fail("Tried to call pure virtual function \"FDivergence::Fdual\"");
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::FDivergence<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return FDivergence::initialize(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::FDivergence<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return FDivergence::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::FDivergence<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return FDivergence::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::FDivergence<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return FDivergence::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::FDivergence<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return FDivergence::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::FDivergence<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return FDivergence::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::FDivergence<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return FDivergence::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::FDivergence<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::FDivergence<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::FDivergence<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::FDivergence<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::FDivergence<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::FDivergence<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::Chi2Divergence file:ROL_Chi2Divergence.hpp line:39
struct PyCallBack_ROL_Chi2Divergence_double_t : public ROL::Chi2Divergence<double> {
	using ROL::Chi2Divergence<double>::Chi2Divergence;

	double Fprimal(double a0, int a1) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Chi2Divergence<double> *>(this), "Fprimal");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Chi2Divergence::Fprimal(a0, a1);
	}
	double Fdual(double a0, int a1) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Chi2Divergence<double> *>(this), "Fdual");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Chi2Divergence::Fdual(a0, a1);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Chi2Divergence<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return FDivergence::initialize(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Chi2Divergence<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return FDivergence::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Chi2Divergence<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return FDivergence::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Chi2Divergence<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return FDivergence::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Chi2Divergence<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return FDivergence::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Chi2Divergence<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return FDivergence::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Chi2Divergence<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return FDivergence::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Chi2Divergence<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Chi2Divergence<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Chi2Divergence<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Chi2Divergence<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Chi2Divergence<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::Chi2Divergence<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::KLDivergence file:ROL_KLDivergence.hpp line:47
struct PyCallBack_ROL_KLDivergence_double_t : public ROL::KLDivergence<double> {
	using ROL::KLDivergence<double>::KLDivergence;

	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::KLDivergence<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return KLDivergence::initialize(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::KLDivergence<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return KLDivergence::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::KLDivergence<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return KLDivergence::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::KLDivergence<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return KLDivergence::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::KLDivergence<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return KLDivergence::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::KLDivergence<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return KLDivergence::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::KLDivergence<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return KLDivergence::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::KLDivergence<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::KLDivergence<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::KLDivergence<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::KLDivergence<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::KLDivergence<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::KLDivergence<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::ExpectationQuadDeviation file:ROL_ExpectationQuadDeviation.hpp line:55
struct PyCallBack_ROL_ExpectationQuadDeviation_double_t : public ROL::ExpectationQuadDeviation<double> {
	using ROL::ExpectationQuadDeviation<double>::ExpectationQuadDeviation;

	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadDeviation<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadDeviation::updateValue(a0, a1, a2, a3);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadDeviation<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadDeviation::updateGradient(a0, a1, a2, a3);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadDeviation<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadDeviation::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadDeviation<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return ExpectationQuadDeviation::getValue(a0, a1, a2);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadDeviation<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadDeviation::getGradient(a0, a1, a2, a3, a4);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadDeviation<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadDeviation::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadDeviation<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadDeviation<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadDeviation<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadDeviation<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadDeviation<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::initialize(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadDeviation<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadDeviation<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::QuantileQuadrangle file:ROL_QuantileQuadrangle.hpp line:63
struct PyCallBack_ROL_QuantileQuadrangle_double_t : public ROL::QuantileQuadrangle<double> {
	using ROL::QuantileQuadrangle<double>::QuantileQuadrangle;

	double error(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::QuantileQuadrangle<double> *>(this), "error");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return QuantileQuadrangle::error(a0, a1);
	}
	double regret(double a0, int a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::QuantileQuadrangle<double> *>(this), "regret");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return QuantileQuadrangle::regret(a0, a1);
	}
	void check() override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::QuantileQuadrangle<double> *>(this), "check");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return QuantileQuadrangle::check();
	}
};

// ROL::ExpectationQuadError file:ROL_ExpectationQuadError.hpp line:55
struct PyCallBack_ROL_ExpectationQuadError_double_t : public ROL::ExpectationQuadError<double> {
	using ROL::ExpectationQuadError<double>::ExpectationQuadError;

	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadError<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadError::updateValue(a0, a1, a2, a3);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadError<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadError::updateGradient(a0, a1, a2, a3);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadError<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadError::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadError<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return ExpectationQuadError::getValue(a0, a1, a2);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadError<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadError::getGradient(a0, a1, a2, a3, a4);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadError<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadError::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadError<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadError<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadError<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadError<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadError<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::initialize(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadError<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadError<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::ExpectationQuadRegret file:ROL_ExpectationQuadRegret.hpp line:55
struct PyCallBack_ROL_ExpectationQuadRegret_double_t : public ROL::ExpectationQuadRegret<double> {
	using ROL::ExpectationQuadRegret<double>::ExpectationQuadRegret;

	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRegret<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadRegret::updateValue(a0, a1, a2, a3);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRegret<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadRegret::updateGradient(a0, a1, a2, a3);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRegret<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadRegret::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRegret<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return ExpectationQuadRegret::getValue(a0, a1, a2);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRegret<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadRegret::getGradient(a0, a1, a2, a3, a4);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRegret<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ExpectationQuadRegret::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRegret<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRegret<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRegret<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRegret<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRegret<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::initialize(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRegret<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ExpectationQuadRegret<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::BPOE file:ROL_BPOE.hpp line:32
struct PyCallBack_ROL_BPOE_double_t : public ROL::BPOE<double> {
	using ROL::BPOE<double>::BPOE;

	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::BPOE<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return BPOE::initialize(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::BPOE<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return BPOE::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::BPOE<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return BPOE::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::BPOE<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return BPOE::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::BPOE<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return BPOE::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::BPOE<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return BPOE::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::BPOE<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return BPOE::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::BPOE<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::BPOE<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::BPOE<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::BPOE<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::BPOE<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::BPOE<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::SmoothedPOE file:ROL_SmoothedPOE.hpp line:32
struct PyCallBack_ROL_SmoothedPOE_double_t : public ROL::SmoothedPOE<double> {
	using ROL::SmoothedPOE<double>::SmoothedPOE;

	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SmoothedPOE<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SmoothedPOE::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SmoothedPOE<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return SmoothedPOE::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SmoothedPOE<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SmoothedPOE::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SmoothedPOE<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SmoothedPOE::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SmoothedPOE<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SmoothedPOE::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SmoothedPOE<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SmoothedPOE::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SmoothedPOE<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SmoothedPOE<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SmoothedPOE<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SmoothedPOE<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::resetStorage(a0);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SmoothedPOE<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::initialize(a0);
	}
	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SmoothedPOE<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setSample(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SmoothedPOE<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::ConvexCombinationRiskMeasure file:ROL_ConvexCombinationRiskMeasure.hpp line:34
struct PyCallBack_ROL_ConvexCombinationRiskMeasure_double_t : public ROL::ConvexCombinationRiskMeasure<double> {
	using ROL::ConvexCombinationRiskMeasure<double>::ConvexCombinationRiskMeasure;

	void setSample(const class std::vector<double> & a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConvexCombinationRiskMeasure<double> *>(this), "setSample");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ConvexCombinationRiskMeasure::setSample(a0, a1);
	}
	void resetStorage(bool a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConvexCombinationRiskMeasure<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ConvexCombinationRiskMeasure::resetStorage(a0);
	}
	void resetStorage(enum ROL::UpdateType a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConvexCombinationRiskMeasure<double> *>(this), "resetStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ConvexCombinationRiskMeasure::resetStorage(a0);
	}
	void initialize(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConvexCombinationRiskMeasure<double> *>(this), "initialize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ConvexCombinationRiskMeasure::initialize(a0);
	}
	void updateValue(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConvexCombinationRiskMeasure<double> *>(this), "updateValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ConvexCombinationRiskMeasure::updateValue(a0, a1, a2, a3);
	}
	double getValue(const class ROL::Vector<double> & a0, const class std::vector<double> & a1, class ROL::SampleGenerator<double> & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConvexCombinationRiskMeasure<double> *>(this), "getValue");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return ConvexCombinationRiskMeasure::getValue(a0, a1, a2);
	}
	void updateGradient(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConvexCombinationRiskMeasure<double> *>(this), "updateGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ConvexCombinationRiskMeasure::updateGradient(a0, a1, a2, a3);
	}
	void getGradient(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, class ROL::SampleGenerator<double> & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConvexCombinationRiskMeasure<double> *>(this), "getGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ConvexCombinationRiskMeasure::getGradient(a0, a1, a2, a3, a4);
	}
	void updateHessVec(class ROL::Objective<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConvexCombinationRiskMeasure<double> *>(this), "updateHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ConvexCombinationRiskMeasure::updateHessVec(a0, a1, a2, a3, a4, a5);
	}
	void getHessVec(class ROL::Vector<double> & a0, class std::vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const class ROL::Vector<double> & a4, const class std::vector<double> & a5, class ROL::SampleGenerator<double> & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConvexCombinationRiskMeasure<double> *>(this), "getHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ConvexCombinationRiskMeasure::getHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	void setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConvexCombinationRiskMeasure<double> *>(this), "setStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setStorage(a0, a1);
	}
	void setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > & a0, const class Teuchos::RCP<class ROL::VectorController<double> > & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConvexCombinationRiskMeasure<double> *>(this), "setHessVecStorage");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RandVarFunctional::setHessVecStorage(a0, a1);
	}
	double computeStatistic(const class Teuchos::RCP<const class std::vector<double> > & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConvexCombinationRiskMeasure<double> *>(this), "computeStatistic");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RandVarFunctional::computeStatistic(a0);
	}
};

// ROL::StochasticObjective file:ROL_StochasticObjective.hpp line:22
struct PyCallBack_ROL_StochasticObjective_double_t : public ROL::StochasticObjective<double> {
	using ROL::StochasticObjective<double>::StochasticObjective;

	void update(const class ROL::Vector<double> & a0, enum ROL::UpdateType a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StochasticObjective::update(a0, a1, a2);
	}
	void update(const class ROL::Vector<double> & a0, bool a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StochasticObjective::update(a0, a1, a2);
	}
	double value(const class ROL::Vector<double> & a0, double & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "value");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return StochasticObjective::value(a0, a1);
	}
	void gradient(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "gradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StochasticObjective::gradient(a0, a1, a2);
	}
	void hessVec(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "hessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StochasticObjective::hessVec(a0, a1, a2, a3);
	}
	void precond(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "precond");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StochasticObjective::precond(a0, a1, a2, a3);
	}
	double dirDeriv(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "dirDeriv");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Objective::dirDeriv(a0, a1, a2);
	}
	void invHessVec(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "invHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::invHessVec(a0, a1, a2, a3);
	}
	void prox(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "prox");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::prox(a0, a1, a2, a3);
	}
	void proxJacVec(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "proxJacVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::proxJacVec(a0, a1, a2, a3, a4);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool a2, std::ostream & a3, const int a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4, const int a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool a3, std::ostream & a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool a2, std::ostream & a3, const int a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4, const int a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool a3, std::ostream & a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<double> checkHessSym(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "checkHessSym");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Objective::checkHessSym(a0, a1, a2, a3, a4);
	}
	class std::vector<double> checkHessSym(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "checkHessSym");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Objective::checkHessSym(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkProxJacVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double a2, bool a3, std::ostream & a4, int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "checkProxJacVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkProxJacVec(a0, a1, a2, a3, a4, a5);
	}
	void setParameter(const class std::vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticObjective<double> *>(this), "setParameter");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::setParameter(a0);
	}
};

// ROL::SimulatedVector file:ROL_SimulatedVector.hpp line:34
struct PyCallBack_ROL_SimulatedVector_double_t : public ROL::SimulatedVector<double> {
	using ROL::SimulatedVector<double>::SimulatedVector;

	void set(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedVector<double> *>(this), "set");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SimulatedVector::set(a0);
	}
	void plus(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedVector<double> *>(this), "plus");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SimulatedVector::plus(a0);
	}
	void scale(const double a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedVector<double> *>(this), "scale");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SimulatedVector::scale(a0);
	}
	void axpy(const double a0, const class ROL::Vector<double> & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedVector<double> *>(this), "axpy");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SimulatedVector::axpy(a0, a1);
	}
	double dot(const class ROL::Vector<double> & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedVector<double> *>(this), "dot");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return SimulatedVector::dot(a0);
	}
	double norm() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedVector<double> *>(this), "norm");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return SimulatedVector::norm();
	}
	class Teuchos::RCP<class ROL::Vector<double> > clone() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedVector<double> *>(this), "clone");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<class Teuchos::RCP<class ROL::Vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class Teuchos::RCP<class ROL::Vector<double> >> caster;
				return pybind11::detail::cast_ref<class Teuchos::RCP<class ROL::Vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class Teuchos::RCP<class ROL::Vector<double> >>(std::move(o));
		}
		return SimulatedVector::clone();
	}
	const class ROL::Vector<double> & dual() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedVector<double> *>(this), "dual");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<const class ROL::Vector<double> &>::value) {
				static pybind11::detail::override_caster_t<const class ROL::Vector<double> &> caster;
				return pybind11::detail::cast_ref<const class ROL::Vector<double> &>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<const class ROL::Vector<double> &>(std::move(o));
		}
		return SimulatedVector::dual();
	}
	class Teuchos::RCP<class ROL::Vector<double> > basis(const int a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedVector<double> *>(this), "basis");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<class Teuchos::RCP<class ROL::Vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class Teuchos::RCP<class ROL::Vector<double> >> caster;
				return pybind11::detail::cast_ref<class Teuchos::RCP<class ROL::Vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class Teuchos::RCP<class ROL::Vector<double> >>(std::move(o));
		}
		return SimulatedVector::basis(a0);
	}
	int dimension() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedVector<double> *>(this), "dimension");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<int>::value) {
				static pybind11::detail::override_caster_t<int> caster;
				return pybind11::detail::cast_ref<int>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<int>(std::move(o));
		}
		return SimulatedVector::dimension();
	}
	void zero() override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedVector<double> *>(this), "zero");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SimulatedVector::zero();
	}
	void applyUnary(const class ROL::Elementwise::UnaryFunction<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedVector<double> *>(this), "applyUnary");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SimulatedVector::applyUnary(a0);
	}
	void applyBinary(const class ROL::Elementwise::BinaryFunction<double> & a0, const class ROL::Vector<double> & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedVector<double> *>(this), "applyBinary");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SimulatedVector::applyBinary(a0, a1);
	}
	double reduce(const class ROL::Elementwise::ReductionOp<double> & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedVector<double> *>(this), "reduce");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return SimulatedVector::reduce(a0);
	}
	void setScalar(const double a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedVector<double> *>(this), "setScalar");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SimulatedVector::setScalar(a0);
	}
	void randomize(const double a0, const double a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedVector<double> *>(this), "randomize");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SimulatedVector::randomize(a0, a1);
	}
	double apply(const class ROL::Vector<double> & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedVector<double> *>(this), "apply");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Vector::apply(a0);
	}
	void print(std::ostream & a0) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedVector<double> *>(this), "print");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Vector::print(a0);
	}
	class std::vector<double> checkVector(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool a2, std::ostream & a3) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedVector<double> *>(this), "checkVector");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Vector::checkVector(a0, a1, a2, a3);
	}
};

// ROL::AlmostSureConstraint file:ROL_AlmostSureConstraint.hpp line:21
struct PyCallBack_ROL_AlmostSureConstraint_double_t : public ROL::AlmostSureConstraint<double> {
	using ROL::AlmostSureConstraint<double>::AlmostSureConstraint;

	void update(const class ROL::Vector<double> & a0, bool a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::AlmostSureConstraint<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return AlmostSureConstraint::update(a0, a1, a2);
	}
	void update(const class ROL::Vector<double> & a0, enum ROL::UpdateType a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::AlmostSureConstraint<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return AlmostSureConstraint::update(a0, a1, a2);
	}
	void value(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::AlmostSureConstraint<double> *>(this), "value");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return AlmostSureConstraint::value(a0, a1, a2);
	}
	void applyJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::AlmostSureConstraint<double> *>(this), "applyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return AlmostSureConstraint::applyJacobian(a0, a1, a2, a3);
	}
	void applyAdjointJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::AlmostSureConstraint<double> *>(this), "applyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return AlmostSureConstraint::applyAdjointJacobian(a0, a1, a2, a3);
	}
	void applyAdjointHessian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::AlmostSureConstraint<double> *>(this), "applyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return AlmostSureConstraint::applyAdjointHessian(a0, a1, a2, a3, a4);
	}
	void applyPreconditioner(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::AlmostSureConstraint<double> *>(this), "applyPreconditioner");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return AlmostSureConstraint::applyPreconditioner(a0, a1, a2, a3, a4);
	}
	void applyAdjointJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::AlmostSureConstraint<double> *>(this), "applyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint::applyAdjointJacobian(a0, a1, a2, a3, a4);
	}
	class std::vector<double> solveAugmentedSystem(class ROL::Vector<double> & a0, class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::AlmostSureConstraint<double> *>(this), "solveAugmentedSystem");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Constraint::solveAugmentedSystem(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkApplyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::AlmostSureConstraint<double> *>(this), "checkApplyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4, const int a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::AlmostSureConstraint<double> *>(this), "checkApplyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::AlmostSureConstraint<double> *>(this), "checkApplyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	double checkAdjointConsistencyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::AlmostSureConstraint<double> *>(this), "checkAdjointConsistencyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint::checkAdjointConsistencyJacobian(a0, a1, a2, a3, a4);
	}
	double checkAdjointConsistencyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool a5, std::ostream & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::AlmostSureConstraint<double> *>(this), "checkAdjointConsistencyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint::checkAdjointConsistencyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointHessian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, const bool a5, std::ostream & a6, const int a7) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::AlmostSureConstraint<double> *>(this), "checkApplyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6, a7);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointHessian(a0, a1, a2, a3, a4, a5, a6, a7);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointHessian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5, const int a6, const int a7) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::AlmostSureConstraint<double> *>(this), "checkApplyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6, a7);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointHessian(a0, a1, a2, a3, a4, a5, a6, a7);
	}
	void setParameter(const class std::vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::AlmostSureConstraint<double> *>(this), "setParameter");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint::setParameter(a0);
	}
};

// ROL::MeanValueConstraint file:ROL_MeanValueConstraint.hpp line:19
struct PyCallBack_ROL_MeanValueConstraint_double_t : public ROL::MeanValueConstraint<double> {
	using ROL::MeanValueConstraint<double>::MeanValueConstraint;

	void update(const class ROL::Vector<double> & a0, bool a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueConstraint<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanValueConstraint::update(a0, a1, a2);
	}
	void update(const class ROL::Vector<double> & a0, enum ROL::UpdateType a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueConstraint<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanValueConstraint::update(a0, a1, a2);
	}
	void value(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueConstraint<double> *>(this), "value");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanValueConstraint::value(a0, a1, a2);
	}
	void applyJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueConstraint<double> *>(this), "applyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanValueConstraint::applyJacobian(a0, a1, a2, a3);
	}
	void applyAdjointJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueConstraint<double> *>(this), "applyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanValueConstraint::applyAdjointJacobian(a0, a1, a2, a3);
	}
	void applyAdjointHessian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueConstraint<double> *>(this), "applyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return MeanValueConstraint::applyAdjointHessian(a0, a1, a2, a3, a4);
	}
	void applyAdjointJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueConstraint<double> *>(this), "applyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint::applyAdjointJacobian(a0, a1, a2, a3, a4);
	}
	class std::vector<double> solveAugmentedSystem(class ROL::Vector<double> & a0, class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueConstraint<double> *>(this), "solveAugmentedSystem");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Constraint::solveAugmentedSystem(a0, a1, a2, a3, a4, a5);
	}
	void applyPreconditioner(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueConstraint<double> *>(this), "applyPreconditioner");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint::applyPreconditioner(a0, a1, a2, a3, a4);
	}
	class std::vector<class std::vector<double> > checkApplyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueConstraint<double> *>(this), "checkApplyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4, const int a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueConstraint<double> *>(this), "checkApplyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueConstraint<double> *>(this), "checkApplyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	double checkAdjointConsistencyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueConstraint<double> *>(this), "checkAdjointConsistencyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint::checkAdjointConsistencyJacobian(a0, a1, a2, a3, a4);
	}
	double checkAdjointConsistencyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool a5, std::ostream & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueConstraint<double> *>(this), "checkAdjointConsistencyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint::checkAdjointConsistencyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointHessian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, const bool a5, std::ostream & a6, const int a7) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueConstraint<double> *>(this), "checkApplyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6, a7);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointHessian(a0, a1, a2, a3, a4, a5, a6, a7);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointHessian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5, const int a6, const int a7) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueConstraint<double> *>(this), "checkApplyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6, a7);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointHessian(a0, a1, a2, a3, a4, a5, a6, a7);
	}
	void setParameter(const class std::vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::MeanValueConstraint<double> *>(this), "setParameter");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint::setParameter(a0);
	}
};

// ROL::RiskNeutralConstraint file:ROL_RiskNeutralConstraint.hpp line:21
struct PyCallBack_ROL_RiskNeutralConstraint_double_t : public ROL::RiskNeutralConstraint<double> {
	using ROL::RiskNeutralConstraint<double>::RiskNeutralConstraint;

	void update(const class ROL::Vector<double> & a0, bool a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskNeutralConstraint<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskNeutralConstraint::update(a0, a1, a2);
	}
	void update(const class ROL::Vector<double> & a0, enum ROL::UpdateType a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskNeutralConstraint<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskNeutralConstraint::update(a0, a1, a2);
	}
	void value(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskNeutralConstraint<double> *>(this), "value");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskNeutralConstraint::value(a0, a1, a2);
	}
	void applyJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskNeutralConstraint<double> *>(this), "applyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskNeutralConstraint::applyJacobian(a0, a1, a2, a3);
	}
	void applyAdjointJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskNeutralConstraint<double> *>(this), "applyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskNeutralConstraint::applyAdjointJacobian(a0, a1, a2, a3);
	}
	void applyAdjointHessian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskNeutralConstraint<double> *>(this), "applyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskNeutralConstraint::applyAdjointHessian(a0, a1, a2, a3, a4);
	}
	void applyAdjointJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskNeutralConstraint<double> *>(this), "applyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint::applyAdjointJacobian(a0, a1, a2, a3, a4);
	}
	class std::vector<double> solveAugmentedSystem(class ROL::Vector<double> & a0, class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskNeutralConstraint<double> *>(this), "solveAugmentedSystem");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Constraint::solveAugmentedSystem(a0, a1, a2, a3, a4, a5);
	}
	void applyPreconditioner(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskNeutralConstraint<double> *>(this), "applyPreconditioner");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint::applyPreconditioner(a0, a1, a2, a3, a4);
	}
	class std::vector<class std::vector<double> > checkApplyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskNeutralConstraint<double> *>(this), "checkApplyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4, const int a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskNeutralConstraint<double> *>(this), "checkApplyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskNeutralConstraint<double> *>(this), "checkApplyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	double checkAdjointConsistencyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskNeutralConstraint<double> *>(this), "checkAdjointConsistencyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint::checkAdjointConsistencyJacobian(a0, a1, a2, a3, a4);
	}
	double checkAdjointConsistencyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool a5, std::ostream & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskNeutralConstraint<double> *>(this), "checkAdjointConsistencyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint::checkAdjointConsistencyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointHessian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, const bool a5, std::ostream & a6, const int a7) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskNeutralConstraint<double> *>(this), "checkApplyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6, a7);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointHessian(a0, a1, a2, a3, a4, a5, a6, a7);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointHessian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5, const int a6, const int a7) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskNeutralConstraint<double> *>(this), "checkApplyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6, a7);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointHessian(a0, a1, a2, a3, a4, a5, a6, a7);
	}
	void setParameter(const class std::vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskNeutralConstraint<double> *>(this), "setParameter");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint::setParameter(a0);
	}
};

// ROL::ConstraintFromObjective file:ROL_ConstraintFromObjective.hpp line:30
struct PyCallBack_ROL_ConstraintFromObjective_double_t : public ROL::ConstraintFromObjective<double> {
	using ROL::ConstraintFromObjective<double>::ConstraintFromObjective;

	void setParameter(const class std::vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConstraintFromObjective<double> *>(this), "setParameter");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ConstraintFromObjective::setParameter(a0);
	}
	void update(const class ROL::Vector<double> & a0, enum ROL::UpdateType a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConstraintFromObjective<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ConstraintFromObjective::update(a0, a1, a2);
	}
	void update(const class ROL::Vector<double> & a0, bool a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConstraintFromObjective<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ConstraintFromObjective::update(a0, a1, a2);
	}
	void value(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConstraintFromObjective<double> *>(this), "value");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ConstraintFromObjective::value(a0, a1, a2);
	}
	void applyJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConstraintFromObjective<double> *>(this), "applyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ConstraintFromObjective::applyJacobian(a0, a1, a2, a3);
	}
	void applyAdjointJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConstraintFromObjective<double> *>(this), "applyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ConstraintFromObjective::applyAdjointJacobian(a0, a1, a2, a3);
	}
	void applyAdjointHessian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConstraintFromObjective<double> *>(this), "applyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return ConstraintFromObjective::applyAdjointHessian(a0, a1, a2, a3, a4);
	}
	void applyAdjointJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConstraintFromObjective<double> *>(this), "applyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint::applyAdjointJacobian(a0, a1, a2, a3, a4);
	}
	class std::vector<double> solveAugmentedSystem(class ROL::Vector<double> & a0, class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConstraintFromObjective<double> *>(this), "solveAugmentedSystem");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Constraint::solveAugmentedSystem(a0, a1, a2, a3, a4, a5);
	}
	void applyPreconditioner(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConstraintFromObjective<double> *>(this), "applyPreconditioner");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint::applyPreconditioner(a0, a1, a2, a3, a4);
	}
	class std::vector<class std::vector<double> > checkApplyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConstraintFromObjective<double> *>(this), "checkApplyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4, const int a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConstraintFromObjective<double> *>(this), "checkApplyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConstraintFromObjective<double> *>(this), "checkApplyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	double checkAdjointConsistencyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConstraintFromObjective<double> *>(this), "checkAdjointConsistencyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint::checkAdjointConsistencyJacobian(a0, a1, a2, a3, a4);
	}
	double checkAdjointConsistencyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool a5, std::ostream & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConstraintFromObjective<double> *>(this), "checkAdjointConsistencyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint::checkAdjointConsistencyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointHessian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, const bool a5, std::ostream & a6, const int a7) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConstraintFromObjective<double> *>(this), "checkApplyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6, a7);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointHessian(a0, a1, a2, a3, a4, a5, a6, a7);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointHessian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5, const int a6, const int a7) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::ConstraintFromObjective<double> *>(this), "checkApplyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6, a7);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointHessian(a0, a1, a2, a3, a4, a5, a6, a7);
	}
};

// ROL::StochasticConstraint file:ROL_StochasticConstraint.hpp line:20
struct PyCallBack_ROL_StochasticConstraint_double_t : public ROL::StochasticConstraint<double> {
	using ROL::StochasticConstraint<double>::StochasticConstraint;

	void update(const class ROL::Vector<double> & a0, enum ROL::UpdateType a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticConstraint<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StochasticConstraint::update(a0, a1, a2);
	}
	void update(const class ROL::Vector<double> & a0, bool a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticConstraint<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StochasticConstraint::update(a0, a1, a2);
	}
	void value(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticConstraint<double> *>(this), "value");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StochasticConstraint::value(a0, a1, a2);
	}
	void applyJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticConstraint<double> *>(this), "applyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StochasticConstraint::applyJacobian(a0, a1, a2, a3);
	}
	void applyAdjointJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticConstraint<double> *>(this), "applyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StochasticConstraint::applyAdjointJacobian(a0, a1, a2, a3);
	}
	void applyAdjointHessian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticConstraint<double> *>(this), "applyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StochasticConstraint::applyAdjointHessian(a0, a1, a2, a3, a4);
	}
	void applyAdjointJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticConstraint<double> *>(this), "applyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint::applyAdjointJacobian(a0, a1, a2, a3, a4);
	}
	class std::vector<double> solveAugmentedSystem(class ROL::Vector<double> & a0, class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticConstraint<double> *>(this), "solveAugmentedSystem");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Constraint::solveAugmentedSystem(a0, a1, a2, a3, a4, a5);
	}
	void applyPreconditioner(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticConstraint<double> *>(this), "applyPreconditioner");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint::applyPreconditioner(a0, a1, a2, a3, a4);
	}
	class std::vector<class std::vector<double> > checkApplyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticConstraint<double> *>(this), "checkApplyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4, const int a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticConstraint<double> *>(this), "checkApplyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticConstraint<double> *>(this), "checkApplyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	double checkAdjointConsistencyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticConstraint<double> *>(this), "checkAdjointConsistencyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint::checkAdjointConsistencyJacobian(a0, a1, a2, a3, a4);
	}
	double checkAdjointConsistencyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool a5, std::ostream & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticConstraint<double> *>(this), "checkAdjointConsistencyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint::checkAdjointConsistencyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointHessian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, const bool a5, std::ostream & a6, const int a7) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticConstraint<double> *>(this), "checkApplyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6, a7);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointHessian(a0, a1, a2, a3, a4, a5, a6, a7);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointHessian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5, const int a6, const int a7) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticConstraint<double> *>(this), "checkApplyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6, a7);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointHessian(a0, a1, a2, a3, a4, a5, a6, a7);
	}
	void setParameter(const class std::vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StochasticConstraint<double> *>(this), "setParameter");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint::setParameter(a0);
	}
};

// ROL::SimulatedBoundConstraint file:ROL_SimulatedBoundConstraint.hpp line:25
struct PyCallBack_ROL_SimulatedBoundConstraint_double_t : public ROL::SimulatedBoundConstraint<double> {
	using ROL::SimulatedBoundConstraint<double>::SimulatedBoundConstraint;

	void project(class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedBoundConstraint<double> *>(this), "project");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SimulatedBoundConstraint::project(a0);
	}
	void projectInterior(class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedBoundConstraint<double> *>(this), "projectInterior");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SimulatedBoundConstraint::projectInterior(a0);
	}
	void pruneUpperActive(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedBoundConstraint<double> *>(this), "pruneUpperActive");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SimulatedBoundConstraint::pruneUpperActive(a0, a1, a2);
	}
	void pruneUpperActive(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double a3, double a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedBoundConstraint<double> *>(this), "pruneUpperActive");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SimulatedBoundConstraint::pruneUpperActive(a0, a1, a2, a3, a4);
	}
	void pruneLowerActive(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedBoundConstraint<double> *>(this), "pruneLowerActive");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SimulatedBoundConstraint::pruneLowerActive(a0, a1, a2);
	}
	void pruneLowerActive(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double a3, double a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedBoundConstraint<double> *>(this), "pruneLowerActive");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SimulatedBoundConstraint::pruneLowerActive(a0, a1, a2, a3, a4);
	}
	const class Teuchos::RCP<const class ROL::Vector<double> > getLowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedBoundConstraint<double> *>(this), "getLowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<const class Teuchos::RCP<const class ROL::Vector<double> >>::value) {
				static pybind11::detail::override_caster_t<const class Teuchos::RCP<const class ROL::Vector<double> >> caster;
				return pybind11::detail::cast_ref<const class Teuchos::RCP<const class ROL::Vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<const class Teuchos::RCP<const class ROL::Vector<double> >>(std::move(o));
		}
		return SimulatedBoundConstraint::getLowerBound();
	}
	const class Teuchos::RCP<const class ROL::Vector<double> > getUpperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedBoundConstraint<double> *>(this), "getUpperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<const class Teuchos::RCP<const class ROL::Vector<double> >>::value) {
				static pybind11::detail::override_caster_t<const class Teuchos::RCP<const class ROL::Vector<double> >> caster;
				return pybind11::detail::cast_ref<const class Teuchos::RCP<const class ROL::Vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<const class Teuchos::RCP<const class ROL::Vector<double> >>(std::move(o));
		}
		return SimulatedBoundConstraint::getUpperBound();
	}
	bool isFeasible(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedBoundConstraint<double> *>(this), "isFeasible");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<bool>::value) {
				static pybind11::detail::override_caster_t<bool> caster;
				return pybind11::detail::cast_ref<bool>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<bool>(std::move(o));
		}
		return SimulatedBoundConstraint::isFeasible(a0);
	}
	void applyInverseScalingFunction(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedBoundConstraint<double> *>(this), "applyInverseScalingFunction");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SimulatedBoundConstraint::applyInverseScalingFunction(a0, a1, a2, a3);
	}
	void applyScalingFunctionJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::SimulatedBoundConstraint<double> *>(this), "applyScalingFunctionJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return SimulatedBoundConstraint::applyScalingFunctionJacobian(a0, a1, a2, a3);
	}
};

// ROL::StdBoundConstraint file:ROL_StdBoundConstraint.hpp line:24
struct PyCallBack_ROL_StdBoundConstraint_double_t : public ROL::StdBoundConstraint<double> {
	using ROL::StdBoundConstraint<double>::StdBoundConstraint;

	void project(class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdBoundConstraint<double> *>(this), "project");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StdBoundConstraint::project(a0);
	}
	void projectInterior(class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdBoundConstraint<double> *>(this), "projectInterior");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StdBoundConstraint::projectInterior(a0);
	}
	void pruneUpperActive(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdBoundConstraint<double> *>(this), "pruneUpperActive");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StdBoundConstraint::pruneUpperActive(a0, a1, a2);
	}
	void pruneUpperActive(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double a3, double a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdBoundConstraint<double> *>(this), "pruneUpperActive");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StdBoundConstraint::pruneUpperActive(a0, a1, a2, a3, a4);
	}
	void pruneLowerActive(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double a3, double a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdBoundConstraint<double> *>(this), "pruneLowerActive");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StdBoundConstraint::pruneLowerActive(a0, a1, a2, a3, a4);
	}
	void pruneLowerActive(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdBoundConstraint<double> *>(this), "pruneLowerActive");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StdBoundConstraint::pruneLowerActive(a0, a1, a2);
	}
	bool isFeasible(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdBoundConstraint<double> *>(this), "isFeasible");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<bool>::value) {
				static pybind11::detail::override_caster_t<bool> caster;
				return pybind11::detail::cast_ref<bool>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<bool>(std::move(o));
		}
		return StdBoundConstraint::isFeasible(a0);
	}
	void applyInverseScalingFunction(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdBoundConstraint<double> *>(this), "applyInverseScalingFunction");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StdBoundConstraint::applyInverseScalingFunction(a0, a1, a2, a3);
	}
	void applyScalingFunctionJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdBoundConstraint<double> *>(this), "applyScalingFunctionJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return StdBoundConstraint::applyScalingFunctionJacobian(a0, a1, a2, a3);
	}
	const class Teuchos::RCP<const class ROL::Vector<double> > getLowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdBoundConstraint<double> *>(this), "getLowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<const class Teuchos::RCP<const class ROL::Vector<double> >>::value) {
				static pybind11::detail::override_caster_t<const class Teuchos::RCP<const class ROL::Vector<double> >> caster;
				return pybind11::detail::cast_ref<const class Teuchos::RCP<const class ROL::Vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<const class Teuchos::RCP<const class ROL::Vector<double> >>(std::move(o));
		}
		return BoundConstraint::getLowerBound();
	}
	const class Teuchos::RCP<const class ROL::Vector<double> > getUpperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::StdBoundConstraint<double> *>(this), "getUpperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<const class Teuchos::RCP<const class ROL::Vector<double> >>::value) {
				static pybind11::detail::override_caster_t<const class Teuchos::RCP<const class ROL::Vector<double> >> caster;
				return pybind11::detail::cast_ref<const class Teuchos::RCP<const class ROL::Vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<const class Teuchos::RCP<const class ROL::Vector<double> >>(std::move(o));
		}
		return BoundConstraint::getUpperBound();
	}
};

// ROL::RiskBoundConstraint file:ROL_RiskBoundConstraint.hpp line:20
struct PyCallBack_ROL_RiskBoundConstraint_double_t : public ROL::RiskBoundConstraint<double> {
	using ROL::RiskBoundConstraint<double>::RiskBoundConstraint;

	void project(class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskBoundConstraint<double> *>(this), "project");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskBoundConstraint::project(a0);
	}
	void projectInterior(class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskBoundConstraint<double> *>(this), "projectInterior");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskBoundConstraint::projectInterior(a0);
	}
	void pruneUpperActive(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskBoundConstraint<double> *>(this), "pruneUpperActive");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskBoundConstraint::pruneUpperActive(a0, a1, a2);
	}
	void pruneUpperActive(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double a3, double a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskBoundConstraint<double> *>(this), "pruneUpperActive");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskBoundConstraint::pruneUpperActive(a0, a1, a2, a3, a4);
	}
	void pruneLowerActive(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskBoundConstraint<double> *>(this), "pruneLowerActive");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskBoundConstraint::pruneLowerActive(a0, a1, a2);
	}
	void pruneLowerActive(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double a3, double a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskBoundConstraint<double> *>(this), "pruneLowerActive");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskBoundConstraint::pruneLowerActive(a0, a1, a2, a3, a4);
	}
	const class Teuchos::RCP<const class ROL::Vector<double> > getLowerBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskBoundConstraint<double> *>(this), "getLowerBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<const class Teuchos::RCP<const class ROL::Vector<double> >>::value) {
				static pybind11::detail::override_caster_t<const class Teuchos::RCP<const class ROL::Vector<double> >> caster;
				return pybind11::detail::cast_ref<const class Teuchos::RCP<const class ROL::Vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<const class Teuchos::RCP<const class ROL::Vector<double> >>(std::move(o));
		}
		return RiskBoundConstraint::getLowerBound();
	}
	const class Teuchos::RCP<const class ROL::Vector<double> > getUpperBound() const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskBoundConstraint<double> *>(this), "getUpperBound");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>();
			if (pybind11::detail::cast_is_temporary_value_reference<const class Teuchos::RCP<const class ROL::Vector<double> >>::value) {
				static pybind11::detail::override_caster_t<const class Teuchos::RCP<const class ROL::Vector<double> >> caster;
				return pybind11::detail::cast_ref<const class Teuchos::RCP<const class ROL::Vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<const class Teuchos::RCP<const class ROL::Vector<double> >>(std::move(o));
		}
		return RiskBoundConstraint::getUpperBound();
	}
	bool isFeasible(const class ROL::Vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskBoundConstraint<double> *>(this), "isFeasible");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<bool>::value) {
				static pybind11::detail::override_caster_t<bool> caster;
				return pybind11::detail::cast_ref<bool>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<bool>(std::move(o));
		}
		return RiskBoundConstraint::isFeasible(a0);
	}
	void applyInverseScalingFunction(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskBoundConstraint<double> *>(this), "applyInverseScalingFunction");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskBoundConstraint::applyInverseScalingFunction(a0, a1, a2, a3);
	}
	void applyScalingFunctionJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3) const override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskBoundConstraint<double> *>(this), "applyScalingFunctionJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskBoundConstraint::applyScalingFunctionJacobian(a0, a1, a2, a3);
	}
};

// ROL::RiskLessObjective file:ROL_RiskLessObjective.hpp line:19
struct PyCallBack_ROL_RiskLessObjective_double_t : public ROL::RiskLessObjective<double> {
	using ROL::RiskLessObjective<double>::RiskLessObjective;

	void update(const class ROL::Vector<double> & a0, enum ROL::UpdateType a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskLessObjective::update(a0, a1, a2);
	}
	void update(const class ROL::Vector<double> & a0, bool a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskLessObjective::update(a0, a1, a2);
	}
	double value(const class ROL::Vector<double> & a0, double & a1) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "value");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return RiskLessObjective::value(a0, a1);
	}
	void gradient(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "gradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskLessObjective::gradient(a0, a1, a2);
	}
	void hessVec(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "hessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskLessObjective::hessVec(a0, a1, a2, a3);
	}
	void precond(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "precond");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskLessObjective::precond(a0, a1, a2, a3);
	}
	void setParameter(const class std::vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "setParameter");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskLessObjective::setParameter(a0);
	}
	double dirDeriv(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "dirDeriv");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Objective::dirDeriv(a0, a1, a2);
	}
	void invHessVec(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "invHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::invHessVec(a0, a1, a2, a3);
	}
	void prox(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "prox");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::prox(a0, a1, a2, a3);
	}
	void proxJacVec(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "proxJacVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Objective::proxJacVec(a0, a1, a2, a3, a4);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool a2, std::ostream & a3, const int a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4, const int a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool a3, std::ostream & a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkGradient(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "checkGradient");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkGradient(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool a2, std::ostream & a3, const int a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4, const int a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool a3, std::ostream & a4, const int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkHessVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "checkHessVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkHessVec(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<double> checkHessSym(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "checkHessSym");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Objective::checkHessSym(a0, a1, a2, a3, a4);
	}
	class std::vector<double> checkHessSym(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "checkHessSym");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Objective::checkHessSym(a0, a1, a2, a3, a4, a5);
	}
	class std::vector<class std::vector<double> > checkProxJacVec(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double a2, bool a3, std::ostream & a4, int a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessObjective<double> *>(this), "checkProxJacVec");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Objective::checkProxJacVec(a0, a1, a2, a3, a4, a5);
	}
};

// ROL::RiskLessConstraint file:ROL_RiskLessConstraint.hpp line:19
struct PyCallBack_ROL_RiskLessConstraint_double_t : public ROL::RiskLessConstraint<double> {
	using ROL::RiskLessConstraint<double>::RiskLessConstraint;

	void update(const class ROL::Vector<double> & a0, enum ROL::UpdateType a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessConstraint<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskLessConstraint::update(a0, a1, a2);
	}
	void update(const class ROL::Vector<double> & a0, bool a1, int a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessConstraint<double> *>(this), "update");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskLessConstraint::update(a0, a1, a2);
	}
	void value(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double & a2) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessConstraint<double> *>(this), "value");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskLessConstraint::value(a0, a1, a2);
	}
	void applyJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessConstraint<double> *>(this), "applyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskLessConstraint::applyJacobian(a0, a1, a2, a3);
	}
	void applyAdjointJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, double & a3) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessConstraint<double> *>(this), "applyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskLessConstraint::applyAdjointJacobian(a0, a1, a2, a3);
	}
	void applyAdjointHessian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessConstraint<double> *>(this), "applyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskLessConstraint::applyAdjointHessian(a0, a1, a2, a3, a4);
	}
	void setParameter(const class std::vector<double> & a0) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessConstraint<double> *>(this), "setParameter");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return RiskLessConstraint::setParameter(a0);
	}
	void applyAdjointJacobian(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessConstraint<double> *>(this), "applyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint::applyAdjointJacobian(a0, a1, a2, a3, a4);
	}
	class std::vector<double> solveAugmentedSystem(class ROL::Vector<double> & a0, class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, double & a5) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessConstraint<double> *>(this), "solveAugmentedSystem");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<double>>::value) {
				static pybind11::detail::override_caster_t<class std::vector<double>> caster;
				return pybind11::detail::cast_ref<class std::vector<double>>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<double>>(std::move(o));
		}
		return Constraint::solveAugmentedSystem(a0, a1, a2, a3, a4, a5);
	}
	void applyPreconditioner(class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, double & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessConstraint<double> *>(this), "applyPreconditioner");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<void>::value) {
				static pybind11::detail::override_caster_t<void> caster;
				return pybind11::detail::cast_ref<void>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<void>(std::move(o));
		}
		return Constraint::applyPreconditioner(a0, a1, a2, a3, a4);
	}
	class std::vector<class std::vector<double> > checkApplyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessConstraint<double> *>(this), "checkApplyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4, const int a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessConstraint<double> *>(this), "checkApplyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5, const int a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessConstraint<double> *>(this), "checkApplyAdjointJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	double checkAdjointConsistencyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool a3, std::ostream & a4) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessConstraint<double> *>(this), "checkAdjointConsistencyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint::checkAdjointConsistencyJacobian(a0, a1, a2, a3, a4);
	}
	double checkAdjointConsistencyJacobian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class ROL::Vector<double> & a4, const bool a5, std::ostream & a6) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessConstraint<double> *>(this), "checkAdjointConsistencyJacobian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6);
			if (pybind11::detail::cast_is_temporary_value_reference<double>::value) {
				static pybind11::detail::override_caster_t<double> caster;
				return pybind11::detail::cast_ref<double>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<double>(std::move(o));
		}
		return Constraint::checkAdjointConsistencyJacobian(a0, a1, a2, a3, a4, a5, a6);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointHessian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const class std::vector<double> & a4, const bool a5, std::ostream & a6, const int a7) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessConstraint<double> *>(this), "checkApplyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6, a7);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointHessian(a0, a1, a2, a3, a4, a5, a6, a7);
	}
	class std::vector<class std::vector<double> > checkApplyAdjointHessian(const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool a4, std::ostream & a5, const int a6, const int a7) override {
		pybind11::gil_scoped_acquire gil;
		pybind11::function overload = pybind11::get_overload(static_cast<const ROL::RiskLessConstraint<double> *>(this), "checkApplyAdjointHessian");
		if (overload) {
			auto o = overload.operator()<pybind11::return_value_policy::reference>(a0, a1, a2, a3, a4, a5, a6, a7);
			if (pybind11::detail::cast_is_temporary_value_reference<class std::vector<class std::vector<double> >>::value) {
				static pybind11::detail::override_caster_t<class std::vector<class std::vector<double> >> caster;
				return pybind11::detail::cast_ref<class std::vector<class std::vector<double> >>(std::move(o), caster);
			}
			return pybind11::detail::cast_safe<class std::vector<class std::vector<double> >>(std::move(o));
		}
		return Constraint::checkApplyAdjointHessian(a0, a1, a2, a3, a4, a5, a6, a7);
	}
};

void bind_pyrol_50(std::function< pybind11::module &(std::string const &namespace_) > &M)
{
	{ // ROL::Distribution file:ROL_Distribution.hpp line:21
		pybind11::class_<ROL::Distribution<double>, Teuchos::RCP<ROL::Distribution<double>>, PyCallBack_ROL_Distribution_double_t> cl(M("ROL"), "Distribution_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](PyCallBack_ROL_Distribution_double_t const &o){ return new PyCallBack_ROL_Distribution_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::Distribution<double> const &o){ return new ROL::Distribution<double>(o); } ) );
		cl.def( pybind11::init( [](){ return new ROL::Distribution<double>(); }, [](){ return new PyCallBack_ROL_Distribution_double_t(); } ) );
		cl.def("evaluatePDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluatePDF, "C++: ROL::Distribution<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluateCDF, "C++: ROL::Distribution<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::integrateCDF, "C++: ROL::Distribution<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::invertCDF, "C++: ROL::Distribution<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Distribution<double>::*)(const unsigned long) const) &ROL::Distribution<double>::moment, "C++: ROL::Distribution<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::lowerBound, "C++: ROL::Distribution<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::upperBound, "C++: ROL::Distribution<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Distribution<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Distribution<double>::*)(std::ostream &) const) &ROL::Distribution<double>::test, "C++: ROL::Distribution<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Distribution<double> & (ROL::Distribution<double>::*)(const class ROL::Distribution<double> &)) &ROL::Distribution<double>::operator=, "C++: ROL::Distribution<double>::operator=(const class ROL::Distribution<double> &) --> class ROL::Distribution<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::Objective_SimOpt file:ROL_Objective_SimOpt.hpp line:25
		PYBIND11_TYPE_CASTER_BASE_HOLDER(ROL::Objective_SimOpt<double> , Teuchos::RCP<ROL::Objective_SimOpt<double>>)
		pybind11::class_<ROL::Objective_SimOpt<double>, Teuchos::RCP<ROL::Objective_SimOpt<double>>, PyCallBack_ROL_Objective_SimOpt_double_t, ROL::Objective<double>> cl(M("ROL"), "Objective_SimOpt_double_t", "", pybind11::module_local());
		cl.def(pybind11::init<PyCallBack_ROL_Objective_SimOpt_double_t const &>());
		cl.def( pybind11::init( [](){ return new PyCallBack_ROL_Objective_SimOpt_double_t(); } ) );
		cl.def("update", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("u"), pybind11::arg("z"));
		cl.def("update", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, bool const & a2) -> void { return o.update(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("flag"));
		cl.def("update", (void (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, bool, int)) &ROL::Objective_SimOpt<double>::update, "C++: ROL::Objective_SimOpt<double>::update(const class ROL::Vector<double> &, const class ROL::Vector<double> &, bool, int) --> void", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("flag"), pybind11::arg("iter"));
		cl.def("update", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0) -> void { return o.update(a0); }, "", pybind11::arg("x"));
		cl.def("update", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, bool const & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("flag"));
		cl.def("update", (void (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, bool, int)) &ROL::Objective_SimOpt<double>::update, "C++: ROL::Objective_SimOpt<double>::update(const class ROL::Vector<double> &, bool, int) --> void", pybind11::arg("x"), pybind11::arg("flag"), pybind11::arg("iter"));
		cl.def("update", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, enum ROL::UpdateType const & a2) -> void { return o.update(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("type"));
		cl.def("update", (void (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, enum ROL::UpdateType, int)) &ROL::Objective_SimOpt<double>::update, "C++: ROL::Objective_SimOpt<double>::update(const class ROL::Vector<double> &, const class ROL::Vector<double> &, enum ROL::UpdateType, int) --> void", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("type"), pybind11::arg("iter"));
		cl.def("update", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, enum ROL::UpdateType const & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("type"));
		cl.def("update", (void (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, enum ROL::UpdateType, int)) &ROL::Objective_SimOpt<double>::update, "C++: ROL::Objective_SimOpt<double>::update(const class ROL::Vector<double> &, enum ROL::UpdateType, int) --> void", pybind11::arg("x"), pybind11::arg("type"), pybind11::arg("iter"));
		cl.def("value", (double (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::value, "C++: ROL::Objective_SimOpt<double>::value(const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> double", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("value", (double (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::value, "C++: ROL::Objective_SimOpt<double>::value(const class ROL::Vector<double> &, double &) --> double", pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("gradient_1", (void (ROL::Objective_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::gradient_1, "C++: ROL::Objective_SimOpt<double>::gradient_1(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("g"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("gradient_2", (void (ROL::Objective_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::gradient_2, "C++: ROL::Objective_SimOpt<double>::gradient_2(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("g"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("gradient", (void (ROL::Objective_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::gradient, "C++: ROL::Objective_SimOpt<double>::gradient(class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("g"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("hessVec_11", (void (ROL::Objective_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::hessVec_11, "C++: ROL::Objective_SimOpt<double>::hessVec_11(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("hessVec_12", (void (ROL::Objective_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::hessVec_12, "C++: ROL::Objective_SimOpt<double>::hessVec_12(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("hessVec_21", (void (ROL::Objective_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::hessVec_21, "C++: ROL::Objective_SimOpt<double>::hessVec_21(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("hessVec_22", (void (ROL::Objective_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::hessVec_22, "C++: ROL::Objective_SimOpt<double>::hessVec_22(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("tol"));
		cl.def("hessVec", (void (ROL::Objective_SimOpt<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective_SimOpt<double>::hessVec, "C++: ROL::Objective_SimOpt<double>::hessVec(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("checkGradient_1", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkGradient_1(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"));
		cl.def("checkGradient_1", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkGradient_1(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"), pybind11::arg("printToStream"));
		cl.def("checkGradient_1", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkGradient_1(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkGradient_1", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4, const int & a5) -> std::vector<class std::vector<double> > { return o.checkGradient_1(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkGradient_1", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkGradient_1, "C++: ROL::Objective_SimOpt<double>::checkGradient_1(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkGradient_1", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkGradient_1, "C++: ROL::Objective_SimOpt<double>::checkGradient_1(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkGradient_1", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkGradient_1, "C++: ROL::Objective_SimOpt<double>::checkGradient_1(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkGradient_2", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkGradient_2(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"));
		cl.def("checkGradient_2", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkGradient_2(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"), pybind11::arg("printToStream"));
		cl.def("checkGradient_2", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkGradient_2(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkGradient_2", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4, const int & a5) -> std::vector<class std::vector<double> > { return o.checkGradient_2(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkGradient_2", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkGradient_2, "C++: ROL::Objective_SimOpt<double>::checkGradient_2(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkGradient_2", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkGradient_2, "C++: ROL::Objective_SimOpt<double>::checkGradient_2(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkGradient_2", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkGradient_2, "C++: ROL::Objective_SimOpt<double>::checkGradient_2(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec_11", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkHessVec_11(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"));
		cl.def("checkHessVec_11", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec_11(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"));
		cl.def("checkHessVec_11", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec_11(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec_11", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4, const int & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec_11(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkHessVec_11", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_11, "C++: ROL::Objective_SimOpt<double>::checkHessVec_11(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec_11", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec_11(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"));
		cl.def("checkHessVec_11", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec_11(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkHessVec_11", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4, std::ostream & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec_11(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec_11", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_11, "C++: ROL::Objective_SimOpt<double>::checkHessVec_11(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec_11", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_11, "C++: ROL::Objective_SimOpt<double>::checkHessVec_11(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec_11", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_11, "C++: ROL::Objective_SimOpt<double>::checkHessVec_11(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec_12", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkHessVec_12(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"));
		cl.def("checkHessVec_12", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec_12(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"));
		cl.def("checkHessVec_12", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec_12(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec_12", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4, const int & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec_12(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkHessVec_12", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_12, "C++: ROL::Objective_SimOpt<double>::checkHessVec_12(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec_12", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec_12(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"));
		cl.def("checkHessVec_12", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec_12(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkHessVec_12", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4, std::ostream & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec_12(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec_12", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_12, "C++: ROL::Objective_SimOpt<double>::checkHessVec_12(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec_12", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_12, "C++: ROL::Objective_SimOpt<double>::checkHessVec_12(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec_12", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_12, "C++: ROL::Objective_SimOpt<double>::checkHessVec_12(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec_21", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkHessVec_21(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"));
		cl.def("checkHessVec_21", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec_21(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"));
		cl.def("checkHessVec_21", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec_21(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec_21", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4, const int & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec_21(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkHessVec_21", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_21, "C++: ROL::Objective_SimOpt<double>::checkHessVec_21(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec_21", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec_21(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"));
		cl.def("checkHessVec_21", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec_21(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkHessVec_21", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4, std::ostream & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec_21(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec_21", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_21, "C++: ROL::Objective_SimOpt<double>::checkHessVec_21(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec_21", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_21, "C++: ROL::Objective_SimOpt<double>::checkHessVec_21(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec_21", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_21, "C++: ROL::Objective_SimOpt<double>::checkHessVec_21(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec_22", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkHessVec_22(a0, a1, a2); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"));
		cl.def("checkHessVec_22", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec_22(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"));
		cl.def("checkHessVec_22", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec_22(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec_22", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4, const int & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec_22(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkHessVec_22", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_22, "C++: ROL::Objective_SimOpt<double>::checkHessVec_22(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec_22", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec_22(a0, a1, a2, a3); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"));
		cl.def("checkHessVec_22", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec_22(a0, a1, a2, a3, a4); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkHessVec_22", [](ROL::Objective_SimOpt<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4, std::ostream & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec_22(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec_22", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_22, "C++: ROL::Objective_SimOpt<double>::checkHessVec_22(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec_22", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_22, "C++: ROL::Objective_SimOpt<double>::checkHessVec_22(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec_22", (class std::vector<class std::vector<double> > (ROL::Objective_SimOpt<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective_SimOpt<double>::checkHessVec_22, "C++: ROL::Objective_SimOpt<double>::checkHessVec_22(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("u"), pybind11::arg("z"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("assign", (class ROL::Objective_SimOpt<double> & (ROL::Objective_SimOpt<double>::*)(const class ROL::Objective_SimOpt<double> &)) &ROL::Objective_SimOpt<double>::operator=, "C++: ROL::Objective_SimOpt<double>::operator=(const class ROL::Objective_SimOpt<double> &) --> class ROL::Objective_SimOpt<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("update", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, enum ROL::UpdateType const & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("type"));
		cl.def("update", (void (ROL::Objective<double>::*)(const class ROL::Vector<double> &, enum ROL::UpdateType, int)) &ROL::Objective<double>::update, "Update objective function. \n\n      This function updates the objective function at new iterations. \n      \n\n      is the new iterate. \n      \n\n   is the type of update requested.\n      \n\n   is the outer algorithm iterations count.\n\nC++: ROL::Objective<double>::update(const class ROL::Vector<double> &, enum ROL::UpdateType, int) --> void", pybind11::arg("x"), pybind11::arg("type"), pybind11::arg("iter"));
		cl.def("update", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0) -> void { return o.update(a0); }, "", pybind11::arg("x"));
		cl.def("update", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, bool const & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("flag"));
		cl.def("update", (void (ROL::Objective<double>::*)(const class ROL::Vector<double> &, bool, int)) &ROL::Objective<double>::update, "Update objective function. \n\n      This function updates the objective function at new iterations. \n      \n\n      is the new iterate. \n      \n\n   is true if the iterate has changed.\n      \n\n   is the outer algorithm iterations count.\n\nC++: ROL::Objective<double>::update(const class ROL::Vector<double> &, bool, int) --> void", pybind11::arg("x"), pybind11::arg("flag"), pybind11::arg("iter"));
		cl.def("value", (double (ROL::Objective<double>::*)(const class ROL::Vector<double> &, double &)) &ROL::Objective<double>::value, "C++: ROL::Objective<double>::value(const class ROL::Vector<double> &, double &) --> double", pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("gradient", (void (ROL::Objective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective<double>::gradient, "Compute gradient.\n\n      This function returns the objective function gradient.\n      \n\n   is the gradient.\n      \n\n   is the current iterate.\n      \n\n is a tolerance for inexact objective function computation.\n\n      The default implementation is a finite-difference approximation based on the function value.\n      This requires the definition of a basis \n\n for the optimization vectors x and\n      the definition of a basis \n\n for the dual optimization vectors (gradient vectors g).\n      The bases must be related through the Riesz map, i.e., \n\n,\n      and this must be reflected in the implementation of the ROL::Vector::dual() method.\n\nC++: ROL::Objective<double>::gradient(class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("g"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("dirDeriv", (double (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective<double>::dirDeriv, "Compute directional derivative.\n\n      This function returns the directional derivative of the objective function in the \n direction.\n      \n\n   is the current iterate.\n      \n\n   is the direction.\n      \n\n is a tolerance for inexact objective function computation.\n\nC++: ROL::Objective<double>::dirDeriv(const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> double", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("tol"));
		cl.def("hessVec", (void (ROL::Objective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective<double>::hessVec, "Apply Hessian approximation to vector.\n\n      This function applies the Hessian of the objective function to the vector \n.\n      \n\n  is the the action of the Hessian on \n.\n      \n\n   is the direction vector.\n      \n\n   is the current iterate.\n      \n\n is a tolerance for inexact objective function computation.\n\nC++: ROL::Objective<double>::hessVec(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("invHessVec", (void (ROL::Objective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective<double>::invHessVec, "Apply inverse Hessian approximation to vector.\n\n      This function applies the inverse Hessian of the objective function to the vector \n.\n      \n\n  is the action of the inverse Hessian on \n.\n      \n\n   is the direction vector.\n      \n\n   is the current iterate.\n      \n\n is a tolerance for inexact objective function computation.\n\nC++: ROL::Objective<double>::invHessVec(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("precond", (void (ROL::Objective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective<double>::precond, "Apply preconditioner to vector.\n\n      This function applies a preconditioner for the Hessian of the objective function to the vector \n.\n      \n\n  is the action of the Hessian preconditioner on \n.\n      \n\n   is the direction vector.\n      \n\n   is the current iterate.\n      \n\n is a tolerance for inexact objective function computation.\n\nC++: ROL::Objective<double>::precond(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("Pv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("prox", (void (ROL::Objective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, double, double &)) &ROL::Objective<double>::prox, "Compute the proximity operator.\n\n      This function returns the proximity operator.\n      \n\n  is the proximity operator applied to \n (primal optimization vector).\n      \n\n   is the input to the proximity operator (primal optimization vector).\n      \n\n   is the proximity operator parameter (positive scalar).\n      \n\n is a tolerance for inexact objective function computation.\n\nC++: ROL::Objective<double>::prox(class ROL::Vector<double> &, const class ROL::Vector<double> &, double, double &) --> void", pybind11::arg("Pv"), pybind11::arg("v"), pybind11::arg("t"), pybind11::arg("tol"));
		cl.def("proxJacVec", (void (ROL::Objective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double, double &)) &ROL::Objective<double>::proxJacVec, "Apply the Jacobian of the proximity operator.\n\n      This function applies the Jacobian of the proximity operator.\n      \n\n  is the Jacobian of the proximity operator at \n applied to \n (primal optimization vector).\n      \n\n   is the direction vector (primal optimization vector).\n      \n\n   is the input to the proximity operator (primal optimization vector).\n      \n\n   is the proximity operator parameter (positive scalar).\n      \n\n is a tolerance for inexact objective function computation.\n\nC++: ROL::Objective<double>::proxJacVec(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double, double &) --> void", pybind11::arg("Jv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("t"), pybind11::arg("tol"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("d"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("printToStream"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2, std::ostream & a3) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2, std::ostream & a3, const int & a4) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkGradient", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective<double>::checkGradient, "Finite-difference gradient check.\n\n      This function computes a sequence of one-sided finite-difference checks for the gradient.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n      \n\n             is an optimization variable.\n      \n\n             is a direction vector.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n      is a parameter which dictates the number of finite difference steps.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkGradient(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("printToStream"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4, const int & a5) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkGradient", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective<double>::checkGradient, "Finite-difference gradient check.\n\n      This function computes a sequence of one-sided finite-difference checks for the gradient.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n\n      \n             is an optimization variable.\n      \n\n             is used to create a temporary gradient vector.\n      \n\n             is a direction vector.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n      is a parameter which dictates the number of finite difference steps.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkGradient(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("steps"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkGradient", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective<double>::checkGradient, "Finite-difference gradient check with specified step sizes.\n\n      This function computes a sequence of one-sided finite-difference checks for the gradient.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n      \n\n             is an optimization variable.\n      \n\n             is a direction vector.\n      \n\n         is vector of steps of user-specified size.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkGradient(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("steps"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4, std::ostream & a5) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkGradient", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective<double>::checkGradient, "Finite-difference gradient check with specified step sizes.\n\n      This function computes a sequence of one-sided finite-difference checks for the gradient.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n\n      \n             is an optimization variable.\n      \n\n             is used to create a temporary gradient vector.\n      \n\n             is a direction vector.\n      \n\n         is vector of steps of user-specified size.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkGradient(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("v"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("printToStream"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2, std::ostream & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2, std::ostream & a3, const int & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkHessVec", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective<double>::checkHessVec, "Finite-difference Hessian-applied-to-vector check.\n\n      This function computes a sequence of one-sided finite-difference checks for the Hessian.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n      \n\n             is an optimization variable.\n      \n\n             is a direction vector.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n      is a parameter which dictates the number of finite difference steps.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkHessVec(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4, const int & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkHessVec", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective<double>::checkHessVec, "Finite-difference Hessian-applied-to-vector check.\n\n      This function computes a sequence of one-sided finite-difference checks for the Hessian.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n      \n\n             is an optimization variable.\n      \n\n            is used to create temporary gradient and Hessian-times-vector vectors.\n      \n\n             is a direction vector.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n      is a parameter which dictates the number of finite difference steps.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkHessVec(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("steps"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective<double>::checkHessVec, "Finite-difference Hessian-applied-to-vector check with specified step sizes.\n\n      This function computes a sequence of one-sided finite-difference checks for the Hessian.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n      \n\n             is an optimization variable.\n      \n\n             is a direction vector.\n      \n\n         is vector of steps of user-specified size.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkHessVec(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4, std::ostream & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective<double>::checkHessVec, "Finite-difference Hessian-applied-to-vector check with specified step sizes.\n\n      This function computes a sequence of one-sided finite-difference checks for the Hessian.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n      \n\n             is an optimization variable.\n      \n\n            is used to create temporary gradient and Hessian-times-vector vectors.\n      \n\n             is a direction vector.\n      \n\n         is vector of steps of user-specified size.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkHessVec(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessSym", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<double> { return o.checkHessSym(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("w"));
		cl.def("checkHessSym", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<double> { return o.checkHessSym(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("w"), pybind11::arg("printToStream"));
		cl.def("checkHessSym", (class std::vector<double> (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &)) &ROL::Objective<double>::checkHessSym, "Hessian symmetry check.\n\n      This function checks the symmetry of the Hessian by comparing \n      \n\n\n\n\n\n      \n             is an optimization variable.\n      \n\n             is a direction vector.\n      \n\n             is a direction vector.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n\nC++: ROL::Objective<double>::checkHessSym(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &) --> class std::vector<double>", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("w"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessSym", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3) -> std::vector<double> { return o.checkHessSym(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("w"));
		cl.def("checkHessSym", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool & a4) -> std::vector<double> { return o.checkHessSym(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("w"), pybind11::arg("printToStream"));
		cl.def("checkHessSym", (class std::vector<double> (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &)) &ROL::Objective<double>::checkHessSym, "Hessian symmetry check.\n\n      This function checks the symmetry of the Hessian by comparing \n      \n\n\n\n\n\n      \n             is an optimization variable.\n      \n\n            is used to create temporary Hessian-times-vector vectors.\n      \n\n             is a direction vector.\n      \n\n             is a direction vector.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n\nC++: ROL::Objective<double>::checkHessSym(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &) --> class std::vector<double>", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("w"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkProxJacVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1) -> std::vector<class std::vector<double> > { return o.checkProxJacVec(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("v"));
		cl.def("checkProxJacVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double const & a2) -> std::vector<class std::vector<double> > { return o.checkProxJacVec(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("t"));
		cl.def("checkProxJacVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double const & a2, bool const & a3) -> std::vector<class std::vector<double> > { return o.checkProxJacVec(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("t"), pybind11::arg("printToStream"));
		cl.def("checkProxJacVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double const & a2, bool const & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkProxJacVec(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("t"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkProxJacVec", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, double, bool, std::ostream &, int)) &ROL::Objective<double>::checkProxJacVec, "Finite-difference proximity operator Jacobian-applied-to-vector check.\n\n      This function computes a sequence of one-sided finite-difference checks for the proximity\n      operator Jacobian.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order.  Note that in some cases the proximity operator\n      is semismooth, which motivates the evaluation of \n\n at \n.\n      \n\n             is an optimization vector.\n      \n\n             is a direction vector.\n      \n\n             is the proximity operator parameter.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n      is a parameter which dictates the number of finite difference steps.\n\nC++: ROL::Objective<double>::checkProxJacVec(const class ROL::Vector<double> &, const class ROL::Vector<double> &, double, bool, std::ostream &, int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("t"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("setParameter", (void (ROL::Objective<double>::*)(const class std::vector<double> &)) &ROL::Objective<double>::setParameter, "C++: ROL::Objective<double>::setParameter(const class std::vector<double> &) --> void", pybind11::arg("param"));
		cl.def("assign", (class ROL::Objective<double> & (ROL::Objective<double>::*)(const class ROL::Objective<double> &)) &ROL::Objective<double>::operator=, "C++: ROL::Objective<double>::operator=(const class ROL::Objective<double> &) --> class ROL::Objective<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::MeanValueObjective file:ROL_MeanValueObjective.hpp line:19
		pybind11::class_<ROL::MeanValueObjective<double>, Teuchos::RCP<ROL::MeanValueObjective<double>>, PyCallBack_ROL_MeanValueObjective_double_t, ROL::Objective<double>> cl(M("ROL"), "MeanValueObjective_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<const class Teuchos::RCP<class ROL::Objective<double> > &, const class Teuchos::RCP<class ROL::SampleGenerator<double> > &>(), pybind11::arg("obj"), pybind11::arg("sampler") );

		cl.def( pybind11::init( [](PyCallBack_ROL_MeanValueObjective_double_t const &o){ return new PyCallBack_ROL_MeanValueObjective_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::MeanValueObjective<double> const &o){ return new ROL::MeanValueObjective<double>(o); } ) );
		cl.def("update", [](ROL::MeanValueObjective<double> &o, const class ROL::Vector<double> & a0, enum ROL::UpdateType const & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("type"));
		cl.def("update", (void (ROL::MeanValueObjective<double>::*)(const class ROL::Vector<double> &, enum ROL::UpdateType, int)) &ROL::MeanValueObjective<double>::update, "C++: ROL::MeanValueObjective<double>::update(const class ROL::Vector<double> &, enum ROL::UpdateType, int) --> void", pybind11::arg("x"), pybind11::arg("type"), pybind11::arg("iter"));
		cl.def("update", [](ROL::MeanValueObjective<double> &o, const class ROL::Vector<double> & a0) -> void { return o.update(a0); }, "", pybind11::arg("x"));
		cl.def("update", [](ROL::MeanValueObjective<double> &o, const class ROL::Vector<double> & a0, bool const & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("flag"));
		cl.def("update", (void (ROL::MeanValueObjective<double>::*)(const class ROL::Vector<double> &, bool, int)) &ROL::MeanValueObjective<double>::update, "C++: ROL::MeanValueObjective<double>::update(const class ROL::Vector<double> &, bool, int) --> void", pybind11::arg("x"), pybind11::arg("flag"), pybind11::arg("iter"));
		cl.def("value", (double (ROL::MeanValueObjective<double>::*)(const class ROL::Vector<double> &, double &)) &ROL::MeanValueObjective<double>::value, "C++: ROL::MeanValueObjective<double>::value(const class ROL::Vector<double> &, double &) --> double", pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("gradient", (void (ROL::MeanValueObjective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::MeanValueObjective<double>::gradient, "C++: ROL::MeanValueObjective<double>::gradient(class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("g"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("hessVec", (void (ROL::MeanValueObjective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::MeanValueObjective<double>::hessVec, "C++: ROL::MeanValueObjective<double>::hessVec(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("precond", (void (ROL::MeanValueObjective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::MeanValueObjective<double>::precond, "C++: ROL::MeanValueObjective<double>::precond(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("Pv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("update", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, enum ROL::UpdateType const & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("type"));
		cl.def("update", (void (ROL::Objective<double>::*)(const class ROL::Vector<double> &, enum ROL::UpdateType, int)) &ROL::Objective<double>::update, "Update objective function. \n\n      This function updates the objective function at new iterations. \n      \n\n      is the new iterate. \n      \n\n   is the type of update requested.\n      \n\n   is the outer algorithm iterations count.\n\nC++: ROL::Objective<double>::update(const class ROL::Vector<double> &, enum ROL::UpdateType, int) --> void", pybind11::arg("x"), pybind11::arg("type"), pybind11::arg("iter"));
		cl.def("update", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0) -> void { return o.update(a0); }, "", pybind11::arg("x"));
		cl.def("update", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, bool const & a1) -> void { return o.update(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("flag"));
		cl.def("update", (void (ROL::Objective<double>::*)(const class ROL::Vector<double> &, bool, int)) &ROL::Objective<double>::update, "Update objective function. \n\n      This function updates the objective function at new iterations. \n      \n\n      is the new iterate. \n      \n\n   is true if the iterate has changed.\n      \n\n   is the outer algorithm iterations count.\n\nC++: ROL::Objective<double>::update(const class ROL::Vector<double> &, bool, int) --> void", pybind11::arg("x"), pybind11::arg("flag"), pybind11::arg("iter"));
		cl.def("value", (double (ROL::Objective<double>::*)(const class ROL::Vector<double> &, double &)) &ROL::Objective<double>::value, "C++: ROL::Objective<double>::value(const class ROL::Vector<double> &, double &) --> double", pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("gradient", (void (ROL::Objective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective<double>::gradient, "Compute gradient.\n\n      This function returns the objective function gradient.\n      \n\n   is the gradient.\n      \n\n   is the current iterate.\n      \n\n is a tolerance for inexact objective function computation.\n\n      The default implementation is a finite-difference approximation based on the function value.\n      This requires the definition of a basis \n\n for the optimization vectors x and\n      the definition of a basis \n\n for the dual optimization vectors (gradient vectors g).\n      The bases must be related through the Riesz map, i.e., \n\n,\n      and this must be reflected in the implementation of the ROL::Vector::dual() method.\n\nC++: ROL::Objective<double>::gradient(class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("g"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("dirDeriv", (double (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective<double>::dirDeriv, "Compute directional derivative.\n\n      This function returns the directional derivative of the objective function in the \n direction.\n      \n\n   is the current iterate.\n      \n\n   is the direction.\n      \n\n is a tolerance for inexact objective function computation.\n\nC++: ROL::Objective<double>::dirDeriv(const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> double", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("tol"));
		cl.def("hessVec", (void (ROL::Objective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective<double>::hessVec, "Apply Hessian approximation to vector.\n\n      This function applies the Hessian of the objective function to the vector \n.\n      \n\n  is the the action of the Hessian on \n.\n      \n\n   is the direction vector.\n      \n\n   is the current iterate.\n      \n\n is a tolerance for inexact objective function computation.\n\nC++: ROL::Objective<double>::hessVec(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("invHessVec", (void (ROL::Objective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective<double>::invHessVec, "Apply inverse Hessian approximation to vector.\n\n      This function applies the inverse Hessian of the objective function to the vector \n.\n      \n\n  is the action of the inverse Hessian on \n.\n      \n\n   is the direction vector.\n      \n\n   is the current iterate.\n      \n\n is a tolerance for inexact objective function computation.\n\nC++: ROL::Objective<double>::invHessVec(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("precond", (void (ROL::Objective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &)) &ROL::Objective<double>::precond, "Apply preconditioner to vector.\n\n      This function applies a preconditioner for the Hessian of the objective function to the vector \n.\n      \n\n  is the action of the Hessian preconditioner on \n.\n      \n\n   is the direction vector.\n      \n\n   is the current iterate.\n      \n\n is a tolerance for inexact objective function computation.\n\nC++: ROL::Objective<double>::precond(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double &) --> void", pybind11::arg("Pv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("tol"));
		cl.def("prox", (void (ROL::Objective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, double, double &)) &ROL::Objective<double>::prox, "Compute the proximity operator.\n\n      This function returns the proximity operator.\n      \n\n  is the proximity operator applied to \n (primal optimization vector).\n      \n\n   is the input to the proximity operator (primal optimization vector).\n      \n\n   is the proximity operator parameter (positive scalar).\n      \n\n is a tolerance for inexact objective function computation.\n\nC++: ROL::Objective<double>::prox(class ROL::Vector<double> &, const class ROL::Vector<double> &, double, double &) --> void", pybind11::arg("Pv"), pybind11::arg("v"), pybind11::arg("t"), pybind11::arg("tol"));
		cl.def("proxJacVec", (void (ROL::Objective<double>::*)(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double, double &)) &ROL::Objective<double>::proxJacVec, "Apply the Jacobian of the proximity operator.\n\n      This function applies the Jacobian of the proximity operator.\n      \n\n  is the Jacobian of the proximity operator at \n applied to \n (primal optimization vector).\n      \n\n   is the direction vector (primal optimization vector).\n      \n\n   is the input to the proximity operator (primal optimization vector).\n      \n\n   is the proximity operator parameter (positive scalar).\n      \n\n is a tolerance for inexact objective function computation.\n\nC++: ROL::Objective<double>::proxJacVec(class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, double, double &) --> void", pybind11::arg("Jv"), pybind11::arg("v"), pybind11::arg("x"), pybind11::arg("t"), pybind11::arg("tol"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("d"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("printToStream"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2, std::ostream & a3) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2, std::ostream & a3, const int & a4) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkGradient", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective<double>::checkGradient, "Finite-difference gradient check.\n\n      This function computes a sequence of one-sided finite-difference checks for the gradient.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n      \n\n             is an optimization variable.\n      \n\n             is a direction vector.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n      is a parameter which dictates the number of finite difference steps.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkGradient(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("printToStream"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4, const int & a5) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkGradient", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective<double>::checkGradient, "Finite-difference gradient check.\n\n      This function computes a sequence of one-sided finite-difference checks for the gradient.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n\n      \n             is an optimization variable.\n      \n\n             is used to create a temporary gradient vector.\n      \n\n             is a direction vector.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n      is a parameter which dictates the number of finite difference steps.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkGradient(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("steps"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkGradient", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective<double>::checkGradient, "Finite-difference gradient check with specified step sizes.\n\n      This function computes a sequence of one-sided finite-difference checks for the gradient.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n      \n\n             is an optimization variable.\n      \n\n             is a direction vector.\n      \n\n         is vector of steps of user-specified size.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkGradient(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("steps"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkGradient", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4, std::ostream & a5) -> std::vector<class std::vector<double> > { return o.checkGradient(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkGradient", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective<double>::checkGradient, "Finite-difference gradient check with specified step sizes.\n\n      This function computes a sequence of one-sided finite-difference checks for the gradient.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n\n      \n             is an optimization variable.\n      \n\n             is used to create a temporary gradient vector.\n      \n\n             is a direction vector.\n      \n\n         is vector of steps of user-specified size.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkGradient(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("g"), pybind11::arg("d"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("v"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("printToStream"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2, std::ostream & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2, std::ostream & a3, const int & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkHessVec", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective<double>::checkHessVec, "Finite-difference Hessian-applied-to-vector check.\n\n      This function computes a sequence of one-sided finite-difference checks for the Hessian.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n      \n\n             is an optimization variable.\n      \n\n             is a direction vector.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n      is a parameter which dictates the number of finite difference steps.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkHessVec(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3, std::ostream & a4, const int & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("checkHessVec", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int)) &ROL::Objective<double>::checkHessVec, "Finite-difference Hessian-applied-to-vector check.\n\n      This function computes a sequence of one-sided finite-difference checks for the Hessian.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n      \n\n             is an optimization variable.\n      \n\n            is used to create temporary gradient and Hessian-times-vector vectors.\n      \n\n             is a direction vector.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n      is a parameter which dictates the number of finite difference steps.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkHessVec(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &, const int, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"), pybind11::arg("order"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("steps"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class std::vector<double> & a2, const bool & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective<double>::checkHessVec, "Finite-difference Hessian-applied-to-vector check with specified step sizes.\n\n      This function computes a sequence of one-sided finite-difference checks for the Hessian.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n      \n\n             is an optimization variable.\n      \n\n             is a direction vector.\n      \n\n         is vector of steps of user-specified size.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkHessVec(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"));
		cl.def("checkHessVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class std::vector<double> & a3, const bool & a4, std::ostream & a5) -> std::vector<class std::vector<double> > { return o.checkHessVec(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessVec", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int)) &ROL::Objective<double>::checkHessVec, "Finite-difference Hessian-applied-to-vector check with specified step sizes.\n\n      This function computes a sequence of one-sided finite-difference checks for the Hessian.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order. More generally, difference approximation is\n      \n\n\n\n      where m = order+1, \n are the difference weights and \n are the difference steps\n      \n\n             is an optimization variable.\n      \n\n            is used to create temporary gradient and Hessian-times-vector vectors.\n      \n\n             is a direction vector.\n      \n\n         is vector of steps of user-specified size.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n         is the order of the finite difference approximation (1,2,3,4)\n\nC++: ROL::Objective<double>::checkHessVec(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const bool, std::ostream &, const int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("steps"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("order"));
		cl.def("checkHessSym", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2) -> std::vector<double> { return o.checkHessSym(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("w"));
		cl.def("checkHessSym", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const bool & a3) -> std::vector<double> { return o.checkHessSym(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("w"), pybind11::arg("printToStream"));
		cl.def("checkHessSym", (class std::vector<double> (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &)) &ROL::Objective<double>::checkHessSym, "Hessian symmetry check.\n\n      This function checks the symmetry of the Hessian by comparing \n      \n\n\n\n\n\n      \n             is an optimization variable.\n      \n\n             is a direction vector.\n      \n\n             is a direction vector.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n\nC++: ROL::Objective<double>::checkHessSym(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &) --> class std::vector<double>", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("w"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkHessSym", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3) -> std::vector<double> { return o.checkHessSym(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("w"));
		cl.def("checkHessSym", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const class ROL::Vector<double> & a2, const class ROL::Vector<double> & a3, const bool & a4) -> std::vector<double> { return o.checkHessSym(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("w"), pybind11::arg("printToStream"));
		cl.def("checkHessSym", (class std::vector<double> (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &)) &ROL::Objective<double>::checkHessSym, "Hessian symmetry check.\n\n      This function checks the symmetry of the Hessian by comparing \n      \n\n\n\n\n\n      \n             is an optimization variable.\n      \n\n            is used to create temporary Hessian-times-vector vectors.\n      \n\n             is a direction vector.\n      \n\n             is a direction vector.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n\nC++: ROL::Objective<double>::checkHessSym(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &) --> class std::vector<double>", pybind11::arg("x"), pybind11::arg("hv"), pybind11::arg("v"), pybind11::arg("w"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkProxJacVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1) -> std::vector<class std::vector<double> > { return o.checkProxJacVec(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("v"));
		cl.def("checkProxJacVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double const & a2) -> std::vector<class std::vector<double> > { return o.checkProxJacVec(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("t"));
		cl.def("checkProxJacVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double const & a2, bool const & a3) -> std::vector<class std::vector<double> > { return o.checkProxJacVec(a0, a1, a2, a3); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("t"), pybind11::arg("printToStream"));
		cl.def("checkProxJacVec", [](ROL::Objective<double> &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, double const & a2, bool const & a3, std::ostream & a4) -> std::vector<class std::vector<double> > { return o.checkProxJacVec(a0, a1, a2, a3, a4); }, "", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("t"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("checkProxJacVec", (class std::vector<class std::vector<double> > (ROL::Objective<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, double, bool, std::ostream &, int)) &ROL::Objective<double>::checkProxJacVec, "Finite-difference proximity operator Jacobian-applied-to-vector check.\n\n      This function computes a sequence of one-sided finite-difference checks for the proximity\n      operator Jacobian.  \n      At each step of the sequence, the finite difference step size is decreased.  The output \n      compares the error \n      \n\n\n\n      if the approximation is first order.  Note that in some cases the proximity operator\n      is semismooth, which motivates the evaluation of \n\n at \n.\n      \n\n             is an optimization vector.\n      \n\n             is a direction vector.\n      \n\n             is the proximity operator parameter.\n      \n\n is a flag that turns on/off output.\n      \n\n     is the output stream.\n      \n\n      is a parameter which dictates the number of finite difference steps.\n\nC++: ROL::Objective<double>::checkProxJacVec(const class ROL::Vector<double> &, const class ROL::Vector<double> &, double, bool, std::ostream &, int) --> class std::vector<class std::vector<double> >", pybind11::arg("x"), pybind11::arg("v"), pybind11::arg("t"), pybind11::arg("printToStream"), pybind11::arg("outStream"), pybind11::arg("numSteps"));
		cl.def("setParameter", (void (ROL::Objective<double>::*)(const class std::vector<double> &)) &ROL::Objective<double>::setParameter, "C++: ROL::Objective<double>::setParameter(const class std::vector<double> &) --> void", pybind11::arg("param"));
		cl.def("assign", (class ROL::Objective<double> & (ROL::Objective<double>::*)(const class ROL::Objective<double> &)) &ROL::Objective<double>::operator=, "C++: ROL::Objective<double>::operator=(const class ROL::Objective<double> &) --> class ROL::Objective<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::RandVarFunctional file:ROL_RandVarFunctional.hpp line:47
		pybind11::class_<ROL::RandVarFunctional<double>, Teuchos::RCP<ROL::RandVarFunctional<double>>, PyCallBack_ROL_RandVarFunctional_double_t> cl(M("ROL"), "RandVarFunctional_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::RandVarFunctional<double>(); }, [](){ return new PyCallBack_ROL_RandVarFunctional_double_t(); } ) );
		cl.def( pybind11::init( [](PyCallBack_ROL_RandVarFunctional_double_t const &o){ return new PyCallBack_ROL_RandVarFunctional_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::RandVarFunctional<double> const &o){ return new ROL::RandVarFunctional<double>(o); } ) );
		cl.def("useStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useStorage, "C++: ROL::RandVarFunctional<double>::useStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("useHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useHessVecStorage, "C++: ROL::RandVarFunctional<double>::useHessVecStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("setStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setStorage, "C++: ROL::RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setHessVecStorage, "C++: ROL::RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("resetStorage", [](ROL::RandVarFunctional<double> &o) -> void { return o.resetStorage(); }, "");
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(bool) --> void", pybind11::arg("flag"));
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(enum ROL::UpdateType)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(enum ROL::UpdateType) --> void", pybind11::arg("type"));
		cl.def("initialize", (void (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::RandVarFunctional<double>::initialize, "C++: ROL::RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("setSample", (void (ROL::RandVarFunctional<double>::*)(const class std::vector<double> &, const double)) &ROL::RandVarFunctional<double>::setSample, "C++: ROL::RandVarFunctional<double>::setSample(const class std::vector<double> &, const double) --> void", pybind11::arg("point"), pybind11::arg("weight"));
		cl.def("computeStatistic", (double (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<const class std::vector<double> > &) const) &ROL::RandVarFunctional<double>::computeStatistic, "C++: ROL::RandVarFunctional<double>::computeStatistic(const class Teuchos::RCP<const class std::vector<double> > &) const --> double", pybind11::arg("xstat"));
		cl.def("updateValue", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateValue, "C++: ROL::RandVarFunctional<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateGradient, "C++: ROL::RandVarFunctional<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateHessVec, "C++: ROL::RandVarFunctional<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getValue, "C++: ROL::RandVarFunctional<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getGradient, "C++: ROL::RandVarFunctional<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getHessVec, "C++: ROL::RandVarFunctional<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::RandVarFunctional<double> & (ROL::RandVarFunctional<double>::*)(const class ROL::RandVarFunctional<double> &)) &ROL::RandVarFunctional<double>::operator=, "C++: ROL::RandVarFunctional<double>::operator=(const class ROL::RandVarFunctional<double> &) --> class ROL::RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::StdVector file:ROL_StdVector.hpp line:27
		pybind11::class_<ROL::StdVector<double,double>, Teuchos::RCP<ROL::StdVector<double,double>>, PyCallBack_ROL_StdVector_double_double_t, ROL::Vector<double>> cl(M("ROL"), "StdVector_double_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<const class Teuchos::RCP<class std::vector<double> > &>(), pybind11::arg("std_vec") );

		cl.def( pybind11::init( [](const int & a0){ return new ROL::StdVector<double,double>(a0); }, [](const int & a0){ return new PyCallBack_ROL_StdVector_double_double_t(a0); } ), "doc");
		cl.def( pybind11::init<const int, const double>(), pybind11::arg("dim"), pybind11::arg("val") );

		cl.def( pybind11::init( [](PyCallBack_ROL_StdVector_double_double_t const &o){ return new PyCallBack_ROL_StdVector_double_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::StdVector<double,double> const &o){ return new ROL::StdVector<double,double>(o); } ) );
		cl.def("__getitem__", (double & (ROL::StdVector<double,double>::*)(int)) &ROL::StdVector<double>::operator[], "C++: ROL::StdVector<double>::operator[](int) --> double &", pybind11::return_value_policy::automatic, pybind11::arg("i"));
		cl.def("set", (void (ROL::StdVector<double,double>::*)(const class ROL::Vector<double> &)) &ROL::StdVector<double>::set, "C++: ROL::StdVector<double>::set(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("plus", (void (ROL::StdVector<double,double>::*)(const class ROL::Vector<double> &)) &ROL::StdVector<double>::plus, "C++: ROL::StdVector<double>::plus(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("axpy", (void (ROL::StdVector<double,double>::*)(const double, const class ROL::Vector<double> &)) &ROL::StdVector<double>::axpy, "C++: ROL::StdVector<double>::axpy(const double, const class ROL::Vector<double> &) --> void", pybind11::arg("alpha"), pybind11::arg("x"));
		cl.def("scale", (void (ROL::StdVector<double,double>::*)(const double)) &ROL::StdVector<double>::scale, "C++: ROL::StdVector<double>::scale(const double) --> void", pybind11::arg("alpha"));
		cl.def("dot", (double (ROL::StdVector<double,double>::*)(const class ROL::Vector<double> &) const) &ROL::StdVector<double>::dot, "C++: ROL::StdVector<double>::dot(const class ROL::Vector<double> &) const --> double", pybind11::arg("x"));
		cl.def("norm", (double (ROL::StdVector<double,double>::*)() const) &ROL::StdVector<double>::norm, "C++: ROL::StdVector<double>::norm() const --> double");
		cl.def("clone", (class Teuchos::RCP<class ROL::Vector<double> > (ROL::StdVector<double,double>::*)() const) &ROL::StdVector<double>::clone, "C++: ROL::StdVector<double>::clone() const --> class Teuchos::RCP<class ROL::Vector<double> >");
		cl.def("getVector", (class Teuchos::RCP<class std::vector<double> > (ROL::StdVector<double,double>::*)()) &ROL::StdVector<double>::getVector, "C++: ROL::StdVector<double>::getVector() --> class Teuchos::RCP<class std::vector<double> >");
		cl.def("basis", (class Teuchos::RCP<class ROL::Vector<double> > (ROL::StdVector<double,double>::*)(const int) const) &ROL::StdVector<double>::basis, "C++: ROL::StdVector<double>::basis(const int) const --> class Teuchos::RCP<class ROL::Vector<double> >", pybind11::arg("i"));
		cl.def("dimension", (int (ROL::StdVector<double,double>::*)() const) &ROL::StdVector<double>::dimension, "C++: ROL::StdVector<double>::dimension() const --> int");
		cl.def("applyUnary", (void (ROL::StdVector<double,double>::*)(const class ROL::Elementwise::UnaryFunction<double> &)) &ROL::StdVector<double>::applyUnary, "C++: ROL::StdVector<double>::applyUnary(const class ROL::Elementwise::UnaryFunction<double> &) --> void", pybind11::arg("f"));
		cl.def("applyBinary", (void (ROL::StdVector<double,double>::*)(const class ROL::Elementwise::BinaryFunction<double> &, const class ROL::Vector<double> &)) &ROL::StdVector<double>::applyBinary, "C++: ROL::StdVector<double>::applyBinary(const class ROL::Elementwise::BinaryFunction<double> &, const class ROL::Vector<double> &) --> void", pybind11::arg("f"), pybind11::arg("x"));
		cl.def("reduce", (double (ROL::StdVector<double,double>::*)(const class ROL::Elementwise::ReductionOp<double> &) const) &ROL::StdVector<double>::reduce, "C++: ROL::StdVector<double>::reduce(const class ROL::Elementwise::ReductionOp<double> &) const --> double", pybind11::arg("r"));
		cl.def("setScalar", (void (ROL::StdVector<double,double>::*)(const double)) &ROL::StdVector<double>::setScalar, "C++: ROL::StdVector<double>::setScalar(const double) --> void", pybind11::arg("C"));
		cl.def("randomize", [](ROL::StdVector<double,double> &o) -> void { return o.randomize(); }, "");
		cl.def("randomize", [](ROL::StdVector<double,double> &o, const double & a0) -> void { return o.randomize(a0); }, "", pybind11::arg("l"));
		cl.def("randomize", (void (ROL::StdVector<double,double>::*)(const double, const double)) &ROL::StdVector<double>::randomize, "C++: ROL::StdVector<double>::randomize(const double, const double) --> void", pybind11::arg("l"), pybind11::arg("u"));
		cl.def("print", (void (ROL::StdVector<double,double>::*)(std::ostream &) const) &ROL::StdVector<double>::print, "C++: ROL::StdVector<double>::print(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::StdVector<double> & (ROL::StdVector<double,double>::*)(const class ROL::StdVector<double> &)) &ROL::StdVector<double>::operator=, "C++: ROL::StdVector<double>::operator=(const class ROL::StdVector<double> &) --> class ROL::StdVector<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("plus", (void (ROL::Vector<double>::*)(const class ROL::Vector<double> &)) &ROL::Vector<double>::plus, "C++: ROL::Vector<double>::plus(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("scale", (void (ROL::Vector<double>::*)(const double)) &ROL::Vector<double>::scale, "C++: ROL::Vector<double>::scale(const double) --> void", pybind11::arg("alpha"));
		cl.def("dot", (double (ROL::Vector<double>::*)(const class ROL::Vector<double> &) const) &ROL::Vector<double>::dot, "C++: ROL::Vector<double>::dot(const class ROL::Vector<double> &) const --> double", pybind11::arg("x"));
		cl.def("norm", (double (ROL::Vector<double>::*)() const) &ROL::Vector<double>::norm, "C++: ROL::Vector<double>::norm() const --> double");
		cl.def("clone", (class Teuchos::RCP<class ROL::Vector<double> > (ROL::Vector<double>::*)() const) &ROL::Vector<double>::clone, "C++: ROL::Vector<double>::clone() const --> class Teuchos::RCP<class ROL::Vector<double> >");
		cl.def("axpy", (void (ROL::Vector<double>::*)(const double, const class ROL::Vector<double> &)) &ROL::Vector<double>::axpy, "Compute \n where \n.\n\n             \n is the scaling of \n             \n\n     is a vector.\n\n             On return \n.\n             Uses #clone, #set, #scale and #plus for the computation.\n             Please overload if a more efficient implementation is needed.\n\n             ---\n\nC++: ROL::Vector<double>::axpy(const double, const class ROL::Vector<double> &) --> void", pybind11::arg("alpha"), pybind11::arg("x"));
		cl.def("zero", (void (ROL::Vector<double>::*)()) &ROL::Vector<double>::zero, "Set to zero vector.\n\n             Uses #scale by zero for the computation.\n             Please overload if a more efficient implementation is needed.\n\n             ---\n\nC++: ROL::Vector<double>::zero() --> void");
		cl.def("basis", (class Teuchos::RCP<class ROL::Vector<double> > (ROL::Vector<double>::*)(const int) const) &ROL::Vector<double>::basis, "Return i-th basis vector.\n\n             \n is the index of the basis function.\n             \n\n A reference-counted pointer to the basis vector with index \n\n             Overloading the basis is only required if the default gradient implementation\n             is used, which computes a finite-difference approximation.\n\n             ---\n\nC++: ROL::Vector<double>::basis(const int) const --> class Teuchos::RCP<class ROL::Vector<double> >", pybind11::arg("i"));
		cl.def("dimension", (int (ROL::Vector<double>::*)() const) &ROL::Vector<double>::dimension, "Return dimension of the vector space.\n\n             \n The dimension of the vector space, i.e., the total number of basis vectors.\n\n             Overload if the basis is overloaded.\n\n             ---\n\nC++: ROL::Vector<double>::dimension() const --> int");
		cl.def("set", (void (ROL::Vector<double>::*)(const class ROL::Vector<double> &)) &ROL::Vector<double>::set, "Set \n where \n.\n\n             \n     is a vector.\n\n             On return \n.\n             Uses #zero and #plus methods for the computation.\n             Please overload if a more efficient implementation is needed.\n\n             ---\n\nC++: ROL::Vector<double>::set(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("dual", (const class ROL::Vector<double> & (ROL::Vector<double>::*)() const) &ROL::Vector<double>::dual, "Return dual representation of \n, for example,\n             the result of applying a Riesz map, or change of basis, or\n             change of memory layout.\n\n             \n         A const reference to dual representation.\n\n             By default, returns the current object.\n             Please overload if you need a dual representation.\n\n             ---\n\nC++: ROL::Vector<double>::dual() const --> const class ROL::Vector<double> &", pybind11::return_value_policy::automatic);
		cl.def("apply", (double (ROL::Vector<double>::*)(const class ROL::Vector<double> &) const) &ROL::Vector<double>::apply, "Apply \n to a dual vector.  This is equivalent\n             to the call \n\n.\n\n             \n      is a vector\n             \n\n         The number equal to \n.\n\n             ---\n\nC++: ROL::Vector<double>::apply(const class ROL::Vector<double> &) const --> double", pybind11::arg("x"));
		cl.def("applyUnary", (void (ROL::Vector<double>::*)(const class ROL::Elementwise::UnaryFunction<double> &)) &ROL::Vector<double>::applyUnary, "C++: ROL::Vector<double>::applyUnary(const class ROL::Elementwise::UnaryFunction<double> &) --> void", pybind11::arg("f"));
		cl.def("applyBinary", (void (ROL::Vector<double>::*)(const class ROL::Elementwise::BinaryFunction<double> &, const class ROL::Vector<double> &)) &ROL::Vector<double>::applyBinary, "C++: ROL::Vector<double>::applyBinary(const class ROL::Elementwise::BinaryFunction<double> &, const class ROL::Vector<double> &) --> void", pybind11::arg("f"), pybind11::arg("x"));
		cl.def("reduce", (double (ROL::Vector<double>::*)(const class ROL::Elementwise::ReductionOp<double> &) const) &ROL::Vector<double>::reduce, "C++: ROL::Vector<double>::reduce(const class ROL::Elementwise::ReductionOp<double> &) const --> double", pybind11::arg("r"));
		cl.def("print", (void (ROL::Vector<double>::*)(std::ostream &) const) &ROL::Vector<double>::print, "C++: ROL::Vector<double>::print(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("setScalar", (void (ROL::Vector<double>::*)(const double)) &ROL::Vector<double>::setScalar, "Set \n where \n.\n\n             \n     is a scalar.\n\n             On return \n.\n             Uses #applyUnary methods for the computation.\n             Please overload if a more efficient implementation is needed.\n\n             ---\n\nC++: ROL::Vector<double>::setScalar(const double) --> void", pybind11::arg("C"));
		cl.def("randomize", [](ROL::Vector<double> &o) -> void { return o.randomize(); }, "");
		cl.def("randomize", [](ROL::Vector<double> &o, const double & a0) -> void { return o.randomize(a0); }, "", pybind11::arg("l"));
		cl.def("randomize", (void (ROL::Vector<double>::*)(const double, const double)) &ROL::Vector<double>::randomize, "Set vector to be uniform random between [l,u].\n\n             \n     is a the lower bound.\n             \n\n     is a the upper bound.\n\n             On return the components of \n are uniform\n             random numbers on the interval \n\n.\n       	     The default implementation uses #applyUnary methods for the\n       	     computation. Please overload if a more efficient implementation is\n             needed.\n\n             ---\n\nC++: ROL::Vector<double>::randomize(const double, const double) --> void", pybind11::arg("l"), pybind11::arg("u"));
		cl.def("checkVector", [](ROL::Vector<double> const &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1) -> std::vector<double> { return o.checkVector(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("y"));
		cl.def("checkVector", [](ROL::Vector<double> const &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2) -> std::vector<double> { return o.checkVector(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("y"), pybind11::arg("printToStream"));
		cl.def("checkVector", (class std::vector<double> (ROL::Vector<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &) const) &ROL::Vector<double>::checkVector, "Verify vector-space methods.\n\n             \n     is a vector.\n             \n\n     is a vector.\n\n             Returns a vector of Reals, all of which should be close to zero.\n             They represent consistency errors in the vector space properties,\n             as follows:\n\n             - Commutativity of addition: \n.\n             - Associativity of addition: \n\n.\n             - Identity element of addition: \n\n.\n             - Inverse elements of addition: \n\n.\n             - Identity element of scalar multiplication: \n\n.\n             - Consistency of scalar multiplication with field multiplication: \n\n.\n             - Distributivity of scalar multiplication with respect to field addition: \n\n.\n             - Distributivity of scalar multiplication with respect to vector addition: \n\n.\n             - Commutativity of dot (inner) product over the field of reals: \n\n.\n             - Additivity of dot (inner) product: \n\n.\n             - Consistency of scalar multiplication and norm: \n\n.\n             - Reflexivity: \n\n .\n             - Consistency of apply and dual: \n\n.\n\n             The consistency errors are defined as the norms or absolute values of the differences between the left-hand\n             side and the right-hand side terms in the above equalities.\n\n             ---\n\nC++: ROL::Vector<double>::checkVector(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &) const --> class std::vector<double>", pybind11::arg("x"), pybind11::arg("y"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Vector<double> & (ROL::Vector<double>::*)(const class ROL::Vector<double> &)) &ROL::Vector<double>::operator=, "C++: ROL::Vector<double>::operator=(const class ROL::Vector<double> &) --> class ROL::Vector<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	// ROL::RiskMeasureInfo(class Teuchos::ParameterList &, std::string &, int &, class std::vector<double> &, class std::vector<double> &, bool &, const bool, std::ostream &) file:ROL_RiskMeasureInfo.hpp line:19
	M("ROL").def("RiskMeasureInfo", [](class Teuchos::ParameterList & a0, std::string & a1, int & a2, class std::vector<double> & a3, class std::vector<double> & a4, bool & a5) -> void { return ROL::RiskMeasureInfo(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("parlist"), pybind11::arg("name"), pybind11::arg("nStatistic"), pybind11::arg("lower"), pybind11::arg("upper"), pybind11::arg("isBoundActivated"));
	M("ROL").def("RiskMeasureInfo", [](class Teuchos::ParameterList & a0, std::string & a1, int & a2, class std::vector<double> & a3, class std::vector<double> & a4, bool & a5, const bool & a6) -> void { return ROL::RiskMeasureInfo(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("parlist"), pybind11::arg("name"), pybind11::arg("nStatistic"), pybind11::arg("lower"), pybind11::arg("upper"), pybind11::arg("isBoundActivated"), pybind11::arg("printToStream"));
	M("ROL").def("RiskMeasureInfo", (void (*)(class Teuchos::ParameterList &, std::string &, int &, class std::vector<double> &, class std::vector<double> &, bool &, const bool, std::ostream &)) &ROL::RiskMeasureInfo<double>, "C++: ROL::RiskMeasureInfo(class Teuchos::ParameterList &, std::string &, int &, class std::vector<double> &, class std::vector<double> &, bool &, const bool, std::ostream &) --> void", pybind11::arg("parlist"), pybind11::arg("name"), pybind11::arg("nStatistic"), pybind11::arg("lower"), pybind11::arg("upper"), pybind11::arg("isBoundActivated"), pybind11::arg("printToStream"), pybind11::arg("outStream"));

	// ROL::DeviationMeasureInfo(class Teuchos::ParameterList &, std::string &, int &, class std::vector<double> &, class std::vector<double> &, bool &, const bool, std::ostream &) file:ROL_DeviationMeasureInfo.hpp line:19
	M("ROL").def("DeviationMeasureInfo", [](class Teuchos::ParameterList & a0, std::string & a1, int & a2, class std::vector<double> & a3, class std::vector<double> & a4, bool & a5) -> void { return ROL::DeviationMeasureInfo(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("parlist"), pybind11::arg("name"), pybind11::arg("nStatistic"), pybind11::arg("lower"), pybind11::arg("upper"), pybind11::arg("isBoundActivated"));
	M("ROL").def("DeviationMeasureInfo", [](class Teuchos::ParameterList & a0, std::string & a1, int & a2, class std::vector<double> & a3, class std::vector<double> & a4, bool & a5, const bool & a6) -> void { return ROL::DeviationMeasureInfo(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("parlist"), pybind11::arg("name"), pybind11::arg("nStatistic"), pybind11::arg("lower"), pybind11::arg("upper"), pybind11::arg("isBoundActivated"), pybind11::arg("printToStream"));
	M("ROL").def("DeviationMeasureInfo", (void (*)(class Teuchos::ParameterList &, std::string &, int &, class std::vector<double> &, class std::vector<double> &, bool &, const bool, std::ostream &)) &ROL::DeviationMeasureInfo<double>, "C++: ROL::DeviationMeasureInfo(class Teuchos::ParameterList &, std::string &, int &, class std::vector<double> &, class std::vector<double> &, bool &, const bool, std::ostream &) --> void", pybind11::arg("parlist"), pybind11::arg("name"), pybind11::arg("nStatistic"), pybind11::arg("lower"), pybind11::arg("upper"), pybind11::arg("isBoundActivated"), pybind11::arg("printToStream"), pybind11::arg("outStream"));

	// ROL::ErrorMeasureInfo(class Teuchos::ParameterList &, std::string &, int &, class std::vector<double> &, class std::vector<double> &, bool &, const bool, std::ostream &) file:ROL_ErrorMeasureInfo.hpp line:19
	M("ROL").def("ErrorMeasureInfo", [](class Teuchos::ParameterList & a0, std::string & a1, int & a2, class std::vector<double> & a3, class std::vector<double> & a4, bool & a5) -> void { return ROL::ErrorMeasureInfo(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("parlist"), pybind11::arg("name"), pybind11::arg("nStatistic"), pybind11::arg("lower"), pybind11::arg("upper"), pybind11::arg("isBoundActivated"));
	M("ROL").def("ErrorMeasureInfo", [](class Teuchos::ParameterList & a0, std::string & a1, int & a2, class std::vector<double> & a3, class std::vector<double> & a4, bool & a5, const bool & a6) -> void { return ROL::ErrorMeasureInfo(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("parlist"), pybind11::arg("name"), pybind11::arg("nStatistic"), pybind11::arg("lower"), pybind11::arg("upper"), pybind11::arg("isBoundActivated"), pybind11::arg("printToStream"));
	M("ROL").def("ErrorMeasureInfo", (void (*)(class Teuchos::ParameterList &, std::string &, int &, class std::vector<double> &, class std::vector<double> &, bool &, const bool, std::ostream &)) &ROL::ErrorMeasureInfo<double>, "C++: ROL::ErrorMeasureInfo(class Teuchos::ParameterList &, std::string &, int &, class std::vector<double> &, class std::vector<double> &, bool &, const bool, std::ostream &) --> void", pybind11::arg("parlist"), pybind11::arg("name"), pybind11::arg("nStatistic"), pybind11::arg("lower"), pybind11::arg("upper"), pybind11::arg("isBoundActivated"), pybind11::arg("printToStream"), pybind11::arg("outStream"));

	// ROL::RegretMeasureInfo(class Teuchos::ParameterList &, std::string &, int &, class std::vector<double> &, class std::vector<double> &, bool &, const bool, std::ostream &) file:ROL_RegretMeasureInfo.hpp line:19
	M("ROL").def("RegretMeasureInfo", [](class Teuchos::ParameterList & a0, std::string & a1, int & a2, class std::vector<double> & a3, class std::vector<double> & a4, bool & a5) -> void { return ROL::RegretMeasureInfo(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("parlist"), pybind11::arg("name"), pybind11::arg("nStatistic"), pybind11::arg("lower"), pybind11::arg("upper"), pybind11::arg("isBoundActivated"));
	M("ROL").def("RegretMeasureInfo", [](class Teuchos::ParameterList & a0, std::string & a1, int & a2, class std::vector<double> & a3, class std::vector<double> & a4, bool & a5, const bool & a6) -> void { return ROL::RegretMeasureInfo(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("parlist"), pybind11::arg("name"), pybind11::arg("nStatistic"), pybind11::arg("lower"), pybind11::arg("upper"), pybind11::arg("isBoundActivated"), pybind11::arg("printToStream"));
	M("ROL").def("RegretMeasureInfo", (void (*)(class Teuchos::ParameterList &, std::string &, int &, class std::vector<double> &, class std::vector<double> &, bool &, const bool, std::ostream &)) &ROL::RegretMeasureInfo<double>, "C++: ROL::RegretMeasureInfo(class Teuchos::ParameterList &, std::string &, int &, class std::vector<double> &, class std::vector<double> &, bool &, const bool, std::ostream &) --> void", pybind11::arg("parlist"), pybind11::arg("name"), pybind11::arg("nStatistic"), pybind11::arg("lower"), pybind11::arg("upper"), pybind11::arg("isBoundActivated"), pybind11::arg("printToStream"), pybind11::arg("outStream"));

	// ROL::ProbabilityInfo(class Teuchos::ParameterList &, std::string &, int &, class std::vector<double> &, class std::vector<double> &, bool &, const bool, std::ostream &) file:ROL_ProbabilityInfo.hpp line:19
	M("ROL").def("ProbabilityInfo", [](class Teuchos::ParameterList & a0, std::string & a1, int & a2, class std::vector<double> & a3, class std::vector<double> & a4, bool & a5) -> void { return ROL::ProbabilityInfo(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("parlist"), pybind11::arg("name"), pybind11::arg("nStatistic"), pybind11::arg("lower"), pybind11::arg("upper"), pybind11::arg("isBoundActivated"));
	M("ROL").def("ProbabilityInfo", [](class Teuchos::ParameterList & a0, std::string & a1, int & a2, class std::vector<double> & a3, class std::vector<double> & a4, bool & a5, const bool & a6) -> void { return ROL::ProbabilityInfo(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("parlist"), pybind11::arg("name"), pybind11::arg("nStatistic"), pybind11::arg("lower"), pybind11::arg("upper"), pybind11::arg("isBoundActivated"), pybind11::arg("printToStream"));
	M("ROL").def("ProbabilityInfo", (void (*)(class Teuchos::ParameterList &, std::string &, int &, class std::vector<double> &, class std::vector<double> &, bool &, const bool, std::ostream &)) &ROL::ProbabilityInfo<double>, "C++: ROL::ProbabilityInfo(class Teuchos::ParameterList &, std::string &, int &, class std::vector<double> &, class std::vector<double> &, bool &, const bool, std::ostream &) --> void", pybind11::arg("parlist"), pybind11::arg("name"), pybind11::arg("nStatistic"), pybind11::arg("lower"), pybind11::arg("upper"), pybind11::arg("isBoundActivated"), pybind11::arg("printToStream"), pybind11::arg("outStream"));

	// ROL::RandVarFunctionalInfo(class Teuchos::ParameterList &, std::string &, int &, class std::vector<double> &, class std::vector<double> &, bool &, const bool, std::ostream &) file:ROL_RandVarFunctionalInfo.hpp line:22
	M("ROL").def("RandVarFunctionalInfo", [](class Teuchos::ParameterList & a0, std::string & a1, int & a2, class std::vector<double> & a3, class std::vector<double> & a4, bool & a5) -> void { return ROL::RandVarFunctionalInfo(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("parlist"), pybind11::arg("name"), pybind11::arg("nStatistic"), pybind11::arg("lower"), pybind11::arg("upper"), pybind11::arg("isBoundActivated"));
	M("ROL").def("RandVarFunctionalInfo", [](class Teuchos::ParameterList & a0, std::string & a1, int & a2, class std::vector<double> & a3, class std::vector<double> & a4, bool & a5, const bool & a6) -> void { return ROL::RandVarFunctionalInfo(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("parlist"), pybind11::arg("name"), pybind11::arg("nStatistic"), pybind11::arg("lower"), pybind11::arg("upper"), pybind11::arg("isBoundActivated"), pybind11::arg("printToStream"));
	M("ROL").def("RandVarFunctionalInfo", (void (*)(class Teuchos::ParameterList &, std::string &, int &, class std::vector<double> &, class std::vector<double> &, bool &, const bool, std::ostream &)) &ROL::RandVarFunctionalInfo<double>, "C++: ROL::RandVarFunctionalInfo(class Teuchos::ParameterList &, std::string &, int &, class std::vector<double> &, class std::vector<double> &, bool &, const bool, std::ostream &) --> void", pybind11::arg("parlist"), pybind11::arg("name"), pybind11::arg("nStatistic"), pybind11::arg("lower"), pybind11::arg("upper"), pybind11::arg("isBoundActivated"), pybind11::arg("printToStream"), pybind11::arg("outStream"));

	{ // ROL::RiskVector file:ROL_RiskVector.hpp line:20
		pybind11::class_<ROL::RiskVector<double>, Teuchos::RCP<ROL::RiskVector<double>>, PyCallBack_ROL_RiskVector_double_t, ROL::Vector<double>> cl(M("ROL"), "RiskVector_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](class Teuchos::RCP<class Teuchos::ParameterList> & a0, const class Teuchos::RCP<class ROL::Vector<double> > & a1){ return new ROL::RiskVector<double>(a0, a1); }, [](class Teuchos::RCP<class Teuchos::ParameterList> & a0, const class Teuchos::RCP<class ROL::Vector<double> > & a1){ return new PyCallBack_ROL_RiskVector_double_t(a0, a1); } ), "doc");
		cl.def( pybind11::init<class Teuchos::RCP<class Teuchos::ParameterList> &, const class Teuchos::RCP<class ROL::Vector<double> > &, const double>(), pybind11::arg("parlist"), pybind11::arg("vec"), pybind11::arg("stat") );

		cl.def( pybind11::init<const class Teuchos::RCP<class ROL::Vector<double> > &>(), pybind11::arg("vec") );

		cl.def( pybind11::init( [](PyCallBack_ROL_RiskVector_double_t const &o){ return new PyCallBack_ROL_RiskVector_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::RiskVector<double> const &o){ return new ROL::RiskVector<double>(o); } ) );
		cl.def("set", (void (ROL::RiskVector<double>::*)(const class ROL::Vector<double> &)) &ROL::RiskVector<double>::set, "C++: ROL::RiskVector<double>::set(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("plus", (void (ROL::RiskVector<double>::*)(const class ROL::Vector<double> &)) &ROL::RiskVector<double>::plus, "C++: ROL::RiskVector<double>::plus(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("scale", (void (ROL::RiskVector<double>::*)(const double)) &ROL::RiskVector<double>::scale, "C++: ROL::RiskVector<double>::scale(const double) --> void", pybind11::arg("alpha"));
		cl.def("axpy", (void (ROL::RiskVector<double>::*)(const double, const class ROL::Vector<double> &)) &ROL::RiskVector<double>::axpy, "C++: ROL::RiskVector<double>::axpy(const double, const class ROL::Vector<double> &) --> void", pybind11::arg("alpha"), pybind11::arg("x"));
		cl.def("dot", (double (ROL::RiskVector<double>::*)(const class ROL::Vector<double> &) const) &ROL::RiskVector<double>::dot, "C++: ROL::RiskVector<double>::dot(const class ROL::Vector<double> &) const --> double", pybind11::arg("x"));
		cl.def("norm", (double (ROL::RiskVector<double>::*)() const) &ROL::RiskVector<double>::norm, "C++: ROL::RiskVector<double>::norm() const --> double");
		cl.def("clone", (class Teuchos::RCP<class ROL::Vector<double> > (ROL::RiskVector<double>::*)() const) &ROL::RiskVector<double>::clone, "C++: ROL::RiskVector<double>::clone() const --> class Teuchos::RCP<class ROL::Vector<double> >");
		cl.def("dual", (const class ROL::Vector<double> & (ROL::RiskVector<double>::*)() const) &ROL::RiskVector<double>::dual, "C++: ROL::RiskVector<double>::dual() const --> const class ROL::Vector<double> &", pybind11::return_value_policy::automatic);
		cl.def("basis", (class Teuchos::RCP<class ROL::Vector<double> > (ROL::RiskVector<double>::*)(const int) const) &ROL::RiskVector<double>::basis, "C++: ROL::RiskVector<double>::basis(const int) const --> class Teuchos::RCP<class ROL::Vector<double> >", pybind11::arg("i"));
		cl.def("applyUnary", (void (ROL::RiskVector<double>::*)(const class ROL::Elementwise::UnaryFunction<double> &)) &ROL::RiskVector<double>::applyUnary, "C++: ROL::RiskVector<double>::applyUnary(const class ROL::Elementwise::UnaryFunction<double> &) --> void", pybind11::arg("f"));
		cl.def("applyBinary", (void (ROL::RiskVector<double>::*)(const class ROL::Elementwise::BinaryFunction<double> &, const class ROL::Vector<double> &)) &ROL::RiskVector<double>::applyBinary, "C++: ROL::RiskVector<double>::applyBinary(const class ROL::Elementwise::BinaryFunction<double> &, const class ROL::Vector<double> &) --> void", pybind11::arg("f"), pybind11::arg("x"));
		cl.def("reduce", (double (ROL::RiskVector<double>::*)(const class ROL::Elementwise::ReductionOp<double> &) const) &ROL::RiskVector<double>::reduce, "C++: ROL::RiskVector<double>::reduce(const class ROL::Elementwise::ReductionOp<double> &) const --> double", pybind11::arg("r"));
		cl.def("setScalar", (void (ROL::RiskVector<double>::*)(const double)) &ROL::RiskVector<double>::setScalar, "C++: ROL::RiskVector<double>::setScalar(const double) --> void", pybind11::arg("C"));
		cl.def("randomize", [](ROL::RiskVector<double> &o) -> void { return o.randomize(); }, "");
		cl.def("randomize", [](ROL::RiskVector<double> &o, const double & a0) -> void { return o.randomize(a0); }, "", pybind11::arg("l"));
		cl.def("randomize", (void (ROL::RiskVector<double>::*)(const double, const double)) &ROL::RiskVector<double>::randomize, "C++: ROL::RiskVector<double>::randomize(const double, const double) --> void", pybind11::arg("l"), pybind11::arg("u"));
		cl.def("dimension", (int (ROL::RiskVector<double>::*)() const) &ROL::RiskVector<double>::dimension, "C++: ROL::RiskVector<double>::dimension() const --> int");
		cl.def("getStatisticVector", [](ROL::RiskVector<double> &o, const int & a0) -> Teuchos::RCP<class ROL::StdVector<double> > { return o.getStatisticVector(a0); }, "", pybind11::arg("comp"));
		cl.def("getStatisticVector", (class Teuchos::RCP<class ROL::StdVector<double> > (ROL::RiskVector<double>::*)(const int, const int)) &ROL::RiskVector<double>::getStatisticVector, "C++: ROL::RiskVector<double>::getStatisticVector(const int, const int) --> class Teuchos::RCP<class ROL::StdVector<double> >", pybind11::arg("comp"), pybind11::arg("index"));
		cl.def("getVector", (class Teuchos::RCP<class ROL::Vector<double> > (ROL::RiskVector<double>::*)()) &ROL::RiskVector<double>::getVector, "C++: ROL::RiskVector<double>::getVector() --> class Teuchos::RCP<class ROL::Vector<double> >");
		cl.def("getStatistic", [](ROL::RiskVector<double> &o) -> Teuchos::RCP<class std::vector<double> > { return o.getStatistic(); }, "");
		cl.def("getStatistic", [](ROL::RiskVector<double> &o, const int & a0) -> Teuchos::RCP<class std::vector<double> > { return o.getStatistic(a0); }, "", pybind11::arg("comp"));
		cl.def("getStatistic", (class Teuchos::RCP<class std::vector<double> > (ROL::RiskVector<double>::*)(const int, const int)) &ROL::RiskVector<double>::getStatistic, "C++: ROL::RiskVector<double>::getStatistic(const int, const int) --> class Teuchos::RCP<class std::vector<double> >", pybind11::arg("comp"), pybind11::arg("index"));
		cl.def("setStatistic", [](ROL::RiskVector<double> &o, const double & a0) -> void { return o.setStatistic(a0); }, "", pybind11::arg("stat"));
		cl.def("setStatistic", [](ROL::RiskVector<double> &o, const double & a0, const int & a1) -> void { return o.setStatistic(a0, a1); }, "", pybind11::arg("stat"), pybind11::arg("comp"));
		cl.def("setStatistic", (void (ROL::RiskVector<double>::*)(const double, const int, const int)) &ROL::RiskVector<double>::setStatistic, "C++: ROL::RiskVector<double>::setStatistic(const double, const int, const int) --> void", pybind11::arg("stat"), pybind11::arg("comp"), pybind11::arg("index"));
		cl.def("setStatistic", [](ROL::RiskVector<double> &o, const class std::vector<double> & a0) -> void { return o.setStatistic(a0); }, "", pybind11::arg("stat"));
		cl.def("setStatistic", [](ROL::RiskVector<double> &o, const class std::vector<double> & a0, const int & a1) -> void { return o.setStatistic(a0, a1); }, "", pybind11::arg("stat"), pybind11::arg("comp"));
		cl.def("setStatistic", (void (ROL::RiskVector<double>::*)(const class std::vector<double> &, const int, const int)) &ROL::RiskVector<double>::setStatistic, "C++: ROL::RiskVector<double>::setStatistic(const class std::vector<double> &, const int, const int) --> void", pybind11::arg("stat"), pybind11::arg("comp"), pybind11::arg("index"));
		cl.def("setVector", (void (ROL::RiskVector<double>::*)(const class ROL::Vector<double> &)) &ROL::RiskVector<double>::setVector, "C++: ROL::RiskVector<double>::setVector(const class ROL::Vector<double> &) --> void", pybind11::arg("vec"));
		cl.def("assign", (class ROL::RiskVector<double> & (ROL::RiskVector<double>::*)(const class ROL::RiskVector<double> &)) &ROL::RiskVector<double>::operator=, "C++: ROL::RiskVector<double>::operator=(const class ROL::RiskVector<double> &) --> class ROL::RiskVector<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("plus", (void (ROL::Vector<double>::*)(const class ROL::Vector<double> &)) &ROL::Vector<double>::plus, "C++: ROL::Vector<double>::plus(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("scale", (void (ROL::Vector<double>::*)(const double)) &ROL::Vector<double>::scale, "C++: ROL::Vector<double>::scale(const double) --> void", pybind11::arg("alpha"));
		cl.def("dot", (double (ROL::Vector<double>::*)(const class ROL::Vector<double> &) const) &ROL::Vector<double>::dot, "C++: ROL::Vector<double>::dot(const class ROL::Vector<double> &) const --> double", pybind11::arg("x"));
		cl.def("norm", (double (ROL::Vector<double>::*)() const) &ROL::Vector<double>::norm, "C++: ROL::Vector<double>::norm() const --> double");
		cl.def("clone", (class Teuchos::RCP<class ROL::Vector<double> > (ROL::Vector<double>::*)() const) &ROL::Vector<double>::clone, "C++: ROL::Vector<double>::clone() const --> class Teuchos::RCP<class ROL::Vector<double> >");
		cl.def("axpy", (void (ROL::Vector<double>::*)(const double, const class ROL::Vector<double> &)) &ROL::Vector<double>::axpy, "Compute \n where \n.\n\n             \n is the scaling of \n             \n\n     is a vector.\n\n             On return \n.\n             Uses #clone, #set, #scale and #plus for the computation.\n             Please overload if a more efficient implementation is needed.\n\n             ---\n\nC++: ROL::Vector<double>::axpy(const double, const class ROL::Vector<double> &) --> void", pybind11::arg("alpha"), pybind11::arg("x"));
		cl.def("zero", (void (ROL::Vector<double>::*)()) &ROL::Vector<double>::zero, "Set to zero vector.\n\n             Uses #scale by zero for the computation.\n             Please overload if a more efficient implementation is needed.\n\n             ---\n\nC++: ROL::Vector<double>::zero() --> void");
		cl.def("basis", (class Teuchos::RCP<class ROL::Vector<double> > (ROL::Vector<double>::*)(const int) const) &ROL::Vector<double>::basis, "Return i-th basis vector.\n\n             \n is the index of the basis function.\n             \n\n A reference-counted pointer to the basis vector with index \n\n             Overloading the basis is only required if the default gradient implementation\n             is used, which computes a finite-difference approximation.\n\n             ---\n\nC++: ROL::Vector<double>::basis(const int) const --> class Teuchos::RCP<class ROL::Vector<double> >", pybind11::arg("i"));
		cl.def("dimension", (int (ROL::Vector<double>::*)() const) &ROL::Vector<double>::dimension, "Return dimension of the vector space.\n\n             \n The dimension of the vector space, i.e., the total number of basis vectors.\n\n             Overload if the basis is overloaded.\n\n             ---\n\nC++: ROL::Vector<double>::dimension() const --> int");
		cl.def("set", (void (ROL::Vector<double>::*)(const class ROL::Vector<double> &)) &ROL::Vector<double>::set, "Set \n where \n.\n\n             \n     is a vector.\n\n             On return \n.\n             Uses #zero and #plus methods for the computation.\n             Please overload if a more efficient implementation is needed.\n\n             ---\n\nC++: ROL::Vector<double>::set(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("dual", (const class ROL::Vector<double> & (ROL::Vector<double>::*)() const) &ROL::Vector<double>::dual, "Return dual representation of \n, for example,\n             the result of applying a Riesz map, or change of basis, or\n             change of memory layout.\n\n             \n         A const reference to dual representation.\n\n             By default, returns the current object.\n             Please overload if you need a dual representation.\n\n             ---\n\nC++: ROL::Vector<double>::dual() const --> const class ROL::Vector<double> &", pybind11::return_value_policy::automatic);
		cl.def("apply", (double (ROL::Vector<double>::*)(const class ROL::Vector<double> &) const) &ROL::Vector<double>::apply, "Apply \n to a dual vector.  This is equivalent\n             to the call \n\n.\n\n             \n      is a vector\n             \n\n         The number equal to \n.\n\n             ---\n\nC++: ROL::Vector<double>::apply(const class ROL::Vector<double> &) const --> double", pybind11::arg("x"));
		cl.def("applyUnary", (void (ROL::Vector<double>::*)(const class ROL::Elementwise::UnaryFunction<double> &)) &ROL::Vector<double>::applyUnary, "C++: ROL::Vector<double>::applyUnary(const class ROL::Elementwise::UnaryFunction<double> &) --> void", pybind11::arg("f"));
		cl.def("applyBinary", (void (ROL::Vector<double>::*)(const class ROL::Elementwise::BinaryFunction<double> &, const class ROL::Vector<double> &)) &ROL::Vector<double>::applyBinary, "C++: ROL::Vector<double>::applyBinary(const class ROL::Elementwise::BinaryFunction<double> &, const class ROL::Vector<double> &) --> void", pybind11::arg("f"), pybind11::arg("x"));
		cl.def("reduce", (double (ROL::Vector<double>::*)(const class ROL::Elementwise::ReductionOp<double> &) const) &ROL::Vector<double>::reduce, "C++: ROL::Vector<double>::reduce(const class ROL::Elementwise::ReductionOp<double> &) const --> double", pybind11::arg("r"));
		cl.def("print", (void (ROL::Vector<double>::*)(std::ostream &) const) &ROL::Vector<double>::print, "C++: ROL::Vector<double>::print(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("setScalar", (void (ROL::Vector<double>::*)(const double)) &ROL::Vector<double>::setScalar, "Set \n where \n.\n\n             \n     is a scalar.\n\n             On return \n.\n             Uses #applyUnary methods for the computation.\n             Please overload if a more efficient implementation is needed.\n\n             ---\n\nC++: ROL::Vector<double>::setScalar(const double) --> void", pybind11::arg("C"));
		cl.def("randomize", [](ROL::Vector<double> &o) -> void { return o.randomize(); }, "");
		cl.def("randomize", [](ROL::Vector<double> &o, const double & a0) -> void { return o.randomize(a0); }, "", pybind11::arg("l"));
		cl.def("randomize", (void (ROL::Vector<double>::*)(const double, const double)) &ROL::Vector<double>::randomize, "Set vector to be uniform random between [l,u].\n\n             \n     is a the lower bound.\n             \n\n     is a the upper bound.\n\n             On return the components of \n are uniform\n             random numbers on the interval \n\n.\n       	     The default implementation uses #applyUnary methods for the\n       	     computation. Please overload if a more efficient implementation is\n             needed.\n\n             ---\n\nC++: ROL::Vector<double>::randomize(const double, const double) --> void", pybind11::arg("l"), pybind11::arg("u"));
		cl.def("checkVector", [](ROL::Vector<double> const &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1) -> std::vector<double> { return o.checkVector(a0, a1); }, "", pybind11::arg("x"), pybind11::arg("y"));
		cl.def("checkVector", [](ROL::Vector<double> const &o, const class ROL::Vector<double> & a0, const class ROL::Vector<double> & a1, const bool & a2) -> std::vector<double> { return o.checkVector(a0, a1, a2); }, "", pybind11::arg("x"), pybind11::arg("y"), pybind11::arg("printToStream"));
		cl.def("checkVector", (class std::vector<double> (ROL::Vector<double>::*)(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &) const) &ROL::Vector<double>::checkVector, "Verify vector-space methods.\n\n             \n     is a vector.\n             \n\n     is a vector.\n\n             Returns a vector of Reals, all of which should be close to zero.\n             They represent consistency errors in the vector space properties,\n             as follows:\n\n             - Commutativity of addition: \n.\n             - Associativity of addition: \n\n.\n             - Identity element of addition: \n\n.\n             - Inverse elements of addition: \n\n.\n             - Identity element of scalar multiplication: \n\n.\n             - Consistency of scalar multiplication with field multiplication: \n\n.\n             - Distributivity of scalar multiplication with respect to field addition: \n\n.\n             - Distributivity of scalar multiplication with respect to vector addition: \n\n.\n             - Commutativity of dot (inner) product over the field of reals: \n\n.\n             - Additivity of dot (inner) product: \n\n.\n             - Consistency of scalar multiplication and norm: \n\n.\n             - Reflexivity: \n\n .\n             - Consistency of apply and dual: \n\n.\n\n             The consistency errors are defined as the norms or absolute values of the differences between the left-hand\n             side and the right-hand side terms in the above equalities.\n\n             ---\n\nC++: ROL::Vector<double>::checkVector(const class ROL::Vector<double> &, const class ROL::Vector<double> &, const bool, std::ostream &) const --> class std::vector<double>", pybind11::arg("x"), pybind11::arg("y"), pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Vector<double> & (ROL::Vector<double>::*)(const class ROL::Vector<double> &)) &ROL::Vector<double>::operator=, "C++: ROL::Vector<double>::operator=(const class ROL::Vector<double> &) --> class ROL::Vector<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::PositiveFunction file:ROL_PositiveFunction.hpp line:16
		pybind11::class_<ROL::PositiveFunction<double>, Teuchos::RCP<ROL::PositiveFunction<double>>, PyCallBack_ROL_PositiveFunction_double_t> cl(M("ROL"), "PositiveFunction_double_t", "", pybind11::module_local());
		cl.def(pybind11::init<PyCallBack_ROL_PositiveFunction_double_t const &>());
		cl.def( pybind11::init( [](){ return new PyCallBack_ROL_PositiveFunction_double_t(); } ) );
		cl.def("evaluate", (double (ROL::PositiveFunction<double>::*)(double, int)) &ROL::PositiveFunction<double>::evaluate, "C++: ROL::PositiveFunction<double>::evaluate(double, int) --> double", pybind11::arg("input"), pybind11::arg("deriv"));
		cl.def("assign", (class ROL::PositiveFunction<double> & (ROL::PositiveFunction<double>::*)(const class ROL::PositiveFunction<double> &)) &ROL::PositiveFunction<double>::operator=, "C++: ROL::PositiveFunction<double>::operator=(const class ROL::PositiveFunction<double> &) --> class ROL::PositiveFunction<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::Dirac file:ROL_Dirac.hpp line:19
		pybind11::class_<ROL::Dirac<double>, Teuchos::RCP<ROL::Dirac<double>>, PyCallBack_ROL_Dirac_double_t, ROL::Distribution<double>> cl(M("ROL"), "Dirac_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::Dirac<double>(); }, [](){ return new PyCallBack_ROL_Dirac_double_t(); } ), "doc");
		cl.def( pybind11::init<const double>(), pybind11::arg("data") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_Dirac_double_t const &o){ return new PyCallBack_ROL_Dirac_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::Dirac<double> const &o){ return new ROL::Dirac<double>(o); } ) );
		cl.def("evaluatePDF", (double (ROL::Dirac<double>::*)(const double) const) &ROL::Dirac<double>::evaluatePDF, "C++: ROL::Dirac<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Dirac<double>::*)(const double) const) &ROL::Dirac<double>::evaluateCDF, "C++: ROL::Dirac<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Dirac<double>::*)(const double) const) &ROL::Dirac<double>::integrateCDF, "C++: ROL::Dirac<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Dirac<double>::*)(const double) const) &ROL::Dirac<double>::invertCDF, "C++: ROL::Dirac<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Dirac<double>::*)(const unsigned long) const) &ROL::Dirac<double>::moment, "C++: ROL::Dirac<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Dirac<double>::*)() const) &ROL::Dirac<double>::lowerBound, "C++: ROL::Dirac<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Dirac<double>::*)() const) &ROL::Dirac<double>::upperBound, "C++: ROL::Dirac<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Dirac<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Dirac<double>::*)(std::ostream &) const) &ROL::Dirac<double>::test, "C++: ROL::Dirac<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Dirac<double> & (ROL::Dirac<double>::*)(const class ROL::Dirac<double> &)) &ROL::Dirac<double>::operator=, "C++: ROL::Dirac<double>::operator=(const class ROL::Dirac<double> &) --> class ROL::Dirac<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("evaluatePDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluatePDF, "C++: ROL::Distribution<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluateCDF, "C++: ROL::Distribution<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::integrateCDF, "C++: ROL::Distribution<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::invertCDF, "C++: ROL::Distribution<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Distribution<double>::*)(const unsigned long) const) &ROL::Distribution<double>::moment, "C++: ROL::Distribution<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::lowerBound, "C++: ROL::Distribution<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::upperBound, "C++: ROL::Distribution<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Distribution<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Distribution<double>::*)(std::ostream &) const) &ROL::Distribution<double>::test, "C++: ROL::Distribution<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Distribution<double> & (ROL::Distribution<double>::*)(const class ROL::Distribution<double> &)) &ROL::Distribution<double>::operator=, "C++: ROL::Distribution<double>::operator=(const class ROL::Distribution<double> &) --> class ROL::Distribution<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::Gaussian file:ROL_Gaussian.hpp line:19
		pybind11::class_<ROL::Gaussian<double>, Teuchos::RCP<ROL::Gaussian<double>>, PyCallBack_ROL_Gaussian_double_t, ROL::Distribution<double>> cl(M("ROL"), "Gaussian_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::Gaussian<double>(); }, [](){ return new PyCallBack_ROL_Gaussian_double_t(); } ), "doc");
		cl.def( pybind11::init( [](const double & a0){ return new ROL::Gaussian<double>(a0); }, [](const double & a0){ return new PyCallBack_ROL_Gaussian_double_t(a0); } ), "doc");
		cl.def( pybind11::init<const double, const double>(), pybind11::arg("mean"), pybind11::arg("variance") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_Gaussian_double_t const &o){ return new PyCallBack_ROL_Gaussian_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::Gaussian<double> const &o){ return new ROL::Gaussian<double>(o); } ) );
		cl.def("evaluatePDF", (double (ROL::Gaussian<double>::*)(const double) const) &ROL::Gaussian<double>::evaluatePDF, "C++: ROL::Gaussian<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Gaussian<double>::*)(const double) const) &ROL::Gaussian<double>::evaluateCDF, "C++: ROL::Gaussian<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Gaussian<double>::*)(const double) const) &ROL::Gaussian<double>::integrateCDF, "C++: ROL::Gaussian<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Gaussian<double>::*)(const double) const) &ROL::Gaussian<double>::invertCDF, "C++: ROL::Gaussian<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Gaussian<double>::*)(const unsigned long) const) &ROL::Gaussian<double>::moment, "C++: ROL::Gaussian<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Gaussian<double>::*)() const) &ROL::Gaussian<double>::lowerBound, "C++: ROL::Gaussian<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Gaussian<double>::*)() const) &ROL::Gaussian<double>::upperBound, "C++: ROL::Gaussian<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Gaussian<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Gaussian<double>::*)(std::ostream &) const) &ROL::Gaussian<double>::test, "C++: ROL::Gaussian<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Gaussian<double> & (ROL::Gaussian<double>::*)(const class ROL::Gaussian<double> &)) &ROL::Gaussian<double>::operator=, "C++: ROL::Gaussian<double>::operator=(const class ROL::Gaussian<double> &) --> class ROL::Gaussian<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("evaluatePDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluatePDF, "C++: ROL::Distribution<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluateCDF, "C++: ROL::Distribution<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::integrateCDF, "C++: ROL::Distribution<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::invertCDF, "C++: ROL::Distribution<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Distribution<double>::*)(const unsigned long) const) &ROL::Distribution<double>::moment, "C++: ROL::Distribution<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::lowerBound, "C++: ROL::Distribution<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::upperBound, "C++: ROL::Distribution<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Distribution<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Distribution<double>::*)(std::ostream &) const) &ROL::Distribution<double>::test, "C++: ROL::Distribution<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Distribution<double> & (ROL::Distribution<double>::*)(const class ROL::Distribution<double> &)) &ROL::Distribution<double>::operator=, "C++: ROL::Distribution<double>::operator=(const class ROL::Distribution<double> &) --> class ROL::Distribution<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::TruncatedGaussian file:ROL_TruncatedGaussian.hpp line:21
		pybind11::class_<ROL::TruncatedGaussian<double>, Teuchos::RCP<ROL::TruncatedGaussian<double>>, PyCallBack_ROL_TruncatedGaussian_double_t, ROL::Distribution<double>> cl(M("ROL"), "TruncatedGaussian_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::TruncatedGaussian<double>(); }, [](){ return new PyCallBack_ROL_TruncatedGaussian_double_t(); } ), "doc");
		cl.def( pybind11::init( [](const double & a0){ return new ROL::TruncatedGaussian<double>(a0); }, [](const double & a0){ return new PyCallBack_ROL_TruncatedGaussian_double_t(a0); } ), "doc");
		cl.def( pybind11::init( [](const double & a0, const double & a1){ return new ROL::TruncatedGaussian<double>(a0, a1); }, [](const double & a0, const double & a1){ return new PyCallBack_ROL_TruncatedGaussian_double_t(a0, a1); } ), "doc");
		cl.def( pybind11::init( [](const double & a0, const double & a1, const double & a2){ return new ROL::TruncatedGaussian<double>(a0, a1, a2); }, [](const double & a0, const double & a1, const double & a2){ return new PyCallBack_ROL_TruncatedGaussian_double_t(a0, a1, a2); } ), "doc");
		cl.def( pybind11::init<const double, const double, const double, const double>(), pybind11::arg("lo"), pybind11::arg("up"), pybind11::arg("mean"), pybind11::arg("sdev") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_TruncatedGaussian_double_t const &o){ return new PyCallBack_ROL_TruncatedGaussian_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::TruncatedGaussian<double> const &o){ return new ROL::TruncatedGaussian<double>(o); } ) );
		cl.def("evaluatePDF", (double (ROL::TruncatedGaussian<double>::*)(const double) const) &ROL::TruncatedGaussian<double>::evaluatePDF, "C++: ROL::TruncatedGaussian<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::TruncatedGaussian<double>::*)(const double) const) &ROL::TruncatedGaussian<double>::evaluateCDF, "C++: ROL::TruncatedGaussian<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::TruncatedGaussian<double>::*)(const double) const) &ROL::TruncatedGaussian<double>::integrateCDF, "C++: ROL::TruncatedGaussian<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::TruncatedGaussian<double>::*)(const double) const) &ROL::TruncatedGaussian<double>::invertCDF, "C++: ROL::TruncatedGaussian<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::TruncatedGaussian<double>::*)(const unsigned long) const) &ROL::TruncatedGaussian<double>::moment, "C++: ROL::TruncatedGaussian<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::TruncatedGaussian<double>::*)() const) &ROL::TruncatedGaussian<double>::lowerBound, "C++: ROL::TruncatedGaussian<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::TruncatedGaussian<double>::*)() const) &ROL::TruncatedGaussian<double>::upperBound, "C++: ROL::TruncatedGaussian<double>::upperBound() const --> double");
		cl.def("test", [](ROL::TruncatedGaussian<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::TruncatedGaussian<double>::*)(std::ostream &) const) &ROL::TruncatedGaussian<double>::test, "C++: ROL::TruncatedGaussian<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::TruncatedGaussian<double> & (ROL::TruncatedGaussian<double>::*)(const class ROL::TruncatedGaussian<double> &)) &ROL::TruncatedGaussian<double>::operator=, "C++: ROL::TruncatedGaussian<double>::operator=(const class ROL::TruncatedGaussian<double> &) --> class ROL::TruncatedGaussian<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("evaluatePDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluatePDF, "C++: ROL::Distribution<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluateCDF, "C++: ROL::Distribution<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::integrateCDF, "C++: ROL::Distribution<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::invertCDF, "C++: ROL::Distribution<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Distribution<double>::*)(const unsigned long) const) &ROL::Distribution<double>::moment, "C++: ROL::Distribution<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::lowerBound, "C++: ROL::Distribution<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::upperBound, "C++: ROL::Distribution<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Distribution<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Distribution<double>::*)(std::ostream &) const) &ROL::Distribution<double>::test, "C++: ROL::Distribution<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Distribution<double> & (ROL::Distribution<double>::*)(const class ROL::Distribution<double> &)) &ROL::Distribution<double>::operator=, "C++: ROL::Distribution<double>::operator=(const class ROL::Distribution<double> &) --> class ROL::Distribution<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::Uniform file:ROL_Uniform.hpp line:19
		pybind11::class_<ROL::Uniform<double>, Teuchos::RCP<ROL::Uniform<double>>, PyCallBack_ROL_Uniform_double_t, ROL::Distribution<double>> cl(M("ROL"), "Uniform_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::Uniform<double>(); }, [](){ return new PyCallBack_ROL_Uniform_double_t(); } ), "doc");
		cl.def( pybind11::init( [](const double & a0){ return new ROL::Uniform<double>(a0); }, [](const double & a0){ return new PyCallBack_ROL_Uniform_double_t(a0); } ), "doc");
		cl.def( pybind11::init<const double, const double>(), pybind11::arg("lo"), pybind11::arg("up") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_Uniform_double_t const &o){ return new PyCallBack_ROL_Uniform_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::Uniform<double> const &o){ return new ROL::Uniform<double>(o); } ) );
		cl.def("evaluatePDF", (double (ROL::Uniform<double>::*)(const double) const) &ROL::Uniform<double>::evaluatePDF, "C++: ROL::Uniform<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Uniform<double>::*)(const double) const) &ROL::Uniform<double>::evaluateCDF, "C++: ROL::Uniform<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Uniform<double>::*)(const double) const) &ROL::Uniform<double>::integrateCDF, "C++: ROL::Uniform<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Uniform<double>::*)(const double) const) &ROL::Uniform<double>::invertCDF, "C++: ROL::Uniform<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Uniform<double>::*)(const unsigned long) const) &ROL::Uniform<double>::moment, "C++: ROL::Uniform<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Uniform<double>::*)() const) &ROL::Uniform<double>::lowerBound, "C++: ROL::Uniform<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Uniform<double>::*)() const) &ROL::Uniform<double>::upperBound, "C++: ROL::Uniform<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Uniform<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Uniform<double>::*)(std::ostream &) const) &ROL::Uniform<double>::test, "C++: ROL::Uniform<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Uniform<double> & (ROL::Uniform<double>::*)(const class ROL::Uniform<double> &)) &ROL::Uniform<double>::operator=, "C++: ROL::Uniform<double>::operator=(const class ROL::Uniform<double> &) --> class ROL::Uniform<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("evaluatePDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluatePDF, "C++: ROL::Distribution<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluateCDF, "C++: ROL::Distribution<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::integrateCDF, "C++: ROL::Distribution<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::invertCDF, "C++: ROL::Distribution<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Distribution<double>::*)(const unsigned long) const) &ROL::Distribution<double>::moment, "C++: ROL::Distribution<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::lowerBound, "C++: ROL::Distribution<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::upperBound, "C++: ROL::Distribution<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Distribution<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Distribution<double>::*)(std::ostream &) const) &ROL::Distribution<double>::test, "C++: ROL::Distribution<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Distribution<double> & (ROL::Distribution<double>::*)(const class ROL::Distribution<double> &)) &ROL::Distribution<double>::operator=, "C++: ROL::Distribution<double>::operator=(const class ROL::Distribution<double> &) --> class ROL::Distribution<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::Logistic file:ROL_Logistic.hpp line:19
		pybind11::class_<ROL::Logistic<double>, Teuchos::RCP<ROL::Logistic<double>>, PyCallBack_ROL_Logistic_double_t, ROL::Distribution<double>> cl(M("ROL"), "Logistic_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::Logistic<double>(); }, [](){ return new PyCallBack_ROL_Logistic_double_t(); } ), "doc");
		cl.def( pybind11::init( [](const double & a0){ return new ROL::Logistic<double>(a0); }, [](const double & a0){ return new PyCallBack_ROL_Logistic_double_t(a0); } ), "doc");
		cl.def( pybind11::init<const double, const double>(), pybind11::arg("mean"), pybind11::arg("var") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_Logistic_double_t const &o){ return new PyCallBack_ROL_Logistic_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::Logistic<double> const &o){ return new ROL::Logistic<double>(o); } ) );
		cl.def("evaluatePDF", (double (ROL::Logistic<double>::*)(const double) const) &ROL::Logistic<double>::evaluatePDF, "C++: ROL::Logistic<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Logistic<double>::*)(const double) const) &ROL::Logistic<double>::evaluateCDF, "C++: ROL::Logistic<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Logistic<double>::*)(const double) const) &ROL::Logistic<double>::integrateCDF, "C++: ROL::Logistic<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Logistic<double>::*)(const double) const) &ROL::Logistic<double>::invertCDF, "C++: ROL::Logistic<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Logistic<double>::*)(const unsigned long) const) &ROL::Logistic<double>::moment, "C++: ROL::Logistic<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Logistic<double>::*)() const) &ROL::Logistic<double>::lowerBound, "C++: ROL::Logistic<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Logistic<double>::*)() const) &ROL::Logistic<double>::upperBound, "C++: ROL::Logistic<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Logistic<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Logistic<double>::*)(std::ostream &) const) &ROL::Logistic<double>::test, "C++: ROL::Logistic<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Logistic<double> & (ROL::Logistic<double>::*)(const class ROL::Logistic<double> &)) &ROL::Logistic<double>::operator=, "C++: ROL::Logistic<double>::operator=(const class ROL::Logistic<double> &) --> class ROL::Logistic<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("evaluatePDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluatePDF, "C++: ROL::Distribution<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluateCDF, "C++: ROL::Distribution<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::integrateCDF, "C++: ROL::Distribution<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::invertCDF, "C++: ROL::Distribution<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Distribution<double>::*)(const unsigned long) const) &ROL::Distribution<double>::moment, "C++: ROL::Distribution<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::lowerBound, "C++: ROL::Distribution<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::upperBound, "C++: ROL::Distribution<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Distribution<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Distribution<double>::*)(std::ostream &) const) &ROL::Distribution<double>::test, "C++: ROL::Distribution<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Distribution<double> & (ROL::Distribution<double>::*)(const class ROL::Distribution<double> &)) &ROL::Distribution<double>::operator=, "C++: ROL::Distribution<double>::operator=(const class ROL::Distribution<double> &) --> class ROL::Distribution<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::Triangle file:ROL_Triangle.hpp line:19
		pybind11::class_<ROL::Triangle<double>, Teuchos::RCP<ROL::Triangle<double>>, PyCallBack_ROL_Triangle_double_t, ROL::Distribution<double>> cl(M("ROL"), "Triangle_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::Triangle<double>(); }, [](){ return new PyCallBack_ROL_Triangle_double_t(); } ), "doc");
		cl.def( pybind11::init( [](const double & a0){ return new ROL::Triangle<double>(a0); }, [](const double & a0){ return new PyCallBack_ROL_Triangle_double_t(a0); } ), "doc");
		cl.def( pybind11::init( [](const double & a0, const double & a1){ return new ROL::Triangle<double>(a0, a1); }, [](const double & a0, const double & a1){ return new PyCallBack_ROL_Triangle_double_t(a0, a1); } ), "doc");
		cl.def( pybind11::init<const double, const double, const double>(), pybind11::arg("a"), pybind11::arg("b"), pybind11::arg("c") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_Triangle_double_t const &o){ return new PyCallBack_ROL_Triangle_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::Triangle<double> const &o){ return new ROL::Triangle<double>(o); } ) );
		cl.def("evaluatePDF", (double (ROL::Triangle<double>::*)(const double) const) &ROL::Triangle<double>::evaluatePDF, "C++: ROL::Triangle<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Triangle<double>::*)(const double) const) &ROL::Triangle<double>::evaluateCDF, "C++: ROL::Triangle<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Triangle<double>::*)(const double) const) &ROL::Triangle<double>::integrateCDF, "C++: ROL::Triangle<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Triangle<double>::*)(const double) const) &ROL::Triangle<double>::invertCDF, "C++: ROL::Triangle<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Triangle<double>::*)(const unsigned long) const) &ROL::Triangle<double>::moment, "C++: ROL::Triangle<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Triangle<double>::*)() const) &ROL::Triangle<double>::lowerBound, "C++: ROL::Triangle<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Triangle<double>::*)() const) &ROL::Triangle<double>::upperBound, "C++: ROL::Triangle<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Triangle<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Triangle<double>::*)(std::ostream &) const) &ROL::Triangle<double>::test, "C++: ROL::Triangle<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Triangle<double> & (ROL::Triangle<double>::*)(const class ROL::Triangle<double> &)) &ROL::Triangle<double>::operator=, "C++: ROL::Triangle<double>::operator=(const class ROL::Triangle<double> &) --> class ROL::Triangle<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("evaluatePDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluatePDF, "C++: ROL::Distribution<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluateCDF, "C++: ROL::Distribution<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::integrateCDF, "C++: ROL::Distribution<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::invertCDF, "C++: ROL::Distribution<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Distribution<double>::*)(const unsigned long) const) &ROL::Distribution<double>::moment, "C++: ROL::Distribution<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::lowerBound, "C++: ROL::Distribution<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::upperBound, "C++: ROL::Distribution<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Distribution<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Distribution<double>::*)(std::ostream &) const) &ROL::Distribution<double>::test, "C++: ROL::Distribution<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Distribution<double> & (ROL::Distribution<double>::*)(const class ROL::Distribution<double> &)) &ROL::Distribution<double>::operator=, "C++: ROL::Distribution<double>::operator=(const class ROL::Distribution<double> &) --> class ROL::Distribution<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::Parabolic file:ROL_Parabolic.hpp line:19
		pybind11::class_<ROL::Parabolic<double>, Teuchos::RCP<ROL::Parabolic<double>>, PyCallBack_ROL_Parabolic_double_t, ROL::Distribution<double>> cl(M("ROL"), "Parabolic_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::Parabolic<double>(); }, [](){ return new PyCallBack_ROL_Parabolic_double_t(); } ), "doc");
		cl.def( pybind11::init( [](const double & a0){ return new ROL::Parabolic<double>(a0); }, [](const double & a0){ return new PyCallBack_ROL_Parabolic_double_t(a0); } ), "doc");
		cl.def( pybind11::init<const double, const double>(), pybind11::arg("a"), pybind11::arg("b") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_Parabolic_double_t const &o){ return new PyCallBack_ROL_Parabolic_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::Parabolic<double> const &o){ return new ROL::Parabolic<double>(o); } ) );
		cl.def("evaluatePDF", (double (ROL::Parabolic<double>::*)(const double) const) &ROL::Parabolic<double>::evaluatePDF, "C++: ROL::Parabolic<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Parabolic<double>::*)(const double) const) &ROL::Parabolic<double>::evaluateCDF, "C++: ROL::Parabolic<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Parabolic<double>::*)(const double) const) &ROL::Parabolic<double>::integrateCDF, "C++: ROL::Parabolic<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Parabolic<double>::*)(const double) const) &ROL::Parabolic<double>::invertCDF, "C++: ROL::Parabolic<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Parabolic<double>::*)(const unsigned long) const) &ROL::Parabolic<double>::moment, "C++: ROL::Parabolic<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Parabolic<double>::*)() const) &ROL::Parabolic<double>::lowerBound, "C++: ROL::Parabolic<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Parabolic<double>::*)() const) &ROL::Parabolic<double>::upperBound, "C++: ROL::Parabolic<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Parabolic<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Parabolic<double>::*)(std::ostream &) const) &ROL::Parabolic<double>::test, "C++: ROL::Parabolic<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Parabolic<double> & (ROL::Parabolic<double>::*)(const class ROL::Parabolic<double> &)) &ROL::Parabolic<double>::operator=, "C++: ROL::Parabolic<double>::operator=(const class ROL::Parabolic<double> &) --> class ROL::Parabolic<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("evaluatePDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluatePDF, "C++: ROL::Distribution<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluateCDF, "C++: ROL::Distribution<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::integrateCDF, "C++: ROL::Distribution<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::invertCDF, "C++: ROL::Distribution<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Distribution<double>::*)(const unsigned long) const) &ROL::Distribution<double>::moment, "C++: ROL::Distribution<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::lowerBound, "C++: ROL::Distribution<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::upperBound, "C++: ROL::Distribution<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Distribution<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Distribution<double>::*)(std::ostream &) const) &ROL::Distribution<double>::test, "C++: ROL::Distribution<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Distribution<double> & (ROL::Distribution<double>::*)(const class ROL::Distribution<double> &)) &ROL::Distribution<double>::operator=, "C++: ROL::Distribution<double>::operator=(const class ROL::Distribution<double> &) --> class ROL::Distribution<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::RaisedCosine file:ROL_RaisedCosine.hpp line:19
		pybind11::class_<ROL::RaisedCosine<double>, Teuchos::RCP<ROL::RaisedCosine<double>>, PyCallBack_ROL_RaisedCosine_double_t, ROL::Distribution<double>> cl(M("ROL"), "RaisedCosine_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::RaisedCosine<double>(); }, [](){ return new PyCallBack_ROL_RaisedCosine_double_t(); } ), "doc");
		cl.def( pybind11::init( [](const double & a0){ return new ROL::RaisedCosine<double>(a0); }, [](const double & a0){ return new PyCallBack_ROL_RaisedCosine_double_t(a0); } ), "doc");
		cl.def( pybind11::init<const double, const double>(), pybind11::arg("mean"), pybind11::arg("var") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_RaisedCosine_double_t const &o){ return new PyCallBack_ROL_RaisedCosine_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::RaisedCosine<double> const &o){ return new ROL::RaisedCosine<double>(o); } ) );
		cl.def("evaluatePDF", (double (ROL::RaisedCosine<double>::*)(const double) const) &ROL::RaisedCosine<double>::evaluatePDF, "C++: ROL::RaisedCosine<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::RaisedCosine<double>::*)(const double) const) &ROL::RaisedCosine<double>::evaluateCDF, "C++: ROL::RaisedCosine<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::RaisedCosine<double>::*)(const double) const) &ROL::RaisedCosine<double>::integrateCDF, "C++: ROL::RaisedCosine<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::RaisedCosine<double>::*)(const double) const) &ROL::RaisedCosine<double>::invertCDF, "C++: ROL::RaisedCosine<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::RaisedCosine<double>::*)(const unsigned long) const) &ROL::RaisedCosine<double>::moment, "C++: ROL::RaisedCosine<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::RaisedCosine<double>::*)() const) &ROL::RaisedCosine<double>::lowerBound, "C++: ROL::RaisedCosine<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::RaisedCosine<double>::*)() const) &ROL::RaisedCosine<double>::upperBound, "C++: ROL::RaisedCosine<double>::upperBound() const --> double");
		cl.def("test", [](ROL::RaisedCosine<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::RaisedCosine<double>::*)(std::ostream &) const) &ROL::RaisedCosine<double>::test, "C++: ROL::RaisedCosine<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::RaisedCosine<double> & (ROL::RaisedCosine<double>::*)(const class ROL::RaisedCosine<double> &)) &ROL::RaisedCosine<double>::operator=, "C++: ROL::RaisedCosine<double>::operator=(const class ROL::RaisedCosine<double> &) --> class ROL::RaisedCosine<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("evaluatePDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluatePDF, "C++: ROL::Distribution<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluateCDF, "C++: ROL::Distribution<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::integrateCDF, "C++: ROL::Distribution<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::invertCDF, "C++: ROL::Distribution<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Distribution<double>::*)(const unsigned long) const) &ROL::Distribution<double>::moment, "C++: ROL::Distribution<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::lowerBound, "C++: ROL::Distribution<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::upperBound, "C++: ROL::Distribution<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Distribution<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Distribution<double>::*)(std::ostream &) const) &ROL::Distribution<double>::test, "C++: ROL::Distribution<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Distribution<double> & (ROL::Distribution<double>::*)(const class ROL::Distribution<double> &)) &ROL::Distribution<double>::operator=, "C++: ROL::Distribution<double>::operator=(const class ROL::Distribution<double> &) --> class ROL::Distribution<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::Laplace file:ROL_Laplace.hpp line:19
		pybind11::class_<ROL::Laplace<double>, Teuchos::RCP<ROL::Laplace<double>>, PyCallBack_ROL_Laplace_double_t, ROL::Distribution<double>> cl(M("ROL"), "Laplace_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::Laplace<double>(); }, [](){ return new PyCallBack_ROL_Laplace_double_t(); } ), "doc");
		cl.def( pybind11::init( [](const double & a0){ return new ROL::Laplace<double>(a0); }, [](const double & a0){ return new PyCallBack_ROL_Laplace_double_t(a0); } ), "doc");
		cl.def( pybind11::init<const double, const double>(), pybind11::arg("mean"), pybind11::arg("scale") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_Laplace_double_t const &o){ return new PyCallBack_ROL_Laplace_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::Laplace<double> const &o){ return new ROL::Laplace<double>(o); } ) );
		cl.def("evaluatePDF", (double (ROL::Laplace<double>::*)(const double) const) &ROL::Laplace<double>::evaluatePDF, "C++: ROL::Laplace<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Laplace<double>::*)(const double) const) &ROL::Laplace<double>::evaluateCDF, "C++: ROL::Laplace<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Laplace<double>::*)(const double) const) &ROL::Laplace<double>::integrateCDF, "C++: ROL::Laplace<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Laplace<double>::*)(const double) const) &ROL::Laplace<double>::invertCDF, "C++: ROL::Laplace<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Laplace<double>::*)(const unsigned long) const) &ROL::Laplace<double>::moment, "C++: ROL::Laplace<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Laplace<double>::*)() const) &ROL::Laplace<double>::lowerBound, "C++: ROL::Laplace<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Laplace<double>::*)() const) &ROL::Laplace<double>::upperBound, "C++: ROL::Laplace<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Laplace<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Laplace<double>::*)(std::ostream &) const) &ROL::Laplace<double>::test, "C++: ROL::Laplace<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Laplace<double> & (ROL::Laplace<double>::*)(const class ROL::Laplace<double> &)) &ROL::Laplace<double>::operator=, "C++: ROL::Laplace<double>::operator=(const class ROL::Laplace<double> &) --> class ROL::Laplace<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("evaluatePDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluatePDF, "C++: ROL::Distribution<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluateCDF, "C++: ROL::Distribution<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::integrateCDF, "C++: ROL::Distribution<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::invertCDF, "C++: ROL::Distribution<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Distribution<double>::*)(const unsigned long) const) &ROL::Distribution<double>::moment, "C++: ROL::Distribution<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::lowerBound, "C++: ROL::Distribution<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::upperBound, "C++: ROL::Distribution<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Distribution<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Distribution<double>::*)(std::ostream &) const) &ROL::Distribution<double>::test, "C++: ROL::Distribution<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Distribution<double> & (ROL::Distribution<double>::*)(const class ROL::Distribution<double> &)) &ROL::Distribution<double>::operator=, "C++: ROL::Distribution<double>::operator=(const class ROL::Distribution<double> &) --> class ROL::Distribution<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::Cauchy file:ROL_Cauchy.hpp line:19
		pybind11::class_<ROL::Cauchy<double>, Teuchos::RCP<ROL::Cauchy<double>>, PyCallBack_ROL_Cauchy_double_t, ROL::Distribution<double>> cl(M("ROL"), "Cauchy_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::Cauchy<double>(); }, [](){ return new PyCallBack_ROL_Cauchy_double_t(); } ), "doc");
		cl.def( pybind11::init( [](const double & a0){ return new ROL::Cauchy<double>(a0); }, [](const double & a0){ return new PyCallBack_ROL_Cauchy_double_t(a0); } ), "doc");
		cl.def( pybind11::init<const double, const double>(), pybind11::arg("loc"), pybind11::arg("scale") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_Cauchy_double_t const &o){ return new PyCallBack_ROL_Cauchy_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::Cauchy<double> const &o){ return new ROL::Cauchy<double>(o); } ) );
		cl.def("evaluatePDF", (double (ROL::Cauchy<double>::*)(const double) const) &ROL::Cauchy<double>::evaluatePDF, "C++: ROL::Cauchy<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Cauchy<double>::*)(const double) const) &ROL::Cauchy<double>::evaluateCDF, "C++: ROL::Cauchy<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Cauchy<double>::*)(const double) const) &ROL::Cauchy<double>::integrateCDF, "C++: ROL::Cauchy<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Cauchy<double>::*)(const double) const) &ROL::Cauchy<double>::invertCDF, "C++: ROL::Cauchy<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Cauchy<double>::*)(const unsigned long) const) &ROL::Cauchy<double>::moment, "C++: ROL::Cauchy<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Cauchy<double>::*)() const) &ROL::Cauchy<double>::lowerBound, "C++: ROL::Cauchy<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Cauchy<double>::*)() const) &ROL::Cauchy<double>::upperBound, "C++: ROL::Cauchy<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Cauchy<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Cauchy<double>::*)(std::ostream &) const) &ROL::Cauchy<double>::test, "C++: ROL::Cauchy<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Cauchy<double> & (ROL::Cauchy<double>::*)(const class ROL::Cauchy<double> &)) &ROL::Cauchy<double>::operator=, "C++: ROL::Cauchy<double>::operator=(const class ROL::Cauchy<double> &) --> class ROL::Cauchy<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("evaluatePDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluatePDF, "C++: ROL::Distribution<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluateCDF, "C++: ROL::Distribution<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::integrateCDF, "C++: ROL::Distribution<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::invertCDF, "C++: ROL::Distribution<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Distribution<double>::*)(const unsigned long) const) &ROL::Distribution<double>::moment, "C++: ROL::Distribution<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::lowerBound, "C++: ROL::Distribution<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::upperBound, "C++: ROL::Distribution<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Distribution<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Distribution<double>::*)(std::ostream &) const) &ROL::Distribution<double>::test, "C++: ROL::Distribution<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Distribution<double> & (ROL::Distribution<double>::*)(const class ROL::Distribution<double> &)) &ROL::Distribution<double>::operator=, "C++: ROL::Distribution<double>::operator=(const class ROL::Distribution<double> &) --> class ROL::Distribution<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::Smale file:ROL_Smale.hpp line:19
		pybind11::class_<ROL::Smale<double>, Teuchos::RCP<ROL::Smale<double>>, PyCallBack_ROL_Smale_double_t, ROL::Distribution<double>> cl(M("ROL"), "Smale_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::Smale<double>(); }, [](){ return new PyCallBack_ROL_Smale_double_t(); } ), "doc");
		cl.def( pybind11::init( [](const double & a0){ return new ROL::Smale<double>(a0); }, [](const double & a0){ return new PyCallBack_ROL_Smale_double_t(a0); } ), "doc");
		cl.def( pybind11::init<const double, const double>(), pybind11::arg("a"), pybind11::arg("b") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_Smale_double_t const &o){ return new PyCallBack_ROL_Smale_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::Smale<double> const &o){ return new ROL::Smale<double>(o); } ) );
		cl.def("evaluatePDF", (double (ROL::Smale<double>::*)(const double) const) &ROL::Smale<double>::evaluatePDF, "C++: ROL::Smale<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Smale<double>::*)(const double) const) &ROL::Smale<double>::evaluateCDF, "C++: ROL::Smale<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Smale<double>::*)(const double) const) &ROL::Smale<double>::integrateCDF, "C++: ROL::Smale<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Smale<double>::*)(const double) const) &ROL::Smale<double>::invertCDF, "C++: ROL::Smale<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Smale<double>::*)(const unsigned long) const) &ROL::Smale<double>::moment, "C++: ROL::Smale<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Smale<double>::*)() const) &ROL::Smale<double>::lowerBound, "C++: ROL::Smale<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Smale<double>::*)() const) &ROL::Smale<double>::upperBound, "C++: ROL::Smale<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Smale<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Smale<double>::*)(std::ostream &) const) &ROL::Smale<double>::test, "C++: ROL::Smale<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Smale<double> & (ROL::Smale<double>::*)(const class ROL::Smale<double> &)) &ROL::Smale<double>::operator=, "C++: ROL::Smale<double>::operator=(const class ROL::Smale<double> &) --> class ROL::Smale<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("evaluatePDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluatePDF, "C++: ROL::Distribution<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluateCDF, "C++: ROL::Distribution<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::integrateCDF, "C++: ROL::Distribution<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::invertCDF, "C++: ROL::Distribution<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Distribution<double>::*)(const unsigned long) const) &ROL::Distribution<double>::moment, "C++: ROL::Distribution<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::lowerBound, "C++: ROL::Distribution<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::upperBound, "C++: ROL::Distribution<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Distribution<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Distribution<double>::*)(std::ostream &) const) &ROL::Distribution<double>::test, "C++: ROL::Distribution<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Distribution<double> & (ROL::Distribution<double>::*)(const class ROL::Distribution<double> &)) &ROL::Distribution<double>::operator=, "C++: ROL::Distribution<double>::operator=(const class ROL::Distribution<double> &) --> class ROL::Distribution<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::Arcsine file:ROL_Arcsine.hpp line:19
		pybind11::class_<ROL::Arcsine<double>, Teuchos::RCP<ROL::Arcsine<double>>, PyCallBack_ROL_Arcsine_double_t, ROL::Distribution<double>> cl(M("ROL"), "Arcsine_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::Arcsine<double>(); }, [](){ return new PyCallBack_ROL_Arcsine_double_t(); } ), "doc");
		cl.def( pybind11::init( [](const double & a0){ return new ROL::Arcsine<double>(a0); }, [](const double & a0){ return new PyCallBack_ROL_Arcsine_double_t(a0); } ), "doc");
		cl.def( pybind11::init<const double, const double>(), pybind11::arg("a"), pybind11::arg("b") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_Arcsine_double_t const &o){ return new PyCallBack_ROL_Arcsine_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::Arcsine<double> const &o){ return new ROL::Arcsine<double>(o); } ) );
		cl.def("evaluatePDF", (double (ROL::Arcsine<double>::*)(const double) const) &ROL::Arcsine<double>::evaluatePDF, "C++: ROL::Arcsine<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Arcsine<double>::*)(const double) const) &ROL::Arcsine<double>::evaluateCDF, "C++: ROL::Arcsine<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Arcsine<double>::*)(const double) const) &ROL::Arcsine<double>::integrateCDF, "C++: ROL::Arcsine<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Arcsine<double>::*)(const double) const) &ROL::Arcsine<double>::invertCDF, "C++: ROL::Arcsine<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Arcsine<double>::*)(const unsigned long) const) &ROL::Arcsine<double>::moment, "C++: ROL::Arcsine<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Arcsine<double>::*)() const) &ROL::Arcsine<double>::lowerBound, "C++: ROL::Arcsine<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Arcsine<double>::*)() const) &ROL::Arcsine<double>::upperBound, "C++: ROL::Arcsine<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Arcsine<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Arcsine<double>::*)(std::ostream &) const) &ROL::Arcsine<double>::test, "C++: ROL::Arcsine<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Arcsine<double> & (ROL::Arcsine<double>::*)(const class ROL::Arcsine<double> &)) &ROL::Arcsine<double>::operator=, "C++: ROL::Arcsine<double>::operator=(const class ROL::Arcsine<double> &) --> class ROL::Arcsine<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("evaluatePDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluatePDF, "C++: ROL::Distribution<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluateCDF, "C++: ROL::Distribution<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::integrateCDF, "C++: ROL::Distribution<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::invertCDF, "C++: ROL::Distribution<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Distribution<double>::*)(const unsigned long) const) &ROL::Distribution<double>::moment, "C++: ROL::Distribution<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::lowerBound, "C++: ROL::Distribution<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::upperBound, "C++: ROL::Distribution<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Distribution<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Distribution<double>::*)(std::ostream &) const) &ROL::Distribution<double>::test, "C++: ROL::Distribution<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Distribution<double> & (ROL::Distribution<double>::*)(const class ROL::Distribution<double> &)) &ROL::Distribution<double>::operator=, "C++: ROL::Distribution<double>::operator=(const class ROL::Distribution<double> &) --> class ROL::Distribution<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::Kumaraswamy file:ROL_Kumaraswamy.hpp line:21
		pybind11::class_<ROL::Kumaraswamy<double>, Teuchos::RCP<ROL::Kumaraswamy<double>>, PyCallBack_ROL_Kumaraswamy_double_t, ROL::Distribution<double>> cl(M("ROL"), "Kumaraswamy_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::Kumaraswamy<double>(); }, [](){ return new PyCallBack_ROL_Kumaraswamy_double_t(); } ), "doc");
		cl.def( pybind11::init( [](const double & a0){ return new ROL::Kumaraswamy<double>(a0); }, [](const double & a0){ return new PyCallBack_ROL_Kumaraswamy_double_t(a0); } ), "doc");
		cl.def( pybind11::init( [](const double & a0, const double & a1){ return new ROL::Kumaraswamy<double>(a0, a1); }, [](const double & a0, const double & a1){ return new PyCallBack_ROL_Kumaraswamy_double_t(a0, a1); } ), "doc");
		cl.def( pybind11::init( [](const double & a0, const double & a1, const double & a2){ return new ROL::Kumaraswamy<double>(a0, a1, a2); }, [](const double & a0, const double & a1, const double & a2){ return new PyCallBack_ROL_Kumaraswamy_double_t(a0, a1, a2); } ), "doc");
		cl.def( pybind11::init<const double, const double, const double, const double>(), pybind11::arg("a"), pybind11::arg("b"), pybind11::arg("exp1"), pybind11::arg("exp2") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_Kumaraswamy_double_t const &o){ return new PyCallBack_ROL_Kumaraswamy_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::Kumaraswamy<double> const &o){ return new ROL::Kumaraswamy<double>(o); } ) );
		cl.def("evaluatePDF", (double (ROL::Kumaraswamy<double>::*)(const double) const) &ROL::Kumaraswamy<double>::evaluatePDF, "C++: ROL::Kumaraswamy<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Kumaraswamy<double>::*)(const double) const) &ROL::Kumaraswamy<double>::evaluateCDF, "C++: ROL::Kumaraswamy<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Kumaraswamy<double>::*)(const double) const) &ROL::Kumaraswamy<double>::integrateCDF, "C++: ROL::Kumaraswamy<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Kumaraswamy<double>::*)(const double) const) &ROL::Kumaraswamy<double>::invertCDF, "C++: ROL::Kumaraswamy<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Kumaraswamy<double>::*)(const unsigned long) const) &ROL::Kumaraswamy<double>::moment, "C++: ROL::Kumaraswamy<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Kumaraswamy<double>::*)() const) &ROL::Kumaraswamy<double>::lowerBound, "C++: ROL::Kumaraswamy<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Kumaraswamy<double>::*)() const) &ROL::Kumaraswamy<double>::upperBound, "C++: ROL::Kumaraswamy<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Kumaraswamy<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Kumaraswamy<double>::*)(std::ostream &) const) &ROL::Kumaraswamy<double>::test, "C++: ROL::Kumaraswamy<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Kumaraswamy<double> & (ROL::Kumaraswamy<double>::*)(const class ROL::Kumaraswamy<double> &)) &ROL::Kumaraswamy<double>::operator=, "C++: ROL::Kumaraswamy<double>::operator=(const class ROL::Kumaraswamy<double> &) --> class ROL::Kumaraswamy<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("evaluatePDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluatePDF, "C++: ROL::Distribution<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluateCDF, "C++: ROL::Distribution<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::integrateCDF, "C++: ROL::Distribution<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::invertCDF, "C++: ROL::Distribution<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Distribution<double>::*)(const unsigned long) const) &ROL::Distribution<double>::moment, "C++: ROL::Distribution<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::lowerBound, "C++: ROL::Distribution<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::upperBound, "C++: ROL::Distribution<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Distribution<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Distribution<double>::*)(std::ostream &) const) &ROL::Distribution<double>::test, "C++: ROL::Distribution<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Distribution<double> & (ROL::Distribution<double>::*)(const class ROL::Distribution<double> &)) &ROL::Distribution<double>::operator=, "C++: ROL::Distribution<double>::operator=(const class ROL::Distribution<double> &) --> class ROL::Distribution<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::Exponential file:ROL_Exponential.hpp line:19
		pybind11::class_<ROL::Exponential<double>, Teuchos::RCP<ROL::Exponential<double>>, PyCallBack_ROL_Exponential_double_t, ROL::Distribution<double>> cl(M("ROL"), "Exponential_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::Exponential<double>(); }, [](){ return new PyCallBack_ROL_Exponential_double_t(); } ), "doc");
		cl.def( pybind11::init( [](const double & a0){ return new ROL::Exponential<double>(a0); }, [](const double & a0){ return new PyCallBack_ROL_Exponential_double_t(a0); } ), "doc");
		cl.def( pybind11::init<const double, const double>(), pybind11::arg("loc"), pybind11::arg("scale") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_Exponential_double_t const &o){ return new PyCallBack_ROL_Exponential_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::Exponential<double> const &o){ return new ROL::Exponential<double>(o); } ) );
		cl.def("evaluatePDF", (double (ROL::Exponential<double>::*)(const double) const) &ROL::Exponential<double>::evaluatePDF, "C++: ROL::Exponential<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Exponential<double>::*)(const double) const) &ROL::Exponential<double>::evaluateCDF, "C++: ROL::Exponential<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Exponential<double>::*)(const double) const) &ROL::Exponential<double>::integrateCDF, "C++: ROL::Exponential<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Exponential<double>::*)(const double) const) &ROL::Exponential<double>::invertCDF, "C++: ROL::Exponential<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Exponential<double>::*)(const unsigned long) const) &ROL::Exponential<double>::moment, "C++: ROL::Exponential<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Exponential<double>::*)() const) &ROL::Exponential<double>::lowerBound, "C++: ROL::Exponential<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Exponential<double>::*)() const) &ROL::Exponential<double>::upperBound, "C++: ROL::Exponential<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Exponential<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Exponential<double>::*)(std::ostream &) const) &ROL::Exponential<double>::test, "C++: ROL::Exponential<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Exponential<double> & (ROL::Exponential<double>::*)(const class ROL::Exponential<double> &)) &ROL::Exponential<double>::operator=, "C++: ROL::Exponential<double>::operator=(const class ROL::Exponential<double> &) --> class ROL::Exponential<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("evaluatePDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluatePDF, "C++: ROL::Distribution<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluateCDF, "C++: ROL::Distribution<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::integrateCDF, "C++: ROL::Distribution<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::invertCDF, "C++: ROL::Distribution<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Distribution<double>::*)(const unsigned long) const) &ROL::Distribution<double>::moment, "C++: ROL::Distribution<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::lowerBound, "C++: ROL::Distribution<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::upperBound, "C++: ROL::Distribution<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Distribution<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Distribution<double>::*)(std::ostream &) const) &ROL::Distribution<double>::test, "C++: ROL::Distribution<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Distribution<double> & (ROL::Distribution<double>::*)(const class ROL::Distribution<double> &)) &ROL::Distribution<double>::operator=, "C++: ROL::Distribution<double>::operator=(const class ROL::Distribution<double> &) --> class ROL::Distribution<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::TruncatedExponential file:ROL_TruncatedExponential.hpp line:19
		pybind11::class_<ROL::TruncatedExponential<double>, Teuchos::RCP<ROL::TruncatedExponential<double>>, PyCallBack_ROL_TruncatedExponential_double_t, ROL::Distribution<double>> cl(M("ROL"), "TruncatedExponential_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::TruncatedExponential<double>(); }, [](){ return new PyCallBack_ROL_TruncatedExponential_double_t(); } ), "doc");
		cl.def( pybind11::init( [](const double & a0){ return new ROL::TruncatedExponential<double>(a0); }, [](const double & a0){ return new PyCallBack_ROL_TruncatedExponential_double_t(a0); } ), "doc");
		cl.def( pybind11::init( [](const double & a0, const double & a1){ return new ROL::TruncatedExponential<double>(a0, a1); }, [](const double & a0, const double & a1){ return new PyCallBack_ROL_TruncatedExponential_double_t(a0, a1); } ), "doc");
		cl.def( pybind11::init<const double, const double, const double>(), pybind11::arg("a"), pybind11::arg("b"), pybind11::arg("scale") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_TruncatedExponential_double_t const &o){ return new PyCallBack_ROL_TruncatedExponential_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::TruncatedExponential<double> const &o){ return new ROL::TruncatedExponential<double>(o); } ) );
		cl.def("evaluatePDF", (double (ROL::TruncatedExponential<double>::*)(const double) const) &ROL::TruncatedExponential<double>::evaluatePDF, "C++: ROL::TruncatedExponential<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::TruncatedExponential<double>::*)(const double) const) &ROL::TruncatedExponential<double>::evaluateCDF, "C++: ROL::TruncatedExponential<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::TruncatedExponential<double>::*)(const double) const) &ROL::TruncatedExponential<double>::integrateCDF, "C++: ROL::TruncatedExponential<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::TruncatedExponential<double>::*)(const double) const) &ROL::TruncatedExponential<double>::invertCDF, "C++: ROL::TruncatedExponential<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::TruncatedExponential<double>::*)(const unsigned long) const) &ROL::TruncatedExponential<double>::moment, "C++: ROL::TruncatedExponential<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::TruncatedExponential<double>::*)() const) &ROL::TruncatedExponential<double>::lowerBound, "C++: ROL::TruncatedExponential<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::TruncatedExponential<double>::*)() const) &ROL::TruncatedExponential<double>::upperBound, "C++: ROL::TruncatedExponential<double>::upperBound() const --> double");
		cl.def("test", [](ROL::TruncatedExponential<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::TruncatedExponential<double>::*)(std::ostream &) const) &ROL::TruncatedExponential<double>::test, "C++: ROL::TruncatedExponential<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::TruncatedExponential<double> & (ROL::TruncatedExponential<double>::*)(const class ROL::TruncatedExponential<double> &)) &ROL::TruncatedExponential<double>::operator=, "C++: ROL::TruncatedExponential<double>::operator=(const class ROL::TruncatedExponential<double> &) --> class ROL::TruncatedExponential<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("evaluatePDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluatePDF, "C++: ROL::Distribution<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluateCDF, "C++: ROL::Distribution<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::integrateCDF, "C++: ROL::Distribution<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::invertCDF, "C++: ROL::Distribution<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Distribution<double>::*)(const unsigned long) const) &ROL::Distribution<double>::moment, "C++: ROL::Distribution<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::lowerBound, "C++: ROL::Distribution<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::upperBound, "C++: ROL::Distribution<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Distribution<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Distribution<double>::*)(std::ostream &) const) &ROL::Distribution<double>::test, "C++: ROL::Distribution<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Distribution<double> & (ROL::Distribution<double>::*)(const class ROL::Distribution<double> &)) &ROL::Distribution<double>::operator=, "C++: ROL::Distribution<double>::operator=(const class ROL::Distribution<double> &) --> class ROL::Distribution<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::Gamma file:ROL_Gamma.hpp line:21
		pybind11::class_<ROL::Gamma<double>, Teuchos::RCP<ROL::Gamma<double>>, PyCallBack_ROL_Gamma_double_t, ROL::Distribution<double>> cl(M("ROL"), "Gamma_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::Gamma<double>(); }, [](){ return new PyCallBack_ROL_Gamma_double_t(); } ), "doc");
		cl.def( pybind11::init( [](const double & a0){ return new ROL::Gamma<double>(a0); }, [](const double & a0){ return new PyCallBack_ROL_Gamma_double_t(a0); } ), "doc");
		cl.def( pybind11::init<const double, const double>(), pybind11::arg("shape"), pybind11::arg("scale") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_Gamma_double_t const &o){ return new PyCallBack_ROL_Gamma_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::Gamma<double> const &o){ return new ROL::Gamma<double>(o); } ) );
		cl.def("evaluatePDF", (double (ROL::Gamma<double>::*)(const double) const) &ROL::Gamma<double>::evaluatePDF, "C++: ROL::Gamma<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Gamma<double>::*)(const double) const) &ROL::Gamma<double>::evaluateCDF, "C++: ROL::Gamma<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Gamma<double>::*)(const double) const) &ROL::Gamma<double>::integrateCDF, "C++: ROL::Gamma<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Gamma<double>::*)(const double) const) &ROL::Gamma<double>::invertCDF, "C++: ROL::Gamma<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Gamma<double>::*)(const unsigned long) const) &ROL::Gamma<double>::moment, "C++: ROL::Gamma<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Gamma<double>::*)() const) &ROL::Gamma<double>::lowerBound, "C++: ROL::Gamma<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Gamma<double>::*)() const) &ROL::Gamma<double>::upperBound, "C++: ROL::Gamma<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Gamma<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Gamma<double>::*)(std::ostream &) const) &ROL::Gamma<double>::test, "C++: ROL::Gamma<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Gamma<double> & (ROL::Gamma<double>::*)(const class ROL::Gamma<double> &)) &ROL::Gamma<double>::operator=, "C++: ROL::Gamma<double>::operator=(const class ROL::Gamma<double> &) --> class ROL::Gamma<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("evaluatePDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluatePDF, "C++: ROL::Distribution<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluateCDF, "C++: ROL::Distribution<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::integrateCDF, "C++: ROL::Distribution<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::invertCDF, "C++: ROL::Distribution<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Distribution<double>::*)(const unsigned long) const) &ROL::Distribution<double>::moment, "C++: ROL::Distribution<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::lowerBound, "C++: ROL::Distribution<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::upperBound, "C++: ROL::Distribution<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Distribution<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Distribution<double>::*)(std::ostream &) const) &ROL::Distribution<double>::test, "C++: ROL::Distribution<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Distribution<double> & (ROL::Distribution<double>::*)(const class ROL::Distribution<double> &)) &ROL::Distribution<double>::operator=, "C++: ROL::Distribution<double>::operator=(const class ROL::Distribution<double> &) --> class ROL::Distribution<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::Beta file:ROL_Beta.hpp line:21
		pybind11::class_<ROL::Beta<double>, Teuchos::RCP<ROL::Beta<double>>, PyCallBack_ROL_Beta_double_t, ROL::Distribution<double>> cl(M("ROL"), "Beta_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::Beta<double>(); }, [](){ return new PyCallBack_ROL_Beta_double_t(); } ), "doc");
		cl.def( pybind11::init( [](const double & a0){ return new ROL::Beta<double>(a0); }, [](const double & a0){ return new PyCallBack_ROL_Beta_double_t(a0); } ), "doc");
		cl.def( pybind11::init<const double, const double>(), pybind11::arg("shape1"), pybind11::arg("shape2") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_Beta_double_t const &o){ return new PyCallBack_ROL_Beta_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::Beta<double> const &o){ return new ROL::Beta<double>(o); } ) );
		cl.def("evaluatePDF", (double (ROL::Beta<double>::*)(const double) const) &ROL::Beta<double>::evaluatePDF, "C++: ROL::Beta<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Beta<double>::*)(const double) const) &ROL::Beta<double>::evaluateCDF, "C++: ROL::Beta<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Beta<double>::*)(const double) const) &ROL::Beta<double>::integrateCDF, "C++: ROL::Beta<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Beta<double>::*)(const double) const) &ROL::Beta<double>::invertCDF, "C++: ROL::Beta<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Beta<double>::*)(const unsigned long) const) &ROL::Beta<double>::moment, "C++: ROL::Beta<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Beta<double>::*)() const) &ROL::Beta<double>::lowerBound, "C++: ROL::Beta<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Beta<double>::*)() const) &ROL::Beta<double>::upperBound, "C++: ROL::Beta<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Beta<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Beta<double>::*)(std::ostream &) const) &ROL::Beta<double>::test, "C++: ROL::Beta<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Beta<double> & (ROL::Beta<double>::*)(const class ROL::Beta<double> &)) &ROL::Beta<double>::operator=, "C++: ROL::Beta<double>::operator=(const class ROL::Beta<double> &) --> class ROL::Beta<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("evaluatePDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluatePDF, "C++: ROL::Distribution<double>::evaluatePDF(const double) const --> double", pybind11::arg("input"));
		cl.def("evaluateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::evaluateCDF, "C++: ROL::Distribution<double>::evaluateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("integrateCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::integrateCDF, "C++: ROL::Distribution<double>::integrateCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("invertCDF", (double (ROL::Distribution<double>::*)(const double) const) &ROL::Distribution<double>::invertCDF, "C++: ROL::Distribution<double>::invertCDF(const double) const --> double", pybind11::arg("input"));
		cl.def("moment", (double (ROL::Distribution<double>::*)(const unsigned long) const) &ROL::Distribution<double>::moment, "C++: ROL::Distribution<double>::moment(const unsigned long) const --> double", pybind11::arg("m"));
		cl.def("lowerBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::lowerBound, "C++: ROL::Distribution<double>::lowerBound() const --> double");
		cl.def("upperBound", (double (ROL::Distribution<double>::*)() const) &ROL::Distribution<double>::upperBound, "C++: ROL::Distribution<double>::upperBound() const --> double");
		cl.def("test", [](ROL::Distribution<double> const &o) -> void { return o.test(); }, "");
		cl.def("test", (void (ROL::Distribution<double>::*)(std::ostream &) const) &ROL::Distribution<double>::test, "C++: ROL::Distribution<double>::test(std::ostream &) const --> void", pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Distribution<double> & (ROL::Distribution<double>::*)(const class ROL::Distribution<double> &)) &ROL::Distribution<double>::operator=, "C++: ROL::Distribution<double>::operator=(const class ROL::Distribution<double> &) --> class ROL::Distribution<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	// ROL::EDistribution file:ROL_DistributionFactory.hpp line:35
	pybind11::enum_<ROL::EDistribution>(M("ROL"), "EDistribution", pybind11::arithmetic(), "", pybind11::module_local())
		.value("DISTRIBUTION_ARCSINE", ROL::DISTRIBUTION_ARCSINE)
		.value("DISTRIBUTION_BETA", ROL::DISTRIBUTION_BETA)
		.value("DISTRIBUTION_CAUCHY", ROL::DISTRIBUTION_CAUCHY)
		.value("DISTRIBUTION_DIRAC", ROL::DISTRIBUTION_DIRAC)
		.value("DISTRIBUTION_EXPONENTIAL", ROL::DISTRIBUTION_EXPONENTIAL)
		.value("DISTRIBUTION_GAMMA", ROL::DISTRIBUTION_GAMMA)
		.value("DISTRIBUTION_GAUSSIAN", ROL::DISTRIBUTION_GAUSSIAN)
		.value("DISTRIBUTION_KUMARASWAMY", ROL::DISTRIBUTION_KUMARASWAMY)
		.value("DISTRIBUTION_LAPLACE", ROL::DISTRIBUTION_LAPLACE)
		.value("DISTRIBUTION_LOGISTIC", ROL::DISTRIBUTION_LOGISTIC)
		.value("DISTRIBUTION_PARABOLIC", ROL::DISTRIBUTION_PARABOLIC)
		.value("DISTRIBUTION_RAISEDCOSINE", ROL::DISTRIBUTION_RAISEDCOSINE)
		.value("DISTRIBUTION_SMALE", ROL::DISTRIBUTION_SMALE)
		.value("DISTRIBUTION_TRIANGLE", ROL::DISTRIBUTION_TRIANGLE)
		.value("DISTRIBUTION_TRUNCATEDEXPONENTIAL", ROL::DISTRIBUTION_TRUNCATEDEXPONENTIAL)
		.value("DISTRIBUTION_TRUNCATEDGAUSSIAN", ROL::DISTRIBUTION_TRUNCATEDGAUSSIAN)
		.value("DISTRIBUTION_UNIFORM", ROL::DISTRIBUTION_UNIFORM)
		.value("DISTRIBUTION_LAST", ROL::DISTRIBUTION_LAST)
		.export_values();

;

	// ROL::EDistributionToString(enum ROL::EDistribution) file:ROL_DistributionFactory.hpp line:56
	M("ROL").def("EDistributionToString", (std::string (*)(enum ROL::EDistribution)) &ROL::EDistributionToString, "C++: ROL::EDistributionToString(enum ROL::EDistribution) --> std::string", pybind11::arg("ed"));

	// ROL::isValidDistribution(enum ROL::EDistribution) file:ROL_DistributionFactory.hpp line:82
	M("ROL").def("isValidDistribution", (int (*)(enum ROL::EDistribution)) &ROL::isValidDistribution, "C++: ROL::isValidDistribution(enum ROL::EDistribution) --> int", pybind11::arg("ed"));

	// ROL::StringToEDistribution(std::string) file:ROL_DistributionFactory.hpp line:122
	M("ROL").def("StringToEDistribution", (enum ROL::EDistribution (*)(std::string)) &ROL::StringToEDistribution, "C++: ROL::StringToEDistribution(std::string) --> enum ROL::EDistribution", pybind11::arg("s"));

	// ROL::DistributionFactory(class Teuchos::ParameterList &) file:ROL_DistributionFactory.hpp line:133
	M("ROL").def("DistributionFactory", (class Teuchos::RCP<class ROL::Distribution<double> > (*)(class Teuchos::ParameterList &)) &ROL::DistributionFactory<double>, "C++: ROL::DistributionFactory(class Teuchos::ParameterList &) --> class Teuchos::RCP<class ROL::Distribution<double> >", pybind11::arg("parlist"));

	{ // ROL::PlusFunction file:ROL_PlusFunction.hpp line:21
		pybind11::class_<ROL::PlusFunction<double>, Teuchos::RCP<ROL::PlusFunction<double>>, PyCallBack_ROL_PlusFunction_double_t, ROL::PositiveFunction<double>> cl(M("ROL"), "PlusFunction_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](class Teuchos::RCP<class ROL::Distribution<double> > & a0){ return new ROL::PlusFunction<double>(a0); }, [](class Teuchos::RCP<class ROL::Distribution<double> > & a0){ return new PyCallBack_ROL_PlusFunction_double_t(a0); } ), "doc");
		cl.def( pybind11::init<class Teuchos::RCP<class ROL::Distribution<double> > &, double>(), pybind11::arg("dist"), pybind11::arg("param") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_PlusFunction_double_t const &o){ return new PyCallBack_ROL_PlusFunction_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::PlusFunction<double> const &o){ return new ROL::PlusFunction<double>(o); } ) );
		cl.def("evaluate", (double (ROL::PlusFunction<double>::*)(double, int)) &ROL::PlusFunction<double>::evaluate, "C++: ROL::PlusFunction<double>::evaluate(double, int) --> double", pybind11::arg("input"), pybind11::arg("deriv"));
		cl.def("test", (void (ROL::PlusFunction<double>::*)(double)) &ROL::PlusFunction<double>::test, "C++: ROL::PlusFunction<double>::test(double) --> void", pybind11::arg("x"));
		cl.def("assign", (class ROL::PlusFunction<double> & (ROL::PlusFunction<double>::*)(const class ROL::PlusFunction<double> &)) &ROL::PlusFunction<double>::operator=, "C++: ROL::PlusFunction<double>::operator=(const class ROL::PlusFunction<double> &) --> class ROL::PlusFunction<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("evaluate", (double (ROL::PositiveFunction<double>::*)(double, int)) &ROL::PositiveFunction<double>::evaluate, "C++: ROL::PositiveFunction<double>::evaluate(double, int) --> double", pybind11::arg("input"), pybind11::arg("deriv"));
		cl.def("assign", (class ROL::PositiveFunction<double> & (ROL::PositiveFunction<double>::*)(const class ROL::PositiveFunction<double> &)) &ROL::PositiveFunction<double>::operator=, "C++: ROL::PositiveFunction<double>::operator=(const class ROL::PositiveFunction<double> &) --> class ROL::PositiveFunction<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::CVaR file:ROL_CVaR.hpp line:44
		pybind11::class_<ROL::CVaR<double>, Teuchos::RCP<ROL::CVaR<double>>, PyCallBack_ROL_CVaR_double_t, ROL::RandVarFunctional<double>> cl(M("ROL"), "CVaR_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<const double, const double, const class Teuchos::RCP<class ROL::PlusFunction<double> > &>(), pybind11::arg("prob"), pybind11::arg("coeff"), pybind11::arg("pf") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_CVaR_double_t const &o){ return new PyCallBack_ROL_CVaR_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::CVaR<double> const &o){ return new ROL::CVaR<double>(o); } ) );
		cl.def("updateValue", (void (ROL::CVaR<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::CVaR<double>::updateValue, "C++: ROL::CVaR<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateGradient", (void (ROL::CVaR<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::CVaR<double>::updateGradient, "C++: ROL::CVaR<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateHessVec", (void (ROL::CVaR<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::CVaR<double>::updateHessVec, "C++: ROL::CVaR<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::CVaR<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::CVaR<double>::getValue, "C++: ROL::CVaR<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getGradient", (void (ROL::CVaR<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::CVaR<double>::getGradient, "C++: ROL::CVaR<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getHessVec", (void (ROL::CVaR<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::CVaR<double>::getHessVec, "C++: ROL::CVaR<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::CVaR<double> & (ROL::CVaR<double>::*)(const class ROL::CVaR<double> &)) &ROL::CVaR<double>::operator=, "C++: ROL::CVaR<double>::operator=(const class ROL::CVaR<double> &) --> class ROL::CVaR<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("useStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useStorage, "C++: ROL::RandVarFunctional<double>::useStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("useHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useHessVecStorage, "C++: ROL::RandVarFunctional<double>::useHessVecStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("setStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setStorage, "C++: ROL::RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setHessVecStorage, "C++: ROL::RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("resetStorage", [](ROL::RandVarFunctional<double> &o) -> void { return o.resetStorage(); }, "");
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(bool) --> void", pybind11::arg("flag"));
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(enum ROL::UpdateType)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(enum ROL::UpdateType) --> void", pybind11::arg("type"));
		cl.def("initialize", (void (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::RandVarFunctional<double>::initialize, "C++: ROL::RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("setSample", (void (ROL::RandVarFunctional<double>::*)(const class std::vector<double> &, const double)) &ROL::RandVarFunctional<double>::setSample, "C++: ROL::RandVarFunctional<double>::setSample(const class std::vector<double> &, const double) --> void", pybind11::arg("point"), pybind11::arg("weight"));
		cl.def("computeStatistic", (double (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<const class std::vector<double> > &) const) &ROL::RandVarFunctional<double>::computeStatistic, "C++: ROL::RandVarFunctional<double>::computeStatistic(const class Teuchos::RCP<const class std::vector<double> > &) const --> double", pybind11::arg("xstat"));
		cl.def("updateValue", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateValue, "C++: ROL::RandVarFunctional<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateGradient, "C++: ROL::RandVarFunctional<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateHessVec, "C++: ROL::RandVarFunctional<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getValue, "C++: ROL::RandVarFunctional<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getGradient, "C++: ROL::RandVarFunctional<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getHessVec, "C++: ROL::RandVarFunctional<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::RandVarFunctional<double> & (ROL::RandVarFunctional<double>::*)(const class ROL::RandVarFunctional<double> &)) &ROL::RandVarFunctional<double>::operator=, "C++: ROL::RandVarFunctional<double>::operator=(const class ROL::RandVarFunctional<double> &) --> class ROL::RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::MixedCVaR file:ROL_MixedCVaR.hpp line:54
		pybind11::class_<ROL::MixedCVaR<double>, Teuchos::RCP<ROL::MixedCVaR<double>>, PyCallBack_ROL_MixedCVaR_double_t, ROL::RandVarFunctional<double>> cl(M("ROL"), "MixedCVaR_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init<const class std::vector<double> &, const class std::vector<double> &, const class Teuchos::RCP<class ROL::PlusFunction<double> > &>(), pybind11::arg("prob"), pybind11::arg("coeff"), pybind11::arg("pf") );

		cl.def( pybind11::init( [](PyCallBack_ROL_MixedCVaR_double_t const &o){ return new PyCallBack_ROL_MixedCVaR_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::MixedCVaR<double> const &o){ return new ROL::MixedCVaR<double>(o); } ) );
		cl.def("initialize", (void (ROL::MixedCVaR<double>::*)(const class ROL::Vector<double> &)) &ROL::MixedCVaR<double>::initialize, "C++: ROL::MixedCVaR<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("computeStatistic", (double (ROL::MixedCVaR<double>::*)(const class Teuchos::RCP<const class std::vector<double> > &) const) &ROL::MixedCVaR<double>::computeStatistic, "C++: ROL::MixedCVaR<double>::computeStatistic(const class Teuchos::RCP<const class std::vector<double> > &) const --> double", pybind11::arg("xstat"));
		cl.def("updateValue", (void (ROL::MixedCVaR<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::MixedCVaR<double>::updateValue, "C++: ROL::MixedCVaR<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::MixedCVaR<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::MixedCVaR<double>::getValue, "C++: ROL::MixedCVaR<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("updateGradient", (void (ROL::MixedCVaR<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::MixedCVaR<double>::updateGradient, "C++: ROL::MixedCVaR<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getGradient", (void (ROL::MixedCVaR<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::MixedCVaR<double>::getGradient, "C++: ROL::MixedCVaR<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("updateHessVec", (void (ROL::MixedCVaR<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::MixedCVaR<double>::updateHessVec, "C++: ROL::MixedCVaR<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getHessVec", (void (ROL::MixedCVaR<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::MixedCVaR<double>::getHessVec, "C++: ROL::MixedCVaR<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::MixedCVaR<double> & (ROL::MixedCVaR<double>::*)(const class ROL::MixedCVaR<double> &)) &ROL::MixedCVaR<double>::operator=, "C++: ROL::MixedCVaR<double>::operator=(const class ROL::MixedCVaR<double> &) --> class ROL::MixedCVaR<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("useStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useStorage, "C++: ROL::RandVarFunctional<double>::useStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("useHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useHessVecStorage, "C++: ROL::RandVarFunctional<double>::useHessVecStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("setStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setStorage, "C++: ROL::RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setHessVecStorage, "C++: ROL::RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("resetStorage", [](ROL::RandVarFunctional<double> &o) -> void { return o.resetStorage(); }, "");
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(bool) --> void", pybind11::arg("flag"));
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(enum ROL::UpdateType)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(enum ROL::UpdateType) --> void", pybind11::arg("type"));
		cl.def("initialize", (void (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::RandVarFunctional<double>::initialize, "C++: ROL::RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("setSample", (void (ROL::RandVarFunctional<double>::*)(const class std::vector<double> &, const double)) &ROL::RandVarFunctional<double>::setSample, "C++: ROL::RandVarFunctional<double>::setSample(const class std::vector<double> &, const double) --> void", pybind11::arg("point"), pybind11::arg("weight"));
		cl.def("computeStatistic", (double (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<const class std::vector<double> > &) const) &ROL::RandVarFunctional<double>::computeStatistic, "C++: ROL::RandVarFunctional<double>::computeStatistic(const class Teuchos::RCP<const class std::vector<double> > &) const --> double", pybind11::arg("xstat"));
		cl.def("updateValue", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateValue, "C++: ROL::RandVarFunctional<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateGradient, "C++: ROL::RandVarFunctional<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateHessVec, "C++: ROL::RandVarFunctional<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getValue, "C++: ROL::RandVarFunctional<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getGradient, "C++: ROL::RandVarFunctional<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getHessVec, "C++: ROL::RandVarFunctional<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::RandVarFunctional<double> & (ROL::RandVarFunctional<double>::*)(const class ROL::RandVarFunctional<double> &)) &ROL::RandVarFunctional<double>::operator=, "C++: ROL::RandVarFunctional<double>::operator=(const class ROL::RandVarFunctional<double> &) --> class ROL::RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::SpectralRisk file:ROL_SpectralRisk.hpp line:55
		pybind11::class_<ROL::SpectralRisk<double>, Teuchos::RCP<ROL::SpectralRisk<double>>, PyCallBack_ROL_SpectralRisk_double_t, ROL::RandVarFunctional<double>> cl(M("ROL"), "SpectralRisk_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::SpectralRisk<double>(); }, [](){ return new PyCallBack_ROL_SpectralRisk_double_t(); } ) );
		cl.def( pybind11::init<const class Teuchos::RCP<class ROL::Distribution<double> > &, const int, const class Teuchos::RCP<class ROL::PlusFunction<double> > &>(), pybind11::arg("dist"), pybind11::arg("nQuad"), pybind11::arg("pf") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init<const class std::vector<double> &, const class std::vector<double> &, const class Teuchos::RCP<class ROL::PlusFunction<double> > &>(), pybind11::arg("pts"), pybind11::arg("wts"), pybind11::arg("pf") );

		cl.def( pybind11::init( [](PyCallBack_ROL_SpectralRisk_double_t const &o){ return new PyCallBack_ROL_SpectralRisk_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::SpectralRisk<double> const &o){ return new ROL::SpectralRisk<double>(o); } ) );
		cl.def("setStorage", (void (ROL::SpectralRisk<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::SpectralRisk<double>::setStorage, "C++: ROL::SpectralRisk<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::SpectralRisk<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::SpectralRisk<double>::setHessVecStorage, "C++: ROL::SpectralRisk<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("setSample", (void (ROL::SpectralRisk<double>::*)(const class std::vector<double> &, const double)) &ROL::SpectralRisk<double>::setSample, "C++: ROL::SpectralRisk<double>::setSample(const class std::vector<double> &, const double) --> void", pybind11::arg("point"), pybind11::arg("weight"));
		cl.def("resetStorage", [](ROL::SpectralRisk<double> &o) -> void { return o.resetStorage(); }, "");
		cl.def("resetStorage", (void (ROL::SpectralRisk<double>::*)(bool)) &ROL::SpectralRisk<double>::resetStorage, "C++: ROL::SpectralRisk<double>::resetStorage(bool) --> void", pybind11::arg("flag"));
		cl.def("resetStorage", (void (ROL::SpectralRisk<double>::*)(enum ROL::UpdateType)) &ROL::SpectralRisk<double>::resetStorage, "C++: ROL::SpectralRisk<double>::resetStorage(enum ROL::UpdateType) --> void", pybind11::arg("type"));
		cl.def("initialize", (void (ROL::SpectralRisk<double>::*)(const class ROL::Vector<double> &)) &ROL::SpectralRisk<double>::initialize, "C++: ROL::SpectralRisk<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("computeStatistic", (double (ROL::SpectralRisk<double>::*)(const class Teuchos::RCP<const class std::vector<double> > &) const) &ROL::SpectralRisk<double>::computeStatistic, "C++: ROL::SpectralRisk<double>::computeStatistic(const class Teuchos::RCP<const class std::vector<double> > &) const --> double", pybind11::arg("xstat"));
		cl.def("updateValue", (void (ROL::SpectralRisk<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::SpectralRisk<double>::updateValue, "C++: ROL::SpectralRisk<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateGradient", (void (ROL::SpectralRisk<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::SpectralRisk<double>::updateGradient, "C++: ROL::SpectralRisk<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateHessVec", (void (ROL::SpectralRisk<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::SpectralRisk<double>::updateHessVec, "C++: ROL::SpectralRisk<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::SpectralRisk<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::SpectralRisk<double>::getValue, "C++: ROL::SpectralRisk<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getGradient", (void (ROL::SpectralRisk<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::SpectralRisk<double>::getGradient, "C++: ROL::SpectralRisk<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getHessVec", (void (ROL::SpectralRisk<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::SpectralRisk<double>::getHessVec, "C++: ROL::SpectralRisk<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::SpectralRisk<double> & (ROL::SpectralRisk<double>::*)(const class ROL::SpectralRisk<double> &)) &ROL::SpectralRisk<double>::operator=, "C++: ROL::SpectralRisk<double>::operator=(const class ROL::SpectralRisk<double> &) --> class ROL::SpectralRisk<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("useStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useStorage, "C++: ROL::RandVarFunctional<double>::useStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("useHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useHessVecStorage, "C++: ROL::RandVarFunctional<double>::useHessVecStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("setStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setStorage, "C++: ROL::RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setHessVecStorage, "C++: ROL::RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("resetStorage", [](ROL::RandVarFunctional<double> &o) -> void { return o.resetStorage(); }, "");
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(bool) --> void", pybind11::arg("flag"));
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(enum ROL::UpdateType)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(enum ROL::UpdateType) --> void", pybind11::arg("type"));
		cl.def("initialize", (void (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::RandVarFunctional<double>::initialize, "C++: ROL::RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("setSample", (void (ROL::RandVarFunctional<double>::*)(const class std::vector<double> &, const double)) &ROL::RandVarFunctional<double>::setSample, "C++: ROL::RandVarFunctional<double>::setSample(const class std::vector<double> &, const double) --> void", pybind11::arg("point"), pybind11::arg("weight"));
		cl.def("computeStatistic", (double (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<const class std::vector<double> > &) const) &ROL::RandVarFunctional<double>::computeStatistic, "C++: ROL::RandVarFunctional<double>::computeStatistic(const class Teuchos::RCP<const class std::vector<double> > &) const --> double", pybind11::arg("xstat"));
		cl.def("updateValue", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateValue, "C++: ROL::RandVarFunctional<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateGradient, "C++: ROL::RandVarFunctional<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateHessVec, "C++: ROL::RandVarFunctional<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getValue, "C++: ROL::RandVarFunctional<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getGradient, "C++: ROL::RandVarFunctional<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getHessVec, "C++: ROL::RandVarFunctional<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::RandVarFunctional<double> & (ROL::RandVarFunctional<double>::*)(const class ROL::RandVarFunctional<double> &)) &ROL::RandVarFunctional<double>::operator=, "C++: ROL::RandVarFunctional<double>::operator=(const class ROL::RandVarFunctional<double> &) --> class ROL::RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::Quadrature1D file:ROL_Quadrature1D.hpp line:18
		pybind11::class_<ROL::Quadrature1D<double>, Teuchos::RCP<ROL::Quadrature1D<double>>, PyCallBack_ROL_Quadrature1D_double_t> cl(M("ROL"), "Quadrature1D_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new PyCallBack_ROL_Quadrature1D_double_t(); } ) );
		cl.def(pybind11::init<PyCallBack_ROL_Quadrature1D_double_t const &>());
		cl.def("get", (void (ROL::Quadrature1D<double>::*)(class std::vector<double> &, class std::vector<double> &) const) &ROL::Quadrature1D<double>::get, "C++: ROL::Quadrature1D<double>::get(class std::vector<double> &, class std::vector<double> &) const --> void", pybind11::arg("pts"), pybind11::arg("wts"));
		cl.def("test", [](ROL::Quadrature1D<double> const &o) -> std::vector<class std::vector<double> > { return o.test(); }, "");
		cl.def("test", [](ROL::Quadrature1D<double> const &o, const bool & a0) -> std::vector<class std::vector<double> > { return o.test(a0); }, "", pybind11::arg("printToStream"));
		cl.def("test", (class std::vector<class std::vector<double> > (ROL::Quadrature1D<double>::*)(const bool, std::ostream &) const) &ROL::Quadrature1D<double>::test, "C++: ROL::Quadrature1D<double>::test(const bool, std::ostream &) const --> class std::vector<class std::vector<double> >", pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Quadrature1D<double> & (ROL::Quadrature1D<double>::*)(const class ROL::Quadrature1D<double> &)) &ROL::Quadrature1D<double>::operator=, "C++: ROL::Quadrature1D<double>::operator=(const class ROL::Quadrature1D<double> &) --> class ROL::Quadrature1D<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::GaussLegendreQuadrature file:ROL_GaussLegendreQuadrature.hpp line:18
		pybind11::class_<ROL::GaussLegendreQuadrature<double>, Teuchos::RCP<ROL::GaussLegendreQuadrature<double>>, PyCallBack_ROL_GaussLegendreQuadrature_double_t, ROL::Quadrature1D<double>> cl(M("ROL"), "GaussLegendreQuadrature_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<const int>(), pybind11::arg("nQuad") );

		cl.def( pybind11::init( [](PyCallBack_ROL_GaussLegendreQuadrature_double_t const &o){ return new PyCallBack_ROL_GaussLegendreQuadrature_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::GaussLegendreQuadrature<double> const &o){ return new ROL::GaussLegendreQuadrature<double>(o); } ) );
		cl.def("test", [](ROL::GaussLegendreQuadrature<double> const &o) -> std::vector<class std::vector<double> > { return o.test(); }, "");
		cl.def("test", [](ROL::GaussLegendreQuadrature<double> const &o, const bool & a0) -> std::vector<class std::vector<double> > { return o.test(a0); }, "", pybind11::arg("printToStream"));
		cl.def("test", (class std::vector<class std::vector<double> > (ROL::GaussLegendreQuadrature<double>::*)(const bool, std::ostream &) const) &ROL::GaussLegendreQuadrature<double>::test, "C++: ROL::GaussLegendreQuadrature<double>::test(const bool, std::ostream &) const --> class std::vector<class std::vector<double> >", pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("get", (void (ROL::Quadrature1D<double>::*)(class std::vector<double> &, class std::vector<double> &) const) &ROL::Quadrature1D<double>::get, "C++: ROL::Quadrature1D<double>::get(class std::vector<double> &, class std::vector<double> &) const --> void", pybind11::arg("pts"), pybind11::arg("wts"));
		cl.def("test", [](ROL::Quadrature1D<double> const &o) -> std::vector<class std::vector<double> > { return o.test(); }, "");
		cl.def("test", [](ROL::Quadrature1D<double> const &o, const bool & a0) -> std::vector<class std::vector<double> > { return o.test(a0); }, "", pybind11::arg("printToStream"));
		cl.def("test", (class std::vector<class std::vector<double> > (ROL::Quadrature1D<double>::*)(const bool, std::ostream &) const) &ROL::Quadrature1D<double>::test, "C++: ROL::Quadrature1D<double>::test(const bool, std::ostream &) const --> class std::vector<class std::vector<double> >", pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Quadrature1D<double> & (ROL::Quadrature1D<double>::*)(const class ROL::Quadrature1D<double> &)) &ROL::Quadrature1D<double>::operator=, "C++: ROL::Quadrature1D<double>::operator=(const class ROL::Quadrature1D<double> &) --> class ROL::Quadrature1D<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::Fejer2Quadrature file:ROL_Fejer2Quadrature.hpp line:18
		pybind11::class_<ROL::Fejer2Quadrature<double>, Teuchos::RCP<ROL::Fejer2Quadrature<double>>, PyCallBack_ROL_Fejer2Quadrature_double_t, ROL::Quadrature1D<double>> cl(M("ROL"), "Fejer2Quadrature_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<const int>(), pybind11::arg("nQuad") );

		cl.def( pybind11::init( [](PyCallBack_ROL_Fejer2Quadrature_double_t const &o){ return new PyCallBack_ROL_Fejer2Quadrature_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::Fejer2Quadrature<double> const &o){ return new ROL::Fejer2Quadrature<double>(o); } ) );
		cl.def("test", [](ROL::Fejer2Quadrature<double> const &o) -> std::vector<class std::vector<double> > { return o.test(); }, "");
		cl.def("test", [](ROL::Fejer2Quadrature<double> const &o, const bool & a0) -> std::vector<class std::vector<double> > { return o.test(a0); }, "", pybind11::arg("printToStream"));
		cl.def("test", (class std::vector<class std::vector<double> > (ROL::Fejer2Quadrature<double>::*)(const bool, std::ostream &) const) &ROL::Fejer2Quadrature<double>::test, "C++: ROL::Fejer2Quadrature<double>::test(const bool, std::ostream &) const --> class std::vector<class std::vector<double> >", pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("get", (void (ROL::Quadrature1D<double>::*)(class std::vector<double> &, class std::vector<double> &) const) &ROL::Quadrature1D<double>::get, "C++: ROL::Quadrature1D<double>::get(class std::vector<double> &, class std::vector<double> &) const --> void", pybind11::arg("pts"), pybind11::arg("wts"));
		cl.def("test", [](ROL::Quadrature1D<double> const &o) -> std::vector<class std::vector<double> > { return o.test(); }, "");
		cl.def("test", [](ROL::Quadrature1D<double> const &o, const bool & a0) -> std::vector<class std::vector<double> > { return o.test(a0); }, "", pybind11::arg("printToStream"));
		cl.def("test", (class std::vector<class std::vector<double> > (ROL::Quadrature1D<double>::*)(const bool, std::ostream &) const) &ROL::Quadrature1D<double>::test, "C++: ROL::Quadrature1D<double>::test(const bool, std::ostream &) const --> class std::vector<class std::vector<double> >", pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Quadrature1D<double> & (ROL::Quadrature1D<double>::*)(const class ROL::Quadrature1D<double> &)) &ROL::Quadrature1D<double>::operator=, "C++: ROL::Quadrature1D<double>::operator=(const class ROL::Quadrature1D<double> &) --> class ROL::Quadrature1D<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::SecondOrderCVaR file:ROL_SecondOrderCVaR.hpp line:51
		pybind11::class_<ROL::SecondOrderCVaR<double>, Teuchos::RCP<ROL::SecondOrderCVaR<double>>, PyCallBack_ROL_SecondOrderCVaR_double_t, ROL::SpectralRisk<double>> cl(M("ROL"), "SecondOrderCVaR_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](const double & a0, const int & a1, const class Teuchos::RCP<class ROL::PlusFunction<double> > & a2){ return new ROL::SecondOrderCVaR<double>(a0, a1, a2); }, [](const double & a0, const int & a1, const class Teuchos::RCP<class ROL::PlusFunction<double> > & a2){ return new PyCallBack_ROL_SecondOrderCVaR_double_t(a0, a1, a2); } ), "doc");
		cl.def( pybind11::init<const double, const int, const class Teuchos::RCP<class ROL::PlusFunction<double> > &, const bool>(), pybind11::arg("alpha"), pybind11::arg("nQuad"), pybind11::arg("pf"), pybind11::arg("useGauss") );

		cl.def( pybind11::init( [](PyCallBack_ROL_SecondOrderCVaR_double_t const &o){ return new PyCallBack_ROL_SecondOrderCVaR_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::SecondOrderCVaR<double> const &o){ return new ROL::SecondOrderCVaR<double>(o); } ) );
		cl.def("assign", (class ROL::SecondOrderCVaR<double> & (ROL::SecondOrderCVaR<double>::*)(const class ROL::SecondOrderCVaR<double> &)) &ROL::SecondOrderCVaR<double>::operator=, "C++: ROL::SecondOrderCVaR<double>::operator=(const class ROL::SecondOrderCVaR<double> &) --> class ROL::SecondOrderCVaR<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("setStorage", (void (ROL::SpectralRisk<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::SpectralRisk<double>::setStorage, "C++: ROL::SpectralRisk<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::SpectralRisk<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::SpectralRisk<double>::setHessVecStorage, "C++: ROL::SpectralRisk<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("setSample", (void (ROL::SpectralRisk<double>::*)(const class std::vector<double> &, const double)) &ROL::SpectralRisk<double>::setSample, "C++: ROL::SpectralRisk<double>::setSample(const class std::vector<double> &, const double) --> void", pybind11::arg("point"), pybind11::arg("weight"));
		cl.def("resetStorage", [](ROL::SpectralRisk<double> &o) -> void { return o.resetStorage(); }, "");
		cl.def("resetStorage", (void (ROL::SpectralRisk<double>::*)(bool)) &ROL::SpectralRisk<double>::resetStorage, "C++: ROL::SpectralRisk<double>::resetStorage(bool) --> void", pybind11::arg("flag"));
		cl.def("resetStorage", (void (ROL::SpectralRisk<double>::*)(enum ROL::UpdateType)) &ROL::SpectralRisk<double>::resetStorage, "C++: ROL::SpectralRisk<double>::resetStorage(enum ROL::UpdateType) --> void", pybind11::arg("type"));
		cl.def("initialize", (void (ROL::SpectralRisk<double>::*)(const class ROL::Vector<double> &)) &ROL::SpectralRisk<double>::initialize, "C++: ROL::SpectralRisk<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("computeStatistic", (double (ROL::SpectralRisk<double>::*)(const class Teuchos::RCP<const class std::vector<double> > &) const) &ROL::SpectralRisk<double>::computeStatistic, "C++: ROL::SpectralRisk<double>::computeStatistic(const class Teuchos::RCP<const class std::vector<double> > &) const --> double", pybind11::arg("xstat"));
		cl.def("updateValue", (void (ROL::SpectralRisk<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::SpectralRisk<double>::updateValue, "C++: ROL::SpectralRisk<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateGradient", (void (ROL::SpectralRisk<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::SpectralRisk<double>::updateGradient, "C++: ROL::SpectralRisk<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateHessVec", (void (ROL::SpectralRisk<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::SpectralRisk<double>::updateHessVec, "C++: ROL::SpectralRisk<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::SpectralRisk<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::SpectralRisk<double>::getValue, "C++: ROL::SpectralRisk<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getGradient", (void (ROL::SpectralRisk<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::SpectralRisk<double>::getGradient, "C++: ROL::SpectralRisk<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getHessVec", (void (ROL::SpectralRisk<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::SpectralRisk<double>::getHessVec, "C++: ROL::SpectralRisk<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::SpectralRisk<double> & (ROL::SpectralRisk<double>::*)(const class ROL::SpectralRisk<double> &)) &ROL::SpectralRisk<double>::operator=, "C++: ROL::SpectralRisk<double>::operator=(const class ROL::SpectralRisk<double> &) --> class ROL::SpectralRisk<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("useStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useStorage, "C++: ROL::RandVarFunctional<double>::useStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("useHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useHessVecStorage, "C++: ROL::RandVarFunctional<double>::useHessVecStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("setStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setStorage, "C++: ROL::RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setHessVecStorage, "C++: ROL::RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("resetStorage", [](ROL::RandVarFunctional<double> &o) -> void { return o.resetStorage(); }, "");
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(bool) --> void", pybind11::arg("flag"));
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(enum ROL::UpdateType)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(enum ROL::UpdateType) --> void", pybind11::arg("type"));
		cl.def("initialize", (void (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::RandVarFunctional<double>::initialize, "C++: ROL::RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("setSample", (void (ROL::RandVarFunctional<double>::*)(const class std::vector<double> &, const double)) &ROL::RandVarFunctional<double>::setSample, "C++: ROL::RandVarFunctional<double>::setSample(const class std::vector<double> &, const double) --> void", pybind11::arg("point"), pybind11::arg("weight"));
		cl.def("computeStatistic", (double (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<const class std::vector<double> > &) const) &ROL::RandVarFunctional<double>::computeStatistic, "C++: ROL::RandVarFunctional<double>::computeStatistic(const class Teuchos::RCP<const class std::vector<double> > &) const --> double", pybind11::arg("xstat"));
		cl.def("updateValue", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateValue, "C++: ROL::RandVarFunctional<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateGradient, "C++: ROL::RandVarFunctional<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateHessVec, "C++: ROL::RandVarFunctional<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getValue, "C++: ROL::RandVarFunctional<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getGradient, "C++: ROL::RandVarFunctional<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getHessVec, "C++: ROL::RandVarFunctional<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::RandVarFunctional<double> & (ROL::RandVarFunctional<double>::*)(const class ROL::RandVarFunctional<double> &)) &ROL::RandVarFunctional<double>::operator=, "C++: ROL::RandVarFunctional<double>::operator=(const class ROL::RandVarFunctional<double> &) --> class ROL::RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::GaussChebyshev1Quadrature file:ROL_GaussChebyshev1Quadrature.hpp line:18
		pybind11::class_<ROL::GaussChebyshev1Quadrature<double>, Teuchos::RCP<ROL::GaussChebyshev1Quadrature<double>>, PyCallBack_ROL_GaussChebyshev1Quadrature_double_t, ROL::Quadrature1D<double>> cl(M("ROL"), "GaussChebyshev1Quadrature_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<const int>(), pybind11::arg("nQuad") );

		cl.def( pybind11::init( [](PyCallBack_ROL_GaussChebyshev1Quadrature_double_t const &o){ return new PyCallBack_ROL_GaussChebyshev1Quadrature_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::GaussChebyshev1Quadrature<double> const &o){ return new ROL::GaussChebyshev1Quadrature<double>(o); } ) );
		cl.def("test", [](ROL::GaussChebyshev1Quadrature<double> const &o) -> std::vector<class std::vector<double> > { return o.test(); }, "");
		cl.def("test", [](ROL::GaussChebyshev1Quadrature<double> const &o, const bool & a0) -> std::vector<class std::vector<double> > { return o.test(a0); }, "", pybind11::arg("printToStream"));
		cl.def("test", (class std::vector<class std::vector<double> > (ROL::GaussChebyshev1Quadrature<double>::*)(const bool, std::ostream &) const) &ROL::GaussChebyshev1Quadrature<double>::test, "C++: ROL::GaussChebyshev1Quadrature<double>::test(const bool, std::ostream &) const --> class std::vector<class std::vector<double> >", pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("get", (void (ROL::Quadrature1D<double>::*)(class std::vector<double> &, class std::vector<double> &) const) &ROL::Quadrature1D<double>::get, "C++: ROL::Quadrature1D<double>::get(class std::vector<double> &, class std::vector<double> &) const --> void", pybind11::arg("pts"), pybind11::arg("wts"));
		cl.def("test", [](ROL::Quadrature1D<double> const &o) -> std::vector<class std::vector<double> > { return o.test(); }, "");
		cl.def("test", [](ROL::Quadrature1D<double> const &o, const bool & a0) -> std::vector<class std::vector<double> > { return o.test(a0); }, "", pybind11::arg("printToStream"));
		cl.def("test", (class std::vector<class std::vector<double> > (ROL::Quadrature1D<double>::*)(const bool, std::ostream &) const) &ROL::Quadrature1D<double>::test, "C++: ROL::Quadrature1D<double>::test(const bool, std::ostream &) const --> class std::vector<class std::vector<double> >", pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Quadrature1D<double> & (ROL::Quadrature1D<double>::*)(const class ROL::Quadrature1D<double> &)) &ROL::Quadrature1D<double>::operator=, "C++: ROL::Quadrature1D<double>::operator=(const class ROL::Quadrature1D<double> &) --> class ROL::Quadrature1D<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::GaussChebyshev2Quadrature file:ROL_GaussChebyshev2Quadrature.hpp line:19
		pybind11::class_<ROL::GaussChebyshev2Quadrature<double>, Teuchos::RCP<ROL::GaussChebyshev2Quadrature<double>>, PyCallBack_ROL_GaussChebyshev2Quadrature_double_t, ROL::Quadrature1D<double>> cl(M("ROL"), "GaussChebyshev2Quadrature_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<const int>(), pybind11::arg("nQuad") );

		cl.def( pybind11::init( [](PyCallBack_ROL_GaussChebyshev2Quadrature_double_t const &o){ return new PyCallBack_ROL_GaussChebyshev2Quadrature_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::GaussChebyshev2Quadrature<double> const &o){ return new ROL::GaussChebyshev2Quadrature<double>(o); } ) );
		cl.def("test", [](ROL::GaussChebyshev2Quadrature<double> const &o) -> std::vector<class std::vector<double> > { return o.test(); }, "");
		cl.def("test", [](ROL::GaussChebyshev2Quadrature<double> const &o, const bool & a0) -> std::vector<class std::vector<double> > { return o.test(a0); }, "", pybind11::arg("printToStream"));
		cl.def("test", (class std::vector<class std::vector<double> > (ROL::GaussChebyshev2Quadrature<double>::*)(const bool, std::ostream &) const) &ROL::GaussChebyshev2Quadrature<double>::test, "C++: ROL::GaussChebyshev2Quadrature<double>::test(const bool, std::ostream &) const --> class std::vector<class std::vector<double> >", pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("get", (void (ROL::Quadrature1D<double>::*)(class std::vector<double> &, class std::vector<double> &) const) &ROL::Quadrature1D<double>::get, "C++: ROL::Quadrature1D<double>::get(class std::vector<double> &, class std::vector<double> &) const --> void", pybind11::arg("pts"), pybind11::arg("wts"));
		cl.def("test", [](ROL::Quadrature1D<double> const &o) -> std::vector<class std::vector<double> > { return o.test(); }, "");
		cl.def("test", [](ROL::Quadrature1D<double> const &o, const bool & a0) -> std::vector<class std::vector<double> > { return o.test(a0); }, "", pybind11::arg("printToStream"));
		cl.def("test", (class std::vector<class std::vector<double> > (ROL::Quadrature1D<double>::*)(const bool, std::ostream &) const) &ROL::Quadrature1D<double>::test, "C++: ROL::Quadrature1D<double>::test(const bool, std::ostream &) const --> class std::vector<class std::vector<double> >", pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Quadrature1D<double> & (ROL::Quadrature1D<double>::*)(const class ROL::Quadrature1D<double> &)) &ROL::Quadrature1D<double>::operator=, "C++: ROL::Quadrature1D<double>::operator=(const class ROL::Quadrature1D<double> &) --> class ROL::Quadrature1D<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::GaussChebyshev3Quadrature file:ROL_GaussChebyshev3Quadrature.hpp line:19
		pybind11::class_<ROL::GaussChebyshev3Quadrature<double>, Teuchos::RCP<ROL::GaussChebyshev3Quadrature<double>>, PyCallBack_ROL_GaussChebyshev3Quadrature_double_t, ROL::Quadrature1D<double>> cl(M("ROL"), "GaussChebyshev3Quadrature_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<const int>(), pybind11::arg("nQuad") );

		cl.def( pybind11::init( [](PyCallBack_ROL_GaussChebyshev3Quadrature_double_t const &o){ return new PyCallBack_ROL_GaussChebyshev3Quadrature_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::GaussChebyshev3Quadrature<double> const &o){ return new ROL::GaussChebyshev3Quadrature<double>(o); } ) );
		cl.def("test", [](ROL::GaussChebyshev3Quadrature<double> const &o) -> std::vector<class std::vector<double> > { return o.test(); }, "");
		cl.def("test", [](ROL::GaussChebyshev3Quadrature<double> const &o, const bool & a0) -> std::vector<class std::vector<double> > { return o.test(a0); }, "", pybind11::arg("printToStream"));
		cl.def("test", (class std::vector<class std::vector<double> > (ROL::GaussChebyshev3Quadrature<double>::*)(const bool, std::ostream &) const) &ROL::GaussChebyshev3Quadrature<double>::test, "C++: ROL::GaussChebyshev3Quadrature<double>::test(const bool, std::ostream &) const --> class std::vector<class std::vector<double> >", pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("get", (void (ROL::Quadrature1D<double>::*)(class std::vector<double> &, class std::vector<double> &) const) &ROL::Quadrature1D<double>::get, "C++: ROL::Quadrature1D<double>::get(class std::vector<double> &, class std::vector<double> &) const --> void", pybind11::arg("pts"), pybind11::arg("wts"));
		cl.def("test", [](ROL::Quadrature1D<double> const &o) -> std::vector<class std::vector<double> > { return o.test(); }, "");
		cl.def("test", [](ROL::Quadrature1D<double> const &o, const bool & a0) -> std::vector<class std::vector<double> > { return o.test(a0); }, "", pybind11::arg("printToStream"));
		cl.def("test", (class std::vector<class std::vector<double> > (ROL::Quadrature1D<double>::*)(const bool, std::ostream &) const) &ROL::Quadrature1D<double>::test, "C++: ROL::Quadrature1D<double>::test(const bool, std::ostream &) const --> class std::vector<class std::vector<double> >", pybind11::arg("printToStream"), pybind11::arg("outStream"));
		cl.def("assign", (class ROL::Quadrature1D<double> & (ROL::Quadrature1D<double>::*)(const class ROL::Quadrature1D<double> &)) &ROL::Quadrature1D<double>::operator=, "C++: ROL::Quadrature1D<double>::operator=(const class ROL::Quadrature1D<double> &) --> class ROL::Quadrature1D<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::ChebyshevSpectral file:ROL_ChebyshevSpectral.hpp line:63
		pybind11::class_<ROL::ChebyshevSpectral<double>, Teuchos::RCP<ROL::ChebyshevSpectral<double>>, PyCallBack_ROL_ChebyshevSpectral_double_t, ROL::SpectralRisk<double>> cl(M("ROL"), "ChebyshevSpectral_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init<const double, const double, const int, const int, const class Teuchos::RCP<class ROL::PlusFunction<double> > &>(), pybind11::arg("lower"), pybind11::arg("upper"), pybind11::arg("nQuad"), pybind11::arg("wType"), pybind11::arg("pf") );

		cl.def( pybind11::init( [](PyCallBack_ROL_ChebyshevSpectral_double_t const &o){ return new PyCallBack_ROL_ChebyshevSpectral_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::ChebyshevSpectral<double> const &o){ return new ROL::ChebyshevSpectral<double>(o); } ) );
		cl.def("assign", (class ROL::ChebyshevSpectral<double> & (ROL::ChebyshevSpectral<double>::*)(const class ROL::ChebyshevSpectral<double> &)) &ROL::ChebyshevSpectral<double>::operator=, "C++: ROL::ChebyshevSpectral<double>::operator=(const class ROL::ChebyshevSpectral<double> &) --> class ROL::ChebyshevSpectral<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("setStorage", (void (ROL::SpectralRisk<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::SpectralRisk<double>::setStorage, "C++: ROL::SpectralRisk<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::SpectralRisk<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::SpectralRisk<double>::setHessVecStorage, "C++: ROL::SpectralRisk<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("setSample", (void (ROL::SpectralRisk<double>::*)(const class std::vector<double> &, const double)) &ROL::SpectralRisk<double>::setSample, "C++: ROL::SpectralRisk<double>::setSample(const class std::vector<double> &, const double) --> void", pybind11::arg("point"), pybind11::arg("weight"));
		cl.def("resetStorage", [](ROL::SpectralRisk<double> &o) -> void { return o.resetStorage(); }, "");
		cl.def("resetStorage", (void (ROL::SpectralRisk<double>::*)(bool)) &ROL::SpectralRisk<double>::resetStorage, "C++: ROL::SpectralRisk<double>::resetStorage(bool) --> void", pybind11::arg("flag"));
		cl.def("resetStorage", (void (ROL::SpectralRisk<double>::*)(enum ROL::UpdateType)) &ROL::SpectralRisk<double>::resetStorage, "C++: ROL::SpectralRisk<double>::resetStorage(enum ROL::UpdateType) --> void", pybind11::arg("type"));
		cl.def("initialize", (void (ROL::SpectralRisk<double>::*)(const class ROL::Vector<double> &)) &ROL::SpectralRisk<double>::initialize, "C++: ROL::SpectralRisk<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("computeStatistic", (double (ROL::SpectralRisk<double>::*)(const class Teuchos::RCP<const class std::vector<double> > &) const) &ROL::SpectralRisk<double>::computeStatistic, "C++: ROL::SpectralRisk<double>::computeStatistic(const class Teuchos::RCP<const class std::vector<double> > &) const --> double", pybind11::arg("xstat"));
		cl.def("updateValue", (void (ROL::SpectralRisk<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::SpectralRisk<double>::updateValue, "C++: ROL::SpectralRisk<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateGradient", (void (ROL::SpectralRisk<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::SpectralRisk<double>::updateGradient, "C++: ROL::SpectralRisk<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateHessVec", (void (ROL::SpectralRisk<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::SpectralRisk<double>::updateHessVec, "C++: ROL::SpectralRisk<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::SpectralRisk<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::SpectralRisk<double>::getValue, "C++: ROL::SpectralRisk<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getGradient", (void (ROL::SpectralRisk<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::SpectralRisk<double>::getGradient, "C++: ROL::SpectralRisk<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getHessVec", (void (ROL::SpectralRisk<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::SpectralRisk<double>::getHessVec, "C++: ROL::SpectralRisk<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::SpectralRisk<double> & (ROL::SpectralRisk<double>::*)(const class ROL::SpectralRisk<double> &)) &ROL::SpectralRisk<double>::operator=, "C++: ROL::SpectralRisk<double>::operator=(const class ROL::SpectralRisk<double> &) --> class ROL::SpectralRisk<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("useStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useStorage, "C++: ROL::RandVarFunctional<double>::useStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("useHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useHessVecStorage, "C++: ROL::RandVarFunctional<double>::useHessVecStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("setStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setStorage, "C++: ROL::RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setHessVecStorage, "C++: ROL::RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("resetStorage", [](ROL::RandVarFunctional<double> &o) -> void { return o.resetStorage(); }, "");
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(bool) --> void", pybind11::arg("flag"));
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(enum ROL::UpdateType)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(enum ROL::UpdateType) --> void", pybind11::arg("type"));
		cl.def("initialize", (void (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::RandVarFunctional<double>::initialize, "C++: ROL::RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("setSample", (void (ROL::RandVarFunctional<double>::*)(const class std::vector<double> &, const double)) &ROL::RandVarFunctional<double>::setSample, "C++: ROL::RandVarFunctional<double>::setSample(const class std::vector<double> &, const double) --> void", pybind11::arg("point"), pybind11::arg("weight"));
		cl.def("computeStatistic", (double (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<const class std::vector<double> > &) const) &ROL::RandVarFunctional<double>::computeStatistic, "C++: ROL::RandVarFunctional<double>::computeStatistic(const class Teuchos::RCP<const class std::vector<double> > &) const --> double", pybind11::arg("xstat"));
		cl.def("updateValue", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateValue, "C++: ROL::RandVarFunctional<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateGradient, "C++: ROL::RandVarFunctional<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateHessVec, "C++: ROL::RandVarFunctional<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getValue, "C++: ROL::RandVarFunctional<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getGradient, "C++: ROL::RandVarFunctional<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getHessVec, "C++: ROL::RandVarFunctional<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::RandVarFunctional<double> & (ROL::RandVarFunctional<double>::*)(const class ROL::RandVarFunctional<double> &)) &ROL::RandVarFunctional<double>::operator=, "C++: ROL::RandVarFunctional<double>::operator=(const class ROL::RandVarFunctional<double> &) --> class ROL::RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::QuantileRadius file:ROL_QuantileRadius.hpp line:21
		pybind11::class_<ROL::QuantileRadius<double>, Teuchos::RCP<ROL::QuantileRadius<double>>, PyCallBack_ROL_QuantileRadius_double_t, ROL::RandVarFunctional<double>> cl(M("ROL"), "QuantileRadius_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init<const double, const double, const class Teuchos::RCP<class ROL::PlusFunction<double> > &>(), pybind11::arg("prob"), pybind11::arg("coeff"), pybind11::arg("pf") );

		cl.def( pybind11::init( [](PyCallBack_ROL_QuantileRadius_double_t const &o){ return new PyCallBack_ROL_QuantileRadius_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::QuantileRadius<double> const &o){ return new ROL::QuantileRadius<double>(o); } ) );
		cl.def("initialize", (void (ROL::QuantileRadius<double>::*)(const class ROL::Vector<double> &)) &ROL::QuantileRadius<double>::initialize, "C++: ROL::QuantileRadius<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("computeStatistic", (double (ROL::QuantileRadius<double>::*)(const class Teuchos::RCP<const class std::vector<double> > &) const) &ROL::QuantileRadius<double>::computeStatistic, "C++: ROL::QuantileRadius<double>::computeStatistic(const class Teuchos::RCP<const class std::vector<double> > &) const --> double", pybind11::arg("xstat"));
		cl.def("updateValue", (void (ROL::QuantileRadius<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::QuantileRadius<double>::updateValue, "C++: ROL::QuantileRadius<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::QuantileRadius<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::QuantileRadius<double>::getValue, "C++: ROL::QuantileRadius<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("updateGradient", (void (ROL::QuantileRadius<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::QuantileRadius<double>::updateGradient, "C++: ROL::QuantileRadius<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getGradient", (void (ROL::QuantileRadius<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::QuantileRadius<double>::getGradient, "C++: ROL::QuantileRadius<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("updateHessVec", (void (ROL::QuantileRadius<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::QuantileRadius<double>::updateHessVec, "C++: ROL::QuantileRadius<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getHessVec", (void (ROL::QuantileRadius<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::QuantileRadius<double>::getHessVec, "C++: ROL::QuantileRadius<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::QuantileRadius<double> & (ROL::QuantileRadius<double>::*)(const class ROL::QuantileRadius<double> &)) &ROL::QuantileRadius<double>::operator=, "C++: ROL::QuantileRadius<double>::operator=(const class ROL::QuantileRadius<double> &) --> class ROL::QuantileRadius<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("useStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useStorage, "C++: ROL::RandVarFunctional<double>::useStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("useHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useHessVecStorage, "C++: ROL::RandVarFunctional<double>::useHessVecStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("setStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setStorage, "C++: ROL::RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setHessVecStorage, "C++: ROL::RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("resetStorage", [](ROL::RandVarFunctional<double> &o) -> void { return o.resetStorage(); }, "");
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(bool) --> void", pybind11::arg("flag"));
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(enum ROL::UpdateType)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(enum ROL::UpdateType) --> void", pybind11::arg("type"));
		cl.def("initialize", (void (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::RandVarFunctional<double>::initialize, "C++: ROL::RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("setSample", (void (ROL::RandVarFunctional<double>::*)(const class std::vector<double> &, const double)) &ROL::RandVarFunctional<double>::setSample, "C++: ROL::RandVarFunctional<double>::setSample(const class std::vector<double> &, const double) --> void", pybind11::arg("point"), pybind11::arg("weight"));
		cl.def("computeStatistic", (double (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<const class std::vector<double> > &) const) &ROL::RandVarFunctional<double>::computeStatistic, "C++: ROL::RandVarFunctional<double>::computeStatistic(const class Teuchos::RCP<const class std::vector<double> > &) const --> double", pybind11::arg("xstat"));
		cl.def("updateValue", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateValue, "C++: ROL::RandVarFunctional<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateGradient, "C++: ROL::RandVarFunctional<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateHessVec, "C++: ROL::RandVarFunctional<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getValue, "C++: ROL::RandVarFunctional<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getGradient, "C++: ROL::RandVarFunctional<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getHessVec, "C++: ROL::RandVarFunctional<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::RandVarFunctional<double> & (ROL::RandVarFunctional<double>::*)(const class ROL::RandVarFunctional<double> &)) &ROL::RandVarFunctional<double>::operator=, "C++: ROL::RandVarFunctional<double>::operator=(const class ROL::RandVarFunctional<double> &) --> class ROL::RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::HMCR file:ROL_HMCR.hpp line:41
		pybind11::class_<ROL::HMCR<double>, Teuchos::RCP<ROL::HMCR<double>>, PyCallBack_ROL_HMCR_double_t, ROL::RandVarFunctional<double>> cl(M("ROL"), "HMCR_double_t", "", pybind11::module_local());
		cl.def( pybind11::init<const double, const double, const unsigned int, const class Teuchos::RCP<class ROL::PlusFunction<double> > &>(), pybind11::arg("prob"), pybind11::arg("lambda"), pybind11::arg("order"), pybind11::arg("pf") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_HMCR_double_t const &o){ return new PyCallBack_ROL_HMCR_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::HMCR<double> const &o){ return new ROL::HMCR<double>(o); } ) );
		cl.def("initialize", (void (ROL::HMCR<double>::*)(const class ROL::Vector<double> &)) &ROL::HMCR<double>::initialize, "C++: ROL::HMCR<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("updateValue", (void (ROL::HMCR<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::HMCR<double>::updateValue, "C++: ROL::HMCR<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::HMCR<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::HMCR<double>::getValue, "C++: ROL::HMCR<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("updateGradient", (void (ROL::HMCR<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::HMCR<double>::updateGradient, "C++: ROL::HMCR<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getGradient", (void (ROL::HMCR<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::HMCR<double>::getGradient, "C++: ROL::HMCR<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("updateHessVec", (void (ROL::HMCR<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::HMCR<double>::updateHessVec, "C++: ROL::HMCR<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getHessVec", (void (ROL::HMCR<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::HMCR<double>::getHessVec, "C++: ROL::HMCR<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::HMCR<double> & (ROL::HMCR<double>::*)(const class ROL::HMCR<double> &)) &ROL::HMCR<double>::operator=, "C++: ROL::HMCR<double>::operator=(const class ROL::HMCR<double> &) --> class ROL::HMCR<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("useStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useStorage, "C++: ROL::RandVarFunctional<double>::useStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("useHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::useHessVecStorage, "C++: ROL::RandVarFunctional<double>::useHessVecStorage(bool) --> void", pybind11::arg("storage"));
		cl.def("setStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setStorage, "C++: ROL::RandVarFunctional<double>::setStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("value_storage"), pybind11::arg("gradient_storage"));
		cl.def("setHessVecStorage", (void (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &)) &ROL::RandVarFunctional<double>::setHessVecStorage, "C++: ROL::RandVarFunctional<double>::setHessVecStorage(const class Teuchos::RCP<class ROL::ScalarController<double> > &, const class Teuchos::RCP<class ROL::VectorController<double> > &) --> void", pybind11::arg("gradvec_storage"), pybind11::arg("hessvec_storage"));
		cl.def("resetStorage", [](ROL::RandVarFunctional<double> &o) -> void { return o.resetStorage(); }, "");
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(bool)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(bool) --> void", pybind11::arg("flag"));
		cl.def("resetStorage", (void (ROL::RandVarFunctional<double>::*)(enum ROL::UpdateType)) &ROL::RandVarFunctional<double>::resetStorage, "C++: ROL::RandVarFunctional<double>::resetStorage(enum ROL::UpdateType) --> void", pybind11::arg("type"));
		cl.def("initialize", (void (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &)) &ROL::RandVarFunctional<double>::initialize, "C++: ROL::RandVarFunctional<double>::initialize(const class ROL::Vector<double> &) --> void", pybind11::arg("x"));
		cl.def("setSample", (void (ROL::RandVarFunctional<double>::*)(const class std::vector<double> &, const double)) &ROL::RandVarFunctional<double>::setSample, "C++: ROL::RandVarFunctional<double>::setSample(const class std::vector<double> &, const double) --> void", pybind11::arg("point"), pybind11::arg("weight"));
		cl.def("computeStatistic", (double (ROL::RandVarFunctional<double>::*)(const class Teuchos::RCP<const class std::vector<double> > &) const) &ROL::RandVarFunctional<double>::computeStatistic, "C++: ROL::RandVarFunctional<double>::computeStatistic(const class Teuchos::RCP<const class std::vector<double> > &) const --> double", pybind11::arg("xstat"));
		cl.def("updateValue", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateValue, "C++: ROL::RandVarFunctional<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateGradient, "C++: ROL::RandVarFunctional<double>::updateGradient(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("updateHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::RandVarFunctional<double>::updateHessVec, "C++: ROL::RandVarFunctional<double>::updateHessVec(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::RandVarFunctional<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getValue, "C++: ROL::RandVarFunctional<double>::getValue(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> double", pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getGradient", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getGradient, "C++: ROL::RandVarFunctional<double>::getGradient(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("g"), pybind11::arg("gstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("getHessVec", (void (ROL::RandVarFunctional<double>::*)(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::RandVarFunctional<double>::getHessVec, "C++: ROL::RandVarFunctional<double>::getHessVec(class ROL::Vector<double> &, class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &) --> void", pybind11::arg("hv"), pybind11::arg("hvstat"), pybind11::arg("v"), pybind11::arg("vstat"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("sampler"));
		cl.def("assign", (class ROL::RandVarFunctional<double> & (ROL::RandVarFunctional<double>::*)(const class ROL::RandVarFunctional<double> &)) &ROL::RandVarFunctional<double>::operator=, "C++: ROL::RandVarFunctional<double>::operator=(const class ROL::RandVarFunctional<double> &) --> class ROL::RandVarFunctional<double> &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
	{ // ROL::EntropicRisk file:ROL_EntropicRisk.hpp line:32
		pybind11::class_<ROL::EntropicRisk<double>, Teuchos::RCP<ROL::EntropicRisk<double>>, PyCallBack_ROL_EntropicRisk_double_t, ROL::RandVarFunctional<double>> cl(M("ROL"), "EntropicRisk_double_t", "", pybind11::module_local());
		cl.def( pybind11::init( [](){ return new ROL::EntropicRisk<double>(); }, [](){ return new PyCallBack_ROL_EntropicRisk_double_t(); } ), "doc");
		cl.def( pybind11::init<const double>(), pybind11::arg("coeff") );

		cl.def( pybind11::init<class Teuchos::ParameterList &>(), pybind11::arg("parlist") );

		cl.def( pybind11::init( [](PyCallBack_ROL_EntropicRisk_double_t const &o){ return new PyCallBack_ROL_EntropicRisk_double_t(o); } ) );
		cl.def( pybind11::init( [](ROL::EntropicRisk<double> const &o){ return new ROL::EntropicRisk<double>(o); } ) );
		cl.def("updateValue", (void (ROL::EntropicRisk<double>::*)(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &)) &ROL::EntropicRisk<double>::updateValue, "C++: ROL::EntropicRisk<double>::updateValue(class ROL::Objective<double> &, const class ROL::Vector<double> &, const class std::vector<double> &, double &) --> void", pybind11::arg("obj"), pybind11::arg("x"), pybind11::arg("xstat"), pybind11::arg("tol"));
		cl.def("getValue", (double (ROL::EntropicRisk<double>::*)(const class ROL::Vector<double> &, const class std::vector<double> &, class ROL::SampleGenerator<double> &)) &ROL::EntropicRisk<double>::getValue, "C++: ROL::EntropicRisk<double>::getVal