# CHANGELOG
## 0.0.323 (2024-04-15)

### :bug:

* :bug: Fix missing help in ozi-fix.

Signed-off-by: rjdbcm &lt;ozi.project@outlook.com&gt; ([`f94b65e`](https://github.com/OZI-Project/OZI/commit/f94b65e639fb68e20c1d20585a08817147d556db))

## 0.0.322 (2024-04-15)

### :bug:

* :bug: Delete emoji variables from option template.

Signed-off-by: rjdbcm &lt;ozi.project@outlook.com&gt; ([`a3c4be1`](https://github.com/OZI-Project/OZI/commit/a3c4be18b5d60704e9286d8196449ca29cb49176))

* :bug: Fix incorrectly rendering sanity-check modules.

Signed-off-by: rjdbcm &lt;ozi.project@outlook.com&gt; ([`4d305a5`](https://github.com/OZI-Project/OZI/commit/4d305a52dd1cb168b2faf5a7815f90f8c433ab7d))

## 0.0.321 (2024-04-12)

### :children_crossing:

* :hammer::children_crossing: Simplify OZI output, remove emoji.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`df8dc06`](https://github.com/OZI-Project/OZI/commit/df8dc06dff6d8101a4ee451484a6e09f3372bdfd))

### :hammer:

* :hammer::construction_worker: Simplify checkpoint runs.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`097aeec`](https://github.com/OZI-Project/OZI/commit/097aeec20eb4ad4b2e2e29c866feec67faba1292))

## 0.0.320 (2024-04-11)

### :pencil2:

* :pencil2: Fix workflow name

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`dc8c3bd`](https://github.com/OZI-Project/OZI/commit/dc8c3bdd23229bac2d32065888e5294b066e11d2))

### :pushpin:

* :pushpin: bump release to 0.1.14

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`8c684c3`](https://github.com/OZI-Project/OZI/commit/8c684c346a570ffa5bfe25b28dd02ab1a579f155))

* :pushpin: Set workflow version pins

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`ed57c62`](https://github.com/OZI-Project/OZI/commit/ed57c62ba8efb9aee234a4e535e80e2ab655ff5f))

## 0.0.319 (2024-04-10)

### :wrench:

* :wrench: Use monochrome emojis by default.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`8163a11`](https://github.com/OZI-Project/OZI/commit/8163a11b55de7f12dce2bfca07701e229d933a6e))

* :wrench: Exclude merge commits from changelogs by default.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`191a405`](https://github.com/OZI-Project/OZI/commit/191a405aa60ebdc76ee2a8f7423083a28984d51f))

## 0.0.318 (2024-04-10)

### :bug:

* :bug: Real fix duplicate found files.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`5597986`](https://github.com/OZI-Project/OZI/commit/5597986180001cec3f0bb9743157f8e624964260))

## 0.0.317 (2024-04-10)

### :bug:

* :bug: Fix duplicate count of non-missing files.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`9e4237e`](https://github.com/OZI-Project/OZI/commit/9e4237ef451956ceb870cfe124b9b37f26cbb54c))

## 0.0.316 (2024-04-10)

### :bug:

* :bug: Fix double missing file counting in root project folder.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`ca0421a`](https://github.com/OZI-Project/OZI/commit/ca0421a5a460be47b62c72118f393f4426a8af1e))

* :bug: Fix double missing file counting in root project folder.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`df514de`](https://github.com/OZI-Project/OZI/commit/df514de907b07c7a94a8db71bb9a20cba2cd6546))

### :pencil2:

* :rotating_light::pencil2: Linted with black 2024

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`3551fc9`](https://github.com/OZI-Project/OZI/commit/3551fc9fa1752a03d87dc8063f583c74713b8e1c))

### Other

* :rotating_light: run black

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`bfff664`](https://github.com/OZI-Project/OZI/commit/bfff664594276fb5f1583907b62faa53b3f3d82f))

## 0.0.315 (2024-04-10)

### :bug:

* :bug: Update ``meson.build`` template root_files to include the default root files.

Now ``ozi -fix missing`` will succeed without warning.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`e42f97f`](https://github.com/OZI-Project/OZI/commit/e42f97f18e2759232720023def745a96dac828c1))

* :bug: Fix root project folder introspection.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`e2aa569`](https://github.com/OZI-Project/OZI/commit/e2aa569da36f6643d8ac95907c8159656637f8af))

## 0.0.314 (2024-04-09)

### :arrow_up:

* :arrow_up: Bump github/codeql-action from 3.24.9 to 3.24.10

Bumps [github/codeql-action](https://github.com/github/codeql-action) from 3.24.9 to 3.24.10.
- [Release notes](https://github.com/github/codeql-action/releases)
- [Changelog](https://github.com/github/codeql-action/blob/main/CHANGELOG.md)
- [Commits](https://github.com/github/codeql-action/compare/1b1aada464948af03b950897e5eb522f92603cc2...4355270be187e1b672a7a1c7c7bae5afdc1ab94a)

---
updated-dependencies:
- dependency-name: github/codeql-action
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`1f454f1`](https://github.com/OZI-Project/OZI/commit/1f454f175e9103cb05dee6ec8a79da85b7de9554))

### :bug:

* :bug:: Fix build definition introspection.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`fd4c33b`](https://github.com/OZI-Project/OZI/commit/fd4c33b8e1aaf9d2817eb7bf7c8a2600bd8c14cc))

## 0.0.313 (2024-04-05)

### :bug:

* :bug: Fix doubled comment diagnostics.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`bddc1ff`](https://github.com/OZI-Project/OZI/commit/bddc1ff723166fea7f5e14e8ba1689d28a33f26f))

## 0.0.312 (2024-04-05)

### :bug:

* :bug: Fix double-printing of comment diagnostic for found files.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`a0fb5ff`](https://github.com/OZI-Project/OZI/commit/a0fb5ffbea84cb6f2847f82abdfbcd5e7f67d816))

### :speech_balloon:

* :speech_balloon: clarify license validation diagnostics.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`25726dc`](https://github.com/OZI-Project/OZI/commit/25726dc8834021930949764bc68fc61123f0885e))

## 0.0.311 (2024-04-05)

### :bug:

* :bug: Fix inspect_files queries subdirectory meson.build.

Now only queries values from the project root ``meson.build``.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`721aecc`](https://github.com/OZI-Project/OZI/commit/721aeccb01848696f86a34b0d10861c22d626668))

* :bug: [e2e] Fix meson rewriter not working for ozi-fix source and test add.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`57e3672`](https://github.com/OZI-Project/OZI/commit/57e36720da5e1fcd9e56d9b2698071df8221da2a))

## 0.0.310 (2024-04-04)

### :bug:

* :bug: [e2e] Fix invalid target_type key in rewriter output.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`7de6edf`](https://github.com/OZI-Project/OZI/commit/7de6edf142c1147911eb2ad02b5b24b31abde65f))

## 0.0.309 (2024-04-04)

### :bug:

* :bug: Fix missing ``install-subprojects`` option check in template output.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`9bd910a`](https://github.com/OZI-Project/OZI/commit/9bd910ac41354f085d669c98ee5fc8316dfc53ff))

## 0.0.308 (2024-04-04)

### :bug:

* :bug:: setuptools found by pip-freeze. ([`1f00096`](https://github.com/OZI-Project/OZI/commit/1f000964c495d3adbdc701db532cb6bd7a346246))

### :hammer:

* :hammer: Add ``install-subprojects`` feature option defaulting to disabled.

Default is to not install python sources when an OZI project is run as a subproject.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`4e87f13`](https://github.com/OZI-Project/OZI/commit/4e87f13d84e41a49cf9a2ed5843012d7d51a77d2))

* :hammer:: Only compile requirements for suite option that is selected.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`7b8e45c`](https://github.com/OZI-Project/OZI/commit/7b8e45c8cc25e7b6da666f4802b577855db284b3))

* :hammer: Add blastpipe bootstrap integration in ``tox -e test`` for OZI. ([`65f3405`](https://github.com/OZI-Project/OZI/commit/65f340542eb87aa6af2e0e16dfdb853d57b83329))

* :hammer: final changes to integrate blastpipe

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`202fd6b`](https://github.com/OZI-Project/OZI/commit/202fd6b1ad59cebbea0b835873cab99d138d81af))

* :hammer: Turn off ``python.install_sources`` if OZI is a subproject.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`ee24d5f`](https://github.com/OZI-Project/OZI/commit/ee24d5f042fe05db2cdf9c47fc626081cefb8ccc))

* :hammer:: Add dist scripts to project template.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`ff0359e`](https://github.com/OZI-Project/OZI/commit/ff0359ee6051910d831f60c92d8decf643e0a0e6))

* :hammer:: Add check ``not meson.is_subproject()`` to install OZI files.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`4de5304`](https://github.com/OZI-Project/OZI/commit/4de530455b1ebe5e7a2340e497538212e0e58c0b))

### Other

* :white_check_mark: Increase deadline to 30s for the new project fuzzer.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`3622015`](https://github.com/OZI-Project/OZI/commit/362201583a53704e1660c016ab29f749783829c7))

## 0.0.307 (2024-04-02)

### :hammer:

* :hammer: Update templates with blastpipe integration discoveries. ([`fc8424f`](https://github.com/OZI-Project/OZI/commit/fc8424f6c35b16aabd9c6955f0ee75435407bb81))

## 0.0.306 (2024-04-02)

### :bug:

* :wrench::bug: ``args-`` options now yield to the superproject anytime OZI is a subproject.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`4d678a1`](https://github.com/OZI-Project/OZI/commit/4d678a12059d688d4693ef30b6100f686ab12282))

### Other

* :rotating_light: Fix for PT001 changes in flake8-pytest-style 2.0.0

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`289255f`](https://github.com/OZI-Project/OZI/commit/289255f1871091e39e6f0dbecb820a78ba3009cd))

## 0.0.305 (2024-03-30)

### :bug:

* :bug::pushpin: Fix Spec should pin workflow versions #103

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`417ee26`](https://github.com/OZI-Project/OZI/commit/417ee261477f34b7039ba22e487b3ccff08bce4a))

* :bug: Fix OZI meson.build configuration step overwrites pyproject.toml. #52

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`4fe2b9a`](https://github.com/OZI-Project/OZI/commit/4fe2b9a0560f9ed0693a051044cd3e2e50f31787))

## 0.0.304 (2024-03-29)

### :hammer:

* :hammer: retry release

0.0 changes ([`f42e78e`](https://github.com/OZI-Project/OZI/commit/f42e78e77726165754dc34a79a093663f0d4dc44))

* :hammer: Force retry release

Signed-off-by: Eden Rose, MSc &lt;ozi.project@outlook.com&gt; ([`9e78fdd`](https://github.com/OZI-Project/OZI/commit/9e78fddc8950b1367caa1bef298416f453063934))

* :hammer: Force release

Signed-off-by: Eden Rose, MSc &lt;ozi.project@outlook.com&gt; ([`85e6ad8`](https://github.com/OZI-Project/OZI/commit/85e6ad88d45bd7e56bcea934c9523f637377f307))

* :hammer: Merge pull request #306 from OZI-Project/0.0 retry 0.0.304 release ([`5074b56`](https://github.com/OZI-Project/OZI/commit/5074b5696a5c22ea58a49d4d8d4978573a60cad9))

### :pushpin:

* :pushpin: Update dist-workflow.yml release to 0.1.13

Signed-off-by: Eden Rose, MSc &lt;ozi.project@outlook.com&gt; ([`e4bebe6`](https://github.com/OZI-Project/OZI/commit/e4bebe62095d089aab02fd55800aa7b3ddcef2c4))

### Other

* Update release.yml.j2 to 0.1.13

Signed-off-by: Eden Rose, MSc &lt;ozi.project@outlook.com&gt; ([`46def0a`](https://github.com/OZI-Project/OZI/commit/46def0aa92030c3d2786fa8465fc4f2a7d8ed754))

## 0.0.303 (2024-03-28)

### :hammer:

* :hammer: Remove some regexes in favor of simple hard-coded algorithms.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`3258401`](https://github.com/OZI-Project/OZI/commit/32584018af03c9e804362bd1a59357d65cb5c45a))

* :hammer: Clarify build configuration output.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`1fa90be`](https://github.com/OZI-Project/OZI/commit/1fa90bee9b8cfc69eb50755b485615b501f3faf5))

### :pushpin:

* :pushpin: Update dist-workflow.yml - release action 0.1.12

Signed-off-by: Eden Rose, MSc &lt;ozi.project@outlook.com&gt; ([`213c1fd`](https://github.com/OZI-Project/OZI/commit/213c1fd5df5ed54bfac8e31dfb7a274f740f0c0b))

### Other

* Update release.yml.j2 - release action 0.1.12

Signed-off-by: Eden Rose, MSc &lt;ozi.project@outlook.com&gt; ([`1dd7aba`](https://github.com/OZI-Project/OZI/commit/1dd7aba4c8da7b0394f3735de181628b4ccce438))

## 0.0.302 (2024-03-27)

### :pushpin:

* :pushpin: Pin black to &gt;=24.3.

This mitigates a known REDOS vulnerability.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`403fd1f`](https://github.com/OZI-Project/OZI/commit/403fd1fb4b17beebdd678f9b41725bfe82502f79))

## 0.0.301 (2024-03-27)

### :hammer:

* :hammer: purge pyc_wheel package references

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`1d563a9`](https://github.com/OZI-Project/OZI/commit/1d563a94af503b4275b36aadb0c26258a22d0935))

## 0.0.300 (2024-03-27)

### :pushpin:

* :pushpin: Bump release workflow to 0.1.11 ([`efefcb5`](https://github.com/OZI-Project/OZI/commit/efefcb5adc796725c6ddfdb62c8a503d6496ec3e))

* :pushpin: Bump release to 0.1.10 ([`2f0476b`](https://github.com/OZI-Project/OZI/commit/2f0476bcee156f169d206f4dde4f40bd1797e701))

### Other

* Update release.yml.j2 - bump release action to 0.1.11

Signed-off-by: Eden Rose, MSc &lt;ozi.project@outlook.com&gt; ([`5b4db63`](https://github.com/OZI-Project/OZI/commit/5b4db635daa8266a8ee175dc148c79ca4ff832d3))

* Update dist-workflow.yml - bump release to 0.1.11

Signed-off-by: Eden Rose, MSc &lt;ozi.project@outlook.com&gt; ([`870b99e`](https://github.com/OZI-Project/OZI/commit/870b99e5730155fab61e1cb2930868371de818b1))

* Update dist-workflow.yml - bump release to 0.1.10

Signed-off-by: Eden Rose, MSc &lt;ozi.project@outlook.com&gt; ([`0793dcb`](https://github.com/OZI-Project/OZI/commit/0793dcb031a4cf4625fbc5ea6d8b8f223b4f738c))

* Update release.yml.j2 - bump release to 0.1.10

Signed-off-by: Eden Rose, MSc &lt;ozi.project@outlook.com&gt; ([`93f02ca`](https://github.com/OZI-Project/OZI/commit/93f02ca572ef1c966294309aa056be21aef624dc))

## 0.0.299 (2024-03-26)

### :pushpin:

* :pushpin: Update release workflow pin

0.0 changes ([`2684c75`](https://github.com/OZI-Project/OZI/commit/2684c750d340e1f6b06f3c14f4bef753a9a1cde2))

### Other

* Update release.yml.j2 - bump release to 0.1.9

Signed-off-by: Eden Rose, MSc &lt;ozi.project@outlook.com&gt; ([`dc8cc69`](https://github.com/OZI-Project/OZI/commit/dc8cc69e07d93e5edb2aba4277ef580df9843c74))

* Update dist-workflow.yml - bump release to 0.1.9

Signed-off-by: Eden Rose, MSc &lt;ozi.project@outlook.com&gt; ([`9028f91`](https://github.com/OZI-Project/OZI/commit/9028f919ea91bad30933733332403e12c46df7af))

## 0.0.298 (2024-03-26)

### :arrow_up:

* :arrow_up: Bump OZI-Project/release from 0.1.5 to 0.1.6

Bumps [OZI-Project/release](https://github.com/ozi-project/release) from 0.1.5 to 0.1.6.
- [Release notes](https://github.com/ozi-project/release/releases)
- [Commits](https://github.com/ozi-project/release/compare/a443e522f64ad355f93ef88ee5e03e819a4dd451...12ac0a7c0e46ad84222a238e40e5a8fb87df3b56)

---
updated-dependencies:
- dependency-name: OZI-Project/release
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`45ade1c`](https://github.com/OZI-Project/OZI/commit/45ade1cf371d1e2aefcc795220343fffa34f4623))

* :arrow_up: Bump actions/dependency-review-action from 4.2.4 to 4.2.5

Bumps [actions/dependency-review-action](https://github.com/actions/dependency-review-action) from 4.2.4 to 4.2.5.
- [Release notes](https://github.com/actions/dependency-review-action/releases)
- [Commits](https://github.com/actions/dependency-review-action/compare/733dd5d4a5203f238c33806593ec0f5fc5343d8c...5bbc3ba658137598168acb2ab73b21c432dd411b)

---
updated-dependencies:
- dependency-name: actions/dependency-review-action
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`7de8319`](https://github.com/OZI-Project/OZI/commit/7de831999d4c0a9092ab669be383a675be7e261e))

* :arrow_up: Bump actions/dependency-review-action from 4.2.3 to 4.2.4

Bumps [actions/dependency-review-action](https://github.com/actions/dependency-review-action) from 4.2.3 to 4.2.4.
- [Release notes](https://github.com/actions/dependency-review-action/releases)
- [Commits](https://github.com/actions/dependency-review-action/compare/0fa40c3c10055986a88de3baa0d6ec17c5a894b3...733dd5d4a5203f238c33806593ec0f5fc5343d8c)

---
updated-dependencies:
- dependency-name: actions/dependency-review-action
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`b7600f5`](https://github.com/OZI-Project/OZI/commit/b7600f5136ccaa06c2340a2c8579ad8be692f021))

### :hammer:

* :hammer: Update meson.options

Drop pyc_wheel test

Signed-off-by: Eden Rose, MSc &lt;ozi.project@outlook.com&gt; ([`8dc2e4e`](https://github.com/OZI-Project/OZI/commit/8dc2e4e01e1765869cbb3fc34c136972f0fe97ff))

* :hammer::construction_worker: Add OZI-Project/pyc_wheel release action version 0.1.4

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`b3d16f1`](https://github.com/OZI-Project/OZI/commit/b3d16f1bcb4526f6b9e48f9387b9a935106733f2))

### :pushpin:

* :pushpin: Bump release workflow to 0.1.7

Signed-off-by: Eden Rose, MSc &lt;ozi.project@outlook.com&gt; ([`c3dfe48`](https://github.com/OZI-Project/OZI/commit/c3dfe48e0542894a2cf399d9474556a89aed3216))

* :pushpin: Pin release to 0.1.7

Signed-off-by: Eden Rose, MSc &lt;ozi.project@outlook.com&gt; ([`0444866`](https://github.com/OZI-Project/OZI/commit/0444866e15137c486aab7c4b7104ba16c3d07b32))

* :pushpin: Update release workflow pin

⬆️ Bump OZI-Project/release from 0.1.5 to 0.1.6 ([`e29a7c0`](https://github.com/OZI-Project/OZI/commit/e29a7c0807085e84e550e5667d6ad1cd19903d00))

* :pushpin: Bump release to 0.1.5

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`8427854`](https://github.com/OZI-Project/OZI/commit/84278543018de407d685588e71993936f2c2a9b2))

### Other

* Update dist-workflow.yml - bump release to 0.1.8

Signed-off-by: Eden Rose, MSc &lt;ozi.project@outlook.com&gt; ([`e185b0f`](https://github.com/OZI-Project/OZI/commit/e185b0f9c745051f16eb81cabaf898d0e7543470))

* Update release.yml.j2 release to 0.1.8

Signed-off-by: Eden Rose, MSc &lt;ozi.project@outlook.com&gt; ([`c763cad`](https://github.com/OZI-Project/OZI/commit/c763cad757ea160072788771828fbc61fb82336b))

## 0.0.297 (2024-03-22)

### :bug:

* :bug: [e2e] suppress TAP diagnostic output for ``ozi-fix`` in add and remove mode.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`e47f3f5`](https://github.com/OZI-Project/OZI/commit/e47f3f57c3d47ce56983664de594fbbaa2af06ae))

## 0.0.296 (2024-03-22)

### :arrow_up:

* :arrow_up: Bump github/codeql-action from 3.24.8 to 3.24.9

Bumps [github/codeql-action](https://github.com/github/codeql-action) from 3.24.8 to 3.24.9.
- [Release notes](https://github.com/github/codeql-action/releases)
- [Changelog](https://github.com/github/codeql-action/blob/main/CHANGELOG.md)
- [Commits](https://github.com/github/codeql-action/compare/05963f47d870e2cb19a537396c1f668a348c7d8f...1b1aada464948af03b950897e5eb522f92603cc2)

---
updated-dependencies:
- dependency-name: github/codeql-action
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`c0b97e1`](https://github.com/OZI-Project/OZI/commit/c0b97e1cc1c2c4661ae740eab3fbef1ff9a21dc7))

### :bug:

* :bug: [e2e] Correctly suppress stderr in ozi-fix.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`2b92f76`](https://github.com/OZI-Project/OZI/commit/2b92f7603d10b66a01e0cea2483a6d1d22f57474))

## 0.0.295 (2024-03-22)

### :bug:

* :bug: [e2e] Fix license classifier validation.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`538ee1c`](https://github.com/OZI-Project/OZI/commit/538ee1c771a76599914108cbc6a5a5ba904752ae))

## 0.0.294 (2024-03-22)

### :bug:

* :bug: [e2e] fix license close matches unpacking in diagnostic.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`f04555d`](https://github.com/OZI-Project/OZI/commit/f04555dab2053a26fe0f7af6390550d1a3e6eb0c))

## 0.0.293 (2024-03-22)

### :bug:

* :bug: [e2e] fix entrypoint closematch for license.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`178f9e8`](https://github.com/OZI-Project/OZI/commit/178f9e865a89d2efc94f2ffe7e9e2e77ae74d0da))

## 0.0.292 (2024-03-21)

### :bug:

* :bug:: Fix closematch output.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`8fbb373`](https://github.com/OZI-Project/OZI/commit/8fbb373c2a4a40ff25578fcd5601ddc54dacd021))

* :bug: [e2e] Fix our new project entrypoint.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`66c2f54`](https://github.com/OZI-Project/OZI/commit/66c2f543cdd7bf0174603424404539dbbaa57500))

* :bug: [e2e] Fix our new project entrypoint. ([`1442acb`](https://github.com/OZI-Project/OZI/commit/1442acbab6d17700e7e8b5f1a857ebab92febd7d))

### :hammer:

* :hammer:: Refactor Rewriter methods.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`5080b4f`](https://github.com/OZI-Project/OZI/commit/5080b4fe5575a9bab75b6cd140f3411f63f2fb7e))

## 0.0.291 (2024-03-21)

### :bug:

* :bug: Fix validate branching in ``build_definition``.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`9cde43f`](https://github.com/OZI-Project/OZI/commit/9cde43fcdbd842283ab60cd1947968da7953c13a))

### :hammer:

* :hammer:: Bump SLSA provenance generator.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`53b590d`](https://github.com/OZI-Project/OZI/commit/53b590da5f64e3729da96503a5a3b1b7218da1a9))

* :hammer: refactor ``ozi.actions`` module

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`7d66e1f`](https://github.com/OZI-Project/OZI/commit/7d66e1feb5a1ff95aa85bed7e6328891ae23c51a))

* :hammer:: Extract a ``comment_diagnostic`` function from ``ozi.comment``.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`98f8e0f`](https://github.com/OZI-Project/OZI/commit/98f8e0fef85be409fcc7d5e1d4cc4583a8d15bd7))

* :hammer: Refactor ``ozi.fix.missing`` object names.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`cdf8d61`](https://github.com/OZI-Project/OZI/commit/cdf8d61f06ad39abe94fd4a6ce5530557a8fa856))

* :hammer: ``ozi -fix missing ...`` now walks the full build dir. Fix comment scoring tiers.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`fb96c58`](https://github.com/OZI-Project/OZI/commit/fb96c589d4b6ae485ec4ae672b97fd5b422f05d1))

### Other

* Bump actions/dependency-review-action from 4.1.3 to 4.2.3

Bumps [actions/dependency-review-action](https://github.com/actions/dependency-review-action) from 4.1.3 to 4.2.3.
- [Release notes](https://github.com/actions/dependency-review-action/releases)
- [Commits](https://github.com/actions/dependency-review-action/compare/9129d7d40b8c12c1ed0f60400d00c92d437adcce...0fa40c3c10055986a88de3baa0d6ec17c5a894b3)

---
updated-dependencies:
- dependency-name: actions/dependency-review-action
  dependency-type: direct:production
  update-type: version-update:semver-minor
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`becda60`](https://github.com/OZI-Project/OZI/commit/becda606aa2cd031a000b2a8b6e6443500d5815e))

* Update CHANGELOG.md - revert release of 0.0.291

Signed-off-by: Eden Rose, MSc &lt;rjdbcm@outlook.com&gt; ([`f1159a0`](https://github.com/OZI-Project/OZI/commit/f1159a053f7c767734046ec5c0a662d8f08d69b7))

* Update dist-workflow.yml and bump build generator.

Signed-off-by: Eden Rose, MSc &lt;rjdbcm@outlook.com&gt; ([`a75f83b`](https://github.com/OZI-Project/OZI/commit/a75f83b7308d9a577801e7a968fafc9493b1d26e))

* Fix type issues.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`3541843`](https://github.com/OZI-Project/OZI/commit/35418434df9ec78c2367ae69aa19d90da455c257))

* Bump github/codeql-action from 3.24.7 to 3.24.8

Bumps [github/codeql-action](https://github.com/github/codeql-action) from 3.24.7 to 3.24.8.
- [Release notes](https://github.com/github/codeql-action/releases)
- [Changelog](https://github.com/github/codeql-action/blob/main/CHANGELOG.md)
- [Commits](https://github.com/github/codeql-action/compare/3ab4101902695724f9365a384f86c1074d94e18c...05963f47d870e2cb19a537396c1f668a348c7d8f)

---
updated-dependencies:
- dependency-name: github/codeql-action
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`5174685`](https://github.com/OZI-Project/OZI/commit/5174685a78f7b13b08c5d91f94b929ef58c84b84))

## 0.0.290 (2024-03-17)

### :hammer:

* :hammer:: Add a comment scoring rubric to ``ozi-fix``.

Also add a TAP tests module. ([`77f5fba`](https://github.com/OZI-Project/OZI/commit/77f5fbaf1f3b4f06d929f5147e8eaf040872536e))

### Other

* use sampled_from. ([`a1f407a`](https://github.com/OZI-Project/OZI/commit/a1f407aeaac7d1508cab5ce1ead442ba1cf25fc1))

* fix lint. ([`0bf8f5a`](https://github.com/OZI-Project/OZI/commit/0bf8f5a622f7bab79f344b818aea9de874c49617))

* Fix fuzzer input. ([`42a9125`](https://github.com/OZI-Project/OZI/commit/42a9125fc213fcae07473b0a864bf1403ddd0f19))

* Fix fuzzer inputs.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`33b3a25`](https://github.com/OZI-Project/OZI/commit/33b3a2536bdbedb8f4fa1ab127ca5105aaccd2a6))

* :white_check_mark: 1s deadline for good_namespace checks.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`2f4dbf6`](https://github.com/OZI-Project/OZI/commit/2f4dbf6bd011d864edc92d1e78a3fb9b2aec1f82))

* :white_check_mark: Optimize test example size.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`90ad8e1`](https://github.com/OZI-Project/OZI/commit/90ad8e1b54975c567954e9c554adff9a126c468f))

## 0.0.289 (2024-03-14)

### :hammer:

* :hammer: refactor entrypoint for ``ozi-new``. ([`4f91ede`](https://github.com/OZI-Project/OZI/commit/4f91ede3bf07cb82e61b42881af6573a9e6983d1))

* :hammer: Extract ``ozi.new.validate`` from ``ozi.new.__main__``

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`d8d58bf`](https://github.com/OZI-Project/OZI/commit/d8d58bf16a0a8b32929562ce1010cde8431ae6c0))

* :hammer: Extract trove module from actions.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`9121ed4`](https://github.com/OZI-Project/OZI/commit/9121ed41f93e269ff439b49ed297e2104615dfe8))

* :hammer: Switch to constant metadata reference throughout the module.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`8ae282e`](https://github.com/OZI-Project/OZI/commit/8ae282ecb9b6126f8a43555e1767720af189b6a3))

### Other

* Bump github/codeql-action from 3.24.6 to 3.24.7

Bumps [github/codeql-action](https://github.com/github/codeql-action) from 3.24.6 to 3.24.7.
- [Release notes](https://github.com/github/codeql-action/releases)
- [Changelog](https://github.com/github/codeql-action/blob/main/CHANGELOG.md)
- [Commits](https://github.com/github/codeql-action/compare/8a470fddafa5cbb6266ee11b37ef4d8aae19c571...3ab4101902695724f9365a384f86c1074d94e18c)

---
updated-dependencies:
- dependency-name: github/codeql-action
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`5b49626`](https://github.com/OZI-Project/OZI/commit/5b4962671a53af8956fb559cbc4551ddb3826028))

* :rotating_light: Run black on tests.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`f482499`](https://github.com/OZI-Project/OZI/commit/f482499c9541cbd92d862109cbdefac86f9d7d08))

* :rotating_light: Clean up linter complaints in tests.

Signed-off-by: Eden Rose MSc &lt;rjdbcm@outlook.com&gt; ([`31515e6`](https://github.com/OZI-Project/OZI/commit/31515e653c3fd0381cc870884855739fb20c3495))

* :rotating_light: Clean up linter complaints in tests.

Signed-off-by: Eden Rose MSc &lt;rjdbcm@outlook.com&gt; ([`d58a76a`](https://github.com/OZI-Project/OZI/commit/d58a76aaf076cc0d1febeeb49d53bec8870652d2))

* :white_check_mark: refactor ``ozi-new`` to reduce filesystem usage during testing.

This allows removal of the suppressed HealthCheck.too_slow

Signed-off-by: Eden Rose Duff MSc &lt;rjdbcm@outlook.com&gt; ([`acf950f`](https://github.com/OZI-Project/OZI/commit/acf950fe5549477ced203651674f7866be7e7f60))

* Bump actions/checkout from 4.1.1 to 4.1.2

Bumps [actions/checkout](https://github.com/actions/checkout) from 4.1.1 to 4.1.2.
- [Release notes](https://github.com/actions/checkout/releases)
- [Changelog](https://github.com/actions/checkout/blob/main/CHANGELOG.md)
- [Commits](https://github.com/actions/checkout/compare/b4ffde65f46336ab88eb53be808477a3936bae11...9bb56186c3b09b4f86b1c65136769dd318469633)

---
updated-dependencies:
- dependency-name: actions/checkout
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`4eb056e`](https://github.com/OZI-Project/OZI/commit/4eb056eeb972c2e086089bd084134338dfc2a2fa))

* :memo: Add missing docstrings.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`6514216`](https://github.com/OZI-Project/OZI/commit/6514216aca3fe6176bcc62252daa5018890539da))

## 0.0.288 (2024-03-10)

### :hammer:

* :hammer: Refactor spec module for easier maint.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`5701985`](https://github.com/OZI-Project/OZI/commit/570198597e30a0f1580fbedf5f86edf7f2f5dd5b))

## 0.0.287 (2024-03-10)

### :hammer:

* :hammer: Cache rendering filters and metadata globals.

* :rotating_light: Render filters assigned by matching type. This makes pyright and mypy happy.

Signed-off-by: Eden Rose, MSc &lt;rjdbcm@outlook.com&gt; ([`4753bba`](https://github.com/OZI-Project/OZI/commit/4753bba898b28fb442856fcf3052086e04b8b9b5))

* :hammer: Cache rendering filters and metadata globals.

* :rotating_light: Render filters assigned by matching type. This makes pyright and mypy happy.

---------

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`0e27ae5`](https://github.com/OZI-Project/OZI/commit/0e27ae507560e8031d37ea5548003615559d9988))

* :hammer: Cache rendering filters and metadata globals.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`c5b2bc0`](https://github.com/OZI-Project/OZI/commit/c5b2bc010163429749cec086a51a0f83beb9e0bd))

### Other

* Dev merge resolve (#238) ([`8761582`](https://github.com/OZI-Project/OZI/commit/876158257331b7279aaa27ef5cea8bb4303bbf58))

* Add pragma defer

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`6a339e2`](https://github.com/OZI-Project/OZI/commit/6a339e20296d072e2982c0f284a181b60d434ce6))

* :rotating_light: Render filters assigned by matching type.

This makes pyright and mypy happy.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`01443d0`](https://github.com/OZI-Project/OZI/commit/01443d0fb4cb130ebb457749eaa0a8f7ecf843f1))

## 0.0.286 (2024-03-10)

### :hammer:

* :hammer: Rendering environment is now cached. (#234)

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`4209d18`](https://github.com/OZI-Project/OZI/commit/4209d189618c63ce1ffdcd8c17e240be0151ef3a))

* :hammer: Rendering environment is now cached.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`08c2cdb`](https://github.com/OZI-Project/OZI/commit/08c2cdb906d915987327b019199cf250e1f650f3))

## 0.0.285 (2024-03-10)

### :hammer:

* :hammer: Removed all duplicated license templates.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`fc3555f`](https://github.com/OZI-Project/OZI/commit/fc3555f20ea205c78f2927eddfb97d000bc5602e))

* :hammer:: Add a load_environment function to render module.

Also extract find_user_template into render module and document.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`3b26c34`](https://github.com/OZI-Project/OZI/commit/3b26c3445257b4d85424ce78955d29f2a712c4ff))

### Other

* fix missing license file.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`da07bf2`](https://github.com/OZI-Project/OZI/commit/da07bf2c3d375692621dc31829eb9497887cdf0d))

* Use a 15 minute test timeout

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`c7cd242`](https://github.com/OZI-Project/OZI/commit/c7cd2427b360fba6acfe37b7e70a55be700f98d3))

* Increase test timeout multiplier.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`e2a26da`](https://github.com/OZI-Project/OZI/commit/e2a26dad3cf9bed0b3448a495bcb1e7c99718696))

* :white_check_mark: Increase test_fuzz_pkg_info_extra deadline to 1000ms.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`18243d2`](https://github.com/OZI-Project/OZI/commit/18243d2d13fc87a723870e3b51d82591ab8993df))

* :white_check_mark: Added several missing licenses.

This may be the source of the flaky test timings.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`1908fb6`](https://github.com/OZI-Project/OZI/commit/1908fb680558f0fd673dc82e885f222459c1acd3))

* :memo: add docstring to filter module.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`97f8132`](https://github.com/OZI-Project/OZI/commit/97f8132f2cdcbbcc2218bf875180bee82b685562))

* Update dependency-review.yml

add head-ref arg to fix cronjob

Signed-off-by: Eden Rose, MSc &lt;rjdbcm@outlook.com&gt; ([`86c3414`](https://github.com/OZI-Project/OZI/commit/86c34149f453503937d4e9efa28d6c89891d9464))

## 0.0.284 (2024-03-08)

### :hammer:

* :hammer: Move Rewriter and RewriteCommand to ozi.fix.rewrite_command

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`f4f528f`](https://github.com/OZI-Project/OZI/commit/f4f528f8e23a3d46b466be15401f3ddaf03d5295))

* :hammer: Rename ozi.meson:query_var_suffix to find_var_suffix

Also reduces the argument number to 2: The AST, and the suffix.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`06d43e5`](https://github.com/OZI-Project/OZI/commit/06d43e558543ca4555ad4e6066c7ac62f6b9941b))

## 0.0.283 (2024-03-08)

### :hammer:

* :hammer: Force release commit re-parse

Add ozi/comment.py module.

Signed-off-by: Eden Rose, MSc &lt;rjdbcm@outlook.com&gt; ([`a18121a`](https://github.com/OZI-Project/OZI/commit/a18121abb4ffda9b484257c08b770f374b2fb094))

* :hammer: add ozi/comment.py

This module handles linter comment diagnostics.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`7da2167`](https://github.com/OZI-Project/OZI/commit/7da21677b13a85a696dbcfef91ae445551467f02))

### Other

* Dev merge (#221) (#222)

* :hammer: Add render_requirements.py script.

This strips comments from requirements.in



* Escape quotes in meson.build template.



* :hammer: add ozi/comment.py

This module handles linter comment diagnostics.



---------

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`87a2360`](https://github.com/OZI-Project/OZI/commit/87a23607a6514c83459dfb5c4fd68e20cad520dd))

* Dev merge (#221)

* :hammer: Add render_requirements.py script.

This strips comments from requirements.in

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt;

* Escape quotes in meson.build template.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt;

* :hammer: add ozi/comment.py

This module handles linter comment diagnostics.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt;

---------

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`5235c33`](https://github.com/OZI-Project/OZI/commit/5235c33496380fbc1c70fd681fb1f57c9742e9b8))

## 0.0.282 (2024-03-07)

### :hammer:

* * :hammer: Add render_requirements.py script.

* :hammer: Add render_requirements.py script.

This strips comments from requirements.in

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`9b187e3`](https://github.com/OZI-Project/OZI/commit/9b187e3601014347bcc5999001f1f9f769b6826d))

* :hammer: Add render_requirements.py script.

This strips comments from requirements.in

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`09e3fb9`](https://github.com/OZI-Project/OZI/commit/09e3fb93860a4fdd68c8d6ffb06ac42a4afcff66))

* :hammer:: Escape comment characters for CodeQL

Signed-off-by: rjdcm &lt;rjdbcm@mail.umkc.edu&gt; ([`fb2ab5a`](https://github.com/OZI-Project/OZI/commit/fb2ab5a7238568bd72b1b10378916705b1e30f80))

### Other

* Escape quotes in meson.build template.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`4ffb8b5`](https://github.com/OZI-Project/OZI/commit/4ffb8b52edb4c3ba81c96fb10477e9da770966af))

## 0.0.281 (2024-03-06)

### :alembic:

* :alembic: Increase deadline for ``ozi-new`` fuzzer to 15s.

Signed-off-by:  rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`1813073`](https://github.com/OZI-Project/OZI/commit/1813073353fa82f2a893031288fd2adfa3258b43))

### :hammer:

* :hammer:(ozi.fix.missing): update ``render_requirements()``

Strip line end comments.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.ukmc.edu&gt; ([`34cd4b5`](https://github.com/OZI-Project/OZI/commit/34cd4b57b59b6dd042cec4e1a16c74ca98e684da))

* :hammer:(ozi-fix) Refactor

Extract pkg_extra, fix.build_definition, and fix.missing

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`278e1bf`](https://github.com/OZI-Project/OZI/commit/278e1bf466240041e548e8a5d94121ef5767a306))

## 0.0.280 (2024-03-03)

### :hammer:

* :hammer:(ozi-fix): Extract ``process_build_definition`` from ``walk_build_definition``.

This should make the whole unit more maintainable.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`822dc7f`](https://github.com/OZI-Project/OZI/commit/822dc7f5375f20571464c86172a2e1501f34c514))

* :hammer: Add warning for deprecated nodejs.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`ab35f02`](https://github.com/OZI-Project/OZI/commit/ab35f023fa6b03607ffa25225e78b84648a4601f))

## 0.0.279 (2024-03-03)

### :pushpin:

* :pushpin: Add a check of node.js version for pyright. (#208)

* pins pyright to &gt;=1.1.352, the version that pinned node &gt;12

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`bf776f2`](https://github.com/OZI-Project/OZI/commit/bf776f2a53c28d672259d099ce9a9b60ea467d93))

* :pushpin: Add a check of node.js version for pyright.

* pins pyright to &gt;=1.1.352, the version that pinned node &gt;12

Signed-off-by: rjdbcm &lt;rjdbcm@outlook.com&gt; ([`e4da4ba`](https://github.com/OZI-Project/OZI/commit/e4da4bae7d7fb3792915fb2b556c1aa0774a60b9))

## 0.0.278 (2024-03-02)

### :arrow_up:

* :arrow_up: Bump github/codeql-action from 3.24.5 to 3.24.6

Bumps [github/codeql-action](https://github.com/github/codeql-action) from 3.24.5 to 3.24.6.
- [Release notes](https://github.com/github/codeql-action/releases)
- [Changelog](https://github.com/github/codeql-action/blob/main/CHANGELOG.md)
- [Commits](https://github.com/github/codeql-action/compare/47b3d888fe66b639e431abf22ebca059152f1eea...8a470fddafa5cbb6266ee11b37ef4d8aae19c571)

---
updated-dependencies:
- dependency-name: github/codeql-action
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`50ffecf`](https://github.com/OZI-Project/OZI/commit/50ffecfcc502300271d7e242931d6eaefad91282))

### :hammer:

* :hammer: Add pep-723 metadata.

Signed-off-by: Eden Rose Duff MSc &lt;help@oziproject.dev&gt; ([`962f91b`](https://github.com/OZI-Project/OZI/commit/962f91b7da73d076d6a858b672a7d8fc14003729))

### :pencil2:

* :pencil2: Shorten PEP-723 metadata.

This requires less ``# noqa: E800`` additions.

Signed-off-by: Eden Rose Duff MSc &lt;help@oziproject.dev&gt; ([`2dab3b3`](https://github.com/OZI-Project/OZI/commit/2dab3b3b716d9b3fe5da3100d0a5b1ed10e27ddf))

* :pencil2: Fix docstring whitespace.

Signed-off-by: Eden Rose Duff MSc &lt;help@oziproject.dev&gt; ([`60e227a`](https://github.com/OZI-Project/OZI/commit/60e227a538dacdac3bb2e3a8f3e83ff86eb5d1a7))

* :pencil2::memo: Fix line continuation.

Signed-off-by: Eden Rose Duff MSc &lt;help@oziproject.dev&gt; ([`5e77cfa`](https://github.com/OZI-Project/OZI/commit/5e77cfafd3c0c03be61c0731c5fd43a7f653dac4))

### Other

* :rotating_light: Fix trailing whitespace.

Signed-off-by: Eden Rose Duff &lt;rjdbcm@outlook.com&gt; ([`2a73a02`](https://github.com/OZI-Project/OZI/commit/2a73a021267246a4f35e4bd4cebafd6508073615))

* :memo: Finish adding script docstrings.

Signed-off-by: Eden Rose Duff MSc &lt;help@oziproject.dev&gt; ([`acbeeda`](https://github.com/OZI-Project/OZI/commit/acbeedaeba847f1109bfebd37675eac217fe6b90))

* :memo: Update __author__ name.

Signed-off-by: Eden Rose Duff MSc &lt;help@oziproject.dev&gt; ([`39687fb`](https://github.com/OZI-Project/OZI/commit/39687fb0ad02acffb7c942e3151f6b602e26901a))

* :memo: Add spdx module docstring.

Signed-off-by: Eden Rose Duff MSc &lt;help@oziproject.dev&gt; ([`ffe26b4`](https://github.com/OZI-Project/OZI/commit/ffe26b492c5893bd88e8c6fb7f9de618222b1cdb))

* :memo: Add render module docstrings.

Signed-off-by: Eden Rose Duff MSc &lt;help@oziproject.dev&gt; ([`7b47d52`](https://github.com/OZI-Project/OZI/commit/7b47d5244897bcaba6fd19130af7e0635ff15e61))

* :memo: Document actions module.

Signed-off-by: Eden Rose Duff MSc &lt;help@oziproject.dev&gt; ([`f33118f`](https://github.com/OZI-Project/OZI/commit/f33118f788d90ba3e68df9caac8618cf4270f2cf))

* :memo: Add variable args to docstrings.

Signed-off-by: Eden Rose Duff MSc &lt;help@oziproject.dev&gt; ([`a5171bd`](https://github.com/OZI-Project/OZI/commit/a5171bdba35220c58c343d2d38b751199a9bb12d))

## 0.0.277 (2024-02-29)

### :hammer:

* :hammer: Add script guard to scripts in ``ozi/scripts``.

Signed-off-by: Eden Rose Duff MSc ([`55ababf`](https://github.com/OZI-Project/OZI/commit/55ababf49578b6c366942f291dcef8543794c6a8))

* :hammer: Update script PEP-723 metadata.

Signed-off-by: Eden Rose Duff MSc ([`550eded`](https://github.com/OZI-Project/OZI/commit/550eded08a6fb98279a96cfb16fb835b6f4d7a57))

### :pencil2:

* :pencil2::memo: Fix docstring whitespace; cleanup defs.

Signed-off-by: Eden Rose Duff MSc ([`ef2b469`](https://github.com/OZI-Project/OZI/commit/ef2b4692f7c9f33eb2bc9f6ff1af09c494d5ee31))

## 0.0.276 (2024-02-28)

### :bug:

* :bug::hammer:(ozi-new): Fix call order.

author email checks before maintainer email.

Signed-off-by: Eden Rose Duff MSc ([`f005dd9`](https://github.com/OZI-Project/OZI/commit/f005dd900285073981a53b52df0a61b092871b54))

### :hammer:

* :hammer::rotating_light: Embed ``noqa: E800`` comments in PEP-723 embedded metadata.

Signed-off-by: Eden Rose Duff MSc ([`cb8ef11`](https://github.com/OZI-Project/OZI/commit/cb8ef11e916b40446391aad7141e35f997b816ed))

* :hammer::rotating_light: Embed ``noqa: E800`` comments in PEP-723 embedded metadata. ([`0dc540e`](https://github.com/OZI-Project/OZI/commit/0dc540e500da7b1acc793821fad39b892ef94862))

### Other

* :rotating_light: Add no cover comment to query_simple.

Signed-off-by: Eden Rose Duff MSc ([`7da7fff`](https://github.com/OZI-Project/OZI/commit/7da7fff43017da8fd692010b1c9d0f1e310d07b7))

* :memo: Update script documentation.

Signed-off-by: Eden Rose Duff MSc ([`01c9243`](https://github.com/OZI-Project/OZI/commit/01c924339c3dec58eedc9cb537ee0f2d9d7cd413))

* :memo: Finish documenting the TAP module.

Signed-off-by: Eden Rose Duff MSc ([`38599b6`](https://github.com/OZI-Project/OZI/commit/38599b6db6ee378ecd9edd57fc104bed2844e602))

* :memo: Document meson module objects.

Signed-off-by: Eden Rose Duff MSc ([`a285f90`](https://github.com/OZI-Project/OZI/commit/a285f906df1a5fda22bfa89eea9730d9d9458599))

* :memo: Update docstrings for filters. ([`4cd54a6`](https://github.com/OZI-Project/OZI/commit/4cd54a6a881954c3eda66eb2fc059f07706cc122))

## 0.0.275 (2024-02-25)

### :pencil2:

* Revert &#34;:pencil2::memo: Fix note admonitions in TAP module.&#34;

This reverts commit 2071ef108280c77461d707d990db64087b79ed40. ([`85fc874`](https://github.com/OZI-Project/OZI/commit/85fc87486349c599c62e49c6b98c1430f919d435))

* :pencil2::memo: Fix note admonitions in TAP module.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`2071ef1`](https://github.com/OZI-Project/OZI/commit/2071ef108280c77461d707d990db64087b79ed40))

* :pencil2::memo: Fix note admonitions in TAP module.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`ebbe334`](https://github.com/OZI-Project/OZI/commit/ebbe334168bb38c6e85d06324dee865e333c2f6e))

### :pushpin:

* Revert &#34;:pushpin: Bump github/codeql-action from 3.24.0 to 3.24.3&#34;

This reverts commit 73d8025a8d11f7ce1a94b2d1cc07254258a86250. ([`ec637ea`](https://github.com/OZI-Project/OZI/commit/ec637ea8a741a74526bfae0ff1586a3e54267718))

* Revert &#34;:pushpin: Bump actions/dependency-review-action from 4.0.0 to 4.1.1&#34;

This reverts commit 72ed4c885eadd2105e9499a8aab6a0871ed688e0. ([`3e2be10`](https://github.com/OZI-Project/OZI/commit/3e2be1049b7f4a4143a1a7d3a38f6149cb6b16e9))

* Revert &#34;:pushpin: Bump github/codeql-action from 3.24.3 to 3.24.4&#34;

This reverts commit 670616c134c130c7fb157674b9abdfec7478f4d8. ([`32e2605`](https://github.com/OZI-Project/OZI/commit/32e2605d7c597df3f06b9dc3bd04b8fe4239894c))

* Revert &#34;:pushpin: Bump github/codeql-action from 3.24.4 to 3.24.5&#34;

This reverts commit 03c60761546ddfbbcc3ef690d9709138c81395e5. ([`67b17ab`](https://github.com/OZI-Project/OZI/commit/67b17ab8f49372225f949c7735e0550855d65af4))

* Revert &#34;:pushpin: Bump actions/dependency-review-action from 4.1.1 to 4.1.3&#34;

This reverts commit 5b2f33c67af4d2dac5b8044656ffd86053e3da8f. ([`3922a7b`](https://github.com/OZI-Project/OZI/commit/3922a7bf86be0ca9286730ddf196658d183c2c29))

* :pushpin: Bump actions/dependency-review-action from 4.1.1 to 4.1.3

Bumps [actions/dependency-review-action](https://github.com/actions/dependency-review-action) from 4.1.1 to 4.1.3.
- [Release notes](https://github.com/actions/dependency-review-action/releases)
- [Commits](https://github.com/actions/dependency-review-action/compare/fd07d42ce87ab09f10c61a2d1a5e59e6c655620a...9129d7d40b8c12c1ed0f60400d00c92d437adcce)

---
updated-dependencies:
- dependency-name: actions/dependency-review-action
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`5b2f33c`](https://github.com/OZI-Project/OZI/commit/5b2f33c67af4d2dac5b8044656ffd86053e3da8f))

* :pushpin: Bump github/codeql-action from 3.24.4 to 3.24.5

Bumps [github/codeql-action](https://github.com/github/codeql-action) from 3.24.4 to 3.24.5.
- [Release notes](https://github.com/github/codeql-action/releases)
- [Changelog](https://github.com/github/codeql-action/blob/main/CHANGELOG.md)
- [Commits](https://github.com/github/codeql-action/compare/e2e140ad1441662206e8f97754b166877dfa1c73...47b3d888fe66b639e431abf22ebca059152f1eea)

---
updated-dependencies:
- dependency-name: github/codeql-action
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`03c6076`](https://github.com/OZI-Project/OZI/commit/03c60761546ddfbbcc3ef690d9709138c81395e5))

* :pushpin: Bump github/codeql-action from 3.24.3 to 3.24.4

Bumps [github/codeql-action](https://github.com/github/codeql-action) from 3.24.3 to 3.24.4.
- [Release notes](https://github.com/github/codeql-action/releases)
- [Changelog](https://github.com/github/codeql-action/blob/main/CHANGELOG.md)
- [Commits](https://github.com/github/codeql-action/compare/379614612a29c9e28f31f39a59013eb8012a51f0...e2e140ad1441662206e8f97754b166877dfa1c73)

---
updated-dependencies:
- dependency-name: github/codeql-action
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`670616c`](https://github.com/OZI-Project/OZI/commit/670616c134c130c7fb157674b9abdfec7478f4d8))

* :pushpin: Bump actions/dependency-review-action from 4.0.0 to 4.1.1

Bumps [actions/dependency-review-action](https://github.com/actions/dependency-review-action) from 4.0.0 to 4.1.1.
- [Release notes](https://github.com/actions/dependency-review-action/releases)
- [Commits](https://github.com/actions/dependency-review-action/compare/4901385134134e04cec5fbe5ddfe3b2c5bd5d976...fd07d42ce87ab09f10c61a2d1a5e59e6c655620a)

---
updated-dependencies:
- dependency-name: actions/dependency-review-action
  dependency-type: direct:production
  update-type: version-update:semver-minor
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`72ed4c8`](https://github.com/OZI-Project/OZI/commit/72ed4c885eadd2105e9499a8aab6a0871ed688e0))

* :pushpin: Bump github/codeql-action from 3.24.0 to 3.24.3

Bumps [github/codeql-action](https://github.com/github/codeql-action) from 3.24.0 to 3.24.3.
- [Release notes](https://github.com/github/codeql-action/releases)
- [Changelog](https://github.com/github/codeql-action/blob/main/CHANGELOG.md)
- [Commits](https://github.com/github/codeql-action/compare/e8893c57a1f3a2b659b6b55564fdfdbbd2982911...379614612a29c9e28f31f39a59013eb8012a51f0)

---
updated-dependencies:
- dependency-name: github/codeql-action
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`73d8025`](https://github.com/OZI-Project/OZI/commit/73d8025a8d11f7ce1a94b2d1cc07254258a86250))

* :pushpin: Bump actions/dependency-review-action from 4.1.1 to 4.1.3

Bumps [actions/dependency-review-action](https://github.com/actions/dependency-review-action) from 4.1.1 to 4.1.3.
- [Release notes](https://github.com/actions/dependency-review-action/releases)
- [Commits](https://github.com/actions/dependency-review-action/compare/fd07d42ce87ab09f10c61a2d1a5e59e6c655620a...9129d7d40b8c12c1ed0f60400d00c92d437adcce)

---
updated-dependencies:
- dependency-name: actions/dependency-review-action
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`b938174`](https://github.com/OZI-Project/OZI/commit/b938174e2d22f9a2f536be661761b76c14e9a12f))

* :pushpin: Bump github/codeql-action from 3.24.4 to 3.24.5

Bumps [github/codeql-action](https://github.com/github/codeql-action) from 3.24.4 to 3.24.5.
- [Release notes](https://github.com/github/codeql-action/releases)
- [Changelog](https://github.com/github/codeql-action/blob/main/CHANGELOG.md)
- [Commits](https://github.com/github/codeql-action/compare/e2e140ad1441662206e8f97754b166877dfa1c73...47b3d888fe66b639e431abf22ebca059152f1eea)

---
updated-dependencies:
- dependency-name: github/codeql-action
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`02c5c63`](https://github.com/OZI-Project/OZI/commit/02c5c63a4ede004260c1b4bd42d526a530f03755))

* :pushpin: Bump github/codeql-action from 3.24.3 to 3.24.4

Bumps [github/codeql-action](https://github.com/github/codeql-action) from 3.24.3 to 3.24.4.
- [Release notes](https://github.com/github/codeql-action/releases)
- [Changelog](https://github.com/github/codeql-action/blob/main/CHANGELOG.md)
- [Commits](https://github.com/github/codeql-action/compare/379614612a29c9e28f31f39a59013eb8012a51f0...e2e140ad1441662206e8f97754b166877dfa1c73)

---
updated-dependencies:
- dependency-name: github/codeql-action
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`5b30aa6`](https://github.com/OZI-Project/OZI/commit/5b30aa60196175e7ea136535f0cd55d3701c8b8d))

* :pushpin: Bump actions/dependency-review-action from 4.0.0 to 4.1.1

Bumps [actions/dependency-review-action](https://github.com/actions/dependency-review-action) from 4.0.0 to 4.1.1.
- [Release notes](https://github.com/actions/dependency-review-action/releases)
- [Commits](https://github.com/actions/dependency-review-action/compare/4901385134134e04cec5fbe5ddfe3b2c5bd5d976...fd07d42ce87ab09f10c61a2d1a5e59e6c655620a)

---
updated-dependencies:
- dependency-name: actions/dependency-review-action
  dependency-type: direct:production
  update-type: version-update:semver-minor
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`d3ca174`](https://github.com/OZI-Project/OZI/commit/d3ca17449e2cc02c4e348a25399e6d8f1a43523a))

* :pushpin: Bump github/codeql-action from 3.24.0 to 3.24.3

Bumps [github/codeql-action](https://github.com/github/codeql-action) from 3.24.0 to 3.24.3.
- [Release notes](https://github.com/github/codeql-action/releases)
- [Changelog](https://github.com/github/codeql-action/blob/main/CHANGELOG.md)
- [Commits](https://github.com/github/codeql-action/compare/e8893c57a1f3a2b659b6b55564fdfdbbd2982911...379614612a29c9e28f31f39a59013eb8012a51f0)

---
updated-dependencies:
- dependency-name: github/codeql-action
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`6b31cec`](https://github.com/OZI-Project/OZI/commit/6b31cec6d324f0f31be3c40fb82740353bcb325f))

### Other

* Revert &#34;:rotating_light: run black.&#34;

This reverts commit fa7cb34a774934c63bc54a384185b39ef468db04. ([`8840595`](https://github.com/OZI-Project/OZI/commit/88405954530a91bbcdcb6fbc6fdc9f7f2c22eea7))

* Revert &#34;Update dependabot.yml remove pushpin prefix.&#34;

This reverts commit 5d480ad9f7ed734b8ed2fef3c3a677d35133052f. ([`136f198`](https://github.com/OZI-Project/OZI/commit/136f19852102425250d90119090b65e353b8a928))

* Update dependabot.yml remove pushpin prefix.

We manually manage actual dependency pins.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`5d480ad`](https://github.com/OZI-Project/OZI/commit/5d480ad9f7ed734b8ed2fef3c3a677d35133052f))

* :rotating_light: run black. ([`fa7cb34`](https://github.com/OZI-Project/OZI/commit/fa7cb34a774934c63bc54a384185b39ef468db04))

* Update dependabot.yml remove pushpin prefix.

We manually manage actual dependency pins.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`e85e0f3`](https://github.com/OZI-Project/OZI/commit/e85e0f35327c09a5b47c48ddd0207f2f7752763a))

* :rotating_light: run black. ([`a8981da`](https://github.com/OZI-Project/OZI/commit/a8981da6f27052641e8b8e90aceeadc8e10da45c))

## 0.0.274 (2024-02-13)

### :lock:

* :lock: Update SECURITY.md (#171)

add @lowlighter/metrics@65836723097537a54cd8eb90f61839426b4266b6 ([`60b1283`](https://github.com/OZI-Project/OZI/commit/60b1283212e9d070055dce2d175f9c03be134edf))

* :lock: Update SECURITY.md

add @lowlighter/metrics@65836723097537a54cd8eb90f61839426b4266b6

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`f863f32`](https://github.com/OZI-Project/OZI/commit/f863f3246e9edd092d0c76cf25a69b0794e8110e))

### :pencil2:

* :memo::pencil2: Update README.rst logo ref

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`22da779`](https://github.com/OZI-Project/OZI/commit/22da779551ba02a19b695c6c881c39aeefb1446d))

* :pencil2: Remove dnspython pin.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`4d1a4ae`](https://github.com/OZI-Project/OZI/commit/4d1a4ae7b7b4c72381441cbf87f32f58e44b1387))

### :pushpin:

* :pushpin: Set requirements pins

Set minimum/compatible pins for idna, jinja2, dnspython, GitPython, and pyparsing.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`494f176`](https://github.com/OZI-Project/OZI/commit/494f1767bd18002dff3d9c143fb146f7bfad80fa))

* :pushpin: Bump actions/upload-artifact from 4.3.0 to 4.3.1 (#175)

Bumps
[actions/upload-artifact](https://github.com/actions/upload-artifact)
from 4.3.0 to 4.3.1.
&lt;details&gt;
&lt;summary&gt;Release notes&lt;/summary&gt;
&lt;p&gt;&lt;em&gt;Sourced from &lt;a
href=&#34;https://github.com/actions/upload-artifact/releases&#34;&gt;actions/upload-artifact&#39;s
releases&lt;/a&gt;.&lt;/em&gt;&lt;/p&gt;
&lt;blockquote&gt;
&lt;h2&gt;v4.3.1&lt;/h2&gt;
&lt;ul&gt;
&lt;li&gt;Bump &lt;code&gt;@​actions/artifacts&lt;/code&gt; to latest version to include
&lt;a href=&#34;https://redirect.github.com/actions/toolkit/pull/1648&#34;&gt;updated
GHES host check&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;/blockquote&gt;
&lt;/details&gt;
&lt;details&gt;
&lt;summary&gt;Commits&lt;/summary&gt;
&lt;ul&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/actions/upload-artifact/commit/5d5d22a31266ced268874388b861e4b58bb5c2f3&#34;&gt;&lt;code&gt;5d5d22a&lt;/code&gt;&lt;/a&gt;
Merge pull request &lt;a
href=&#34;https://redirect.github.com/actions/upload-artifact/issues/515&#34;&gt;#515&lt;/a&gt;
from actions/eggyhead/update-artifact-v2.1.1&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/actions/upload-artifact/commit/f1e993d9663a03508e7fc0370c744c4b963f0044&#34;&gt;&lt;code&gt;f1e993d&lt;/code&gt;&lt;/a&gt;
update artifact license&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/actions/upload-artifact/commit/4881bfd3f27855c63733d8cfff17721cc0ad611f&#34;&gt;&lt;code&gt;4881bfd&lt;/code&gt;&lt;/a&gt;
updating dist:&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/actions/upload-artifact/commit/a30777e2653648a0a7bbd3efb5c96ef9131b96cc&#34;&gt;&lt;code&gt;a30777e&lt;/code&gt;&lt;/a&gt;
&lt;a href=&#34;https://github.com/eggyhead&#34;&gt;&lt;code&gt;@​eggyhead&lt;/code&gt;&lt;/a&gt;&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/actions/upload-artifact/commit/3a8048248f2f288c271830f8ecf2a1c5d8eb0e9a&#34;&gt;&lt;code&gt;3a80482&lt;/code&gt;&lt;/a&gt;
Merge pull request &lt;a
href=&#34;https://redirect.github.com/actions/upload-artifact/issues/511&#34;&gt;#511&lt;/a&gt;
from actions/robherley/migration-docs-typo&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/actions/upload-artifact/commit/9d63e3f2f81d9dc4e13d83fc330408f8a94b79d1&#34;&gt;&lt;code&gt;9d63e3f&lt;/code&gt;&lt;/a&gt;
Merge branch &#39;main&#39; into robherley/migration-docs-typo&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/actions/upload-artifact/commit/dfa1ab292d2fdd78d056187f11c568c16ab53de9&#34;&gt;&lt;code&gt;dfa1ab2&lt;/code&gt;&lt;/a&gt;
fix typo with v3 artifact downloads in migration guide&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/actions/upload-artifact/commit/d00351bf698398c17253d21cf8f90e57a344e14b&#34;&gt;&lt;code&gt;d00351b&lt;/code&gt;&lt;/a&gt;
Merge pull request &lt;a
href=&#34;https://redirect.github.com/actions/upload-artifact/issues/509&#34;&gt;#509&lt;/a&gt;
from markmssd/patch-1&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/actions/upload-artifact/commit/707f5a7b71e0fb01c5df1e16e9679a3292606ef2&#34;&gt;&lt;code&gt;707f5a7&lt;/code&gt;&lt;/a&gt;
Update limitation of &lt;code&gt;10&lt;/code&gt; artifacts upload to
&lt;code&gt;500&lt;/code&gt;&lt;/li&gt;
&lt;li&gt;See full diff in &lt;a
href=&#34;https://github.com/actions/upload-artifact/compare/26f96dfa697d77e81fd5907df203aa23a56210a8...5d5d22a31266ced268874388b861e4b58bb5c2f3&#34;&gt;compare
view&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;/details&gt;
&lt;br /&gt;


[![Dependabot compatibility
score](https://dependabot-badges.githubapp.com/badges/compatibility_score?dependency-name=actions/upload-artifact&amp;package-manager=github_actions&amp;previous-version=4.3.0&amp;new-version=4.3.1)](https://docs.github.com/en/github/managing-security-vulnerabilities/about-dependabot-security-updates#about-compatibility-scores)

Dependabot will resolve any conflicts with this PR as long as you don&#39;t
alter it yourself. You can also trigger a rebase manually by commenting
`@dependabot rebase`.

[//]: # (dependabot-automerge-start)
[//]: # (dependabot-automerge-end)

---

&lt;details&gt;
&lt;summary&gt;Dependabot commands and options&lt;/summary&gt;
&lt;br /&gt;

You can trigger Dependabot actions by commenting on this PR:
- `@dependabot rebase` will rebase this PR
- `@dependabot recreate` will recreate this PR, overwriting any edits
that have been made to it
- `@dependabot merge` will merge this PR after your CI passes on it
- `@dependabot squash and merge` will squash and merge this PR after
your CI passes on it
- `@dependabot cancel merge` will cancel a previously requested merge
and block automerging
- `@dependabot reopen` will reopen this PR if it is closed
- `@dependabot close` will close this PR and stop Dependabot recreating
it. You can achieve the same result by closing it manually
- `@dependabot show &lt;dependency name&gt; ignore conditions` will show all
of the ignore conditions of the specified dependency
- `@dependabot ignore this major version` will close this PR and stop
Dependabot creating any more for this major version (unless you reopen
the PR or upgrade to it yourself)
- `@dependabot ignore this minor version` will close this PR and stop
Dependabot creating any more for this minor version (unless you reopen
the PR or upgrade to it yourself)
- `@dependabot ignore this dependency` will close this PR and stop
Dependabot creating any more for this dependency (unless you reopen the
PR or upgrade to it yourself)


&lt;/details&gt; ([`eae4922`](https://github.com/OZI-Project/OZI/commit/eae4922951cc20ff4498f6a1afb28074bbed7e7b))

* :pushpin: Bump actions/upload-artifact from 4.3.0 to 4.3.1

Bumps [actions/upload-artifact](https://github.com/actions/upload-artifact) from 4.3.0 to 4.3.1.
- [Release notes](https://github.com/actions/upload-artifact/releases)
- [Commits](https://github.com/actions/upload-artifact/compare/26f96dfa697d77e81fd5907df203aa23a56210a8...5d5d22a31266ced268874388b861e4b58bb5c2f3)

---
updated-dependencies:
- dependency-name: actions/upload-artifact
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`5130279`](https://github.com/OZI-Project/OZI/commit/513027952c25e69e46998dc4210aa4923c01a485))

* :pushpin: Bump github/codeql-action from 3.23.2 to 3.24.0

Bumps [github/codeql-action](https://github.com/github/codeql-action) from 3.23.2 to 3.24.0.
- [Release notes](https://github.com/github/codeql-action/releases)
- [Changelog](https://github.com/github/codeql-action/blob/main/CHANGELOG.md)
- [Commits](https://github.com/github/codeql-action/compare/b7bf0a3ed3ecfa44160715d7c442788f65f0f923...e8893c57a1f3a2b659b6b55564fdfdbbd2982911)

---
updated-dependencies:
- dependency-name: github/codeql-action
  dependency-type: direct:production
  update-type: version-update:semver-minor
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`c8886c3`](https://github.com/OZI-Project/OZI/commit/c8886c3db7e9ba49cad14a23b7c1f70dc43661d2))

### Other

* Update dependency-review.yml

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`f9359cd`](https://github.com/OZI-Project/OZI/commit/f9359cd1c24ad84e7fef05c97717467faf0ef586))

* Update dependency-review.yml

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`b273df2`](https://github.com/OZI-Project/OZI/commit/b273df246dc5a7c34ee7e4055db3a880893646a2))

* Update dependency-review.yml

Run check daily on a cron.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`4805b25`](https://github.com/OZI-Project/OZI/commit/4805b2576945d5c4435b88d5b4b92e2c4b4e1ab8))

* Bump github/codeql-action from 3.23.2 to 3.24.0 (#172)

Bumps [github/codeql-action](https://github.com/github/codeql-action)
from 3.23.2 to 3.24.0.
&lt;details&gt;
&lt;summary&gt;Changelog&lt;/summary&gt;
&lt;p&gt;&lt;em&gt;Sourced from &lt;a
href=&#34;https://github.com/github/codeql-action/blob/main/CHANGELOG.md&#34;&gt;github/codeql-action&#39;s
changelog&lt;/a&gt;.&lt;/em&gt;&lt;/p&gt;
&lt;blockquote&gt;
&lt;h1&gt;CodeQL Action Changelog&lt;/h1&gt;
&lt;p&gt;See the &lt;a
href=&#34;https://github.com/github/codeql-action/releases&#34;&gt;releases
page&lt;/a&gt; for the relevant changes to the CodeQL CLI and language
packs.&lt;/p&gt;
&lt;p&gt;Note that the only difference between &lt;code&gt;v2&lt;/code&gt; and
&lt;code&gt;v3&lt;/code&gt; of the CodeQL Action is the node version they support,
with &lt;code&gt;v3&lt;/code&gt; running on node 20 while we continue to release
&lt;code&gt;v2&lt;/code&gt; to support running on node 16. For example
&lt;code&gt;3.22.11&lt;/code&gt; was the first &lt;code&gt;v3&lt;/code&gt; release and is
functionally identical to &lt;code&gt;2.22.11&lt;/code&gt;. This approach ensures an
easy way to track exactly which features are included in different
versions, indicated by the minor and patch version numbers.&lt;/p&gt;
&lt;h2&gt;[UNRELEASED]&lt;/h2&gt;
&lt;p&gt;No user facing changes.&lt;/p&gt;
&lt;h2&gt;3.24.0 - 02 Feb 2024&lt;/h2&gt;
&lt;ul&gt;
&lt;li&gt;CodeQL Python analysis will no longer install dependencies on GitHub
Enterprise Server, as is already the case for GitHub.com. See &lt;a
href=&#34;https://github.com/github/codeql-action/blob/main/#3230---08-jan-2024&#34;&gt;release
notes for 3.23.0&lt;/a&gt; for more details. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2106&#34;&gt;#2106&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;h2&gt;3.23.2 - 26 Jan 2024&lt;/h2&gt;
&lt;ul&gt;
&lt;li&gt;On Linux, the maximum possible value for the &lt;code&gt;--threads&lt;/code&gt;
option now respects the CPU count as specified in &lt;code&gt;cgroup&lt;/code&gt;
files to more accurately reflect the number of available cores when
running in containers. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2083&#34;&gt;#2083&lt;/a&gt;&lt;/li&gt;
&lt;li&gt;Update default CodeQL bundle version to 2.16.1. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2096&#34;&gt;#2096&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;h2&gt;3.23.1 - 17 Jan 2024&lt;/h2&gt;
&lt;ul&gt;
&lt;li&gt;Update default CodeQL bundle version to 2.16.0. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2073&#34;&gt;#2073&lt;/a&gt;&lt;/li&gt;
&lt;li&gt;Change the retention period for uploaded debug artifacts to 7 days.
Previously, this was whatever the repository default was. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2079&#34;&gt;#2079&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;h2&gt;3.23.0 - 08 Jan 2024&lt;/h2&gt;
&lt;ul&gt;
&lt;li&gt;We are rolling out a feature in January 2024 that will disable
Python dependency installation by default for all users. This improves
the speed of analysis while having only a very minor impact on results.
You can override this behavior by setting
&lt;code&gt;CODEQL_ACTION_DISABLE_PYTHON_DEPENDENCY_INSTALLATION=false&lt;/code&gt;
in your workflow, however we plan to remove this ability in future
versions of the CodeQL Action. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2031&#34;&gt;#2031&lt;/a&gt;&lt;/li&gt;
&lt;li&gt;The CodeQL Action now requires CodeQL version 2.11.6 or later. For
more information, see &lt;a
href=&#34;https://github.com/github/codeql-action/blob/main/#2227---16-nov-2023&#34;&gt;the
corresponding changelog entry for CodeQL Action version 2.22.7&lt;/a&gt;. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2009&#34;&gt;#2009&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;h2&gt;3.22.12 - 22 Dec 2023&lt;/h2&gt;
&lt;ul&gt;
&lt;li&gt;Update default CodeQL bundle version to 2.15.5. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2047&#34;&gt;#2047&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;h2&gt;3.22.11 - 13 Dec 2023&lt;/h2&gt;
&lt;ul&gt;
&lt;li&gt;[v3+ only] The CodeQL Action now runs on Node.js v20. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2006&#34;&gt;#2006&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;h2&gt;2.22.10 - 12 Dec 2023&lt;/h2&gt;
&lt;ul&gt;
&lt;li&gt;Update default CodeQL bundle version to 2.15.4. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2016&#34;&gt;#2016&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;h2&gt;2.22.9 - 07 Dec 2023&lt;/h2&gt;
&lt;p&gt;No user facing changes.&lt;/p&gt;
&lt;h2&gt;2.22.8 - 23 Nov 2023&lt;/h2&gt;
&lt;ul&gt;
&lt;li&gt;Update default CodeQL bundle version to 2.15.3. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2001&#34;&gt;#2001&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;h2&gt;2.22.7 - 16 Nov 2023&lt;/h2&gt;
&lt;!-- raw HTML omitted --&gt;
&lt;/blockquote&gt;
&lt;p&gt;... (truncated)&lt;/p&gt;
&lt;/details&gt;
&lt;details&gt;
&lt;summary&gt;Commits&lt;/summary&gt;
&lt;ul&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/e8893c57a1f3a2b659b6b55564fdfdbbd2982911&#34;&gt;&lt;code&gt;e8893c5&lt;/code&gt;&lt;/a&gt;
Merge pull request &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/issues/2113&#34;&gt;#2113&lt;/a&gt;
from github/update-v3.24.0-2db032717&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/78d6c8e84d016cf4acb354a3303db8635054030f&#34;&gt;&lt;code&gt;78d6c8e&lt;/code&gt;&lt;/a&gt;
Update changelog for v3.24.0&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/2db03271718eb704357b7bbf29ef6876a898f966&#34;&gt;&lt;code&gt;2db0327&lt;/code&gt;&lt;/a&gt;
Merge pull request &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/issues/2112&#34;&gt;#2112&lt;/a&gt;
from github/henrymercer/status-report-handle-disk-fa...&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/f9dea84e297d93b380c8e1fbee3b726ae2f9a0d1&#34;&gt;&lt;code&gt;f9dea84&lt;/code&gt;&lt;/a&gt;
Status report: Handle failures determining disk usage&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/81eb6b2bf41204db055248bd3f7a89f335b6e4d9&#34;&gt;&lt;code&gt;81eb6b2&lt;/code&gt;&lt;/a&gt;
Merge pull request &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/issues/2108&#34;&gt;#2108&lt;/a&gt;
from github/henrymercer/build-mode-input&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/483bef1dab1b4345c7aaad6b5ab530b6296dc57e&#34;&gt;&lt;code&gt;483bef1&lt;/code&gt;&lt;/a&gt;
Merge pull request &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/issues/2106&#34;&gt;#2106&lt;/a&gt;
from github/rasmuswl/default-no-dep-inst&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/b58c2f67a6ee7168ff2d21176f29c8e7a25f34f8&#34;&gt;&lt;code&gt;b58c2f6&lt;/code&gt;&lt;/a&gt;
Detail requirements for different build modes&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/f7d53249e3ff1b2d2bc99288527e155561d1ba90&#34;&gt;&lt;code&gt;f7d5324&lt;/code&gt;&lt;/a&gt;
Update wording for CHANGELOG.md&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/254b53d99969befd5b84fbe43df37bc8e9350bfc&#34;&gt;&lt;code&gt;254b53d&lt;/code&gt;&lt;/a&gt;
Merge branch &#39;main&#39; into henrymercer/build-mode-input&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/e34513334c80bc03203d626a9c14243c9bf67245&#34;&gt;&lt;code&gt;e345133&lt;/code&gt;&lt;/a&gt;
Merge pull request &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/issues/2107&#34;&gt;#2107&lt;/a&gt;
from github/henrymercer/refactor-config&lt;/li&gt;
&lt;li&gt;Additional commits viewable in &lt;a
href=&#34;https://github.com/github/codeql-action/compare/b7bf0a3ed3ecfa44160715d7c442788f65f0f923...e8893c57a1f3a2b659b6b55564fdfdbbd2982911&#34;&gt;compare
view&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;/details&gt;
&lt;br /&gt;


[![Dependabot compatibility
score](https://dependabot-badges.githubapp.com/badges/compatibility_score?dependency-name=github/codeql-action&amp;package-manager=github_actions&amp;previous-version=3.23.2&amp;new-version=3.24.0)](https://docs.github.com/en/github/managing-security-vulnerabilities/about-dependabot-security-updates#about-compatibility-scores)

Dependabot will resolve any conflicts with this PR as long as you don&#39;t
alter it yourself. You can also trigger a rebase manually by commenting
`@dependabot rebase`.

[//]: # (dependabot-automerge-start)
[//]: # (dependabot-automerge-end)

---

&lt;details&gt;
&lt;summary&gt;Dependabot commands and options&lt;/summary&gt;
&lt;br /&gt;

You can trigger Dependabot actions by commenting on this PR:
- `@dependabot rebase` will rebase this PR
- `@dependabot recreate` will recreate this PR, overwriting any edits
that have been made to it
- `@dependabot merge` will merge this PR after your CI passes on it
- `@dependabot squash and merge` will squash and merge this PR after
your CI passes on it
- `@dependabot cancel merge` will cancel a previously requested merge
and block automerging
- `@dependabot reopen` will reopen this PR if it is closed
- `@dependabot close` will close this PR and stop Dependabot recreating
it. You can achieve the same result by closing it manually
- `@dependabot show &lt;dependency name&gt; ignore conditions` will show all
of the ignore conditions of the specified dependency
- `@dependabot ignore this major version` will close this PR and stop
Dependabot creating any more for this major version (unless you reopen
the PR or upgrade to it yourself)
- `@dependabot ignore this minor version` will close this PR and stop
Dependabot creating any more for this minor version (unless you reopen
the PR or upgrade to it yourself)
- `@dependabot ignore this dependency` will close this PR and stop
Dependabot creating any more for this dependency (unless you reopen the
PR or upgrade to it yourself)


&lt;/details&gt; ([`30f1750`](https://github.com/OZI-Project/OZI/commit/30f175039a23296acc20ec6bc01a5e9b20ccfbb5))

## 0.0.273 (2024-02-03)

### :lock:

* :lock: Clarify reporting process for vulnerabilities. (#169) ([`be193f7`](https://github.com/OZI-Project/OZI/commit/be193f7ccc58e4b7e93e48511b5f9d6663acbb94))

* :lock: Clarify reporting process for vulnerabilities.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`8b9a4de`](https://github.com/OZI-Project/OZI/commit/8b9a4de48c346df310d1eb15a612719a457f43aa))

### Other

* Update security policy and readme logo. (#170)

Also tests out branch protection rules for pre-alpha release branch. ([`1710c19`](https://github.com/OZI-Project/OZI/commit/1710c19216a58b67131817413602e99a05d6c56b))

* :memo: Normalize logo alignment by using a vector graphic. (#168) ([`b35c5d0`](https://github.com/OZI-Project/OZI/commit/b35c5d067fd8b9a1ce0ac959c288812d44ce4793))

* :memo: Normalize logo alignment by using a vector graphic.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`1c8060a`](https://github.com/OZI-Project/OZI/commit/1c8060aa9da25d38158c1d298e541f7a0b8d6f14))

* 0.0 (#167) ([`85c8f3c`](https://github.com/OZI-Project/OZI/commit/85c8f3cf847d80b8c34567133d8ee30c7e2060e1))

## 0.0.272 (2024-02-03)

### :hammer:

* :hammer: Update meson_setuptools_scm.py

Validate user-supplied ``version_file``.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`9e91e71`](https://github.com/OZI-Project/OZI/commit/9e91e7183aaf89d942c8b9236642191e84e25161))

* :hammer: Update meson_dist_setuptools_scm.py

* User-provided ``version_file`` is now validated.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`a8ba231`](https://github.com/OZI-Project/OZI/commit/a8ba23106109ca96993d7206895e2d5afc442e1b))

### :pencil2:

* :pencil2: Update meson_dist_setuptools_scm.py

Make file write dependent on a valid path.
Fix error message to point to the ``version_file`` variable in pyproject.toml.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`697ad43`](https://github.com/OZI-Project/OZI/commit/697ad43f2cff68a29207f3368c530bf0dc0c6fa4))

### Other

* Release (#166) ([`7ae1a9c`](https://github.com/OZI-Project/OZI/commit/7ae1a9c630e74949ba769bb624444120ab3833e8))

* Update scripts (#165)

* Add path validation ([`1f27273`](https://github.com/OZI-Project/OZI/commit/1f27273dfa7546f4986be54148df69c42d1008d0))

## 0.0.271 (2024-02-03)

### :hammer:

* :hammer: Update spec.py (#163)

Use black &lt;24
Add restructuredtext-lint ([`a139d44`](https://github.com/OZI-Project/OZI/commit/a139d442814e3da26553b6f7ab3cd10cc689fd34))

* :hammer: Update spec.py

Use black &lt;24
Add restructuredtext-lint

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`2638f6b`](https://github.com/OZI-Project/OZI/commit/2638f6b71c5e5d7b9b57c4be9bc1d63a3602aaa8))

### Other

* Release (#164) ([`b854829`](https://github.com/OZI-Project/OZI/commit/b854829acf64f4b12f11e79acef4ab17cfcb0bbf))

## 0.0.270 (2024-02-03)

### :hammer:

* :hammer: Update ozi/new/parser.py (#161)

Remove ``-new`` help.
Remove ``-fix`` help. ([`ff19cc1`](https://github.com/OZI-Project/OZI/commit/ff19cc1e2e1129e4595a3bf0f554acd60b18d1ec))

* :hammer: Update ozi/__main__.py

Add help explaining alternate entrypoints for ``ozi-fix`` and ``ozi-new``

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt;
Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`0401adc`](https://github.com/OZI-Project/OZI/commit/0401adc33da19866e1cb46abb5b3e9f0b2df57d7))

* :hammer: Update ozi/new/parser.py

Remove ``-new`` help.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt;
Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`c27c665`](https://github.com/OZI-Project/OZI/commit/c27c665ada465f00f68d83bb90f67ab167dd9148))

* :hammer: Update ozi/__main__.py

Add help explaining alternate entrypoints for ``ozi-fix`` and ``ozi-new``

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`5e6698b`](https://github.com/OZI-Project/OZI/commit/5e6698b4355115a25cea923bef99be60d8a8a531))

* :hammer: Update ozi/new/parser.py

Remove ``-new`` help.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`b1faaab`](https://github.com/OZI-Project/OZI/commit/b1faaab27f5e0c4a6342385f134076933a328622))

### :pencil2:

* :pencil2: fix missing import of argparse.
Signed-off-by: Eden Rose Duff MSc

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`1184044`](https://github.com/OZI-Project/OZI/commit/1184044c1cf7d804ba601e44d1fb0424d8bd6ecb))

* :pencil2: fix missing import of argparse.
Signed-off-by: Eden Rose Duff MSc ([`692d8bd`](https://github.com/OZI-Project/OZI/commit/692d8bdf2822b86e0428d77ab18de7d2b3c0f110))

### :pushpin:

* :pushpin:(tox): pin tox black version to &lt;24.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`72f1ad1`](https://github.com/OZI-Project/OZI/commit/72f1ad1ac8cdeb84db7dd1d4c7784931821d638b))

* :pushpin:(tox): pin tox black version to &lt;24. ([`d78543f`](https://github.com/OZI-Project/OZI/commit/d78543f04f84d82226819fb4a83757f5716aabb0))

### Other

* Release (#162) ([`adf2193`](https://github.com/OZI-Project/OZI/commit/adf219370722d17d1c587588f3a8c3d55af16e4b))

* :rotating_light:: reformat to black 2024 stable style.

Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`f5b0c21`](https://github.com/OZI-Project/OZI/commit/f5b0c21b4ae3ce17a34cf4e03d37a35429952b06))

* Update parser.py

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt;
Signed-off-by: rjdbcm &lt;rjdbcm@mail.umkc.edu&gt; ([`b992957`](https://github.com/OZI-Project/OZI/commit/b9929576c84cd161666ab65c139d95af3be9e91d))

* :rotating_light:: reformat to black 2024 stable style. ([`eadf4d7`](https://github.com/OZI-Project/OZI/commit/eadf4d73d0ea17fe515633702f38acdd3464aa8f))

* Update parser.py

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`099e281`](https://github.com/OZI-Project/OZI/commit/099e281a451f35ec17cc37dd69f5855f9e0a499a))

## 0.0.269 (2024-02-02)

### :hammer:

* :hammer: Update __main__.py (#154)

Add ``-new`` and ``-fix`` arguments to ``ozi`` ([`54b3758`](https://github.com/OZI-Project/OZI/commit/54b3758b5f2d29f7df792f3df80837a7da0f296f))

* :hammer:: ``ozi-fix`` and ``ozi-new`` can now be accessed from the ``ozi`` entrypoint. ([`673f56c`](https://github.com/OZI-Project/OZI/commit/673f56ccf6ad760f07ea410903aee0677b232d14))

### Other

* Release (#159) ([`6768a42`](https://github.com/OZI-Project/OZI/commit/6768a42dcc123dfdd775db4de9738e39ce1dc0be))

* :rotating_light: Fix lint issues. ([`10e7898`](https://github.com/OZI-Project/OZI/commit/10e7898adb24ff0f8d492d6dfaba85fbefd978d2))

* :rotating_light: Run linters ([`d02dab7`](https://github.com/OZI-Project/OZI/commit/d02dab737a7abfbcc5a7d9bc7e80f4e26dd38a30))

## 0.0.268 (2024-02-01)

### :hammer:

* :hammer: Update __main__.py

Add ``-new`` and ``-fix`` arguments to ``ozi``

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`956ab4f`](https://github.com/OZI-Project/OZI/commit/956ab4f118da940ae9f16b04259cc847b0793ce1))

### :pencil2:

* :pencil2: Update __main__.py

add no cover comments to args.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`86544d3`](https://github.com/OZI-Project/OZI/commit/86544d3c86132b239d76937c4ee53d52f82788db))

### :pushpin:

* :pushpin: Update checkpoint.yml.j2 harden-runner action. (#156) ([`259f334`](https://github.com/OZI-Project/OZI/commit/259f33421e7bf394d94a0d022fd7cd925d92b26a))

* :pushpin: Update release.yml.j2 harden-runner to 2.7.0

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`a64333b`](https://github.com/OZI-Project/OZI/commit/a64333bde7bfa13d48d19a1d82adb646572fcee6))

* :pushpin: Update publish.yml.j2 harden-runner to 2.7.0

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`afe0a3d`](https://github.com/OZI-Project/OZI/commit/afe0a3d8c256df0af1c6a3c26c294ec1f5a8b1fa))

* :pushpin: Update checkpoint.yml.j2 harden-runner action.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`5ea1483`](https://github.com/OZI-Project/OZI/commit/5ea1483bc121869ecf38ffef24bfb0324eeca891))

* :pushpin: Bump step-security/harden-runner from 2.6.1 to 2.7.0 (#155)

Bumps
[step-security/harden-runner](https://github.com/step-security/harden-runner)
from 2.6.1 to 2.7.0.
&lt;details&gt;
&lt;summary&gt;Release notes&lt;/summary&gt;
&lt;p&gt;&lt;em&gt;Sourced from &lt;a
href=&#34;https://github.com/step-security/harden-runner/releases&#34;&gt;step-security/harden-runner&#39;s
releases&lt;/a&gt;.&lt;/em&gt;&lt;/p&gt;
&lt;blockquote&gt;
&lt;h2&gt;v2.7.0&lt;/h2&gt;
&lt;h2&gt;What&#39;s Changed&lt;/h2&gt;
&lt;p&gt;Release 2.7.0 by &lt;a
href=&#34;https://github.com/varunsh-coder&#34;&gt;&lt;code&gt;@​varunsh-coder&lt;/code&gt;&lt;/a&gt;
and &lt;a href=&#34;https://github.com/h0x0er&#34;&gt;&lt;code&gt;@​h0x0er&lt;/code&gt;&lt;/a&gt; in &lt;a
href=&#34;https://redirect.github.com/step-security/harden-runner/pull/376&#34;&gt;step-security/harden-runner#376&lt;/a&gt;
This release:&lt;/p&gt;
&lt;ol&gt;
&lt;li&gt;Updates the node runtime to node20&lt;/li&gt;
&lt;li&gt;Adds capability to inspect outbound HTTPS traffic on GitHub-hosted
and self-hosted VM runners&lt;/li&gt;
&lt;/ol&gt;
&lt;p&gt;&lt;strong&gt;Full Changelog&lt;/strong&gt;: &lt;a
href=&#34;https://github.com/step-security/harden-runner/compare/v2...v2.7.0&#34;&gt;https://github.com/step-security/harden-runner/compare/v2...v2.7.0&lt;/a&gt;&lt;/p&gt;
&lt;/blockquote&gt;
&lt;/details&gt;
&lt;details&gt;
&lt;summary&gt;Commits&lt;/summary&gt;
&lt;ul&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/step-security/harden-runner/commit/63c24ba6bd7ba022e95695ff85de572c04a18142&#34;&gt;&lt;code&gt;63c24ba&lt;/code&gt;&lt;/a&gt;
Merge pull request &lt;a
href=&#34;https://redirect.github.com/step-security/harden-runner/issues/376&#34;&gt;#376&lt;/a&gt;
from step-security/rc-7&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/step-security/harden-runner/commit/95691d3d1cfc1f403f673ccbe70465d7c4254108&#34;&gt;&lt;code&gt;95691d3&lt;/code&gt;&lt;/a&gt;
Update dist&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/step-security/harden-runner/commit/6339621ce7eb126e03da0cdd1e373bf4a86aa351&#34;&gt;&lt;code&gt;6339621&lt;/code&gt;&lt;/a&gt;
Update to node20&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/step-security/harden-runner/commit/4a63cdab7412f310777ba8aba65aafca4c1dd47f&#34;&gt;&lt;code&gt;4a63cda&lt;/code&gt;&lt;/a&gt;
Add tls-inspection capability (&lt;a
href=&#34;https://redirect.github.com/step-security/harden-runner/issues/368&#34;&gt;#368&lt;/a&gt;)&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/step-security/harden-runner/commit/dece11172ed6b762b5421b294513d628edad7f7d&#34;&gt;&lt;code&gt;dece111&lt;/code&gt;&lt;/a&gt;
Merge pull request &lt;a
href=&#34;https://redirect.github.com/step-security/harden-runner/issues/372&#34;&gt;#372&lt;/a&gt;
from step-security/readme-update&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/step-security/harden-runner/commit/1952f970702453e198ed55b40944bf4ffc0ad992&#34;&gt;&lt;code&gt;1952f97&lt;/code&gt;&lt;/a&gt;
Updates&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/step-security/harden-runner/commit/32f00ffb1b198fae962ae378ca876e01f367043f&#34;&gt;&lt;code&gt;32f00ff&lt;/code&gt;&lt;/a&gt;
Update README.md&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/step-security/harden-runner/commit/ea8b747819ff6d82907eb4018229f1a75c174697&#34;&gt;&lt;code&gt;ea8b747&lt;/code&gt;&lt;/a&gt;
Publish test results (&lt;a
href=&#34;https://redirect.github.com/step-security/harden-runner/issues/363&#34;&gt;#363&lt;/a&gt;)&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/step-security/harden-runner/commit/c0db65e1f64025718795419be8dbbf8c4050160f&#34;&gt;&lt;code&gt;c0db65e&lt;/code&gt;&lt;/a&gt;
Merge pull request &lt;a
href=&#34;https://redirect.github.com/step-security/harden-runner/issues/359&#34;&gt;#359&lt;/a&gt;
from step-security/dependabot/github_actions/actions/...&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/step-security/harden-runner/commit/4151c053ff9c3daff63c12b5175c94870ec73b53&#34;&gt;&lt;code&gt;4151c05&lt;/code&gt;&lt;/a&gt;
Merge pull request &lt;a
href=&#34;https://redirect.github.com/step-security/harden-runner/issues/361&#34;&gt;#361&lt;/a&gt;
from step-security/dependabot/github_actions/step-sec...&lt;/li&gt;
&lt;li&gt;Additional commits viewable in &lt;a
href=&#34;https://github.com/step-security/harden-runner/compare/eb238b55efaa70779f274895e782ed17c84f2895...63c24ba6bd7ba022e95695ff85de572c04a18142&#34;&gt;compare
view&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;/details&gt;
&lt;br /&gt;


[![Dependabot compatibility
score](https://dependabot-badges.githubapp.com/badges/compatibility_score?dependency-name=step-security/harden-runner&amp;package-manager=github_actions&amp;previous-version=2.6.1&amp;new-version=2.7.0)](https://docs.github.com/en/github/managing-security-vulnerabilities/about-dependabot-security-updates#about-compatibility-scores)

Dependabot will resolve any conflicts with this PR as long as you don&#39;t
alter it yourself. You can also trigger a rebase manually by commenting
`@dependabot rebase`.

[//]: # (dependabot-automerge-start)
[//]: # (dependabot-automerge-end)

---

&lt;details&gt;
&lt;summary&gt;Dependabot commands and options&lt;/summary&gt;
&lt;br /&gt;

You can trigger Dependabot actions by commenting on this PR:
- `@dependabot rebase` will rebase this PR
- `@dependabot recreate` will recreate this PR, overwriting any edits
that have been made to it
- `@dependabot merge` will merge this PR after your CI passes on it
- `@dependabot squash and merge` will squash and merge this PR after
your CI passes on it
- `@dependabot cancel merge` will cancel a previously requested merge
and block automerging
- `@dependabot reopen` will reopen this PR if it is closed
- `@dependabot close` will close this PR and stop Dependabot recreating
it. You can achieve the same result by closing it manually
- `@dependabot show &lt;dependency name&gt; ignore conditions` will show all
of the ignore conditions of the specified dependency
- `@dependabot ignore this major version` will close this PR and stop
Dependabot creating any more for this major version (unless you reopen
the PR or upgrade to it yourself)
- `@dependabot ignore this minor version` will close this PR and stop
Dependabot creating any more for this minor version (unless you reopen
the PR or upgrade to it yourself)
- `@dependabot ignore this dependency` will close this PR and stop
Dependabot creating any more for this dependency (unless you reopen the
PR or upgrade to it yourself)


&lt;/details&gt; ([`751eec7`](https://github.com/OZI-Project/OZI/commit/751eec7ac326b904186bf875760bc8af7a98c4f0))

* :pushpin: Bump step-security/harden-runner from 2.6.1 to 2.7.0

Bumps [step-security/harden-runner](https://github.com/step-security/harden-runner) from 2.6.1 to 2.7.0.
- [Release notes](https://github.com/step-security/harden-runner/releases)
- [Commits](https://github.com/step-security/harden-runner/compare/eb238b55efaa70779f274895e782ed17c84f2895...63c24ba6bd7ba022e95695ff85de572c04a18142)

---
updated-dependencies:
- dependency-name: step-security/harden-runner
  dependency-type: direct:production
  update-type: version-update:semver-minor
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`80d9aa6`](https://github.com/OZI-Project/OZI/commit/80d9aa6a5a4f844aaa143deb22f927492c03d5fe))

### Other

* Bump harden runner (#158)

This makes our entire toolchain node20 ([`29bc7f9`](https://github.com/OZI-Project/OZI/commit/29bc7f9dea6082ee636c43056c71703f7da6a269))

* :memo: Add logo for PyPI rendered readme. (#157) ([`aab9571`](https://github.com/OZI-Project/OZI/commit/aab9571238613f2e3f6b981d3e66284909a4220d))

* :memo: Add logo for PyPI rendered readme.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`145dd51`](https://github.com/OZI-Project/OZI/commit/145dd51d1081d070bf2496f04da6972262bb4718))

## 0.0.267 (2024-01-30)

### :hammer:

* :hammer: Update meson.build (#151)

Optimize requirements build loop. ([`16d2d4a`](https://github.com/OZI-Project/OZI/commit/16d2d4a71ccb1f151de1947600d95aa6ab7681ca))

* :hammer: Update meson.build

Optimize requirements build loop.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`7f7da94`](https://github.com/OZI-Project/OZI/commit/7f7da9429e4b2d58c572fd74e4346b3a2f015357))

### :pencil2:

* :pencil2: Update README.rst

Contributing is its own section.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`7e5f5e8`](https://github.com/OZI-Project/OZI/commit/7e5f5e8cb38f7fe9f24f7da58958d8aebd44af65))

* :pencil2: Update meson.build

Fix missing variable suite set.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`1dc802b`](https://github.com/OZI-Project/OZI/commit/1dc802b77187ee6c61bdc42ac1c57a7d9a063f24))

### Other

* Release 0.0.267 (#153) ([`2a9cfde`](https://github.com/OZI-Project/OZI/commit/2a9cfde0bff7586f792fdafc61e3bb8d2a4da519))

* :memo: Update README.rst (#152)

touch up layout of readme. ([`9dba5e6`](https://github.com/OZI-Project/OZI/commit/9dba5e63c993540d06a0852e03b410e92537eb6b))

* :memo: Update README.rst

Moving message from maintainer to discussion board.
Update my name.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`58eb2a2`](https://github.com/OZI-Project/OZI/commit/58eb2a27c345a2358227f0dfd4a02ba1bbd53365))

* :memo: Update README.rst

touch up layout of readme.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`76a9447`](https://github.com/OZI-Project/OZI/commit/76a94477f024458b079c81e43f563643f7b4ca6f))

* :memo: Update README.rst (#150)

Update Scorecard and best practices badges to use OpenSSF brand
guideline livery. ([`1c1c7f8`](https://github.com/OZI-Project/OZI/commit/1c1c7f8583f896f96cfe166dac0f9a6265360ac3))

* :memo: Update README.rst

Separate external metrics from internal metadata badges.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`339ec48`](https://github.com/OZI-Project/OZI/commit/339ec48fc275ce6a856fe3f4697335c1eb9d646f))

* :memo: Update pyproject.toml add Community Project URL

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`37f3a8c`](https://github.com/OZI-Project/OZI/commit/37f3a8cb99bbaeb46e0ff31db2ed01303eea390b))

* :memo: Update README.rst

Update Scorecard and best practices badges to use OpenSSF brand guideline livery.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`e35a8c8`](https://github.com/OZI-Project/OZI/commit/e35a8c839a25c2e986e1fe83c7cf232b75948721))

* :memo: Update README.rst (#149)

Add logo and clarify python version badge text ([`e6c9daa`](https://github.com/OZI-Project/OZI/commit/e6c9daaf7be046a3283175a9bb077f450427609f))

* :memo: Update README.rst

Add target links

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`e37de85`](https://github.com/OZI-Project/OZI/commit/e37de858c9db38bbd7206d211b7ad82acdd935ae))

* :memo: Update README.rst

Add logo and clarify python version badge text

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`282b535`](https://github.com/OZI-Project/OZI/commit/282b53526667c87f3a7138cf89e0f7dc505d3ed3))

* :memo: Update README.rst (#148)

Add libraries.io logo to badge ([`ea8cc2c`](https://github.com/OZI-Project/OZI/commit/ea8cc2c1f67f86b3f6a981349f3b2accf8e0b236))

* :memo: Update README.rst

Add libraries.io logo to badge

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`dca6005`](https://github.com/OZI-Project/OZI/commit/dca600591a08f7586e826b613704551fdaea295c))

## 0.0.266 (2024-01-30)

### :hammer:

* :hammer:: Add rst-lint meson.options template output. (#146) ([`55200b8`](https://github.com/OZI-Project/OZI/commit/55200b82aeb1b5dc44f76b7db79e8c7b9cdb04a3))

* :hammer:: Add rst-lint meson.options template output.

Signed-Off-By: rjdbcm &lt;help@oziproject.dev&gt; ([`fc7da7d`](https://github.com/OZI-Project/OZI/commit/fc7da7d69a19ab59d350ae889004610d1d7aff36))

* :hammer: Add restructuredtext-lint requirements.in to build. ([`8d9ef5a`](https://github.com/OZI-Project/OZI/commit/8d9ef5ab84a9a6d9a4bd0b520f4f60db856483aa))

### :pencil2:

* :pencil2: Update meson.options

fix leading whitespace

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`0811dc9`](https://github.com/OZI-Project/OZI/commit/0811dc9da219f54d7b7fc9dfec6e83fe42913401))

* :memo::pencil2: Update README.rst (#134)

Add a target to the SLSA badge. ([`f3f734a`](https://github.com/OZI-Project/OZI/commit/f3f734acbd2eaf8a8bb827df95360ab6511b5d9c))

* :memo::pencil2: Update README.rst

Add a target to the SLSA badge.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`c0abc5d`](https://github.com/OZI-Project/OZI/commit/c0abc5d1bf59c50d6993ac17f71f6461dd6dc288))

### :pushpin:

* :pushpin: Bump OZI-Project/checkpoint from 0.1.1 to 0.1.2 (#140)

Bumps
[OZI-Project/checkpoint](https://github.com/ozi-project/checkpoint) from
0.1.1 to 0.1.2.
&lt;details&gt;
&lt;summary&gt;Release notes&lt;/summary&gt;
&lt;p&gt;&lt;em&gt;Sourced from &lt;a
href=&#34;https://github.com/ozi-project/checkpoint/releases&#34;&gt;OZI-Project/checkpoint&#39;s
releases&lt;/a&gt;.&lt;/em&gt;&lt;/p&gt;
&lt;blockquote&gt;
&lt;h2&gt;0.1.2&lt;/h2&gt;
&lt;h2&gt;What&#39;s Changed&lt;/h2&gt;
&lt;ul&gt;
&lt;li&gt;Update action.yml by &lt;a
href=&#34;https://github.com/rjdbcm&#34;&gt;&lt;code&gt;@​rjdbcm&lt;/code&gt;&lt;/a&gt; in &lt;a
href=&#34;https://redirect.github.com/OZI-Project/checkpoint/pull/25&#34;&gt;OZI-Project/checkpoint#25&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;p&gt;Using sigstore action version 2.1.2rc1 as this version does not use
the deprecated Node 16 actions.&lt;/p&gt;
&lt;p&gt;&lt;strong&gt;Full Changelog&lt;/strong&gt;: &lt;a
href=&#34;https://github.com/OZI-Project/checkpoint/compare/0.1.1...0.1.2&#34;&gt;https://github.com/OZI-Project/checkpoint/compare/0.1.1...0.1.2&lt;/a&gt;&lt;/p&gt;
&lt;/blockquote&gt;
&lt;/details&gt;
&lt;details&gt;
&lt;summary&gt;Commits&lt;/summary&gt;
&lt;ul&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/OZI-Project/checkpoint/commit/9b94738aab4c7c3ee989c8be1144d041bfd7a184&#34;&gt;&lt;code&gt;9b94738&lt;/code&gt;&lt;/a&gt;
Merge pull request &lt;a
href=&#34;https://redirect.github.com/ozi-project/checkpoint/issues/25&#34;&gt;#25&lt;/a&gt;
from OZI-Project/rjdbcm-patch-4&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/OZI-Project/checkpoint/commit/60a5642b02b5a81e3200e9d7f8838c49740ee7ff&#34;&gt;&lt;code&gt;60a5642&lt;/code&gt;&lt;/a&gt;
Update action.yml&lt;/li&gt;
&lt;li&gt;See full diff in &lt;a
href=&#34;https://github.com/ozi-project/checkpoint/compare/0.1.1...9b94738aab4c7c3ee989c8be1144d041bfd7a184&#34;&gt;compare
view&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;/details&gt;
&lt;br /&gt;


[![Dependabot compatibility
score](https://dependabot-badges.githubapp.com/badges/compatibility_score?dependency-name=OZI-Project/checkpoint&amp;package-manager=github_actions&amp;previous-version=0.1.1&amp;new-version=0.1.2)](https://docs.github.com/en/github/managing-security-vulnerabilities/about-dependabot-security-updates#about-compatibility-scores)

Dependabot will resolve any conflicts with this PR as long as you don&#39;t
alter it yourself. You can also trigger a rebase manually by commenting
`@dependabot rebase`.

[//]: # (dependabot-automerge-start)
[//]: # (dependabot-automerge-end)

---

&lt;details&gt;
&lt;summary&gt;Dependabot commands and options&lt;/summary&gt;
&lt;br /&gt;

You can trigger Dependabot actions by commenting on this PR:
- `@dependabot rebase` will rebase this PR
- `@dependabot recreate` will recreate this PR, overwriting any edits
that have been made to it
- `@dependabot merge` will merge this PR after your CI passes on it
- `@dependabot squash and merge` will squash and merge this PR after
your CI passes on it
- `@dependabot cancel merge` will cancel a previously requested merge
and block automerging
- `@dependabot reopen` will reopen this PR if it is closed
- `@dependabot close` will close this PR and stop Dependabot recreating
it. You can achieve the same result by closing it manually
- `@dependabot show &lt;dependency name&gt; ignore conditions` will show all
of the ignore conditions of the specified dependency
- `@dependabot ignore this major version` will close this PR and stop
Dependabot creating any more for this major version (unless you reopen
the PR or upgrade to it yourself)
- `@dependabot ignore this minor version` will close this PR and stop
Dependabot creating any more for this minor version (unless you reopen
the PR or upgrade to it yourself)
- `@dependabot ignore this dependency` will close this PR and stop
Dependabot creating any more for this dependency (unless you reopen the
PR or upgrade to it yourself)


&lt;/details&gt; ([`69198d1`](https://github.com/OZI-Project/OZI/commit/69198d130d58c36c81ef2b1269a89d9730996b26))

* :pushpin: Bump github/codeql-action from 3.23.1 to 3.23.2 (#141)

Bumps [github/codeql-action](https://github.com/github/codeql-action)
from 3.23.1 to 3.23.2.
&lt;details&gt;
&lt;summary&gt;Changelog&lt;/summary&gt;
&lt;p&gt;&lt;em&gt;Sourced from &lt;a
href=&#34;https://github.com/github/codeql-action/blob/main/CHANGELOG.md&#34;&gt;github/codeql-action&#39;s
changelog&lt;/a&gt;.&lt;/em&gt;&lt;/p&gt;
&lt;blockquote&gt;
&lt;h1&gt;CodeQL Action Changelog&lt;/h1&gt;
&lt;p&gt;See the &lt;a
href=&#34;https://github.com/github/codeql-action/releases&#34;&gt;releases
page&lt;/a&gt; for the relevant changes to the CodeQL CLI and language
packs.&lt;/p&gt;
&lt;p&gt;Note that the only difference between &lt;code&gt;v2&lt;/code&gt; and
&lt;code&gt;v3&lt;/code&gt; of the CodeQL Action is the node version they support,
with &lt;code&gt;v3&lt;/code&gt; running on node 20 while we continue to release
&lt;code&gt;v2&lt;/code&gt; to support running on node 16. For example
&lt;code&gt;3.22.11&lt;/code&gt; was the first &lt;code&gt;v3&lt;/code&gt; release and is
functionally identical to &lt;code&gt;2.22.11&lt;/code&gt;. This approach ensures an
easy way to track exactly which features are included in different
versions, indicated by the minor and patch version numbers.&lt;/p&gt;
&lt;h2&gt;[UNRELEASED]&lt;/h2&gt;
&lt;p&gt;No user facing changes.&lt;/p&gt;
&lt;h2&gt;3.23.2 - 26 Jan 2024&lt;/h2&gt;
&lt;ul&gt;
&lt;li&gt;On Linux, the maximum possible value for the &lt;code&gt;--threads&lt;/code&gt;
option now respects the CPU count as specified in &lt;code&gt;cgroup&lt;/code&gt;
files to more accurately reflect the number of available cores when
running in containers. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2083&#34;&gt;#2083&lt;/a&gt;&lt;/li&gt;
&lt;li&gt;Update default CodeQL bundle version to 2.16.1. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2096&#34;&gt;#2096&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;h2&gt;3.23.1 - 17 Jan 2024&lt;/h2&gt;
&lt;ul&gt;
&lt;li&gt;Update default CodeQL bundle version to 2.16.0. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2073&#34;&gt;#2073&lt;/a&gt;&lt;/li&gt;
&lt;li&gt;Change the retention period for uploaded debug artifacts to 7 days.
Previously, this was whatever the repository default was. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2079&#34;&gt;#2079&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;h2&gt;3.23.0 - 08 Jan 2024&lt;/h2&gt;
&lt;ul&gt;
&lt;li&gt;We are rolling out a feature in January 2024 that will disable
Python dependency installation by default for all users. This improves
the speed of analysis while having only a very minor impact on results.
You can override this behavior by setting
&lt;code&gt;CODEQL_ACTION_DISABLE_PYTHON_DEPENDENCY_INSTALLATION=false&lt;/code&gt;
in your workflow, however we plan to remove this ability in future
versions of the CodeQL Action. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2031&#34;&gt;#2031&lt;/a&gt;&lt;/li&gt;
&lt;li&gt;The CodeQL Action now requires CodeQL version 2.11.6 or later. For
more information, see &lt;a
href=&#34;https://github.com/github/codeql-action/blob/main/#2227---16-nov-2023&#34;&gt;the
corresponding changelog entry for CodeQL Action version 2.22.7&lt;/a&gt;. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2009&#34;&gt;#2009&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;h2&gt;3.22.12 - 22 Dec 2023&lt;/h2&gt;
&lt;ul&gt;
&lt;li&gt;Update default CodeQL bundle version to 2.15.5. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2047&#34;&gt;#2047&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;h2&gt;3.22.11 - 13 Dec 2023&lt;/h2&gt;
&lt;ul&gt;
&lt;li&gt;[v3+ only] The CodeQL Action now runs on Node.js v20. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2006&#34;&gt;#2006&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;h2&gt;2.22.10 - 12 Dec 2023&lt;/h2&gt;
&lt;ul&gt;
&lt;li&gt;Update default CodeQL bundle version to 2.15.4. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2016&#34;&gt;#2016&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;h2&gt;2.22.9 - 07 Dec 2023&lt;/h2&gt;
&lt;p&gt;No user facing changes.&lt;/p&gt;
&lt;h2&gt;2.22.8 - 23 Nov 2023&lt;/h2&gt;
&lt;ul&gt;
&lt;li&gt;Update default CodeQL bundle version to 2.15.3. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/2001&#34;&gt;#2001&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;h2&gt;2.22.7 - 16 Nov 2023&lt;/h2&gt;
&lt;ul&gt;
&lt;li&gt;Add a deprecation warning for customers using CodeQL version 2.11.5
and earlier. These versions of CodeQL were discontinued on 8 November
2023 alongside GitHub Enterprise Server 3.7, and will be unsupported by
CodeQL Action v2.23.0 and later. &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/pull/1993&#34;&gt;#1993&lt;/a&gt;
&lt;ul&gt;
&lt;li&gt;If you are using one of these versions, please update to CodeQL CLI
version 2.11.6 or later. For instance, if you have specified a custom
version of the CLI using the &#39;tools&#39; input to the &#39;init&#39; Action, you can
remove this input to use the default version.&lt;/li&gt;
&lt;li&gt;Alternatively, if you want to continue using a version of the CodeQL
CLI between 2.10.5 and 2.11.5, you can replace
&lt;code&gt;github/codeql-action/*@v2&lt;/code&gt; by
&lt;code&gt;github/codeql-action/*@v2.22.7&lt;/code&gt; in your code scanning
workflow to ensure you continue using this version of the CodeQL
Action.&lt;/li&gt;
&lt;/ul&gt;
&lt;/li&gt;
&lt;/ul&gt;
&lt;!-- raw HTML omitted --&gt;
&lt;/blockquote&gt;
&lt;p&gt;... (truncated)&lt;/p&gt;
&lt;/details&gt;
&lt;details&gt;
&lt;summary&gt;Commits&lt;/summary&gt;
&lt;ul&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/b7bf0a3ed3ecfa44160715d7c442788f65f0f923&#34;&gt;&lt;code&gt;b7bf0a3&lt;/code&gt;&lt;/a&gt;
Merge pull request &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/issues/2099&#34;&gt;#2099&lt;/a&gt;
from github/update-v3.23.2-61bf02577&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/33e354b34bc9d95d28ae4f055fa1faeb59e59ae5&#34;&gt;&lt;code&gt;33e354b&lt;/code&gt;&lt;/a&gt;
Changelog: Add missing PR link&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/f4cfe8904c929c35f9612da0c754f121a3422d7e&#34;&gt;&lt;code&gt;f4cfe89&lt;/code&gt;&lt;/a&gt;
Update changelog for v3.23.2&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/61bf02577c801b30a708abc6f2164763e4e1d0cd&#34;&gt;&lt;code&gt;61bf025&lt;/code&gt;&lt;/a&gt;
Send overall job status in init-post status report (&lt;a
href=&#34;https://redirect.github.com/github/codeql-action/issues/2097&#34;&gt;#2097&lt;/a&gt;)&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/16150320c5db0d4942ea2bd4974fc365d6324737&#34;&gt;&lt;code&gt;1615032&lt;/code&gt;&lt;/a&gt;
Merge pull request &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/issues/2096&#34;&gt;#2096&lt;/a&gt;
from github/update-bundle/codeql-bundle-v2.16.1&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/bd67d8d6b2096e4b46db15ed108e563c4447d608&#34;&gt;&lt;code&gt;bd67d8d&lt;/code&gt;&lt;/a&gt;
Merge pull request &lt;a
href=&#34;https://redirect.github.com/github/codeql-action/issues/2098&#34;&gt;#2098&lt;/a&gt;
from github/henrymercer/update-internal-queries&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/a2619f68c8432b9a500ecc7aafd4816667379bed&#34;&gt;&lt;code&gt;a2619f6&lt;/code&gt;&lt;/a&gt;
Internal queries: Replace deprecated predicates&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/666e2f9edfd29789e9f46f2cce092d18622dcb74&#34;&gt;&lt;code&gt;666e2f9&lt;/code&gt;&lt;/a&gt;
Internal queries: Replace deprecated predicates&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/d43ae36a631248dea35da2f8da5e28687255da31&#34;&gt;&lt;code&gt;d43ae36&lt;/code&gt;&lt;/a&gt;
Add changelog note&lt;/li&gt;
&lt;li&gt;&lt;a
href=&#34;https://github.com/github/codeql-action/commit/75af1f5948eef4f82d80db69296c55a9bc5ba26e&#34;&gt;&lt;code&gt;75af1f5&lt;/code&gt;&lt;/a&gt;
Update default bundle to codeql-bundle-v2.16.1&lt;/li&gt;
&lt;li&gt;Additional commits viewable in &lt;a
href=&#34;https://github.com/github/codeql-action/compare/0b21cf2492b6b02c465a3e5d7c473717ad7721ba...b7bf0a3ed3ecfa44160715d7c442788f65f0f923&#34;&gt;compare
view&lt;/a&gt;&lt;/li&gt;
&lt;/ul&gt;
&lt;/details&gt;
&lt;br /&gt;


[![Dependabot compatibility
score](https://dependabot-badges.githubapp.com/badges/compatibility_score?dependency-name=github/codeql-action&amp;package-manager=github_actions&amp;previous-version=3.23.1&amp;new-version=3.23.2)](https://docs.github.com/en/github/managing-security-vulnerabilities/about-dependabot-security-updates#about-compatibility-scores)

Dependabot will resolve any conflicts with this PR as long as you don&#39;t
alter it yourself. You can also trigger a rebase manually by commenting
`@dependabot rebase`.

[//]: # (dependabot-automerge-start)
[//]: # (dependabot-automerge-end)

---

&lt;details&gt;
&lt;summary&gt;Dependabot commands and options&lt;/summary&gt;
&lt;br /&gt;

You can trigger Dependabot actions by commenting on this PR:
- `@dependabot rebase` will rebase this PR
- `@dependabot recreate` will recreate this PR, overwriting any edits
that have been made to it
- `@dependabot merge` will merge this PR after your CI passes on it
- `@dependabot squash and merge` will squash and merge this PR after
your CI passes on it
- `@dependabot cancel merge` will cancel a previously requested merge
and block automerging
- `@dependabot reopen` will reopen this PR if it is closed
- `@dependabot close` will close this PR and stop Dependabot recreating
it. You can achieve the same result by closing it manually
- `@dependabot show &lt;dependency name&gt; ignore conditions` will show all
of the ignore conditions of the specified dependency
- `@dependabot ignore this major version` will close this PR and stop
Dependabot creating any more for this major version (unless you reopen
the PR or upgrade to it yourself)
- `@dependabot ignore this minor version` will close this PR and stop
Dependabot creating any more for this minor version (unless you reopen
the PR or upgrade to it yourself)
- `@dependabot ignore this dependency` will close this PR and stop
Dependabot creating any more for this dependency (unless you reopen the
PR or upgrade to it yourself)


&lt;/details&gt; ([`81900ac`](https://github.com/OZI-Project/OZI/commit/81900aca56fc44d655b36c25a7c7af7f3adf810b))

* :pushpin: Bump github/codeql-action from 3.23.1 to 3.23.2

Bumps [github/codeql-action](https://github.com/github/codeql-action) from 3.23.1 to 3.23.2.
- [Release notes](https://github.com/github/codeql-action/releases)
- [Changelog](https://github.com/github/codeql-action/blob/main/CHANGELOG.md)
- [Commits](https://github.com/github/codeql-action/compare/0b21cf2492b6b02c465a3e5d7c473717ad7721ba...b7bf0a3ed3ecfa44160715d7c442788f65f0f923)

---
updated-dependencies:
- dependency-name: github/codeql-action
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`968eb71`](https://github.com/OZI-Project/OZI/commit/968eb71d7e3007a6f2bd6db1d826a7ab4f819ebc))

* :pushpin: Bump OZI-Project/checkpoint from 0.1.1 to 0.1.2

Bumps [OZI-Project/checkpoint](https://github.com/ozi-project/checkpoint) from 0.1.1 to 0.1.2.
- [Release notes](https://github.com/ozi-project/checkpoint/releases)
- [Commits](https://github.com/ozi-project/checkpoint/compare/0.1.1...9b94738aab4c7c3ee989c8be1144d041bfd7a184)

---
updated-dependencies:
- dependency-name: OZI-Project/checkpoint
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`d32a58c`](https://github.com/OZI-Project/OZI/commit/d32a58ca4be12e97c7b47bc48b7ab4a90d01bc76))

### :wrench:

* :wrench: Update meson.options

remove rst-lint from module-only

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`228965d`](https://github.com/OZI-Project/OZI/commit/228965debb3412e047f101ac4f702322f7cf4430))

* :wrench: Update meson.options 

args-restructuredtext-lint level set to warning over debug.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`2b85237`](https://github.com/OZI-Project/OZI/commit/2b85237506e63fc6e0804f85292ecce93dbddf5c))

* :wrench: Update meson.options

Add rst-lint to lint suites.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`2b72b78`](https://github.com/OZI-Project/OZI/commit/2b72b78cfaf200e2c53097aa3206113ddd6bfdec))

### Other

* release 0.0.266 (#147) ([`514f702`](https://github.com/OZI-Project/OZI/commit/514f702418b19339d5f6b27b2608e71e39b087fa))

* Rjdbcm patch restructuredtext lint (#145)

Fix #139 ([`a40677e`](https://github.com/OZI-Project/OZI/commit/a40677e9c6d9128b9db5596000c20952f31c5af4))

* :memo: Update README.rst (#144)

Swap description and information sections for PyPI presentation.
Move sigstore seal to the bottom. ([`93f1f2c`](https://github.com/OZI-Project/OZI/commit/93f1f2cfdcf617e3a0764ee95e54a84cddf6d655))

* Update README.rst

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`32e3b1f`](https://github.com/OZI-Project/OZI/commit/32e3b1fd9066fba07e203ba80e4537ea02e76297))

* :memo: Update README.rst (#143)

Remove license section (still hosted at
https://github.com/orgs/OZI-Project/discussions/8)

Add license badge. ([`94ccf24`](https://github.com/OZI-Project/OZI/commit/94ccf24ab7e066b4beabaccdb14c4382cb2d1af5))

* :memo: Update README.rst

Remove license section (still hosted at https://github.com/orgs/OZI-Project/discussions/8)

Add license badge.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`b0fa9f8`](https://github.com/OZI-Project/OZI/commit/b0fa9f8dc12b2fcc58d4edcf2bf6b8cbf16ef029))

* :memo: Update README.rst (#142)

Add [SLSA v1.0 - Level 3](https://slsa.dev/spec/v1.0/levels#build-l3)
link ([`114b6bf`](https://github.com/OZI-Project/OZI/commit/114b6bf391e7c7f004c6192967099e6d9ba9be1b))

* :memo: Update README.rst

Add [SLSA v1.0 - Level 3](https://slsa.dev/spec/v1.0/levels#build-l3) link

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`aa0823b`](https://github.com/OZI-Project/OZI/commit/aa0823b3bc99dfbd7924a3330eb23188fce57e46))

* :memo: Update CONTRIBUTING.md (#137)

Add commit signing policy. ([`5ae9bd7`](https://github.com/OZI-Project/OZI/commit/5ae9bd7159fd51400472fc64b22533f09e6f9a0d))

* :memo: Update CONTRIBUTING.md

Add commit signing policy.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`7e91069`](https://github.com/OZI-Project/OZI/commit/7e91069db604d3e46cf3483f138123c9d7b9d4e3))

* :memo: Update README.rst (#136)

Add link to pypi search for python versions. ([`b0c64cb`](https://github.com/OZI-Project/OZI/commit/b0c64cbac7ffc2975c38b2f220bdd2939027e832))

* :memo: Update README.rst

Add link to pypi search for python versions.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`e5289e7`](https://github.com/OZI-Project/OZI/commit/e5289e735d638be7db65093aa81fac53f6c929ce))

* 0.0 changes (#135) ([`0f5af03`](https://github.com/OZI-Project/OZI/commit/0f5af038ad824666befc1d5d7fc5f6491f2d9b39))

## 0.0.265 (2024-01-28)

### :lipstick:

* :lipstick: Update README.rst

Add little changes to the readme to target end-users better.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`0c57038`](https://github.com/OZI-Project/OZI/commit/0c570388f3dcf7e000b5f5062109bd4ee2402e90))

### :pencil2:

* :pencil2: Update README.rst (#132)

Fix long_description format for twine. ([`5f457d6`](https://github.com/OZI-Project/OZI/commit/5f457d6757bb6a330c84982c7fe5efd5a1432fd7))

* :pencil2: Update README.rst

Fix long_description format for twine.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`510beaf`](https://github.com/OZI-Project/OZI/commit/510beafe506fb2b74a8d3bfd41866ca26fc74239))

### Other

* Retry 0.0.265 release (#133) ([`7b541b4`](https://github.com/OZI-Project/OZI/commit/7b541b48603d0c4451dddfc4608b89207b3f472e))

* Rjdbcm patch 1 (#131) ([`510f41e`](https://github.com/OZI-Project/OZI/commit/510f41e3a65d46c8b492c4faa6dea0dfb01f2105))

* Update README.rst

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`1e2bd2a`](https://github.com/OZI-Project/OZI/commit/1e2bd2a6dfdec3eb32c7be035786072bfc13a2de))

* Update README.rst

:memo: Add provenance step to readme.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`22a05fe`](https://github.com/OZI-Project/OZI/commit/22a05fed214091911461247fe7e4c28e84dc2955))

* Update README.rst

:memo: Licensing scan monitor badge removed.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`8ae96d4`](https://github.com/OZI-Project/OZI/commit/8ae96d46193e2c69b64d5ebb11732af62ad68db3))

* Update README.rst

:memo: Clean up badges to be more informative to potential users.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`881af21`](https://github.com/OZI-Project/OZI/commit/881af2105eed39177cf97057ae11b040f3067a0b))

## 0.0.264 (2024-01-26)

### :hammer:

* :hammer: Update dist-workflow.yml

Use separate jobs rather than matrix for checkpointing stability.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`afa4051`](https://github.com/OZI-Project/OZI/commit/afa4051d3963b808eb85b9402744ad911da79db3))

* :hammer: Update dev-workflow.yml

Can&#39;t use matrix actions because of artifact upload v4

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`6cf0dfb`](https://github.com/OZI-Project/OZI/commit/6cf0dfb420d8152c8ff840bd0ff89dd5252e5743))

### :pushpin:

* :pushpin: Bump OZI-Project/checkpoint from 0.1.1 to 0.1.2

Bumps [OZI-Project/checkpoint](https://github.com/ozi-project/checkpoint) from 0.1.1 to 0.1.2.
- [Release notes](https://github.com/ozi-project/checkpoint/releases)
- [Commits](https://github.com/ozi-project/checkpoint/compare/9f405918305aa607771282da4ae207589d0f23b8...9b94738aab4c7c3ee989c8be1144d041bfd7a184)

---
updated-dependencies:
- dependency-name: OZI-Project/checkpoint
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`cf9b587`](https://github.com/OZI-Project/OZI/commit/cf9b587f1a5dec70dae48210594047e5b41594fe))

### Other

* Update requirements.in

✏️ fix pin

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`eecc30e`](https://github.com/OZI-Project/OZI/commit/eecc30e12348206a7b066140eceff3e7c003c364))

* Update checkpoint.yml.j2

✏️ Fix missing step from checkpoint aggregator

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`4193fa2`](https://github.com/OZI-Project/OZI/commit/4193fa2c7fecd3049d453c89828b4e3c5cab19f0))

* Update dist-workflow.yml

✏️ Fix missing step from checkpoint aggregator

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`4476e61`](https://github.com/OZI-Project/OZI/commit/4476e61c08980bf8ccd5181dd9f910594fa9a2f7))

* Update requirements.in

📌 use ``black ~= 23`` stable version pin.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`7f08787`](https://github.com/OZI-Project/OZI/commit/7f087873d6644518915ac7e225f970108438ccd3))

* Update checkpoint.yml.j2

🔨  use unique checkpoint job ids.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`49b7b42`](https://github.com/OZI-Project/OZI/commit/49b7b427b5eeb9962b136fe2fef2249a901a85bf))

* Update dev-workflow.yml

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`3f8fe63`](https://github.com/OZI-Project/OZI/commit/3f8fe634567db3de054845f68ffa5a53e37c72c2))

## 0.0.263 (2024-01-26)

### :pushpin:

* :pushpin: Update dist-workflow.yml

Update checkpoint pin to: 9f405918305aa607771282da4ae207589d0f23b8

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`fde0d36`](https://github.com/OZI-Project/OZI/commit/fde0d36a89fda57fe0307cfc681b9a3eeef9ca66))

* :pushpin: Update dev-workflow.yml

Update checkpoint pin to: 9f405918305aa607771282da4ae207589d0f23b8

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`c9b05e8`](https://github.com/OZI-Project/OZI/commit/c9b05e89f14885ec499d4b1baecc8cf88a0c6801))

* :pushpin:: Update checkpoint.yml.j2

Update version pin to: 9f405918305aa607771282da4ae207589d0f23b8

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`6d084a0`](https://github.com/OZI-Project/OZI/commit/6d084a0346883737ea82fb752d6ca06ef86ac056))

## 0.0.262 (2024-01-25)

### :hammer:

* :hammer: Update dist-workflow.yml to latest release and publish.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`a09649b`](https://github.com/OZI-Project/OZI/commit/a09649b21c90986a6f880ea362f0fa87ac6398ac))

* :hammer: Update checkpoint.yml.j2 to add signed log artifact.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`ee99788`](https://github.com/OZI-Project/OZI/commit/ee9978823e9da544f68ff43a9d9e977d1b3d199e))

* :hammer: add ``id-token: write`` to checkpoint

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`5770594`](https://github.com/OZI-Project/OZI/commit/5770594fc342eec709043696601ff2e5812dcb51))

### :pushpin:

* :pushpin: Bump OZI-Project/publish

Bumps [OZI-Project/publish](https://github.com/ozi-project/publish) from 37f120b2f1f8130d11e0d6c62b01ad2061187f59 to d9173e726b4cbb2ecd631fff0259656737e0dc23.
- [Release notes](https://github.com/ozi-project/publish/releases)
- [Commits](https://github.com/ozi-project/publish/compare/37f120b2f1f8130d11e0d6c62b01ad2061187f59...d9173e726b4cbb2ecd631fff0259656737e0dc23)

---
updated-dependencies:
- dependency-name: OZI-Project/publish
  dependency-type: direct:production
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`e5d477c`](https://github.com/OZI-Project/OZI/commit/e5d477c3ea3faa9c282dcb1377ba004a3b74543a))

### Other

* Update publish.yml.j2

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`9def9ef`](https://github.com/OZI-Project/OZI/commit/9def9efaae3b3440939db57f3e4073ea060c1d48))

* Update release.yml.j2 to 0.1.0-prealpha

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`b27c29a`](https://github.com/OZI-Project/OZI/commit/b27c29ace509452ad9e56bd711cbfbd6cf65f8a9))

* Update dist-workflow.yml - add     permissions:         id-token: write

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`c7fd5d0`](https://github.com/OZI-Project/OZI/commit/c7fd5d03a9bfdd24a7a134f49961aa8266811eb2))

* Update dev-workflow.yml - egress policy for signed checkpoints.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`120b783`](https://github.com/OZI-Project/OZI/commit/120b78304b21c83f787fc01ae1e3dc87a5f15fc6))

* Update dist-workflow.yml - fix egress policy for signed checkpoints.

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`6ee3c92`](https://github.com/OZI-Project/OZI/commit/6ee3c923ad4c2954817538298331733a910b080c))

* Update dev-workflow.yml

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`629c3c9`](https://github.com/OZI-Project/OZI/commit/629c3c941b32c3e68f2b9b0d29c2325b00d17756))

* Update dist-workflow.yml

Signed-off-by: Eden Rose, MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`5061a6c`](https://github.com/OZI-Project/OZI/commit/5061a6c3b55babfa9444a548a68e8faad5356c67))

* Update dependabot.yml

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`d9288e1`](https://github.com/OZI-Project/OZI/commit/d9288e1bf9a7db07963e73f4bfd1e60c0609dedd))

* Update dependabot.yml

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`3d1afce`](https://github.com/OZI-Project/OZI/commit/3d1afceec4651757cc0b797cd03e0e2c08c5074b))

* Bump actions/upload-artifact from 4.2.0 to 4.3.0

Bumps [actions/upload-artifact](https://github.com/actions/upload-artifact) from 4.2.0 to 4.3.0.
- [Release notes](https://github.com/actions/upload-artifact/releases)
- [Commits](https://github.com/actions/upload-artifact/compare/694cdabd8bdb0f10b2cea11669e1bf5453eed0a6...26f96dfa697d77e81fd5907df203aa23a56210a8)

---
updated-dependencies:
- dependency-name: actions/upload-artifact
  dependency-type: direct:production
  update-type: version-update:semver-minor
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`8f0aed0`](https://github.com/OZI-Project/OZI/commit/8f0aed074c61a065782ecfc5e71d42ee55ee780f))

* :construction_worker: Update scorecard.yml

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`3676437`](https://github.com/OZI-Project/OZI/commit/36764372a655d3d51960846270c50a788003cf08))

## 0.0.261 (2024-01-23)

### :hammer:

* :hammer:: Merge pull request #100 from OZI-Project/0.0

Merge pull request #99 from OZI-Project/main ([`a1cb31a`](https://github.com/OZI-Project/OZI/commit/a1cb31a8ed3f48ca0b09fabb57c2400414891195))

### Other

* 👷 🔨 : Add egress block allowlist for release and publish. ([`aac44be`](https://github.com/OZI-Project/OZI/commit/aac44be171446a04ee39dc42e7709a5922711044))

* :construction_worker:: Update dev-workflow.yml to run on all branches on PR.

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`c1796e9`](https://github.com/OZI-Project/OZI/commit/c1796e989d40731ba41b647cb25ad223beff6f35))

## 0.0.260 (2024-01-21)

### :hammer:

* :hammer:: Fix SLSA generation by using the output release tag. ([`879b7a3`](https://github.com/OZI-Project/OZI/commit/879b7a397ad60a2d2a7e854d250bd0a04ed8883b))

### Other

* Update dev-workflow.yml to run on any branch.

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`9a126f4`](https://github.com/OZI-Project/OZI/commit/9a126f4a80205fadce0858be56947245a1550422))

* Update dev-workflow.yml

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`1f39913`](https://github.com/OZI-Project/OZI/commit/1f39913087af1eb979e309d8a49ecfebce09307e))

* :memo:: Update SECURITY.md 

Move workflows policy to bottom.

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`b071807`](https://github.com/OZI-Project/OZI/commit/b071807b97dada21eefcd09fcfa2e1ee0e9b5dff))

* :memo:: Update SECURITY.md

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`aa9dfbd`](https://github.com/OZI-Project/OZI/commit/aa9dfbd801d5c4460969d7fa9d4ed0e5dd4de03f))

## 0.0.259 (2024-01-21)

### :arrow_up:

* :arrow_up: Bump github/codeql-action from 3.23.0 to 3.23.1

Bumps [github/codeql-action](https://github.com/github/codeql-action) from 3.23.0 to 3.23.1.
- [Release notes](https://github.com/github/codeql-action/releases)
- [Changelog](https://github.com/github/codeql-action/blob/main/CHANGELOG.md)
- [Commits](https://github.com/github/codeql-action/compare/e5f05b81d5b6ff8cfa111c80c22c5fd02a384118...0b21cf2492b6b02c465a3e5d7c473717ad7721ba)

---
updated-dependencies:
- dependency-name: github/codeql-action
  dependency-type: direct:production
  update-type: version-update:semver-patch
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`13aa5e1`](https://github.com/OZI-Project/OZI/commit/13aa5e1725832c6dd9f92f89c9ba7a5e36e3bb93))

* :arrow_up: Bump actions/upload-artifact from 4.0.0 to 4.1.0

Bumps [actions/upload-artifact](https://github.com/actions/upload-artifact) from 4.0.0 to 4.1.0.
- [Release notes](https://github.com/actions/upload-artifact/releases)
- [Commits](https://github.com/actions/upload-artifact/compare/c7d193f32edcb7bfad88892161225aeda64e9392...1eb3cb2b3e0f29609092a73eb033bb759a334595)

---
updated-dependencies:
- dependency-name: actions/upload-artifact
  dependency-type: direct:production
  update-type: version-update:semver-minor
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`dcb65a1`](https://github.com/OZI-Project/OZI/commit/dcb65a10888cb6038b577ab99be63a1cfc071458))

### :hammer:

* :hammer:: Add generate-provenance step template ([`c612e68`](https://github.com/OZI-Project/OZI/commit/c612e680c031ccacbfc4900675d8d50960795220))

* :construction_worker::hammer:: Correct use of reusable workflow for SLSA generation. ([`b8c97f5`](https://github.com/OZI-Project/OZI/commit/b8c97f5d1127894f57716e86e90143ddfa4c2fa3))

* :hammer:: Attempt to add SLSA provenance to publish step. ([`7a0bf0c`](https://github.com/OZI-Project/OZI/commit/7a0bf0cdb0e0bc5941c3c2cc1059fe34c42b4de8))

* :hammer:: Update egress policy to include artifact store ([`d80d453`](https://github.com/OZI-Project/OZI/commit/d80d453e373aca3dfcd25e51d300acbed081a237))

* :hammer:: set checkpoint egress policy. ([`b2bd306`](https://github.com/OZI-Project/OZI/commit/b2bd3062275bab2bdd1c6bcbe0e8d7bfa00d8268))

* :hammer::construction_worker:: Fix workflow hardener to run outside our actions. ([`57b284e`](https://github.com/OZI-Project/OZI/commit/57b284e5a073c075b8e38bb34145dac8ca87efa8))

* :hammer:: Implement hardened runner in workflow output. ([`5c47aff`](https://github.com/OZI-Project/OZI/commit/5c47aff6baa775a300c56b1317aef52180d7e0e9))

### Other

* :construction_worker:: Pin reusable SLSA generator version. ([`f54c869`](https://github.com/OZI-Project/OZI/commit/f54c869580c36732cf09f003b22941d5359a2d0e))

* :construction_worker:: Use external SLSA workflows by setting org permissions. ([`154ac13`](https://github.com/OZI-Project/OZI/commit/154ac13f429095ae8d1e16e5d9983ef8edab97ed))

* :construction_worker:: Use organization fork of SLSA generator. ([`e1ca493`](https://github.com/OZI-Project/OZI/commit/e1ca4930ee984b6e228b238301f7a9db5f76ebb2))

* Update README.rst

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`52bd96c`](https://github.com/OZI-Project/OZI/commit/52bd96ceac2f4e43071b95ca6996683d23e01315))

* Bump actions/upload-artifact from 4.1.0 to 4.2.0

Bumps [actions/upload-artifact](https://github.com/actions/upload-artifact) from 4.1.0 to 4.2.0.
- [Release notes](https://github.com/actions/upload-artifact/releases)
- [Commits](https://github.com/actions/upload-artifact/compare/1eb3cb2b3e0f29609092a73eb033bb759a334595...694cdabd8bdb0f10b2cea11669e1bf5453eed0a6)

---
updated-dependencies:
- dependency-name: actions/upload-artifact
  dependency-type: direct:production
  update-type: version-update:semver-minor
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`02082e8`](https://github.com/OZI-Project/OZI/commit/02082e87def0ccab00db8fcac9fdb6b5efeff58d))

* Bump actions/dependency-review-action from 3.1.5 to 4.0.0

Bumps [actions/dependency-review-action](https://github.com/actions/dependency-review-action) from 3.1.5 to 4.0.0.
- [Release notes](https://github.com/actions/dependency-review-action/releases)
- [Commits](https://github.com/actions/dependency-review-action/compare/c74b580d73376b7750d3d2a50bfb8adc2c937507...4901385134134e04cec5fbe5ddfe3b2c5bd5d976)

---
updated-dependencies:
- dependency-name: actions/dependency-review-action
  dependency-type: direct:production
  update-type: version-update:semver-major
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`c0bf369`](https://github.com/OZI-Project/OZI/commit/c0bf3698145da958a1a47174bc8a157988e38c09))

* Update CODEOWNERS

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`568b8b0`](https://github.com/OZI-Project/OZI/commit/568b8b0f68090f00a22d80b913d22e378dae45e9))

* Update CODEOWNERS

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`4331d11`](https://github.com/OZI-Project/OZI/commit/4331d11b75bdde85ccbb654532d87b969e777fe1))

* Update CODEOWNERS

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`90fbeff`](https://github.com/OZI-Project/OZI/commit/90fbeff45a8f9136eb13716274b42693e18c4b7a))

* Update CODEOWNERS

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`eb5a856`](https://github.com/OZI-Project/OZI/commit/eb5a8563957ee3f95f6c25a4c1343eb2a560b949))

* Update CODEOWNERS

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`13afc2d`](https://github.com/OZI-Project/OZI/commit/13afc2d7ae6150999da06d127aa8456fa69a1c5d))

* Create CODEOWNERS

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`c86f348`](https://github.com/OZI-Project/OZI/commit/c86f348be858aa4085e8073707d84697dca7b93e))

* Update FUNDING.yml

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`4eab163`](https://github.com/OZI-Project/OZI/commit/4eab1637529b24f4918a634b6ab584939fb4f2c0))

* Update codeql.yml

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`9da5638`](https://github.com/OZI-Project/OZI/commit/9da563834ba09732bb8c5c7fbc66f1d841e7f39e))

* [StepSecurity] ci: Harden GitHub Actions

Signed-off-by: StepSecurity Bot &lt;bot@stepsecurity.io&gt; ([`a269af7`](https://github.com/OZI-Project/OZI/commit/a269af72df76a8c421b5e51ba086a795552b3a22))

* 0.0 merge (#48)

* 0.0.255

Automatically generated by python-semantic-release

* 0.0.256

Automatically generated by python-semantic-release

* 0.0.257

Automatically generated by python-semantic-release

* 0.0.258

Automatically generated by python-semantic-release

---------

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt;
Co-authored-by: github-actions &lt;github-actions@github.com&gt; ([`f8805d4`](https://github.com/OZI-Project/OZI/commit/f8805d4e2c14621f79150b85f1987d9af564b99a))

## 0.0.258 (2024-01-12)

### :arrow_up:

* :arrow_up:: Bump OZI-Project/release.

New pin: cde53aa6ef204695f7a5b4d5debc5bf696846cf1 ([`040f029`](https://github.com/OZI-Project/OZI/commit/040f02967a56930bf6b3edc8f25a832969f1a694))

### Other

* 0.0 release tags (#47)

* 0.0.255

Automatically generated by python-semantic-release

* 0.0.256

Automatically generated by python-semantic-release

* 0.0.257

Automatically generated by python-semantic-release

---------

Co-authored-by: github-actions &lt;github-actions@github.com&gt; ([`135a07b`](https://github.com/OZI-Project/OZI/commit/135a07bc74c93b2530d408518275a154ad1e84c6))

## 0.0.257 (2024-01-12)

### :arrow_up:

* :arrow_up:: bump checkpoint workflow pin ([`ce2626f`](https://github.com/OZI-Project/OZI/commit/ce2626f5f3a47a43912a659e93e59c6576e8d00a))

## 0.0.256 (2024-01-11)

### :arrow_up:

* :arrow_up: Bump github/codeql-action from 3.22.12 to 3.23.0

Bumps [github/codeql-action](https://github.com/github/codeql-action) from 3.22.12 to 3.23.0.
- [Release notes](https://github.com/github/codeql-action/releases)
- [Changelog](https://github.com/github/codeql-action/blob/main/CHANGELOG.md)
- [Commits](https://github.com/github/codeql-action/compare/012739e5082ff0c22ca6d6ab32e07c36df03c4a4...e5f05b81d5b6ff8cfa111c80c22c5fd02a384118)

---
updated-dependencies:
- dependency-name: github/codeql-action
  dependency-type: direct:production
  update-type: version-update:semver-minor
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`fe3466d`](https://github.com/OZI-Project/OZI/commit/fe3466d54b2b6d615fd51bf7f66edcd9352a3bba))

* :arrow_up: Bump github/codeql-action from 3.22.12 to 3.23.0

Bumps [github/codeql-action](https://github.com/github/codeql-action) from 3.22.12 to 3.23.0.
- [Release notes](https://github.com/github/codeql-action/releases)
- [Changelog](https://github.com/github/codeql-action/blob/main/CHANGELOG.md)
- [Commits](https://github.com/github/codeql-action/compare/012739e5082ff0c22ca6d6ab32e07c36df03c4a4...e5f05b81d5b6ff8cfa111c80c22c5fd02a384118)

---
updated-dependencies:
- dependency-name: github/codeql-action
  dependency-type: direct:production
  update-type: version-update:semver-minor
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`8288ad4`](https://github.com/OZI-Project/OZI/commit/8288ad4442fff8f8aa78b844f4917b322f4559dc))

### Other

* :memo:: Create FUNDING.yml

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`62f46be`](https://github.com/OZI-Project/OZI/commit/62f46bed149b97bb14337ae336872bd149a1eeaf))

* :construction_worker::(StepSecurity): Harden GitHub Actions

Signed-off-by: StepSecurity Bot &lt;bot@stepsecurity.io&gt; ([`52f5342`](https://github.com/OZI-Project/OZI/commit/52f5342fb445c7e04ce554434f0ec56e4acc4cb1))

## 0.0.255 (2024-01-07)

### :arrow_up:

* :arrow_up: Bump actions/upload-artifact from 3.1.0 to 4.0.0

Bumps [actions/upload-artifact](https://github.com/actions/upload-artifact) from 3.1.0 to 4.0.0.
- [Release notes](https://github.com/actions/upload-artifact/releases)
- [Commits](https://github.com/actions/upload-artifact/compare/3cea5372237819ed00197afe530f5a7ea3e805c8...c7d193f32edcb7bfad88892161225aeda64e9392)

---
updated-dependencies:
- dependency-name: actions/upload-artifact
  dependency-type: direct:production
  update-type: version-update:semver-major
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`c8f77c8`](https://github.com/OZI-Project/OZI/commit/c8f77c89d1809ee19434a6ef61cbbca6a9614a30))

* :arrow_up: Bump actions/dependency-review-action from 2.5.1 to 3.1.5

Bumps [actions/dependency-review-action](https://github.com/actions/dependency-review-action) from 2.5.1 to 3.1.5.
- [Release notes](https://github.com/actions/dependency-review-action/releases)
- [Commits](https://github.com/actions/dependency-review-action/compare/0efb1d1d84fc9633afcdaad14c485cbbc90ef46c...c74b580d73376b7750d3d2a50bfb8adc2c937507)

---
updated-dependencies:
- dependency-name: actions/dependency-review-action
  dependency-type: direct:production
  update-type: version-update:semver-major
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`1ef8ec2`](https://github.com/OZI-Project/OZI/commit/1ef8ec22878c794ab13685a2a08865a947abd23a))

* :arrow_up: Bump ossf/scorecard-action from 2.1.2 to 2.3.1

Bumps [ossf/scorecard-action](https://github.com/ossf/scorecard-action) from 2.1.2 to 2.3.1.
- [Release notes](https://github.com/ossf/scorecard-action/releases)
- [Changelog](https://github.com/ossf/scorecard-action/blob/main/RELEASE.md)
- [Commits](https://github.com/ossf/scorecard-action/compare/e38b1902ae4f44df626f11ba0734b14fb91f8f86...0864cf19026789058feabb7e87baa5f140aac736)

---
updated-dependencies:
- dependency-name: ossf/scorecard-action
  dependency-type: direct:production
  update-type: version-update:semver-minor
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`bc0d3fd`](https://github.com/OZI-Project/OZI/commit/bc0d3fdecc1f296fcb8098ce8cab103cc4a043fe))

* :arrow_up: Bump github/codeql-action from 2.2.4 to 3.22.12

Bumps [github/codeql-action](https://github.com/github/codeql-action) from 2.2.4 to 3.22.12.
- [Release notes](https://github.com/github/codeql-action/releases)
- [Changelog](https://github.com/github/codeql-action/blob/main/CHANGELOG.md)
- [Commits](https://github.com/github/codeql-action/compare/v2.2.4...012739e5082ff0c22ca6d6ab32e07c36df03c4a4)

---
updated-dependencies:
- dependency-name: github/codeql-action
  dependency-type: direct:production
  update-type: version-update:semver-major
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`3aba574`](https://github.com/OZI-Project/OZI/commit/3aba57406c2e5e51d42a1f3a5e4e3aa15958d98e))

* :arrow_up: Bump actions/checkout from 3.1.0 to 4.1.1

Bumps [actions/checkout](https://github.com/actions/checkout) from 3.1.0 to 4.1.1.
- [Release notes](https://github.com/actions/checkout/releases)
- [Changelog](https://github.com/actions/checkout/blob/main/CHANGELOG.md)
- [Commits](https://github.com/actions/checkout/compare/v3.1.0...b4ffde65f46336ab88eb53be808477a3936bae11)

---
updated-dependencies:
- dependency-name: actions/checkout
  dependency-type: direct:production
  update-type: version-update:semver-major
...

Signed-off-by: dependabot[bot] &lt;support@github.com&gt; ([`bad22f6`](https://github.com/OZI-Project/OZI/commit/bad22f696459ec672790bf1f2404075ab19990db))

### :hammer:

* :lock::hammer::construction_worker:: Add security best practices recommendations.

[StepSecurity] Apply security best practices

Signed-off-by: StepSecurity Bot &lt;bot@stepsecurity.io&gt; ([`649b499`](https://github.com/OZI-Project/OZI/commit/649b4999ce8ed725d8b778e0a135e5a4acdeb9ca))

* :hammer:: Add a dev branch matching checkpoint workflow. ([`42c9902`](https://github.com/OZI-Project/OZI/commit/42c990278bdcb316f969688a88e4e97f5f0fca8f))

### :pushpin:

* :pushpin:: Pin workflows to commit hash. ([`a5a445d`](https://github.com/OZI-Project/OZI/commit/a5a445da64cc63f6e5a4352c71f934e31b328240))

### Other

* :memo:: Update security policy. ([`86d0a7a`](https://github.com/OZI-Project/OZI/commit/86d0a7a5087b4265ec99215eb32e46971414fc0c))

* :memo:: Add security contact email. ([`f1604fe`](https://github.com/OZI-Project/OZI/commit/f1604fec8d061ecb42b5fbf75b7dc703331f7da9))

## 0.0.254 (2024-01-06)

### :hammer:

* :hammer:: 0.0.254 re-release. ([`8fd45c3`](https://github.com/OZI-Project/OZI/commit/8fd45c3a8c81395875467e9fbb4b4ae567865de2))

## 0.0.253 (2024-01-05)

### :hammer:

* :hammer:: 0.0.253 force re-release ([`b365dd3`](https://github.com/OZI-Project/OZI/commit/b365dd348e528bfd2c5a91475617a54497f4c5e1))

## 0.0.252 (2024-01-05)

### :hammer:

* :hammer:: Re-release 0.0.252 ([`76b313f`](https://github.com/OZI-Project/OZI/commit/76b313ff083979966c0c1fffbc6adb22a9afd9d3))

* :hammer:: Add 0.0 branch to semantic-release. ([`cadef25`](https://github.com/OZI-Project/OZI/commit/cadef257dc6dab6a09c3736364a607155b6e5fed))

* :hammer:: Add signing step to publish workflow job. ([`5faccdd`](https://github.com/OZI-Project/OZI/commit/5faccdd27229606beda5d92f888f8a105177b12b))

* :hammer:: adjust workflow permissions and broaden codeql to run on any commit. ([`b28260b`](https://github.com/OZI-Project/OZI/commit/b28260b62fe60a7c7a8e954dbdef17b27c289807))

* :hammer::construction_worker:: Integrate step-security recommended workflows. (#9) ([`5394bf8`](https://github.com/OZI-Project/OZI/commit/5394bf812d011da0c031eb21d83597a7bacf17c5))

### Other

* 0.0.254 ([`1bec575`](https://github.com/OZI-Project/OZI/commit/1bec575d6132bc481c4f3adfdbd1dbefa4023360))

* 0.0.253 ([`f4eaf3f`](https://github.com/OZI-Project/OZI/commit/f4eaf3fcd31939c8800ac5ac40da47d7a11094c8))

* 0.0.252 ([`a559207`](https://github.com/OZI-Project/OZI/commit/a559207cf284e1c7e73774dfdd6a9be318f2061f))

* 0.0.x changes (#11)

* :hammer::construction_worker:: Integrate step-security recommended workflows.

* :hammer:: Publish from an unprotected branch.

* :hammer:: Update workflow to run in release branch.

* :hammer::pencil2:: Fix duplicated toml key.

* 0.0.252

Automatically generated by python-semantic-release

* :hammer::construction_worker:: Change branch match pattern.

* 0.0.253

Automatically generated by python-semantic-release

* 0.0.254

Automatically generated by python-semantic-release

* Update CHANGELOG.md

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt;

* 0.0.254

Automatically generated by python-semantic-release

---------

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt;
Co-authored-by: github-actions &lt;github-actions@github.com&gt; ([`52819c0`](https://github.com/OZI-Project/OZI/commit/52819c0863bf3695402c0a762e3d8a21fe89dbb6))

* 0.0.252 changes (#10)

* :hammer::construction_worker:: Integrate step-security recommended workflows.

* :hammer:: Publish from an unprotected branch.

* :hammer:: Update workflow to run in release branch.

* :hammer::pencil2:: Fix duplicated toml key.

* 0.0.252

Automatically generated by python-semantic-release

---------

Co-authored-by: github-actions &lt;github-actions@github.com&gt; ([`8e13fef`](https://github.com/OZI-Project/OZI/commit/8e13fef439525cbcfa146e5dbdc3eacef235c0bc))

## 0.0.251 (2024-01-04)

### :hammer:

* :hammer:: Fix test file names. ([`809eaa4`](https://github.com/OZI-Project/OZI/commit/809eaa459e74c8e48178817df18d16a214268596))

* :hammer:: Harden workflow. ([`42cea2c`](https://github.com/OZI-Project/OZI/commit/42cea2c8ce432ef99445c0409e9668a22d19d0f1))

### Other

* :rotating_light: Fix lint issues. ([`0525cbc`](https://github.com/OZI-Project/OZI/commit/0525cbc648bd6459c58082496d1bd4a2fb677b1f))

* Update dependabot.yml

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`c64bea7`](https://github.com/OZI-Project/OZI/commit/c64bea76c1ae4dff5b9aa100c0a6ec45f3320683))

* Create dependabot.yml

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`8ced901`](https://github.com/OZI-Project/OZI/commit/8ced9015f694ee824c54392c7b1935838a65b7e1))

* Create scorecard.yml

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`3df9150`](https://github.com/OZI-Project/OZI/commit/3df915051f2e413492e24dc86a02e6580fa0fc36))

## 0.0.250 (2024-01-02)

### :hammer:

* :hammer:(ozi-new): Set semantic-release remote type based on ``ci-provider``. ([`c007e1f`](https://github.com/OZI-Project/OZI/commit/c007e1fa9634609abe1412131a5f26ba362a4a24))

### Other

* :rotating_light:: Fix lint. ([`93843cb`](https://github.com/OZI-Project/OZI/commit/93843cb2d8d6f5d0eb767594ca552d0333eef1a6))

## 0.0.249 (2023-12-31)

### :hammer:

* :hammer::construction_worker:(ozi-new): Output workflow with official github actions. ([`6d3e772`](https://github.com/OZI-Project/OZI/commit/6d3e772bb95da3f010070a1dd81780681aa6f34f))

### Other

* :memo:: Update readme with link to contributing. ([`204215a`](https://github.com/OZI-Project/OZI/commit/204215a0f084dec657849eaac1b18d12f1df1941))

* :memo:: Move readme contributing section to CONTRIBUTING.md ([`90615c7`](https://github.com/OZI-Project/OZI/commit/90615c7b188c8d3c79a6b064680a96f09045edd9))

## 0.0.248 (2023-12-30)

### :bug:

* :bug: force bump. ([`426e20c`](https://github.com/OZI-Project/OZI/commit/426e20cd287eaf74703b5c7fa2a5fcf4771697ae))

* :bug: Force release. ([`7199470`](https://github.com/OZI-Project/OZI/commit/719947047224e652256a90a446a36e201b4a843e))

### :hammer:

* :hammer:: Fix workflow secrets handling. ([`8f83999`](https://github.com/OZI-Project/OZI/commit/8f839992763b3c4c503b85673de8a557bf68a927))

* :hammer:: Try new streamlined github CI. ([`7949809`](https://github.com/OZI-Project/OZI/commit/79498096c635ec42597b05409ecf7bfdb82a217c))

### Other

* :memo:: Clarify CI process in readme. ([`8b4e4d3`](https://github.com/OZI-Project/OZI/commit/8b4e4d3224962414faabc2d2c51f93130058a7a1))

* :memo:: Update readme. ([`8f9fd3b`](https://github.com/OZI-Project/OZI/commit/8f9fd3bcb1b7a467b28a098dd07e3fab2ca8e6ea))

* :memo:: Update readme. ([`5aeede8`](https://github.com/OZI-Project/OZI/commit/5aeede8d9e07b44b959d026f435d201f3c76f613))

* :memo:: Edit readme. ([`58e5b9a`](https://github.com/OZI-Project/OZI/commit/58e5b9afc5237ffaa66b51a064ca607fb05672b6))

## 0.0.247 (2023-12-28)

### :bug:

* :pushpin::bug:: Pin semantic-release to 8.7.0 and enable trusted publishing workflow. ([`d40a58a`](https://github.com/OZI-Project/OZI/commit/d40a58afad9150f926ed6db365536aa05d20043b))

## 0.0.246 (2023-12-28)

### :bug:

* :bug:: Install utility requirements from ``meson.project_build_root()`` ([`0618f0c`](https://github.com/OZI-Project/OZI/commit/0618f0c3652bafc4981c7f00a01da730b78dc677))

## 0.0.245 (2023-12-27)

### :bug:

* :bug:: Run pip-compile at config time. ([`ebe8445`](https://github.com/OZI-Project/OZI/commit/ebe8445034159726675799321312740ad3febf25))

### :pencil2:

* :pencil2:: Fix custom_target --&gt; configure_file for pyright requirements.txt. ([`bc02394`](https://github.com/OZI-Project/OZI/commit/bc02394bb9dde7073847fc14a9b818ef6710f09e))

## 0.0.244 (2023-12-27)

### :hammer:

* :construction_worker::hammer:: Build requirements.txt at configure time. ([`9765aab`](https://github.com/OZI-Project/OZI/commit/9765aab0ad30b47566d69e7d944156f07f4a7604))

## 0.0.243 (2023-12-23)

### :bug:

* :bug:(ozi-fix): Run comment diagnostic over source *.py files. ([`0709abc`](https://github.com/OZI-Project/OZI/commit/0709abc82c02e258d5bdb0214fa2a9f9c9dff162))

## 0.0.242 (2023-12-23)

### :hammer:

* :hammer::construction_worker:(ozi-new): New meson build dir for each wheel ([`d27b72e`](https://github.com/OZI-Project/OZI/commit/d27b72e8d0ad4b456b4465e67b2e482b650ceac8))

## 0.0.241 (2023-12-23)

### :hammer:

* :hammer:: Build sdist from bugfix1 whl ([`2c08b9c`](https://github.com/OZI-Project/OZI/commit/2c08b9c6bd21c627be83c54bf7bceffd312195b5))

* :pushpin::construction_worker::hammer:(ozi-new): Pin workflow utilities. ([`70d2304`](https://github.com/OZI-Project/OZI/commit/70d230417fc499369d53169c007bbd408e0c7410))

### :pencil2:

* :pencil2:: fix bullet points README.rst

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`0d7ca02`](https://github.com/OZI-Project/OZI/commit/0d7ca027fc2000ac10ee860851fc1aff79633b7f))

### Other

* :memo:: Simplify readme layout. ([`814b773`](https://github.com/OZI-Project/OZI/commit/814b773743a799e33951a22097b14cabd2ec113d))

* :memo:: clean up README.rst 

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`47a7288`](https://github.com/OZI-Project/OZI/commit/47a7288e380d73368e2931e62b7c2ab8f33ef797))

## 0.0.240 (2023-12-21)

### :bug:

* :bug:: Fix dist workflow for artifact v4. ([`1c8b5b6`](https://github.com/OZI-Project/OZI/commit/1c8b5b6a2b7b7889afe83fd2cff7823bd907f8ba))

### :pushpin:

* :pushpin::construction_worker:: Pin workflow action versions in dist. ([`3f0edb9`](https://github.com/OZI-Project/OZI/commit/3f0edb9dd94f49efcec51f9a0a18f8516a2e18c4))

### Other

* Update CODE_OF_CONDUCT.md

Signed-off-by: Ross J. Duff(Eden Rose), MSc &lt;42073607+rjdbcm@users.noreply.github.com&gt; ([`edddbca`](https://github.com/OZI-Project/OZI/commit/edddbca7aa9feb7bd196dc0fb6a93cbc3ee9dc9a))

## 0.0.239 (2023-12-19)

### :bug:

* :bug::construction_worker:: No real need to run checkpoints on macos-latest. ([`a37c838`](https://github.com/OZI-Project/OZI/commit/a37c8385bcccca57a225bcbf93b480ae7f34a1b5))

### :pushpin:

* :pushpin::construction_worker:: Pin actions/upload-artifact to v3 for checkpoint. ([`c72a99a`](https://github.com/OZI-Project/OZI/commit/c72a99a3ef801d97f2be53e5d9749849d8d09695))

### Other

* :page_facing_up:: Update license to include LLVM exception text. ([`8626688`](https://github.com/OZI-Project/OZI/commit/862668885998003d3297a2b02beaf401869ec9ba))

## 0.0.238 (2023-12-18)

### :bug:

* :bug::construction_worker:: set sigstore output directory. ([`97a45a0`](https://github.com/OZI-Project/OZI/commit/97a45a0ae975a1345bfc8d252fe89992a8a39600))

* :bug:: Pin upload-artifact to v3 to fix broken publish workflow. ([`13eca77`](https://github.com/OZI-Project/OZI/commit/13eca773da591776fd984843db4d72c1162d54d2))

* :bug:: Revert CIBW experiment. ([`b0c94bf`](https://github.com/OZI-Project/OZI/commit/b0c94bf5258faf443b5c8714a2b906507d036bb4))

* :bug:: Don&#39;t run pip install --user for CIBW. ([`d0f3b5b`](https://github.com/OZI-Project/OZI/commit/d0f3b5b1949c78b278ad32f681c9383794fa23f3))

* :bug: Try to fix CIBW versioning. ([`d8cf99b`](https://github.com/OZI-Project/OZI/commit/d8cf99bcef699d128c864f1454af58f7f3b59977))

* :bug:: Limit wheel builds to supported versions. ([`708043a`](https://github.com/OZI-Project/OZI/commit/708043aee241202fce385e4e6228701540895195))

* :bug:: Attempt to simplify CI build process. ([`1b1571c`](https://github.com/OZI-Project/OZI/commit/1b1571ccb71d29e119996bbd503bbb1471a1f585))

### Other

* :construction_worker:: Use static CIBW configuration. ([`f91e1df`](https://github.com/OZI-Project/OZI/commit/f91e1df7abed2732c8c15e3932e87c3746652aa1))

* :construction_worker: Bump CIBW. ([`8d2aefa`](https://github.com/OZI-Project/OZI/commit/8d2aefa93692ae085e19a437a73ba7846110ba99))

## 0.0.237 (2023-12-16)

### :bug:

* :bug:: Try to fix release workflow. ([`129d70a`](https://github.com/OZI-Project/OZI/commit/129d70af588aeb6df6ee3984c3012924f58662c1))

### Other

* :rotating_light:: Fix pyright false alarm. ([`3169ed2`](https://github.com/OZI-Project/OZI/commit/3169ed25219721e8d4886125fb8f8e4a9152991a))

## 0.0.236 (2023-12-15)

### :alembic:

* :bug::alembic:: Attempt to fix workflow. ([`b6d6634`](https://github.com/OZI-Project/OZI/commit/b6d663455221e90c0be35df227bf5fd2b829c81c))

### :bug:

* :bug:: Try to fix artifact download issue. ([`045441d`](https://github.com/OZI-Project/OZI/commit/045441d1d8ba9534855b06e0c983b91a9d57a755))

* :bug:: Fix tox fix template. ([`eca8bf2`](https://github.com/OZI-Project/OZI/commit/eca8bf294ed768bcd6b1b0a2ab3d5c3239572a1d))

* :bug:: Fix accidental inclusion of non-existing template. ([`97dae1d`](https://github.com/OZI-Project/OZI/commit/97dae1dd7ca0e4d0ac027c6dab93af934a4c4c68))

* :bug: Fix some bugs discovered during integration testing. ([`bcf5540`](https://github.com/OZI-Project/OZI/commit/bcf5540f14d1b9ea780349bedcf062f373a30228))

### Other

* :rotating_light:: Fix coverage. ([`8938456`](https://github.com/OZI-Project/OZI/commit/89384560f1c4491e620514e89b1293f0c70cb33b))

## 0.0.235 (2023-12-13)

### :bug:

* :bug:(ozi-new): Properly template upper bound Python-Support. ([`ebd2f25`](https://github.com/OZI-Project/OZI/commit/ebd2f25af910e4742345302617775929456c7285))

## 0.0.234 (2023-12-13)

### :bug:

* :pencil2::bug:(ozi-fix): Remove debug print. ([`9dbe921`](https://github.com/OZI-Project/OZI/commit/9dbe921f71157e15ddd0b8b8631a559c4b5b4400))

## 0.0.233 (2023-12-13)

### :bug:

* :bug:(ozi-fix, ozi-new): Fix PKG-INFO rendering for ``setuptools_scm`` version 8. ([`07be62f`](https://github.com/OZI-Project/OZI/commit/07be62f6680f2639c8fd0da06144936634212b05))

## 0.0.232 (2023-12-13)

### :bug:

* :bug:(ozi-new): Fix PKG-INFO:Requires-Python ceiling. ([`813b17b`](https://github.com/OZI-Project/OZI/commit/813b17b1024d795555769386bbba7c9a85d122fd))

* :bug:(ozi-fix): Fix README path for PKG-INFO render. ([`2f04204`](https://github.com/OZI-Project/OZI/commit/2f04204433b218ef7f2c481452b16559778a204b))

## 0.0.231 (2023-12-12)

### :bug:

* :bug:(ozi-fix): Fix metadata retrieval for missing command. ([`4a8fce4`](https://github.com/OZI-Project/OZI/commit/4a8fce44e95981fe4efc6a2b73c358913eda7bed))

## 0.0.230 (2023-12-12)

### :bug:

* :bug:: Workaround for dist script python version issue in mesonpep517. ([`0d60fb4`](https://github.com/OZI-Project/OZI/commit/0d60fb444bcd64d3d99904a4111d989fb73428ac))

* :bug:: Fix release sdist. ([`af87ddf`](https://github.com/OZI-Project/OZI/commit/af87ddf429845d9f6c8b19137732f59b976157dc))

* :bug:: Still need to install local before sdist build. ([`e15d773`](https://github.com/OZI-Project/OZI/commit/e15d77323549c4e4f93e52544f8cb87a3c616133))

* :bug:: Fix sdist build invocation. ([`33626d6`](https://github.com/OZI-Project/OZI/commit/33626d6f8085aa9b32326e578b22dd34bbf10ed1))

* :bug:: Remove tomli from sanity check deps. ([`c02c26d`](https://github.com/OZI-Project/OZI/commit/c02c26d3abcfddef29414afb7cccf9ae60d6d0a0))

* :bug:: Correct version_info import guards. ([`fd749fa`](https://github.com/OZI-Project/OZI/commit/fd749fad6a2d97077b5c4d945f4a9189103c25d8))

* :bug:: Simplify PKG-INFO deployment and add a meson-log.txt to checkpoint workflow failure printing. ([`a0b9a26`](https://github.com/OZI-Project/OZI/commit/a0b9a268737ff8d4eabd28460b9cfe41b664b5e1))

* :bug: Partial revert of last commit.

Remove ``sync_pkg_readme.py`` script.
Store a truncated ``PKG-INFO`` file in the project root called ``PKG-INFO.ozi``, this is a fallback to allow for local installation of OZI with ``pip install .``.
Meson uses ``vcs_tag`` to write the SCM supplied version tag. ([`1ebc27f`](https://github.com/OZI-Project/OZI/commit/1ebc27f2f3fae0312f69eb9b7f0ce64f7c48ac67))

### :hammer:

* :hammer:(ozi-new,ozi-fix,spec): PKG-INFO now concealed in build system rather than being at the project root.

This is fairly standard although explicit PKG-INFO configuration-time template is provided in ``[tool.setuptools_scm]`` and configured by the ``ozi-new`` rendered build script.

The string ``@README_TEXT@`` is replaced with the contents of ``README.rst`` at meson configuration-time. ([`546f74d`](https://github.com/OZI-Project/OZI/commit/546f74da81a807ceb2259199a8209c5420ef7790))

### :pencil2:

* :pencil2:: Fix some no cover comments. ([`d8f79c6`](https://github.com/OZI-Project/OZI/commit/d8f79c66fc168a697f4bf3cd0711790bda603365))

* :pencil2:: Fix PKG-INFO, deployment at build config time only. ([`18b2995`](https://github.com/OZI-Project/OZI/commit/18b299521d08105450e60e2668d11a8b98a8f702))

### Other

* :construction_worker: patch in tomli for bug in mesonpep517. ([`5ce8bc8`](https://github.com/OZI-Project/OZI/commit/5ce8bc8c380af128318a11e68bcf12a50c7505f8))

* :construction_worker:: Deploy PKG-INFO into dist source tarball. ([`87019b0`](https://github.com/OZI-Project/OZI/commit/87019b096842d54185094ea6dfa6ca46aa1d9cec))

* Make sure PKG-INFO is in sdist. ([`4b7f4da`](https://github.com/OZI-Project/OZI/commit/4b7f4da56f227c65fba5a6b2996612866c09d4a3))

* :construction_worker:: Add mesonpep517 install to release env. ([`e5894f1`](https://github.com/OZI-Project/OZI/commit/e5894f1aed2e68db299888b06a5547ca1d9c2ca1))

* :construction_worker:: Turn build isolation off for sdist. ([`7e69072`](https://github.com/OZI-Project/OZI/commit/7e6907202bd69aa74a45a360218445181e300a25))

* Run formatter. ([`65e79a5`](https://github.com/OZI-Project/OZI/commit/65e79a54e39991c3ccef6e6ac2e0782c5b3bdbfe))

## 0.0.229 (2023-12-05)

### :bug:

* :bug:(ozi-new): Fix github workflow duplicate id. ([`1ccd73c`](https://github.com/OZI-Project/OZI/commit/1ccd73c11bd610e1f6f5649495bebb220f670833))

## 0.0.228 (2023-12-04)

### :bug:

* :bug:(ozi-new): Fix spec field typo and tox invocation for checkpoint retries. ([`692207f`](https://github.com/OZI-Project/OZI/commit/692207f060a57002421a822c6ac9a2168162d654))

## 0.0.227 (2023-12-03)

### :bug:

* :bug:(ozi): Correct tox invocation docstring info.

Also clean up README badges. ([`ff66382`](https://github.com/OZI-Project/OZI/commit/ff66382ade92dc88eec6feb63499190cc192f82f))

### :hammer:

* :hammer:(ozi-new): add tox ci backend to optional_dependencies. ([`5f5a4ad`](https://github.com/OZI-Project/OZI/commit/5f5a4ad9c6bf9e7fbd2962380a5c6bbdeeabc833))

## 0.0.226 (2023-12-02)

### :hammer:

* :hammer:(ozi-new): Update tox checkpoint invocation. ([`bd64128`](https://github.com/OZI-Project/OZI/commit/bd64128f6aecdf85a485b4b79a0cad42bfebe327))

## 0.0.225 (2023-12-02)

### :hammer:

* :hammer:(ozi-fix): No longer using ozi to run utility modules.

tox is the preferred CI env manager.
Remove ``ozi/experimental.py``
Trying a new tox CI setup. ([`a7d15e1`](https://github.com/OZI-Project/OZI/commit/a7d15e19f00586f48c4accbd70dd39f501a2fb13))

## 0.0.224 (2023-12-01)

### :bug:

* :bug:(ozi-new): Fix missing ``TAP.end()`` ([`213ee76`](https://github.com/OZI-Project/OZI/commit/213ee76c6941107c768f3323a4ee6a19ff38b43d))

## 0.0.223 (2023-12-01)

### :bug:

* :bug:(ozi-fix): Make devnull writable. ([`11f0b7a`](https://github.com/OZI-Project/OZI/commit/11f0b7aef701c6303ac5e373eb6f07c4bd91836d))

## 0.0.222 (2023-12-01)

### :hammer:

* :hammer:(ozi-fix): Fix doctest failures.
Redirect output to null for ``TAP.suppress``.
Fix unclosed quote in root meson.build template. ([`98c8aa6`](https://github.com/OZI-Project/OZI/commit/98c8aa6e1e03f54417649f83e1976b429088b20a))

## 0.0.221 (2023-12-01)

### :hammer:

* :hammer:: TAP class is now simply changes the warning format for ``TAP.not_ok``.

No longer uses a ContextDecorator. ([`3a003bb`](https://github.com/OZI-Project/OZI/commit/3a003bb38672e522dd783922ab844cb617629dcc))

* :hammer:(ozi-fix): Add a proper mesonbuild AST inspection module ``ozi.meson``. ([`b5e5e3e`](https://github.com/OZI-Project/OZI/commit/b5e5e3edb488220708527535f5f1f4a6132f90d5))

### Other

* :page_facing_up:: Add copyright headers to some files. ([`76be62b`](https://github.com/OZI-Project/OZI/commit/76be62bc8810b583a6a5ddf47d1b07db4816ebb8))

* :truck:: Move repo files to ``.github`` ([`0e423c3`](https://github.com/OZI-Project/OZI/commit/0e423c3fd03f84f40f0f9e0f6afbd049f56bd4d5))

## 0.0.220 (2023-11-27)

### :bug:

* :bug::rotating_light:(ozi/tap.py): Fix nested quote styles and add version guard for typing.Self. ([`d1bc0b1`](https://github.com/OZI-Project/OZI/commit/d1bc0b1b0f4a6367e6835e6617bdddc6b7f05b3a))

### :hammer:

* :hammer:(ozi,ozi-fix,ozi-new): Add ``tap.py`` TAP support module. ([`cf5e144`](https://github.com/OZI-Project/OZI/commit/cf5e14440accc11148adce6cc6257e8fd8b48ae3))

* :hammer:(ozi-fix): Add ruff to utility suite. ([`1ab1c17`](https://github.com/OZI-Project/OZI/commit/1ab1c17111d2f3c180d7f4324c7ca7c5c6095214))

### Other

* :rotating_light:(ozi): Fix linter complaints. ([`d764695`](https://github.com/OZI-Project/OZI/commit/d764695f77c34f1e7c704fd7433cd90cde654aa8))

## 0.0.219 (2023-11-24)

### :pencil2:

* :pencil2:(ozi): Restore setuptools entrypoint ``main()``. ([`e7e1726`](https://github.com/OZI-Project/OZI/commit/e7e1726195a5854f1d2044a6a636afb89f7b26ae))

## 0.0.218 (2023-11-24)

### :hammer:

* :hammer:(ozi/spec.py): Add more spec metadata for templates. ([`5fa0c67`](https://github.com/OZI-Project/OZI/commit/5fa0c676bc04faf57877b1d569542335e5ba8f1c))

### :pencil2:

* :pencil2:: add changed entrypoint for ozi.fix and ozi.new ([`7c7d62a`](https://github.com/OZI-Project/OZI/commit/7c7d62a7c44f348f2420e65c8a94450e38067bf6))

* :pencil2:(requirements.in): Remove email-validator. ([`a458510`](https://github.com/OZI-Project/OZI/commit/a458510349098a74e5ff61d185ea4100dc6f0f1c))

### Other

* :construction_worker:(PKG-INFO): Bump version. ([`b9e792e`](https://github.com/OZI-Project/OZI/commit/b9e792e6e5fa81d613f975eb2455ace334a66fb7))

* :rotating_light:(ozi/actions.py): Update type guard block. ([`e1ba894`](https://github.com/OZI-Project/OZI/commit/e1ba894faeb9d3ecc360158d34b68fec34affc8d))

* Clean up hanging whitespace. ([`68c4050`](https://github.com/OZI-Project/OZI/commit/68c405069b1671c9239f91effbc5988eab205338))

* :memo:(ozi): Update pragma comments. Update docstring. ([`8aa482d`](https://github.com/OZI-Project/OZI/commit/8aa482d0794f1e2fbd2b1193b9b2f9187edc5fa2))

* :truck:(ozi/assets.py): Move utility functions and tap_warning_format into ``ozi/assets.py`` ([`a9b374b`](https://github.com/OZI-Project/OZI/commit/a9b374b485c97cc30d16d0f32f9c05ab65cae8fe))

* :truck:(ozi-new,ozi-fix): Moved ozi-fix and ozi-new into their own respective submodules. ([`bb35aa9`](https://github.com/OZI-Project/OZI/commit/bb35aa929e4587a6317def8c1d4f6e6fd15e01f7))

## 0.0.217 (2023-11-23)

### :bug:

* :bug:(ozi-fix): Fix warnings still being emitted for ``--add``

Also remove the ``stdout`` argument from several functions.
Redirecting stdout directly using contextlib. ([`218b768`](https://github.com/OZI-Project/OZI/commit/218b768852962e777c1e5cba8d9421e4e87f258a))

## 0.0.216 (2023-11-23)

### :bug:

* :bug:(ozi-new,ozi-fix): Fix meson.build install path rendering. ([`28f0f9d`](https://github.com/OZI-Project/OZI/commit/28f0f9d2597fcbed411dc45e73e6d6dbc563973d))

## 0.0.215 (2023-11-23)

### :bug:

* :bug:(ozi-new): Fix pytest ``pyproject.toml`` config rendering. ([`1f1e511`](https://github.com/OZI-Project/OZI/commit/1f1e5111df638231a465e9524fad82ba225d7756))

* :bug:(ozi-new): Fix PKG-INFO rendering &#34;Programming Language :: Python :: {major} :: Only&#34; ([`21f069c`](https://github.com/OZI-Project/OZI/commit/21f069cedec8d51dfc68c44df21de61570442d96))

### Other

* Bump PKG-INFO. ([`0aed6b8`](https://github.com/OZI-Project/OZI/commit/0aed6b88fe8ab4b6793a1487445c6993f24979ab))

## 0.0.214 (2023-11-23)

### :bug:

* :bug:(tests): Fix typo in keywords regex strategy. ([`a6d198e`](https://github.com/OZI-Project/OZI/commit/a6d198e57cf651863bb3da5b5056f9992a31dd15))

* :bug:(ozi-fix): Fix missing license-id list option. ([`bfc7609`](https://github.com/OZI-Project/OZI/commit/bfc7609f137898a4c91be6e99417dc71d6c34bec))

### :hammer:

* :hammer:(ozi-new): Rendered PKG-INFO includes &#34;Private :: Do Not Upload&#34; if license is set to &#34;Private&#34; ([`0575a5f`](https://github.com/OZI-Project/OZI/commit/0575a5fc7865ecca6bd68d9a388bbf009ef5672e))

## 0.0.213 (2023-11-23)

### :bug:

* :bug:(ozi): Fix main commandline app list not working for choices with dashes. ([`9c3c4e7`](https://github.com/OZI-Project/OZI/commit/9c3c4e728eda4386186dcdf7c4971c63351f4779))

* :bug:(ozi-new): Fix typo in rendering of black config template. ([`cfd6f52`](https://github.com/OZI-Project/OZI/commit/cfd6f52b7f661d8ff58385ca195b0177d3bdc079))

## 0.0.212 (2023-11-23)

### :bug:

* :bug:(ozi-fix): Fix reDOS in filename search. ([`2c2fc82`](https://github.com/OZI-Project/OZI/commit/2c2fc824ee5141c792d4b6c02fa26098c346ddfa))

### Other

* Bump PKG-INFO. ([`812f49d`](https://github.com/OZI-Project/OZI/commit/812f49d3c7f7f9f3e1b4f5feea89d03e86daea4d))

## 0.0.211 (2023-11-23)

### :bug:

* :bug:: Sanitize ozi-fix target against directory traversal. ([`690d200`](https://github.com/OZI-Project/OZI/commit/690d200b796ae46965230410102a214149f99150))

* :bug:: Fix unsanitized path. ([`7a3d624`](https://github.com/OZI-Project/OZI/commit/7a3d624fca54405eda4fe0472403926541e07fe2))

### Other

* :rotating_light:: Fix mypy complaints. ([`d06449f`](https://github.com/OZI-Project/OZI/commit/d06449f23ecc4a53e3f9de8de6149f4ab8b4f5f6))

* :rotating_light:: Fix black and revert PKG-INFO patch bump. ([`bbea8fb`](https://github.com/OZI-Project/OZI/commit/bbea8fbe7138263d529764032dc8655733dddcb0))

## 0.0.210 (2023-11-23)

### :bug:

* :bug:: Fix email email validator install path. ([`9828d09`](https://github.com/OZI-Project/OZI/commit/9828d097103d953433d0ea814b0488bee4043ee2))

## 0.0.209 (2023-11-23)

### :bug:

* :bug:: Finish vendoring of email_validator ([`fa371f1`](https://github.com/OZI-Project/OZI/commit/fa371f178aa662bbeb4e0f3fab11fd6bb4154fa3))

* :bug:: Vendor email-validator. ([`d17acf1`](https://github.com/OZI-Project/OZI/commit/d17acf12824864d24f5493e0a3d1379632859dfa))

## 0.0.208 (2023-11-22)

### :bug:

* :bug:: Fix circular depend on email_validator ([`30543b7`](https://github.com/OZI-Project/OZI/commit/30543b70a48b25b660030f2f032fa106359e1b26))

## 0.0.207 (2023-11-22)

### :bug:

* :bug:: Fix circular import. ([`d0fd1bd`](https://github.com/OZI-Project/OZI/commit/d0fd1bd0edcc83db54279dd182ab8e8288c2720b))

## 0.0.206 (2023-11-22)

### :bug:

* :bug:: Fix coverage with no cover of warning format. ([`05322ed`](https://github.com/OZI-Project/OZI/commit/05322ede2634de929f00915f3192c5aea7adca4c))

* :bug:: Fix linter complaints and missing import. ([`c1d68d8`](https://github.com/OZI-Project/OZI/commit/c1d68d8d20929984b04d7a104d90bca43e93818d))

* :bug:: Fix unknown import issue with email_validator. ([`d4d8b16`](https://github.com/OZI-Project/OZI/commit/d4d8b161d4e73a02e68170e64af2a48c886c8e5e))

## 0.0.205 (2023-11-22)

### :bug:

* :bug:: No cover warning formatter. ([`5b52bfc`](https://github.com/OZI-Project/OZI/commit/5b52bfc4443e220ef23c4d612ed77cb622779722))

* :bug:: Remove test of tap warning formatting. ([`be62ac1`](https://github.com/OZI-Project/OZI/commit/be62ac1867aadf1629b77102b1e6c45ddded9b2b))

* :bug:: Fix circular assets import. ([`b8a2774`](https://github.com/OZI-Project/OZI/commit/b8a2774b5106b2e2095f4d405f88afae5a02d931))

### Other

* Fix missing ruff template and circular import. ([`323b963`](https://github.com/OZI-Project/OZI/commit/323b96375b1e1c8f083b95fdfb1bc69e3e65e911))

## 0.0.204 (2023-11-22)

### :bug:

* :bug:: Fix meson.build template pyproject.toml preprocessing. ([`e9f10da`](https://github.com/OZI-Project/OZI/commit/e9f10da28bf2a3fc9dd78766f684b72def73ee6f))

* :bug:: Fix warning output to use TAP with a contextmanager. ([`92dea85`](https://github.com/OZI-Project/OZI/commit/92dea85753c1edb4fc6bf676a1c75f4048809ac9))

## 0.0.203 (2023-11-21)

### :bug:

* :bug:: Fix ``--list-available`` to use ExactMatch API. ([`2938362`](https://github.com/OZI-Project/OZI/commit/2938362128dbcec76762648a4a11bb8839382e89))

* :bug:(ozi/__main__.py): Fix incorrect help and OZI.spec.Metadata API use. ([`67655e8`](https://github.com/OZI-Project/OZI/commit/67655e8a9ffc250b23d01e7b59e6cb7d1be025d4))

## 0.0.202 (2023-11-21)

### :bug:

* :bug:: Fix typing issue on 3.10 ([`b6722c9`](https://github.com/OZI-Project/OZI/commit/b6722c9debe222eece36d2207927c83e0b344619))

* :bug:: Fix missing Self type annotation on 3.10 builds. ([`67059e3`](https://github.com/OZI-Project/OZI/commit/67059e32d6f168b0b96570c27b282d48928b5c9b))

### :hammer:

* :hammer::wrench:: Major refactor iteration.

* Created a specification data API ``ozi/spec.py``
* Moved argument matching actions to ``ozi/actions.py``
* Moved most parsers into ``ozi/assets.py``
  * Remove ``ozi/assets/__init__.py`` and ``ozi/assets/structure.py``
* Moved most Jinja2 template setups to ``ozi/render.py``
* Moved Jinja2 compatible filter functions into ``ozi/filter.py``
* Remove spec requirement for ``__init__.pyi``
* Update spec with compatibility for ruff
  * adds single line imports specification format requirement
* Fix VCS version templating by meson to write to a preprocessed ``pyproject.toml`` (``pyproject.toml.pre``)
* Move utility requirements to top level source dir ``ozi/dist``, ``ozi/docs``, ``ozi/lint``, ``ozi/test``.
* Proper author rendering as a list. ([`0793eff`](https://github.com/OZI-Project/OZI/commit/0793eff197e991d0d87896ccfbe5dcbc4572cfbd))

### Other

* :rotating_light:: no cover type guard ([`2c4a33a`](https://github.com/OZI-Project/OZI/commit/2c4a33a27904cee4bafaa53b0be6c5d7978c1385))

* :rotating_light: Forgot to lint. ([`3bf8be5`](https://github.com/OZI-Project/OZI/commit/3bf8be525956bc427690a6d175ca9b0c799b691d))

* :rotating_light: Fix lint. ([`5a05ff0`](https://github.com/OZI-Project/OZI/commit/5a05ff088530c05f8a237caa3c09267e340a665f))

## 0.0.201 (2023-11-15)

### :bug:

* :bug:: Add missing __init__.pyi required by spec. ([`9e6ba6e`](https://github.com/OZI-Project/OZI/commit/9e6ba6efc45c8f6bbc52fe56f52fc4b7c9dd21e2))

### Other

* :rotating_light:(pyproject.toml): Clean up. ([`6c9e92c`](https://github.com/OZI-Project/OZI/commit/6c9e92c2e8d6238b4078d0b02ecad0e979d6e808))

## 0.0.200 (2023-11-14)

### :bug:

* :bug: Fix meson.build build file check to use absolute path. ([`30f8c56`](https://github.com/OZI-Project/OZI/commit/30f8c56bc611309b8ce1e59d2ed110861d764b2b))

## 0.0.199 (2023-11-14)

### :bug:

* :bug:(ozi-fix): Fix missing ``run_utility`` AttributeError

Fixes: File &#34;&lt;OZI-0.0.198&gt;/ozi/fix.py&#34;, line 667, in main
AttributeError: &#39;Namespace&#39; object has no attribute &#39;run_utility&#39; ([`6c4d52a`](https://github.com/OZI-Project/OZI/commit/6c4d52a533052006a69f645bdec79c09fde02c9f))

## 0.0.198 (2023-11-14)

### :bug:

* :bug:(ozi-new): fix missing append argparse arguments.

Revert to using standard email-validator package. ([`1f2959b`](https://github.com/OZI-Project/OZI/commit/1f2959bb9c4dfc82bf7bf64c0aa4d73709a9f42b))

## 0.0.197 (2023-11-14)

### :hammer:

* :hammer:(ozi-fix,ozi-new): Clean up

Add Author, Author-email, License to assets.required_pkg_info
Create metadata variable in __init__.py
Add meson_min_version key to ozi metadata context used in Jinja2 templates
Add check_for_update method to ``ozi`` main script
Remove verbosity requirement for ``isort``
Add ``--run-utility`` to run ``isort``, ``black``, and ``autoflake`` with ``ozi-fix``
``ozi-fix`` warns for python files missing from meson.build.
``tox`` run local ``pip install``  add ``--quiet``
:bug: Template for ``meson.build`` in root now builds ``requirements.in``
Add Author, Author-email, License, Maintainer, and Maintainer-email keys to PKG-INFO template.
:bug:(scm_version): Fix ``fallback_version`` placeholder to use VCS_TAG from ``meson`` and set ``parentdir_prefix_version`` at template render.
Add ``--check-for-update`` bool arg to ``ozi-new`` (not yet implemented) ([`ee63ffd`](https://github.com/OZI-Project/OZI/commit/ee63ffd3f78f0950a1dc080a36f816907085359e))

## 0.0.196 (2023-11-10)

### :bug:

* :bug:: Fix missing ``pip-tools`` dep. ([`1ee16cc`](https://github.com/OZI-Project/OZI/commit/1ee16ccaea5741a513982bc4681b3b8c8c838865))

* :bug: Fix release signing for sdist. ([`8295605`](https://github.com/OZI-Project/OZI/commit/829560542fab9f36f86e90e3074f10fa2814aa99))

* :bug:(CI): Fix sdist release.

Also publishes a sigstore bundle for the tarball release. ([`dcdfb20`](https://github.com/OZI-Project/OZI/commit/dcdfb204cc57fbaea6d7609928aff4ad17209145))

### :pencil2:

* :pencil2: Fix typo from clipboard. ([`fe1561c`](https://github.com/OZI-Project/OZI/commit/fe1561c213391ca697c481968cd62852b77f32b5))

## 0.0.195 (2023-11-10)

### :hammer:

* :hammer::construction_worker:(GitHub): Fix publish workflow to publish an sdist.

Fixes sdist builds disabled #2 ([`5a059e1`](https://github.com/OZI-Project/OZI/commit/5a059e1f3236506e28c03f44330fd3c36f72b2e9))

## 0.0.194 (2023-11-09)

### :bug:

* :bug:(ozi-new): Fix TypeError.

missing default. ([`3f8b5ff`](https://github.com/OZI-Project/OZI/commit/3f8b5ff539d54c024f1a4c89636db352b57390ed))

## 0.0.193 (2023-11-09)

### :hammer:

* :hammer:(ozi-new): Add Download-URL to PKG-INFO Template.

Adds a ``project.ci_user`` dependent on ``project.ci_provider``.
Adds a ``Download-URL`` output dependent on ``project.ci_provider``.
Adds dependency on [GitPython](https://pypi.org/project/GitPython)
Fixes Issue #5 [OZI does not support Download-URL header.](https://github.com/rjdbcm/OZI/issues/5) ([`070f033`](https://github.com/OZI-Project/OZI/commit/070f03380dae39b2e2ceb0ad63af7d9a2c38e873))

## 0.0.192 (2023-11-09)

### :hammer:

* :hammer:(ozi-new): Use ``shlex.join()`` to render argv in changelog. ([`33b5219`](https://github.com/OZI-Project/OZI/commit/33b5219bd80cf11e53de3124b779d332735a464c))

* :hammer:(PKG-INFO): Correct Download-URL. ([`f787eb8`](https://github.com/OZI-Project/OZI/commit/f787eb82bdde5c273232c1a08a4b7e7c9f5fd9b0))

## 0.0.191 (2023-11-08)

### :hammer:

* :hammer:(ozi-new): Add optional Project-URL metadata.

Fixes Issue [Project-URLs are not supported by OZI #4](https://github.com/rjdbcm/OZI/issues/4) ([`b09898b`](https://github.com/OZI-Project/OZI/commit/b09898b02edc26ba07bc223e16edc0485fa3188d))

### Other

* :rotating_light:(tests/ozi_new.py): Fix black lint failure. ([`06419d9`](https://github.com/OZI-Project/OZI/commit/06419d98e16e6f56afd5c7e48f8e7c0282b7bc56))

## 0.0.190 (2023-11-04)

### :hammer:

* :hammer:(ozi-new): Add a cache key based on compiled requirements file.

Prior to this patch caches were not checked against requirements file. ([`af72080`](https://github.com/OZI-Project/OZI/commit/af720803bfacd8944e02e2b1952bd5a160c387e4))

## 0.0.189 (2023-11-04)

### :hammer:

* :hammer:(ozi-new): Fix missing ``subprojects/ozi.wrap``. ([`97ba52a`](https://github.com/OZI-Project/OZI/commit/97ba52a0af7e15008e054956ce8a257f77e28b2e))

## 0.0.188 (2023-11-04)

### :bug:

* :bug:(ozi-new): Fix missing __init__.pyi in project initialization. ([`94eb34f`](https://github.com/OZI-Project/OZI/commit/94eb34f7b754599e2f71f660b55396ec8aa21f55))

## 0.0.187 (2023-11-04)

### :bug:

* :bug:(ozi-new): Project source ``meson.build`` options conditional removed.

This check was added in error. ([`87bf8ec`](https://github.com/OZI-Project/OZI/commit/87bf8ec6b4c9888aa582e83f8ed65cbdc2318436))

## 0.0.186 (2023-11-03)

### :hammer:

* :hammer::pencil2:(ozi-new): Fix project source directory naming in root meson.build. ([`c8eba2f`](https://github.com/OZI-Project/OZI/commit/c8eba2ff2682e4f091542970769b7732366e7fe9))

## 0.0.185 (2023-11-03)

### :hammer:

* :hammer:(ozi-new): Update templates.

Projects now initialize with a changelog.
PKG-INFO is now initialized with version ``0.0.0``.
README.rst initializes with the OZI extra package info. ([`d09381b`](https://github.com/OZI-Project/OZI/commit/d09381ba174da7046765f7ca4bae7a0905de1483))

### :pencil2:

* :pencil2: Update semantic_release CHANGELOG.md template whitespace ([`527aa60`](https://github.com/OZI-Project/OZI/commit/527aa6073ef053f1f680870c4cc01fc37126d5c5))

## 0.0.184 (2023-11-03)

### :hammer:

* :hammer:(ozi-new): Add ``--allow-file``.

Added a list of allowed files in a new project directory: ``project.allow_file``.
Currently by default ``templates/`` and ``.git/`` are allowed. ([`a9640c1`](https://github.com/OZI-Project/OZI/commit/a9640c153c0d160bb82a344528d59dcb91d57e55))

### :pencil2:

* :pencil2: Update CHANGELOG.md

Fix minor changelog format issues. ([`f53f628`](https://github.com/OZI-Project/OZI/commit/f53f62872fd5c985df753fd8f26e8f5c9603158b))

### Other

* Update CHANGELOG.md ([`dd953c8`](https://github.com/OZI-Project/OZI/commit/dd953c847a28e0936a4e94a2115319b3c920a303))

## 0.0.183 (2023-11-02)

### :bug:

* :bug:(templates): Fix author_email rendering. ([`ab78ea0`](https://github.com/OZI-Project/OZI/commit/ab78ea014c987cfde5155926a852e2ac85b08820))

### :hammer:

* :hammer:(ozi-new): Allow new project with existing ``templates/`` and ``.git/`` ([`53c5687`](https://github.com/OZI-Project/OZI/commit/53c5687821a9af76a19d3572d39b1ae13636c2c7))

### :pencil2:

* :pencil2::construction_worker: Fix workflow logging to use wildcard. ([`5fa5496`](https://github.com/OZI-Project/OZI/commit/5fa549603eb62da4ec00077c902216525dbbd980))

### Other

* Add failure logging to checkpoint workflow. ([`3c5cd27`](https://github.com/OZI-Project/OZI/commit/3c5cd2708ef3fbe027f1df31f1758c75f35c2261))

* :construction_worker:(PKG-INFO): 0.0.183 ([`db66619`](https://github.com/OZI-Project/OZI/commit/db666193bf07ee9a66b143690a5383ddd5f59c06))

## 0.0.182 (2023-11-01)

### :bug:

* :bug:(CI): Fix ozi release workflow python version string quoting. ([`b5ec332`](https://github.com/OZI-Project/OZI/commit/b5ec33265a63b91267b82fce7903c55c810a51c6))

## 0.0.181 (2023-11-01)

### :bug:

* :bug:(CI): Fix workflow job indent level. ([`b6d4587`](https://github.com/OZI-Project/OZI/commit/b6d4587a939472904af4e86d2feb598887a5d263))

## 0.0.180 (2023-11-01)

### :bug:

* :bug:(CI): Fix indentation issue in workflow template. ([`07abfd4`](https://github.com/OZI-Project/OZI/commit/07abfd40060617fdfd8ee4a775c7429ee879cd34))

## 0.0.179 (2023-11-01)

### :bug:

* :bug::construction_worker:(CI): Fix for raw jinja whitespace trimming causing broken workflow. ([`e3e4d66`](https://github.com/OZI-Project/OZI/commit/e3e4d6633e6f62a93084eee9dc1e0f74f0c0fd21))

## 0.0.178 (2023-11-01)

### :bug:

* :bug:(ozi-fix): Fix incorrect source install subdir argument. ([`77c97b2`](https://github.com/OZI-Project/OZI/commit/77c97b27c492b138dc772609a2de21b1f0bbccbd))

## 0.0.177 (2023-10-31)

### :bug:

* :bug:(tests/ozi_fix.py): Remove flaky assertion. ([`fcaf807`](https://github.com/OZI-Project/OZI/commit/fcaf8072cf3c03ebd29734b7bfe09e17ad46b5c4))

### :children_crossing:

* :children_crossing:(ozi-fix): warn for nested subdirectories. ([`8f99980`](https://github.com/OZI-Project/OZI/commit/8f99980cc219c4bf17029fdecbc49e0c0768579b))

## 0.0.176 (2023-10-31)

### :bug:

* :bug: Revert nested dir add ([`b6c0de8`](https://github.com/OZI-Project/OZI/commit/b6c0de88f59818e9a4f4ae9261fd1b817d082bf2))

* :bug:(ozi-fix): Fix unconditional output of a file add command. ([`69614ba`](https://github.com/OZI-Project/OZI/commit/69614ba5d6c0a0c2aad0ee7627c58aefc5ec962d))

## 0.0.175 (2023-10-31)

### :bug:

* :children_crossing::bug:(CI): Fix retry of OZI utility checkpoint. ([`20b122d`](https://github.com/OZI-Project/OZI/commit/20b122d892dcbea1b70a59937015821e19bcfc81))

## 0.0.174 (2023-10-31)

### :children_crossing:

* :children_crossing::construction_worker:(CI): Retry checkpoint workflow after failure. ([`3188248`](https://github.com/OZI-Project/OZI/commit/318824881d6ae0fa5a38d47ceef5b87f4767525f))

## 0.0.173 (2023-10-31)

### :bug:

* :bug:(ozi-fix): Fix incorrect path to source subdirectory __init__.py ([`b7a454c`](https://github.com/OZI-Project/OZI/commit/b7a454cc496d7252726a5be0c42b4b80433b6c02))

* :bug:(ozi-fix): FIX: Incorrect subdirectory for __init__.py when adding source directories. ([`6c295c9`](https://github.com/OZI-Project/OZI/commit/6c295c9927bb0e52a9202f145687347394a40e7a))

## 0.0.172 (2023-10-30)

### :bug:

* :children_crossing::bug:(ozi-fix): Adding a source subdirectory now includes the __init__.py ([`1403d36`](https://github.com/OZI-Project/OZI/commit/1403d36b170797d676f8f36675ef83b2fb34c4bb))

## 0.0.171 (2023-10-30)

### :children_crossing:

* :children_crossing:(ozi-fix): Can now add nested subdirectories.

You can now add subdirectories that are nested like
```
ozi-fix source -a foo/bar/baz/
``` ([`5d3c15e`](https://github.com/OZI-Project/OZI/commit/5d3c15e7defcd1495ff4fc55aa24335aecdc9e25))

## 0.0.170 (2023-10-30)

### :children_crossing:

* :children_crossing:(ozi-fix): Add support for a ``templates/`` for user templates. ([`ecedb26`](https://github.com/OZI-Project/OZI/commit/ecedb26faa1015c4fba527d29b8b60919ceb5721))

## 0.0.169 (2023-10-28)

### :bug:

* :bug:(ozi-new): Fix Framework classifier output. ([`e7a7bb3`](https://github.com/OZI-Project/OZI/commit/e7a7bb36d27fd05f8ff7767584663afa5107e709))

## 0.0.168 (2023-10-28)

### :bug:

* :bug:(ozi-fix): Fix miscount in TAP output. ([`3e6b662`](https://github.com/OZI-Project/OZI/commit/3e6b66224bf24ec88f77d16b8e9e5e22f090a065))

## 0.0.167 (2023-10-27)

### :bug:

* :bug:: Fix default Multiple use args. ([`38cd3d4`](https://github.com/OZI-Project/OZI/commit/38cd3d4535a94ef8d57bc90fa108f344a3a855ca))

### :pencil2:

* :pencil2:: Fix black complaints. ([`c5b1402`](https://github.com/OZI-Project/OZI/commit/c5b1402b799b2177134d9e91d9fa21ff5b22169b))

## 0.0.166 (2023-10-27)

### :bug:

* :bug:(ozi-new): Fix keywords parsing. ([`db3f61e`](https://github.com/OZI-Project/OZI/commit/db3f61ef9080fca38d0b5e033e6031111b51faf8))

## 0.0.165 (2023-10-27)

### :bug:

* :bug:(ozi-new): Fix several improper PKG-INFO outputs ([`8db531a`](https://github.com/OZI-Project/OZI/commit/8db531a4162764f12967894f53de707386fa49e6))

## 0.0.164 (2023-10-26)

### :bug:

* :bug:: Fix missing variable in fix copyright_head. ([`1b06ddb`](https://github.com/OZI-Project/OZI/commit/1b06ddbb44e0ff3fd84b72a63033e804dc9ceed5))

### :pencil2:

* :pencil2:: Fix missing format placeholder. ([`a4c49cf`](https://github.com/OZI-Project/OZI/commit/a4c49cf0b3e09ef8068c1cc64d475ab56e665510))

## 0.0.163 (2023-10-26)

### :bug:

* :bug:: Fix missing dist_requires tests. ([`5d3c594`](https://github.com/OZI-Project/OZI/commit/5d3c594903f72d7e00168bf6f36e07697485f29c))

* :bug:: Fix default dist_requires. ([`513b932`](https://github.com/OZI-Project/OZI/commit/513b932dddcdf8890366c885f6c883445ad4cd62))

## 0.0.162 (2023-10-26)

### :bug:

* :bug:: Fix default project topic. ([`9d6e9d4`](https://github.com/OZI-Project/OZI/commit/9d6e9d4fd1330a0719fae5869da467fc4af3e9db))

## 0.0.161 (2023-10-26)

### :bug:

* :bug:(ozi/new.py): Fix EmailSyntaxError handling.

Emails with no @ sign will simply warn. ([`4e1fe3e`](https://github.com/OZI-Project/OZI/commit/4e1fe3eade42311e4cc2b7356615072d7de3fe47))

## 0.0.160 (2023-10-26)

### :children_crossing:

* :pencil2::children_crossing:: Fix flaky test deadline. ([`362c0b0`](https://github.com/OZI-Project/OZI/commit/362c0b04a31e44c4f7787c9d5601af070dda21c7))

### Other

* :rotating_light:: Re-black test file. ([`afabb83`](https://github.com/OZI-Project/OZI/commit/afabb835ee9544c83f54408f45a11dc801a349c6))

## 0.0.159 (2023-10-26)

### :hammer:

* :hammer::construction_worker:: Update templates and turn on CI dependency caching. ([`4897943`](https://github.com/OZI-Project/OZI/commit/4897943249f5375ed7ed9626e2c232b9acd13604))

## 0.0.158 (2023-10-25)

### :hammer:

* :hammer:: Add artifact upload for meson logs during checkpoint. ([`df59a74`](https://github.com/OZI-Project/OZI/commit/df59a743430fa7bc4d471c61d0621ab6aa578a8e))

### :pencil2:

* :pencil2:: Wildcard artifact upload path. ([`4a8aae1`](https://github.com/OZI-Project/OZI/commit/4a8aae1c50c8122c89fd48ddeed1ec36954db254))

* :pencil2:: Fix path name for artifact upload. ([`56fc456`](https://github.com/OZI-Project/OZI/commit/56fc4561efbf48fd1da4ab2b4f19c66141a78165))

* :pencil2:: Always upload artifact ([`3c05e6f`](https://github.com/OZI-Project/OZI/commit/3c05e6fad058cd00c617be08fcb1b3e440047503))

## 0.0.157 (2023-10-25)

### :children_crossing:

* :hammer::children_crossing:(project): Refactored for running test suite on OZI build itself. ([`1bbd6ae`](https://github.com/OZI-Project/OZI/commit/1bbd6aedcf7539d7c623991aed5bec0aed7975ec))

* :children_crossing:: Add meson-private/ to .gitignore. ([`2a4e62d`](https://github.com/OZI-Project/OZI/commit/2a4e62d30984b0334487b3691c82762640916834))

* :rotating_light::children_crossing:(tests): Fix paths for build. ([`7a8960f`](https://github.com/OZI-Project/OZI/commit/7a8960f4965edd237b8539cdf293478f8ba9048d))

* :hammer::children_crossing:(ozi/scripts): pip-compile now runs silently. ([`a1cf607`](https://github.com/OZI-Project/OZI/commit/a1cf60711aba8d8691ebab0326423faa50d42a22))

### :hammer:

* :hammer::rotating_light:(ozi): Fix py312 flake8-quotes style. ([`54f8ed7`](https://github.com/OZI-Project/OZI/commit/54f8ed7167782fc6d4da5d81d4d4ebe6eef49df6))

* :hammer:: Fix CI workflow for local checkpointing. ([`06d9107`](https://github.com/OZI-Project/OZI/commit/06d91073d1295678e3fe7c571fe891535eb76143))

* :hammer:(ozi/assets;ozi/templates): Fix missing files from build. ([`aa014bb`](https://github.com/OZI-Project/OZI/commit/aa014bbe59589d042ac5a8dbcd904d72b28d571f))

### :pencil2:

* :pencil2:: Fix missing toml-config arg. ([`c764706`](https://github.com/OZI-Project/OZI/commit/c764706ab36c054407a037e652038af941a11f29))

### Other

* :rotating_light:(ozi): Fix linting and typing. ([`7fca0c4`](https://github.com/OZI-Project/OZI/commit/7fca0c49a0d4b3f7b592d3238251f63c65bb4c30))

## 0.0.156 (2023-10-20)

### :pencil2:

* :pencil2: Emails generated from phony domains. ([`e415cc9`](https://github.com/OZI-Project/OZI/commit/e415cc97c7af5878b34334879c769450619ea49a))

### Other

* :white_check_mark:(tests/ozi_new.py): fullmatch=True for from_regex strategy. ([`c20fb56`](https://github.com/OZI-Project/OZI/commit/c20fb56cbef138ab73660e2addfa30d68b6acbe1))

## 0.0.155 (2023-10-20)

### :hammer:

* :hammer:(meson.options):Complete compliance with specification.

Flake8 is happy.
Coverage is complete. ([`5a0d991`](https://github.com/OZI-Project/OZI/commit/5a0d9910326be8e5926881f6f6b005afad0c2dae))

### Other

* Add more @settings(deadline=timedelta(milliseconds=500)) ([`c6bbe72`](https://github.com/OZI-Project/OZI/commit/c6bbe72c0d39ba2811cd683cabfc614c20487dd9))

* :white_check_mark:(tests/ozi_new.py:test_fuzz_new_project_good_namespace): suppress_health_check=[HealthCheck.too_slow] ([`1792d25`](https://github.com/OZI-Project/OZI/commit/1792d25dbee40a500e35e6a95520886b29de1ae0))

* :white_check_mark:: Fix deadline of test_fuzz_CloseMatch_nargs_None. ([`3b412c9`](https://github.com/OZI-Project/OZI/commit/3b412c9a727e2ed606d2fe92b1f386b5b3d04937))

* :white_check_mark:(tests/ozi_new.py): Reduce size of hypothesis.

Add max_size=8 to author_email and maintainer_email. ([`d75eae9`](https://github.com/OZI-Project/OZI/commit/d75eae9375390f04d6927d99c9add9f5c6a91989))

## 0.0.154 (2023-10-13)

### :bug:

* :bug:: Fix missing license templates. ([`439c426`](https://github.com/OZI-Project/OZI/commit/439c426894c4de153579be08f9b41e34ae72dff7))

### :children_crossing:

* :children_crossing:: Reduce test size to fix failed health check. ([`13bb6f3`](https://github.com/OZI-Project/OZI/commit/13bb6f339051adb1ce233cd0ae04ad86e7ca506b))

* :children_crossing:: Moved test assumptions to start of test. ([`b345516`](https://github.com/OZI-Project/OZI/commit/b3455164da0dcc64a20c773271a29327592e6b51))

### :hammer:

* :hammer:(ozi-new): Refactor of arguments. ([`69a5ace`](https://github.com/OZI-Project/OZI/commit/69a5ace417daa4d2e38d23ec3d3ea5b10ab03ff5))

* :hammer:: Change PKG-INFO template.

Add:
* keywords
* maintainer
* maintainer_email

Change:
* email -&gt; author_email ([`93b59a0`](https://github.com/OZI-Project/OZI/commit/93b59a0bcf85ca800d9898f22b8f161354cb0936))

* :hammer:: Add missing license templates.

Just LGPL-2.0-x and APSL-X.X ([`6465972`](https://github.com/OZI-Project/OZI/commit/6465972cc9ce6639d95ac99c5b57f88fe7a4f72f))

## 0.0.153 (2023-10-10)

### :hammer:

* :hammer:: add requirements.in to root_templates. ([`16f1124`](https://github.com/OZI-Project/OZI/commit/16f1124bff821a87101fad7853c5edb630f119a7))

* :hammer::construction_worker:: Update CI templates and CI build process. ([`a12607c`](https://github.com/OZI-Project/OZI/commit/a12607c954be007fd05f60a8d3da7394fcb0dba9))

* :hammer:: Add requirements.in to required file templates.

Also add metadata_version to PKG-INFO template.
Also add requirements as Requires-Dist in PKG-INFO template. ([`f18a8d8`](https://github.com/OZI-Project/OZI/commit/f18a8d8048d242f34b928509e1d6bbf9d13b8a52))

* :hammer:: Pytest entrypoint has a workflow template of its own.

This is mainly so we can document it in the specification. ([`c4fb826`](https://github.com/OZI-Project/OZI/commit/c4fb8261f1aebd7ffd74ce478d863f11b7803b50))

## 0.0.152 (2023-10-08)

### :hammer:

* :memo::hammer:(ozi-new): Add coverage and pytest templates ([`3504ee1`](https://github.com/OZI-Project/OZI/commit/3504ee1888b8b1d7a52a25db2a3b595a9561e51d))

* :hammer:: ``pytest_plugins`` option becomes ``plugin_only``. ([`72cf109`](https://github.com/OZI-Project/OZI/commit/72cf1095aa77cffaba7578978f40821743b61696))

* :hammer:: Make ``Home-page`` a REQUIRED PKG-INFO key. ([`a92191c`](https://github.com/OZI-Project/OZI/commit/a92191c98697e9957a91a4553df8b57cef90b6cc))

## 0.0.151 (2023-10-07)

### :bug:

* :bug::pencil2:: PKG-INFO template python version typo fix. ([`11ec7d9`](https://github.com/OZI-Project/OZI/commit/11ec7d9d4eee89fd74b44f2f4459c37a5972f06a))

## 0.0.150 (2023-10-06)

### :bug:

* :bug:: Fix improper import of dataclass from attr. ([`5714c66`](https://github.com/OZI-Project/OZI/commit/5714c66fc8d4a0b17419ff93b8c7aa5e27f7ac50))

### :children_crossing:

* :children_crossing:: Use Home-page header in PKG-INFO template. ([`6d4a96a`](https://github.com/OZI-Project/OZI/commit/6d4a96ac631a6b7a259d439b9c6c6ccbb558ed86))

* :children_crossing:(PKG-INFO): Use Home-page and Download-URL.

Also add requirements to PKG-INFO, including git. ([`2fda90e`](https://github.com/OZI-Project/OZI/commit/2fda90e3f1d9a405567a2a312833b481cb2ac5b4))

### Other

* :construction_worker:(PKG-INFO): Patch bump. ([`3ead502`](https://github.com/OZI-Project/OZI/commit/3ead50241c5068ff0a9137c5201b674a4b8d2f5b))

## 0.0.149 (2023-10-06)

### :bug:

* :bug:(CI): Fix Python versioning to follow an automated policy for CI templates. ([`7ae853b`](https://github.com/OZI-Project/OZI/commit/7ae853b66203f2ecf0ab4d6dacc860d5884be3ff))

## 0.0.148 (2023-10-06)

### :children_crossing:

* :children_crossing:: Add bug tracker URL. ([`957fc15`](https://github.com/OZI-Project/OZI/commit/957fc1541461d3f362f228349b0168f927edf5a1))

### :hammer:

* :hammer:: Add automation and checking of Python implementation and version metadata. ([`7315896`](https://github.com/OZI-Project/OZI/commit/7315896021a07f9cac43b003af189d22b31c0df6))

## 0.0.147 (2023-10-06)

### :bug:

* :bug::construction_worker:(tests/ozi_fix.py): Fix flaky CI due to exceeded deadline. ([`ae446ae`](https://github.com/OZI-Project/OZI/commit/ae446aeb5045e54583e27d1bee8f596b713c723e))

* :bug:(ozi/templates/project.PKG-INFO):  Fix template not specifying Python 3 Only.

```
# &lt;OZI-0.0.146&gt;/ozi/fix.py:239: RuntimeWarning
not ok - 8 - &#34;Programming Language :: Python :: 3 :: Only&#34; MISSING
``` ([`9e8b6c0`](https://github.com/OZI-Project/OZI/commit/9e8b6c0d8cfe70973ff094ff1455960dccb7334f))

### :hammer:

* :hammer::white_check_mark:(ozi-fix): Add coverage for Python version PKG-INFO. ([`39422a5`](https://github.com/OZI-Project/OZI/commit/39422a5b4052dae92c1f13c85926c32da08c237a))

## 0.0.146 (2023-10-06)

### :bug:

* :bug::construction_worker:(ozi-fix):  Fix flaky CI.

``tests/ozi_fix.py::test_fuzz_report_missing - hypothesis.errors.Flaky: Hypothesis ``
Unreliable test timings! On an initial run, this test took 359.85ms, which exceeded the deadline of 200.00ms, but on a subsequent run it took 10.32 ms, which did not. Deadline raised for this test by setting deadline=500ms. ([`7356c9a`](https://github.com/OZI-Project/OZI/commit/7356c9a697fc04279733bdeb81dec058e9f40f21))

### :hammer:

* :hammer:(ozi-fix): Coverage complete for pep-639 extra classifiers. ([`6c65619`](https://github.com/OZI-Project/OZI/commit/6c65619597f73bf7a296ccf283f6e3e653a19362))

## 0.0.145 (2023-10-05)

### :hammer:

* :hammer:(ozi-fix): Improved coverage.

Still deferring to good first issue for the extra PKG-INFO parser.
It is likely I will move it to it&#39;s own module as well. ([`a796bd3`](https://github.com/OZI-Project/OZI/commit/a796bd392e30119e2e84d33dcdad0338e6ed2071))

## 0.0.144 (2023-10-05)

### :hammer:

* :hammer:(ozi-fix): Add Python version checking. ([`f33d754`](https://github.com/OZI-Project/OZI/commit/f33d7542b7577288d9c4cd6e607f9d986bb5fcc9))

* :hammer:(ozi-fix): Added reporting of all PKG-INFO headers present. ([`dee27f7`](https://github.com/OZI-Project/OZI/commit/dee27f7b779d33fa8e75c4c78a4b1dda09938991))

## 0.0.143 (2023-10-04)

### :pencil2:

* :pushpin::pencil2:: Forgot to bump Python for OZI&#39;s distribution. ([`c0e07d4`](https://github.com/OZI-Project/OZI/commit/c0e07d41c8ee1c21d2f7bc395322b493cbb6c7a3))

### :pushpin:

* :pushpin:: Deprecate Python version 3.9

Add support for Python 3.12 ([`0668309`](https://github.com/OZI-Project/OZI/commit/0668309d7219029fbc0dc483ec39b9cc701076a2))

* :pushpin:: Deprecate Python version 3.9

Add support for Python 3.12 ([`706191e`](https://github.com/OZI-Project/OZI/commit/706191e80fc0ad344a0dbb66ca07b7569b4f5c91))

## 0.0.142 (2023-10-04)

### :bug:

* :bug:: 500ms deadline for hypothesis.

Should fix:
Unreliable test timings! On an initial run, this test took 357.72ms, which exceeded the deadline of 200.00ms, but on a subsequent run it took 24.28 ms, which did not. If you expect this sort of variability in your test timings, consider turning deadlines off for this test by setting deadline=None. ([`2005bb3`](https://github.com/OZI-Project/OZI/commit/2005bb30040bc700af9d6fd857f0e69394b747b0))

### :hammer:

* :hammer:: Remove unnecessary references to NOTICE. ([`b146b78`](https://github.com/OZI-Project/OZI/commit/b146b78ee302d5d6d56ea5d1dc8248f7416e2226))

### Other

* :see_no_evil:: Update gitignore template.

Added ignored-by-default patterns for:
* Utility environments
* coverage files
* Byte-compiled / optimized / DLL files
*  C extensions ([`cfdd5d7`](https://github.com/OZI-Project/OZI/commit/cfdd5d72a660e39f923b7574efe107634e3ebc0f))

## 0.0.141 (2023-10-03)

### :bug:

* :bug:(ozi-fix): Correct warning for missing. ([`f474efd`](https://github.com/OZI-Project/OZI/commit/f474efdef3d918a423684614016bc9608612eb24))

* :bug:: Coverage fixed. ([`fe03224`](https://github.com/OZI-Project/OZI/commit/fe03224ebfdac2f99c522eeb58fc944c00abb7fe))

* :bug:: Defer some flaky tests to issues. ([`9f9fbc9`](https://github.com/OZI-Project/OZI/commit/9f9fbc98dd554c47760c6cc32d0fe430cb226a59))

* :bug:: Flaky license test. ([`1c2eba0`](https://github.com/OZI-Project/OZI/commit/1c2eba0806f0d66a5a03df1e00a217ad7ed5de01))

* :bug:: Fix flaky test caused by PEP-639 proposed keys. ([`fee17df`](https://github.com/OZI-Project/OZI/commit/fee17dfd4db81b8a3d87d9f5f4e1412b5fe01ff8))

### :hammer:

* :hammer:(ozi-new): Name test strategy changes.

```python
r&#39;^([A-Za-z]|[A-Za-z][A-Za-z0-9._-]*[A-Za-z0-9])$&#39;
``` ([`9f5d2b8`](https://github.com/OZI-Project/OZI/commit/9f5d2b840834f4b5390ffc732950470494a7756e))

### Other

* :white_check_mark:(ozi-new): Modified test draw strategy for licenses.

We mainly want to test that ``ozi-new project`` does not complain about licenses that we have templates for. ([`d99b144`](https://github.com/OZI-Project/OZI/commit/d99b144af8c975f96a0d034057b78cb9696a6795))

* :white_check_mark:(ozi-new): Coverage improved.

A handful of defer to good-first-issue like ``project.homepage.netloc`` ([`4f0339a`](https://github.com/OZI-Project/OZI/commit/4f0339a2a9a8f80b31eadc78c5ea1b54b08d004b))

## 0.0.140 (2023-10-01)

### :bug:

* :bug:(ozi-fix): Fix ``--missing`` output. ([`36fa838`](https://github.com/OZI-Project/OZI/commit/36fa838b93d36f8ffe41f787b890ed6665981b38))

## 0.0.139 (2023-10-01)

### :hammer:

* :hammer:(ozi-fix): Fix missing pretty print arg. ([`7e5a9bb`](https://github.com/OZI-Project/OZI/commit/7e5a9bb9200eac98e12a762eac3eb815c52dda60))

## 0.0.138 (2023-10-01)

### :hammer:

* :hammer:(ozi-new;ozi-fix): ``ozi-new`` just for project creation.

Decoupled utility functionality. Also corrected some output. ([`99ffe02`](https://github.com/OZI-Project/OZI/commit/99ffe022d802806559568f8da0800db9536141f7))

## 0.0.137 (2023-10-01)

### :bug:

* :bug:(ozi-new): Fix skipping of new item creation. ([`93b1e70`](https://github.com/OZI-Project/OZI/commit/93b1e701d0d3ef7dda817cd8451f80c35a51b625))

## 0.0.136 (2023-10-01)

### :hammer:

* :hammer:: Add check for missing typing arg in PKG-INFO template. ([`bb48d07`](https://github.com/OZI-Project/OZI/commit/bb48d076f073e7029630f2e943d2762eb8a9f7ab))

### Other

* :construction_worker:(PKG-INFO): Bump version. ([`1d3cf17`](https://github.com/OZI-Project/OZI/commit/1d3cf1752b78262d0a5398d9f1e3fcb86709c69b))

* :memo:: Update tempates for documentation. ([`6cb97e7`](https://github.com/OZI-Project/OZI/commit/6cb97e79d1a425e0684b5d45116766bc78fd0c76))

## 0.0.135 (2023-10-01)

### :bug:

* :bug:: Try setting PYTHONPATH to get pytest-cov working. ([`a260409`](https://github.com/OZI-Project/OZI/commit/a2604094b9646ed694ed3c5db6dc3579796e6798))

* :bug:: Get correct dist-packages coverage location. ([`054c900`](https://github.com/OZI-Project/OZI/commit/054c900b81fe8dfc1baa0b29ca207a957d35d35c))

* :bug:: Try to fix coverage path. ([`b710223`](https://github.com/OZI-Project/OZI/commit/b710223e900161e30c4567a4e4c646f701e25c98))

* :bug::pencil2:: Fix option typo. ([`348152d`](https://github.com/OZI-Project/OZI/commit/348152de6dbb61dde68594a13285e0ef08d9a95c))

* :bug:: Install requirements in addition to building clone for pytest. ([`fc79ce3`](https://github.com/OZI-Project/OZI/commit/fc79ce34f660aecf63cf0a85add55c1d5b6bf042))

* :bug:: Install from clone for pytest. ([`9f821b3`](https://github.com/OZI-Project/OZI/commit/9f821b3d4aa27cad2b3d7e8dece17bb997630027))

* :bug:: Correct tests folder path. ([`28f2f93`](https://github.com/OZI-Project/OZI/commit/28f2f936e1ebb0d0cf3a40020f0fedadd9af3e59))

* :bug:: Just do a fresh test suite environment for Pytest. ([`d0efb7c`](https://github.com/OZI-Project/OZI/commit/d0efb7cc582e51a212a52b128c24a2b163e6c086))

* :bug:: Fix call binary pytest not module. ([`35500f2`](https://github.com/OZI-Project/OZI/commit/35500f238010d64b7feee9c8a85f2462819ad88e))

* :bug:: Pytest invocation should be python version specific. ([`72cf38d`](https://github.com/OZI-Project/OZI/commit/72cf38d067b8a49d4f474ab9b6e2c2b885a18a55))

* :hammer::bug:: Fix invocation of Pytest.

It was unclear until this point where pytest would be invoked. Now it is clearly invoked during the CI checkpoint step for ``--setup=test`` only. ([`018f703`](https://github.com/OZI-Project/OZI/commit/018f70316cb5d06b6609b838ca06897c50bf3966))

### Other

* :construction_worker:: Bump PKG-INFO. ([`1dddfd7`](https://github.com/OZI-Project/OZI/commit/1dddfd72a43b343aef91b8c18f337569527a5652))

* :construction_worker:: Bump for sigstore 2.0. ([`668c389`](https://github.com/OZI-Project/OZI/commit/668c389e2d3719084167150f9e31d803eeb1249a))

* :construction_worker:: Add builtin pytest invocation. ([`88b335e`](https://github.com/OZI-Project/OZI/commit/88b335e78aa3506ddae56eb72aee5a745c618240))

## 0.0.134 (2023-10-01)

### :hammer:

* :hammer::white_check_mark:: Add a test suite.

Most nearly 100% coverage. ([`68e6dbb`](https://github.com/OZI-Project/OZI/commit/68e6dbbf6355afdf092978bc6a1a0ed6ee1fb271))

### Other

* Add basetemp for testing. ([`d92fa25`](https://github.com/OZI-Project/OZI/commit/d92fa2503dc205a664afdf25892ab2bc37cb5786))

## 0.0.133 (2023-09-28)

### :hammer:

* :hammer::test_tube:(ozi-fix,ozi-new): Add the beginning of our test suite.

Hypothesis test writing must be done from a release so failing tests are using
```
# pragma: no cover
```
This also fixes some minor UX bugs:
* Missing ``ozi-new --list`` keys
* Incorrect names ([`748b730`](https://github.com/OZI-Project/OZI/commit/748b730f393f4b7facc8060a2745dc0f31a8f638))

## 0.0.132 (2023-09-27)

### :pencil2:

* :pencil2:(ozi-fix): Remove unnecessary print statement. ([`20d509f`](https://github.com/OZI-Project/OZI/commit/20d509ff8ebbf94f03b3d67f4038bb4c1d39c943))

## 0.0.131 (2023-09-27)

### :bug:

* :bug:(ozi-fix): Fix RewriteCommand.

TypeError: Object of type RewriteCommand is not JSON serializable ([`a9344cd`](https://github.com/OZI-Project/OZI/commit/a9344cd69fcfc3671ecff8278213aaacaadfc6fb))

## 0.0.130 (2023-09-26)

### :bug:

* :bug:(ozi-fix): Fix namespace.

```
File &#34;&lt;OZI-0.0.129&gt;/ozi/fix.py&#34;, line 435, in main
File &#34;&lt;OZI-0.0.129&gt;/ozi/fix.py&#34;, line 427, in preprocess
TypeError: unhashable type: &#39;list&#39;
``` ([`5ec84bb`](https://github.com/OZI-Project/OZI/commit/5ec84bb1c4640fd3d98ba70f5f412f52452c961e))

## 0.0.129 (2023-09-26)

### :bug:

* :bug:(ozi-fix): Fix missing args.

&#39;Namespace&#39; object has no attribute &#39;add&#39; ([`17e1d79`](https://github.com/OZI-Project/OZI/commit/17e1d794dc17a0bfb90ca4e98d7775daae1dd8d2))

## 0.0.128 (2023-09-26)

### :hammer:

* :hammer:(ozi-fix): major refactoring.

Add Rewriter class. ([`8410fcc`](https://github.com/OZI-Project/OZI/commit/8410fcc93cf507f31071abead6c7dc6504d2b4c0))

### Other

* :memo:: Add security policy. ([`ba1b1ba`](https://github.com/OZI-Project/OZI/commit/ba1b1bab2f6f4a052282a37bf5cc262e9b17a63d))

## 0.0.127 (2023-09-24)

### :children_crossing:

* :children_crossing:: Drop run of blastpipe for now.

I do plan to implement a test suite but blastpipe&#39;s invocation from OZI during continuous integration is currently suffering from broken arguments. ([`2461151`](https://github.com/OZI-Project/OZI/commit/24611518eb2fb656698532248b80c9eee3edce0d))

## 0.0.126 (2023-09-24)

### :bug:

* :bug:(ozi-fix):  &#39;Namespace&#39; object has no attribute &#39;strict&#39; ([`f7bbdaf`](https://github.com/OZI-Project/OZI/commit/f7bbdafb132be919311458487fe2834612dedc42))

## 0.0.125 (2023-09-24)

### :bug:

* :bug:(ozi-fix): Fix &#39;Namespace&#39; object has no attribute &#39;add&#39;. ([`af35c7e`](https://github.com/OZI-Project/OZI/commit/af35c7e5f8e4322a9e26b54e712540b16946db0c))

## 0.0.124 (2023-09-23)

### :bug:

* :bug:(ozi-fix): Add missing new_child template. ([`4f406ad`](https://github.com/OZI-Project/OZI/commit/4f406adc6c94fae5dddd8da59e52d04695d05772))

### Other

* :memo:(PKG-INFO): Bump version. ([`fca526b`](https://github.com/OZI-Project/OZI/commit/fca526b6aa5b59dad27b8a47c89d02e1e9f5d3e6))

## 0.0.123 (2023-09-23)

### :bug:

* :bug:(ozi-fix): proper detection of target paths. ([`09806e0`](https://github.com/OZI-Project/OZI/commit/09806e07386d7c12a40e5e6d409e8a58624f9fd4))

## 0.0.122 (2023-09-23)

### :bug:

* :bug:(ozi-fix): Fix &#39;Namespace has no attribute missing&#39;. ([`238ba81`](https://github.com/OZI-Project/OZI/commit/238ba81c18f0ad81c6b6f266639984ce8c7c5500))

## 0.0.121 (2023-09-23)

### :children_crossing:

* :children_crossing:(ozi-fix): Changed ``missing`` from a flag to a subparser. ([`526665d`](https://github.com/OZI-Project/OZI/commit/526665de9049dd4b5e897c7e509dfe7cc42f503c))

### Other

* :memo:(PKG-INFO): Bump version. ([`18c112a`](https://github.com/OZI-Project/OZI/commit/18c112ac9cb4f80851bf2fcdea5480319239c1b0))

## 0.0.120 (2023-09-23)

### :bug:

* :bug:(ozi-fix): Fix dictionary cast of RewriteCommand.

Using dataclasses.asdict(). ([`32fad26`](https://github.com/OZI-Project/OZI/commit/32fad263589ef9555f3f03fccb0ca147295e7a8d))

## 0.0.119 (2023-09-23)

### :bug:

* :bug:(ozi-fix): Fix mutable default in dataclass. ([`198bf28`](https://github.com/OZI-Project/OZI/commit/198bf287cc7f9723ce66d767d78714b54a7e6d0e))

### Other

* :memo:(PKG-INFO): Bump version. ([`ed08b45`](https://github.com/OZI-Project/OZI/commit/ed08b45eb9e3aa9b76fdd659233dff5c33fb5cff))

## 0.0.118 (2023-09-23)

### :bug:

* :bug:(ozi-fix): Fix RewriteCommand repr to dict. ([`a1dfcbb`](https://github.com/OZI-Project/OZI/commit/a1dfcbb6ef5144c5ee57ad0aa6aaf7b5c766e33c))

* :bug:(ozi-fix): Fix incorrect annotation of self. ([`d3417ae`](https://github.com/OZI-Project/OZI/commit/d3417ae6ad60d9e87e26cb7b246c225b79537a22))

## 0.0.117 (2023-09-23)

### :hammer:

* :hammer:: Improved ``ozi-fix`` implementation. ([`c4b2cf4`](https://github.com/OZI-Project/OZI/commit/c4b2cf48baf0dfd361e7729a44fb033b55f94b2f))

## 0.0.116 (2023-09-19)

### :children_crossing:

* :children_crossing:: ``ozi-fix`` arg order matches ``ozi-new`` ([`c776a0e`](https://github.com/OZI-Project/OZI/commit/c776a0e33a45adcec3fb6e351e62b8e206497c17))

## 0.0.115 (2023-09-19)

### :pencil2:

* :pencil2:: Fix copyright head between different subparsers. ([`d86bedd`](https://github.com/OZI-Project/OZI/commit/d86beddb487df36cf5ecb4bef2291846938aaac2))

* :pencil2:: Correct test count print for ``ozi-new``. ([`80eeda5`](https://github.com/OZI-Project/OZI/commit/80eeda53990dda6f7c775bda14822f5071b9a7b0))

## 0.0.114 (2023-09-18)

### :children_crossing:

* :children_crossing:: Update list functionality. ([`c681cd1`](https://github.com/OZI-Project/OZI/commit/c681cd132758cfe530b1e24791531e3d5ef97e12))

## 0.0.113 (2023-09-18)

### :pencil2:

* :pencil2:: Warning format.

Show name of Warning.
Also run isort and blacken. ([`16c948d`](https://github.com/OZI-Project/OZI/commit/16c948d48ca041e952a50c52d7b876149bd955f1))

## 0.0.112 (2023-09-18)

### :pencil2:

* :pencil2: Fix TAP output newlines. ([`cb37731`](https://github.com/OZI-Project/OZI/commit/cb377310ebb6fe75493ed83766cb58db5f21a41a))

## 0.0.111 (2023-09-18)

### :hammer:

* :hammer:: Update ``ozi-new``.

Should use TAP output throughout now. ([`1cf2cee`](https://github.com/OZI-Project/OZI/commit/1cf2cee123be53551d6b377069492be0dee13e22))

## 0.0.110 (2023-09-18)

### :ambulance:

* :ambulance::pencil2:: Fix incorrect importlib.metadata import. ([`c0cf9b9`](https://github.com/OZI-Project/OZI/commit/c0cf9b9d0ccb8cf1f258c2f4f2d396969c434789))

## 0.0.109 (2023-09-17)

### :hammer:

* :hammer:: FIX ``ozi-fix``.

```
File &#34;&lt;OZI-0.0.108&gt;/ozi/fix.py&#34;, line 250, in main
AttributeError: &#39;str&#39; object has no attribute &#39;is_dir&#39;
``` ([`8721bb0`](https://github.com/OZI-Project/OZI/commit/8721bb0235f12633352cb2afe705352c942f8323))

## 0.0.108 (2023-09-17)

### :ambulance:

* :ambulance:: FIX ``ozi-fix``

```
File &#34;&lt;OZI-0.0.107&gt;/ozi/fix.py&#34;, line 244, in main
AttributeError: &#39;Namespace&#39; object has no attribute &#39;name&#39;
``` ([`1368035`](https://github.com/OZI-Project/OZI/commit/13680352ef22520d748eab5a4a9966e63b65b2cc))

### :children_crossing:

* :pencil2::children_crossing:: Fix NoReturn annotation. ([`f5299ac`](https://github.com/OZI-Project/OZI/commit/f5299ace198182fc010ad0fd1ab42c0437daabdd))

* :children_crossing:: Add OZI_SPEC version variable. ([`4188f2d`](https://github.com/OZI-Project/OZI/commit/4188f2d529846ed97fa315761fca582040f5a677))

### Other

* :memo:: Update template header. ([`f1c0f7d`](https://github.com/OZI-Project/OZI/commit/f1c0f7de109be93205affe7475f0d9f7ea5ce0dd))

## 0.0.107 (2023-09-17)

### :pencil2:

* :pencil2:: Fix README whitespace finally, hopefully. ([`4b7a27a`](https://github.com/OZI-Project/OZI/commit/4b7a27ad7b665b4be21c0174040293b93f634b3c))

## 0.0.106 (2023-09-17)

### :ambulance:

* :ambulance:: Fix incorrect OZI PKG-INFO extras. ([`ecdc241`](https://github.com/OZI-Project/OZI/commit/ecdc2419c6fdc14a9de4cd07c2f4774d0119bdfe))

### :pencil2:

* :pencil2: fix template README.rst whitespace. ([`014b862`](https://github.com/OZI-Project/OZI/commit/014b86228705ad15ffc2747ebee17649a48518dd))

* :pencil2: Fix incorrect TAP test count. ([`23a7efc`](https://github.com/OZI-Project/OZI/commit/23a7efc59cfd9ec2eb0be75fd20f319be05c09fa))

### Other

* :memo:: Bump PKG-INFO. ([`a4f6d59`](https://github.com/OZI-Project/OZI/commit/a4f6d59ea6501fcb0ab83bdfd625d59939754e91))

## 0.0.105 (2023-09-16)

### :ambulance:

* :ambulance:: Fix incorrect remote file checksumming. ([`99a3ea0`](https://github.com/OZI-Project/OZI/commit/99a3ea078e992c4fda660b19dbef5a84ae3ef39d))

## 0.0.104 (2023-09-16)

### :hammer:

* :hammer:: Use a streaming request to generate hashes for wrapfile. ([`e27546d`](https://github.com/OZI-Project/OZI/commit/e27546d17183ab85e5e8af9bd6416cac01328594))

### :heavy_plus_sign:

* :heavy_plus_sign:: Add ``requests`` to dependencies. ([`5e65e34`](https://github.com/OZI-Project/OZI/commit/5e65e340617f04e4b16985c6218edfa51f2a3056))

### :pencil2:

* :pencil2:: Fix file permissions. ([`a6d033a`](https://github.com/OZI-Project/OZI/commit/a6d033afc8edb60477d9f9d7aa8e6f9e4b6575bc))

## 0.0.103 (2023-09-16)

### :ambulance:

* :ambulance:: Fix ozi.wrap hash url. ([`68af9f6`](https://github.com/OZI-Project/OZI/commit/68af9f6f856b81e63e51ab57b3a9b0c843873364))

## 0.0.102 (2023-09-16)

### :children_crossing:

* :hammer::children_crossing:: Generate sha256sum for wrapfile. ([`c9f8fd0`](https://github.com/OZI-Project/OZI/commit/c9f8fd0b6b9cc4228747fc6bcce95bc88c41727b))

## 0.0.101 (2023-09-16)

### :pencil2:

* :pencil2:: Fix variable reference in ``ozi.wrap.j2`` ([`3d7ffa1`](https://github.com/OZI-Project/OZI/commit/3d7ffa1774a8e9f0113cddd1e2df5d4f098c040a))

## 0.0.100 (2023-09-16)

### :ambulance:

* :ambulance:: Fix missing ozi.wrap template. ([`2aff6fd`](https://github.com/OZI-Project/OZI/commit/2aff6fd7f6955d07de6563b3c88cbbc8e71dcfee))

### :pencil2:

* :pencil2:: Fix wrapfile template filename. ([`46d1bd0`](https://github.com/OZI-Project/OZI/commit/46d1bd0709235417358294a1d103724b93396959))

## 0.0.99 (2023-09-16)

### :hammer:

* :hammer:: Update only need copyright_head for source generation. ([`174c1ac`](https://github.com/OZI-Project/OZI/commit/174c1acb3bad3392c0f467970b12f51f871b6ea7))

## 0.0.98 (2023-09-16)

### :pencil2:

* :pencil2:: Fix more whitespace. ([`dc2eb53`](https://github.com/OZI-Project/OZI/commit/dc2eb53d19012fa52e88725b5ebba2ff3e7a4385))

* :pencil2:: Fix missing whitespace in template. ([`58bc4f4`](https://github.com/OZI-Project/OZI/commit/58bc4f47b20c45921bdecd5e9a0138271bb82b17))

* :pencil2:: Move strict warning filter into ``ozi-new`` into project block. ([`b70ae67`](https://github.com/OZI-Project/OZI/commit/b70ae671c0211c59dde745bfe40cd98329cd4c31))

## 0.0.97 (2023-09-16)

### :children_crossing:

* :children_crossing:: add ozi.wrap creation tool. ([`64700a6`](https://github.com/OZI-Project/OZI/commit/64700a667c82eabf322f40e2986e4a370967293b))

### Other

* Updated disclaimers. ([`78f1bd0`](https://github.com/OZI-Project/OZI/commit/78f1bd09dd2152d893b3b5595a4d27b3bfed8ae2))

## 0.0.96 (2023-09-16)

### :children_crossing:

* :children_crossing:: Add ``pip-tools`` to ``pyproject.toml`` template. ([`b6346a2`](https://github.com/OZI-Project/OZI/commit/b6346a2208ef24c1cba5cc9cc07dfc73d1dddb3e))

### :hammer:

* :hammer:: Add missing ``--license-file`` arg to ``ozi-new p``. ([`ff64224`](https://github.com/OZI-Project/OZI/commit/ff64224372600ef452468c6564789956a09a5dd6))

* :hammer:: Add pip-tools to tox template. ([`5838fb7`](https://github.com/OZI-Project/OZI/commit/5838fb7d7aafd4e63bab241a7f427c08443af606))

### :pencil2:

* :pencil2:: Remove uneeded NOTICE header. ([`062e116`](https://github.com/OZI-Project/OZI/commit/062e1162152cc22f347639766a652b60e9ffecd0))

## 0.0.95 (2023-09-16)

### :ambulance:

* :ambulance:: Fix LICENSE.txt template lookup. ([`58ce5ee`](https://github.com/OZI-Project/OZI/commit/58ce5ee509bbeada0b0ad87f4b9e27530ef81c80))

## 0.0.94 (2023-09-16)

### :ambulance:

* :ambulance:: Fix missing pip-compile in tox. ([`d8dbfff`](https://github.com/OZI-Project/OZI/commit/d8dbfff7fc22d6ef25455a97c50c936ad2da072f))

### :children_crossing:

* :children_crossing: Restructure dependencies around pip-tools. ([`9c21588`](https://github.com/OZI-Project/OZI/commit/9c21588db1935d7c70a2f071a9d5d6b2fe8faef6))

## 0.0.93 (2023-09-15)

### :ambulance:

* :ambulance: Fix mismatched PKG-INFO. ([`3c4fd77`](https://github.com/OZI-Project/OZI/commit/3c4fd773c167041fe95cb476fa7b700d8bda20e9))

### :children_crossing:

* :memo::children_crossing:: Update README license info. ([`04811c2`](https://github.com/OZI-Project/OZI/commit/04811c2e03584c387e5a54a4cdc50e97fee24760))

### :hammer:

* :hammer:: Improved strict mode using warning filters.

Also improved license disambiguation for PEP 639 preparedness. ([`7774b02`](https://github.com/OZI-Project/OZI/commit/7774b02043fdf633ce6e5e542cd1c5324df8cc95))

* :hammer:: Add report_missing TAP fixture and SPDX expression parser. ([`4902150`](https://github.com/OZI-Project/OZI/commit/490215052385f676e216dd67b940c2a9748765c5))

### Other

* :memo: Update licensing header format.

Loosely follows the style of LLVM. ([`f80f7eb`](https://github.com/OZI-Project/OZI/commit/f80f7eba7fb862db443494c2e01869424afdbd31))

## 0.0.92 (2023-09-14)

### :children_crossing:

* :children_crossing:: Add OZI PKG-DATA payload preamble.

PEP-639 keys:
* License-Expression
* License-File ([`19d194c`](https://github.com/OZI-Project/OZI/commit/19d194c00d861adfc23f495a6ee05a809b5d4a8a))

### Other

* :page_facing_up: Relicense codebase to LLVM-exception.

This adds the following to ``LICENSE.txt``:
---- LLVM Exceptions to the Apache 2.0 License ----

As an exception, if, as a result of your compiling your source code, portions
of this Software are embedded into an Object form of such source code, you
may redistribute such embedded portions in such Object form without complying
with the conditions of Sections 4(a), 4(b) and 4(d) of the License.

In addition, if you combine or link compiled forms of this Software with
software that is licensed under the GPLv2 (&#34;Combined Software&#34;) and if a
court of competent jurisdiction determines that the patent provision (Section
3), the indemnity provision (Section 9) or other Section of the License
conflicts with the conditions of the GPLv2, you may retroactively and
prospectively choose to deem waived or otherwise exclude such Section(s) of
the License, but only in their entirety and only with respect to the Combined
Software. ([`0ede284`](https://github.com/OZI-Project/OZI/commit/0ede284551bee0a6c6f17c0ecd27d9d43cfd2be0))

## 0.0.91 (2023-09-12)

### :bug:

* :bug:: Fix ``ozi-new`` source and test report_missing. ([`0ad2897`](https://github.com/OZI-Project/OZI/commit/0ad2897b65593c5442171c2ed793bd821925e00c))

## 0.0.90 (2023-09-12)

### :children_crossing:

* :children_crossing::construction_worker:: Add OZI spec version to workflow templates for docs. ([`de50238`](https://github.com/OZI-Project/OZI/commit/de50238a74107c12043479bc4a702a96326185b0))

* :children_crossing:: Add OZI spec version comments for Documentation.

Also fixes missing [tool.setuptools_scm]. ([`faf6ddb`](https://github.com/OZI-Project/OZI/commit/faf6ddb0c397a1b1105d2594fb93c5d64398b5bd))

### :hammer:

* :hammer::pencil2:: new_module.py.j2 added to install. ([`39ac634`](https://github.com/OZI-Project/OZI/commit/39ac6342a2f9b9141f3f21451a2179957bd125d7))

* :hammer:: Source and test creation with ``ozi-new``. ([`55071ba`](https://github.com/OZI-Project/OZI/commit/55071bac9509ecfe5513881282aba0317dab076c))

* :hammer:: Add py.typed to source_templates. ([`0b2e730`](https://github.com/OZI-Project/OZI/commit/0b2e730d708cf872eb8c508f6a0e9c9f1dba1c82))

## 0.0.89 (2023-09-11)

### :hammer:

* :hammer:: Add strict flag to ``ozi-new project`` and ``ozi-fix``. ([`3f8c4db`](https://github.com/OZI-Project/OZI/commit/3f8c4db094cad91c3dfdbcce7594720c63c6b0bd))

## 0.0.88 (2023-09-11)

### :pencil2:

* :pencil2:: Fix jinja2 include directive. ([`43101e3`](https://github.com/OZI-Project/OZI/commit/43101e3a07d5838b2fd27e5b195669ebf5498732))

## 0.0.87 (2023-09-11)

### :children_crossing:

* :children_crossing: Add ``ozi.spec`` versioned header for meson templates. ([`fa27b03`](https://github.com/OZI-Project/OZI/commit/fa27b031f34b127e4a0bf3ff8e6b8bcb2bfff21a))

## 0.0.86 (2023-09-11)

### :bug:

* :bug:: Fix comment and loop whitespace trimming. ([`5c5040e`](https://github.com/OZI-Project/OZI/commit/5c5040eb1581a02e40620157b8263f871221eeaf))

## 0.0.85 (2023-09-11)

### :bug:

* :lipstick::bug:: Fix meson file header whitespace. ([`d07be48`](https://github.com/OZI-Project/OZI/commit/d07be4845bc4f83519566878367f014cc0a10319))

* :bug:: Fix PKG-INFO whitespace. ([`2ee8841`](https://github.com/OZI-Project/OZI/commit/2ee88414351a0a13e84271a00e9409cee0073fd8))

## 0.0.84 (2023-09-11)

### :bug:

* :bug:: Default topic should be a List[str]. ([`8ab11e6`](https://github.com/OZI-Project/OZI/commit/8ab11e65837720ea8c42e5cd900908887f556083))

* :bug:: Fix PKG-INFO whitespace. ([`eabd4cc`](https://github.com/OZI-Project/OZI/commit/eabd4cccdc594df90e818b48fb9f2c03b50a8496))

### :lipstick:

* :lipstick:: Fix jinja header comment rendering. ([`b5db826`](https://github.com/OZI-Project/OZI/commit/b5db826e3f56a9c17ecd906e8bc32fc2edfc500e))

## 0.0.83 (2023-09-11)

### :bug:

* :bug::pencil2:: Fix another unescaped false positive for Jinja2. ([`076cdbb`](https://github.com/OZI-Project/OZI/commit/076cdbb2ae6e43c92bfdb65f1c16e29c0555d5bb))

## 0.0.82 (2023-09-11)

### :bug:

* :bug::pencil2:: Fix template paths. ([`84363da`](https://github.com/OZI-Project/OZI/commit/84363da70e038896f02d416cd6434e5dd3f2e0b9))

## 0.0.81 (2023-09-11)

### :bug:

* :bug:: Fix unescaped jinja directive false positive. ([`2e074be`](https://github.com/OZI-Project/OZI/commit/2e074beba320179d14166e6bc9c92600b0772e62))

## 0.0.80 (2023-09-11)

### :bug:

* :bug:: Fix missing github templates. ([`78068f8`](https://github.com/OZI-Project/OZI/commit/78068f8ab5e44eeaa460d30825e5073576562061))

## 0.0.79 (2023-09-10)

### :bug:

* :bug:: Fix missing ci workflow and test builf files. ([`0ff5d3b`](https://github.com/OZI-Project/OZI/commit/0ff5d3b2fcb0331bed338aee65f7e1d0e8bc4fc0))

* :bug:: Fix whitespace in templates. ([`d345443`](https://github.com/OZI-Project/OZI/commit/d34544374af83f0b3bc5a44ded71548d09fddbd2))

## 0.0.78 (2023-09-10)

### :bug:

* :bug:: Fix comment newlines. ([`ae54609`](https://github.com/OZI-Project/OZI/commit/ae5460982405889eac5074c6b2148b6efa2b1176))

### :children_crossing:

* :children_crossing:: Allow multiple topic classifiers. ([`4b8ef90`](https://github.com/OZI-Project/OZI/commit/4b8ef9014593c36f6aa44cf10093d59c58abfd1e))

### :hammer:

* :hammer:: add ci_provider_templates and test_templates. ([`5518bb8`](https://github.com/OZI-Project/OZI/commit/5518bb8233781682114b662e43f2a8812a75e558))

## 0.0.77 (2023-09-10)

### :bug:

* :bug:: Fix template path for tests. Fix template line trimming. ([`04ea00b`](https://github.com/OZI-Project/OZI/commit/04ea00bba9525986a0ad81c5592d2eb0692a7ae3))

## 0.0.76 (2023-09-10)

### :bug:

* :bug:: Fix untrimmed whitespace in ``ozi-new project`` output. ([`60e0d10`](https://github.com/OZI-Project/OZI/commit/60e0d1074cbc970cecb15ace97d6c974a83d0de1))

## 0.0.75 (2023-09-10)

### :bug:

* :hammer::bug:: Fix source subdirectory naming. ([`74f7b7e`](https://github.com/OZI-Project/OZI/commit/74f7b7e46d7fba18f5fb65f74cfe756f39c15bd8))

## 0.0.74 (2023-09-10)

### :bug:

* :bug:: Fix wrong subdir install location for OSI Approved licenses. ([`64d547b`](https://github.com/OZI-Project/OZI/commit/64d547bb3d4c18ec4a6b523bb16215e7a50f551a))

## 0.0.73 (2023-09-10)

### :bug:

* :bug::pencil2:: Fix trim filter should be map(&#39;trim&#39;) ([`a2a2099`](https://github.com/OZI-Project/OZI/commit/a2a2099a6c2a1ead538d905100e78001fef5a35d))

## 0.0.72 (2023-09-10)

### :bug:

* :bug:: Fix: trim whitespace from template includes. ([`09e54dd`](https://github.com/OZI-Project/OZI/commit/09e54dd41fda430ca7edf5d1b8093939d1a2e864))

## 0.0.71 (2023-09-10)

### :pencil2:

* :pencil2:: Fix include of project.PKG-INFO. ([`332d1c1`](https://github.com/OZI-Project/OZI/commit/332d1c1b3f7ee8f431bd059476bbb426d8489c7c))

## 0.0.70 (2023-09-10)

### :pencil2:

* :pencil2:: Fix unquoted template include path. ([`3fe0d91`](https://github.com/OZI-Project/OZI/commit/3fe0d91c0a0d748cc67d716d84eaf088b0f843ab))

## 0.0.69 (2023-09-10)

### :bug:

* :bug:: Fix missing resource pyright.pyproject.toml. ([`e9f2363`](https://github.com/OZI-Project/OZI/commit/e9f236386f2f431ea8906ad478d50e0a6d3199f1))

## 0.0.68 (2023-09-09)

### :bug:

* :bug:: FIX: Add missing pyright pyproject.toml template. ([`dc1b22f`](https://github.com/OZI-Project/OZI/commit/dc1b22fcdd17a657eaa6e1ddc4e16c9c95fad648))

## 0.0.67 (2023-09-09)

### :pencil2:

* :pencil2:: Fix template typo. ([`291bdf8`](https://github.com/OZI-Project/OZI/commit/291bdf889b333af2a20b8ebe2a9c0acfc073b735))

## 0.0.66 (2023-09-09)

### :bug:

* :bug::hammer:: Fix incorrect use of split function. ([`b6362b4`](https://github.com/OZI-Project/OZI/commit/b6362b454858aeb04dc2930a5c06a42088c6bc3a))

## 0.0.65 (2023-09-09)

### :bug:

* :hammer::bug:: Add split filter to template globals. ([`935c1a2`](https://github.com/OZI-Project/OZI/commit/935c1a25dad5e2502a5f25203f888e2431f82d14))

## 0.0.64 (2023-09-09)

### :bug:

* :bug::hammer:: Unite default Jinja Namespace with ours. ([`7b0d394`](https://github.com/OZI-Project/OZI/commit/7b0d394161e1f6d2eaa3d7ce30689c03cc9e04ad))

## 0.0.63 (2023-09-09)

### :bug:

* :bug:: Fix for loop over numeric range in Jinja templates. ([`940efbb`](https://github.com/OZI-Project/OZI/commit/940efbbf0464bca6fd8c60e92304e3e39ea06c78))

## 0.0.62 (2023-09-09)

### :bug:

* :hammer::bug:: Fix improper filter invocation in Jinja templates. ([`df1fe8d`](https://github.com/OZI-Project/OZI/commit/df1fe8d56f272599941de823272eeab725d9800f))

## 0.0.61 (2023-09-09)

### :hammer:

* :hammer:: ``ozi-new`` exit(1) for non-empty directory. ([`091d88e`](https://github.com/OZI-Project/OZI/commit/091d88e88ce62a35b5597eee21cc6355010f7518))

* :hammer::truck:: Move templates. ([`199bea2`](https://github.com/OZI-Project/OZI/commit/199bea2f339c98a648cb44878a0e9dfe5f1ad691))

## 0.0.60 (2023-09-09)

### :ambulance:

* :ambulance:: Fix Jinja includes to use a quoted string. ([`a675068`](https://github.com/OZI-Project/OZI/commit/a675068ae2dc1d985613fcfb87d2e2f7f999ba22))

## 0.0.59 (2023-09-09)

### :ambulance:

* :ambulance:: FIX: Ensure that templates are loaded properly. ([`537e2c1`](https://github.com/OZI-Project/OZI/commit/537e2c1f0f3f67267fd0fd2de502c6fa476d05c7))

## 0.0.58 (2023-09-09)

### :hammer:

* :hammer::pencil2:: Fix uneeded call to geturl(). ([`a0d6f35`](https://github.com/OZI-Project/OZI/commit/a0d6f3597740ecac4d8fd48a87cee3c4097a6f3e))

## 0.0.57 (2023-09-09)

### :hammer:

* :pencil2::hammer:: Fix geturl() call. ([`b9a770a`](https://github.com/OZI-Project/OZI/commit/b9a770af4c2c4af2812699ca4ea293fccd649956))

## 0.0.56 (2023-09-09)

### :hammer:

* :hammer::pencil2:: Fix minor typo and bump the PKG-INFO. ([`165730b`](https://github.com/OZI-Project/OZI/commit/165730b5aeb4ce27be834a1a7801c23ffc4e31ad))

## 0.0.55 (2023-09-09)

### :ambulance:

* :hammer::ambulance:: Fix ``ozi-new`` bug that caused early exit. ([`f56f93b`](https://github.com/OZI-Project/OZI/commit/f56f93be9096e837fa2c3fdf9498f6bbb0f16f49))

## 0.0.54 (2023-09-08)

### :children_crossing:

* :hammer::children_crossing:: Update templates - add test and module templates. ([`3ab9892`](https://github.com/OZI-Project/OZI/commit/3ab9892b160a6f163bb9d5741b7cf7944f59e589))

### :hammer:

* :hammer:: Added LICENSE.txt template and license selection disambiguation. ([`f4e52d0`](https://github.com/OZI-Project/OZI/commit/f4e52d01a8164a5384f655529657eee69f4d461b))

## 0.0.53 (2023-09-06)

### :ambulance:

* :ambulance:: Fix entrypoint version arg. ([`e098e8c`](https://github.com/OZI-Project/OZI/commit/e098e8c43e8fbf07d5e76b8ac851ac4175903c27))

## 0.0.52 (2023-09-06)

### :children_crossing:

* :children_crossing::memo:: Update Topics and Clarify Python 3 Only. ([`cfbabcf`](https://github.com/OZI-Project/OZI/commit/cfbabcf008d7ec3d8e32b0e54c073d99c4147475))

* :children_crossing:: Improve help string for main script. ([`716085b`](https://github.com/OZI-Project/OZI/commit/716085b6a7c6ae94f2b10926dbba95d0f38c4613))

### :hammer:

* :hammer:: Improve main entrypoint help.

Also made ``--version`` work. ([`d804b32`](https://github.com/OZI-Project/OZI/commit/d804b320d7d074f9085b8b31631c2f614b8695c0))

## 0.0.51 (2023-09-05)

### :bento:

* :memo::bento:: Update readme for clarity. ([`172c1b5`](https://github.com/OZI-Project/OZI/commit/172c1b532613e41006a859a4b44e6aec90cc45c1))

### Other

* :memo:: Resychronize README.rst. ([`8a57e39`](https://github.com/OZI-Project/OZI/commit/8a57e3906f5456e8180ff0c7a01eeb0ee5beacf3))

## 0.0.50 (2023-09-05)

### :ambulance:

* :hammer::ambulance:: Fixed ``ozi/new.py`` PKG-INFO. |

Also added environment, framework, language and typing to PKG-INFO. ([`5e53d4d`](https://github.com/OZI-Project/OZI/commit/5e53d4dfa77dec79185cf2439728fce378f6a421))

### :hammer:

* :hammer:: Add ``--audience`` to ``ozi/new.py``.

Also fixed PKG-INFO template. ([`d9bf177`](https://github.com/OZI-Project/OZI/commit/d9bf177d22215b20356ba9ac7c7c34958cb3638a))

### :pencil2:

* :pencil2:: Remove ``__init__.pyi``from meson.build. ([`5e5e583`](https://github.com/OZI-Project/OZI/commit/5e5e583cdf323c6b1913e7d6a73311e928bcf9fb))

## 0.0.49 (2023-09-05)

### :hammer:

* :hammer:: Fix ``ozi-fix`` crash if PKG-INFO is missing. ([`79048c0`](https://github.com/OZI-Project/OZI/commit/79048c0da7af5eed72ceb595177b9078173af18d))

### Other

* :art:: Blacken and isort ``ozi/new.py``. ([`e1fabc6`](https://github.com/OZI-Project/OZI/commit/e1fabc6a6658d3536185dbb71911c93d0b5dddd9))

* :art: Add E203 to Flake8 ignore to allow for black slice style. ([`e11fef2`](https://github.com/OZI-Project/OZI/commit/e11fef2581a804bd090273e266ad24c1a571c0bc))

## 0.0.48 (2023-09-05)

### :ambulance:

* :ambulance::construction_worker:: Fix wheel versions. Was building all on 3.11. ([`0ccfa1e`](https://github.com/OZI-Project/OZI/commit/0ccfa1e2f6c2aaa6198b5d0152031f1e61ccb4fd))

## 0.0.47 (2023-09-05)

### :ambulance:

* :ambulance:: Fix release workflow. ([`476246b`](https://github.com/OZI-Project/OZI/commit/476246be55082d821669a00ffac2c9494ebf9313))

* :ambulance:: Fix release trigger checks. ([`7ac2795`](https://github.com/OZI-Project/OZI/commit/7ac2795555b353082b6c3d9fb7585935414781b9))

* :ambulance:: Fix CI Build. ([`0abe8b4`](https://github.com/OZI-Project/OZI/commit/0abe8b46ef6b80b418edcafbfa8c9220b1ef34de))

* :ambulance::construction_worker:: Fix release step outputs. ([`50c8a94`](https://github.com/OZI-Project/OZI/commit/50c8a943df4650a2ae6b63366b6f470a8d8f66c8))

* :construction_worker::ambulance:: Fix release workflow being completed for any push.

We now should only do a full release workflow if semantic-release triggers one. ([`61b1141`](https://github.com/OZI-Project/OZI/commit/61b1141d0c57e2d526fd6fd7d9128f8d9907015a))

## 0.0.46 (2023-09-04)

### :pencil2:

* :pencil2::construction_worker:: Update workflow name to OZI. ([`d59200f`](https://github.com/OZI-Project/OZI/commit/d59200f8cd64bb9727c7fe77fdd9ab7f69e81d3f))

## 0.0.45 (2023-09-04)

### :ambulance:

* :ambulance:: Move dist-info before release. ([`ca4d90d`](https://github.com/OZI-Project/OZI/commit/ca4d90d1e88944b9b8886671c64379f13206dd4d))

* :ambulance:: Fix release tag output ([`369881a`](https://github.com/OZI-Project/OZI/commit/369881a9d9d7512270999cd14dc7892ec792530f))

* :ambulance: move artifact to CWD. ([`cad344f`](https://github.com/OZI-Project/OZI/commit/cad344fdf26c21396c58798e01c7e2a9ddb7807f))

* :ambulance:: update gitignore template and gitignore. ([`6de3068`](https://github.com/OZI-Project/OZI/commit/6de306822ac4ea2740ae58157b6601c0dc8f372c))

* :ambulance::construction_worker:: Separate release and publish with artifacting. ([`e1ae4fd`](https://github.com/OZI-Project/OZI/commit/e1ae4fd56424504f3add9d7d2a30ce76276e0a3e))

* :ambulance::construction_worker:: Switch to sequential matrix action. ([`a2eb098`](https://github.com/OZI-Project/OZI/commit/a2eb098f60f5dda67e425023db152f153f8782ec))

* :ambulance::construction_worker:: Wait until builds complete to release. ([`8ac8c93`](https://github.com/OZI-Project/OZI/commit/8ac8c93d3adfca319b386f63cffc6e0573e5154b))

* :ambulance:: Fix CI workflow release versioning. ([`5b2fb2e`](https://github.com/OZI-Project/OZI/commit/5b2fb2e03b1481090333832f4816ba3487f39cb6))

* :ambulance:: Checkout released tag for publish. ([`9754cd1`](https://github.com/OZI-Project/OZI/commit/9754cd13040c61386f5f098540b78c93da82a2cc))

* :ambulance::construction_worker:: Second retry of 0.0.45, fixed some conditionals. ([`f558a13`](https://github.com/OZI-Project/OZI/commit/f558a13b34e33123d28383fd6e1d1eb815a1702f))

* :ambulance::pencil2:: Retry 0.0.45 with version as strings. ([`702e6d2`](https://github.com/OZI-Project/OZI/commit/702e6d211e5a2578aa923e81329819d297b4ff1c))

* :ambulance:: Attempt a more hermetic release with indv. versioned wheels we need. ([`7d2e4d9`](https://github.com/OZI-Project/OZI/commit/7d2e4d9d1b7af60a7cdda3b0e528b0909b89634d))

### :pencil2:

* :pencil2:: Fix version used for checkout and download. ([`2d5fdcd`](https://github.com/OZI-Project/OZI/commit/2d5fdcd9d07c0bfa6e2af4b68f499e6959b55159))

* :pencil2:: Fix PKG-INFO version overreach. ([`3a97d37`](https://github.com/OZI-Project/OZI/commit/3a97d372d1b9653e5f63ee64c954ca95f67278e5))

### Other

* :construction_worker:: Rename dist-info to match wheels. ([`81be710`](https://github.com/OZI-Project/OZI/commit/81be710209ed70c7caf0ae360374ba55a79a04a4))

* :construction_worker:: Move dist-info for all wheel releases. ([`ebc5e2f`](https://github.com/OZI-Project/OZI/commit/ebc5e2f504eaa15172644061aa499ac7bc5d59d0))

* :construction_worker:: Drop sdist for now. ([`e1a4628`](https://github.com/OZI-Project/OZI/commit/e1a46286348e11e0afa0f24883fd86f9f4663498))

* :construction_worker:(PKG-INFO): Bump Version. ([`dbfb676`](https://github.com/OZI-Project/OZI/commit/dbfb676e6b2236dfc92124c352b60b8f0dbc3f89))

* :memo:: Remove extraneous workflow file header. ([`ba1a5af`](https://github.com/OZI-Project/OZI/commit/ba1a5af352b32313c609f121dc9c9fc2659c4a88))

* :construction_worker:: merge before pushing PKG-INFO. ([`c08266c`](https://github.com/OZI-Project/OZI/commit/c08266cbc8f3da8034373d2354d679b765563114))

* :construction_worker:: Merge PKG-INFO during release. ([`7df4e56`](https://github.com/OZI-Project/OZI/commit/7df4e56e128aa629e10683fd944ae28b880a3666))

* :construction_worker:: Fixing sdsist. ([`26e6c5e`](https://github.com/OZI-Project/OZI/commit/26e6c5eba95e2fea44efa66f765d039555607ea3))

* :construction_worker:: Get correct ambient credentials for sdist. ([`239f3c5`](https://github.com/OZI-Project/OZI/commit/239f3c5121465e92e5f98e690a35c0854ca95eb4))

* :construction_worker:: Add phony checkout for ambient credentials. ([`98c2670`](https://github.com/OZI-Project/OZI/commit/98c2670f1a0859673f93b9ebe13a5ccf0000bf2c))

* :construction_worker:: Fix sdist git credentials. ([`39f4259`](https://github.com/OZI-Project/OZI/commit/39f425996c4f0be8ccf3d06a0a7cc89ad9f3e66b))

* :construction_worker:(pyc_wheel): Only strip the built wheel not finished wheels.

Add version detection from tag. ([`44a7f05`](https://github.com/OZI-Project/OZI/commit/44a7f05be277ae280dce272f181fceda87f42962))

* :construction_worker:(pyc_wheel): strip correct wheel version. ([`9ea0c93`](https://github.com/OZI-Project/OZI/commit/9ea0c9375e1a48562933beadf1731e387bdd6711))

* :construction_worker:: Only configure git repo the first time. ([`c528ac6`](https://github.com/OZI-Project/OZI/commit/c528ac645b7ccf43350d1d875c6ed1fd6761810d))

* :construction_worker:: Reverse python version build order.
sdist (py311) runs last.
this avoid commiting PKG-INFO too early. ([`14d6edc`](https://github.com/OZI-Project/OZI/commit/14d6edc658c8cd7daf802310f45411e18f6ad481))

* :construction_worker:: Use actions/download-artifact to get repo for wheel builds. ([`37ad739`](https://github.com/OZI-Project/OZI/commit/37ad739c365653ceb4f7616fe195d9578b75d50b))

* :construction_worker:(PKG-INFO): Bump Version. ([`e03b527`](https://github.com/OZI-Project/OZI/commit/e03b52768db0157d3490a5d26e0ee8aa0aa17d48))

* :construction_worker:: Only run git checkout once per release. ([`acfe7c2`](https://github.com/OZI-Project/OZI/commit/acfe7c2e832c58e3cf8dbf041de33881b2a69e40))

* :construction_worker:(PKG-INFO): Bump Version. ([`6a48956`](https://github.com/OZI-Project/OZI/commit/6a4895634585f86820b9d328d98ae92d3b61e423))

* :construction_worker:(PKG-INFO): Bump Version. ([`e556184`](https://github.com/OZI-Project/OZI/commit/e556184a8868b4a99e46fd959eb3277951bf73a4))

* :construction_worker:: relocate git repo setup. ([`72c648c`](https://github.com/OZI-Project/OZI/commit/72c648cd2a9292b79316c7a1381041c635510f5f))

* :construction_worker:: correctly name wheel files. ([`617c065`](https://github.com/OZI-Project/OZI/commit/617c065498d5d679d947887ff5bb2c884e6e6df6))

* :construction_worker:(PKG-INFO): Bump Version. ([`4e4cbb2`](https://github.com/OZI-Project/OZI/commit/4e4cbb2dc6a8b690dac1142b09bc6167448c9330))

## 0.0.44 (2023-09-03)

### :hammer:

* :hammer:: Update ``ozi-new`` and ``ozi-fix`` scripts. ([`2a2a131`](https://github.com/OZI-Project/OZI/commit/2a2a131b83c19d3e70a9b72147c506aaff6294cc))

### Other

* :construction_worker:(PKG-INFO): Bump Version. ([`e8897da`](https://github.com/OZI-Project/OZI/commit/e8897da27fbb1e14a4d3e33611d026937232ebfd))

## 0.0.43 (2023-09-02)

### :bento:

* :bento:: fix missing asset listing for ``structure.py``. ([`be3bc6f`](https://github.com/OZI-Project/OZI/commit/be3bc6fb2923e03ea7a06ddc4969552a86bc77c6))

### :hammer:

* :hammer:: Fix ``ozi`` entrypoint. ([`5628c02`](https://github.com/OZI-Project/OZI/commit/5628c02dc835d30b2ea66adb1cfd9c55396f38f9))

### Other

* :construction_worker:(PKG-INFO): Bump Version. ([`5c10473`](https://github.com/OZI-Project/OZI/commit/5c1047327f7f673d1868bbf934e5d4f2ca2cf6c5))

## 0.0.42 (2023-09-02)

### :hammer:

* :hammer:: Fix relative import in ``ozi-fix``. ([`a23d78d`](https://github.com/OZI-Project/OZI/commit/a23d78decda22cc9b36c05905e0cbfde2d6f172d))

### Other

* :construction_worker:(PKG-INFO): Bump Version. ([`baa497e`](https://github.com/OZI-Project/OZI/commit/baa497e47225b5d51596f0f6409283f849a43b16))

## 0.0.41 (2023-09-02)

### :bento:

* :bento::memo:: Cleanup README and PKG-INFO. ([`20a2766`](https://github.com/OZI-Project/OZI/commit/20a2766b07c1d1121f3ae060e1f540292032e59e))

### :hammer:

* :hammer: update github workflow templates. ([`e7babd1`](https://github.com/OZI-Project/OZI/commit/e7babd1b78a9501808e387e25707e165fcfc388b))

* :hammer:: Add ``ozi`` script entrypoint. ([`dfc96a8`](https://github.com/OZI-Project/OZI/commit/dfc96a80a551c91867aaa6427a01b16f32931324))

* :hammer:: Add ``ozi-fix`` script for making rewrites. ([`ce4222e`](https://github.com/OZI-Project/OZI/commit/ce4222e507577dec2be8349fd5c6fde55fd82d07))

* :hammer:: Add --no-verify-email to ``ozi-new`` script. ([`4d0030a`](https://github.com/OZI-Project/OZI/commit/4d0030a586756b71065445bf076a5ef9c31a6eff))

### :pushpin:

* :pushpin:: Pin action versions with hash. ([`3fdaa02`](https://github.com/OZI-Project/OZI/commit/3fdaa02d88a6be0dde46d9bb365a8f5233f01a61))

### :wrench:

* :wrench:: Add pseudo-targets root_files and source_files. ([`e14ea88`](https://github.com/OZI-Project/OZI/commit/e14ea889aa8a1f16fb05bdb263756feb2a84b51a))

### Other

* :construction_worker:(PKG-INFO): Bump Version. ([`470d40e`](https://github.com/OZI-Project/OZI/commit/470d40e0cfd6ae82afe1f7c537cf5011e710d775))

## 0.0.40 (2023-09-01)

### :pencil2:

* :pencil2:: Add missed template from move. ([`a366872`](https://github.com/OZI-Project/OZI/commit/a366872e2120a79d19c89aa5047950b1046022de))

### Other

* :construction_worker:(PKG-INFO): Bump Version. ([`3339932`](https://github.com/OZI-Project/OZI/commit/3339932f9b5753de03f39691d9685c0ce270c302))

## 0.0.39 (2023-09-01)

### :ambulance:

* :ambulance:: Manually fix git permissions. ([`168338f`](https://github.com/OZI-Project/OZI/commit/168338f9077bc3b96456ebac771395daf2b1adf0))

* :ambulance:: Ensure that we have privileges in the .git directory during build. ([`112e7b8`](https://github.com/OZI-Project/OZI/commit/112e7b878bcd366a7ffca87464319100e0a3ac7a))

* :hammer::ambulance:: Fix relative module import. ([`d159122`](https://github.com/OZI-Project/OZI/commit/d15912294f6d52802e8fe49c0503666c040c33c6))

### Other

* :construction_worker:(PKG-INFO): Bump Version. ([`4dad555`](https://github.com/OZI-Project/OZI/commit/4dad55587b5ce6ec26f6fed7d1b3f1948d2ce272))

## 0.0.38 (2023-09-01)

### :pencil2:

* :pencil2::wrench:: Fix wheel build. ([`a335272`](https://github.com/OZI-Project/OZI/commit/a3352728a55f875f6cbd569b6340dac06dec8d5d))

### Other

* :construction_worker:(PKG-INFO): Bump Version. ([`11818bb`](https://github.com/OZI-Project/OZI/commit/11818bbedad7f7e329d34b75debdf7cc5c2c09d7))

## 0.0.37 (2023-09-01)

### :wrench:

* :wrench:: Add subdir to install_sources template. ([`105cd73`](https://github.com/OZI-Project/OZI/commit/105cd73b01eec634997b40106c8a4d9296b30776))

* :wrench:: Fix meson build for mesonpep517 wheel. ([`f6daa66`](https://github.com/OZI-Project/OZI/commit/f6daa66e00b073ff132da25a1153868cf94405b6))

### Other

* :construction_worker:(PKG-INFO): Bump Version. ([`46279ac`](https://github.com/OZI-Project/OZI/commit/46279acf8a5cc1025c85a0aca0eb1054206fce7b))

## 0.0.36 (2023-09-01)

### :ambulance:

* :ambulance::hammer:: Fix meson entry point finding. ([`30c3eb0`](https://github.com/OZI-Project/OZI/commit/30c3eb09f59b80887f43cb2cede5cc66135a8d91))

### Other

* :construction_worker:(PKG-INFO): Bump Version. ([`87e5573`](https://github.com/OZI-Project/OZI/commit/87e5573ff78dbdb01b64328715dc70774c40f7b6))

## 0.0.35 (2023-09-01)

### :ambulance:

* :ambulance:: Fix python install sources for meson. ([`5c47a59`](https://github.com/OZI-Project/OZI/commit/5c47a59f1312eac75c53cb9693081920d77a95fc))

* :ambulance:(CI): Properly invoke release build with meson. ([`3ff7d07`](https://github.com/OZI-Project/OZI/commit/3ff7d0751888d102af24165ac5f1e9fd2e958828))

* :ambulance:: Fix implementation of python.install_sources(). ([`d50200b`](https://github.com/OZI-Project/OZI/commit/d50200be2ace24e5162ed5c12ce930a87617b22d))

### :fire:

* :fire:: remove duplicate workflow scripts folder. ([`239ef1a`](https://github.com/OZI-Project/OZI/commit/239ef1a110fb2766cc5b0c8ec14c203ab5edacca))

### :pencil2:

* :pencil2::wrench:: Fix unquoted string in build. ([`5a9feb4`](https://github.com/OZI-Project/OZI/commit/5a9feb4842bba3b5b1efd653b833b3d9c5922ddf))

* :pencil2::wrench:: Fix missing commas in build. ([`0a5febd`](https://github.com/OZI-Project/OZI/commit/0a5febdc030eb68e7b3fb5c49020f3746f150a7b))

### Other

* :construction_worker:(PKG-INFO): Bump Version. ([`dc0e174`](https://github.com/OZI-Project/OZI/commit/dc0e174330a07b10028bba864cecf10350923509))

## 0.0.34 (2023-09-01)

### :ambulance:

* :ambulance:: Fix script location. ([`5c82b2b`](https://github.com/OZI-Project/OZI/commit/5c82b2bfa4f6fe1a8d67453ca5a00771fdf4e017))

### Other

* :construction_worker:(PKG-INFO): Bump Version. ([`f426f8b`](https://github.com/OZI-Project/OZI/commit/f426f8b778ff4234213abaddcd72a4881004f3b2))

## 0.0.33 (2023-09-01)

### :children_crossing:

* :children_crossing:: Add project script ``ozi-new``. ([`5a91afc`](https://github.com/OZI-Project/OZI/commit/5a91afc310ef26eb3401c3f39280f948dfcff77a))

### Other

* 🚑️: Fix script entrypoint name. ([`7ab1b06`](https://github.com/OZI-Project/OZI/commit/7ab1b067feb58f8440955ecace0c87bd6bb87334))

* :construction_worker:(PKG-INFO): Bump Version. ([`66d1b0a`](https://github.com/OZI-Project/OZI/commit/66d1b0aa7f31c401e617164c034cf04334d5bff0))

## 0.0.32 (2023-08-31)

### :bento:

* :fire::bento:: Delete ``assets/structure`` ([`c7da0ec`](https://github.com/OZI-Project/OZI/commit/c7da0ec0c710593aa4ab14fb2cdbd5b7070a54dd))

### :wrench:

* :wrench::truck:(project): Move core templates and assets from OZI.docs. ([`959f38d`](https://github.com/OZI-Project/OZI/commit/959f38d46214c80671c0af2df252b7196b65e9cd))

### Other

* :busts_in_silhouette:: Add CODE_OF_CONDUCT.md ([`1f944ff`](https://github.com/OZI-Project/OZI/commit/1f944ff53c3be973fa6e0fcca04d398607c846ce))

* :construction_worker:(PKG-INFO): Bump Version. ([`7be3c2b`](https://github.com/OZI-Project/OZI/commit/7be3c2b672341b6226f8267cc3045e753ba4a870))

## 0.0.31 (2023-08-30)

### :children_crossing:

* :children_crossing:(semantic-release): Fix commit parsing. ([`e6d349d`](https://github.com/OZI-Project/OZI/commit/e6d349d58d8a6d8c36e3778217c8a5cf7c6f1c00))

### Other

* :construction_worker:(PKG-INFO): Bump Version. ([`b16af53`](https://github.com/OZI-Project/OZI/commit/b16af531534be46e98bb5f04ddf4ec46f9501cbf))

## 0.0.30 (2023-08-30)

### :ambulance:

* :ambulance: Fix SCM tracked version. ([`9a5a7cb`](https://github.com/OZI-Project/OZI/commit/9a5a7cbbafc8ef561e1785442c66ec1bb7c3cddf))

* :wrench::ambulance:(semantic-release): Fix args for major version bump 7 to 8. ([`501d387`](https://github.com/OZI-Project/OZI/commit/501d3873291958249ed6561688ec7ad34c55ec39))

### :wrench:

* :wrench:(meson): drop rst-lint for now. ([`7b35036`](https://github.com/OZI-Project/OZI/commit/7b35036b6d27b613b40fe8ecd30f05c21ac4d59b))

* :wrench:(tox): fix tox-gh env names. ([`81e1ebf`](https://github.com/OZI-Project/OZI/commit/81e1ebf6ba28d1acf7eab9b36d0a33b66528f186))

* :construction_worker::wrench:: Move test workflow into dist-workflow.yml ([`c2f16a1`](https://github.com/OZI-Project/OZI/commit/c2f16a14fb315e9d9225a76b93593a6863a72cbb))

### Other

* :pencil: remove trailing newline PKG-INFO template. ([`0304af0`](https://github.com/OZI-Project/OZI/commit/0304af0be29deecc8b8c0d9fa6f4200b5a11e8bd))

* :memo:: remove pytest badge. ([`1d1acde`](https://github.com/OZI-Project/OZI/commit/1d1acdedd1fefb6b1e4bd240c9ed9b9a8991a430))

* :pencil: delete symlink. ([`38076dd`](https://github.com/OZI-Project/OZI/commit/38076ddb4173b9a0261a3b0d34155facf2113dd5))

* :construction_worker:(gh-actions): Parity with blastpipe. ([`8bb5ebe`](https://github.com/OZI-Project/OZI/commit/8bb5ebe856eee7a43d01d45ea422c131d94b2777))

* 🎨: Blacken script files. ([`6b5cc15`](https://github.com/OZI-Project/OZI/commit/6b5cc15b1d14cdbe3399a59f94c874cbce1282f3))

* 🔥: remove the file setuptools_tools.py for now. ([`e66738d`](https://github.com/OZI-Project/OZI/commit/e66738d830632483a1817d59d654879835e4a9de))

* :construction_worker:: Drop docs from workflow. ([`8981a12`](https://github.com/OZI-Project/OZI/commit/8981a12650217a2f13af9cfde7db90c57d71d100))

* 👷: add all deps to tox. ([`b013818`](https://github.com/OZI-Project/OZI/commit/b013818bdfb5f155cdcba539f480944a146efb83))

* 🚑️👷(tox-gh): fix 3.11 build and delete Windows testing. ([`95c5f4f`](https://github.com/OZI-Project/OZI/commit/95c5f4fc55ffabd8e3a6a08756464d47e68230ad))

* 🐛(tox): delete --skip-pkg-install argument in CI. ([`d2d0cda`](https://github.com/OZI-Project/OZI/commit/d2d0cda2d2b729d7dc743fca980a967c07c54f2e))

* 🔨🚑️: FIX: sync_pkg_readme should use meson.source_root(). ([`ed99470`](https://github.com/OZI-Project/OZI/commit/ed994701df37ff0ceda6dca96cd501c2fcf08749))

## 0.0.29 (2023-08-29)

### :bug:

* :bug: try remove .git/COMMIT_EDITMSG during build. ([`8ea37ef`](https://github.com/OZI-Project/OZI/commit/8ea37ef48cb525675c87152a5921ea00d235d88f))

* :bug: Attempt to force a version by fixing permissions. ([`718e36d`](https://github.com/OZI-Project/OZI/commit/718e36d859019153276c2a1b239fc9dc788b2ec0))

* :bug: Attempting to force COMMIT_MSG permissions. ([`a3af65f`](https://github.com/OZI-Project/OZI/commit/a3af65ffe215d84e749281f192f58180ef3e471d))

* :bug: empty commit message during release. ([`8375f5a`](https://github.com/OZI-Project/OZI/commit/8375f5a716ce704cbafaea070619673e129532c6))

* :bug:(dist-workflow): fix permissions for commit. ([`f3e7929`](https://github.com/OZI-Project/OZI/commit/f3e79293f5882936b7d984f8fe921722cd60347a))

* :bug:(PKG-INFO): Ensure that PKG-INFO is updated at release. ([`23aa8e6`](https://github.com/OZI-Project/OZI/commit/23aa8e6367ce9d47ae130972f4a6ae563fcb6e13))

* :bug:(CI): don&#39;t stash mesons source of version info. ([`9f3d311`](https://github.com/OZI-Project/OZI/commit/9f3d3113881b5e5bd714d9ac4622cfc4ead0e486))

## 0.0.28 (2023-08-29)

### Other

* 🚑️(pyproject.toml:tool.semantic_release): No hardcoded version. ([`f2cad32`](https://github.com/OZI-Project/OZI/commit/f2cad323e928c8dbe12eb2f9d70dc136a11b340b))

## 0.0.27 (2023-08-29)

### :bug:

* :bug:(CI): forcing a patch. ([`799789c`](https://github.com/OZI-Project/OZI/commit/799789c805d310b4273c9c807dfbedfe1c8f8963))

* :bug:(version): Attempting direct version bump. ([`40440ed`](https://github.com/OZI-Project/OZI/commit/40440ed43b5b8951dae8097c52c005cce6913e63))

* :bug:(project): Patch release trigger. ([`0c0796d`](https://github.com/OZI-Project/OZI/commit/0c0796d329403652a3e1250b5bc71818980800b4))

### Other

* :construction_worker:(build): revert manual bump. ([`6f612c9`](https://github.com/OZI-Project/OZI/commit/6f612c9ec2f3f21db6f797fa7bd27ea34f1685d5))

* 🐛(pyproject.toml): Fix fallback version blocking release trigger. ([`75b68d4`](https://github.com/OZI-Project/OZI/commit/75b68d4f0aefd68b32dbfa6e6b2dd1b856b0b365))

* 🐛(CI/gh-actions): This should trigger a semantic-release. ([`7ea080a`](https://github.com/OZI-Project/OZI/commit/7ea080a0e35858656ff80020682673a9a6b27fdf))

* 🐛: Release should trigger. Deleted unused key. ([`e1899e9`](https://github.com/OZI-Project/OZI/commit/e1899e9f01b4230f8f63ea558c5c85d65b1ba593))

* 🚑️: Only build wheel on successful release. ([`000953f`](https://github.com/OZI-Project/OZI/commit/000953f4259a0f0d08c5487984240b4af2687ef1))

* Remove Windows Classifier. ([`92d424c`](https://github.com/OZI-Project/OZI/commit/92d424ccdc918367cd01c7865436f55c29b3ea45))

## 0.0.26 (2023-08-29)

### Other

* 👷: remove dist-info glob. ([`8d89d33`](https://github.com/OZI-Project/OZI/commit/8d89d332e06d9f298ecb49aa824da4551dddcb45))

* 👷: move dist-info to sig. ([`78bb99e`](https://github.com/OZI-Project/OZI/commit/78bb99e61502d514bdd0ac2d3025d88997e6aaee))

* 👷: add hardcoded prefixes for now -py3-none-any. ([`9654dc1`](https://github.com/OZI-Project/OZI/commit/9654dc1e37e809c8f21c4fecf8db9afb025872ba))

* :pencil: rekor should have been sigstore. ([`66d5571`](https://github.com/OZI-Project/OZI/commit/66d557191946721999a26164c6a88817d883bd92))

* 🏗️: move signatures out of dist after build. ([`9310b36`](https://github.com/OZI-Project/OZI/commit/9310b369a0d673767b8bbd13b6c81fe74ba1c471))

* 🏗️: Move CI build out of dist. ([`b3d7dba`](https://github.com/OZI-Project/OZI/commit/b3d7dbaf721c414c5fe55f0913729f34815dfb48))

* 👷: Fix OZI case by hard-coding for now. ([`513612d`](https://github.com/OZI-Project/OZI/commit/513612d9d5c5e4fd2f0eae7dc400b18bb2945d96))

* 👷:update maintainer email. ([`b905956`](https://github.com/OZI-Project/OZI/commit/b905956d6acc550b0c568e05296d175731bc84d6))

* 👷: No longer attempting to upload signatures to PyPI. ([`c9c630e`](https://github.com/OZI-Project/OZI/commit/c9c630e5d1a2007bd29d2b59d895d5d131378161))

* 👷: May still need to stash PKG-INFO. ([`1104ff6`](https://github.com/OZI-Project/OZI/commit/1104ff65f97b813c22b2adae419790773b4a2a2b))

* 🏗️👷: remove git invocation during wheel build. ([`8b53863`](https://github.com/OZI-Project/OZI/commit/8b53863c573269760b44250e9d2c6165cb4e82d9))

* 👷: Fix gh-actions permissions. ([`750b208`](https://github.com/OZI-Project/OZI/commit/750b208903b00141fc333e0b8da6102118c2340c))

* 🏗️: release then build. ([`12b14db`](https://github.com/OZI-Project/OZI/commit/12b14db94b61b60754cc7a0b604e5a503bacc242))

* 👷: Add CI/CD user name &#34;OZI Packaging&#34;. ([`c1430b8`](https://github.com/OZI-Project/OZI/commit/c1430b86ed8de6c1352faa03f62af9ff030abcae))

* 👷: add noreply git user. ([`e960a9d`](https://github.com/OZI-Project/OZI/commit/e960a9d809ebe2af702d0054baf4e28198669424))

* :pencil: Fix unnecessary escaping. ([`b5803e4`](https://github.com/OZI-Project/OZI/commit/b5803e4f52afa5e30d41317db759d2b9f439880a))

* 🏗️: bind semantic_release.version_toml to setuptools_scm.fallback_version. ([`9f275ad`](https://github.com/OZI-Project/OZI/commit/9f275ad7378ad9553ccda638f69cc66b967625c7))

* :pencil: should have kept setuptools_scm. ([`931f1c0`](https://github.com/OZI-Project/OZI/commit/931f1c00b8a0721a4970053b0061d7b59be04059))

* 👷: pip install --user --upgrade ninja ([`9662564`](https://github.com/OZI-Project/OZI/commit/966256423aa3ddb68726c21d78b779ea77dfb0cd))

* 👷: Fix missing setuptools_scm. ([`c301871`](https://github.com/OZI-Project/OZI/commit/c3018716ceb0efa799ca20c6f30a89591d80ed3e))

* move all of CI build out of semantic-release. ([`5ff06a7`](https://github.com/OZI-Project/OZI/commit/5ff06a74c00282f507861182f169c0d59abc0328))

* 👷: move pyc_wheel out of semantic-release build cmd. ([`2715570`](https://github.com/OZI-Project/OZI/commit/2715570469c066ad1145d17e07d1b8ce2a2023f0))

* add ci build requirements. ([`69672f5`](https://github.com/OZI-Project/OZI/commit/69672f5e703a80bfbcb2e3aea9172dcdbbc76352))

* :pencil:: fix path root on build check. ([`914bb5d`](https://github.com/OZI-Project/OZI/commit/914bb5d98f831372831c65599d836423806d1692))

* :pencil:: Should have built -w (wheel) ([`d4180ea`](https://github.com/OZI-Project/OZI/commit/d4180ea1b39c01ebb40703512da6a1a3062db9ff))

* 🔧Do our own build during release CI. ([`e7c6a58`](https://github.com/OZI-Project/OZI/commit/e7c6a58ecd621901c9445f23ba8646ae28ffa4b7))

* update CI actions. ([`8f7ba72`](https://github.com/OZI-Project/OZI/commit/8f7ba72f8d0959cf6de7ef4155ee74358e91e211))

* 🔧: install build during CI. ([`b23c529`](https://github.com/OZI-Project/OZI/commit/b23c529e296fb8c2dafe5f096f65ba6b9ee10bba))

* ⬆️(python-semantic-release): Bump version to 8.0.8. ([`9c2bc45`](https://github.com/OZI-Project/OZI/commit/9c2bc45a364f76695fee4f12f42a21d3dc9f6448))

* update semantic release version. ([`4ba7161`](https://github.com/OZI-Project/OZI/commit/4ba71618fc3220ab80c3e8dbcc718b057ee901e5))

* add workflows. ([`b2802f8`](https://github.com/OZI-Project/OZI/commit/b2802f8ef0761b5b0068623ac91cf77864644598))

* Create python-publish.yml ([`c2e507d`](https://github.com/OZI-Project/OZI/commit/c2e507ddaf3c43bcd08b9b98ebdd6bdcb24b8d60))

* :pencil:(README): Fix indentation. ([`979e948`](https://github.com/OZI-Project/OZI/commit/979e948303fd32569f4fc3a4462fc42573b946be))

* 👷: HOTFIX Relative directory traversal in scripts. ([`ffd966d`](https://github.com/OZI-Project/OZI/commit/ffd966dde388677db380e6ea78e2e0b1cf70f522))

* :loud_sound: Added release changes. ([`b479657`](https://github.com/OZI-Project/OZI/commit/b479657fc6dbf60012090391551b7b38fa2f4265))

* Updated PKG-INFO Version. ([`01ba8d5`](https://github.com/OZI-Project/OZI/commit/01ba8d57ffe0927737675a57365a5860e610e9cc))

* :pencil: Revert Version. ([`8d37ca7`](https://github.com/OZI-Project/OZI/commit/8d37ca7ab25614bca8fe6f68763e1980ed07ce89))

* :pencil: commit changelog during release. ([`e646d0b`](https://github.com/OZI-Project/OZI/commit/e646d0bc8377635520eddc23bb46e4da2583c540))

* :loud_sound: Added release changes and updated PKG-INFO. ([`bbfd15a`](https://github.com/OZI-Project/OZI/commit/bbfd15a39704c2934a3ee86bd44d98866801adb0))

* :pencil: fix version. ([`7ef2a05`](https://github.com/OZI-Project/OZI/commit/7ef2a05cfd70f74d33418d706b5a1e0df518da0b))

* :pencil: remove commit ammend. ([`083284e`](https://github.com/OZI-Project/OZI/commit/083284e09ec6feabd5213b631233b0260ca93325))

* :pencil:(pyproject.toml): --noedit should be --no-verify. ([`d002a1f`](https://github.com/OZI-Project/OZI/commit/d002a1f2a312e644822b7030887d50aa819cf7c6))

* :loud_sound: Added release changes and updated PKG-INFO. ([`6a5d7bb`](https://github.com/OZI-Project/OZI/commit/6a5d7bbdef9ac149dbe3098c766d2e1d615f2b7f))

* 🚧(meson.build): Commented out migrated install summary. ([`54d31c9`](https://github.com/OZI-Project/OZI/commit/54d31c99156019b4e408587a8978b5b0a6832ad0))

* 🔧: Added mypy to optional-dependencies and requirements. ([`ba78c65`](https://github.com/OZI-Project/OZI/commit/ba78c65ae0b2b9444973d3485d6d24f53314ebc5))

* remove unecessary license header ([`4b09e8b`](https://github.com/OZI-Project/OZI/commit/4b09e8bd097c4005b07c22796e82069412ed9458))

* 🔧(ozi/scripts/meson.build): Add sync_pkg_readme.py. ([`d32bac9`](https://github.com/OZI-Project/OZI/commit/d32bac9718502e8218302a3e962ee5dae249c065))

* 🔨(meson.options): add mypy to lint utilities. ([`bee2247`](https://github.com/OZI-Project/OZI/commit/bee2247ae33974885faa57db4a10550686ff9d0f))

* 🔧🎨(meson.build): Move code out of blastpipe and format. ([`6f4a0d2`](https://github.com/OZI-Project/OZI/commit/6f4a0d2765350008882fd6fbd88935e73efd5885))

* 🔧(pyproject.toml:tool.semantic_release): Update to target standard 0.1 milestone. ([`06286da`](https://github.com/OZI-Project/OZI/commit/06286dad75f3d0c3ef0cd196acd827b50f2e4e55))

* FIX: potential CWE-23. ([`620ef68`](https://github.com/OZI-Project/OZI/commit/620ef68907b5d7a00bdcc8613e161fcc70ed9514))

* FIX: CWE-23 ([`d0036fc`](https://github.com/OZI-Project/OZI/commit/d0036fc4c91336fca41e9275e0ae1b3c6a8f7e67))

* 🔊: Add 0.0.25 changes. ([`10c0096`](https://github.com/OZI-Project/OZI/commit/10c0096d00a5743cfa036f79f94c2c8b6ead5d13))

* PKG-INFO Updated ([`e8b8e71`](https://github.com/OZI-Project/OZI/commit/e8b8e71fdb4df3c2f6c9f0cf896fc6145eb4b5e1))

## 0.0.25 (2023-08-05)

### Other

* 🍱(ozi/assets): Restructured assets folder. ([`7a09768`](https://github.com/OZI-Project/OZI/commit/7a097680f940c4190b705c590ce08125f13a1c99))

* 👷(meson.build): Check PKG-INFO synced to pyproject. ([`515d4e8`](https://github.com/OZI-Project/OZI/commit/515d4e835395695400b1d3e358502eec53d8e550))

* 🔥 Migrate docs to [OZI.docs](https://github.com/rjdbcm/ozi.docs). ([`b3ff172`](https://github.com/OZI-Project/OZI/commit/b3ff172fc79b942344c498c1a7c6bdf34b44df81))

* 🔊(v0.0.24) ([`19c20f6`](https://github.com/OZI-Project/OZI/commit/19c20f6d4e3b4f6708c1b1bd9cb7dea3d567d1a4))

* PKG-INFO Updated ([`167694d`](https://github.com/OZI-Project/OZI/commit/167694d1d78f9b40a3b65f57466e389a84c040d0))

## 0.0.24 (2023-07-12)

### Other

* 🙈: add blastpipe to gitignore ([`d0130ba`](https://github.com/OZI-Project/OZI/commit/d0130ba81d10161cb6f4e4749402b3281e0f43f5))

* 🙈: add subprojects/dev.wrap. ([`1225f5b`](https://github.com/OZI-Project/OZI/commit/1225f5b5023d1fe7ac18d34de7c35d42a55c7e74))

* 🔧(project.optional-dependencies): add lint plugins. ([`7453005`](https://github.com/OZI-Project/OZI/commit/7453005e9732d8d8cbb201005f402b12c89e9907))

* 📝(lint): update list of flake8 plugins. ([`f27ba85`](https://github.com/OZI-Project/OZI/commit/f27ba8551f6239bc44017c16f0ac74924cac3871))

* 🔧(black): add ``-S`` to skip string normalization. ([`76d6358`](https://github.com/OZI-Project/OZI/commit/76d6358f07f221659cca7ac6b86028f168baa2bd))

* 🔧(flake8): tidy-imports ban relative beyond sibling. ([`7dbde5e`](https://github.com/OZI-Project/OZI/commit/7dbde5e2c441a37b6ba9ede37a7196aad4de2ca7))

* 📌(project): Set pins. ([`347ed85`](https://github.com/OZI-Project/OZI/commit/347ed854011570c2c0633b9564e023d964201a99))

* 🚑️(Safety): Mitigation for CVE-2022-40898. ([`380e6c0`](https://github.com/OZI-Project/OZI/commit/380e6c07ecf8efe98ae2d315d2ee9fb316292db6))

* 🚑️(Safety): mitigation for CVE-2022-40897. ([`7d3d50f`](https://github.com/OZI-Project/OZI/commit/7d3d50f54cf3e157886f813adf58c4ff38060534))

* Update README.rst

Added human-centered messaging. ([`8d7d0a6`](https://github.com/OZI-Project/OZI/commit/8d7d0a638a13e89ebfec7aefbf64a6623228188a))

* add changes. ([`991d09a`](https://github.com/OZI-Project/OZI/commit/991d09ad41e568318b4532f97e79ad83438660d2))

* PKG-INFO Updated ([`e4feee9`](https://github.com/OZI-Project/OZI/commit/e4feee97a6e7c6ce0eebd879c4770bbe9267ccaf))

## 0.0.23 (2023-07-05)

### :pencil2:

* :pencil2: blastpipe provides blastpipe. ([`68f1897`](https://github.com/OZI-Project/OZI/commit/68f1897671398b9a52ca42f3df6a15192950eba1))

## 0.0.22 (2023-07-05)

### Other

* 🔥 Remove wrap redirect. ([`e589cb6`](https://github.com/OZI-Project/OZI/commit/e589cb62d5f69e3abc71671ff349e0f5129e2cb4))

* 🔧(blastpipe): add as subproject. ([`266d128`](https://github.com/OZI-Project/OZI/commit/266d128cdd766cc5c9fa7f75bbbd749b7b289a3a))

* 🔧(project): Add blastpipe bootstrapping.
Renamed ozi-bootstrap to ozi-blastpipe. ([`216d027`](https://github.com/OZI-Project/OZI/commit/216d0277dfd94af98f14ab2d28c61290dd51dd72))

* 🔥(meson.build): install requirements individually.
This allows support of hashed version pins. ([`baaf291`](https://github.com/OZI-Project/OZI/commit/baaf291996d016debe5dae16d6ec4948aa9f0e9a))

* Hashes in use. ([`19e481d`](https://github.com/OZI-Project/OZI/commit/19e481dd8d6d58e75942f9b425f52eecc626d702))

* Not using version hashes for now. ([`5b0358b`](https://github.com/OZI-Project/OZI/commit/5b0358b181de2de0642448e9bc67825078c6801f))

* merge ([`adaab3f`](https://github.com/OZI-Project/OZI/commit/adaab3f5c98121fc6277d91455b6b720e69e2f89))

* merge ([`2609234`](https://github.com/OZI-Project/OZI/commit/2609234be52f714a85a531d8747af8be65251d68))

* 📌(project): pin all option suite tools. ([`4d3e459`](https://github.com/OZI-Project/OZI/commit/4d3e4594b80aa3c589578590070943211dd7fd6f))

* 📌(project): pin all option suite tools. ([`73618a2`](https://github.com/OZI-Project/OZI/commit/73618a27a90a8991cdf3d8cb15a92279d6c672b9))

* 🔨(pyproject.toml): sync to README. ([`233bac5`](https://github.com/OZI-Project/OZI/commit/233bac502c5c762d5e04c9ca316961760de4b932))

* 🔨(meson.build): Implement emoji_generic. ([`e727ace`](https://github.com/OZI-Project/OZI/commit/e727acec03785869db53668b39425e64902b1375))

* 🔨(meson.options): Add generic_emoji. ([`58c4f51`](https://github.com/OZI-Project/OZI/commit/58c4f51a164bd4c34dc846989950da5a82c3f132))

* 🔊(CHANGELOG.md): Updated. ([`5aade55`](https://github.com/OZI-Project/OZI/commit/5aade551c2e25e89b18de4be2faaf9f6c2076605))

* PKG-INFO Updated ([`0877e63`](https://github.com/OZI-Project/OZI/commit/0877e63c615d2e39630dc3e0dcb08729c1854c40))

## 0.0.21 (2023-07-01)

### Other

* 🔨(meson.options): Added python version options.
Formerly these were hardcoded. ([`98dc031`](https://github.com/OZI-Project/OZI/commit/98dc03107c9ea202d92ba599a9516b58e5c76496))

* :technologist:(README.rst): Added bugfix section. ([`d522338`](https://github.com/OZI-Project/OZI/commit/d522338daf72bea127a3636a4bc61bcd13b04f49))

* 🧑‍💻: Update issue templates

Add feature request and bug report templates. ([`24a9834`](https://github.com/OZI-Project/OZI/commit/24a9834112253dbf08114d4fb71735253797a11d))

* 📝 README.rst: add OpenSSF badge. ([`334bdb9`](https://github.com/OZI-Project/OZI/commit/334bdb937133b0795cf34c9a8cf51895e3140985))

* 🧑‍💻 README.rst: Add Contributing section. ([`14b8b5a`](https://github.com/OZI-Project/OZI/commit/14b8b5a813d65d711227e8c6b44cdd7b66ff832e))

* 📝 README.rst: Remove hanging markdown. ([`e49d3a0`](https://github.com/OZI-Project/OZI/commit/e49d3a0b2462d3ba83c38397774d8e137a14489c))

* 📝 README.rst: Fix FOSSA badge. ([`08b31f7`](https://github.com/OZI-Project/OZI/commit/08b31f731306aaad06f771ea433b9738d968ec23))

* 📝README.rst: fix FOSSA badge. ([`b054f57`](https://github.com/OZI-Project/OZI/commit/b054f5757dbac829b0e5d49e4488665d5b7c9367))

* Add license scan report and status

Signed off by: fossabot &lt;badges@fossa.com&gt; ([`3814fcb`](https://github.com/OZI-Project/OZI/commit/3814fcbcdff6622771c67f9a036b47b5c589b13c))

* 🚑️(tox): correct meson build options.
Now using ozi-bootstrap=enabled. ([`30712f5`](https://github.com/OZI-Project/OZI/commit/30712f5204cadbb5c218bccba47d44cd34af02ac))

* 👷(semantic-release): use textual changelog sections. ([`730b7ec`](https://github.com/OZI-Project/OZI/commit/730b7ec62cef8fdc7ef15391d1f15f1903244732))

* 🔨(semantic-release): git clean -dfX run pre_commit. ([`12c8de4`](https://github.com/OZI-Project/OZI/commit/12c8de45a6c36a18bc2ac2e66ef9be0ab50c081c))

* 🔊 Update CHANGELOG.md ([`1f3bf64`](https://github.com/OZI-Project/OZI/commit/1f3bf645408da6373bf12b05565fa03e0f0d2367))

* PKG-INFO Updated ([`c1c04d9`](https://github.com/OZI-Project/OZI/commit/c1c04d9bd89823b9d8c48eb422c5bc6a8360e883))

## 0.0.20 (2023-06-24)

### Other

* 🔨 drop PKG-INFO from pre_commit. ([`39a908d`](https://github.com/OZI-Project/OZI/commit/39a908d39cc747a5c33082bddf833e9fe2b9075b))

* 🔨 fix stash strategy.. ([`a20807e`](https://github.com/OZI-Project/OZI/commit/a20807e23f3555b8306523cc3da8ebf84ef575f2))

* PKG-INFO Updated ([`5de6296`](https://github.com/OZI-Project/OZI/commit/5de6296f33c58f751c97551b9b69f1f786c04409))

## 0.0.19 (2023-06-24)

### Other

* 🔨 stash after push release. ([`4169813`](https://github.com/OZI-Project/OZI/commit/4169813270f1e6783da08a914904b53776b3b49c))

## 0.0.18 (2023-06-24)

### Other

* 🔨 turn back on repo build. ([`4137e1e`](https://github.com/OZI-Project/OZI/commit/4137e1e2822dfce5eb0d47ac23519515422181db))

## 0.0.17 (2023-06-24)

### Other

* 🔊 Add changes for 0.0.16. ([`62e9641`](https://github.com/OZI-Project/OZI/commit/62e9641e4e0505e664449110d0a46b5e3a1f794f))

## 0.0.16 (2023-06-24)

### Other

* 🔊 add 0.0.16 changes. ([`c765e65`](https://github.com/OZI-Project/OZI/commit/c765e6545bbdacde2a76021e9311f3cf334e7065))

* 🔥 git rm -r --cached subprojects.dev ([`26590cc`](https://github.com/OZI-Project/OZI/commit/26590cc76e5adf543f5231d89279c8dd1c9cefb1))

* Add gitignore. ([`bf295f4`](https://github.com/OZI-Project/OZI/commit/bf295f4ad8b133cbe98a987ec09bd7bee3572428))

* 🔨 Just stash PKG-INFO. ([`40db643`](https://github.com/OZI-Project/OZI/commit/40db6433be6f26b802a4fc4b85393cf42b9c2131))

* PKG-INFO Updated ([`0916ffd`](https://github.com/OZI-Project/OZI/commit/0916ffd48343b54474bde97d77d52f32fd7b712c))

## 0.0.15 (2023-06-24)

### Other

* 🔨 just use pypi repo namespace. ([`926bce6`](https://github.com/OZI-Project/OZI/commit/926bce6f8a1ab70cb5ccb6041fbc3452dba10c17))

* PKG-INFO Updated ([`cf1df31`](https://github.com/OZI-Project/OZI/commit/cf1df31248d4cf5aae72380b928f9c3e0ddaf79f))

## 0.0.14 (2023-06-24)

### Other

* PKG-INFO Updated ([`8001504`](https://github.com/OZI-Project/OZI/commit/8001504dfe277eff8b16ea07fe5987feb0754968))

## 0.0.13 (2023-06-24)

### Other

* 🔨 fix must be a file: build/meson-dist/*.tar.gz foreals. ([`ce2e8f0`](https://github.com/OZI-Project/OZI/commit/ce2e8f0e6ccb4160e128de2759c921839ca413db))

* PKG-INFO Updated ([`382ed8a`](https://github.com/OZI-Project/OZI/commit/382ed8a40a26b47c7451b632a33ecc43b1cc1dd0))

## 0.0.12 (2023-06-24)

### Other

* 🔨 fix must be a file: build/meson-dist/*.tar.gz. ([`03de6fc`](https://github.com/OZI-Project/OZI/commit/03de6fcca53c6f0edcce3e6d3a0f44c62ab60c87))

* PKG-INFO Updated ([`7ed30a3`](https://github.com/OZI-Project/OZI/commit/7ed30a3f486f9bf1011d849b4f910dbc2d1a24fc))

## 0.0.11 (2023-06-24)

### Other

* PKG-INFO Updated ([`55f6ccb`](https://github.com/OZI-Project/OZI/commit/55f6ccb170a0c652a344a944b119ca06088bd477))

## 0.0.10 (2023-06-24)

### Other

* 🔨no initial stash clear. ([`5c9e106`](https://github.com/OZI-Project/OZI/commit/5c9e106c178d8a8fcc4555a339827fe30862fa3e))

* PKG-INFO Updated ([`79cd462`](https://github.com/OZI-Project/OZI/commit/79cd462d26dba50421267a1eaf0ebc60f2893495))

## 0.0.9 (2023-06-24)

### :pencil2:

* :pencil2: git add CHANGELOG.md. ([`6575895`](https://github.com/OZI-Project/OZI/commit/65758958a899629f680b37b930ac34377dfd0b59))

## 0.0.8 (2023-06-24)

### Other

* 👷 add summary to metadata. ([`a97a05b`](https://github.com/OZI-Project/OZI/commit/a97a05b1de54c140bde7ded8029c2a9ffa1be79c))

* 👷 use pkg-info. ([`b0cd371`](https://github.com/OZI-Project/OZI/commit/b0cd371fdbafc1ecce4274722586fa07181e351e))

* 👷 fix CI changelog commit. ([`3b8288b`](https://github.com/OZI-Project/OZI/commit/3b8288b15b9a8a46e6a9c3866942262508e98530))

* PKG-INFO Updated ([`1db763d`](https://github.com/OZI-Project/OZI/commit/1db763d5e978742e1848b0cf83b773e39a9efe98))

## 0.0.7 (2023-06-23)

### Other

* 🍱 fix readme rendering. ([`d27ffc9`](https://github.com/OZI-Project/OZI/commit/d27ffc925a80e910b6cf6d2aa3f18e51d3cdad24))

* PKG-INFO Updated ([`88d8722`](https://github.com/OZI-Project/OZI/commit/88d87224d4e8b5c734ef0791c5707df0f3441dd1))

## 0.0.6 (2023-06-23)

### :pencil2:

* :pencil2: to_lower ([`5c48087`](https://github.com/OZI-Project/OZI/commit/5c48087f08373aeeabd18b1e2899280a242f0a51))

* :pencil2: lower case folder. ([`dfaaaba`](https://github.com/OZI-Project/OZI/commit/dfaaababe369809efce86a14aba13684751bc345))

* :pencil2: fix wrap file usage. ([`b4157b1`](https://github.com/OZI-Project/OZI/commit/b4157b19fa86d2f11f1ba97cdb8799556244cbd4))

* :pencil2: fix typo in build script. ([`c0fa9c8`](https://github.com/OZI-Project/OZI/commit/c0fa9c86a37626dcb41eb2c8300339c5d82a773e))

### Other

* 📌 Add requirements to build. ([`fd83e88`](https://github.com/OZI-Project/OZI/commit/fd83e88c51a0396b91e776b64f11692ed83d96d5))

* ✏️ add config files to build. ([`f732ed1`](https://github.com/OZI-Project/OZI/commit/f732ed190d46e4c53d7c87c0f9aa2427c1479b0e))

* ⚰️ No Notice required. ([`ca50d4f`](https://github.com/OZI-Project/OZI/commit/ca50d4f89b3f6c905bae26928b0a24d5c7f7a39c))

* 📝 Add CHANGELOG. ([`bf62b43`](https://github.com/OZI-Project/OZI/commit/bf62b43d5fb3241b863177380de74dedadf8720d))

* 🔨 Add bootstrapping ozi.wrap. ([`c9a076e`](https://github.com/OZI-Project/OZI/commit/c9a076e7c0625df32bd1622a422896ff251327c2))

* 🔧 add bootstrapping script to build. ([`2215826`](https://github.com/OZI-Project/OZI/commit/221582631c5b70db905bb3e2980a61a1e86212b3))

* PKG-INFO Updated ([`c9f3a62`](https://github.com/OZI-Project/OZI/commit/c9f3a62e30f9deda448bd245ff71e6813fd84c2d))

## 0.0.5 (2023-06-23)

### :pencil2:

* :pencil2: fix typo is_enabled. ([`a966905`](https://github.com/OZI-Project/OZI/commit/a966905031826b9cfa78edcb8713831431a9676b))

### Other

* 🙈 add .gitignore!!! ([`04e2eb4`](https://github.com/OZI-Project/OZI/commit/04e2eb40a954935a251f8c65574187c013448a74))

## 0.0.4 (2023-06-23)

### Other

* 👷 PKG-INFO updated with version! ([`3a04107`](https://github.com/OZI-Project/OZI/commit/3a04107ce11622e6ba788915c5d57ad958e93c60))

* 👷 no find_program override for now. ([`a495f3d`](https://github.com/OZI-Project/OZI/commit/a495f3d8f9a7e0e9344594215c6b319091547c38))

* 🚧👷  add distrbution related build bootstrapping. ([`3fbda2a`](https://github.com/OZI-Project/OZI/commit/3fbda2aef99b4746cdd321c87c4852e11e260109))

* Create meson.build ([`51727a6`](https://github.com/OZI-Project/OZI/commit/51727a69709131eeb175d1adba4539966b211ec9))

* Update ozi.wrap ([`9b9e2cd`](https://github.com/OZI-Project/OZI/commit/9b9e2cd9ff00904636ec8f1610e52e40d40e2ab0))

* Update meson.build

add meson.override_find_program, remove todo wrap. ([`f01c0c7`](https://github.com/OZI-Project/OZI/commit/f01c0c7607d53f6ab824caa1954af2b4e58c4c6d))

* Create PKG-INFO ([`7b9ece4`](https://github.com/OZI-Project/OZI/commit/7b9ece48fd69f89d7f8849f7d0291746f2dc540a))

* Update pyproject.toml ([`5260ee9`](https://github.com/OZI-Project/OZI/commit/5260ee98ad383b1adaa9c934657c4e16375b2372))

* Create ozi.wrap ([`279ec4b`](https://github.com/OZI-Project/OZI/commit/279ec4bd2ff5247c61b8d8c6b6184be1467f18c7))

* Add files via upload ([`9fbabca`](https://github.com/OZI-Project/OZI/commit/9fbabca05a29e8350187f86d1ff4dfb4259b37be))

* Add files via upload ([`22e4055`](https://github.com/OZI-Project/OZI/commit/22e40555c85c9d36e6fef06086b81874057edf4c))

* Create tox.ini ([`2ab7c48`](https://github.com/OZI-Project/OZI/commit/2ab7c48db0529f6ba4149ba0b8df18513a813d45))

* Create workflow.yml ([`318c0c1`](https://github.com/OZI-Project/OZI/commit/318c0c19dfbbb1f3d108cb3ba4ddce6fcc14945b))

* Add files via upload ([`b2c7a93`](https://github.com/OZI-Project/OZI/commit/b2c7a93e2da6835c6dbfa07f72ace9179c5af8ce))

* Create scm_version_snip.py ([`b7ec6a7`](https://github.com/OZI-Project/OZI/commit/b7ec6a78516491a659fb48550122631b8d97070c))

* Add files via upload ([`beefc2c`](https://github.com/OZI-Project/OZI/commit/beefc2c1fbec5997af3445a3db653295bda86625))

* Create __init__.py ([`3f83f68`](https://github.com/OZI-Project/OZI/commit/3f83f68b731608d0462fb570aa8ea3a1e9915029))

* Root folder sync to blastpipe-0.4.20 ([`b05b497`](https://github.com/OZI-Project/OZI/commit/b05b4977180014aae1e5276d9588fa089ab95ae2))
