Chatting with openrouter/meta-llama/llama-4-scout:free
Type 'exit' or 'quit' to exit
Type '!multi' to enter multiple lines, then '!end' to finish
**Markdown Syntax Overview**
==========================

Markdown is a lightweight markup language that allows you to create formatted text using plain text syntax. Here's a comprehensive overview of Markdown syntax:

### Headers

* Headers are denoted by the `#` symbol followed by a space and the header text.
* The number of `#` symbols determines the header level (e.g., `#` for H1, `##` for H2, etc.).

Example:
```markdown
# H1 Header
## H2 Header
### H3 Header
```

### Emphasis

* **Bold text**: Surround text with double asterisks `**` or double underscores `__`.
* *Italic text*: Surround text with single asterisks `*` or single underscores `_`.
* ***Bold and Italic text***: Surround text with triple asterisks `***` or triple underscores `___`.

Example:
```markdown
**Bold text**
*Italic text*
***Bold and Italic text***
```

### Lists

* **Ordered lists**: Use numbers followed by a period and a space (e.g., `1.`, `2.`, etc.).
* **Unordered lists**: Use asterisks `*`, plus signs `+`, or hyphens `-` followed by a space.

Example:
```markdown
1. Ordered list item 1
2. Ordered list item 2
3. Ordered list item 3

* Unordered list item 1
* Unordered list item 2
* Unordered list item 3
```

### Links

* **Inline links**: Surround link text with square brackets `[]` and the URL with parentheses `()`.
* **Reference links**: Use a reference syntax with a link definition at the bottom of the document.

Example:
```markdown
[Inline link](https://www.example.com)
[Reference link][ref]

[ref]: https://www.example.com
```

### Images

* **Inline images**: Surround image alt text with square brackets `[]` and the URL with parentheses `()`.
* **Reference images**: Use a reference syntax with an image definition at the bottom of the document.

Example:
```markdown
![Inline image](https://www.example.com/image.jpg)
![Reference image][image]

[image]: https://www.example.com/image.jpg
```

### Code Blocks

* **Inline code**: Surround code with backticks `` ` ``.
* **Code blocks**: Use triple backticks ````` or indent with four spaces.

Example:
```markdown
`Inline code`

```
Code block
```
```

### Tables

* **Simple tables**: Use pipes `|` to separate columns and rows.

Example:
```markdown
| Column 1 | Column 2 | Column 3 |
|----------|----------|----------|
| Cell 1   | Cell 2   | Cell 3   |
| Cell 4   | Cell 5   | Cell 6   |
```

### Blockquotes

* **Blockquotes**: Use a greater-than symbol `>` followed by a space.

Example:
```markdown
> This is a blockquote.
> It can span multiple lines.
```

### Horizontal Rules

* **Horizontal rules**: Use three or more hyphens `-`, asterisks `*`, or underscores `_`.

Example:
```markdown
---
***
___
```

### Escaping

* **Escape characters**: Use a backslash `\` to escape special characters.

Example:
```markdown
\* Escaped asterisk
```

### Task Lists

* **Task lists**: Use square brackets with an `x` or a space to indicate completion.

Example:
```markdown
- [x] Task 1
- [ ] Task 2
```

### Definition Lists

* **Definition lists**: Use a colon `:` and a space to define terms.

Example:
```markdown
; Term 1
: Definition 1

; Term 2
: Definition 2
```

This overview covers the basic Markdown syntax. You can find more information and variations in the [Markdown Guide](https://www.markdownguide.org/basic-syntax/).
> 
