"""
python bindings for openfoam
"""
from __future__ import annotations
import collections.abc
import numpy
import numpy.typing
import typing
__all__ = ['Time', 'Word', 'dictionary', 'dictionaryEntry', 'entry', 'fvMesh', 'instant', 'instantList', 'keyType', 'mag', 'scalarField', 'selectTimes', 'sum', 'surfaceScalarField', 'surfaceTensorField', 'surfaceVectorField', 'symmTensor', 'symmTensorField', 'tensor', 'tensorField', 'tmp_surfaceScalarField', 'tmp_surfaceTensorField', 'tmp_surfaceVectorField', 'tmp_volScalarField', 'tmp_volSymmTensorField', 'tmp_volTensorField', 'tmp_volVectorField', 'vector', 'vectorField', 'volScalarField', 'volSymmTensorField', 'volTensorField', 'volVectorField', 'wordList']
class Time:
    @typing.overload
    def __init__(self, arg0: Time) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: str, arg1: str) -> None:
        ...
    def setTime(self, arg0: ..., arg1: typing.SupportsInt) -> None:
        ...
    def value(self) -> float:
        ...
class Word:
    __hash__: typing.ClassVar[None] = None
    def __eq__(self, arg0: str) -> bool:
        ...
    def __init__(self, arg0: str) -> None:
        ...
    def __str__(self) -> str:
        ...
class dictionary:
    @staticmethod
    def read(arg0: str) -> dictionary:
        ...
    @typing.overload
    def __init__(self, arg0: str) -> None:
        ...
    @typing.overload
    def __init__(self) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: dictionary) -> None:
        ...
    @typing.overload
    def add(self, arg0: entry, arg1: bool) -> None:
        ...
    @typing.overload
    def add(self, arg0: str, arg1: ...) -> None:
        ...
    @typing.overload
    def add(self, arg0: str, arg1: typing.SupportsFloat) -> None:
        ...
    @typing.overload
    def add(self, arg0: str, arg1: ...) -> None:
        ...
    @typing.overload
    def add(self, arg0: str, arg1: ...) -> None:
        ...
    @typing.overload
    def add(self, arg0: str, arg1: ...) -> None:
        ...
    @typing.overload
    def add(self, arg0: str, arg1: ...) -> None:
        ...
    @typing.overload
    def add(self, arg0: str, arg1: ...) -> None:
        ...
    @typing.overload
    def add(self, arg0: str, arg1: ...) -> None:
        ...
    @typing.overload
    def clear(self) -> None:
        ...
    @typing.overload
    def clear(self) -> None:
        ...
    def get_scalar(self, arg0: str) -> float:
        ...
    def get_scalarField(self, arg0: str) -> ...:
        ...
    def get_tensor(self, arg0: str) -> ...:
        ...
    def get_tensorField(self, arg0: str) -> ...:
        ...
    def get_vector(self, arg0: str) -> ...:
        ...
    def get_vectorField(self, arg0: str) -> ...:
        ...
    def get_word(self, arg0: str) -> ...:
        ...
    def get_wordList(self, arg0: str) -> ...:
        ...
    def isDict(self, arg0: str) -> bool:
        ...
    def print(self) -> None:
        ...
    @typing.overload
    def set(self, arg0: str, arg1: ...) -> None:
        ...
    @typing.overload
    def set(self, arg0: str, arg1: typing.SupportsFloat) -> None:
        ...
    @typing.overload
    def set(self, arg0: str, arg1: ...) -> None:
        ...
    @typing.overload
    def set(self, arg0: str, arg1: ...) -> None:
        ...
    @typing.overload
    def set(self, arg0: str, arg1: ...) -> None:
        ...
    @typing.overload
    def set(self, arg0: str, arg1: ...) -> None:
        ...
    @typing.overload
    def set(self, arg0: str, arg1: ...) -> None:
        ...
    @typing.overload
    def set(self, arg0: str, arg1: ...) -> None:
        ...
    def subDict(self, arg0: str) -> dictionary:
        ...
    def subDictOrAdd(self, arg0: str) -> dictionary:
        ...
    def toc(self) -> ...:
        ...
    def write(self, arg0: str) -> None:
        ...
class dictionaryEntry(entry):
    def __init__(self, arg0: keyType, arg1: ..., arg2: ...) -> None:
        ...
class entry:
    pass
class fvMesh:
    def C(self) -> ...:
        ...
    def Cf(self) -> ...:
        ...
    def Sf(self) -> ...:
        ...
    @typing.overload
    def __init__(self, arg0: fvMesh) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: Time) -> None:
        ...
    def magSf(self) -> ...:
        ...
    def time(self) -> Time:
        ...
class instant:
    def __str__(self) -> str:
        ...
class instantList:
    def __getitem__(self, arg0: typing.SupportsInt) -> instant:
        ...
class keyType:
    @typing.overload
    def __init__(self, arg0: ...) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: str) -> None:
        ...
class scalarField:
    @typing.overload
    def __add__(self, arg0: scalarField) -> scalarField:
        ...
    @typing.overload
    def __add__(self, arg0: typing.SupportsFloat) -> scalarField:
        ...
    def __getitem__(self, arg0: typing.SupportsInt) -> float:
        ...
    @typing.overload
    def __init__(self) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: scalarField) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: ...) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: collections.abc.Sequence[typing.SupportsFloat]) -> None:
        ...
    def __len__(self) -> int:
        ...
    @typing.overload
    def __mul__(self, arg0: typing.SupportsFloat) -> scalarField:
        ...
    @typing.overload
    def __mul__(self, arg0: scalarField) -> scalarField:
        ...
    def __setitem__(self, arg0: typing.SupportsInt, arg1: typing.SupportsFloat) -> None:
        ...
    @typing.overload
    def __sub__(self, arg0: scalarField) -> scalarField:
        ...
    @typing.overload
    def __sub__(self, arg0: typing.SupportsFloat) -> scalarField:
        ...
    @typing.overload
    def __truediv__(self, arg0: typing.SupportsFloat) -> scalarField:
        ...
    @typing.overload
    def __truediv__(self, arg0: scalarField) -> scalarField:
        ...
    def from_numpy(self) -> numpy.typing.NDArray[numpy.float64]:
        ...
    def to_numpy(self) -> numpy.typing.NDArray[numpy.float64]:
        ...
class surfaceScalarField:
    @staticmethod
    def from_registry(arg0: fvMesh, arg1: str) -> surfaceScalarField:
        ...
    @staticmethod
    def list_objects(arg0: fvMesh) -> wordList:
        ...
    @staticmethod
    def read_field(arg0: fvMesh, arg1: str) -> surfaceScalarField:
        ...
    def __add__(self, arg0: surfaceScalarField) -> tmp_surfaceScalarField:
        ...
    def __getitem__(self, arg0: str) -> scalarField:
        ...
    @typing.overload
    def __init__(self, arg0: surfaceScalarField) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: tmp_surfaceScalarField) -> None:
        ...
    def __mul__(self, arg0: surfaceScalarField) -> tmp_surfaceScalarField:
        ...
    def __setitem__(self, arg0: str, arg1: scalarField) -> None:
        ...
    def __sub__(self, arg0: surfaceScalarField) -> tmp_surfaceScalarField:
        ...
    def __truediv__(self, arg0: surfaceScalarField) -> tmp_surfaceScalarField:
        ...
    def internalField(self, arg0: str) -> scalarField:
        ...
class surfaceTensorField:
    @staticmethod
    def from_registry(arg0: fvMesh, arg1: str) -> surfaceTensorField:
        ...
    @staticmethod
    def list_objects(arg0: fvMesh) -> wordList:
        ...
    @staticmethod
    def read_field(arg0: fvMesh, arg1: str) -> surfaceTensorField:
        ...
    def __add__(self, arg0: surfaceTensorField) -> tmp_surfaceTensorField:
        ...
    def __getitem__(self, arg0: str) -> tensorField:
        ...
    @typing.overload
    def __init__(self, arg0: surfaceTensorField) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: tmp_surfaceTensorField) -> None:
        ...
    def __mul__(self, arg0: surfaceScalarField) -> tmp_surfaceTensorField:
        ...
    def __setitem__(self, arg0: str, arg1: tensorField) -> None:
        ...
    def __sub__(self, arg0: surfaceTensorField) -> tmp_surfaceTensorField:
        ...
    def __truediv__(self, arg0: surfaceScalarField) -> tmp_surfaceTensorField:
        ...
    def internalField(self, arg0: str) -> tensorField:
        ...
class surfaceVectorField:
    @staticmethod
    def from_registry(arg0: fvMesh, arg1: str) -> surfaceVectorField:
        ...
    @staticmethod
    def list_objects(arg0: fvMesh) -> wordList:
        ...
    @staticmethod
    def read_field(arg0: fvMesh, arg1: str) -> surfaceVectorField:
        ...
    def __add__(self, arg0: surfaceVectorField) -> tmp_surfaceVectorField:
        ...
    def __getitem__(self, arg0: str) -> vectorField:
        ...
    @typing.overload
    def __init__(self, arg0: surfaceVectorField) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: tmp_surfaceVectorField) -> None:
        ...
    def __mul__(self, arg0: surfaceScalarField) -> tmp_surfaceVectorField:
        ...
    def __setitem__(self, arg0: str, arg1: vectorField) -> None:
        ...
    def __sub__(self, arg0: surfaceVectorField) -> tmp_surfaceVectorField:
        ...
    def __truediv__(self, arg0: surfaceScalarField) -> tmp_surfaceVectorField:
        ...
    def internalField(self, arg0: str) -> vectorField:
        ...
class symmTensor:
    __hash__: typing.ClassVar[None] = None
    def __add__(self, arg0: symmTensor) -> symmTensor:
        ...
    @typing.overload
    def __and__(self, arg0: symmTensor) -> tensor:
        ...
    @typing.overload
    def __and__(self, arg0: vector) -> vector:
        ...
    @typing.overload
    def __eq__(self, arg0: symmTensor) -> bool:
        ...
    @typing.overload
    def __eq__(self, arg0: typing.Annotated[collections.abc.Sequence[typing.SupportsFloat], "FixedSize(6)"]) -> bool:
        ...
    def __getitem__(self, arg0: typing.SupportsInt) -> float:
        ...
    @typing.overload
    def __init__(self, arg0: symmTensor) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: typing.Annotated[collections.abc.Sequence[typing.SupportsFloat], "FixedSize(6)"]) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: typing.SupportsFloat, arg1: typing.SupportsFloat, arg2: typing.SupportsFloat, arg3: typing.SupportsFloat, arg4: typing.SupportsFloat, arg5: typing.SupportsFloat) -> None:
        ...
    def __len__(self) -> int:
        ...
    def __mul__(self, arg0: typing.SupportsFloat) -> symmTensor:
        ...
    def __ne__(self, arg0: symmTensor) -> bool:
        ...
    def __setitem__(self, arg0: typing.SupportsInt, arg1: typing.SupportsFloat) -> None:
        ...
    def __str__(self) -> str:
        ...
    def __sub__(self, arg0: symmTensor) -> symmTensor:
        ...
class symmTensorField:
    @typing.overload
    def __add__(self, arg0: symmTensorField) -> symmTensorField:
        ...
    @typing.overload
    def __add__(self, arg0: symmTensor) -> symmTensorField:
        ...
    def __getitem__(self, arg0: typing.SupportsInt) -> symmTensor:
        ...
    @typing.overload
    def __init__(self) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: symmTensorField) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: ...) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: collections.abc.Sequence[symmTensor]) -> None:
        ...
    def __len__(self) -> int:
        ...
    @typing.overload
    def __mul__(self, arg0: typing.SupportsFloat) -> symmTensorField:
        ...
    @typing.overload
    def __mul__(self, arg0: scalarField) -> symmTensorField:
        ...
    def __setitem__(self, arg0: typing.SupportsInt, arg1: symmTensor) -> None:
        ...
    @typing.overload
    def __sub__(self, arg0: symmTensorField) -> symmTensorField:
        ...
    @typing.overload
    def __sub__(self, arg0: symmTensor) -> symmTensorField:
        ...
    @typing.overload
    def __truediv__(self, arg0: typing.SupportsFloat) -> symmTensorField:
        ...
    @typing.overload
    def __truediv__(self, arg0: scalarField) -> symmTensorField:
        ...
    def from_numpy(self) -> numpy.typing.NDArray[numpy.float64]:
        ...
    def to_numpy(self) -> numpy.typing.NDArray[numpy.float64]:
        ...
class tensor:
    __hash__: typing.ClassVar[None] = None
    def __add__(self, arg0: tensor) -> tensor:
        ...
    @typing.overload
    def __and__(self, arg0: tensor) -> tensor:
        ...
    @typing.overload
    def __and__(self, arg0: vector) -> vector:
        ...
    @typing.overload
    def __eq__(self, arg0: tensor) -> bool:
        ...
    @typing.overload
    def __eq__(self, arg0: typing.Annotated[collections.abc.Sequence[typing.SupportsFloat], "FixedSize(9)"]) -> bool:
        ...
    def __getitem__(self, arg0: typing.SupportsInt) -> float:
        ...
    @typing.overload
    def __init__(self, arg0: tensor) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: typing.Annotated[collections.abc.Sequence[typing.SupportsFloat], "FixedSize(9)"]) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: typing.SupportsFloat, arg1: typing.SupportsFloat, arg2: typing.SupportsFloat, arg3: typing.SupportsFloat, arg4: typing.SupportsFloat, arg5: typing.SupportsFloat, arg6: typing.SupportsFloat, arg7: typing.SupportsFloat, arg8: typing.SupportsFloat) -> None:
        ...
    def __len__(self) -> int:
        ...
    def __mul__(self, arg0: typing.SupportsFloat) -> tensor:
        ...
    def __ne__(self, arg0: tensor) -> bool:
        ...
    def __setitem__(self, arg0: typing.SupportsInt, arg1: typing.SupportsFloat) -> None:
        ...
    def __str__(self) -> str:
        ...
    def __sub__(self, arg0: tensor) -> tensor:
        ...
class tensorField:
    @typing.overload
    def __add__(self, arg0: tensorField) -> tensorField:
        ...
    @typing.overload
    def __add__(self, arg0: tensor) -> tensorField:
        ...
    def __getitem__(self, arg0: typing.SupportsInt) -> tensor:
        ...
    @typing.overload
    def __init__(self) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: tensorField) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: ...) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: collections.abc.Sequence[tensor]) -> None:
        ...
    def __len__(self) -> int:
        ...
    @typing.overload
    def __mul__(self, arg0: typing.SupportsFloat) -> tensorField:
        ...
    @typing.overload
    def __mul__(self, arg0: scalarField) -> tensorField:
        ...
    def __setitem__(self, arg0: typing.SupportsInt, arg1: tensor) -> None:
        ...
    @typing.overload
    def __sub__(self, arg0: tensorField) -> tensorField:
        ...
    @typing.overload
    def __sub__(self, arg0: tensor) -> tensorField:
        ...
    @typing.overload
    def __truediv__(self, arg0: typing.SupportsFloat) -> tensorField:
        ...
    @typing.overload
    def __truediv__(self, arg0: scalarField) -> tensorField:
        ...
    def from_numpy(self) -> numpy.typing.NDArray[numpy.float64]:
        ...
    def to_numpy(self) -> numpy.typing.NDArray[numpy.float64]:
        ...
class tmp_surfaceScalarField:
    def geoField(self) -> ...:
        ...
class tmp_surfaceTensorField:
    def geoField(self) -> ...:
        ...
class tmp_surfaceVectorField:
    def geoField(self) -> ...:
        ...
class tmp_volScalarField:
    def geoField(self) -> ...:
        ...
class tmp_volSymmTensorField:
    def geoField(self) -> ...:
        ...
class tmp_volTensorField:
    def geoField(self) -> ...:
        ...
class tmp_volVectorField:
    def geoField(self) -> ...:
        ...
class vector:
    __hash__: typing.ClassVar[None] = None
    def __add__(self, arg0: vector) -> vector:
        ...
    @typing.overload
    def __and__(self, arg0: vector) -> float:
        ...
    @typing.overload
    def __and__(self, arg0: ...) -> vector:
        ...
    @typing.overload
    def __and__(self, arg0: ...) -> vector:
        ...
    @typing.overload
    def __eq__(self, arg0: vector) -> bool:
        ...
    @typing.overload
    def __eq__(self, arg0: typing.Annotated[collections.abc.Sequence[typing.SupportsFloat], "FixedSize(3)"]) -> bool:
        ...
    def __getitem__(self, arg0: typing.SupportsInt) -> float:
        ...
    @typing.overload
    def __init__(self, arg0: vector) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: typing.Annotated[collections.abc.Sequence[typing.SupportsFloat], "FixedSize(3)"]) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: typing.SupportsFloat, arg1: typing.SupportsFloat, arg2: typing.SupportsFloat) -> None:
        ...
    def __len__(self) -> int:
        ...
    def __mul__(self, arg0: typing.SupportsFloat) -> vector:
        ...
    def __ne__(self, arg0: vector) -> bool:
        ...
    def __setitem__(self, arg0: typing.SupportsInt, arg1: typing.SupportsFloat) -> None:
        ...
    def __str__(self) -> str:
        ...
    def __sub__(self, arg0: vector) -> vector:
        ...
class vectorField:
    @typing.overload
    def __add__(self, arg0: vectorField) -> vectorField:
        ...
    @typing.overload
    def __add__(self, arg0: vector) -> vectorField:
        ...
    @typing.overload
    def __and__(self, arg0: vector) -> scalarField:
        ...
    @typing.overload
    def __and__(self, arg0: vectorField) -> scalarField:
        ...
    @typing.overload
    def __and__(self, arg0: tensor) -> vectorField:
        ...
    @typing.overload
    def __and__(self, arg0: ...) -> vectorField:
        ...
    @typing.overload
    def __and__(self, arg0: symmTensor) -> vectorField:
        ...
    @typing.overload
    def __and__(self, arg0: ...) -> vectorField:
        ...
    def __getitem__(self, arg0: typing.SupportsInt) -> vector:
        ...
    @typing.overload
    def __init__(self) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: vectorField) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: ...) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: collections.abc.Sequence[vector]) -> None:
        ...
    def __len__(self) -> int:
        ...
    @typing.overload
    def __mul__(self, arg0: typing.SupportsFloat) -> vectorField:
        ...
    @typing.overload
    def __mul__(self, arg0: scalarField) -> vectorField:
        ...
    def __setitem__(self, arg0: typing.SupportsInt, arg1: vector) -> None:
        ...
    @typing.overload
    def __sub__(self, arg0: vectorField) -> vectorField:
        ...
    @typing.overload
    def __sub__(self, arg0: vector) -> vectorField:
        ...
    @typing.overload
    def __truediv__(self, arg0: typing.SupportsFloat) -> vectorField:
        ...
    @typing.overload
    def __truediv__(self, arg0: scalarField) -> vectorField:
        ...
    def from_numpy(self) -> numpy.typing.NDArray[numpy.float64]:
        ...
    def to_numpy(self) -> numpy.typing.NDArray[numpy.float64]:
        ...
class volScalarField:
    @staticmethod
    def from_registry(arg0: fvMesh, arg1: str) -> volScalarField:
        ...
    @staticmethod
    def list_objects(arg0: fvMesh) -> wordList:
        ...
    @staticmethod
    def read_field(arg0: fvMesh, arg1: str) -> volScalarField:
        ...
    def __add__(self, arg0: volScalarField) -> tmp_volScalarField:
        ...
    def __getitem__(self, arg0: str) -> scalarField:
        ...
    @typing.overload
    def __init__(self, arg0: volScalarField) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: tmp_volScalarField) -> None:
        ...
    def __mul__(self, arg0: volScalarField) -> tmp_volScalarField:
        ...
    def __setitem__(self, arg0: str, arg1: scalarField) -> None:
        ...
    def __sub__(self, arg0: volScalarField) -> tmp_volScalarField:
        ...
    def __truediv__(self, arg0: volScalarField) -> tmp_volScalarField:
        ...
    def internalField(self, arg0: str) -> scalarField:
        ...
class volSymmTensorField:
    @staticmethod
    def from_registry(arg0: fvMesh, arg1: str) -> volSymmTensorField:
        ...
    @staticmethod
    def list_objects(arg0: fvMesh) -> wordList:
        ...
    @staticmethod
    def read_field(arg0: fvMesh, arg1: str) -> volSymmTensorField:
        ...
    def __add__(self, arg0: volSymmTensorField) -> tmp_volSymmTensorField:
        ...
    def __getitem__(self, arg0: str) -> symmTensorField:
        ...
    @typing.overload
    def __init__(self, arg0: volSymmTensorField) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: tmp_volSymmTensorField) -> None:
        ...
    def __mul__(self, arg0: volScalarField) -> tmp_volSymmTensorField:
        ...
    def __setitem__(self, arg0: str, arg1: symmTensorField) -> None:
        ...
    def __sub__(self, arg0: volSymmTensorField) -> tmp_volSymmTensorField:
        ...
    def __truediv__(self, arg0: volScalarField) -> tmp_volSymmTensorField:
        ...
    def internalField(self, arg0: str) -> symmTensorField:
        ...
class volTensorField:
    @staticmethod
    def from_registry(arg0: fvMesh, arg1: str) -> volTensorField:
        ...
    @staticmethod
    def list_objects(arg0: fvMesh) -> wordList:
        ...
    @staticmethod
    def read_field(arg0: fvMesh, arg1: str) -> volTensorField:
        ...
    def __add__(self, arg0: volTensorField) -> tmp_volTensorField:
        ...
    def __getitem__(self, arg0: str) -> tensorField:
        ...
    @typing.overload
    def __init__(self, arg0: volTensorField) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: tmp_volTensorField) -> None:
        ...
    def __mul__(self, arg0: volScalarField) -> tmp_volTensorField:
        ...
    def __setitem__(self, arg0: str, arg1: tensorField) -> None:
        ...
    def __sub__(self, arg0: volTensorField) -> tmp_volTensorField:
        ...
    def __truediv__(self, arg0: volScalarField) -> tmp_volTensorField:
        ...
    def internalField(self, arg0: str) -> tensorField:
        ...
class volVectorField:
    @staticmethod
    def from_registry(arg0: fvMesh, arg1: str) -> volVectorField:
        ...
    @staticmethod
    def list_objects(arg0: fvMesh) -> wordList:
        ...
    @staticmethod
    def read_field(arg0: fvMesh, arg1: str) -> volVectorField:
        ...
    def __add__(self, arg0: volVectorField) -> tmp_volVectorField:
        ...
    def __getitem__(self, arg0: str) -> vectorField:
        ...
    @typing.overload
    def __init__(self, arg0: volVectorField) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: tmp_volVectorField) -> None:
        ...
    def __mul__(self, arg0: volScalarField) -> tmp_volVectorField:
        ...
    def __setitem__(self, arg0: str, arg1: vectorField) -> None:
        ...
    def __sub__(self, arg0: volVectorField) -> tmp_volVectorField:
        ...
    def __truediv__(self, arg0: volScalarField) -> tmp_volVectorField:
        ...
    def internalField(self, arg0: str) -> vectorField:
        ...
class wordList:
    def __getitem__(self, arg0: typing.SupportsInt) -> str:
        ...
    @typing.overload
    def __init__(self, arg0: wordList) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: collections.abc.Sequence[str]) -> None:
        ...
    def __len__(self) -> int:
        ...
    def __setitem__(self, arg0: typing.SupportsInt, arg1: str) -> None:
        ...
    def list(self) -> list[str]:
        ...
@typing.overload
def mag(arg0: typing.SupportsFloat) -> float:
    ...
@typing.overload
def mag(arg0: vector) -> float:
    ...
@typing.overload
def mag(arg0: tensor) -> float:
    ...
@typing.overload
def mag(arg0: volScalarField) -> volScalarField:
    ...
@typing.overload
def mag(arg0: volVectorField) -> volScalarField:
    ...
@typing.overload
def mag(arg0: volTensorField) -> volScalarField:
    ...
@typing.overload
def mag(arg0: volSymmTensorField) -> volScalarField:
    ...
@typing.overload
def mag(arg0: surfaceScalarField) -> surfaceScalarField:
    ...
@typing.overload
def mag(arg0: surfaceVectorField) -> surfaceScalarField:
    ...
@typing.overload
def mag(arg0: surfaceTensorField) -> surfaceScalarField:
    ...
def selectTimes(arg0: ..., arg1: collections.abc.Sequence[str]) -> ...:
    ...
@typing.overload
def sum(arg0: scalarField) -> float:
    ...
@typing.overload
def sum(arg0: vectorField) -> vector:
    ...
@typing.overload
def sum(arg0: tensorField) -> tensor:
    ...
@typing.overload
def sum(arg0: symmTensorField) -> symmTensor:
    ...
