"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bounce = exports.BounceTemplate = void 0;
/**
 * (experimental) A bounce template.
 *
 * @experimental
 */
class BounceTemplate {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
}
exports.BounceTemplate = BounceTemplate;
/**
 * @experimental
 */
BounceTemplate.MAILBOX_DOES_NOT_EXIST = new BounceTemplate({
    message: 'Mailbox does not exist',
    smtpReplyCode: '550',
    statusCode: '5.1.1',
});
/**
 * @experimental
 */
BounceTemplate.MESSAGE_TOO_LARGE = new BounceTemplate({
    message: 'Message too large',
    smtpReplyCode: '552',
    statusCode: '5.3.4',
});
/**
 * @experimental
 */
BounceTemplate.MAILBOX_FULL = new BounceTemplate({
    message: 'Mailbox full',
    smtpReplyCode: '552',
    statusCode: '5.2.2',
});
/**
 * @experimental
 */
BounceTemplate.MESSAGE_CONTENT_REJECTED = new BounceTemplate({
    message: 'Message content rejected',
    smtpReplyCode: '500',
    statusCode: '5.6.1',
});
/**
 * @experimental
 */
BounceTemplate.TEMPORARY_FAILURE = new BounceTemplate({
    message: 'Temporary failure',
    smtpReplyCode: '450',
    statusCode: '4.0.0',
});
/**
 * (experimental) Rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon SNS.
 *
 * @experimental
 */
class Bounce {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) (experimental) Returns the receipt rule action specification.
     *
     * @experimental
     */
    bind(_rule) {
        return {
            bounceAction: {
                sender: this.props.sender,
                smtpReplyCode: this.props.template.props.smtpReplyCode,
                message: this.props.template.props.message,
                topicArn: this.props.topic ? this.props.topic.topicArn : undefined,
                statusCode: this.props.template.props.statusCode,
            },
        };
    }
}
exports.Bounce = Bounce;
//# sourceMappingURL=data:application/json;base64,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