"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Lambda = exports.LambdaInvocationType = void 0;
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * (experimental) The type of invocation to use for a Lambda Action.
 *
 * @experimental
 */
var LambdaInvocationType;
(function (LambdaInvocationType) {
    LambdaInvocationType["EVENT"] = "Event";
    LambdaInvocationType["REQUEST_RESPONSE"] = "RequestResponse";
})(LambdaInvocationType = exports.LambdaInvocationType || (exports.LambdaInvocationType = {}));
/**
 * (experimental) Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
 *
 * @experimental
 */
class Lambda {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) (experimental) Returns the receipt rule action specification.
     *
     * @experimental
     */
    bind(rule) {
        // Allow SES to invoke Lambda function
        // See https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html#receiving-email-permissions-lambda
        const permissionId = 'AllowSes';
        if (!this.props.function.permissionsNode.tryFindChild(permissionId)) {
            this.props.function.addPermission(permissionId, {
                action: 'lambda:InvokeFunction',
                principal: new iam.ServicePrincipal('ses.amazonaws.com'),
                sourceAccount: cdk.Aws.ACCOUNT_ID,
            });
        }
        // Ensure permission is deployed before rule
        const permission = this.props.function.permissionsNode.tryFindChild(permissionId);
        if (permission) { // The Lambda could be imported
            rule.node.addDependency(permission);
        }
        else {
            // eslint-disable-next-line max-len
            cdk.Annotations.of(rule).addWarning('This rule is using a Lambda action with an imported function. Ensure permission is given to SES to invoke that function.');
        }
        return {
            lambdaAction: {
                functionArn: this.props.function.functionArn,
                invocationType: this.props.invocationType,
                topicArn: this.props.topic ? this.props.topic.topicArn : undefined,
            },
        };
    }
}
exports.Lambda = Lambda;
//# sourceMappingURL=data:application/json;base64,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