"""Data models for OpenAgents."""

from .transport import (
    TransportType,
    ConnectionState,
    PeerMetadata,
    ConnectionInfo,
    AgentConnection,
)

from .messages import Event, EventVisibility, EventNames

from .network_config import NetworkConfig, OpenAgentsConfig, NetworkMode

from .network_role import NetworkRole

__all__ = [
    # Transport models
    "TransportType",
    "ConnectionState",
    "PeerMetadata",
    "ConnectionInfo",
    "AgentConnection",
    # Event models (unified message system)
    "Event",
    "EventVisibility",
    "EventNames",
    # Config models
    "NetworkConfig",
    "OpenAgentsConfig",
    "NetworkMode",
    "NetworkRole",
]
