import * as customresources from 'aws-cdk-lib/custom-resources';
import * as constructs from 'constructs';
import * as network from './network';
/**
 * Supported instance types for Managed Blockchain nodes
 */
export declare enum InstanceType {
    BURSTABLE3_SMALL = "bc.t3.small",
    BURSTABLE3_MEDIUM = "bc.t3.medium",
    BURSTABLE3_LARGE = "bc.t3.large",
    BURSTABLE3_XLARGE = "bc.t3.xlarge",
    STANDARD5_LARGE = "bc.m5.large",
    STANDARD5_XLARGE = "bc.m5.xlarge",
    STANDARD5_XLARGE2 = "bc.m5.2xlarge",
    STANDARD5_XLARGE4 = "bc.m5.4xlarge",
    COMPUTE5_LARGE = "bc.c5.large",
    COMPUTE5_XLARGE = "bc.c5.xlarge",
    COMPUTE5_XLARGE2 = "bc.c5.2xlarge",
    COMPUTE5_XLARGE4 = "bc.c5.4xlarge"
}
/**
 * Valid instance types for starter networks
 */
export declare const STARTER_INSTANCE_TYPES: InstanceType[];
/**
 * Construct properties for `HyperledgerFabricNode`
 */
export interface HyperledgerFabricNodeProps {
    /**
     * The Availability Zone in which the node will be created
     * @default - The first AZ in the region
     */
    readonly availabilityZone?: string;
    /**
     * The Amazon Managed Blockchain instance type for the node
     * @default - BURSTABLE3_SMALL
     */
    readonly instanceType?: InstanceType;
    /**
     * The configuration to enable or disable chaincode logging
     * @default - true
     */
    readonly enableChaincodeLogging?: boolean;
    /**
     * The configuration to enable or disable node logging
     * @default - true
     */
    readonly enableNodeLogging?: boolean;
}
/**
 * Creates a Hyperledger Fabric node on an Amazon Managed Blockchain network
 */
export declare class HyperledgerFabricNode extends constructs.Construct {
    /**
     * Build out a list of HyperledgerFabricNode constructs given a list of input property
     * objects; additionally checks to ensure node count is supported given the network type
     */
    static constructNodes(scope: network.HyperledgerFabricNetwork, nodeProps?: Array<HyperledgerFabricNodeProps>): HyperledgerFabricNode[];
    /**
     * Managed Blockchain network identifier
     */
    readonly networkId: string;
    /**
     * Managed Blockchain member identifier
     */
    readonly memberId: string;
    /**
     * Managed Blockchain node identifier generated on construction
     */
    readonly nodeId: string;
    /**
     * The Availability Zone in which the node exists
     */
    readonly availabilityZone: string;
    /**
     * The Amazon Managed Blockchain instance type for the node
     */
    readonly instanceType: InstanceType;
    /**
     * The configuration to enable or disable chaincode logging
     */
    readonly enableChaincodeLogging: boolean;
    /**
     * The configuration to enable or disable node logging
     */
    readonly enableNodeLogging: boolean;
    endpoint: string;
    eventEndpoint: string;
    constructor(scope: network.HyperledgerFabricNetwork, id: string, props?: HyperledgerFabricNodeProps);
    /**
     * Configure logging for the node via SDK call; this function
     * should be merged back into the constructor once the race condition is solved
     */
    configureLogging(sdkCallPolicy: customresources.AwsCustomResourcePolicy): void;
    /**
     * Populate the output properties that must be fetched via SDK call; this function
     * should be merged back into the constructor once the race condition is solved
     */
    fetchData(dataSdkCallPolicy: customresources.AwsCustomResourcePolicy): void;
}
