import * as secretsmanager from 'aws-cdk-lib/aws-secretsmanager';
import * as constructs from 'constructs';
import * as network from './network';
/**
 * Construct properties for `HyperledgerFabricUser`
 */
export interface HyperledgerFabricUserProps {
    /**
     * User's affiliation to the member.
     * Should be hierarchical with member name as root(`MemberName.Dept1`).
     */
    readonly affilitation: string;
    /**
     * User ID to register with CA
     */
    readonly userId: string;
}
/**
 * Creates custom resources to register and enroll users identities
 * with the CA using the fabric-ca-client SDK
 */
export declare class HyperledgerFabricUser extends constructs.Construct {
    /**
     * User ID registered with CA
     */
    readonly userId: string;
    /**
     * User's affiliation to the member
     */
    readonly affiliation: string;
    /**
     * Secret for user signed certificate
     */
    readonly userSignedCertSecret: secretsmanager.Secret;
    /**
     * Secret for user private key
     */
    readonly userPrivateKeySecret: secretsmanager.Secret;
    constructor(scope: network.HyperledgerFabricNetwork, id: string, props: HyperledgerFabricUserProps);
}
