/**
 * Regions where Managed Blockchain is supported, for details see
 * https://aws.amazon.com/managed-blockchain/pricing/hyperledger/
 */
export declare const SUPPORTED_REGIONS: string[];
/**
 * Map of supported regions to their availability zones
 */
export declare const SUPPORTED_AVAILABILITY_ZONES: Record<string, Array<string>>;
/**
 * Starting port of the Network port range
 */
export declare const STARTING_PORT = 30001;
/**
 * Ending port of the Network port range
 */
export declare const ENDING_PORT = 30004;
/**
 * Returns the S3 Bucket and key that contains the TLS cert file
 */
export declare function getTlsBucket(region: string): {
    bucketName: string;
    key: string;
};
/**
 * Throw an error if provided region is not in the supported list
 */
export declare function validateRegion(region: string): void;
/**
 * Throw an error if provided availability zone is not in the supported list
 */
export declare function validateAvailabilityZone(region: string, availabilityZone?: string): void;
/**
 * Throw an error if provided number is not an integer, or not with the given range (inclusive)
 */
export declare function validateInteger(value: number, min: number, max: number): boolean;
/**
 * Throw an error if provided string has length with a given range (inclusive),
 * and optionally matches a provided regular expression pattern
 */
export declare function validateString(value: string, min: number, max: number, regexp?: RegExp | undefined): boolean;
