# Generated by ariadne-codegen
# Source: ../graphql

from typing import Any, AsyncIterator, Dict, List, Optional, Union

from .abort_execution import AbortExecution
from .add_api_key import AddApiKey
from .add_role import AddRole
from .add_role_device_group import AddRoleDeviceGroup
from .add_role_neops_task import AddRoleNeopsTask
from .add_user import AddUser
from .add_users_to_role import AddUsersToRole
from .app_settings import AppSettings
from .archive_or_delete_task import ArchiveOrDeleteTask
from .async_base_client import AsyncBaseClient
from .autocomplete_fields import AutocompleteFields
from .base_model import UNSET, UnsetType
from .client_aggregation import ClientAggregation
from .clients import Clients
from .cron_execution_type import CronExecutionType
from .cronjob_execution_types import CronjobExecutionTypes
from .cronjob_type import CronjobType
from .cronjob_types import CronjobTypes
from .device_aggregation import DeviceAggregation
from .device_group_elastic import DeviceGroupElastic
from .device_group_upsert import DeviceGroupUpsert
from .device_upsert import DeviceUpsert
from .devices import Devices
from .discovery import Discovery
from .enums import (
    CronExecuteTypeEnum,
    ExecutionTypeEnum,
    OutputSchemaTypeEnum,
    ProviderSchemaEnum,
    RunOnEnum,
)
from .execute_neops_task import ExecuteNeopsTask
from .execution import Execution
from .execution_subscription import ExecutionSubscription
from .executions_detail import ExecutionsDetail
from .executions_elastic import ExecutionsElastic
from .executions_simple import ExecutionsSimple
from .get_and_lock_resources import GetAndLockResources
from .get_role import GetRole
from .group_aggregation import GroupAggregation
from .interface_aggregation import InterfaceAggregation
from .interfaces import Interfaces
from .jinja_render import JinjaRender
from .json_form import JsonForm
from .location_upsert import LocationUpsert
from .login import Login
from .neops_provider import NeopsProvider
from .neops_task_create_mutation import NeopsTaskCreateMutation
from .neops_task_cronjob_delete import NeopsTaskCronjobDelete
from .neops_task_cronjob_upsert import NeopsTaskCronjobUpsert
from .neops_task_cronjobs import NeopsTaskCronjobs
from .neops_task_unarchive import NeopsTaskUnarchive
from .neops_tasks import NeopsTasks
from .permissions import Permissions
from .platforms import Platforms
from .process_overview import ProcessOverview
from .providers import Providers
from .refresh_token import RefreshToken
from .reports import Reports
from .reports_execute import ReportsExecute
from .role_device_group import RoleDeviceGroup
from .role_device_group_upsert import RoleDeviceGroupUpsert
from .role_neops_task import RoleNeopsTask
from .role_neops_task_upsert import RoleNeopsTaskUpsert
from .role_permission_element import RolePermissionElement
from .role_permission_element_upsert import RolePermissionElementUpsert
from .role_permission_upsert import RolePermissionUpsert
from .role_permissions import RolePermissions
from .role_scope_upsert import RoleScopeUpsert
from .role_user import RoleUser
from .rollback import Rollback
from .saved_search_create import SavedSearchCreate
from .saved_search_delete import SavedSearchDelete
from .saved_searches import SavedSearches
from .scope_delete import ScopeDelete
from .scopes import Scopes
from .scopes_upsert import ScopesUpsert
from .single_discovery import SingleDiscovery
from .text_fsm_render import TextFsmRender
from .topology import Topology
from .unlock_resources import UnlockResources


def gql(q: str) -> str:
    return q


class Client(AsyncBaseClient):
    async def abort_execution(
        self,
        id: Union[Optional[int], UnsetType] = UNSET,
        task_id: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> AbortExecution:
        query = gql(
            """
            mutation abortExecution($id: Int, $taskId: String) {
              abortExecution(id: $id, taskId: $taskId) {
                executions {
                  id
                  name
                  state
                  neopsTask {
                    id
                    name
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id, "taskId": task_id}
        response = await self.execute(
            query=query, operation_name="abortExecution", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return AbortExecution.model_validate(data)

    async def add_api_key(
        self,
        app: str,
        description: Union[Optional[str], UnsetType] = UNSET,
        user_id: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> AddApiKey:
        query = gql(
            """
            mutation addApiKey($app: String!, $description: String, $userId: ID) {
              staticApiKeyCreate(app: $app, description: $description, userId: $userId) {
                app
                accessToken
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "app": app,
            "description": description,
            "userId": user_id,
        }
        response = await self.execute(
            query=query, operation_name="addApiKey", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return AddApiKey.model_validate(data)

    async def add_role(
        self,
        name: Union[Optional[str], UnsetType] = UNSET,
        users: Union[Optional[List[Optional[str]]], UnsetType] = UNSET,
        **kwargs: Any
    ) -> AddRole:
        query = gql(
            """
            mutation addRole($name: String, $users: [ID]) {
              roleUpsert(name: $name, users: $users) {
                role {
                  id
                  users {
                    id
                    username
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"name": name, "users": users}
        response = await self.execute(
            query=query, operation_name="addRole", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return AddRole.model_validate(data)

    async def add_role_device_group(
        self,
        device_group_id: Union[Optional[str], UnsetType] = UNSET,
        role_id: Union[Optional[str], UnsetType] = UNSET,
        permission: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> AddRoleDeviceGroup:
        query = gql(
            """
            mutation addRoleDeviceGroup($deviceGroupId: ID, $roleId: ID, $permission: Int) {
              roleDeviceGroupUpsert(
                deviceGroupId: $deviceGroupId
                roleId: $roleId
                permission: $permission
              ) {
                roleDeviceGroup {
                  role {
                    id
                    users {
                      id
                      username
                    }
                  }
                  deviceGroup {
                    id
                    name
                    devices {
                      hostname
                    }
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "deviceGroupId": device_group_id,
            "roleId": role_id,
            "permission": permission,
        }
        response = await self.execute(
            query=query,
            operation_name="addRoleDeviceGroup",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return AddRoleDeviceGroup.model_validate(data)

    async def add_role_neops_task(
        self,
        neops_task_id: Union[Optional[str], UnsetType] = UNSET,
        role_id: Union[Optional[str], UnsetType] = UNSET,
        permission: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> AddRoleNeopsTask:
        query = gql(
            """
            mutation addRoleNeopsTask($neopsTaskId: ID, $roleId: ID, $permission: Int) {
              roleNeopsTaskUpsert(
                neopsTaskId: $neopsTaskId
                roleId: $roleId
                permission: $permission
              ) {
                roleNeopsTask {
                  role {
                    id
                    users {
                      id
                      username
                    }
                  }
                  neopsTask {
                    id
                    name
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "neopsTaskId": neops_task_id,
            "roleId": role_id,
            "permission": permission,
        }
        response = await self.execute(
            query=query,
            operation_name="addRoleNeopsTask",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return AddRoleNeopsTask.model_validate(data)

    async def add_user(
        self,
        username: str,
        password: str,
        email: Union[Optional[str], UnsetType] = UNSET,
        first_name: Union[Optional[str], UnsetType] = UNSET,
        last_name: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> AddUser:
        query = gql(
            """
            mutation addUser($username: String!, $password: String!, $email: String, $firstName: String, $lastName: String) {
              localUserCreate(
                username: $username
                password: $password
                email: $email
                firstName: $firstName
                lastName: $lastName
              ) {
                localUser {
                  id
                  username
                  password
                  isActive
                  isSuperuser
                  firstName
                  lastName
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "username": username,
            "password": password,
            "email": email,
            "firstName": first_name,
            "lastName": last_name,
        }
        response = await self.execute(
            query=query, operation_name="addUser", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return AddUser.model_validate(data)

    async def add_users_to_role(
        self,
        id: Union[Optional[str], UnsetType] = UNSET,
        users: Union[Optional[List[Optional[str]]], UnsetType] = UNSET,
        **kwargs: Any
    ) -> AddUsersToRole:
        query = gql(
            """
            mutation addUsersToRole($id: ID, $users: [ID]) {
              roleAddUsers(id: $id, users: $users) {
                role {
                  id
                  name
                  users {
                    id
                    username
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id, "users": users}
        response = await self.execute(
            query=query, operation_name="addUsersToRole", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return AddUsersToRole.model_validate(data)

    async def app_settings(self, **kwargs: Any) -> AppSettings:
        query = gql(
            """
            query appSettings {
              appSettings {
                auth {
                  active
                  type
                }
                modules {
                  name
                }
                sentry {
                  dsn
                  environment
                }
                version
                useOidc
                oidcConfig
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query, operation_name="appSettings", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return AppSettings.model_validate(data)

    async def archive_or_delete_task(
        self,
        id: str,
        hard_delete: Union[Optional[bool], UnsetType] = UNSET,
        **kwargs: Any
    ) -> ArchiveOrDeleteTask:
        query = gql(
            """
            mutation archiveOrDeleteTask($id: ID!, $hardDelete: Boolean = false) {
              neopsTaskDelete(id: $id, hardDelete: $hardDelete) {
                neopsTask {
                  id
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id, "hardDelete": hard_delete}
        response = await self.execute(
            query=query,
            operation_name="archiveOrDeleteTask",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ArchiveOrDeleteTask.model_validate(data)

    async def autocomplete_fields(self, **kwargs: Any) -> AutocompleteFields:
        query = gql(
            """
            query autocompleteFields {
              searchFields(index: GLOBAL)
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query,
            operation_name="autocompleteFields",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return AutocompleteFields.model_validate(data)

    async def client_aggregation(
        self,
        aggr_field: str,
        query: Union[Optional[str], UnsetType] = UNSET,
        size: Union[Optional[int], UnsetType] = UNSET,
        scope: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> ClientAggregation:
        _query = gql(
            """
            query clientAggregation($aggrField: String!, $query: String, $size: Int, $scope: Int) {
              clientAggregation(
                aggrField: $aggrField
                query: $query
                queryTypeGlobal: true
                size: $size
                scope: $scope
              ) {
                results {
                  value
                  count
                }
                countAggregatedElements
                count
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "aggrField": aggr_field,
            "query": query,
            "size": size,
            "scope": scope,
        }
        response = await self.execute(
            query=_query,
            operation_name="clientAggregation",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ClientAggregation.model_validate(data)

    async def clients(
        self,
        query: Union[Optional[str], UnsetType] = UNSET,
        page: Union[Optional[int], UnsetType] = UNSET,
        page_size: Union[Optional[int], UnsetType] = UNSET,
        ordering: Union[Optional[str], UnsetType] = UNSET,
        scope: Union[Optional[Any], UnsetType] = UNSET,
        id: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> Clients:
        _query = gql(
            """
            query clients($query: String, $page: Int, $pageSize: Int, $ordering: String, $scope: Decimal, $id: ID) {
              clientsElastic(id: $id, query: $query, queryTypeGlobal: true, scope: $scope) {
                totalCount
                results(page: $page, pageSize: $pageSize, ordering: $ordering) {
                  id
                  createdAt
                  updatedAt
                  fromimport
                  lastdiscovered
                  macaddress
                  facts
                  interface {
                    id
                    name
                    device {
                      id
                      hostname
                      ip
                    }
                  }
                  location {
                    id
                    name
                    address
                    city
                    country
                    lat
                    lon
                  }
                  checks
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "query": query,
            "page": page,
            "pageSize": page_size,
            "ordering": ordering,
            "scope": scope,
            "id": id,
        }
        response = await self.execute(
            query=_query, operation_name="clients", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Clients.model_validate(data)

    async def cron_execution_type(
        self,
        cron_execute_type: Union[Optional[CronExecuteTypeEnum], UnsetType] = UNSET,
        **kwargs: Any
    ) -> CronExecutionType:
        query = gql(
            """
            query cronExecutionType($cronExecuteType: CronExecuteTypeEnum) {
              cronjobExecutionTypes(cronExecuteType: $cronExecuteType) {
                results {
                  form
                  cronExecuteType
                }
                totalCount
              }
            }
            """
        )
        variables: Dict[str, object] = {"cronExecuteType": cron_execute_type}
        response = await self.execute(
            query=query,
            operation_name="cronExecutionType",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CronExecutionType.model_validate(data)

    async def neops_task_cronjob_delete(
        self, id: str, **kwargs: Any
    ) -> NeopsTaskCronjobDelete:
        query = gql(
            """
            mutation neopsTaskCronjobDelete($id: ID!) {
              neopsTaskCronjobDelete(id: $id) {
                neopsTaskCronjob {
                  id
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query,
            operation_name="neopsTaskCronjobDelete",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return NeopsTaskCronjobDelete.model_validate(data)

    async def cronjob_execution_types(self, **kwargs: Any) -> CronjobExecutionTypes:
        query = gql(
            """
            query cronjobExecutionTypes {
              cronjobExecutionTypes {
                results {
                  form
                  cronExecuteType
                }
                totalCount
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query,
            operation_name="cronjobExecutionTypes",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CronjobExecutionTypes.model_validate(data)

    async def cronjob_type(
        self, id: Union[Optional[Any], UnsetType] = UNSET, **kwargs: Any
    ) -> CronjobType:
        query = gql(
            """
            query cronjobType($id: Decimal) {
              cronjobType(id: $id) {
                results {
                  id
                  name
                  description
                  task
                  args
                  customArgsFrom
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query, operation_name="cronjobType", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CronjobType.model_validate(data)

    async def cronjob_types(self, **kwargs: Any) -> CronjobTypes:
        query = gql(
            """
            query cronjobTypes {
              cronjobType {
                results {
                  id
                  name
                  description
                  task
                  args
                  customArgsFrom
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query, operation_name="cronjobTypes", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CronjobTypes.model_validate(data)

    async def neops_task_cronjob_upsert(
        self,
        description: Union[Optional[str], UnsetType] = UNSET,
        element_filter: Union[Optional[str], UnsetType] = UNSET,
        enabled: Union[Optional[bool], UnsetType] = UNSET,
        execute_times: Union[Optional[Any], UnsetType] = UNSET,
        execute_type: Union[Optional[CronExecuteTypeEnum], UnsetType] = UNSET,
        id: Union[Optional[str], UnsetType] = UNSET,
        name: Union[Optional[str], UnsetType] = UNSET,
        neops_task: Union[Optional[str], UnsetType] = UNSET,
        neops_task_args: Union[Optional[Any], UnsetType] = UNSET,
        **kwargs: Any
    ) -> NeopsTaskCronjobUpsert:
        query = gql(
            """
            mutation neopsTaskCronjobUpsert($description: String, $elementFilter: String, $enabled: Boolean, $executeTimes: JSONString, $executeType: CronExecuteTypeEnum, $id: ID, $name: String, $neopsTask: ID, $neopsTaskArgs: JSONString) {
              neopsTaskCronjobUpsert(
                description: $description
                elementFilter: $elementFilter
                enabled: $enabled
                executeTimes: $executeTimes
                executeType: $executeType
                id: $id
                name: $name
                neopsTask: $neopsTask
                neopsTaskArgs: $neopsTaskArgs
              ) {
                neopsTaskCronjob {
                  id
                  name
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "description": description,
            "elementFilter": element_filter,
            "enabled": enabled,
            "executeTimes": execute_times,
            "executeType": execute_type,
            "id": id,
            "name": name,
            "neopsTask": neops_task,
            "neopsTaskArgs": neops_task_args,
        }
        response = await self.execute(
            query=query,
            operation_name="neopsTaskCronjobUpsert",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return NeopsTaskCronjobUpsert.model_validate(data)

    async def neops_task_cronjobs(
        self, id: Union[Optional[Any], UnsetType] = UNSET, **kwargs: Any
    ) -> NeopsTaskCronjobs:
        query = gql(
            """
            query neopsTaskCronjobs($id: Decimal) {
              neopsTaskCronjob(id: $id) {
                results {
                  id
                  name
                  description
                  createdAt
                  neopsTask {
                    id
                    name
                    taskRunInputSchema
                  }
                  neopsTaskArgs
                  executeType
                  executeTimes
                  elementFilter
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query,
            operation_name="neopsTaskCronjobs",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return NeopsTaskCronjobs.model_validate(data)

    async def device_aggregation(
        self,
        aggr_field: str,
        query: Union[Optional[str], UnsetType] = UNSET,
        size: Union[Optional[int], UnsetType] = UNSET,
        scope: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> DeviceAggregation:
        _query = gql(
            """
            query deviceAggregation($aggrField: String!, $query: String, $size: Int, $scope: Int) {
              deviceAggregation(
                aggrField: $aggrField
                query: $query
                queryTypeGlobal: true
                size: $size
                scope: $scope
              ) {
                results {
                  value
                  count
                }
                countAggregatedElements
                count
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "aggrField": aggr_field,
            "query": query,
            "size": size,
            "scope": scope,
        }
        response = await self.execute(
            query=_query,
            operation_name="deviceAggregation",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeviceAggregation.model_validate(data)

    async def device_group_elastic(
        self,
        page: Union[Optional[int], UnsetType] = UNSET,
        page_size: Union[Optional[int], UnsetType] = UNSET,
        ordering: Union[Optional[str], UnsetType] = UNSET,
        query: Union[Optional[str], UnsetType] = UNSET,
        id: Union[Optional[str], UnsetType] = UNSET,
        permission: Union[Optional[str], UnsetType] = UNSET,
        scope: Union[Optional[Any], UnsetType] = UNSET,
        **kwargs: Any
    ) -> DeviceGroupElastic:
        _query = gql(
            """
            query deviceGroupElastic($page: Int = 1, $pageSize: Int = 999, $ordering: String = "name", $query: String = "", $id: ID, $permission: String = "read", $scope: Decimal) {
              groupsElastic(
                query: $query
                queryTypeGlobal: true
                id: $id
                permission: $permission
                scope: $scope
              ) {
                totalCount
                results(page: $page, pageSize: $pageSize, ordering: $ordering) {
                  id
                  name
                  title
                  description
                  location {
                    id
                    address
                    city
                    zipCode
                    lon
                    lat
                  }
                  deviceCount
                  checks
                  facts
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "page": page,
            "pageSize": page_size,
            "ordering": ordering,
            "query": query,
            "id": id,
            "permission": permission,
            "scope": scope,
        }
        response = await self.execute(
            query=_query,
            operation_name="deviceGroupElastic",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeviceGroupElastic.model_validate(data)

    async def device_group_upsert(
        self,
        description: Union[Optional[str], UnsetType] = UNSET,
        devices: Union[Optional[List[Optional[str]]], UnsetType] = UNSET,
        id: Union[Optional[str], UnsetType] = UNSET,
        name: Union[Optional[str], UnsetType] = UNSET,
        title: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> DeviceGroupUpsert:
        query = gql(
            """
            mutation deviceGroupUpsert($description: String, $devices: [ID], $id: ID, $name: String, $title: String) {
              deviceGroupUpsert(
                description: $description
                devices: $devices
                id: $id
                name: $name
                title: $title
              ) {
                deviceGroup {
                  id
                  name
                  description
                  title
                  devices {
                    id
                    hostname
                    ip
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "description": description,
            "devices": devices,
            "id": id,
            "name": name,
            "title": title,
        }
        response = await self.execute(
            query=query,
            operation_name="deviceGroupUpsert",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeviceGroupUpsert.model_validate(data)

    async def device_upsert(
        self,
        connection_options: Union[Optional[Any], UnsetType] = UNSET,
        groups: Union[Optional[List[Optional[str]]], UnsetType] = UNSET,
        hostname: Union[Optional[str], UnsetType] = UNSET,
        id: Union[Optional[str], UnsetType] = UNSET,
        ip: Union[Optional[str], UnsetType] = UNSET,
        password: Union[Optional[str], UnsetType] = UNSET,
        platform: Union[Optional[str], UnsetType] = UNSET,
        username: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> DeviceUpsert:
        query = gql(
            """
            mutation deviceUpsert($connectionOptions: JSONString, $groups: [ID], $hostname: String, $id: ID, $ip: String, $password: String, $platform: ID, $username: String) {
              deviceUpsert(
                connectionOptions: $connectionOptions
                groups: $groups
                hostname: $hostname
                id: $id
                ip: $ip
                password: $password
                platform: $platform
                username: $username
              ) {
                device {
                  id
                  hostname
                  connectionOptions
                  ip
                  groups {
                    id
                    name
                  }
                  platform {
                    id
                    name
                  }
                  username
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "connectionOptions": connection_options,
            "groups": groups,
            "hostname": hostname,
            "id": id,
            "ip": ip,
            "password": password,
            "platform": platform,
            "username": username,
        }
        response = await self.execute(
            query=query, operation_name="deviceUpsert", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return DeviceUpsert.model_validate(data)

    async def devices(
        self,
        query: Union[Optional[str], UnsetType] = UNSET,
        page: Union[Optional[int], UnsetType] = UNSET,
        page_size: Union[Optional[int], UnsetType] = UNSET,
        id: Union[Optional[str], UnsetType] = UNSET,
        ordering: Union[Optional[str], UnsetType] = UNSET,
        scope: Union[Optional[Any], UnsetType] = UNSET,
        **kwargs: Any
    ) -> Devices:
        _query = gql(
            """
            query devices($query: String = "", $page: Int = 1, $pageSize: Int = 999, $id: ID, $ordering: String = "hostname", $scope: Decimal) {
              devicesElastic(query: $query, queryTypeGlobal: true, id: $id, scope: $scope) {
                totalCount
                results(page: $page, pageSize: $pageSize, ordering: $ordering) {
                  id
                  createdAt
                  updatedAt
                  hostname
                  ip
                  connectionState
                  facts
                  softwareRelease
                  platform {
                    id
                    name
                    shortName
                  }
                  vendor
                  model
                  serial
                  username
                  currentConfiguration
                  groups {
                    id
                    name
                  }
                  checks
                  groupCount
                  interfaceCount
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "query": query,
            "page": page,
            "pageSize": page_size,
            "id": id,
            "ordering": ordering,
            "scope": scope,
        }
        response = await self.execute(
            query=_query, operation_name="devices", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Devices.model_validate(data)

    async def discovery(
        self, arguments: Union[Optional[Any], UnsetType] = UNSET, **kwargs: Any
    ) -> Discovery:
        query = gql(
            """
            mutation discovery($arguments: JSONString) {
              execute(task: "discover_device", arguments: $arguments) {
                execution {
                  id
                  taskId
                  state
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"arguments": arguments}
        response = await self.execute(
            query=query, operation_name="discovery", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Discovery.model_validate(data)

    async def execute_neops_task(
        self,
        neops_task_id: str,
        dry_run: Union[Optional[bool], UnsetType] = UNSET,
        execute_on: Union[Optional[List[Optional[str]]], UnsetType] = UNSET,
        execute_on_type: Union[Optional[RunOnEnum], UnsetType] = UNSET,
        name: Union[Optional[str], UnsetType] = UNSET,
        process_execution_id: Union[Optional[str], UnsetType] = UNSET,
        task_arguments: Union[Optional[Any], UnsetType] = UNSET,
        run_synchronous: Union[Optional[bool], UnsetType] = UNSET,
        unique_task_name: Union[Optional[str], UnsetType] = UNSET,
        synchronous_timeout: Union[Optional[int], UnsetType] = UNSET,
        search_query: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> ExecuteNeopsTask:
        query = gql(
            """
            mutation executeNeopsTask($dryRun: Boolean, $executeOn: [ID], $executeOnType: RunOnEnum, $name: String, $neopsTaskId: ID!, $processExecutionId: ID, $taskArguments: JSONString, $runSynchronous: Boolean, $uniqueTaskName: String, $synchronousTimeout: Int, $searchQuery: String) {
              executeNeopsTask(
                dryRun: $dryRun
                executeOn: $executeOn
                executeOnType: $executeOnType
                name: $name
                neopsTaskId: $neopsTaskId
                processExecutionId: $processExecutionId
                taskArguments: $taskArguments
                runSynchronous: $runSynchronous
                uniquetaskname: $uniqueTaskName
                synchronousTimeout: $synchronousTimeout
                searchQuery: $searchQuery
              ) {
                executions {
                  args
                  id
                  taskId
                  name
                  createdAt
                  updatedAt
                  state
                  executionType
                  taskId
                  task
                  neopsTask {
                    id
                    name
                    description
                    provider {
                      providerType
                    }
                  }
                  deviceExecution {
                    execution {
                      id
                    }
                    id
                    device {
                      id
                      hostname
                      vendor
                      model
                      platform {
                        id
                        name
                      }
                      softwareRelease
                    }
                    runOn
                    executeOn
                    state
                    exception
                    do
                    done
                    changed
                    willChange
                    log
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "dryRun": dry_run,
            "executeOn": execute_on,
            "executeOnType": execute_on_type,
            "name": name,
            "neopsTaskId": neops_task_id,
            "processExecutionId": process_execution_id,
            "taskArguments": task_arguments,
            "runSynchronous": run_synchronous,
            "uniqueTaskName": unique_task_name,
            "synchronousTimeout": synchronous_timeout,
            "searchQuery": search_query,
        }
        response = await self.execute(
            query=query,
            operation_name="executeNeopsTask",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ExecuteNeopsTask.model_validate(data)

    async def execution(
        self, id: Union[Optional[Any], UnsetType] = UNSET, **kwargs: Any
    ) -> Execution:
        query = gql(
            """
            query execution($id: Decimal) {
              executions(id: $id) {
                results {
                  id
                  taskId
                  name
                  executionType
                  createdAt
                  updatedAt
                  log
                  do
                  done
                  process {
                    name
                    id
                  }
                  neopsTask {
                    id
                    name
                    description
                    provider {
                      providerType
                    }
                  }
                  state
                  deviceExecution {
                    id
                    device {
                      id
                      hostname
                      platform {
                        id
                        name
                      }
                    }
                    runOn
                    executeOn
                    state
                    result
                    do
                    exception
                    done
                    changed
                    log
                  }
                  executionResults {
                    devicegroupexecutionresult {
                      group {
                        name
                      }
                      granularity
                      message
                      state
                    }
                    deviceexecutionresult {
                      device {
                        hostname
                      }
                      granularity
                      message
                      state
                    }
                    clientexecutionresult {
                      client {
                        macaddress
                      }
                      granularity
                      message
                      state
                    }
                    interfaceexecutionresult {
                      interface {
                        name
                      }
                      granularity
                      message
                      state
                    }
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query, operation_name="execution", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Execution.model_validate(data)

    async def execution_subscription(
        self, **kwargs: Any
    ) -> AsyncIterator[ExecutionSubscription]:
        query = gql(
            """
            subscription executionSubscription {
              executionSubscription {
                execution {
                  id
                  taskId
                  name
                  createdAt
                  updatedAt
                  state
                  executionType
                  args
                  do
                  done
                  log
                  process {
                    id
                    name
                  }
                  neopsTask {
                    id
                    name
                    description
                    provider {
                      providerType
                    }
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        async for data in self.execute_ws(
            query=query,
            operation_name="executionSubscription",
            variables=variables,
            **kwargs
        ):
            yield ExecutionSubscription.model_validate(data)

    async def executions_detail(
        self,
        execution_type: Union[Optional[ExecutionTypeEnum], UnsetType] = UNSET,
        page: Union[Optional[int], UnsetType] = UNSET,
        page_size: Union[Optional[int], UnsetType] = UNSET,
        ordering: Union[Optional[str], UnsetType] = UNSET,
        state: Union[Optional[str], UnsetType] = UNSET,
        check_id: Union[Optional[Any], UnsetType] = UNSET,
        user_id: Union[Optional[str], UnsetType] = UNSET,
        user_username: Union[Optional[str], UnsetType] = UNSET,
        neops_task: Union[Optional[str], UnsetType] = UNSET,
        neops_task_uniquetaskname: Union[Optional[str], UnsetType] = UNSET,
        updated_at_gt: Union[Optional[Any], UnsetType] = UNSET,
        created_at_gt: Union[Optional[Any], UnsetType] = UNSET,
        **kwargs: Any
    ) -> ExecutionsDetail:
        query = gql(
            """
            query executionsDetail($executionType: ExecutionTypeEnum, $page: Int, $pageSize: Int = 20, $ordering: String = "name", $state: String, $checkId: Decimal, $user_Id: ID, $user_Username: String, $neopsTask: ID, $neopsTask_Uniquetaskname: String, $updatedAt_Gt: CustomDateTime, $createdAt_Gt: CustomDateTime) {
              executions(
                states: $state
                process_Isnull: false
                executionType: $executionType
                checkId: $checkId
                user_Id: $user_Id
                user_Username: $user_Username
                neopsTask: $neopsTask
                neopsTask_Uniquetaskname: $neopsTask_Uniquetaskname
                updatedAt_Gt: $updatedAt_Gt
                createdAt_Gt: $createdAt_Gt
              ) {
                totalCount
                results(page: $page, pageSize: $pageSize, ordering: $ordering) {
                  id
                  taskId
                  name
                  executionType
                  createdAt
                  updatedAt
                  state
                  user {
                    username
                    lastName
                    firstName
                    email
                    id
                  }
                  process {
                    name
                    id
                  }
                  neopsTask {
                    id
                    name
                    description
                    provider {
                      providerType
                    }
                  }
                  executionResults {
                    devicegroupexecutionresult {
                      group {
                        name
                      }
                      granularity
                      message
                      state
                    }
                    deviceexecutionresult {
                      device {
                        hostname
                      }
                      granularity
                      message
                      state
                    }
                    clientexecutionresult {
                      client {
                        macaddress
                      }
                      granularity
                      message
                      state
                    }
                    interfaceexecutionresult {
                      interface {
                        name
                      }
                      granularity
                      message
                      state
                    }
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "executionType": execution_type,
            "page": page,
            "pageSize": page_size,
            "ordering": ordering,
            "state": state,
            "checkId": check_id,
            "user_Id": user_id,
            "user_Username": user_username,
            "neopsTask": neops_task,
            "neopsTask_Uniquetaskname": neops_task_uniquetaskname,
            "updatedAt_Gt": updated_at_gt,
            "createdAt_Gt": created_at_gt,
        }
        response = await self.execute(
            query=query,
            operation_name="executionsDetail",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ExecutionsDetail.model_validate(data)

    async def executions_elastic(
        self,
        query: Union[Optional[str], UnsetType] = UNSET,
        page: Union[Optional[int], UnsetType] = UNSET,
        page_size: Union[Optional[int], UnsetType] = UNSET,
        id: Union[Optional[str], UnsetType] = UNSET,
        ordering: Union[Optional[str], UnsetType] = UNSET,
        permission: Union[Optional[str], UnsetType] = UNSET,
        scope: Union[Optional[Any], UnsetType] = UNSET,
        **kwargs: Any
    ) -> ExecutionsElastic:
        _query = gql(
            """
            query executionsElastic($query: String = "", $page: Int = 1, $pageSize: Int = 20, $id: ID, $ordering: String = "id", $permission: String, $scope: Decimal) {
              executionsElastic(
                query: $query
                queryTypeGlobal: true
                id: $id
                permission: $permission
                scope: $scope
              ) {
                totalCount
                results(page: $page, pageSize: $pageSize, ordering: $ordering) {
                  id
                  taskId
                  name
                  executionType
                  createdAt
                  updatedAt
                  user {
                    username
                    lastName
                    firstName
                    email
                  }
                  process {
                    name
                    id
                  }
                  neopsTask {
                    id
                    name
                    description
                    provider {
                      providerType
                    }
                  }
                  state
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "query": query,
            "page": page,
            "pageSize": page_size,
            "id": id,
            "ordering": ordering,
            "permission": permission,
            "scope": scope,
        }
        response = await self.execute(
            query=_query,
            operation_name="executionsElastic",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ExecutionsElastic.model_validate(data)

    async def executions_simple(
        self,
        execution_type: Union[Optional[ExecutionTypeEnum], UnsetType] = UNSET,
        page: Union[Optional[int], UnsetType] = UNSET,
        page_size: Union[Optional[int], UnsetType] = UNSET,
        ordering: Union[Optional[str], UnsetType] = UNSET,
        state: Union[Optional[str], UnsetType] = UNSET,
        check_id: Union[Optional[Any], UnsetType] = UNSET,
        user_id: Union[Optional[str], UnsetType] = UNSET,
        user_username: Union[Optional[str], UnsetType] = UNSET,
        neops_task: Union[Optional[str], UnsetType] = UNSET,
        neops_task_uniquetaskname: Union[Optional[str], UnsetType] = UNSET,
        updated_at_gt: Union[Optional[Any], UnsetType] = UNSET,
        created_at_gt: Union[Optional[Any], UnsetType] = UNSET,
        updated_at_lt: Union[Optional[Any], UnsetType] = UNSET,
        created_at_lt: Union[Optional[Any], UnsetType] = UNSET,
        **kwargs: Any
    ) -> ExecutionsSimple:
        query = gql(
            """
            query executionsSimple($executionType: ExecutionTypeEnum, $page: Int, $pageSize: Int = 20, $ordering: String = "name", $state: String, $checkId: Decimal, $user_Id: ID, $user_Username: String, $neopsTask: ID, $neopsTask_Uniquetaskname: String, $updatedAt_Gt: CustomDateTime, $createdAt_Gt: CustomDateTime, $updatedAt_Lt: CustomDateTime, $createdAt_Lt: CustomDateTime) {
              executions(
                states: $state
                process_Isnull: false
                executionType: $executionType
                checkId: $checkId
                user_Id: $user_Id
                user_Username: $user_Username
                neopsTask: $neopsTask
                neopsTask_Uniquetaskname: $neopsTask_Uniquetaskname
                updatedAt_Gt: $updatedAt_Gt
                createdAt_Gt: $createdAt_Gt
                updatedAt_Lt: $updatedAt_Lt
                createdAt_Lt: $createdAt_Lt
              ) {
                totalCount
                results(page: $page, pageSize: $pageSize, ordering: $ordering) {
                  id
                  taskId
                  name
                  executionType
                  createdAt
                  updatedAt
                  state
                  user {
                    username
                    lastName
                    firstName
                    email
                    id
                  }
                  process {
                    name
                    id
                  }
                  neopsTask {
                    id
                    name
                    description
                    provider {
                      providerType
                    }
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "executionType": execution_type,
            "page": page,
            "pageSize": page_size,
            "ordering": ordering,
            "state": state,
            "checkId": check_id,
            "user_Id": user_id,
            "user_Username": user_username,
            "neopsTask": neops_task,
            "neopsTask_Uniquetaskname": neops_task_uniquetaskname,
            "updatedAt_Gt": updated_at_gt,
            "createdAt_Gt": created_at_gt,
            "updatedAt_Lt": updated_at_lt,
            "createdAt_Lt": created_at_lt,
        }
        response = await self.execute(
            query=query,
            operation_name="executionsSimple",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ExecutionsSimple.model_validate(data)

    async def get_role(
        self, name: Union[Optional[str], UnsetType] = UNSET, **kwargs: Any
    ) -> GetRole:
        query = gql(
            """
            query getRole($name: String) {
              role(name: $name) {
                results {
                  id
                  name
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"name": name}
        response = await self.execute(
            query=query, operation_name="getRole", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetRole.model_validate(data)

    async def get_and_lock_resources(
        self,
        reference: str,
        device_group_ids: Union[Optional[List[Optional[str]]], UnsetType] = UNSET,
        device_ids: Union[Optional[List[Optional[str]]], UnsetType] = UNSET,
        **kwargs: Any
    ) -> GetAndLockResources:
        query = gql(
            """
            mutation getAndLockResources($reference: String!, $deviceGroupIds: [ID], $deviceIds: [ID]) {
              getAndLockResources(
                reference: $reference
                deviceGroupIds: $deviceGroupIds
                deviceIds: $deviceIds
              ) {
                devices {
                  id
                  createdAt
                  updatedAt
                  hostname
                  ip
                  connectionState
                  facts
                  softwareRelease
                  platform {
                    id
                    name
                    shortName
                  }
                  vendor
                  model
                  serial
                  username
                  currentConfiguration
                  groups {
                    id
                    name
                  }
                  checks
                  groupCount
                  interfaceCount
                }
                deviceGroups {
                  id
                  name
                  devices {
                    id
                  }
                  title
                  description
                  location {
                    id
                    address
                    city
                    lon
                    lat
                  }
                  deviceCount
                  checks
                  facts
                }
                lock {
                  id
                  owner
                  reference
                  expiresAt
                  createdAt
                  updatedAt
                }
                lockAlreadyExisted
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "reference": reference,
            "deviceGroupIds": device_group_ids,
            "deviceIds": device_ids,
        }
        response = await self.execute(
            query=query,
            operation_name="getAndLockResources",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetAndLockResources.model_validate(data)

    async def group_aggregation(
        self,
        aggr_field: str,
        query: Union[Optional[str], UnsetType] = UNSET,
        size: Union[Optional[int], UnsetType] = UNSET,
        scope: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> GroupAggregation:
        _query = gql(
            """
            query groupAggregation($aggrField: String!, $query: String, $size: Int, $scope: Int) {
              groupAggregation(
                aggrField: $aggrField
                query: $query
                queryTypeGlobal: true
                size: $size
                scope: $scope
              ) {
                results {
                  value
                  count
                }
                countAggregatedElements
                count
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "aggrField": aggr_field,
            "query": query,
            "size": size,
            "scope": scope,
        }
        response = await self.execute(
            query=_query,
            operation_name="groupAggregation",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GroupAggregation.model_validate(data)

    async def interface_aggregation(
        self,
        aggr_field: str,
        query: Union[Optional[str], UnsetType] = UNSET,
        size: Union[Optional[int], UnsetType] = UNSET,
        scope: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> InterfaceAggregation:
        _query = gql(
            """
            query interfaceAggregation($aggrField: String!, $query: String, $size: Int, $scope: Int) {
              interfaceAggregation(
                aggrField: $aggrField
                query: $query
                queryTypeGlobal: true
                size: $size
                scope: $scope
              ) {
                results {
                  value
                  count
                }
                countAggregatedElements
                count
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "aggrField": aggr_field,
            "query": query,
            "size": size,
            "scope": scope,
        }
        response = await self.execute(
            query=_query,
            operation_name="interfaceAggregation",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return InterfaceAggregation.model_validate(data)

    async def interfaces(
        self,
        query: Union[Optional[str], UnsetType] = UNSET,
        page: Union[Optional[int], UnsetType] = UNSET,
        page_size: Union[Optional[int], UnsetType] = UNSET,
        ordering: Union[Optional[str], UnsetType] = UNSET,
        scope: Union[Optional[Any], UnsetType] = UNSET,
        id: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> Interfaces:
        _query = gql(
            """
            query interfaces($query: String, $page: Int, $pageSize: Int, $ordering: String = "device__hostname,name_sorting", $scope: Decimal, $id: ID) {
              interfacesElastic(query: $query, queryTypeGlobal: true, scope: $scope, id: $id) {
                totalCount
                results(page: $page, pageSize: $pageSize, ordering: $ordering) {
                  id
                  createdAt
                  updatedAt
                  name
                  description
                  state
                  facts
                  currentConfiguration
                  interface {
                    id
                  }
                  device {
                    id
                    hostname
                    ip
                  }
                  checks
                  clientCount
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "query": query,
            "page": page,
            "pageSize": page_size,
            "ordering": ordering,
            "scope": scope,
            "id": id,
        }
        response = await self.execute(
            query=_query, operation_name="interfaces", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Interfaces.model_validate(data)

    async def jinja_render(
        self,
        template: Union[Optional[str], UnsetType] = UNSET,
        template_vars: Union[Optional[Any], UnsetType] = UNSET,
        facts_for_element_id: Union[Optional[str], UnsetType] = UNSET,
        facts_for_element_type: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> JinjaRender:
        query = gql(
            """
            mutation jinjaRender($template: String, $templateVars: JSONString, $factsForElementId: ID, $factsForElementType: String) {
              jinjaRender(
                template: $template
                jsonVars: $templateVars
                factsForElementId: $factsForElementId
                factsForElementType: $factsForElementType
              ) {
                renderedTemplate
                error
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "template": template,
            "templateVars": template_vars,
            "factsForElementId": facts_for_element_id,
            "factsForElementType": facts_for_element_type,
        }
        response = await self.execute(
            query=query, operation_name="jinjaRender", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return JinjaRender.model_validate(data)

    async def location_upsert(
        self,
        id: Union[Optional[str], UnsetType] = UNSET,
        name: Union[Optional[str], UnsetType] = UNSET,
        devices: Union[Optional[List[Optional[str]]], UnsetType] = UNSET,
        description: Union[Optional[str], UnsetType] = UNSET,
        title: Union[Optional[str], UnsetType] = UNSET,
        address: Union[Optional[str], UnsetType] = UNSET,
        zip_code: Union[Optional[str], UnsetType] = UNSET,
        city: Union[Optional[str], UnsetType] = UNSET,
        country: Union[Optional[str], UnsetType] = UNSET,
        lat: Union[Optional[Any], UnsetType] = UNSET,
        lon: Union[Optional[Any], UnsetType] = UNSET,
        **kwargs: Any
    ) -> LocationUpsert:
        query = gql(
            """
            mutation locationUpsert($id: ID, $name: String, $devices: [ID], $description: String, $title: String, $address: String, $zipCode: String, $city: String, $country: String, $lat: Decimal, $lon: Decimal) {
              locationUpsert(
                id: $id
                name: $name
                devices: $devices
                description: $description
                address: $address
                zipCode: $zipCode
                city: $city
                title: $title
                country: $country
                lat: $lat
                lon: $lon
              ) {
                location {
                  id
                  name
                  title
                  description
                  address
                  zipCode
                  city
                  country
                  devices {
                    id
                    hostname
                    ip
                  }
                  lon
                  lat
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "id": id,
            "name": name,
            "devices": devices,
            "description": description,
            "title": title,
            "address": address,
            "zipCode": zip_code,
            "city": city,
            "country": country,
            "lat": lat,
            "lon": lon,
        }
        response = await self.execute(
            query=query, operation_name="locationUpsert", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return LocationUpsert.model_validate(data)

    async def login(
        self,
        username: Union[Optional[str], UnsetType] = UNSET,
        password: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> Login:
        query = gql(
            """
            mutation login($username: String, $password: String) {
              login(username: $username, password: $password) {
                accessToken
                refreshToken
                roles
                user {
                  id
                  email
                  username
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"username": username, "password": password}
        response = await self.execute(
            query=query, operation_name="login", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Login.model_validate(data)

    async def reports_execute(
        self,
        id: Union[Optional[str], UnsetType] = UNSET,
        uniquereportname: Union[Optional[str], UnsetType] = UNSET,
        execute_on: Union[Optional[List[Optional[str]]], UnsetType] = UNSET,
        execute_on_type: Union[Optional[RunOnEnum], UnsetType] = UNSET,
        search_query: Union[Optional[str], UnsetType] = UNSET,
        scope: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> ReportsExecute:
        query = gql(
            """
            mutation reportsExecute($id: ID, $uniquereportname: String, $executeOn: [ID], $executeOnType: RunOnEnum, $searchQuery: String, $scope: Int) {
              reportsExecute(
                id: $id
                uniquereportname: $uniquereportname
                executeOn: $executeOn
                executeOnType: $executeOnType
                searchQuery: $searchQuery
                scope: $scope
              ) {
                reportExecution {
                  contentBase64
                  extension
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "id": id,
            "uniquereportname": uniquereportname,
            "executeOn": execute_on,
            "executeOnType": execute_on_type,
            "searchQuery": search_query,
            "scope": scope,
        }
        response = await self.execute(
            query=query, operation_name="reportsExecute", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return ReportsExecute.model_validate(data)

    async def neops_task_unarchive(self, id: str, **kwargs: Any) -> NeopsTaskUnarchive:
        query = gql(
            """
            mutation neopsTaskUnarchive($id: ID!) {
              neopsTaskUpsert(id: $id, unarchive: true) {
                neopsTask {
                  id
                  name
                  deletedAt
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query,
            operation_name="neopsTaskUnarchive",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return NeopsTaskUnarchive.model_validate(data)

    async def neops_task_create_mutation(
        self,
        id: Union[Optional[str], UnsetType] = UNSET,
        description: Union[Optional[str], UnsetType] = UNSET,
        name: Union[Optional[str], UnsetType] = UNSET,
        provider_identifier: Union[Optional[str], UnsetType] = UNSET,
        task_kwargs: Union[Optional[str], UnsetType] = UNSET,
        task_run_input_schema: Union[Optional[str], UnsetType] = UNSET,
        task_run_filter: Union[Optional[str], UnsetType] = UNSET,
        pre_run_tasks: Union[Optional[List[Optional[str]]], UnsetType] = UNSET,
        post_run_tasks: Union[Optional[List[Optional[str]]], UnsetType] = UNSET,
        uniquetaskname: Union[Optional[str], UnsetType] = UNSET,
        scope_id: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> NeopsTaskCreateMutation:
        query = gql(
            """
            mutation neopsTaskCreateMutation($id: ID, $description: String, $name: String, $providerIdentifier: String, $taskKwargs: String, $taskRunInputSchema: String, $taskRunFilter: String, $preRunTasks: [ID], $postRunTasks: [ID], $uniquetaskname: String, $scopeId: ID) {
              neopsTaskUpsert(
                id: $id
                description: $description
                name: $name
                providerIdentifier: $providerIdentifier
                taskKwargs: $taskKwargs
                taskRunInputSchema: $taskRunInputSchema
                taskRunFilter: $taskRunFilter
                preRunTasks: $preRunTasks
                postRunTasks: $postRunTasks
                uniquetaskname: $uniquetaskname
                scopeId: $scopeId
              ) {
                neopsTask {
                  id
                  name
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "id": id,
            "description": description,
            "name": name,
            "providerIdentifier": provider_identifier,
            "taskKwargs": task_kwargs,
            "taskRunInputSchema": task_run_input_schema,
            "taskRunFilter": task_run_filter,
            "preRunTasks": pre_run_tasks,
            "postRunTasks": post_run_tasks,
            "uniquetaskname": uniquetaskname,
            "scopeId": scope_id,
        }
        response = await self.execute(
            query=query,
            operation_name="neopsTaskCreateMutation",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return NeopsTaskCreateMutation.model_validate(data)

    async def neops_tasks(
        self,
        id: Union[Optional[Any], UnsetType] = UNSET,
        permission: Union[Optional[str], UnsetType] = UNSET,
        scope: Union[Optional[Any], UnsetType] = UNSET,
        run_on: Union[Optional[str], UnsetType] = UNSET,
        unique_task_name_starts_with: Union[Optional[str], UnsetType] = UNSET,
        unique_task_name: Union[Optional[str], UnsetType] = UNSET,
        unique_task_name_i_contains: Union[Optional[str], UnsetType] = UNSET,
        unique_task_name_i_regex: Union[Optional[str], UnsetType] = UNSET,
        unique_task_name_regex: Union[Optional[str], UnsetType] = UNSET,
        provider_identifier_contains: Union[Optional[str], UnsetType] = UNSET,
        provider_identifier: Union[Optional[str], UnsetType] = UNSET,
        show_archived_only: Union[Optional[bool], UnsetType] = UNSET,
        show_archived: Union[Optional[bool], UnsetType] = UNSET,
        ordering: Union[Optional[str], UnsetType] = UNSET,
        page: Union[Optional[int], UnsetType] = UNSET,
        page_size: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> NeopsTasks:
        query = gql(
            """
            query neopsTasks($id: Decimal, $permission: String = "read", $scope: Decimal, $runOn: String, $uniqueTaskNameStartsWith: String, $uniqueTaskName: String, $uniqueTaskNameIContains: String, $uniqueTaskNameIRegex: String, $uniqueTaskNameRegex: String, $providerIdentifierContains: String, $providerIdentifier: String, $showArchivedOnly: Boolean = false, $showArchived: Boolean = false, $ordering: String = "name", $page: Int = 1, $pageSize: Int = 999) {
              neopsTasks(
                id: $id
                permission: $permission
                scope: $scope
                runOn: $runOn
                uniquetaskname_Istartswith: $uniqueTaskNameStartsWith
                uniquetaskname: $uniqueTaskName
                uniquetaskname_Icontains: $uniqueTaskNameIContains
                uniquetaskname_Iregex: $uniqueTaskNameIRegex
                uniquetaskname_Regex: $uniqueTaskNameRegex
                providerIdentifier: $providerIdentifier
                providerIdentifier_Icontains: $providerIdentifierContains
                showArchived: $showArchived
                showArchivedOnly: $showArchivedOnly
              ) {
                results(page: $page, pageSize: $pageSize, ordering: $ordering) {
                  id
                  name
                  description
                  uniquetaskname
                  providerIdentifier
                  runOn
                  runOnStrict
                  isCheck
                  isTask
                  provider {
                    name
                    jsonSchema
                    shortDescription
                    deprecated
                    description
                  }
                  taskKwargs
                  taskRunInputSchema
                  taskRunFilter
                  preRunTasks {
                    id
                    name
                  }
                  postRunTasks {
                    id
                    name
                  }
                  createdAt
                  updatedAt
                  permission
                  isValid
                  isValidRecursive
                  ValidityInformation
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "id": id,
            "permission": permission,
            "scope": scope,
            "runOn": run_on,
            "uniqueTaskNameStartsWith": unique_task_name_starts_with,
            "uniqueTaskName": unique_task_name,
            "uniqueTaskNameIContains": unique_task_name_i_contains,
            "uniqueTaskNameIRegex": unique_task_name_i_regex,
            "uniqueTaskNameRegex": unique_task_name_regex,
            "providerIdentifierContains": provider_identifier_contains,
            "providerIdentifier": provider_identifier,
            "showArchivedOnly": show_archived_only,
            "showArchived": show_archived,
            "ordering": ordering,
            "page": page,
            "pageSize": page_size,
        }
        response = await self.execute(
            query=query, operation_name="neopsTasks", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return NeopsTasks.model_validate(data)

    async def permissions(self, **kwargs: Any) -> Permissions:
        query = gql(
            """
            query permissions {
              permissions {
                results {
                  name
                  description
                  defaultPermission
                  defaultPermissionFlags
                  permissionAllFlags
                  permission
                  permissionFlags
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query, operation_name="permissions", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Permissions.model_validate(data)

    async def platforms(
        self, scope: Union[Optional[Any], UnsetType] = UNSET, **kwargs: Any
    ) -> Platforms:
        query = gql(
            """
            query platforms($scope: Decimal) {
              platforms(scope: $scope) {
                results {
                  id
                  name
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"scope": scope}
        response = await self.execute(
            query=query, operation_name="platforms", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Platforms.model_validate(data)

    async def process_overview(
        self,
        process_id: Union[Optional[Any], UnsetType] = UNSET,
        scope: Union[Optional[Any], UnsetType] = UNSET,
        **kwargs: Any
    ) -> ProcessOverview:
        query = gql(
            """
            query processOverview($processId: Decimal, $scope: Decimal) {
              processExecutions(id: $processId, scope: $scope) {
                results {
                  id
                  name
                  executions {
                    id
                    name
                    state
                    executionType
                    task
                    createdAt
                    updatedAt
                    args
                    do
                    done
                    log
                    executionResults {
                      id
                      state
                      message
                    }
                    neopsTask {
                      id
                      name
                      description
                      provider {
                        providerType
                      }
                    }
                    deviceExecution {
                      id
                      state
                      createdAt
                      updatedAt
                      changed
                      willChange
                      runOn
                      executeOn
                      device {
                        id
                        ip
                        hostname
                        vendor
                        model
                        platform {
                          id
                          name
                        }
                        softwareRelease
                      }
                    }
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"processId": process_id, "scope": scope}
        response = await self.execute(
            query=query, operation_name="processOverview", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return ProcessOverview.model_validate(data)

    async def neops_provider(
        self, name: Union[Optional[str], UnsetType] = UNSET, **kwargs: Any
    ) -> NeopsProvider:
        query = gql(
            """
            query neopsProvider($name: String) {
              neopsTaskProvider(name: $name) {
                results {
                  name
                  description
                  runOn
                  runOnStrict
                  runOnAllIfEmpty
                  providerType
                  jsonSchema
                  module
                  shortDescription
                  deprecated
                  fullQualifiedName
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"name": name}
        response = await self.execute(
            query=query, operation_name="neopsProvider", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return NeopsProvider.model_validate(data)

    async def providers(self, **kwargs: Any) -> Providers:
        query = gql(
            """
            query providers {
              neopsTaskProvider {
                results {
                  name
                  description
                  runOn
                  runOnStrict
                  runOnAllIfEmpty
                  providerType
                  fullQualifiedName
                  jsonSchema
                  module
                  shortDescription
                  deprecated
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query, operation_name="providers", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Providers.model_validate(data)

    async def reports(
        self,
        scope: Union[Optional[Any], UnsetType] = UNSET,
        type: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> Reports:
        query = gql(
            """
            query reports($scope: Decimal, $type: String) {
              reports(scope: $scope, type: $type) {
                results {
                  id
                  name
                  extension
                  uniquereportname
                  jinjaTemplate
                  entityType
                  scope {
                    id
                    name
                  }
                  permission
                  updatedAt
                  createdAt
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"scope": scope, "type": type}
        response = await self.execute(
            query=query, operation_name="reports", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Reports.model_validate(data)

    async def refresh_token(
        self, refresh_token: Union[Optional[str], UnsetType] = UNSET, **kwargs: Any
    ) -> RefreshToken:
        query = gql(
            """
            mutation refreshToken($refreshToken: String) {
              refreshToken(refreshToken: $refreshToken) {
                accessToken
                refreshToken
              }
            }
            """
        )
        variables: Dict[str, object] = {"refreshToken": refresh_token}
        response = await self.execute(
            query=query, operation_name="refreshToken", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return RefreshToken.model_validate(data)

    async def role_device_group(self, **kwargs: Any) -> RoleDeviceGroup:
        query = gql(
            """
            query roleDeviceGroup {
              roleDeviceGroup {
                results {
                  id
                  role {
                    id
                    name
                  }
                  deviceGroup {
                    id
                    name
                  }
                  permission
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query, operation_name="roleDeviceGroup", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return RoleDeviceGroup.model_validate(data)

    async def role_device_group_upsert(
        self,
        role_id: Union[Optional[str], UnsetType] = UNSET,
        device_group_id: Union[Optional[str], UnsetType] = UNSET,
        permission: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> RoleDeviceGroupUpsert:
        query = gql(
            """
            mutation roleDeviceGroupUpsert($roleId: ID, $deviceGroupId: ID, $permission: Int) {
              roleDeviceGroupUpsert(
                roleId: $roleId
                deviceGroupId: $deviceGroupId
                permission: $permission
              ) {
                roleDeviceGroup {
                  id
                  permissionFlags
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "roleId": role_id,
            "deviceGroupId": device_group_id,
            "permission": permission,
        }
        response = await self.execute(
            query=query,
            operation_name="roleDeviceGroupUpsert",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return RoleDeviceGroupUpsert.model_validate(data)

    async def role_neops_task(self, **kwargs: Any) -> RoleNeopsTask:
        query = gql(
            """
            query roleNeopsTask {
              roleNeopsTask {
                results {
                  id
                  role {
                    id
                    name
                  }
                  neopsTask {
                    id
                    name
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query, operation_name="roleNeopsTask", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return RoleNeopsTask.model_validate(data)

    async def role_neops_task_upsert(
        self,
        role_id: Union[Optional[str], UnsetType] = UNSET,
        neops_task_id: Union[Optional[str], UnsetType] = UNSET,
        permission: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> RoleNeopsTaskUpsert:
        query = gql(
            """
            mutation roleNeopsTaskUpsert($roleId: ID, $neopsTaskId: ID, $permission: Int) {
              roleNeopsTaskUpsert(
                roleId: $roleId
                neopsTaskId: $neopsTaskId
                permission: $permission
              ) {
                roleNeopsTask {
                  id
                  permissionFlags
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "roleId": role_id,
            "neopsTaskId": neops_task_id,
            "permission": permission,
        }
        response = await self.execute(
            query=query,
            operation_name="roleNeopsTaskUpsert",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return RoleNeopsTaskUpsert.model_validate(data)

    async def role_permission_element(self, **kwargs: Any) -> RolePermissionElement:
        query = gql(
            """
            query rolePermissionElement {
              rolePermissionElement {
                results {
                  id
                  permissionElement {
                    id
                    name
                    description
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query,
            operation_name="rolePermissionElement",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return RolePermissionElement.model_validate(data)

    async def role_permission_element_upsert(
        self,
        role_id: Union[Optional[str], UnsetType] = UNSET,
        permission_element_id: Union[Optional[str], UnsetType] = UNSET,
        permission: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> RolePermissionElementUpsert:
        query = gql(
            """
            mutation rolePermissionElementUpsert($roleId: ID, $permissionElementId: ID, $permission: Int) {
              rolePermissionElementUpsert(
                roleId: $roleId
                permissionElementId: $permissionElementId
                permission: $permission
              ) {
                rolePermissionElement {
                  id
                  permissionFlags
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "roleId": role_id,
            "permissionElementId": permission_element_id,
            "permission": permission,
        }
        response = await self.execute(
            query=query,
            operation_name="rolePermissionElementUpsert",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return RolePermissionElementUpsert.model_validate(data)

    async def role_permission_upsert(
        self,
        id: Union[Optional[str], UnsetType] = UNSET,
        default_permission: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> RolePermissionUpsert:
        query = gql(
            """
            mutation rolePermissionUpsert($id: ID, $defaultPermission: Int) {
              rolePermissionUpsert(id: $id, defaultPermission: $defaultPermission) {
                rolePermission {
                  id
                  defaultPermissionFlags
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "id": id,
            "defaultPermission": default_permission,
        }
        response = await self.execute(
            query=query,
            operation_name="rolePermissionUpsert",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return RolePermissionUpsert.model_validate(data)

    async def role_permissions(self, **kwargs: Any) -> RolePermissions:
        query = gql(
            """
            query rolePermissions {
              rolePermission {
                results {
                  id
                  name
                  defaultPermission
                  defaultPermissionFlags
                  permissionAllFlags
                  permissionElementPermissionsAll {
                    permissionFlags
                    permissionAllFlags
                    permissionElement {
                      id
                      name
                      description
                    }
                    role {
                      id
                      name
                    }
                  }
                  deviceGroupPermissionsAll {
                    permissionFlags
                    permissionAllFlags
                    role {
                      id
                      name
                    }
                    deviceGroup {
                      id
                      name
                      description
                    }
                  }
                  neopsTaskPermissionsAll {
                    permissionFlags
                    permissionAllFlags
                    role {
                      id
                      name
                    }
                    neopsTask {
                      id
                      name
                      description
                    }
                  }
                  scopePermissionsAll {
                    permissionFlags
                    permissionAllFlags
                    role {
                      id
                      name
                    }
                    scope {
                      id
                      name
                      description
                    }
                  }
                  users {
                    id
                    username
                    lastName
                    firstName
                    email
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query, operation_name="rolePermissions", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return RolePermissions.model_validate(data)

    async def role_scope_upsert(
        self,
        role_id: Union[Optional[str], UnsetType] = UNSET,
        scope_id: Union[Optional[str], UnsetType] = UNSET,
        permission: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> RoleScopeUpsert:
        query = gql(
            """
            mutation roleScopeUpsert($roleId: ID, $scopeId: ID, $permission: Int) {
              roleScopeUpsert(roleId: $roleId, scopeId: $scopeId, permission: $permission) {
                roleScope {
                  id
                  permissionFlags
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "roleId": role_id,
            "scopeId": scope_id,
            "permission": permission,
        }
        response = await self.execute(
            query=query, operation_name="roleScopeUpsert", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return RoleScopeUpsert.model_validate(data)

    async def role_user(self, **kwargs: Any) -> RoleUser:
        query = gql(
            """
            query roleUser {
              role(myRolesOnly: true) {
                results {
                  id
                  name
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query, operation_name="roleUser", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return RoleUser.model_validate(data)

    async def rollback(
        self, configuration_id: str, device_id: str, **kwargs: Any
    ) -> Rollback:
        query = gql(
            """
            mutation rollback($configurationId: ID!, $deviceId: ID!) {
              deviceRollback(configurationId: $configurationId, deviceId: $deviceId) {
                execution {
                  id
                  taskId
                  state
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "configurationId": configuration_id,
            "deviceId": device_id,
        }
        response = await self.execute(
            query=query, operation_name="rollback", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Rollback.model_validate(data)

    async def saved_search_create(
        self, name: str, description: str, search: str, **kwargs: Any
    ) -> SavedSearchCreate:
        query = gql(
            """
            mutation savedSearchCreate($name: String!, $description: String!, $search: String!) {
              savedSearchCreate(name: $name, description: $description, search: $search) {
                savedSearch {
                  id
                  name
                  description
                  search
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "name": name,
            "description": description,
            "search": search,
        }
        response = await self.execute(
            query=query,
            operation_name="savedSearchCreate",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return SavedSearchCreate.model_validate(data)

    async def saved_search_delete(self, id: str, **kwargs: Any) -> SavedSearchDelete:
        query = gql(
            """
            mutation savedSearchDelete($id: ID!) {
              savedSearchDelete(id: $id) {
                savedSearch {
                  id
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query,
            operation_name="savedSearchDelete",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return SavedSearchDelete.model_validate(data)

    async def saved_searches(
        self, scope: Union[Optional[Any], UnsetType] = UNSET, **kwargs: Any
    ) -> SavedSearches:
        query = gql(
            """
            query savedSearches($scope: Decimal) {
              savedSearches(scope: $scope) {
                results {
                  id
                  name
                  description
                  search
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"scope": scope}
        response = await self.execute(
            query=query, operation_name="savedSearches", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return SavedSearches.model_validate(data)

    async def scope_delete(self, id: str, **kwargs: Any) -> ScopeDelete:
        query = gql(
            """
            mutation scopeDelete($id: ID!) {
              scopeDelete(id: $id) {
                scope {
                  id
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query, operation_name="scopeDelete", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return ScopeDelete.model_validate(data)

    async def scopes_upsert(
        self,
        clientcolumns: Union[Optional[str], UnsetType] = UNSET,
        clientfilter: Union[Optional[str], UnsetType] = UNSET,
        description: Union[Optional[str], UnsetType] = UNSET,
        devicecolumns: Union[Optional[str], UnsetType] = UNSET,
        devicefilter: Union[Optional[str], UnsetType] = UNSET,
        groupcolumns: Union[Optional[str], UnsetType] = UNSET,
        groupfilter: Union[Optional[str], UnsetType] = UNSET,
        id: Union[Optional[str], UnsetType] = UNSET,
        interfacecolumns: Union[Optional[str], UnsetType] = UNSET,
        interfacefilter: Union[Optional[str], UnsetType] = UNSET,
        name: Union[Optional[str], UnsetType] = UNSET,
        show_clients: Union[Optional[bool], UnsetType] = UNSET,
        show_devices: Union[Optional[bool], UnsetType] = UNSET,
        show_groups: Union[Optional[bool], UnsetType] = UNSET,
        show_interfaces: Union[Optional[bool], UnsetType] = UNSET,
        show_topology: Union[Optional[bool], UnsetType] = UNSET,
        tasks: Union[Optional[List[Optional[str]]], UnsetType] = UNSET,
        **kwargs: Any
    ) -> ScopesUpsert:
        query = gql(
            """
            mutation scopesUpsert($clientcolumns: String, $clientfilter: String, $description: String, $devicecolumns: String, $devicefilter: String, $groupcolumns: String, $groupfilter: String, $id: ID, $interfacecolumns: String, $interfacefilter: String, $name: String, $showClients: Boolean, $showDevices: Boolean, $showGroups: Boolean, $showInterfaces: Boolean, $showTopology: Boolean, $tasks: [ID]) {
              scopesUpsert(
                clientcolumns: $clientcolumns
                clientfilter: $clientfilter
                description: $description
                devicecolumns: $devicecolumns
                devicefilter: $devicefilter
                groupcolumns: $groupcolumns
                groupfilter: $groupfilter
                id: $id
                interfacecolumns: $interfacecolumns
                interfacefilter: $interfacefilter
                name: $name
                showClients: $showClients
                showDevices: $showDevices
                showGroups: $showGroups
                showInterfaces: $showInterfaces
                showTopology: $showTopology
                tasks: $tasks
              ) {
                scope {
                  id
                  name
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "clientcolumns": clientcolumns,
            "clientfilter": clientfilter,
            "description": description,
            "devicecolumns": devicecolumns,
            "devicefilter": devicefilter,
            "groupcolumns": groupcolumns,
            "groupfilter": groupfilter,
            "id": id,
            "interfacecolumns": interfacecolumns,
            "interfacefilter": interfacefilter,
            "name": name,
            "showClients": show_clients,
            "showDevices": show_devices,
            "showGroups": show_groups,
            "showInterfaces": show_interfaces,
            "showTopology": show_topology,
            "tasks": tasks,
        }
        response = await self.execute(
            query=query, operation_name="scopesUpsert", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return ScopesUpsert.model_validate(data)

    async def scopes(
        self, id: Union[Optional[Any], UnsetType] = UNSET, **kwargs: Any
    ) -> Scopes:
        query = gql(
            """
            query scopes($id: Decimal) {
              scopes(id: $id) {
                results {
                  id
                  name
                  allTasks
                  description
                  groupfilter
                  devicefilter
                  interfacefilter
                  clientfilter
                  groupcolumns
                  devicecolumns
                  interfacecolumns
                  clientcolumns
                  showClients
                  showDevices
                  showGroups
                  locationDrillDownAttributeSchema
                  showInterfaces
                  showTopology
                  dashboardConfiguration
                  tasks {
                    id
                    name
                    isCheck
                    isTask
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query, operation_name="scopes", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Scopes.model_validate(data)

    async def single_discovery(
        self,
        execute_on: Union[Optional[List[Optional[str]]], UnsetType] = UNSET,
        **kwargs: Any
    ) -> SingleDiscovery:
        query = gql(
            """
            mutation singleDiscovery($executeOn: [ID]) {
              discovery(
                executeOn: $executeOn
                executeOnAll: false
                includeInterfaces: true
                recursive: false
              ) {
                execution {
                  id
                  taskId
                  state
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"executeOn": execute_on}
        response = await self.execute(
            query=query, operation_name="singleDiscovery", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return SingleDiscovery.model_validate(data)

    async def json_form(
        self,
        execute_on: Union[Optional[List[Optional[str]]], UnsetType] = UNSET,
        execute_on_type: Union[Optional[RunOnEnum], UnsetType] = UNSET,
        neops_task_id: Union[Optional[str], UnsetType] = UNSET,
        output_schema_type: Union[Optional[OutputSchemaTypeEnum], UnsetType] = UNSET,
        provider_full_qualified_name: Union[Optional[str], UnsetType] = UNSET,
        provider_schema: Union[Optional[ProviderSchemaEnum], UnsetType] = UNSET,
        resolve_all_elements: Union[Optional[bool], UnsetType] = UNSET,
        schema: Union[Optional[Any], UnsetType] = UNSET,
        search_query: Union[Optional[str], UnsetType] = UNSET,
        task_arguments: Union[Optional[Any], UnsetType] = UNSET,
        uniquetaskname: Union[Optional[str], UnsetType] = UNSET,
        scope: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> JsonForm:
        query = gql(
            """
            mutation jsonForm($executeOn: [ID], $executeOnType: RunOnEnum, $neopsTaskId: ID, $outputSchemaType: OutputSchemaTypeEnum, $providerFullQualifiedName: String, $providerSchema: ProviderSchemaEnum, $resolveAllElements: Boolean, $schema: JSONString, $searchQuery: String, $taskArguments: JSONString, $uniquetaskname: String, $scope: Int) {
              jsonForm(
                executeOn: $executeOn
                executeOnType: $executeOnType
                neopsTaskId: $neopsTaskId
                outputSchemaType: $outputSchemaType
                providerFullQualifiedName: $providerFullQualifiedName
                providerSchema: $providerSchema
                resolveAllElements: $resolveAllElements
                schema: $schema
                searchQuery: $searchQuery
                taskArguments: $taskArguments
                uniquetaskname: $uniquetaskname
                scope: $scope
              ) {
                jsonSchema
                data
                uiSchema
                baseSchema
                runOn
                devices {
                  id
                  hostname
                }
                groups {
                  id
                  name
                }
                interfaces {
                  id
                  name
                  device {
                    id
                    hostname
                  }
                }
                clients {
                  id
                  macaddress
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "executeOn": execute_on,
            "executeOnType": execute_on_type,
            "neopsTaskId": neops_task_id,
            "outputSchemaType": output_schema_type,
            "providerFullQualifiedName": provider_full_qualified_name,
            "providerSchema": provider_schema,
            "resolveAllElements": resolve_all_elements,
            "schema": schema,
            "searchQuery": search_query,
            "taskArguments": task_arguments,
            "uniquetaskname": uniquetaskname,
            "scope": scope,
        }
        response = await self.execute(
            query=query, operation_name="jsonForm", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return JsonForm.model_validate(data)

    async def text_fsm_render(
        self,
        template: Union[Optional[str], UnsetType] = UNSET,
        ntc_command: Union[Optional[str], UnsetType] = UNSET,
        ntc_platform: Union[Optional[str], UnsetType] = UNSET,
        command_output: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> TextFsmRender:
        query = gql(
            """
            mutation textFsmRender($template: String, $ntcCommand: String, $ntcPlatform: String, $commandOutput: String) {
              textFsmRender(
                template: $template
                ntcCommand: $ntcCommand
                ntcPlatform: $ntcPlatform
                commandOutput: $commandOutput
              ) {
                renderedTemplate
                error
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "template": template,
            "ntcCommand": ntc_command,
            "ntcPlatform": ntc_platform,
            "commandOutput": command_output,
        }
        response = await self.execute(
            query=query, operation_name="textFsmRender", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return TextFsmRender.model_validate(data)

    async def topology(
        self,
        query: Union[Optional[str], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        query_type_global: Union[Optional[bool], UnsetType] = UNSET,
        **kwargs: Any
    ) -> Topology:
        _query = gql(
            """
            query topology($query: String, $limit: Int, $queryTypeGlobal: Boolean = true) {
              topology(query: $query, limit: $limit, queryTypeGlobal: $queryTypeGlobal) {
                type
                metric
                version
                protocol
                nodes {
                  id
                  label
                  properties {
                    device {
                      id
                      hostname
                      ip
                    }
                  }
                }
                links {
                  source
                  target
                  cost
                  properties {
                    sourceInterface {
                      id
                      name
                      state
                    }
                    targetInterface {
                      id
                      name
                      state
                    }
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "query": query,
            "limit": limit,
            "queryTypeGlobal": query_type_global,
        }
        response = await self.execute(
            query=_query, operation_name="topology", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Topology.model_validate(data)

    async def unlock_resources(self, reference: str, **kwargs: Any) -> UnlockResources:
        query = gql(
            """
            mutation unlockResources($reference: String!) {
              unlockResources(reference: $reference) {
                success
              }
            }
            """
        )
        variables: Dict[str, object] = {"reference": reference}
        response = await self.execute(
            query=query, operation_name="unlockResources", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return UnlockResources.model_validate(data)
