"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Package gNMI defines a service specification for the gRPC Network Management
Interface. This interface is defined to be a standard interface via which
a network management system ("client") can subscribe to state values,
retrieve snapshots of state information, and manipulate the state of a data
tree supported by a device ("target").

This document references the gNMI Specification which can be found at
http://github.com/openconfig/reference/blob/master/rpc/gnmi
"""
import builtins
import collections.abc
import gnmi1.gnmi_ext_pb2
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.descriptor_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.internal.extension_dict
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _Encoding:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _EncodingEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Encoding.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    JSON: _Encoding.ValueType  # 0
    """JSON encoded text."""
    BYTES: _Encoding.ValueType  # 1
    """Arbitrarily encoded bytes."""
    PROTO: _Encoding.ValueType  # 2
    """Encoded according to scalar values of TypedValue."""
    ASCII: _Encoding.ValueType  # 3
    """ASCII text of an out-of-band agreed format."""
    JSON_IETF: _Encoding.ValueType  # 4
    """JSON encoded text as per RFC7951."""

class Encoding(_Encoding, metaclass=_EncodingEnumTypeWrapper):
    """Encoding defines the value encoding formats that are supported by the gNMI
    protocol. These encodings are used by both the client (when sending Set
    messages to modify the state of the target) and the target when serializing
    data to be returned to the client (in both Subscribe and Get RPCs).
    Reference: gNMI Specification Section 2.3
    """

JSON: Encoding.ValueType  # 0
"""JSON encoded text."""
BYTES: Encoding.ValueType  # 1
"""Arbitrarily encoded bytes."""
PROTO: Encoding.ValueType  # 2
"""Encoded according to scalar values of TypedValue."""
ASCII: Encoding.ValueType  # 3
"""ASCII text of an out-of-band agreed format."""
JSON_IETF: Encoding.ValueType  # 4
"""JSON encoded text as per RFC7951."""
global___Encoding = Encoding

class _SubscriptionMode:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SubscriptionModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SubscriptionMode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TARGET_DEFINED: _SubscriptionMode.ValueType  # 0
    """The target selects the relevant mode for each element."""
    ON_CHANGE: _SubscriptionMode.ValueType  # 1
    """The target sends an update on element value change."""
    SAMPLE: _SubscriptionMode.ValueType  # 2
    """The target samples values according to the interval."""

class SubscriptionMode(_SubscriptionMode, metaclass=_SubscriptionModeEnumTypeWrapper):
    """SubscriptionMode is the mode of the subscription, specifying how the
    target must return values in a subscription.
    Reference: gNMI Specification Section 3.5.1.3
    """

TARGET_DEFINED: SubscriptionMode.ValueType  # 0
"""The target selects the relevant mode for each element."""
ON_CHANGE: SubscriptionMode.ValueType  # 1
"""The target sends an update on element value change."""
SAMPLE: SubscriptionMode.ValueType  # 2
"""The target samples values according to the interval."""
global___SubscriptionMode = SubscriptionMode

@typing_extensions.final
class Notification(google.protobuf.message.Message):
    """Notification is a re-usable message that is used to encode data from the
    target to the client. A Notification carries two types of changes to the data
    tree:
     - Deleted values (delete) - a set of paths that have been removed from the
       data tree.
     - Updated values (update) - a set of path-value pairs indicating the path
       whose value has changed in the data tree.
    Reference: gNMI Specification Section 2.1
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    PREFIX_FIELD_NUMBER: builtins.int
    UPDATE_FIELD_NUMBER: builtins.int
    DELETE_FIELD_NUMBER: builtins.int
    ATOMIC_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Timestamp in nanoseconds since Epoch."""
    @property
    def prefix(self) -> global___Path:
        """Prefix used for paths in the message."""
    @property
    def update(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Update]:
        """Data elements that have changed values."""
    @property
    def delete(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Path]:
        """Data elements that have been deleted."""
    atomic: builtins.bool
    """This notification contains a set of paths that are always updated together
    referenced by a globally unique prefix.
    """
    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        prefix: global___Path | None = ...,
        update: collections.abc.Iterable[global___Update] | None = ...,
        delete: collections.abc.Iterable[global___Path] | None = ...,
        atomic: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["prefix", b"prefix"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["atomic", b"atomic", "delete", b"delete", "prefix", b"prefix", "timestamp", b"timestamp", "update", b"update"]) -> None: ...

global___Notification = Notification

@typing_extensions.final
class Update(google.protobuf.message.Message):
    """Update is a re-usable message that is used to store a particular Path,
    Value pair.
    Reference: gNMI Specification Section 2.1
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PATH_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    VAL_FIELD_NUMBER: builtins.int
    DUPLICATES_FIELD_NUMBER: builtins.int
    @property
    def path(self) -> global___Path:
        """The path (key) for the update."""
    @property
    def value(self) -> global___Value:
        """The value (value) for the update."""
    @property
    def val(self) -> global___TypedValue:
        """The explicitly typed update value."""
    duplicates: builtins.int
    """Number of coalesced duplicates."""
    def __init__(
        self,
        *,
        path: global___Path | None = ...,
        value: global___Value | None = ...,
        val: global___TypedValue | None = ...,
        duplicates: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["path", b"path", "val", b"val", "value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["duplicates", b"duplicates", "path", b"path", "val", b"val", "value", b"value"]) -> None: ...

global___Update = Update

@typing_extensions.final
class TypedValue(google.protobuf.message.Message):
    """TypedValue is used to encode a value being sent between the client and
    target (originated by either entity).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STRING_VAL_FIELD_NUMBER: builtins.int
    INT_VAL_FIELD_NUMBER: builtins.int
    UINT_VAL_FIELD_NUMBER: builtins.int
    BOOL_VAL_FIELD_NUMBER: builtins.int
    BYTES_VAL_FIELD_NUMBER: builtins.int
    FLOAT_VAL_FIELD_NUMBER: builtins.int
    DOUBLE_VAL_FIELD_NUMBER: builtins.int
    DECIMAL_VAL_FIELD_NUMBER: builtins.int
    LEAFLIST_VAL_FIELD_NUMBER: builtins.int
    ANY_VAL_FIELD_NUMBER: builtins.int
    JSON_VAL_FIELD_NUMBER: builtins.int
    JSON_IETF_VAL_FIELD_NUMBER: builtins.int
    ASCII_VAL_FIELD_NUMBER: builtins.int
    PROTO_BYTES_FIELD_NUMBER: builtins.int
    string_val: builtins.str
    """String value."""
    int_val: builtins.int
    """Integer value."""
    uint_val: builtins.int
    """Unsigned integer value."""
    bool_val: builtins.bool
    """Bool value."""
    bytes_val: builtins.bytes
    """Arbitrary byte sequence value."""
    float_val: builtins.float
    """Deprecated - use double_val."""
    double_val: builtins.float
    """Floating point value."""
    @property
    def decimal_val(self) -> global___Decimal64:
        """Deprecated - use double_val."""
    @property
    def leaflist_val(self) -> global___ScalarArray:
        """Mixed type scalar array value."""
    @property
    def any_val(self) -> google.protobuf.any_pb2.Any:
        """protobuf.Any encoded bytes."""
    json_val: builtins.bytes
    """JSON-encoded text."""
    json_ietf_val: builtins.bytes
    """JSON-encoded text per RFC7951."""
    ascii_val: builtins.str
    """Arbitrary ASCII text."""
    proto_bytes: builtins.bytes
    """Protobuf binary encoded bytes. The message type is not included.
    See the specification at
    github.com/openconfig/reference/blob/master/rpc/gnmi/protobuf-vals.md
    for a complete specification. [Experimental]
    """
    def __init__(
        self,
        *,
        string_val: builtins.str = ...,
        int_val: builtins.int = ...,
        uint_val: builtins.int = ...,
        bool_val: builtins.bool = ...,
        bytes_val: builtins.bytes = ...,
        float_val: builtins.float = ...,
        double_val: builtins.float = ...,
        decimal_val: global___Decimal64 | None = ...,
        leaflist_val: global___ScalarArray | None = ...,
        any_val: google.protobuf.any_pb2.Any | None = ...,
        json_val: builtins.bytes = ...,
        json_ietf_val: builtins.bytes = ...,
        ascii_val: builtins.str = ...,
        proto_bytes: builtins.bytes = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["any_val", b"any_val", "ascii_val", b"ascii_val", "bool_val", b"bool_val", "bytes_val", b"bytes_val", "decimal_val", b"decimal_val", "double_val", b"double_val", "float_val", b"float_val", "int_val", b"int_val", "json_ietf_val", b"json_ietf_val", "json_val", b"json_val", "leaflist_val", b"leaflist_val", "proto_bytes", b"proto_bytes", "string_val", b"string_val", "uint_val", b"uint_val", "value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["any_val", b"any_val", "ascii_val", b"ascii_val", "bool_val", b"bool_val", "bytes_val", b"bytes_val", "decimal_val", b"decimal_val", "double_val", b"double_val", "float_val", b"float_val", "int_val", b"int_val", "json_ietf_val", b"json_ietf_val", "json_val", b"json_val", "leaflist_val", b"leaflist_val", "proto_bytes", b"proto_bytes", "string_val", b"string_val", "uint_val", b"uint_val", "value", b"value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["value", b"value"]) -> typing_extensions.Literal["string_val", "int_val", "uint_val", "bool_val", "bytes_val", "float_val", "double_val", "decimal_val", "leaflist_val", "any_val", "json_val", "json_ietf_val", "ascii_val", "proto_bytes"] | None: ...

global___TypedValue = TypedValue

@typing_extensions.final
class Path(google.protobuf.message.Message):
    """Path encodes a data tree path as a series of repeated strings, with
    each element of the path representing a data tree node name and the
    associated attributes.
    Reference: gNMI Specification Section 2.2.2.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ELEMENT_FIELD_NUMBER: builtins.int
    ORIGIN_FIELD_NUMBER: builtins.int
    ELEM_FIELD_NUMBER: builtins.int
    TARGET_FIELD_NUMBER: builtins.int
    @property
    def element(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Elements of the path are no longer encoded as a string, but rather within
        the elem field as a PathElem message.
        """
    origin: builtins.str
    """Label to disambiguate path."""
    @property
    def elem(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PathElem]:
        """Elements of the path."""
    target: builtins.str
    """The name of the target"""
    def __init__(
        self,
        *,
        element: collections.abc.Iterable[builtins.str] | None = ...,
        origin: builtins.str = ...,
        elem: collections.abc.Iterable[global___PathElem] | None = ...,
        target: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elem", b"elem", "element", b"element", "origin", b"origin", "target", b"target"]) -> None: ...

global___Path = Path

@typing_extensions.final
class PathElem(google.protobuf.message.Message):
    """PathElem encodes an element of a gNMI path, along with any attributes (keys)
    that may be associated with it.
    Reference: gNMI Specification Section 2.2.2.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class KeyEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the element in the path."""
    @property
    def key(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Map of key (attribute) name to value."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        key: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "name", b"name"]) -> None: ...

global___PathElem = PathElem

@typing_extensions.final
class Value(google.protobuf.message.Message):
    """Value encodes a data tree node's value - along with the way in which
    the value is encoded. This message is deprecated by gNMI 0.3.0.
    Reference: gNMI Specification Section 2.2.3.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    value: builtins.bytes
    """Value of the variable being transmitted."""
    type: global___Encoding.ValueType
    """Encoding used for the value field."""
    def __init__(
        self,
        *,
        value: builtins.bytes = ...,
        type: global___Encoding.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["type", b"type", "value", b"value"]) -> None: ...

global___Value = Value

@typing_extensions.final
class Error(google.protobuf.message.Message):
    """Error message previously utilised to return errors to the client. Deprecated
    in favour of using the google.golang.org/genproto/googleapis/rpc/status
    message in the RPC response.
    Reference: gNMI Specification Section 2.5
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CODE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    code: builtins.int
    """Canonical gRPC error code."""
    message: builtins.str
    """Human readable error."""
    @property
    def data(self) -> google.protobuf.any_pb2.Any:
        """Optional additional information."""
    def __init__(
        self,
        *,
        code: builtins.int = ...,
        message: builtins.str = ...,
        data: google.protobuf.any_pb2.Any | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["data", b"data"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["code", b"code", "data", b"data", "message", b"message"]) -> None: ...

global___Error = Error

@typing_extensions.final
class Decimal64(google.protobuf.message.Message):
    """Decimal64 is used to encode a fixed precision decimal number. The value
    is expressed as a set of digits with the precision specifying the
    number of digits following the decimal point in the digit set.
    This message is deprecated in favor of encoding all floating point types
    as double precision.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DIGITS_FIELD_NUMBER: builtins.int
    PRECISION_FIELD_NUMBER: builtins.int
    digits: builtins.int
    """Set of digits."""
    precision: builtins.int
    """Number of digits following the decimal point."""
    def __init__(
        self,
        *,
        digits: builtins.int = ...,
        precision: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["digits", b"digits", "precision", b"precision"]) -> None: ...

global___Decimal64 = Decimal64

@typing_extensions.final
class ScalarArray(google.protobuf.message.Message):
    """ScalarArray is used to encode a mixed-type array of values."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ELEMENT_FIELD_NUMBER: builtins.int
    @property
    def element(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TypedValue]:
        """The set of elements within the array. Each TypedValue message should
        specify only elements that have a field identifier of 1-7 (i.e., the
        values are scalar values).
        """
    def __init__(
        self,
        *,
        element: collections.abc.Iterable[global___TypedValue] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["element", b"element"]) -> None: ...

global___ScalarArray = ScalarArray

@typing_extensions.final
class SubscribeRequest(google.protobuf.message.Message):
    """SubscribeRequest is the message sent by the client to the target when
    initiating a subscription to a set of paths within the data tree. The
    request field must be populated and the initial message must specify a
    SubscriptionList to initiate a subscription.
    Reference: gNMI Specification Section 3.5.1.1
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBSCRIBE_FIELD_NUMBER: builtins.int
    POLL_FIELD_NUMBER: builtins.int
    EXTENSION_FIELD_NUMBER: builtins.int
    @property
    def subscribe(self) -> global___SubscriptionList:
        """Specify the paths within a subscription."""
    @property
    def poll(self) -> global___Poll:
        """Trigger a polled update."""
    @property
    def extension(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[gnmi1.gnmi_ext_pb2.Extension]:
        """Extension messages associated with the SubscribeRequest. See the
        gNMI extension specification for further definition.
        """
    def __init__(
        self,
        *,
        subscribe: global___SubscriptionList | None = ...,
        poll: global___Poll | None = ...,
        extension: collections.abc.Iterable[gnmi1.gnmi_ext_pb2.Extension] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["poll", b"poll", "request", b"request", "subscribe", b"subscribe"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["extension", b"extension", "poll", b"poll", "request", b"request", "subscribe", b"subscribe"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["request", b"request"]) -> typing_extensions.Literal["subscribe", "poll"] | None: ...

global___SubscribeRequest = SubscribeRequest

@typing_extensions.final
class Poll(google.protobuf.message.Message):
    """Poll is sent within a SubscribeRequest to trigger the device to
    send telemetry updates for the paths that are associated with the
    subscription.
    Reference: gNMI Specification Section Section 3.5.1.4
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___Poll = Poll

@typing_extensions.final
class SubscribeResponse(google.protobuf.message.Message):
    """SubscribeResponse is the message used by the target within a Subscribe RPC.
    The target includes a Notification message which is used to transmit values
    of the path(s) that are associated with the subscription. The same message
    is to indicate that the target has sent all data values once (is
    synchronized).
    Reference: gNMI Specification Section 3.5.1.4
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UPDATE_FIELD_NUMBER: builtins.int
    SYNC_RESPONSE_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    EXTENSION_FIELD_NUMBER: builtins.int
    @property
    def update(self) -> global___Notification:
        """Changed or sampled value for a path."""
    sync_response: builtins.bool
    """Indicate target has sent all values associated with the subscription
    at least once.
    """
    @property
    def error(self) -> global___Error:
        """Deprecated in favour of google.golang.org/genproto/googleapis/rpc/status"""
    @property
    def extension(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[gnmi1.gnmi_ext_pb2.Extension]:
        """Extension messages associated with the SubscribeResponse. See the
        gNMI extension specification for further definition.
        """
    def __init__(
        self,
        *,
        update: global___Notification | None = ...,
        sync_response: builtins.bool = ...,
        error: global___Error | None = ...,
        extension: collections.abc.Iterable[gnmi1.gnmi_ext_pb2.Extension] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["error", b"error", "response", b"response", "sync_response", b"sync_response", "update", b"update"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["error", b"error", "extension", b"extension", "response", b"response", "sync_response", b"sync_response", "update", b"update"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["response", b"response"]) -> typing_extensions.Literal["update", "sync_response", "error"] | None: ...

global___SubscribeResponse = SubscribeResponse

@typing_extensions.final
class SubscriptionList(google.protobuf.message.Message):
    """SubscriptionList is used within a Subscribe message to specify the list of
    paths that the client wishes to subscribe to. The message consists of a
    list of (possibly prefixed) paths, and options that relate to the
    subscription.
    Reference: gNMI Specification Section 3.5.1.2
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Mode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SubscriptionList._Mode.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STREAM: SubscriptionList._Mode.ValueType  # 0
        """Values streamed by the target (Sec. 3.5.1.5.2)."""
        ONCE: SubscriptionList._Mode.ValueType  # 1
        """Values sent once-off by the target (Sec. 3.5.1.5.1)."""
        POLL: SubscriptionList._Mode.ValueType  # 2
        """Values sent in response to a poll request (Sec. 3.5.1.5.3)."""

    class Mode(_Mode, metaclass=_ModeEnumTypeWrapper):
        """Mode of the subscription."""

    STREAM: SubscriptionList.Mode.ValueType  # 0
    """Values streamed by the target (Sec. 3.5.1.5.2)."""
    ONCE: SubscriptionList.Mode.ValueType  # 1
    """Values sent once-off by the target (Sec. 3.5.1.5.1)."""
    POLL: SubscriptionList.Mode.ValueType  # 2
    """Values sent in response to a poll request (Sec. 3.5.1.5.3)."""

    PREFIX_FIELD_NUMBER: builtins.int
    SUBSCRIPTION_FIELD_NUMBER: builtins.int
    QOS_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    ALLOW_AGGREGATION_FIELD_NUMBER: builtins.int
    USE_MODELS_FIELD_NUMBER: builtins.int
    ENCODING_FIELD_NUMBER: builtins.int
    UPDATES_ONLY_FIELD_NUMBER: builtins.int
    @property
    def prefix(self) -> global___Path:
        """Prefix used for paths."""
    @property
    def subscription(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Subscription]:
        """Set of subscriptions to create."""
    @property
    def qos(self) -> global___QOSMarking:
        """DSCP marking to be used."""
    mode: global___SubscriptionList.Mode.ValueType
    allow_aggregation: builtins.bool
    """Whether elements of the schema that are marked as eligible for aggregation
    should be aggregated or not.
    """
    @property
    def use_models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelData]:
        """The set of schemas that define the elements of the data tree that should
        be sent by the target.
        """
    encoding: global___Encoding.ValueType
    """The encoding that the target should use within the Notifications generated
    corresponding to the SubscriptionList.
    """
    updates_only: builtins.bool
    """An optional field to specify that only updates to current state should be
    sent to a client. If set, the initial state is not sent to the client but
    rather only the sync message followed by any subsequent updates to the
    current state. For ONCE and POLL modes, this causes the server to send only
    the sync message (Sec. 3.5.2.3).
    """
    def __init__(
        self,
        *,
        prefix: global___Path | None = ...,
        subscription: collections.abc.Iterable[global___Subscription] | None = ...,
        qos: global___QOSMarking | None = ...,
        mode: global___SubscriptionList.Mode.ValueType = ...,
        allow_aggregation: builtins.bool = ...,
        use_models: collections.abc.Iterable[global___ModelData] | None = ...,
        encoding: global___Encoding.ValueType = ...,
        updates_only: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["prefix", b"prefix", "qos", b"qos"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["allow_aggregation", b"allow_aggregation", "encoding", b"encoding", "mode", b"mode", "prefix", b"prefix", "qos", b"qos", "subscription", b"subscription", "updates_only", b"updates_only", "use_models", b"use_models"]) -> None: ...

global___SubscriptionList = SubscriptionList

@typing_extensions.final
class Subscription(google.protobuf.message.Message):
    """Subscription is a single request within a SubscriptionList. The path
    specified is interpreted (along with the prefix) as the elements of the data
    tree that the client is subscribing to. The mode determines how the target
    should trigger updates to be sent.
    Reference: gNMI Specification Section 3.5.1.3
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PATH_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    SAMPLE_INTERVAL_FIELD_NUMBER: builtins.int
    SUPPRESS_REDUNDANT_FIELD_NUMBER: builtins.int
    HEARTBEAT_INTERVAL_FIELD_NUMBER: builtins.int
    @property
    def path(self) -> global___Path:
        """The data tree path."""
    mode: global___SubscriptionMode.ValueType
    """Subscription mode to be used."""
    sample_interval: builtins.int
    """ns between samples in SAMPLE mode."""
    suppress_redundant: builtins.bool
    """Indicates whether values that have not changed should be sent in a SAMPLE
    subscription.
    """
    heartbeat_interval: builtins.int
    """Specifies the maximum allowable silent period in nanoseconds when
    suppress_redundant is in use. The target should send a value at least once
    in the period specified.
    """
    def __init__(
        self,
        *,
        path: global___Path | None = ...,
        mode: global___SubscriptionMode.ValueType = ...,
        sample_interval: builtins.int = ...,
        suppress_redundant: builtins.bool = ...,
        heartbeat_interval: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["path", b"path"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["heartbeat_interval", b"heartbeat_interval", "mode", b"mode", "path", b"path", "sample_interval", b"sample_interval", "suppress_redundant", b"suppress_redundant"]) -> None: ...

global___Subscription = Subscription

@typing_extensions.final
class QOSMarking(google.protobuf.message.Message):
    """QOSMarking specifies the DSCP value to be set on transmitted telemetry
    updates from the target.
    Reference: gNMI Specification Section 3.5.1.2
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MARKING_FIELD_NUMBER: builtins.int
    marking: builtins.int
    def __init__(
        self,
        *,
        marking: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["marking", b"marking"]) -> None: ...

global___QOSMarking = QOSMarking

@typing_extensions.final
class SetRequest(google.protobuf.message.Message):
    """SetRequest is sent from a client to the target to update values in the data
    tree. Paths are either deleted by the client, or modified by means of being
    updated, or replaced. Where a replace is used, unspecified values are
    considered to be replaced, whereas when update is used the changes are
    considered to be incremental. The set of changes that are specified within
    a single SetRequest are considered to be a transaction.
    Reference: gNMI Specification Section 3.4.1
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREFIX_FIELD_NUMBER: builtins.int
    DELETE_FIELD_NUMBER: builtins.int
    REPLACE_FIELD_NUMBER: builtins.int
    UPDATE_FIELD_NUMBER: builtins.int
    EXTENSION_FIELD_NUMBER: builtins.int
    @property
    def prefix(self) -> global___Path:
        """Prefix used for paths in the message."""
    @property
    def delete(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Path]:
        """Paths to be deleted from the data tree."""
    @property
    def replace(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Update]:
        """Updates specifying elements to be replaced."""
    @property
    def update(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Update]:
        """Updates specifying elements to updated."""
    @property
    def extension(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[gnmi1.gnmi_ext_pb2.Extension]:
        """Extension messages associated with the SetRequest. See the
        gNMI extension specification for further definition.
        """
    def __init__(
        self,
        *,
        prefix: global___Path | None = ...,
        delete: collections.abc.Iterable[global___Path] | None = ...,
        replace: collections.abc.Iterable[global___Update] | None = ...,
        update: collections.abc.Iterable[global___Update] | None = ...,
        extension: collections.abc.Iterable[gnmi1.gnmi_ext_pb2.Extension] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["prefix", b"prefix"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["delete", b"delete", "extension", b"extension", "prefix", b"prefix", "replace", b"replace", "update", b"update"]) -> None: ...

global___SetRequest = SetRequest

@typing_extensions.final
class SetResponse(google.protobuf.message.Message):
    """SetResponse is the response to a SetRequest, sent from the target to the
    client. It reports the result of the modifications to the data tree that were
    specified by the client. Errors for this RPC should be reported using the
    https://github.com/googleapis/googleapis/blob/master/google/rpc/status.proto
    message in the RPC return. The gnmi.Error message can be used to add additional
    details where required.
    Reference: gNMI Specification Section 3.4.2
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREFIX_FIELD_NUMBER: builtins.int
    RESPONSE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    EXTENSION_FIELD_NUMBER: builtins.int
    @property
    def prefix(self) -> global___Path:
        """Prefix used for paths."""
    @property
    def response(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UpdateResult]:
        """A set of responses specifying the result of the operations specified in
        the SetRequest.
        """
    @property
    def message(self) -> global___Error:
        """The overall status of the transaction."""
    timestamp: builtins.int
    """Timestamp of transaction (ns since epoch)."""
    @property
    def extension(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[gnmi1.gnmi_ext_pb2.Extension]:
        """Extension messages associated with the SetResponse. See the
        gNMI extension specification for further definition.
        """
    def __init__(
        self,
        *,
        prefix: global___Path | None = ...,
        response: collections.abc.Iterable[global___UpdateResult] | None = ...,
        message: global___Error | None = ...,
        timestamp: builtins.int = ...,
        extension: collections.abc.Iterable[gnmi1.gnmi_ext_pb2.Extension] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["message", b"message", "prefix", b"prefix"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["extension", b"extension", "message", b"message", "prefix", b"prefix", "response", b"response", "timestamp", b"timestamp"]) -> None: ...

global___SetResponse = SetResponse

@typing_extensions.final
class UpdateResult(google.protobuf.message.Message):
    """UpdateResult is used within the SetResponse message to communicate the
    result of an operation specified within a SetRequest message.
    Reference: gNMI Specification Section 3.4.2
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Operation:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _OperationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[UpdateResult._Operation.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        INVALID: UpdateResult._Operation.ValueType  # 0
        DELETE: UpdateResult._Operation.ValueType  # 1
        """The result relates to a delete of Path."""
        REPLACE: UpdateResult._Operation.ValueType  # 2
        """The result relates to a replace of Path."""
        UPDATE: UpdateResult._Operation.ValueType  # 3
        """The result relates to an update of Path."""

    class Operation(_Operation, metaclass=_OperationEnumTypeWrapper):
        """The operation that was associated with the Path specified."""

    INVALID: UpdateResult.Operation.ValueType  # 0
    DELETE: UpdateResult.Operation.ValueType  # 1
    """The result relates to a delete of Path."""
    REPLACE: UpdateResult.Operation.ValueType  # 2
    """The result relates to a replace of Path."""
    UPDATE: UpdateResult.Operation.ValueType  # 3
    """The result relates to an update of Path."""

    TIMESTAMP_FIELD_NUMBER: builtins.int
    PATH_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    OP_FIELD_NUMBER: builtins.int
    timestamp: builtins.int
    """Deprecated timestamp for the UpdateResult, this field has been
    replaced by the timestamp within the SetResponse message, since
    all mutations effected by a set should be applied as a single
    transaction.
    """
    @property
    def path(self) -> global___Path:
        """Path associated with the update."""
    @property
    def message(self) -> global___Error:
        """Status of the update operation."""
    op: global___UpdateResult.Operation.ValueType
    """Update operation type."""
    def __init__(
        self,
        *,
        timestamp: builtins.int = ...,
        path: global___Path | None = ...,
        message: global___Error | None = ...,
        op: global___UpdateResult.Operation.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["message", b"message", "path", b"path"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["message", b"message", "op", b"op", "path", b"path", "timestamp", b"timestamp"]) -> None: ...

global___UpdateResult = UpdateResult

@typing_extensions.final
class GetRequest(google.protobuf.message.Message):
    """GetRequest is sent when a client initiates a Get RPC. It is used to specify
    the set of data elements for which the target should return a snapshot of
    data. The use_models field specifies the set of schema modules that are to
    be used by the target - where use_models is not specified then the target
    must use all schema models that it has.
    Reference: gNMI Specification Section 3.3.1
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _DataType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _DataTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[GetRequest._DataType.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ALL: GetRequest._DataType.ValueType  # 0
        """All data elements."""
        CONFIG: GetRequest._DataType.ValueType  # 1
        """Config (rw) only elements."""
        STATE: GetRequest._DataType.ValueType  # 2
        """State (ro) only elements."""
        OPERATIONAL: GetRequest._DataType.ValueType  # 3
        """Data elements marked in the schema as operational. This refers to data
        elements whose value relates to the state of processes or interactions
        running on the device.
        """

    class DataType(_DataType, metaclass=_DataTypeEnumTypeWrapper):
        """Type of elements within the data tree."""

    ALL: GetRequest.DataType.ValueType  # 0
    """All data elements."""
    CONFIG: GetRequest.DataType.ValueType  # 1
    """Config (rw) only elements."""
    STATE: GetRequest.DataType.ValueType  # 2
    """State (ro) only elements."""
    OPERATIONAL: GetRequest.DataType.ValueType  # 3
    """Data elements marked in the schema as operational. This refers to data
    elements whose value relates to the state of processes or interactions
    running on the device.
    """

    PREFIX_FIELD_NUMBER: builtins.int
    PATH_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    ENCODING_FIELD_NUMBER: builtins.int
    USE_MODELS_FIELD_NUMBER: builtins.int
    EXTENSION_FIELD_NUMBER: builtins.int
    @property
    def prefix(self) -> global___Path:
        """Prefix used for paths."""
    @property
    def path(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Path]:
        """Paths requested by the client."""
    type: global___GetRequest.DataType.ValueType
    """The type of data being requested."""
    encoding: global___Encoding.ValueType
    """Encoding to be used."""
    @property
    def use_models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelData]:
        """The schema models to be used."""
    @property
    def extension(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[gnmi1.gnmi_ext_pb2.Extension]:
        """Extension messages associated with the GetRequest. See the
        gNMI extension specification for further definition.
        """
    def __init__(
        self,
        *,
        prefix: global___Path | None = ...,
        path: collections.abc.Iterable[global___Path] | None = ...,
        type: global___GetRequest.DataType.ValueType = ...,
        encoding: global___Encoding.ValueType = ...,
        use_models: collections.abc.Iterable[global___ModelData] | None = ...,
        extension: collections.abc.Iterable[gnmi1.gnmi_ext_pb2.Extension] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["prefix", b"prefix"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["encoding", b"encoding", "extension", b"extension", "path", b"path", "prefix", b"prefix", "type", b"type", "use_models", b"use_models"]) -> None: ...

global___GetRequest = GetRequest

@typing_extensions.final
class GetResponse(google.protobuf.message.Message):
    """GetResponse is used by the target to respond to a GetRequest from a client.
    The set of Notifications corresponds to the data values that are requested
    by the client in the GetRequest.
    Reference: gNMI Specification Section 3.3.2
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NOTIFICATION_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    EXTENSION_FIELD_NUMBER: builtins.int
    @property
    def notification(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Notification]:
        """Data values."""
    @property
    def error(self) -> global___Error:
        """Errors that occurred in the Get."""
    @property
    def extension(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[gnmi1.gnmi_ext_pb2.Extension]:
        """Extension messages associated with the GetResponse. See the
        gNMI extension specification for further definition.
        """
    def __init__(
        self,
        *,
        notification: collections.abc.Iterable[global___Notification] | None = ...,
        error: global___Error | None = ...,
        extension: collections.abc.Iterable[gnmi1.gnmi_ext_pb2.Extension] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["error", b"error"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["error", b"error", "extension", b"extension", "notification", b"notification"]) -> None: ...

global___GetResponse = GetResponse

@typing_extensions.final
class CapabilityRequest(google.protobuf.message.Message):
    """CapabilityRequest is sent by the client in the Capabilities RPC to request
    that the target reports its capabilities.
    Reference: gNMI Specification Section 3.2.1
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXTENSION_FIELD_NUMBER: builtins.int
    @property
    def extension(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[gnmi1.gnmi_ext_pb2.Extension]:
        """Extension messages associated with the CapabilityRequest. See the
        gNMI extension specification for further definition.
        """
    def __init__(
        self,
        *,
        extension: collections.abc.Iterable[gnmi1.gnmi_ext_pb2.Extension] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["extension", b"extension"]) -> None: ...

global___CapabilityRequest = CapabilityRequest

@typing_extensions.final
class CapabilityResponse(google.protobuf.message.Message):
    """CapabilityResponse is used by the target to report its capabilities to the
    client within the Capabilities RPC.
    Reference: gNMI Specification Section 3.2.2
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUPPORTED_MODELS_FIELD_NUMBER: builtins.int
    SUPPORTED_ENCODINGS_FIELD_NUMBER: builtins.int
    GNMI_VERSION_FIELD_NUMBER: builtins.int
    EXTENSION_FIELD_NUMBER: builtins.int
    @property
    def supported_models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelData]:
        """Supported schema models."""
    @property
    def supported_encodings(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___Encoding.ValueType]:
        """Supported encodings."""
    gNMI_version: builtins.str
    """Supported gNMI version."""
    @property
    def extension(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[gnmi1.gnmi_ext_pb2.Extension]:
        """Extension messages associated with the CapabilityResponse. See the
        gNMI extension specification for further definition.
        """
    def __init__(
        self,
        *,
        supported_models: collections.abc.Iterable[global___ModelData] | None = ...,
        supported_encodings: collections.abc.Iterable[global___Encoding.ValueType] | None = ...,
        gNMI_version: builtins.str = ...,
        extension: collections.abc.Iterable[gnmi1.gnmi_ext_pb2.Extension] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["extension", b"extension", "gNMI_version", b"gNMI_version", "supported_encodings", b"supported_encodings", "supported_models", b"supported_models"]) -> None: ...

global___CapabilityResponse = CapabilityResponse

@typing_extensions.final
class ModelData(google.protobuf.message.Message):
    """ModelData is used to describe a set of schema modules. It can be used in a
    CapabilityResponse where a target reports the set of modules that it
    supports, and within the SubscribeRequest and GetRequest messages to specify
    the set of models from which data tree elements should be reported.
    Reference: gNMI Specification Section 3.2.3
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    ORGANIZATION_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the model."""
    organization: builtins.str
    """Organization publishing the model."""
    version: builtins.str
    """Semantic version of the model."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        organization: builtins.str = ...,
        version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "organization", b"organization", "version", b"version"]) -> None: ...

global___ModelData = ModelData

GNMI_SERVICE_FIELD_NUMBER: builtins.int
gnmi_service: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[google.protobuf.descriptor_pb2.FileOptions, builtins.str]
"""The gNMI service semantic version."""
