"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2020 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class RetryInfo(google.protobuf.message.Message):
    """Describes when the clients can retry a failed request. Clients could ignore
    the recommendation here or retry when this information is missing from error
    responses.

    It's always recommended that clients should use exponential backoff when
    retrying.

    Clients should wait until `retry_delay` amount of time has passed since
    receiving the error response before retrying.  If retrying requests also
    fail, clients should use an exponential backoff scheme to gradually increase
    the delay between retries based on `retry_delay`, until either a maximum
    number of retries have been reached or a maximum retry delay cap has been
    reached.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RETRY_DELAY_FIELD_NUMBER: builtins.int
    @property
    def retry_delay(self) -> google.protobuf.duration_pb2.Duration:
        """Clients should wait at least this long between retrying the same request."""
    def __init__(
        self,
        *,
        retry_delay: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["retry_delay", b"retry_delay"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["retry_delay", b"retry_delay"]) -> None: ...

global___RetryInfo = RetryInfo

@typing_extensions.final
class DebugInfo(google.protobuf.message.Message):
    """Describes additional debugging info."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STACK_ENTRIES_FIELD_NUMBER: builtins.int
    DETAIL_FIELD_NUMBER: builtins.int
    @property
    def stack_entries(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The stack trace entries indicating where the error occurred."""
    detail: builtins.str
    """Additional debugging information provided by the server."""
    def __init__(
        self,
        *,
        stack_entries: collections.abc.Iterable[builtins.str] | None = ...,
        detail: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["detail", b"detail", "stack_entries", b"stack_entries"]) -> None: ...

global___DebugInfo = DebugInfo

@typing_extensions.final
class QuotaFailure(google.protobuf.message.Message):
    """Describes how a quota check failed.

    For example if a daily limit was exceeded for the calling project,
    a service could respond with a QuotaFailure detail containing the project
    id and the description of the quota limit that was exceeded.  If the
    calling project hasn't enabled the service in the developer console, then
    a service could respond with the project id and set `service_disabled`
    to true.

    Also see RetryInfo and Help types for other details about handling a
    quota failure.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Violation(google.protobuf.message.Message):
        """A message type used to describe a single quota violation.  For example, a
        daily quota or a custom quota that was exceeded.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SUBJECT_FIELD_NUMBER: builtins.int
        DESCRIPTION_FIELD_NUMBER: builtins.int
        subject: builtins.str
        """The subject on which the quota check failed.
        For example, "clientip:<ip address of client>" or "project:<Google
        developer project id>".
        """
        description: builtins.str
        """A description of how the quota check failed. Clients can use this
        description to find more about the quota configuration in the service's
        public documentation, or find the relevant quota limit to adjust through
        developer console.

        For example: "Service disabled" or "Daily Limit for read operations
        exceeded".
        """
        def __init__(
            self,
            *,
            subject: builtins.str = ...,
            description: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "subject", b"subject"]) -> None: ...

    VIOLATIONS_FIELD_NUMBER: builtins.int
    @property
    def violations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___QuotaFailure.Violation]:
        """Describes all quota violations."""
    def __init__(
        self,
        *,
        violations: collections.abc.Iterable[global___QuotaFailure.Violation] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["violations", b"violations"]) -> None: ...

global___QuotaFailure = QuotaFailure

@typing_extensions.final
class ErrorInfo(google.protobuf.message.Message):
    """Describes the cause of the error with structured details.

    Example of an error when contacting the "pubsub.googleapis.com" API when it
    is not enabled:
        { "reason":   "API_DISABLED"
          "domain": "googleapis.com"
          "metadata": {
            "resource": "projects/123",
            "service": "pubsub.googleapis.com"
          }
        }
    This response indicates that the pubsub.googleapis.com API is not enabled.

    Example of an error that is returned when attempting to create a Spanner
    instance in a region that is out of stock:
        { "reason":   "STOCKOUT"
          "domain": "spanner.googleapis.com",
          "metadata": {
            "availableRegions": "us-central1,us-east2"
          }
        }
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    REASON_FIELD_NUMBER: builtins.int
    DOMAIN_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    reason: builtins.str
    """The reason of the error. This is a constant value that identifies the
    proximate cause of the error. Error reasons are unique within a particular
    domain of errors. This should be at most 63 characters and match
    /[A-Z0-9_]+/.
    """
    domain: builtins.str
    """The logical grouping to which the "reason" belongs.  Often "domain" will
    contain the registered service name of the tool or product that is the
    source of the error. Example: "pubsub.googleapis.com". If the error is
    common across many APIs, the first segment of the example above will be
    omitted.  The value will be, "googleapis.com".
    """
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional structured details about this error.

        Keys should match /[a-zA-Z0-9-_]/ and be limited to 64 characters in
        length. When identifying the current value of an exceeded limit, the units
        should be contained in the key, not the value.  For example, rather than
        {"instanceLimit": "100/request"}, should be returned as,
        {"instanceLimitPerRequest": "100"}, if the client exceeds the number of
        instances that can be created in a single (batch) request.
        """
    def __init__(
        self,
        *,
        reason: builtins.str = ...,
        domain: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["domain", b"domain", "metadata", b"metadata", "reason", b"reason"]) -> None: ...

global___ErrorInfo = ErrorInfo

@typing_extensions.final
class PreconditionFailure(google.protobuf.message.Message):
    """Describes what preconditions have failed.

    For example, if an RPC failed because it required the Terms of Service to be
    acknowledged, it could list the terms of service violation in the
    PreconditionFailure message.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Violation(google.protobuf.message.Message):
        """A message type used to describe a single precondition failure."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TYPE_FIELD_NUMBER: builtins.int
        SUBJECT_FIELD_NUMBER: builtins.int
        DESCRIPTION_FIELD_NUMBER: builtins.int
        type: builtins.str
        """The type of PreconditionFailure. We recommend using a service-specific
        enum type to define the supported precondition violation subjects. For
        example, "TOS" for "Terms of Service violation".
        """
        subject: builtins.str
        """The subject, relative to the type, that failed.
        For example, "google.com/cloud" relative to the "TOS" type would indicate
        which terms of service is being referenced.
        """
        description: builtins.str
        """A description of how the precondition failed. Developers can use this
        description to understand how to fix the failure.

        For example: "Terms of service not accepted".
        """
        def __init__(
            self,
            *,
            type: builtins.str = ...,
            subject: builtins.str = ...,
            description: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "subject", b"subject", "type", b"type"]) -> None: ...

    VIOLATIONS_FIELD_NUMBER: builtins.int
    @property
    def violations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PreconditionFailure.Violation]:
        """Describes all precondition violations."""
    def __init__(
        self,
        *,
        violations: collections.abc.Iterable[global___PreconditionFailure.Violation] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["violations", b"violations"]) -> None: ...

global___PreconditionFailure = PreconditionFailure

@typing_extensions.final
class BadRequest(google.protobuf.message.Message):
    """Describes violations in a client request. This error type focuses on the
    syntactic aspects of the request.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class FieldViolation(google.protobuf.message.Message):
        """A message type used to describe a single bad request field."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        FIELD_FIELD_NUMBER: builtins.int
        DESCRIPTION_FIELD_NUMBER: builtins.int
        field: builtins.str
        """A path leading to a field in the request body. The value will be a
        sequence of dot-separated identifiers that identify a protocol buffer
        field. E.g., "field_violations.field" would identify this field.
        """
        description: builtins.str
        """A description of why the request element is bad."""
        def __init__(
            self,
            *,
            field: builtins.str = ...,
            description: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "field", b"field"]) -> None: ...

    FIELD_VIOLATIONS_FIELD_NUMBER: builtins.int
    @property
    def field_violations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BadRequest.FieldViolation]:
        """Describes all violations in a client request."""
    def __init__(
        self,
        *,
        field_violations: collections.abc.Iterable[global___BadRequest.FieldViolation] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["field_violations", b"field_violations"]) -> None: ...

global___BadRequest = BadRequest

@typing_extensions.final
class RequestInfo(google.protobuf.message.Message):
    """Contains metadata about the request that clients can attach when filing a bug
    or providing other forms of feedback.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    SERVING_DATA_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    """An opaque string that should only be interpreted by the service generating
    it. For example, it can be used to identify requests in the service's logs.
    """
    serving_data: builtins.str
    """Any data that was used to serve this request. For example, an encrypted
    stack trace that can be sent back to the service provider for debugging.
    """
    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
        serving_data: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["request_id", b"request_id", "serving_data", b"serving_data"]) -> None: ...

global___RequestInfo = RequestInfo

@typing_extensions.final
class ResourceInfo(google.protobuf.message.Message):
    """Describes the resource that is being accessed."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_TYPE_FIELD_NUMBER: builtins.int
    RESOURCE_NAME_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    resource_type: builtins.str
    """A name for the type of resource being accessed, e.g. "sql table",
    "cloud storage bucket", "file", "Google calendar"; or the type URL
    of the resource: e.g. "type.googleapis.com/google.pubsub.v1.Topic".
    """
    resource_name: builtins.str
    """The name of the resource being accessed.  For example, a shared calendar
    name: "example.com_4fghdhgsrgh@group.calendar.google.com", if the current
    error is [google.rpc.Code.PERMISSION_DENIED][google.rpc.Code.PERMISSION_DENIED].
    """
    owner: builtins.str
    """The owner of the resource (optional).
    For example, "user:<owner email>" or "project:<Google developer project
    id>".
    """
    description: builtins.str
    """Describes what error is encountered when accessing this resource.
    For example, updating a cloud project may require the `writer` permission
    on the developer console project.
    """
    def __init__(
        self,
        *,
        resource_type: builtins.str = ...,
        resource_name: builtins.str = ...,
        owner: builtins.str = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "owner", b"owner", "resource_name", b"resource_name", "resource_type", b"resource_type"]) -> None: ...

global___ResourceInfo = ResourceInfo

@typing_extensions.final
class Help(google.protobuf.message.Message):
    """Provides links to documentation or for performing an out of band action.

    For example, if a quota check failed with an error indicating the calling
    project hasn't enabled the accessed service, this can contain a URL pointing
    directly to the right place in the developer console to flip the bit.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Link(google.protobuf.message.Message):
        """Describes a URL link."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DESCRIPTION_FIELD_NUMBER: builtins.int
        URL_FIELD_NUMBER: builtins.int
        description: builtins.str
        """Describes what the link offers."""
        url: builtins.str
        """The URL of the link."""
        def __init__(
            self,
            *,
            description: builtins.str = ...,
            url: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "url", b"url"]) -> None: ...

    LINKS_FIELD_NUMBER: builtins.int
    @property
    def links(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Help.Link]:
        """URL(s) pointing to additional information on handling the current error."""
    def __init__(
        self,
        *,
        links: collections.abc.Iterable[global___Help.Link] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["links", b"links"]) -> None: ...

global___Help = Help

@typing_extensions.final
class LocalizedMessage(google.protobuf.message.Message):
    """Provides a localized error message that is safe to return to the user
    which can be attached to an RPC error.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOCALE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    locale: builtins.str
    """The locale used following the specification defined at
    http://www.rfc-editor.org/rfc/bcp/bcp47.txt.
    Examples are: "en-US", "fr-CH", "es-MX"
    """
    message: builtins.str
    """The localized error message in the above locale."""
    def __init__(
        self,
        *,
        locale: builtins.str = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["locale", b"locale", "message", b"message"]) -> None: ...

global___LocalizedMessage = LocalizedMessage
