"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
This package and its contents are a work-in-progress."""
import builtins
import collections.abc
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import p4.config.v1.p4types_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class P4Info(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PKG_INFO_FIELD_NUMBER: builtins.int
    TABLES_FIELD_NUMBER: builtins.int
    ACTIONS_FIELD_NUMBER: builtins.int
    ACTION_PROFILES_FIELD_NUMBER: builtins.int
    COUNTERS_FIELD_NUMBER: builtins.int
    DIRECT_COUNTERS_FIELD_NUMBER: builtins.int
    METERS_FIELD_NUMBER: builtins.int
    DIRECT_METERS_FIELD_NUMBER: builtins.int
    CONTROLLER_PACKET_METADATA_FIELD_NUMBER: builtins.int
    VALUE_SETS_FIELD_NUMBER: builtins.int
    REGISTERS_FIELD_NUMBER: builtins.int
    DIGESTS_FIELD_NUMBER: builtins.int
    EXTERNS_FIELD_NUMBER: builtins.int
    TYPE_INFO_FIELD_NUMBER: builtins.int
    @property
    def pkg_info(self) -> global___PkgInfo: ...
    @property
    def tables(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Table]: ...
    @property
    def actions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Action]: ...
    @property
    def action_profiles(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ActionProfile]: ...
    @property
    def counters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Counter]: ...
    @property
    def direct_counters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DirectCounter]: ...
    @property
    def meters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Meter]: ...
    @property
    def direct_meters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DirectMeter]: ...
    @property
    def controller_packet_metadata(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ControllerPacketMetadata]: ...
    @property
    def value_sets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ValueSet]: ...
    @property
    def registers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Register]: ...
    @property
    def digests(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Digest]: ...
    @property
    def externs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Extern]: ...
    @property
    def type_info(self) -> p4.config.v1.p4types_pb2.P4TypeInfo: ...
    def __init__(
        self,
        *,
        pkg_info: global___PkgInfo | None = ...,
        tables: collections.abc.Iterable[global___Table] | None = ...,
        actions: collections.abc.Iterable[global___Action] | None = ...,
        action_profiles: collections.abc.Iterable[global___ActionProfile] | None = ...,
        counters: collections.abc.Iterable[global___Counter] | None = ...,
        direct_counters: collections.abc.Iterable[global___DirectCounter] | None = ...,
        meters: collections.abc.Iterable[global___Meter] | None = ...,
        direct_meters: collections.abc.Iterable[global___DirectMeter] | None = ...,
        controller_packet_metadata: collections.abc.Iterable[global___ControllerPacketMetadata] | None = ...,
        value_sets: collections.abc.Iterable[global___ValueSet] | None = ...,
        registers: collections.abc.Iterable[global___Register] | None = ...,
        digests: collections.abc.Iterable[global___Digest] | None = ...,
        externs: collections.abc.Iterable[global___Extern] | None = ...,
        type_info: p4.config.v1.p4types_pb2.P4TypeInfo | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pkg_info", b"pkg_info", "type_info", b"type_info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action_profiles", b"action_profiles", "actions", b"actions", "controller_packet_metadata", b"controller_packet_metadata", "counters", b"counters", "digests", b"digests", "direct_counters", b"direct_counters", "direct_meters", b"direct_meters", "externs", b"externs", "meters", b"meters", "pkg_info", b"pkg_info", "registers", b"registers", "tables", b"tables", "type_info", b"type_info", "value_sets", b"value_sets"]) -> None: ...

global___P4Info = P4Info

@typing_extensions.final
class Documentation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BRIEF_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    brief: builtins.str
    """A brief description of something, e.g. one sentence"""
    description: builtins.str
    """A more verbose description of something. Multiline is accepted. Markup
    format (if any) is TBD.
    """
    def __init__(
        self,
        *,
        brief: builtins.str = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["brief", b"brief", "description", b"description"]) -> None: ...

global___Documentation = Documentation

@typing_extensions.final
class PkgInfo(google.protobuf.message.Message):
    """Top-level package documentation describing the forwarding pipeline config
    Can be used to manage multiple P4 packages.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    DOC_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    ANNOTATION_LOCATIONS_FIELD_NUMBER: builtins.int
    ARCH_FIELD_NUMBER: builtins.int
    ORGANIZATION_FIELD_NUMBER: builtins.int
    CONTACT_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    STRUCTURED_ANNOTATIONS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """a definitive name for this configuration, e.g. switch.p4_v1.0"""
    version: builtins.str
    """configuration version, free-format string"""
    @property
    def doc(self) -> global___Documentation:
        """brief and detailed descriptions"""
    @property
    def annotations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Miscellaneous metadata, free-form; a way to extend PkgInfo"""
    @property
    def annotation_locations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[p4.config.v1.p4types_pb2.SourceLocation]:
        """Optional. If present, the location of `annotations[i]` is given by
        `annotation_locations[i]`.
        """
    arch: builtins.str
    """the target architecture, e.g. "psa" """
    organization: builtins.str
    """organization which produced the configuration, e.g. "p4.org" """
    contact: builtins.str
    """contact info for support,e.g. "tech-support@acme.org" """
    url: builtins.str
    """url for more information, e.g.
    "http://support.p4.org/ref/p4/switch.p4_v1.0"
    """
    @property
    def structured_annotations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[p4.config.v1.p4types_pb2.StructuredAnnotation]:
        """Miscellaneous metadata, structured; a way to extend PkgInfo"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
        doc: global___Documentation | None = ...,
        annotations: collections.abc.Iterable[builtins.str] | None = ...,
        annotation_locations: collections.abc.Iterable[p4.config.v1.p4types_pb2.SourceLocation] | None = ...,
        arch: builtins.str = ...,
        organization: builtins.str = ...,
        contact: builtins.str = ...,
        url: builtins.str = ...,
        structured_annotations: collections.abc.Iterable[p4.config.v1.p4types_pb2.StructuredAnnotation] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["doc", b"doc"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotation_locations", b"annotation_locations", "annotations", b"annotations", "arch", b"arch", "contact", b"contact", "doc", b"doc", "name", b"name", "organization", b"organization", "structured_annotations", b"structured_annotations", "url", b"url", "version", b"version"]) -> None: ...

global___PkgInfo = PkgInfo

@typing_extensions.final
class P4Ids(google.protobuf.message.Message):
    """wrapping the enum in a message to avoid name collisions in C++, where "enum
    values are siblings of their type, not children of it"
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Prefix:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PrefixEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[P4Ids._Prefix.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: P4Ids._Prefix.ValueType  # 0
        ACTION: P4Ids._Prefix.ValueType  # 1
        """P4 language built-ins"""
        TABLE: P4Ids._Prefix.ValueType  # 2
        VALUE_SET: P4Ids._Prefix.ValueType  # 3
        CONTROLLER_HEADER: P4Ids._Prefix.ValueType  # 4
        PSA_EXTERNS_START: P4Ids._Prefix.ValueType  # 16
        """PSA externs"""
        ACTION_PROFILE: P4Ids._Prefix.ValueType  # 17
        COUNTER: P4Ids._Prefix.ValueType  # 18
        DIRECT_COUNTER: P4Ids._Prefix.ValueType  # 19
        METER: P4Ids._Prefix.ValueType  # 20
        DIRECT_METER: P4Ids._Prefix.ValueType  # 21
        REGISTER: P4Ids._Prefix.ValueType  # 22
        DIGEST: P4Ids._Prefix.ValueType  # 23
        OTHER_EXTERNS_START: P4Ids._Prefix.ValueType  # 128
        """externs for other architectures (vendor extensions)"""
        MAX: P4Ids._Prefix.ValueType  # 255
        """max value for an unsigned 8-bit byte
        requires protoc >= 3.5.0
        reserved 0x100 to max;
        """

    class Prefix(_Prefix, metaclass=_PrefixEnumTypeWrapper):
        """ids are allocated in such a way that it is possible based on an id to
        deduce the resource type (e.g. table, action, counter, ...). The
        most-significant byte of the 32-bit id encodes the resource type. The
        purpose of this enum is to define which value is used as the
        most-significant byte for each resource type. The P4 compiler must use
        these values when allocating ids for P4 objects. Other users of P4Info can
        refer to this enum to identify a resource type based on its id.
        """

    UNSPECIFIED: P4Ids.Prefix.ValueType  # 0
    ACTION: P4Ids.Prefix.ValueType  # 1
    """P4 language built-ins"""
    TABLE: P4Ids.Prefix.ValueType  # 2
    VALUE_SET: P4Ids.Prefix.ValueType  # 3
    CONTROLLER_HEADER: P4Ids.Prefix.ValueType  # 4
    PSA_EXTERNS_START: P4Ids.Prefix.ValueType  # 16
    """PSA externs"""
    ACTION_PROFILE: P4Ids.Prefix.ValueType  # 17
    COUNTER: P4Ids.Prefix.ValueType  # 18
    DIRECT_COUNTER: P4Ids.Prefix.ValueType  # 19
    METER: P4Ids.Prefix.ValueType  # 20
    DIRECT_METER: P4Ids.Prefix.ValueType  # 21
    REGISTER: P4Ids.Prefix.ValueType  # 22
    DIGEST: P4Ids.Prefix.ValueType  # 23
    OTHER_EXTERNS_START: P4Ids.Prefix.ValueType  # 128
    """externs for other architectures (vendor extensions)"""
    MAX: P4Ids.Prefix.ValueType  # 255
    """max value for an unsigned 8-bit byte
    requires protoc >= 3.5.0
    reserved 0x100 to max;
    """

    def __init__(
        self,
    ) -> None: ...

global___P4Ids = P4Ids

@typing_extensions.final
class Preamble(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    ALIAS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    ANNOTATION_LOCATIONS_FIELD_NUMBER: builtins.int
    DOC_FIELD_NUMBER: builtins.int
    STRUCTURED_ANNOTATIONS_FIELD_NUMBER: builtins.int
    id: builtins.int
    """ids share the same number-space; e.g. table ids cannot overlap with counter
    ids. Even though this is irrelevant to this proto definition, the ids are
    allocated in such a way that it is possible based on an id to deduce the
    resource type (e.g. table, action, counter, ...). This means that code
    using these ids can detect if the wrong resource type is used
    somewhere. This also means that ids of different types can be mixed
    (e.g. direct resource list for a table) without ambiguity. Note that id 0
    is reserved and means "invalid id".
    """
    name: builtins.str
    """fully qualified name of the P4 object, e.g. c1.c2.ipv4_lpm"""
    alias: builtins.str
    """an alias (alternative name) for the P4 object, probably shorter than its
    fully qualified name. The only constraint is for it to be unique with
    respect to other P4 objects of the same type. By default, the compiler uses
    the shortest suffix of the name that uniquely identifies the object. For
    example if the P4 program contains two tables with names s.c1.t and s.c2.t,
    the default aliases will respectively be c1.t and c2.t. In the future, the
    P4 programmer may also be able to override the default alias for any P4
    object (TBD).
    """
    @property
    def annotations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def annotation_locations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[p4.config.v1.p4types_pb2.SourceLocation]:
        """Optional. If present, the location of `annotations[i]` is given by
        `annotation_locations[i]`.
        """
    @property
    def doc(self) -> global___Documentation:
        """Documentation of the entity"""
    @property
    def structured_annotations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[p4.config.v1.p4types_pb2.StructuredAnnotation]: ...
    def __init__(
        self,
        *,
        id: builtins.int = ...,
        name: builtins.str = ...,
        alias: builtins.str = ...,
        annotations: collections.abc.Iterable[builtins.str] | None = ...,
        annotation_locations: collections.abc.Iterable[p4.config.v1.p4types_pb2.SourceLocation] | None = ...,
        doc: global___Documentation | None = ...,
        structured_annotations: collections.abc.Iterable[p4.config.v1.p4types_pb2.StructuredAnnotation] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["doc", b"doc"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["alias", b"alias", "annotation_locations", b"annotation_locations", "annotations", b"annotations", "doc", b"doc", "id", b"id", "name", b"name", "structured_annotations", b"structured_annotations"]) -> None: ...

global___Preamble = Preamble

@typing_extensions.final
class Extern(google.protobuf.message.Message):
    """used to group all extern instances of the same type in one message"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXTERN_TYPE_ID_FIELD_NUMBER: builtins.int
    EXTERN_TYPE_NAME_FIELD_NUMBER: builtins.int
    INSTANCES_FIELD_NUMBER: builtins.int
    extern_type_id: builtins.int
    """the extern_type_id is unique for a given architecture and must be in the
    range [0x81, 0xfe].
    """
    extern_type_name: builtins.str
    @property
    def instances(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ExternInstance]: ...
    def __init__(
        self,
        *,
        extern_type_id: builtins.int = ...,
        extern_type_name: builtins.str = ...,
        instances: collections.abc.Iterable[global___ExternInstance] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["extern_type_id", b"extern_type_id", "extern_type_name", b"extern_type_name", "instances", b"instances"]) -> None: ...

global___Extern = Extern

@typing_extensions.final
class ExternInstance(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREAMBLE_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    @property
    def preamble(self) -> global___Preamble: ...
    @property
    def info(self) -> google.protobuf.any_pb2.Any:
        """specific to the extern type, declared in a separate vendor-specific proto
        file
        """
    def __init__(
        self,
        *,
        preamble: global___Preamble | None = ...,
        info: google.protobuf.any_pb2.Any | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["info", b"info", "preamble", b"preamble"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["info", b"info", "preamble", b"preamble"]) -> None: ...

global___ExternInstance = ExternInstance

@typing_extensions.final
class MatchField(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _MatchType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _MatchTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MatchField._MatchType.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: MatchField._MatchType.ValueType  # 0
        EXACT: MatchField._MatchType.ValueType  # 2
        LPM: MatchField._MatchType.ValueType  # 3
        TERNARY: MatchField._MatchType.ValueType  # 4
        RANGE: MatchField._MatchType.ValueType  # 5
        OPTIONAL: MatchField._MatchType.ValueType  # 6

    class MatchType(_MatchType, metaclass=_MatchTypeEnumTypeWrapper): ...
    UNSPECIFIED: MatchField.MatchType.ValueType  # 0
    EXACT: MatchField.MatchType.ValueType  # 2
    LPM: MatchField.MatchType.ValueType  # 3
    TERNARY: MatchField.MatchType.ValueType  # 4
    RANGE: MatchField.MatchType.ValueType  # 5
    OPTIONAL: MatchField.MatchType.ValueType  # 6

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    ANNOTATION_LOCATIONS_FIELD_NUMBER: builtins.int
    BITWIDTH_FIELD_NUMBER: builtins.int
    MATCH_TYPE_FIELD_NUMBER: builtins.int
    OTHER_MATCH_TYPE_FIELD_NUMBER: builtins.int
    DOC_FIELD_NUMBER: builtins.int
    TYPE_NAME_FIELD_NUMBER: builtins.int
    STRUCTURED_ANNOTATIONS_FIELD_NUMBER: builtins.int
    id: builtins.int
    name: builtins.str
    @property
    def annotations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def annotation_locations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[p4.config.v1.p4types_pb2.SourceLocation]:
        """Optional. If present, the location of `annotations[i]` is given by
        `annotation_locations[i]`.
        """
    bitwidth: builtins.int
    match_type: global___MatchField.MatchType.ValueType
    other_match_type: builtins.str
    """used for architecture-specific match types which are not part of the core
    P4 language or of the PSA architecture.
    """
    @property
    def doc(self) -> global___Documentation:
        """Documentation of the match field"""
    @property
    def type_name(self) -> p4.config.v1.p4types_pb2.P4NamedType:
        """unset if not user-defined type"""
    @property
    def structured_annotations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[p4.config.v1.p4types_pb2.StructuredAnnotation]: ...
    def __init__(
        self,
        *,
        id: builtins.int = ...,
        name: builtins.str = ...,
        annotations: collections.abc.Iterable[builtins.str] | None = ...,
        annotation_locations: collections.abc.Iterable[p4.config.v1.p4types_pb2.SourceLocation] | None = ...,
        bitwidth: builtins.int = ...,
        match_type: global___MatchField.MatchType.ValueType = ...,
        other_match_type: builtins.str = ...,
        doc: global___Documentation | None = ...,
        type_name: p4.config.v1.p4types_pb2.P4NamedType | None = ...,
        structured_annotations: collections.abc.Iterable[p4.config.v1.p4types_pb2.StructuredAnnotation] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["doc", b"doc", "match", b"match", "match_type", b"match_type", "other_match_type", b"other_match_type", "type_name", b"type_name"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotation_locations", b"annotation_locations", "annotations", b"annotations", "bitwidth", b"bitwidth", "doc", b"doc", "id", b"id", "match", b"match", "match_type", b"match_type", "name", b"name", "other_match_type", b"other_match_type", "structured_annotations", b"structured_annotations", "type_name", b"type_name"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["match", b"match"]) -> typing_extensions.Literal["match_type", "other_match_type"] | None: ...

global___MatchField = MatchField

@typing_extensions.final
class Table(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _IdleTimeoutBehavior:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _IdleTimeoutBehaviorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Table._IdleTimeoutBehavior.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NO_TIMEOUT: Table._IdleTimeoutBehavior.ValueType  # 0
        NOTIFY_CONTROL: Table._IdleTimeoutBehavior.ValueType  # 1

    class IdleTimeoutBehavior(_IdleTimeoutBehavior, metaclass=_IdleTimeoutBehaviorEnumTypeWrapper):
        """this enum can be extended in the future with other behaviors, such as
        "HARD_EVICTION"
        """

    NO_TIMEOUT: Table.IdleTimeoutBehavior.ValueType  # 0
    NOTIFY_CONTROL: Table.IdleTimeoutBehavior.ValueType  # 1

    PREAMBLE_FIELD_NUMBER: builtins.int
    MATCH_FIELDS_FIELD_NUMBER: builtins.int
    ACTION_REFS_FIELD_NUMBER: builtins.int
    CONST_DEFAULT_ACTION_ID_FIELD_NUMBER: builtins.int
    IMPLEMENTATION_ID_FIELD_NUMBER: builtins.int
    DIRECT_RESOURCE_IDS_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    IDLE_TIMEOUT_BEHAVIOR_FIELD_NUMBER: builtins.int
    IS_CONST_TABLE_FIELD_NUMBER: builtins.int
    OTHER_PROPERTIES_FIELD_NUMBER: builtins.int
    @property
    def preamble(self) -> global___Preamble: ...
    @property
    def match_fields(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MatchField]: ...
    @property
    def action_refs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ActionRef]:
        """even when the table is indirect (see implementation_id) below, this field
        includes all possible actions for the table; by using ActionRef instead of
        a repeated field of action ids, each action reference in a P4 table is able
        to have its own annotations
        """
    const_default_action_id: builtins.int
    """0 (default value) means that the table does not have a const default action"""
    implementation_id: builtins.int
    """P4 id of the "implementation" for this table (e.g. action profile id); 0
    (default value) means that the table is a regular (direct) match table. As
    of today, only action profiles are supported but other table
    implementations may be added in the future
    """
    @property
    def direct_resource_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """ids of the direct resources (if any) attached to this table; for now this
        includes only direct counters and direct meters, but other resources may be
        added in the future
        """
    size: builtins.int
    """max number of entries in table"""
    idle_timeout_behavior: global___Table.IdleTimeoutBehavior.ValueType
    """is idle timeout supported for this table?"""
    is_const_table: builtins.bool
    """table with static P4 entries, cannot be modified at runtime"""
    @property
    def other_properties(self) -> google.protobuf.any_pb2.Any:
        """architecture-specific table properties which are not part of the core P4
        language or of the PSA architecture.
        """
    def __init__(
        self,
        *,
        preamble: global___Preamble | None = ...,
        match_fields: collections.abc.Iterable[global___MatchField] | None = ...,
        action_refs: collections.abc.Iterable[global___ActionRef] | None = ...,
        const_default_action_id: builtins.int = ...,
        implementation_id: builtins.int = ...,
        direct_resource_ids: collections.abc.Iterable[builtins.int] | None = ...,
        size: builtins.int = ...,
        idle_timeout_behavior: global___Table.IdleTimeoutBehavior.ValueType = ...,
        is_const_table: builtins.bool = ...,
        other_properties: google.protobuf.any_pb2.Any | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["other_properties", b"other_properties", "preamble", b"preamble"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action_refs", b"action_refs", "const_default_action_id", b"const_default_action_id", "direct_resource_ids", b"direct_resource_ids", "idle_timeout_behavior", b"idle_timeout_behavior", "implementation_id", b"implementation_id", "is_const_table", b"is_const_table", "match_fields", b"match_fields", "other_properties", b"other_properties", "preamble", b"preamble", "size", b"size"]) -> None: ...

global___Table = Table

@typing_extensions.final
class ActionRef(google.protobuf.message.Message):
    """used to list all possible actions in a Table"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Scope:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ScopeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ActionRef._Scope.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TABLE_AND_DEFAULT: ActionRef._Scope.ValueType  # 0
        TABLE_ONLY: ActionRef._Scope.ValueType  # 1
        DEFAULT_ONLY: ActionRef._Scope.ValueType  # 2

    class Scope(_Scope, metaclass=_ScopeEnumTypeWrapper): ...
    TABLE_AND_DEFAULT: ActionRef.Scope.ValueType  # 0
    TABLE_ONLY: ActionRef.Scope.ValueType  # 1
    DEFAULT_ONLY: ActionRef.Scope.ValueType  # 2

    ID_FIELD_NUMBER: builtins.int
    SCOPE_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    ANNOTATION_LOCATIONS_FIELD_NUMBER: builtins.int
    STRUCTURED_ANNOTATIONS_FIELD_NUMBER: builtins.int
    id: builtins.int
    scope: global___ActionRef.Scope.ValueType
    @property
    def annotations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def annotation_locations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[p4.config.v1.p4types_pb2.SourceLocation]:
        """Optional. If present, the location of `annotations[i]` is given by
        `annotation_locations[i]`.
        """
    @property
    def structured_annotations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[p4.config.v1.p4types_pb2.StructuredAnnotation]: ...
    def __init__(
        self,
        *,
        id: builtins.int = ...,
        scope: global___ActionRef.Scope.ValueType = ...,
        annotations: collections.abc.Iterable[builtins.str] | None = ...,
        annotation_locations: collections.abc.Iterable[p4.config.v1.p4types_pb2.SourceLocation] | None = ...,
        structured_annotations: collections.abc.Iterable[p4.config.v1.p4types_pb2.StructuredAnnotation] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotation_locations", b"annotation_locations", "annotations", b"annotations", "id", b"id", "scope", b"scope", "structured_annotations", b"structured_annotations"]) -> None: ...

global___ActionRef = ActionRef

@typing_extensions.final
class Action(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Param(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ID_FIELD_NUMBER: builtins.int
        NAME_FIELD_NUMBER: builtins.int
        ANNOTATIONS_FIELD_NUMBER: builtins.int
        ANNOTATION_LOCATIONS_FIELD_NUMBER: builtins.int
        BITWIDTH_FIELD_NUMBER: builtins.int
        DOC_FIELD_NUMBER: builtins.int
        TYPE_NAME_FIELD_NUMBER: builtins.int
        STRUCTURED_ANNOTATIONS_FIELD_NUMBER: builtins.int
        id: builtins.int
        name: builtins.str
        @property
        def annotations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        @property
        def annotation_locations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[p4.config.v1.p4types_pb2.SourceLocation]:
            """Optional. If present, the location of `annotations[i]` is given by
            `annotation_locations[i]`.
            """
        bitwidth: builtins.int
        @property
        def doc(self) -> global___Documentation:
            """Documentation of the Param"""
        @property
        def type_name(self) -> p4.config.v1.p4types_pb2.P4NamedType:
            """unset if not user-defined type"""
        @property
        def structured_annotations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[p4.config.v1.p4types_pb2.StructuredAnnotation]: ...
        def __init__(
            self,
            *,
            id: builtins.int = ...,
            name: builtins.str = ...,
            annotations: collections.abc.Iterable[builtins.str] | None = ...,
            annotation_locations: collections.abc.Iterable[p4.config.v1.p4types_pb2.SourceLocation] | None = ...,
            bitwidth: builtins.int = ...,
            doc: global___Documentation | None = ...,
            type_name: p4.config.v1.p4types_pb2.P4NamedType | None = ...,
            structured_annotations: collections.abc.Iterable[p4.config.v1.p4types_pb2.StructuredAnnotation] | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["doc", b"doc", "type_name", b"type_name"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["annotation_locations", b"annotation_locations", "annotations", b"annotations", "bitwidth", b"bitwidth", "doc", b"doc", "id", b"id", "name", b"name", "structured_annotations", b"structured_annotations", "type_name", b"type_name"]) -> None: ...

    PREAMBLE_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    @property
    def preamble(self) -> global___Preamble: ...
    @property
    def params(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Action.Param]: ...
    def __init__(
        self,
        *,
        preamble: global___Preamble | None = ...,
        params: collections.abc.Iterable[global___Action.Param] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["preamble", b"preamble"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["params", b"params", "preamble", b"preamble"]) -> None: ...

global___Action = Action

@typing_extensions.final
class ActionProfile(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class SumOfWeights(google.protobuf.message.Message):
        """indicates that `size` and `max_group_size` represent the maximum sum of
        weights that can be present across all selector groups and within a
        single selector group respectively.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(
            self,
        ) -> None: ...

    @typing_extensions.final
    class SumOfMembers(google.protobuf.message.Message):
        """indicates that `size` and `max_group_size` represent the maximum number
        of members that can be present across all selector groups and within a
        single selector group respectively.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        MAX_MEMBER_WEIGHT_FIELD_NUMBER: builtins.int
        max_member_weight: builtins.int
        """the maximum weight of each individual member in a group."""
        def __init__(
            self,
            *,
            max_member_weight: builtins.int | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["_max_member_weight", b"_max_member_weight", "max_member_weight", b"max_member_weight"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["_max_member_weight", b"_max_member_weight", "max_member_weight", b"max_member_weight"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["_max_member_weight", b"_max_member_weight"]) -> typing_extensions.Literal["max_member_weight"] | None: ...

    PREAMBLE_FIELD_NUMBER: builtins.int
    TABLE_IDS_FIELD_NUMBER: builtins.int
    WITH_SELECTOR_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    MAX_GROUP_SIZE_FIELD_NUMBER: builtins.int
    SUM_OF_WEIGHTS_FIELD_NUMBER: builtins.int
    SUM_OF_MEMBERS_FIELD_NUMBER: builtins.int
    @property
    def preamble(self) -> global___Preamble: ...
    @property
    def table_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """the ids of the tables sharing this action profile"""
    with_selector: builtins.bool
    """true iff the action profile used dynamic selection"""
    size: builtins.int
    """max number of member entries across all groups if the action profile does
    not have a selector. Otherwise, semantics as specified by
    `selector_size_semantics` below.
    """
    max_group_size: builtins.int
    """0 if the action profile does not have a selector. Otherwise, semantics as
    specified by `selector_size_semantics` below.
    """
    @property
    def sum_of_weights(self) -> global___ActionProfile.SumOfWeights:
        """group size is the sum of the group's weights."""
    @property
    def sum_of_members(self) -> global___ActionProfile.SumOfMembers:
        """group size is the sum of the group's members."""
    def __init__(
        self,
        *,
        preamble: global___Preamble | None = ...,
        table_ids: collections.abc.Iterable[builtins.int] | None = ...,
        with_selector: builtins.bool = ...,
        size: builtins.int = ...,
        max_group_size: builtins.int = ...,
        sum_of_weights: global___ActionProfile.SumOfWeights | None = ...,
        sum_of_members: global___ActionProfile.SumOfMembers | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["preamble", b"preamble", "selector_size_semantics", b"selector_size_semantics", "sum_of_members", b"sum_of_members", "sum_of_weights", b"sum_of_weights"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["max_group_size", b"max_group_size", "preamble", b"preamble", "selector_size_semantics", b"selector_size_semantics", "size", b"size", "sum_of_members", b"sum_of_members", "sum_of_weights", b"sum_of_weights", "table_ids", b"table_ids", "with_selector", b"with_selector"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["selector_size_semantics", b"selector_size_semantics"]) -> typing_extensions.Literal["sum_of_weights", "sum_of_members"] | None: ...

global___ActionProfile = ActionProfile

@typing_extensions.final
class CounterSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Unit:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _UnitEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[CounterSpec._Unit.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: CounterSpec._Unit.ValueType  # 0
        BYTES: CounterSpec._Unit.ValueType  # 1
        PACKETS: CounterSpec._Unit.ValueType  # 2
        BOTH: CounterSpec._Unit.ValueType  # 3

    class Unit(_Unit, metaclass=_UnitEnumTypeWrapper):
        """Corresponds to 'type' constructor parameter for Counter / DirectCounter in
        PSA
        """

    UNSPECIFIED: CounterSpec.Unit.ValueType  # 0
    BYTES: CounterSpec.Unit.ValueType  # 1
    PACKETS: CounterSpec.Unit.ValueType  # 2
    BOTH: CounterSpec.Unit.ValueType  # 3

    UNIT_FIELD_NUMBER: builtins.int
    unit: global___CounterSpec.Unit.ValueType
    def __init__(
        self,
        *,
        unit: global___CounterSpec.Unit.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["unit", b"unit"]) -> None: ...

global___CounterSpec = CounterSpec

@typing_extensions.final
class Counter(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREAMBLE_FIELD_NUMBER: builtins.int
    SPEC_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    INDEX_TYPE_NAME_FIELD_NUMBER: builtins.int
    @property
    def preamble(self) -> global___Preamble: ...
    @property
    def spec(self) -> global___CounterSpec: ...
    size: builtins.int
    """number of entries in the counter array"""
    @property
    def index_type_name(self) -> p4.config.v1.p4types_pb2.P4NamedType:
        """unset if index is not user-defined type"""
    def __init__(
        self,
        *,
        preamble: global___Preamble | None = ...,
        spec: global___CounterSpec | None = ...,
        size: builtins.int = ...,
        index_type_name: p4.config.v1.p4types_pb2.P4NamedType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["index_type_name", b"index_type_name", "preamble", b"preamble", "spec", b"spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["index_type_name", b"index_type_name", "preamble", b"preamble", "size", b"size", "spec", b"spec"]) -> None: ...

global___Counter = Counter

@typing_extensions.final
class DirectCounter(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREAMBLE_FIELD_NUMBER: builtins.int
    SPEC_FIELD_NUMBER: builtins.int
    DIRECT_TABLE_ID_FIELD_NUMBER: builtins.int
    @property
    def preamble(self) -> global___Preamble: ...
    @property
    def spec(self) -> global___CounterSpec: ...
    direct_table_id: builtins.int
    """the id of the table to which the counter is attached"""
    def __init__(
        self,
        *,
        preamble: global___Preamble | None = ...,
        spec: global___CounterSpec | None = ...,
        direct_table_id: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["preamble", b"preamble", "spec", b"spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["direct_table_id", b"direct_table_id", "preamble", b"preamble", "spec", b"spec"]) -> None: ...

global___DirectCounter = DirectCounter

@typing_extensions.final
class MeterSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Unit:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _UnitEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MeterSpec._Unit.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: MeterSpec._Unit.ValueType  # 0
        BYTES: MeterSpec._Unit.ValueType  # 1
        PACKETS: MeterSpec._Unit.ValueType  # 2

    class Unit(_Unit, metaclass=_UnitEnumTypeWrapper):
        """Corresponds to 'type' constructor parameter for Meter / DirectMeter in PSA"""

    UNSPECIFIED: MeterSpec.Unit.ValueType  # 0
    BYTES: MeterSpec.Unit.ValueType  # 1
    PACKETS: MeterSpec.Unit.ValueType  # 2

    UNIT_FIELD_NUMBER: builtins.int
    unit: global___MeterSpec.Unit.ValueType
    def __init__(
        self,
        *,
        unit: global___MeterSpec.Unit.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["unit", b"unit"]) -> None: ...

global___MeterSpec = MeterSpec

@typing_extensions.final
class Meter(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREAMBLE_FIELD_NUMBER: builtins.int
    SPEC_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    INDEX_TYPE_NAME_FIELD_NUMBER: builtins.int
    @property
    def preamble(self) -> global___Preamble: ...
    @property
    def spec(self) -> global___MeterSpec: ...
    size: builtins.int
    """number of entries in the meter array"""
    @property
    def index_type_name(self) -> p4.config.v1.p4types_pb2.P4NamedType:
        """unset if index is not user-defined type"""
    def __init__(
        self,
        *,
        preamble: global___Preamble | None = ...,
        spec: global___MeterSpec | None = ...,
        size: builtins.int = ...,
        index_type_name: p4.config.v1.p4types_pb2.P4NamedType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["index_type_name", b"index_type_name", "preamble", b"preamble", "spec", b"spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["index_type_name", b"index_type_name", "preamble", b"preamble", "size", b"size", "spec", b"spec"]) -> None: ...

global___Meter = Meter

@typing_extensions.final
class DirectMeter(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREAMBLE_FIELD_NUMBER: builtins.int
    SPEC_FIELD_NUMBER: builtins.int
    DIRECT_TABLE_ID_FIELD_NUMBER: builtins.int
    @property
    def preamble(self) -> global___Preamble: ...
    @property
    def spec(self) -> global___MeterSpec: ...
    direct_table_id: builtins.int
    """the id of the table to which the meter is attached"""
    def __init__(
        self,
        *,
        preamble: global___Preamble | None = ...,
        spec: global___MeterSpec | None = ...,
        direct_table_id: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["preamble", b"preamble", "spec", b"spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["direct_table_id", b"direct_table_id", "preamble", b"preamble", "spec", b"spec"]) -> None: ...

global___DirectMeter = DirectMeter

@typing_extensions.final
class ControllerPacketMetadata(google.protobuf.message.Message):
    """Any metadata associated with controller Packet-IO (Packet-In or Packet-Out)
    is modeled as P4 headers carrying special annotations
    @controller_header("packet_out") and @controller_header("packet_in")
    respectively. There can be at most one header each with these annotations.
    This message captures the info contained within these special headers,
    and used in p4runtime.proto to supply the metadata.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Metadata(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ID_FIELD_NUMBER: builtins.int
        NAME_FIELD_NUMBER: builtins.int
        ANNOTATIONS_FIELD_NUMBER: builtins.int
        ANNOTATION_LOCATIONS_FIELD_NUMBER: builtins.int
        BITWIDTH_FIELD_NUMBER: builtins.int
        TYPE_NAME_FIELD_NUMBER: builtins.int
        STRUCTURED_ANNOTATIONS_FIELD_NUMBER: builtins.int
        id: builtins.int
        name: builtins.str
        """This is the name of the header field (not fully-qualified), similar
        to e.g. Action.Param.name.
        """
        @property
        def annotations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        @property
        def annotation_locations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[p4.config.v1.p4types_pb2.SourceLocation]:
            """Optional. If present, the location of `annotations[i]` is given by
            `annotation_locations[i]`.
            """
        bitwidth: builtins.int
        @property
        def type_name(self) -> p4.config.v1.p4types_pb2.P4NamedType:
            """unset if not user-defined type"""
        @property
        def structured_annotations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[p4.config.v1.p4types_pb2.StructuredAnnotation]: ...
        def __init__(
            self,
            *,
            id: builtins.int = ...,
            name: builtins.str = ...,
            annotations: collections.abc.Iterable[builtins.str] | None = ...,
            annotation_locations: collections.abc.Iterable[p4.config.v1.p4types_pb2.SourceLocation] | None = ...,
            bitwidth: builtins.int = ...,
            type_name: p4.config.v1.p4types_pb2.P4NamedType | None = ...,
            structured_annotations: collections.abc.Iterable[p4.config.v1.p4types_pb2.StructuredAnnotation] | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["type_name", b"type_name"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["annotation_locations", b"annotation_locations", "annotations", b"annotations", "bitwidth", b"bitwidth", "id", b"id", "name", b"name", "structured_annotations", b"structured_annotations", "type_name", b"type_name"]) -> None: ...

    PREAMBLE_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    @property
    def preamble(self) -> global___Preamble:
        """preamble.name and preamble.id will specify header type ("packet_out" or
        "packet_in" for now).
        """
    @property
    def metadata(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ControllerPacketMetadata.Metadata]:
        """Ordered based on header layout.
        This is a constraint on the generator of this P4Info.
        """
    def __init__(
        self,
        *,
        preamble: global___Preamble | None = ...,
        metadata: collections.abc.Iterable[global___ControllerPacketMetadata.Metadata] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["preamble", b"preamble"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "preamble", b"preamble"]) -> None: ...

global___ControllerPacketMetadata = ControllerPacketMetadata

@typing_extensions.final
class ValueSet(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREAMBLE_FIELD_NUMBER: builtins.int
    MATCH_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    @property
    def preamble(self) -> global___Preamble: ...
    @property
    def match(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MatchField]: ...
    size: builtins.int
    """number of entries in the value_set, as per the P4 constructor call."""
    def __init__(
        self,
        *,
        preamble: global___Preamble | None = ...,
        match: collections.abc.Iterable[global___MatchField] | None = ...,
        size: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["preamble", b"preamble"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["match", b"match", "preamble", b"preamble", "size", b"size"]) -> None: ...

global___ValueSet = ValueSet

@typing_extensions.final
class Register(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREAMBLE_FIELD_NUMBER: builtins.int
    TYPE_SPEC_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    INDEX_TYPE_NAME_FIELD_NUMBER: builtins.int
    @property
    def preamble(self) -> global___Preamble: ...
    @property
    def type_spec(self) -> p4.config.v1.p4types_pb2.P4DataTypeSpec: ...
    size: builtins.int
    @property
    def index_type_name(self) -> p4.config.v1.p4types_pb2.P4NamedType:
        """unset if index is not user-defined type"""
    def __init__(
        self,
        *,
        preamble: global___Preamble | None = ...,
        type_spec: p4.config.v1.p4types_pb2.P4DataTypeSpec | None = ...,
        size: builtins.int = ...,
        index_type_name: p4.config.v1.p4types_pb2.P4NamedType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["index_type_name", b"index_type_name", "preamble", b"preamble", "type_spec", b"type_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["index_type_name", b"index_type_name", "preamble", b"preamble", "size", b"size", "type_spec", b"type_spec"]) -> None: ...

global___Register = Register

@typing_extensions.final
class Digest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREAMBLE_FIELD_NUMBER: builtins.int
    TYPE_SPEC_FIELD_NUMBER: builtins.int
    @property
    def preamble(self) -> global___Preamble: ...
    @property
    def type_spec(self) -> p4.config.v1.p4types_pb2.P4DataTypeSpec: ...
    def __init__(
        self,
        *,
        preamble: global___Preamble | None = ...,
        type_spec: p4.config.v1.p4types_pb2.P4DataTypeSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["preamble", b"preamble", "type_spec", b"type_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["preamble", b"preamble", "type_spec", b"type_spec"]) -> None: ...

global___Digest = Digest
