"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2013-present Barefoot Networks, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class P4TypeInfo(google.protobuf.message.Message):
    """|--------------------|--------------------------------------------|
    |                    | Container type                             |
    | Element type       |-----------|--------------|-----------------|
    |                    | header    | header_union | struct or tuple |
    |--------------------|-----------|--------------|-----------------|
    | bit<W>             | allowed   | error        | allowed         |
    | int<W>             | allowed   | error        | allowed         |
    | varbit<W>          | allowed   | error        | allowed         |
    | int                | error     | error        | error           |
    | void               | error     | error        | error           |
    | error              | error     | error        | allowed         |
    | match_kind         | error     | error        | error           |
    | bool               | error     | error        | allowed         |
    | enum               | allowed*  | error        | allowed         |
    | header             | error     | allowed      | allowed         |
    | header stack       | error     | error        | allowed         |
    | header_union       | error     | error        | allowed         |
    | struct             | error     | error        | allowed         |
    | tuple              | error     | error        | allowed         |
    |--------------------|-----------|--------------|-----------------|

    *if serializable

    These P4 types (struct, header_type, header_union and enum) are guaranteed to
    have a fully-qualified name (e.g. you cannot use an anonymous struct to
    declare a variable like in C). Instead of duplicating the type spec for these
    every time the type is used, we include the type spec once in this P4TypeInfo
    message and refer to the types by name in the P4DataTypeSpec message. We also
    support annotations for these type specs which can be useful, e.g. to
    identify well-known headers (such as ipv4).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class StructsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___P4StructTypeSpec: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___P4StructTypeSpec | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class HeadersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___P4HeaderTypeSpec: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___P4HeaderTypeSpec | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class HeaderUnionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___P4HeaderUnionTypeSpec: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___P4HeaderUnionTypeSpec | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class EnumsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___P4EnumTypeSpec: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___P4EnumTypeSpec | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class SerializableEnumsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___P4SerializableEnumTypeSpec: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___P4SerializableEnumTypeSpec | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class NewTypesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___P4NewTypeSpec: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___P4NewTypeSpec | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    STRUCTS_FIELD_NUMBER: builtins.int
    HEADERS_FIELD_NUMBER: builtins.int
    HEADER_UNIONS_FIELD_NUMBER: builtins.int
    ENUMS_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    SERIALIZABLE_ENUMS_FIELD_NUMBER: builtins.int
    NEW_TYPES_FIELD_NUMBER: builtins.int
    @property
    def structs(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___P4StructTypeSpec]: ...
    @property
    def headers(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___P4HeaderTypeSpec]: ...
    @property
    def header_unions(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___P4HeaderUnionTypeSpec]: ...
    @property
    def enums(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___P4EnumTypeSpec]: ...
    @property
    def error(self) -> global___P4ErrorTypeSpec: ...
    @property
    def serializable_enums(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___P4SerializableEnumTypeSpec]: ...
    @property
    def new_types(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___P4NewTypeSpec]: ...
    def __init__(
        self,
        *,
        structs: collections.abc.Mapping[builtins.str, global___P4StructTypeSpec] | None = ...,
        headers: collections.abc.Mapping[builtins.str, global___P4HeaderTypeSpec] | None = ...,
        header_unions: collections.abc.Mapping[builtins.str, global___P4HeaderUnionTypeSpec] | None = ...,
        enums: collections.abc.Mapping[builtins.str, global___P4EnumTypeSpec] | None = ...,
        error: global___P4ErrorTypeSpec | None = ...,
        serializable_enums: collections.abc.Mapping[builtins.str, global___P4SerializableEnumTypeSpec] | None = ...,
        new_types: collections.abc.Mapping[builtins.str, global___P4NewTypeSpec] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["error", b"error"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["enums", b"enums", "error", b"error", "header_unions", b"header_unions", "headers", b"headers", "new_types", b"new_types", "serializable_enums", b"serializable_enums", "structs", b"structs"]) -> None: ...

global___P4TypeInfo = P4TypeInfo

@typing_extensions.final
class P4DataTypeSpec(google.protobuf.message.Message):
    """Describes a P4_16 type."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BITSTRING_FIELD_NUMBER: builtins.int
    BOOL_FIELD_NUMBER: builtins.int
    TUPLE_FIELD_NUMBER: builtins.int
    STRUCT_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    HEADER_UNION_FIELD_NUMBER: builtins.int
    HEADER_STACK_FIELD_NUMBER: builtins.int
    HEADER_UNION_STACK_FIELD_NUMBER: builtins.int
    ENUM_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    SERIALIZABLE_ENUM_FIELD_NUMBER: builtins.int
    NEW_TYPE_FIELD_NUMBER: builtins.int
    @property
    def bitstring(self) -> global___P4BitstringLikeTypeSpec: ...
    @property
    def bool(self) -> global___P4BoolType: ...
    @property
    def tuple(self) -> global___P4TupleTypeSpec: ...
    @property
    def struct(self) -> global___P4NamedType: ...
    @property
    def header(self) -> global___P4NamedType: ...
    @property
    def header_union(self) -> global___P4NamedType: ...
    @property
    def header_stack(self) -> global___P4HeaderStackTypeSpec: ...
    @property
    def header_union_stack(self) -> global___P4HeaderUnionStackTypeSpec: ...
    @property
    def enum(self) -> global___P4NamedType: ...
    @property
    def error(self) -> global___P4ErrorType: ...
    @property
    def serializable_enum(self) -> global___P4NamedType: ...
    @property
    def new_type(self) -> global___P4NamedType: ...
    def __init__(
        self,
        *,
        bitstring: global___P4BitstringLikeTypeSpec | None = ...,
        bool: global___P4BoolType | None = ...,
        tuple: global___P4TupleTypeSpec | None = ...,
        struct: global___P4NamedType | None = ...,
        header: global___P4NamedType | None = ...,
        header_union: global___P4NamedType | None = ...,
        header_stack: global___P4HeaderStackTypeSpec | None = ...,
        header_union_stack: global___P4HeaderUnionStackTypeSpec | None = ...,
        enum: global___P4NamedType | None = ...,
        error: global___P4ErrorType | None = ...,
        serializable_enum: global___P4NamedType | None = ...,
        new_type: global___P4NamedType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["bitstring", b"bitstring", "bool", b"bool", "enum", b"enum", "error", b"error", "header", b"header", "header_stack", b"header_stack", "header_union", b"header_union", "header_union_stack", b"header_union_stack", "new_type", b"new_type", "serializable_enum", b"serializable_enum", "struct", b"struct", "tuple", b"tuple", "type_spec", b"type_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bitstring", b"bitstring", "bool", b"bool", "enum", b"enum", "error", b"error", "header", b"header", "header_stack", b"header_stack", "header_union", b"header_union", "header_union_stack", b"header_union_stack", "new_type", b"new_type", "serializable_enum", b"serializable_enum", "struct", b"struct", "tuple", b"tuple", "type_spec", b"type_spec"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["type_spec", b"type_spec"]) -> typing_extensions.Literal["bitstring", "bool", "tuple", "struct", "header", "header_union", "header_stack", "header_union_stack", "enum", "error", "serializable_enum", "new_type"] | None: ...

global___P4DataTypeSpec = P4DataTypeSpec

@typing_extensions.final
class P4NamedType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___P4NamedType = P4NamedType

@typing_extensions.final
class P4BoolType(google.protobuf.message.Message):
    """Empty message as no type information needed, just used as a placeholder in
    the oneof to identify boolean types.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___P4BoolType = P4BoolType

@typing_extensions.final
class P4ErrorType(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___P4ErrorType = P4ErrorType

@typing_extensions.final
class P4BitstringLikeTypeSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BIT_FIELD_NUMBER: builtins.int
    INT_FIELD_NUMBER: builtins.int
    VARBIT_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    ANNOTATION_LOCATIONS_FIELD_NUMBER: builtins.int
    STRUCTURED_ANNOTATIONS_FIELD_NUMBER: builtins.int
    @property
    def bit(self) -> global___P4BitTypeSpec:
        """bit<W>"""
    @property
    def int(self) -> global___P4IntTypeSpec:
        """int<W>"""
    @property
    def varbit(self) -> global___P4VarbitTypeSpec:
        """varbit<W>"""
    @property
    def annotations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Useful to identify well-known types, such as IP address or Ethernet MAC
        address.
        """
    @property
    def annotation_locations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SourceLocation]:
        """Optional. If present, the location of `annotations[i]` is given by
        `annotation_locations[i]`.
        """
    @property
    def structured_annotations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StructuredAnnotation]: ...
    def __init__(
        self,
        *,
        bit: global___P4BitTypeSpec | None = ...,
        int: global___P4IntTypeSpec | None = ...,
        varbit: global___P4VarbitTypeSpec | None = ...,
        annotations: collections.abc.Iterable[builtins.str] | None = ...,
        annotation_locations: collections.abc.Iterable[global___SourceLocation] | None = ...,
        structured_annotations: collections.abc.Iterable[global___StructuredAnnotation] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["bit", b"bit", "int", b"int", "type_spec", b"type_spec", "varbit", b"varbit"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotation_locations", b"annotation_locations", "annotations", b"annotations", "bit", b"bit", "int", b"int", "structured_annotations", b"structured_annotations", "type_spec", b"type_spec", "varbit", b"varbit"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["type_spec", b"type_spec"]) -> typing_extensions.Literal["bit", "int", "varbit"] | None: ...

global___P4BitstringLikeTypeSpec = P4BitstringLikeTypeSpec

@typing_extensions.final
class P4BitTypeSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BITWIDTH_FIELD_NUMBER: builtins.int
    bitwidth: builtins.int
    def __init__(
        self,
        *,
        bitwidth: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bitwidth", b"bitwidth"]) -> None: ...

global___P4BitTypeSpec = P4BitTypeSpec

@typing_extensions.final
class P4IntTypeSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BITWIDTH_FIELD_NUMBER: builtins.int
    bitwidth: builtins.int
    def __init__(
        self,
        *,
        bitwidth: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bitwidth", b"bitwidth"]) -> None: ...

global___P4IntTypeSpec = P4IntTypeSpec

@typing_extensions.final
class P4VarbitTypeSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MAX_BITWIDTH_FIELD_NUMBER: builtins.int
    max_bitwidth: builtins.int
    def __init__(
        self,
        *,
        max_bitwidth: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["max_bitwidth", b"max_bitwidth"]) -> None: ...

global___P4VarbitTypeSpec = P4VarbitTypeSpec

@typing_extensions.final
class P4TupleTypeSpec(google.protobuf.message.Message):
    """From the P4_16 spec: "A tuple is similar to a struct, in that it holds
    multiple values. Unlike a struct type, tuples have no named fields."
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEMBERS_FIELD_NUMBER: builtins.int
    @property
    def members(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___P4DataTypeSpec]: ...
    def __init__(
        self,
        *,
        members: collections.abc.Iterable[global___P4DataTypeSpec] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["members", b"members"]) -> None: ...

global___P4TupleTypeSpec = P4TupleTypeSpec

@typing_extensions.final
class P4StructTypeSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Member(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        TYPE_SPEC_FIELD_NUMBER: builtins.int
        name: builtins.str
        @property
        def type_spec(self) -> global___P4DataTypeSpec: ...
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            type_spec: global___P4DataTypeSpec | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["type_spec", b"type_spec"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "type_spec", b"type_spec"]) -> None: ...

    MEMBERS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    ANNOTATION_LOCATIONS_FIELD_NUMBER: builtins.int
    STRUCTURED_ANNOTATIONS_FIELD_NUMBER: builtins.int
    @property
    def members(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___P4StructTypeSpec.Member]: ...
    @property
    def annotations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def annotation_locations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SourceLocation]:
        """Optional. If present, the location of `annotations[i]` is given by
        `annotation_locations[i]`.
        """
    @property
    def structured_annotations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StructuredAnnotation]: ...
    def __init__(
        self,
        *,
        members: collections.abc.Iterable[global___P4StructTypeSpec.Member] | None = ...,
        annotations: collections.abc.Iterable[builtins.str] | None = ...,
        annotation_locations: collections.abc.Iterable[global___SourceLocation] | None = ...,
        structured_annotations: collections.abc.Iterable[global___StructuredAnnotation] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotation_locations", b"annotation_locations", "annotations", b"annotations", "members", b"members", "structured_annotations", b"structured_annotations"]) -> None: ...

global___P4StructTypeSpec = P4StructTypeSpec

@typing_extensions.final
class P4HeaderTypeSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Member(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        TYPE_SPEC_FIELD_NUMBER: builtins.int
        name: builtins.str
        @property
        def type_spec(self) -> global___P4BitstringLikeTypeSpec: ...
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            type_spec: global___P4BitstringLikeTypeSpec | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["type_spec", b"type_spec"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "type_spec", b"type_spec"]) -> None: ...

    MEMBERS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    ANNOTATION_LOCATIONS_FIELD_NUMBER: builtins.int
    STRUCTURED_ANNOTATIONS_FIELD_NUMBER: builtins.int
    @property
    def members(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___P4HeaderTypeSpec.Member]: ...
    @property
    def annotations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def annotation_locations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SourceLocation]:
        """Optional. If present, the location of `annotations[i]` is given by
        `annotation_locations[i]`.
        """
    @property
    def structured_annotations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StructuredAnnotation]: ...
    def __init__(
        self,
        *,
        members: collections.abc.Iterable[global___P4HeaderTypeSpec.Member] | None = ...,
        annotations: collections.abc.Iterable[builtins.str] | None = ...,
        annotation_locations: collections.abc.Iterable[global___SourceLocation] | None = ...,
        structured_annotations: collections.abc.Iterable[global___StructuredAnnotation] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotation_locations", b"annotation_locations", "annotations", b"annotations", "members", b"members", "structured_annotations", b"structured_annotations"]) -> None: ...

global___P4HeaderTypeSpec = P4HeaderTypeSpec

@typing_extensions.final
class P4HeaderUnionTypeSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Member(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        HEADER_FIELD_NUMBER: builtins.int
        name: builtins.str
        @property
        def header(self) -> global___P4NamedType: ...
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            header: global___P4NamedType | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["header", b"header"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["header", b"header", "name", b"name"]) -> None: ...

    MEMBERS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    ANNOTATION_LOCATIONS_FIELD_NUMBER: builtins.int
    STRUCTURED_ANNOTATIONS_FIELD_NUMBER: builtins.int
    @property
    def members(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___P4HeaderUnionTypeSpec.Member]: ...
    @property
    def annotations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def annotation_locations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SourceLocation]:
        """Optional. If present, the location of `annotations[i]` is given by
        `annotation_locations[i]`.
        """
    @property
    def structured_annotations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StructuredAnnotation]: ...
    def __init__(
        self,
        *,
        members: collections.abc.Iterable[global___P4HeaderUnionTypeSpec.Member] | None = ...,
        annotations: collections.abc.Iterable[builtins.str] | None = ...,
        annotation_locations: collections.abc.Iterable[global___SourceLocation] | None = ...,
        structured_annotations: collections.abc.Iterable[global___StructuredAnnotation] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotation_locations", b"annotation_locations", "annotations", b"annotations", "members", b"members", "structured_annotations", b"structured_annotations"]) -> None: ...

global___P4HeaderUnionTypeSpec = P4HeaderUnionTypeSpec

@typing_extensions.final
class P4HeaderStackTypeSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEADER_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    @property
    def header(self) -> global___P4NamedType: ...
    size: builtins.int
    def __init__(
        self,
        *,
        header: global___P4NamedType | None = ...,
        size: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["header", b"header"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["header", b"header", "size", b"size"]) -> None: ...

global___P4HeaderStackTypeSpec = P4HeaderStackTypeSpec

@typing_extensions.final
class P4HeaderUnionStackTypeSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEADER_UNION_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    @property
    def header_union(self) -> global___P4NamedType: ...
    size: builtins.int
    def __init__(
        self,
        *,
        header_union: global___P4NamedType | None = ...,
        size: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["header_union", b"header_union"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["header_union", b"header_union", "size", b"size"]) -> None: ...

global___P4HeaderUnionStackTypeSpec = P4HeaderUnionStackTypeSpec

@typing_extensions.final
class KeyValuePair(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    key: builtins.str
    @property
    def value(self) -> global___Expression: ...
    def __init__(
        self,
        *,
        key: builtins.str = ...,
        value: global___Expression | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

global___KeyValuePair = KeyValuePair

@typing_extensions.final
class KeyValuePairList(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KV_PAIRS_FIELD_NUMBER: builtins.int
    @property
    def kv_pairs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___KeyValuePair]: ...
    def __init__(
        self,
        *,
        kv_pairs: collections.abc.Iterable[global___KeyValuePair] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["kv_pairs", b"kv_pairs"]) -> None: ...

global___KeyValuePairList = KeyValuePairList

@typing_extensions.final
class Expression(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STRING_VALUE_FIELD_NUMBER: builtins.int
    INT64_VALUE_FIELD_NUMBER: builtins.int
    BOOL_VALUE_FIELD_NUMBER: builtins.int
    string_value: builtins.str
    int64_value: builtins.int
    bool_value: builtins.bool
    def __init__(
        self,
        *,
        string_value: builtins.str = ...,
        int64_value: builtins.int = ...,
        bool_value: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["bool_value", b"bool_value", "int64_value", b"int64_value", "string_value", b"string_value", "value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bool_value", b"bool_value", "int64_value", b"int64_value", "string_value", b"string_value", "value", b"value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["value", b"value"]) -> typing_extensions.Literal["string_value", "int64_value", "bool_value"] | None: ...

global___Expression = Expression

@typing_extensions.final
class ExpressionList(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXPRESSIONS_FIELD_NUMBER: builtins.int
    @property
    def expressions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Expression]: ...
    def __init__(
        self,
        *,
        expressions: collections.abc.Iterable[global___Expression] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["expressions", b"expressions"]) -> None: ...

global___ExpressionList = ExpressionList

@typing_extensions.final
class StructuredAnnotation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    EXPRESSION_LIST_FIELD_NUMBER: builtins.int
    KV_PAIR_LIST_FIELD_NUMBER: builtins.int
    SOURCE_LOCATION_FIELD_NUMBER: builtins.int
    name: builtins.str
    @property
    def expression_list(self) -> global___ExpressionList: ...
    @property
    def kv_pair_list(self) -> global___KeyValuePairList: ...
    @property
    def source_location(self) -> global___SourceLocation:
        """Optional. Location of the '@' symbol of this annotation in the source code."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        expression_list: global___ExpressionList | None = ...,
        kv_pair_list: global___KeyValuePairList | None = ...,
        source_location: global___SourceLocation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["body", b"body", "expression_list", b"expression_list", "kv_pair_list", b"kv_pair_list", "source_location", b"source_location"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["body", b"body", "expression_list", b"expression_list", "kv_pair_list", b"kv_pair_list", "name", b"name", "source_location", b"source_location"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["body", b"body"]) -> typing_extensions.Literal["expression_list", "kv_pair_list"] | None: ...

global___StructuredAnnotation = StructuredAnnotation

@typing_extensions.final
class SourceLocation(google.protobuf.message.Message):
    """Location of code relative to a given source file."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_FIELD_NUMBER: builtins.int
    LINE_FIELD_NUMBER: builtins.int
    COLUMN_FIELD_NUMBER: builtins.int
    file: builtins.str
    """Path to the source file (absolute or relative to the working directory)."""
    line: builtins.int
    """Line and column numbers within the source file, 1-based."""
    column: builtins.int
    def __init__(
        self,
        *,
        file: builtins.str = ...,
        line: builtins.int = ...,
        column: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["column", b"column", "file", b"file", "line", b"line"]) -> None: ...

global___SourceLocation = SourceLocation

@typing_extensions.final
class P4EnumTypeSpec(google.protobuf.message.Message):
    """For "safe" enums with no underlying representation and no member integer
    values.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Member(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        ANNOTATIONS_FIELD_NUMBER: builtins.int
        ANNOTATION_LOCATIONS_FIELD_NUMBER: builtins.int
        STRUCTURED_ANNOTATIONS_FIELD_NUMBER: builtins.int
        name: builtins.str
        @property
        def annotations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        @property
        def annotation_locations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SourceLocation]:
            """Optional. If present, the location of `annotations[i]` is given by
            `annotation_locations[i]`.
            """
        @property
        def structured_annotations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StructuredAnnotation]: ...
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            annotations: collections.abc.Iterable[builtins.str] | None = ...,
            annotation_locations: collections.abc.Iterable[global___SourceLocation] | None = ...,
            structured_annotations: collections.abc.Iterable[global___StructuredAnnotation] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["annotation_locations", b"annotation_locations", "annotations", b"annotations", "name", b"name", "structured_annotations", b"structured_annotations"]) -> None: ...

    MEMBERS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    ANNOTATION_LOCATIONS_FIELD_NUMBER: builtins.int
    STRUCTURED_ANNOTATIONS_FIELD_NUMBER: builtins.int
    @property
    def members(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___P4EnumTypeSpec.Member]: ...
    @property
    def annotations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def annotation_locations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SourceLocation]:
        """Optional. If present, the location of `annotations[i]` is given by
        `annotation_locations[i]`.
        """
    @property
    def structured_annotations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StructuredAnnotation]: ...
    def __init__(
        self,
        *,
        members: collections.abc.Iterable[global___P4EnumTypeSpec.Member] | None = ...,
        annotations: collections.abc.Iterable[builtins.str] | None = ...,
        annotation_locations: collections.abc.Iterable[global___SourceLocation] | None = ...,
        structured_annotations: collections.abc.Iterable[global___StructuredAnnotation] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotation_locations", b"annotation_locations", "annotations", b"annotations", "members", b"members", "structured_annotations", b"structured_annotations"]) -> None: ...

global___P4EnumTypeSpec = P4EnumTypeSpec

@typing_extensions.final
class P4SerializableEnumTypeSpec(google.protobuf.message.Message):
    """For serializable (or "unsafe") enums, which have an underlying type. Note
    that as per the P4_16 specification, the underlying representation can only
    be a bit<W> type.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Member(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        ANNOTATIONS_FIELD_NUMBER: builtins.int
        ANNOTATION_LOCATIONS_FIELD_NUMBER: builtins.int
        STRUCTURED_ANNOTATIONS_FIELD_NUMBER: builtins.int
        name: builtins.str
        value: builtins.bytes
        @property
        def annotations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        @property
        def annotation_locations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SourceLocation]:
            """Optional. If present, the location of `annotations[i]` is given by
            `annotation_locations[i]`.
            """
        @property
        def structured_annotations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StructuredAnnotation]: ...
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            value: builtins.bytes = ...,
            annotations: collections.abc.Iterable[builtins.str] | None = ...,
            annotation_locations: collections.abc.Iterable[global___SourceLocation] | None = ...,
            structured_annotations: collections.abc.Iterable[global___StructuredAnnotation] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["annotation_locations", b"annotation_locations", "annotations", b"annotations", "name", b"name", "structured_annotations", b"structured_annotations", "value", b"value"]) -> None: ...

    UNDERLYING_TYPE_FIELD_NUMBER: builtins.int
    MEMBERS_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    ANNOTATION_LOCATIONS_FIELD_NUMBER: builtins.int
    STRUCTURED_ANNOTATIONS_FIELD_NUMBER: builtins.int
    @property
    def underlying_type(self) -> global___P4BitTypeSpec: ...
    @property
    def members(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___P4SerializableEnumTypeSpec.Member]: ...
    @property
    def annotations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def annotation_locations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SourceLocation]:
        """Optional. If present, the location of `annotations[i]` is given by
        `annotation_locations[i]`.
        """
    @property
    def structured_annotations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StructuredAnnotation]: ...
    def __init__(
        self,
        *,
        underlying_type: global___P4BitTypeSpec | None = ...,
        members: collections.abc.Iterable[global___P4SerializableEnumTypeSpec.Member] | None = ...,
        annotations: collections.abc.Iterable[builtins.str] | None = ...,
        annotation_locations: collections.abc.Iterable[global___SourceLocation] | None = ...,
        structured_annotations: collections.abc.Iterable[global___StructuredAnnotation] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["underlying_type", b"underlying_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotation_locations", b"annotation_locations", "annotations", b"annotations", "members", b"members", "structured_annotations", b"structured_annotations", "underlying_type", b"underlying_type"]) -> None: ...

global___P4SerializableEnumTypeSpec = P4SerializableEnumTypeSpec

@typing_extensions.final
class P4ErrorTypeSpec(google.protobuf.message.Message):
    """Similar to an enum, but there is always one and only one instance per P4
    program.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEMBERS_FIELD_NUMBER: builtins.int
    @property
    def members(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        members: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["members", b"members"]) -> None: ...

global___P4ErrorTypeSpec = P4ErrorTypeSpec

@typing_extensions.final
class P4NewTypeTranslation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class SdnString(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(
            self,
        ) -> None: ...

    URI_FIELD_NUMBER: builtins.int
    SDN_BITWIDTH_FIELD_NUMBER: builtins.int
    SDN_STRING_FIELD_NUMBER: builtins.int
    uri: builtins.str
    """the URI uniquely identifies the translation in order to enable the
    P4Runtime agent to perform value-mapping appropriately when required. It is
    recommended that the URI includes at least the P4 architecture name and the
    type name.
    """
    sdn_bitwidth: builtins.int
    @property
    def sdn_string(self) -> global___P4NewTypeTranslation.SdnString: ...
    def __init__(
        self,
        *,
        uri: builtins.str = ...,
        sdn_bitwidth: builtins.int = ...,
        sdn_string: global___P4NewTypeTranslation.SdnString | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["sdn_bitwidth", b"sdn_bitwidth", "sdn_string", b"sdn_string", "sdn_type", b"sdn_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["sdn_bitwidth", b"sdn_bitwidth", "sdn_string", b"sdn_string", "sdn_type", b"sdn_type", "uri", b"uri"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["sdn_type", b"sdn_type"]) -> typing_extensions.Literal["sdn_bitwidth", "sdn_string"] | None: ...

global___P4NewTypeTranslation = P4NewTypeTranslation

@typing_extensions.final
class P4NewTypeSpec(google.protobuf.message.Message):
    """New types introduced with the "type" keyword"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORIGINAL_TYPE_FIELD_NUMBER: builtins.int
    TRANSLATED_TYPE_FIELD_NUMBER: builtins.int
    ANNOTATIONS_FIELD_NUMBER: builtins.int
    ANNOTATION_LOCATIONS_FIELD_NUMBER: builtins.int
    STRUCTURED_ANNOTATIONS_FIELD_NUMBER: builtins.int
    @property
    def original_type(self) -> global___P4DataTypeSpec:
        """if no @p4runtime_translation annotation present"""
    @property
    def translated_type(self) -> global___P4NewTypeTranslation:
        """if @p4runtime_translation annotation present"""
    @property
    def annotations(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """for other annotations (not @p4runtime_translation)"""
    @property
    def annotation_locations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SourceLocation]:
        """Optional. If present, the location of `annotations[i]` is given by
        `annotation_locations[i]`.
        """
    @property
    def structured_annotations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___StructuredAnnotation]: ...
    def __init__(
        self,
        *,
        original_type: global___P4DataTypeSpec | None = ...,
        translated_type: global___P4NewTypeTranslation | None = ...,
        annotations: collections.abc.Iterable[builtins.str] | None = ...,
        annotation_locations: collections.abc.Iterable[global___SourceLocation] | None = ...,
        structured_annotations: collections.abc.Iterable[global___StructuredAnnotation] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["original_type", b"original_type", "representation", b"representation", "translated_type", b"translated_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["annotation_locations", b"annotation_locations", "annotations", b"annotations", "original_type", b"original_type", "representation", b"representation", "structured_annotations", b"structured_annotations", "translated_type", b"translated_type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["representation", b"representation"]) -> typing_extensions.Literal["original_type", "translated_type"] | None: ...

global___P4NewTypeSpec = P4NewTypeSpec
