"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
This package and its contents are a work-in-progress."""
import builtins
import collections.abc
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.rpc.status_pb2
import p4.config.v1.p4info_pb2
import p4.v1.p4data_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _SdnPort:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SdnPortEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_SdnPort.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SDN_PORT_UNKNOWN: _SdnPort.ValueType  # 0
    SDN_PORT_MIN: _SdnPort.ValueType  # 1
    """SDN ports are numbered starting form 1."""
    SDN_PORT_MAX: _SdnPort.ValueType  # -257
    """0xfffffeff: The maximum value of an SDN port (physical or logical)."""
    SDN_PORT_RECIRCULATE: _SdnPort.ValueType  # -6
    """Reserved SDN port numbers (0xffffff00 - 0xffffffff)
    0xfffffffa: Recirculate the packet back to ingress
    """
    SDN_PORT_CPU: _SdnPort.ValueType  # -3
    """0xfffffffd: Send to CPU"""

class SdnPort(_SdnPort, metaclass=_SdnPortEnumTypeWrapper):
    """------------------------------------------------------------------------------
    Reserved controller-specified SDN port numbers for reference.
    """

SDN_PORT_UNKNOWN: SdnPort.ValueType  # 0
SDN_PORT_MIN: SdnPort.ValueType  # 1
"""SDN ports are numbered starting form 1."""
SDN_PORT_MAX: SdnPort.ValueType  # -257
"""0xfffffeff: The maximum value of an SDN port (physical or logical)."""
SDN_PORT_RECIRCULATE: SdnPort.ValueType  # -6
"""Reserved SDN port numbers (0xffffff00 - 0xffffffff)
0xfffffffa: Recirculate the packet back to ingress
"""
SDN_PORT_CPU: SdnPort.ValueType  # -3
"""0xfffffffd: Send to CPU"""
global___SdnPort = SdnPort

@typing_extensions.final
class WriteRequest(google.protobuf.message.Message):
    """------------------------------------------------------------------------------"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Atomicity:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AtomicityEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[WriteRequest._Atomicity.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        CONTINUE_ON_ERROR: WriteRequest._Atomicity.ValueType  # 0
        """Required. This is the default behavior. The batch is processed in a
        non-atomic manner from a data plane point of view. Each operation within
        the batch must be attempted even if one or more encounter errors.
        Every data plane packet is guaranteed to be processed according to
        table contents as they are between two individual operations of the
        batch, but there could be several packets processed that see each of
        these intermediate stages.
        """
        ROLLBACK_ON_ERROR: WriteRequest._Atomicity.ValueType  # 1
        """Optional. Operations within the batch are committed to data plane until
        an error is encountered. At this point, the operations must be rolled
        back such that both software and data plane state is consistent with the
        state before the batch was attempted. The resulting behavior is
        all-or-none, except the batch is not atomic from a data plane point of
        view. Every data plane packet is guaranteed to be processed according to
        table contents as they are between two individual operations of the
        batch, but there could be several packets processed that see each of
        these intermediate stages.
        """
        DATAPLANE_ATOMIC: WriteRequest._Atomicity.ValueType  # 2
        """Optional. Every data plane packet is guaranteed to be processed according
        to table contents before the batch began, or after the batch completed
        and the operations were programmed to the hardware.
        The batch is therefore treated as a transaction.
        """

    class Atomicity(_Atomicity, metaclass=_AtomicityEnumTypeWrapper): ...
    CONTINUE_ON_ERROR: WriteRequest.Atomicity.ValueType  # 0
    """Required. This is the default behavior. The batch is processed in a
    non-atomic manner from a data plane point of view. Each operation within
    the batch must be attempted even if one or more encounter errors.
    Every data plane packet is guaranteed to be processed according to
    table contents as they are between two individual operations of the
    batch, but there could be several packets processed that see each of
    these intermediate stages.
    """
    ROLLBACK_ON_ERROR: WriteRequest.Atomicity.ValueType  # 1
    """Optional. Operations within the batch are committed to data plane until
    an error is encountered. At this point, the operations must be rolled
    back such that both software and data plane state is consistent with the
    state before the batch was attempted. The resulting behavior is
    all-or-none, except the batch is not atomic from a data plane point of
    view. Every data plane packet is guaranteed to be processed according to
    table contents as they are between two individual operations of the
    batch, but there could be several packets processed that see each of
    these intermediate stages.
    """
    DATAPLANE_ATOMIC: WriteRequest.Atomicity.ValueType  # 2
    """Optional. Every data plane packet is guaranteed to be processed according
    to table contents before the batch began, or after the batch completed
    and the operations were programmed to the hardware.
    The batch is therefore treated as a transaction.
    """

    DEVICE_ID_FIELD_NUMBER: builtins.int
    ROLE_ID_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    ELECTION_ID_FIELD_NUMBER: builtins.int
    UPDATES_FIELD_NUMBER: builtins.int
    ATOMICITY_FIELD_NUMBER: builtins.int
    device_id: builtins.int
    role_id: builtins.int
    role: builtins.str
    @property
    def election_id(self) -> global___Uint128: ...
    @property
    def updates(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Update]:
        """The write batch, comprising a list of Update operations. The P4Runtime
        server may arbitrarily reorder messages within a batch to maximize
        performance.
        """
    atomicity: global___WriteRequest.Atomicity.ValueType
    def __init__(
        self,
        *,
        device_id: builtins.int = ...,
        role_id: builtins.int = ...,
        role: builtins.str = ...,
        election_id: global___Uint128 | None = ...,
        updates: collections.abc.Iterable[global___Update] | None = ...,
        atomicity: global___WriteRequest.Atomicity.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["election_id", b"election_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["atomicity", b"atomicity", "device_id", b"device_id", "election_id", b"election_id", "role", b"role", "role_id", b"role_id", "updates", b"updates"]) -> None: ...

global___WriteRequest = WriteRequest

@typing_extensions.final
class WriteResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___WriteResponse = WriteResponse

@typing_extensions.final
class ReadRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEVICE_ID_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    ENTITIES_FIELD_NUMBER: builtins.int
    device_id: builtins.int
    role: builtins.str
    """When specified, only return table entries for the given role."""
    @property
    def entities(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Entity]: ...
    def __init__(
        self,
        *,
        device_id: builtins.int = ...,
        role: builtins.str = ...,
        entities: collections.abc.Iterable[global___Entity] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["device_id", b"device_id", "entities", b"entities", "role", b"role"]) -> None: ...

global___ReadRequest = ReadRequest

@typing_extensions.final
class ReadResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITIES_FIELD_NUMBER: builtins.int
    @property
    def entities(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Entity]: ...
    def __init__(
        self,
        *,
        entities: collections.abc.Iterable[global___Entity] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["entities", b"entities"]) -> None: ...

global___ReadResponse = ReadResponse

@typing_extensions.final
class Update(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Update._Type.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: Update._Type.ValueType  # 0
        INSERT: Update._Type.ValueType  # 1
        MODIFY: Update._Type.ValueType  # 2
        DELETE: Update._Type.ValueType  # 3

    class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
    UNSPECIFIED: Update.Type.ValueType  # 0
    INSERT: Update.Type.ValueType  # 1
    MODIFY: Update.Type.ValueType  # 2
    DELETE: Update.Type.ValueType  # 3

    TYPE_FIELD_NUMBER: builtins.int
    ENTITY_FIELD_NUMBER: builtins.int
    type: global___Update.Type.ValueType
    @property
    def entity(self) -> global___Entity: ...
    def __init__(
        self,
        *,
        type: global___Update.Type.ValueType = ...,
        entity: global___Entity | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity", "type", b"type"]) -> None: ...

global___Update = Update

@typing_extensions.final
class Entity(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXTERN_ENTRY_FIELD_NUMBER: builtins.int
    TABLE_ENTRY_FIELD_NUMBER: builtins.int
    ACTION_PROFILE_MEMBER_FIELD_NUMBER: builtins.int
    ACTION_PROFILE_GROUP_FIELD_NUMBER: builtins.int
    METER_ENTRY_FIELD_NUMBER: builtins.int
    DIRECT_METER_ENTRY_FIELD_NUMBER: builtins.int
    COUNTER_ENTRY_FIELD_NUMBER: builtins.int
    DIRECT_COUNTER_ENTRY_FIELD_NUMBER: builtins.int
    PACKET_REPLICATION_ENGINE_ENTRY_FIELD_NUMBER: builtins.int
    VALUE_SET_ENTRY_FIELD_NUMBER: builtins.int
    REGISTER_ENTRY_FIELD_NUMBER: builtins.int
    DIGEST_ENTRY_FIELD_NUMBER: builtins.int
    @property
    def extern_entry(self) -> global___ExternEntry: ...
    @property
    def table_entry(self) -> global___TableEntry: ...
    @property
    def action_profile_member(self) -> global___ActionProfileMember: ...
    @property
    def action_profile_group(self) -> global___ActionProfileGroup: ...
    @property
    def meter_entry(self) -> global___MeterEntry: ...
    @property
    def direct_meter_entry(self) -> global___DirectMeterEntry: ...
    @property
    def counter_entry(self) -> global___CounterEntry: ...
    @property
    def direct_counter_entry(self) -> global___DirectCounterEntry: ...
    @property
    def packet_replication_engine_entry(self) -> global___PacketReplicationEngineEntry: ...
    @property
    def value_set_entry(self) -> global___ValueSetEntry: ...
    @property
    def register_entry(self) -> global___RegisterEntry: ...
    @property
    def digest_entry(self) -> global___DigestEntry: ...
    def __init__(
        self,
        *,
        extern_entry: global___ExternEntry | None = ...,
        table_entry: global___TableEntry | None = ...,
        action_profile_member: global___ActionProfileMember | None = ...,
        action_profile_group: global___ActionProfileGroup | None = ...,
        meter_entry: global___MeterEntry | None = ...,
        direct_meter_entry: global___DirectMeterEntry | None = ...,
        counter_entry: global___CounterEntry | None = ...,
        direct_counter_entry: global___DirectCounterEntry | None = ...,
        packet_replication_engine_entry: global___PacketReplicationEngineEntry | None = ...,
        value_set_entry: global___ValueSetEntry | None = ...,
        register_entry: global___RegisterEntry | None = ...,
        digest_entry: global___DigestEntry | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["action_profile_group", b"action_profile_group", "action_profile_member", b"action_profile_member", "counter_entry", b"counter_entry", "digest_entry", b"digest_entry", "direct_counter_entry", b"direct_counter_entry", "direct_meter_entry", b"direct_meter_entry", "entity", b"entity", "extern_entry", b"extern_entry", "meter_entry", b"meter_entry", "packet_replication_engine_entry", b"packet_replication_engine_entry", "register_entry", b"register_entry", "table_entry", b"table_entry", "value_set_entry", b"value_set_entry"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action_profile_group", b"action_profile_group", "action_profile_member", b"action_profile_member", "counter_entry", b"counter_entry", "digest_entry", b"digest_entry", "direct_counter_entry", b"direct_counter_entry", "direct_meter_entry", b"direct_meter_entry", "entity", b"entity", "extern_entry", b"extern_entry", "meter_entry", b"meter_entry", "packet_replication_engine_entry", b"packet_replication_engine_entry", "register_entry", b"register_entry", "table_entry", b"table_entry", "value_set_entry", b"value_set_entry"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["entity", b"entity"]) -> typing_extensions.Literal["extern_entry", "table_entry", "action_profile_member", "action_profile_group", "meter_entry", "direct_meter_entry", "counter_entry", "direct_counter_entry", "packet_replication_engine_entry", "value_set_entry", "register_entry", "digest_entry"] | None: ...

global___Entity = Entity

@typing_extensions.final
class ExternEntry(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXTERN_TYPE_ID_FIELD_NUMBER: builtins.int
    EXTERN_ID_FIELD_NUMBER: builtins.int
    ENTRY_FIELD_NUMBER: builtins.int
    extern_type_id: builtins.int
    """the extern_type_id is unique for a given architecture and must be in the
    range [0x81, 0xfe].
    """
    extern_id: builtins.int
    """id of the instance"""
    @property
    def entry(self) -> google.protobuf.any_pb2.Any: ...
    def __init__(
        self,
        *,
        extern_type_id: builtins.int = ...,
        extern_id: builtins.int = ...,
        entry: google.protobuf.any_pb2.Any | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entry", b"entry"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entry", b"entry", "extern_id", b"extern_id", "extern_type_id", b"extern_type_id"]) -> None: ...

global___ExternEntry = ExternEntry

@typing_extensions.final
class TableEntry(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class IdleTimeout(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ELAPSED_NS_FIELD_NUMBER: builtins.int
        elapsed_ns: builtins.int
        """Time elapsed - in nanoseconds - since the table entry was last "hit" as
        part of a data plane table lookup.
        """
        def __init__(
            self,
            *,
            elapsed_ns: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["elapsed_ns", b"elapsed_ns"]) -> None: ...

    TABLE_ID_FIELD_NUMBER: builtins.int
    MATCH_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    PRIORITY_FIELD_NUMBER: builtins.int
    CONTROLLER_METADATA_FIELD_NUMBER: builtins.int
    METER_CONFIG_FIELD_NUMBER: builtins.int
    COUNTER_DATA_FIELD_NUMBER: builtins.int
    METER_COUNTER_DATA_FIELD_NUMBER: builtins.int
    IS_DEFAULT_ACTION_FIELD_NUMBER: builtins.int
    IDLE_TIMEOUT_NS_FIELD_NUMBER: builtins.int
    TIME_SINCE_LAST_HIT_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    table_id: builtins.int
    @property
    def match(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FieldMatch]: ...
    @property
    def action(self) -> global___TableAction: ...
    priority: builtins.int
    """Should only be set if the match implies a TCAM lookup, i.e. at least one of
    the match fields is Optional, Ternary or Range.  A higher number indicates
    higher priority.  Only a highest priority entry that matches the packet
    must be selected.  Multiple entries in the same table with the same
    priority value are permitted.  See Section "TableEntry" in the
    specification for details of the behavior.
    """
    controller_metadata: builtins.int
    """Metadata (cookie) opaque to the target. There is no requirement of where
    this is stored, as long as it is returned with the rest of the entry in
    a Read RPC. This is deprecated in favor of the more flexible metadata
    field.
    """
    @property
    def meter_config(self) -> global___MeterConfig:
        """meter_config, counter_data and meter_counter_data are convenience fields
        that enable the controller to configure the direct resources associated
        with the table at the same time as a match-action entry is inserted or
        modified.
        Table write:
          - If the table does not contain a direct resource, then setting the
            corresponding direct resource field in any table write operation will
            return an error.
          - When inserting a new table entry, leaving these fields unset means that
            the direct resources of this table (if any) will assume default values.
            For counters, the default value is 0, and for meters, the default value
            is always green.
          - When updating a table entry, leaving meter_config unset will reset the
            meter (if any) to its default configuration, while leaving counter_data
            or meter_counter_data unset means that the counter (if any) will not be
            updated.
        Table read:
          - If the table does not contain a direct resource, then the corresponding
            field will not be set in the read table entry.
          - If meter_config is unset in the request, or if the meter has a default
            configuration, meter_config will not be set in the response.
          - If counter_data or meter_counter_data is unset in the request, it will
            be unset in the response as well.
        """
    @property
    def counter_data(self) -> global___CounterData: ...
    @property
    def meter_counter_data(self) -> global___MeterCounterData:
        """Per color counters for tables with a direct meter."""
    is_default_action: builtins.bool
    """Set to true if the table entry is being used to update the non-const
    default action of the table. If true, the "match" field must be empty and
    the "action" field must be populated with a valid direct action.
    """
    idle_timeout_ns: builtins.int
    """The TTL for the entry, in nanoseconds. A value of 0 means that the table
    entry never "expires".
    """
    @property
    def time_since_last_hit(self) -> global___TableEntry.IdleTimeout:
        """Table write: this field should be left unset.
        Table read: if the table supports idle timeout and time_since_last_hit is
        set in the request, this field will be set in the response.
        """
    metadata: builtins.bytes
    """Arbitrary metadata from the controller that is opaque to the target."""
    def __init__(
        self,
        *,
        table_id: builtins.int = ...,
        match: collections.abc.Iterable[global___FieldMatch] | None = ...,
        action: global___TableAction | None = ...,
        priority: builtins.int = ...,
        controller_metadata: builtins.int = ...,
        meter_config: global___MeterConfig | None = ...,
        counter_data: global___CounterData | None = ...,
        meter_counter_data: global___MeterCounterData | None = ...,
        is_default_action: builtins.bool = ...,
        idle_timeout_ns: builtins.int = ...,
        time_since_last_hit: global___TableEntry.IdleTimeout | None = ...,
        metadata: builtins.bytes = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["action", b"action", "counter_data", b"counter_data", "meter_config", b"meter_config", "meter_counter_data", b"meter_counter_data", "time_since_last_hit", b"time_since_last_hit"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action", b"action", "controller_metadata", b"controller_metadata", "counter_data", b"counter_data", "idle_timeout_ns", b"idle_timeout_ns", "is_default_action", b"is_default_action", "match", b"match", "metadata", b"metadata", "meter_config", b"meter_config", "meter_counter_data", b"meter_counter_data", "priority", b"priority", "table_id", b"table_id", "time_since_last_hit", b"time_since_last_hit"]) -> None: ...

global___TableEntry = TableEntry

@typing_extensions.final
class FieldMatch(google.protobuf.message.Message):
    """field_match_type ::= exact | ternary | lpm | range | optional"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Exact(google.protobuf.message.Message):
        """Matches can be performed on arbitrarily-large inputs; the protobuf type
        'bytes' is used to model arbitrarily-large values.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        VALUE_FIELD_NUMBER: builtins.int
        value: builtins.bytes
        def __init__(
            self,
            *,
            value: builtins.bytes = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["value", b"value"]) -> None: ...

    @typing_extensions.final
    class Ternary(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        VALUE_FIELD_NUMBER: builtins.int
        MASK_FIELD_NUMBER: builtins.int
        value: builtins.bytes
        mask: builtins.bytes
        def __init__(
            self,
            *,
            value: builtins.bytes = ...,
            mask: builtins.bytes = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["mask", b"mask", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class LPM(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        VALUE_FIELD_NUMBER: builtins.int
        PREFIX_LEN_FIELD_NUMBER: builtins.int
        value: builtins.bytes
        prefix_len: builtins.int
        """in bits"""
        def __init__(
            self,
            *,
            value: builtins.bytes = ...,
            prefix_len: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["prefix_len", b"prefix_len", "value", b"value"]) -> None: ...

    @typing_extensions.final
    class Range(google.protobuf.message.Message):
        """A Range is logically a set that contains all values numerically between
        'low' and 'high' inclusively.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        LOW_FIELD_NUMBER: builtins.int
        HIGH_FIELD_NUMBER: builtins.int
        low: builtins.bytes
        high: builtins.bytes
        def __init__(
            self,
            *,
            low: builtins.bytes = ...,
            high: builtins.bytes = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["high", b"high", "low", b"low"]) -> None: ...

    @typing_extensions.final
    class Optional(google.protobuf.message.Message):
        """If the Optional match should be a wildcard, the FieldMatch must be omitted.
        Otherwise, this behaves like an exact match.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        VALUE_FIELD_NUMBER: builtins.int
        value: builtins.bytes
        def __init__(
            self,
            *,
            value: builtins.bytes = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["value", b"value"]) -> None: ...

    FIELD_ID_FIELD_NUMBER: builtins.int
    EXACT_FIELD_NUMBER: builtins.int
    TERNARY_FIELD_NUMBER: builtins.int
    LPM_FIELD_NUMBER: builtins.int
    RANGE_FIELD_NUMBER: builtins.int
    OPTIONAL_FIELD_NUMBER: builtins.int
    OTHER_FIELD_NUMBER: builtins.int
    field_id: builtins.int
    @property
    def exact(self) -> global___FieldMatch.Exact: ...
    @property
    def ternary(self) -> global___FieldMatch.Ternary: ...
    @property
    def lpm(self) -> global___FieldMatch.LPM: ...
    @property
    def range(self) -> global___FieldMatch.Range: ...
    @property
    def optional(self) -> global___FieldMatch.Optional: ...
    @property
    def other(self) -> google.protobuf.any_pb2.Any:
        """Architecture-specific match value; it corresponds to the other_match_type
        in the P4Info MatchField message.
        """
    def __init__(
        self,
        *,
        field_id: builtins.int = ...,
        exact: global___FieldMatch.Exact | None = ...,
        ternary: global___FieldMatch.Ternary | None = ...,
        lpm: global___FieldMatch.LPM | None = ...,
        range: global___FieldMatch.Range | None = ...,
        optional: global___FieldMatch.Optional | None = ...,
        other: google.protobuf.any_pb2.Any | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["exact", b"exact", "field_match_type", b"field_match_type", "lpm", b"lpm", "optional", b"optional", "other", b"other", "range", b"range", "ternary", b"ternary"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["exact", b"exact", "field_id", b"field_id", "field_match_type", b"field_match_type", "lpm", b"lpm", "optional", b"optional", "other", b"other", "range", b"range", "ternary", b"ternary"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["field_match_type", b"field_match_type"]) -> typing_extensions.Literal["exact", "ternary", "lpm", "range", "optional", "other"] | None: ...

global___FieldMatch = FieldMatch

@typing_extensions.final
class TableAction(google.protobuf.message.Message):
    """table_actions ::= action_specification | action_profile_specification"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTION_FIELD_NUMBER: builtins.int
    ACTION_PROFILE_MEMBER_ID_FIELD_NUMBER: builtins.int
    ACTION_PROFILE_GROUP_ID_FIELD_NUMBER: builtins.int
    ACTION_PROFILE_ACTION_SET_FIELD_NUMBER: builtins.int
    @property
    def action(self) -> global___Action: ...
    action_profile_member_id: builtins.int
    action_profile_group_id: builtins.int
    @property
    def action_profile_action_set(self) -> global___ActionProfileActionSet: ...
    def __init__(
        self,
        *,
        action: global___Action | None = ...,
        action_profile_member_id: builtins.int = ...,
        action_profile_group_id: builtins.int = ...,
        action_profile_action_set: global___ActionProfileActionSet | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["action", b"action", "action_profile_action_set", b"action_profile_action_set", "action_profile_group_id", b"action_profile_group_id", "action_profile_member_id", b"action_profile_member_id", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action", b"action", "action_profile_action_set", b"action_profile_action_set", "action_profile_group_id", b"action_profile_group_id", "action_profile_member_id", b"action_profile_member_id", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["type", b"type"]) -> typing_extensions.Literal["action", "action_profile_member_id", "action_profile_group_id", "action_profile_action_set"] | None: ...

global___TableAction = TableAction

@typing_extensions.final
class Action(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Param(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        PARAM_ID_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        param_id: builtins.int
        value: builtins.bytes
        def __init__(
            self,
            *,
            param_id: builtins.int = ...,
            value: builtins.bytes = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["param_id", b"param_id", "value", b"value"]) -> None: ...

    ACTION_ID_FIELD_NUMBER: builtins.int
    PARAMS_FIELD_NUMBER: builtins.int
    action_id: builtins.int
    @property
    def params(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Action.Param]: ...
    def __init__(
        self,
        *,
        action_id: builtins.int = ...,
        params: collections.abc.Iterable[global___Action.Param] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["action_id", b"action_id", "params", b"params"]) -> None: ...

global___Action = Action

@typing_extensions.final
class ActionProfileActionSet(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTION_PROFILE_ACTIONS_FIELD_NUMBER: builtins.int
    @property
    def action_profile_actions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ActionProfileAction]: ...
    def __init__(
        self,
        *,
        action_profile_actions: collections.abc.Iterable[global___ActionProfileAction] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["action_profile_actions", b"action_profile_actions"]) -> None: ...

global___ActionProfileActionSet = ActionProfileActionSet

@typing_extensions.final
class ActionProfileAction(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTION_FIELD_NUMBER: builtins.int
    WEIGHT_FIELD_NUMBER: builtins.int
    WATCH_FIELD_NUMBER: builtins.int
    WATCH_PORT_FIELD_NUMBER: builtins.int
    @property
    def action(self) -> global___Action: ...
    weight: builtins.int
    watch: builtins.int
    """Using int32 as ports is deprecated, use watch_port instead."""
    watch_port: builtins.bytes
    def __init__(
        self,
        *,
        action: global___Action | None = ...,
        weight: builtins.int = ...,
        watch: builtins.int = ...,
        watch_port: builtins.bytes = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["action", b"action", "watch", b"watch", "watch_kind", b"watch_kind", "watch_port", b"watch_port"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action", b"action", "watch", b"watch", "watch_kind", b"watch_kind", "watch_port", b"watch_port", "weight", b"weight"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["watch_kind", b"watch_kind"]) -> typing_extensions.Literal["watch", "watch_port"] | None: ...

global___ActionProfileAction = ActionProfileAction

@typing_extensions.final
class ActionProfileMember(google.protobuf.message.Message):
    """------------------------------------------------------------------------------"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTION_PROFILE_ID_FIELD_NUMBER: builtins.int
    MEMBER_ID_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    action_profile_id: builtins.int
    member_id: builtins.int
    @property
    def action(self) -> global___Action: ...
    def __init__(
        self,
        *,
        action_profile_id: builtins.int = ...,
        member_id: builtins.int = ...,
        action: global___Action | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["action", b"action"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action", b"action", "action_profile_id", b"action_profile_id", "member_id", b"member_id"]) -> None: ...

global___ActionProfileMember = ActionProfileMember

@typing_extensions.final
class ActionProfileGroup(google.protobuf.message.Message):
    """------------------------------------------------------------------------------"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Member(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        MEMBER_ID_FIELD_NUMBER: builtins.int
        WEIGHT_FIELD_NUMBER: builtins.int
        WATCH_FIELD_NUMBER: builtins.int
        WATCH_PORT_FIELD_NUMBER: builtins.int
        member_id: builtins.int
        weight: builtins.int
        watch: builtins.int
        """Using int32 as ports is deprecated, use watch_port instead."""
        watch_port: builtins.bytes
        def __init__(
            self,
            *,
            member_id: builtins.int = ...,
            weight: builtins.int = ...,
            watch: builtins.int = ...,
            watch_port: builtins.bytes = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["watch", b"watch", "watch_kind", b"watch_kind", "watch_port", b"watch_port"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["member_id", b"member_id", "watch", b"watch", "watch_kind", b"watch_kind", "watch_port", b"watch_port", "weight", b"weight"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["watch_kind", b"watch_kind"]) -> typing_extensions.Literal["watch", "watch_port"] | None: ...

    ACTION_PROFILE_ID_FIELD_NUMBER: builtins.int
    GROUP_ID_FIELD_NUMBER: builtins.int
    MEMBERS_FIELD_NUMBER: builtins.int
    MAX_SIZE_FIELD_NUMBER: builtins.int
    action_profile_id: builtins.int
    group_id: builtins.int
    @property
    def members(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ActionProfileGroup.Member]: ...
    max_size: builtins.int
    """Max number of weighted member entries in this group. It cannot be modified
    after a group has been created. It must not exceed the static
    max_group_size included in P4Info. If the max size is not known at group
    creation-time, the client may leave this field unset (default value 0), in
    which case the static max_group_size value will be used and the group will
    be able to include up to max_group_size weighted member entries.
    """
    def __init__(
        self,
        *,
        action_profile_id: builtins.int = ...,
        group_id: builtins.int = ...,
        members: collections.abc.Iterable[global___ActionProfileGroup.Member] | None = ...,
        max_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["action_profile_id", b"action_profile_id", "group_id", b"group_id", "max_size", b"max_size", "members", b"members"]) -> None: ...

global___ActionProfileGroup = ActionProfileGroup

@typing_extensions.final
class Index(google.protobuf.message.Message):
    """An index as a protobuf message. In proto3, fields cannot be optional and
    there is no difference between an unset integer field and an integer field
    set to 0. This is inconvenient for reading from P4 array-like structures,
    such as indirect counters and meters. We need a way to do a wildcard read on
    these but we cannot use a default zero index value to do so, as zero is a
    valid index (first entry in the array). We therefore wrap the index in a
    message.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INDEX_FIELD_NUMBER: builtins.int
    index: builtins.int
    def __init__(
        self,
        *,
        index: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["index", b"index"]) -> None: ...

global___Index = Index

@typing_extensions.final
class MeterEntry(google.protobuf.message.Message):
    """------------------------------------------------------------------------------
    For WriteRequest, Update.Type must be MODIFY.
    For ReadRequest, the scope is defined as follows:
    - All meter cells for all meters if meter_id = 0 (default).
    - All meter cells for given meter_id if index is unset (default).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METER_ID_FIELD_NUMBER: builtins.int
    INDEX_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    COUNTER_DATA_FIELD_NUMBER: builtins.int
    meter_id: builtins.int
    @property
    def index(self) -> global___Index: ...
    @property
    def config(self) -> global___MeterConfig: ...
    @property
    def counter_data(self) -> global___MeterCounterData: ...
    def __init__(
        self,
        *,
        meter_id: builtins.int = ...,
        index: global___Index | None = ...,
        config: global___MeterConfig | None = ...,
        counter_data: global___MeterCounterData | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["config", b"config", "counter_data", b"counter_data", "index", b"index"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["config", b"config", "counter_data", b"counter_data", "index", b"index", "meter_id", b"meter_id"]) -> None: ...

global___MeterEntry = MeterEntry

@typing_extensions.final
class DirectMeterEntry(google.protobuf.message.Message):
    """------------------------------------------------------------------------------
    For WriteRequest, Update.Type must be MODIFY. INSERT and DELETE on direct
    meters is not allowed and will return an error. The insertion/deletion
    should happen as part of INSERT/DELETE on the associated table-entry.
    For ReadRequest, the scope is defined as follows:
    - All meter cells for all tables if table_entry.table_id = 0.
    - All meter cells of a table if table_entry.table_id is present and
      table_entry.match is empty.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TABLE_ENTRY_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    COUNTER_DATA_FIELD_NUMBER: builtins.int
    @property
    def table_entry(self) -> global___TableEntry:
        """The associated table entry. This field is required.
        table_entry.action is ignored. Other fields specify the match.
        """
    @property
    def config(self) -> global___MeterConfig: ...
    @property
    def counter_data(self) -> global___MeterCounterData: ...
    def __init__(
        self,
        *,
        table_entry: global___TableEntry | None = ...,
        config: global___MeterConfig | None = ...,
        counter_data: global___MeterCounterData | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["config", b"config", "counter_data", b"counter_data", "table_entry", b"table_entry"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["config", b"config", "counter_data", b"counter_data", "table_entry", b"table_entry"]) -> None: ...

global___DirectMeterEntry = DirectMeterEntry

@typing_extensions.final
class MeterConfig(google.protobuf.message.Message):
    """Modeled as RFC 2698: A Two Rate Three Color Marker (trTCM)
    The trTCM meters a packet stream and marks its packets based on two rates,
    Peak Information Rate (PIR) and Committed Information Rate (CIR), and their
    associated burst sizes to be either green, yellow, or red.  A packet is
    marked red if it exceeds the PIR.  Otherwise it is marked either yellow or
    green depending on whether it exceeds or doesn't exceed the CIR.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CIR_FIELD_NUMBER: builtins.int
    CBURST_FIELD_NUMBER: builtins.int
    PIR_FIELD_NUMBER: builtins.int
    PBURST_FIELD_NUMBER: builtins.int
    cir: builtins.int
    """Committed information rate (units per sec)"""
    cburst: builtins.int
    """Committed burst size"""
    pir: builtins.int
    """Peak information rate (units per sec)"""
    pburst: builtins.int
    """Peak burst size"""
    def __init__(
        self,
        *,
        cir: builtins.int = ...,
        cburst: builtins.int = ...,
        pir: builtins.int = ...,
        pburst: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cburst", b"cburst", "cir", b"cir", "pburst", b"pburst", "pir", b"pir"]) -> None: ...

global___MeterConfig = MeterConfig

@typing_extensions.final
class CounterEntry(google.protobuf.message.Message):
    """------------------------------------------------------------------------------
    For WriteRequest, Update.Type must be MODIFY.
    For ReadRequest, the scope is defined as follows:
    - All counter cells for all counters if counter_id = 0 (default).
    - All counter cells for given counter_id if index is unset (default).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COUNTER_ID_FIELD_NUMBER: builtins.int
    INDEX_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    counter_id: builtins.int
    @property
    def index(self) -> global___Index: ...
    @property
    def data(self) -> global___CounterData: ...
    def __init__(
        self,
        *,
        counter_id: builtins.int = ...,
        index: global___Index | None = ...,
        data: global___CounterData | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["data", b"data", "index", b"index"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["counter_id", b"counter_id", "data", b"data", "index", b"index"]) -> None: ...

global___CounterEntry = CounterEntry

@typing_extensions.final
class DirectCounterEntry(google.protobuf.message.Message):
    """------------------------------------------------------------------------------
    For WriteRequest, Update.Type must be MODIFY. INSERT and DELETE on direct
    counters is not allowed and will return an error. The insertion/deletion
    should happen as part of INSERT/DELETE on the associated table-entry.
    For ReadRequest, the scope is defined as follows:
    - All counter cells for all tables if table_entry.table_id = 0.
    - All counter cells of a table if table_entry.table_id is present and
      table_entry.match is empty.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TABLE_ENTRY_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    @property
    def table_entry(self) -> global___TableEntry:
        """The associated table entry. This field is required.
        table_entry.action is ignored. Other fields specify the match.
        """
    @property
    def data(self) -> global___CounterData: ...
    def __init__(
        self,
        *,
        table_entry: global___TableEntry | None = ...,
        data: global___CounterData | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["data", b"data", "table_entry", b"table_entry"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["data", b"data", "table_entry", b"table_entry"]) -> None: ...

global___DirectCounterEntry = DirectCounterEntry

@typing_extensions.final
class CounterData(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BYTE_COUNT_FIELD_NUMBER: builtins.int
    PACKET_COUNT_FIELD_NUMBER: builtins.int
    byte_count: builtins.int
    packet_count: builtins.int
    def __init__(
        self,
        *,
        byte_count: builtins.int = ...,
        packet_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["byte_count", b"byte_count", "packet_count", b"packet_count"]) -> None: ...

global___CounterData = CounterData

@typing_extensions.final
class MeterCounterData(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GREEN_FIELD_NUMBER: builtins.int
    YELLOW_FIELD_NUMBER: builtins.int
    RED_FIELD_NUMBER: builtins.int
    @property
    def green(self) -> global___CounterData: ...
    @property
    def yellow(self) -> global___CounterData: ...
    @property
    def red(self) -> global___CounterData: ...
    def __init__(
        self,
        *,
        green: global___CounterData | None = ...,
        yellow: global___CounterData | None = ...,
        red: global___CounterData | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["green", b"green", "red", b"red", "yellow", b"yellow"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["green", b"green", "red", b"red", "yellow", b"yellow"]) -> None: ...

global___MeterCounterData = MeterCounterData

@typing_extensions.final
class PacketReplicationEngineEntry(google.protobuf.message.Message):
    """------------------------------------------------------------------------------
    Only one instance of a Packet Replication Engine (PRE) is expected in the
    P4 pipeline. Hence, no instance id is needed to access the PRE.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MULTICAST_GROUP_ENTRY_FIELD_NUMBER: builtins.int
    CLONE_SESSION_ENTRY_FIELD_NUMBER: builtins.int
    @property
    def multicast_group_entry(self) -> global___MulticastGroupEntry: ...
    @property
    def clone_session_entry(self) -> global___CloneSessionEntry: ...
    def __init__(
        self,
        *,
        multicast_group_entry: global___MulticastGroupEntry | None = ...,
        clone_session_entry: global___CloneSessionEntry | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["clone_session_entry", b"clone_session_entry", "multicast_group_entry", b"multicast_group_entry", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["clone_session_entry", b"clone_session_entry", "multicast_group_entry", b"multicast_group_entry", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["type", b"type"]) -> typing_extensions.Literal["multicast_group_entry", "clone_session_entry"] | None: ...

global___PacketReplicationEngineEntry = PacketReplicationEngineEntry

@typing_extensions.final
class Replica(google.protobuf.message.Message):
    """Used for replicas created for cloning and multicasting actions."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EGRESS_PORT_FIELD_NUMBER: builtins.int
    INSTANCE_FIELD_NUMBER: builtins.int
    egress_port: builtins.int
    instance: builtins.int
    def __init__(
        self,
        *,
        egress_port: builtins.int = ...,
        instance: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["egress_port", b"egress_port", "instance", b"instance"]) -> None: ...

global___Replica = Replica

@typing_extensions.final
class MulticastGroupEntry(google.protobuf.message.Message):
    """The (egress_port, instance) pair must be unique for each replica in a given
    multicast group entry. A packet may be multicast by setting the
    multicast_group field of PSA ingress output metadata to multicast_group_id
    of a programmed multicast group entry. The egress_port and instance fields of
    each replica's egress input metadata will be set to the respective values
    programmed in the multicast group entry.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MULTICAST_GROUP_ID_FIELD_NUMBER: builtins.int
    REPLICAS_FIELD_NUMBER: builtins.int
    multicast_group_id: builtins.int
    @property
    def replicas(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Replica]: ...
    def __init__(
        self,
        *,
        multicast_group_id: builtins.int = ...,
        replicas: collections.abc.Iterable[global___Replica] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["multicast_group_id", b"multicast_group_id", "replicas", b"replicas"]) -> None: ...

global___MulticastGroupEntry = MulticastGroupEntry

@typing_extensions.final
class CloneSessionEntry(google.protobuf.message.Message):
    """A packet may be cloned by setting the clone_session_id field of PSA
    ingress/egress output metadata to session_id of a programmed clone session
    entry. Multiple clones may be created via a single clone session entry by
    using the replicas message. The clones may be distinguished in the egress
    using the instance field. The class_of_service field of the clone's egress
    input metadata will be set to the respective value programmed in the clone
    session entry. Note that in case of multiple clones, all clones, defined
    for a clone session, will get the same class of service. The
    packet_length_bytes field must be set to a non-zero value if the clone
    packet(s) should be truncated to the given value (in bytes). The packet
    length is also common to all clones in the clone session. If the
    packet_length_bytes field is 0, no truncation on the clone(s) will be
    performed.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_ID_FIELD_NUMBER: builtins.int
    REPLICAS_FIELD_NUMBER: builtins.int
    CLASS_OF_SERVICE_FIELD_NUMBER: builtins.int
    PACKET_LENGTH_BYTES_FIELD_NUMBER: builtins.int
    session_id: builtins.int
    @property
    def replicas(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Replica]: ...
    class_of_service: builtins.int
    packet_length_bytes: builtins.int
    def __init__(
        self,
        *,
        session_id: builtins.int = ...,
        replicas: collections.abc.Iterable[global___Replica] | None = ...,
        class_of_service: builtins.int = ...,
        packet_length_bytes: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["class_of_service", b"class_of_service", "packet_length_bytes", b"packet_length_bytes", "replicas", b"replicas", "session_id", b"session_id"]) -> None: ...

global___CloneSessionEntry = CloneSessionEntry

@typing_extensions.final
class ValueSetMember(google.protobuf.message.Message):
    """A member in a P4 value set. Each member defines a list of matches, which can
    have different match types.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MATCH_FIELD_NUMBER: builtins.int
    @property
    def match(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FieldMatch]: ...
    def __init__(
        self,
        *,
        match: collections.abc.Iterable[global___FieldMatch] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["match", b"match"]) -> None: ...

global___ValueSetMember = ValueSetMember

@typing_extensions.final
class ValueSetEntry(google.protobuf.message.Message):
    """------------------------------------------------------------------------------
    For writing and reading matches in a parser value set. A state transition
    on an empty value set will never be taken. The number of matches must be at
    most the size of the value set as specified by the size argument of the
    value_set constructor in the P4 program.

    For Write Requests:
      - MODIFY will write the given matches in the repeated field to the value
        set.
      - INSERT and DELETE are not allowed.

    For Read Requests:
      - All matches for all value-set entries if value_set_id = 0
      - All matches of the value-set if a valid value_set_id is specified
      - The 'match' field must never be set in the ReadRequest
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_SET_ID_FIELD_NUMBER: builtins.int
    MEMBERS_FIELD_NUMBER: builtins.int
    value_set_id: builtins.int
    @property
    def members(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ValueSetMember]: ...
    def __init__(
        self,
        *,
        value_set_id: builtins.int = ...,
        members: collections.abc.Iterable[global___ValueSetMember] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["members", b"members", "value_set_id", b"value_set_id"]) -> None: ...

global___ValueSetEntry = ValueSetEntry

@typing_extensions.final
class RegisterEntry(google.protobuf.message.Message):
    """------------------------------------------------------------------------------"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REGISTER_ID_FIELD_NUMBER: builtins.int
    INDEX_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    register_id: builtins.int
    @property
    def index(self) -> global___Index: ...
    @property
    def data(self) -> p4.v1.p4data_pb2.P4Data: ...
    def __init__(
        self,
        *,
        register_id: builtins.int = ...,
        index: global___Index | None = ...,
        data: p4.v1.p4data_pb2.P4Data | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["data", b"data", "index", b"index"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["data", b"data", "index", b"index", "register_id", b"register_id"]) -> None: ...

global___RegisterEntry = RegisterEntry

@typing_extensions.final
class DigestEntry(google.protobuf.message.Message):
    """------------------------------------------------------------------------------
    Used to configure the digest extern only, not to stream digests or acks
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Config(google.protobuf.message.Message):
        """a DigestList message is streamed when the following conditions are met:
          - there is at least one digest ready
          - the oldest digest in the list has been waiting for at least
            max_timeout_ns nanoseconds or we have gathered max_list_size digests
            already
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        MAX_TIMEOUT_NS_FIELD_NUMBER: builtins.int
        MAX_LIST_SIZE_FIELD_NUMBER: builtins.int
        ACK_TIMEOUT_NS_FIELD_NUMBER: builtins.int
        max_timeout_ns: builtins.int
        """max timeout for outstanding digest data"""
        max_list_size: builtins.int
        """max size for a digest list"""
        ack_timeout_ns: builtins.int
        """timeout for DigestListAck message"""
        def __init__(
            self,
            *,
            max_timeout_ns: builtins.int = ...,
            max_list_size: builtins.int = ...,
            ack_timeout_ns: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["ack_timeout_ns", b"ack_timeout_ns", "max_list_size", b"max_list_size", "max_timeout_ns", b"max_timeout_ns"]) -> None: ...

    DIGEST_ID_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    digest_id: builtins.int
    @property
    def config(self) -> global___DigestEntry.Config: ...
    def __init__(
        self,
        *,
        digest_id: builtins.int = ...,
        config: global___DigestEntry.Config | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["config", b"config", "digest_id", b"digest_id"]) -> None: ...

global___DigestEntry = DigestEntry

@typing_extensions.final
class StreamMessageRequest(google.protobuf.message.Message):
    """------------------------------------------------------------------------------"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ARBITRATION_FIELD_NUMBER: builtins.int
    PACKET_FIELD_NUMBER: builtins.int
    DIGEST_ACK_FIELD_NUMBER: builtins.int
    OTHER_FIELD_NUMBER: builtins.int
    @property
    def arbitration(self) -> global___MasterArbitrationUpdate: ...
    @property
    def packet(self) -> global___PacketOut: ...
    @property
    def digest_ack(self) -> global___DigestListAck: ...
    @property
    def other(self) -> google.protobuf.any_pb2.Any: ...
    def __init__(
        self,
        *,
        arbitration: global___MasterArbitrationUpdate | None = ...,
        packet: global___PacketOut | None = ...,
        digest_ack: global___DigestListAck | None = ...,
        other: google.protobuf.any_pb2.Any | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["arbitration", b"arbitration", "digest_ack", b"digest_ack", "other", b"other", "packet", b"packet", "update", b"update"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["arbitration", b"arbitration", "digest_ack", b"digest_ack", "other", b"other", "packet", b"packet", "update", b"update"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["update", b"update"]) -> typing_extensions.Literal["arbitration", "packet", "digest_ack", "other"] | None: ...

global___StreamMessageRequest = StreamMessageRequest

@typing_extensions.final
class PacketOut(google.protobuf.message.Message):
    """Packet sent from the controller to the switch."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYLOAD_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    payload: builtins.bytes
    @property
    def metadata(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PacketMetadata]:
        """This will be based on P4 header annotated as
        @controller_header("packet_out").
        At most one P4 header can have this annotation.
        """
    def __init__(
        self,
        *,
        payload: builtins.bytes = ...,
        metadata: collections.abc.Iterable[global___PacketMetadata] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "payload", b"payload"]) -> None: ...

global___PacketOut = PacketOut

@typing_extensions.final
class DigestListAck(google.protobuf.message.Message):
    """Used by the controller to ack a DigestList message. To avoid flooding the
    controller, the switch must not generate digest notifications for the same
    data until a DigestListAck message with the same list_id is received or the
    ack timeout (ack_timeout_ns field in DigestEntry.Config) expires.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DIGEST_ID_FIELD_NUMBER: builtins.int
    LIST_ID_FIELD_NUMBER: builtins.int
    digest_id: builtins.int
    list_id: builtins.int
    def __init__(
        self,
        *,
        digest_id: builtins.int = ...,
        list_id: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["digest_id", b"digest_id", "list_id", b"list_id"]) -> None: ...

global___DigestListAck = DigestListAck

@typing_extensions.final
class StreamMessageResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ARBITRATION_FIELD_NUMBER: builtins.int
    PACKET_FIELD_NUMBER: builtins.int
    DIGEST_FIELD_NUMBER: builtins.int
    IDLE_TIMEOUT_NOTIFICATION_FIELD_NUMBER: builtins.int
    OTHER_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    @property
    def arbitration(self) -> global___MasterArbitrationUpdate: ...
    @property
    def packet(self) -> global___PacketIn: ...
    @property
    def digest(self) -> global___DigestList: ...
    @property
    def idle_timeout_notification(self) -> global___IdleTimeoutNotification: ...
    @property
    def other(self) -> google.protobuf.any_pb2.Any: ...
    @property
    def error(self) -> global___StreamError:
        """Used by the server to asynchronously report errors which occur when
        processing StreamMessageRequest messages.
        """
    def __init__(
        self,
        *,
        arbitration: global___MasterArbitrationUpdate | None = ...,
        packet: global___PacketIn | None = ...,
        digest: global___DigestList | None = ...,
        idle_timeout_notification: global___IdleTimeoutNotification | None = ...,
        other: google.protobuf.any_pb2.Any | None = ...,
        error: global___StreamError | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["arbitration", b"arbitration", "digest", b"digest", "error", b"error", "idle_timeout_notification", b"idle_timeout_notification", "other", b"other", "packet", b"packet", "update", b"update"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["arbitration", b"arbitration", "digest", b"digest", "error", b"error", "idle_timeout_notification", b"idle_timeout_notification", "other", b"other", "packet", b"packet", "update", b"update"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["update", b"update"]) -> typing_extensions.Literal["arbitration", "packet", "digest", "idle_timeout_notification", "other", "error"] | None: ...

global___StreamMessageResponse = StreamMessageResponse

@typing_extensions.final
class PacketIn(google.protobuf.message.Message):
    """Packet sent from the switch to the controller."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYLOAD_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    payload: builtins.bytes
    @property
    def metadata(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PacketMetadata]:
        """This will be based on P4 header annotated as
        @controller_header("packet_in").
        At most one P4 header can have this annotation.
        """
    def __init__(
        self,
        *,
        payload: builtins.bytes = ...,
        metadata: collections.abc.Iterable[global___PacketMetadata] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["metadata", b"metadata", "payload", b"payload"]) -> None: ...

global___PacketIn = PacketIn

@typing_extensions.final
class DigestList(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DIGEST_ID_FIELD_NUMBER: builtins.int
    LIST_ID_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    digest_id: builtins.int
    """identifies the digest extern instance"""
    list_id: builtins.int
    """identifies a list of entries, used by receiver to ack"""
    @property
    def data(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[p4.v1.p4data_pb2.P4Data]:
        """List of entries: each call to the Digest<T>::pack() method corresponds to
        one entry and we can have as little as one entry.
        """
    timestamp: builtins.int
    """Timestamp at which the server generated the message (in nanoseconds since
    Epoch)
    """
    def __init__(
        self,
        *,
        digest_id: builtins.int = ...,
        list_id: builtins.int = ...,
        data: collections.abc.Iterable[p4.v1.p4data_pb2.P4Data] | None = ...,
        timestamp: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data", b"data", "digest_id", b"digest_id", "list_id", b"list_id", "timestamp", b"timestamp"]) -> None: ...

global___DigestList = DigestList

@typing_extensions.final
class PacketMetadata(google.protobuf.message.Message):
    """Any metadata associated with Packet-IO (controller Packet-In or Packet-Out)
    needs to be modeled as P4 headers carrying special annotations
    @controller_header("packet_out") and @controller_header("packet_in")
    respectively. There can be at most one header each with these annotations.
    These special headers are captured in P4Info ControllerPacketMetadata.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METADATA_ID_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    metadata_id: builtins.int
    """This refers to Metadata.id coming from P4Info ControllerPacketMetadata."""
    value: builtins.bytes
    def __init__(
        self,
        *,
        metadata_id: builtins.int = ...,
        value: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["metadata_id", b"metadata_id", "value", b"value"]) -> None: ...

global___PacketMetadata = PacketMetadata

@typing_extensions.final
class MasterArbitrationUpdate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEVICE_ID_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    ELECTION_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    device_id: builtins.int
    @property
    def role(self) -> global___Role:
        """The role for which the primary client is being arbitrated. For use-cases
        where multiple roles are not needed, the controller can leave this unset,
        implying default role and full pipeline access.
        """
    @property
    def election_id(self) -> global___Uint128:
        """The stream RPC with the highest election_id is the primary. The 'primary'
        controller instance populates this with its latest election_id. Switch
        populates with the highest election ID it has received from all connected
        controllers.
        """
    @property
    def status(self) -> google.rpc.status_pb2.Status:
        """Switch populates this with OK for the client that is the primary, and
        with an error status for all other connected clients (at every primary
        client change). The controller does not populate this field.
        """
    def __init__(
        self,
        *,
        device_id: builtins.int = ...,
        role: global___Role | None = ...,
        election_id: global___Uint128 | None = ...,
        status: google.rpc.status_pb2.Status | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["election_id", b"election_id", "role", b"role", "status", b"status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["device_id", b"device_id", "election_id", b"election_id", "role", b"role", "status", b"status"]) -> None: ...

global___MasterArbitrationUpdate = MasterArbitrationUpdate

@typing_extensions.final
class Role(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    id: builtins.int
    """Uniquely identifies this role."""
    name: builtins.str
    @property
    def config(self) -> google.protobuf.any_pb2.Any:
        """Describes the role configuration, i.e. what operations, P4 entities,
        behaviors, etc. are in the scope of a given role. If config is not set
        (default case), it implies all P4 objects and control behaviors are in
        scope, i.e. full pipeline access. The format of this message is
        out-of-scope of P4Runtime.
        """
    def __init__(
        self,
        *,
        id: builtins.int = ...,
        name: builtins.str = ...,
        config: google.protobuf.any_pb2.Any | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["config", b"config", "id", b"id", "name", b"name"]) -> None: ...

global___Role = Role

@typing_extensions.final
class IdleTimeoutNotification(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TABLE_ENTRY_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    @property
    def table_entry(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TableEntry]:
        """The only fields that are required to be set in each TableEntry are the
        "key" fields (table_id, match and priority) along with controller_metadata,
        metadata and idle_timeout_ns.
        """
    timestamp: builtins.int
    """Timestamp at which the server generated the message (in nanoseconds since
    Epoch)
    """
    def __init__(
        self,
        *,
        table_entry: collections.abc.Iterable[global___TableEntry] | None = ...,
        timestamp: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["table_entry", b"table_entry", "timestamp", b"timestamp"]) -> None: ...

global___IdleTimeoutNotification = IdleTimeoutNotification

@typing_extensions.final
class StreamError(google.protobuf.message.Message):
    """Used by the server to asynchronously report errors which occur when
    processing StreamMessageRequest messages.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CANONICAL_CODE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    SPACE_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    PACKET_OUT_FIELD_NUMBER: builtins.int
    DIGEST_LIST_ACK_FIELD_NUMBER: builtins.int
    OTHER_FIELD_NUMBER: builtins.int
    canonical_code: builtins.int
    """gRPC canonical error code (see
    https://developers.google.com/maps-booking/reference/grpc-api/status_codes)
    """
    message: builtins.str
    """Optional. An explanation of the error."""
    space: builtins.str
    """Optional. Target and architecture specific space to which this error
    belongs.
    We encourage using triplet: <target>-<arch>-<vendor>,
    e.g."targetX-psa-vendor1" or "targetY-psa-vendor2".
    """
    code: builtins.int
    """Optional. Numeric code drawn from target-specific error space above."""
    @property
    def packet_out(self) -> global___PacketOutError: ...
    @property
    def digest_list_ack(self) -> global___DigestListAckError: ...
    @property
    def other(self) -> global___StreamOtherError: ...
    def __init__(
        self,
        *,
        canonical_code: builtins.int = ...,
        message: builtins.str = ...,
        space: builtins.str = ...,
        code: builtins.int = ...,
        packet_out: global___PacketOutError | None = ...,
        digest_list_ack: global___DigestListAckError | None = ...,
        other: global___StreamOtherError | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["details", b"details", "digest_list_ack", b"digest_list_ack", "other", b"other", "packet_out", b"packet_out"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["canonical_code", b"canonical_code", "code", b"code", "details", b"details", "digest_list_ack", b"digest_list_ack", "message", b"message", "other", b"other", "packet_out", b"packet_out", "space", b"space"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["details", b"details"]) -> typing_extensions.Literal["packet_out", "digest_list_ack", "other"] | None: ...

global___StreamError = StreamError

@typing_extensions.final
class PacketOutError(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PACKET_OUT_FIELD_NUMBER: builtins.int
    @property
    def packet_out(self) -> global___PacketOut:
        """Optional. The packet out message that caused the error."""
    def __init__(
        self,
        *,
        packet_out: global___PacketOut | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["packet_out", b"packet_out"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["packet_out", b"packet_out"]) -> None: ...

global___PacketOutError = PacketOutError

@typing_extensions.final
class DigestListAckError(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DIGEST_LIST_ACK_FIELD_NUMBER: builtins.int
    @property
    def digest_list_ack(self) -> global___DigestListAck:
        """Optional. The digest list acknowledgement message that caused the error."""
    def __init__(
        self,
        *,
        digest_list_ack: global___DigestListAck | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["digest_list_ack", b"digest_list_ack"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["digest_list_ack", b"digest_list_ack"]) -> None: ...

global___DigestListAckError = DigestListAckError

@typing_extensions.final
class StreamOtherError(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OTHER_FIELD_NUMBER: builtins.int
    @property
    def other(self) -> google.protobuf.any_pb2.Any:
        """Optional. The architecture-specific stream message that caused the error."""
    def __init__(
        self,
        *,
        other: google.protobuf.any_pb2.Any | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["other", b"other"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["other", b"other"]) -> None: ...

global___StreamOtherError = StreamOtherError

@typing_extensions.final
class Uint128(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HIGH_FIELD_NUMBER: builtins.int
    LOW_FIELD_NUMBER: builtins.int
    high: builtins.int
    """Highest 64 bits of a 128 bit number."""
    low: builtins.int
    """Lowest 64 bits of a 128 bit number."""
    def __init__(
        self,
        *,
        high: builtins.int = ...,
        low: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["high", b"high", "low", b"low"]) -> None: ...

global___Uint128 = Uint128

@typing_extensions.final
class SetForwardingPipelineConfigRequest(google.protobuf.message.Message):
    """------------------------------------------------------------------------------"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Action:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ActionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SetForwardingPipelineConfigRequest._Action.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNSPECIFIED: SetForwardingPipelineConfigRequest._Action.ValueType  # 0
        VERIFY: SetForwardingPipelineConfigRequest._Action.ValueType  # 1
        """Verify that the target can realize the given config. Do not modify the
        forwarding state in the target. Returns error if config is not provided
        of if the provided config cannot be realized.
        """
        VERIFY_AND_SAVE: SetForwardingPipelineConfigRequest._Action.ValueType  # 2
        """Save the config if the target can realize it. Do not modify the
        forwarding state in the target. Any subsequent read/write requests must
        refer to fields in the new config. Returns error if config is not
        provided of if the provided config cannot be realized.
        """
        VERIFY_AND_COMMIT: SetForwardingPipelineConfigRequest._Action.ValueType  # 3
        """Verify, save and realize the given config. Clear the forwarding state
        in the target. Returns error if config is not provided of if the
        provided config cannot be realized.
        """
        COMMIT: SetForwardingPipelineConfigRequest._Action.ValueType  # 4
        """Realize the last saved, but not yet committed, config. Update the
        forwarding state in the target by replaying the write requests since the
        last config was saved. Config should not be provided for this action
        type. Returns an error if no saved config is found or if a config is
        provided with this message.
        """
        RECONCILE_AND_COMMIT: SetForwardingPipelineConfigRequest._Action.ValueType  # 5
        """Verify, save and realize the given config, while preserving the
        forwarding state in the target. This is an advanced use case to enable
        changes to the P4 forwarding pipeline configuration with minimal traffic
        loss. P4Runtime does not impose any constraints on the duration of the
        traffic loss. The support for this option is not expected to be uniform
        across all P4Runtime targets. A target that does not support this option
        may return an UNIMPLEMENTED error. For targets that support this option,
        an INVALID_ARGUMENT error is returned if no config is provided, or if
        the existing forwarding state cannot be preserved for the given config
        by the target.
        """

    class Action(_Action, metaclass=_ActionEnumTypeWrapper): ...
    UNSPECIFIED: SetForwardingPipelineConfigRequest.Action.ValueType  # 0
    VERIFY: SetForwardingPipelineConfigRequest.Action.ValueType  # 1
    """Verify that the target can realize the given config. Do not modify the
    forwarding state in the target. Returns error if config is not provided
    of if the provided config cannot be realized.
    """
    VERIFY_AND_SAVE: SetForwardingPipelineConfigRequest.Action.ValueType  # 2
    """Save the config if the target can realize it. Do not modify the
    forwarding state in the target. Any subsequent read/write requests must
    refer to fields in the new config. Returns error if config is not
    provided of if the provided config cannot be realized.
    """
    VERIFY_AND_COMMIT: SetForwardingPipelineConfigRequest.Action.ValueType  # 3
    """Verify, save and realize the given config. Clear the forwarding state
    in the target. Returns error if config is not provided of if the
    provided config cannot be realized.
    """
    COMMIT: SetForwardingPipelineConfigRequest.Action.ValueType  # 4
    """Realize the last saved, but not yet committed, config. Update the
    forwarding state in the target by replaying the write requests since the
    last config was saved. Config should not be provided for this action
    type. Returns an error if no saved config is found or if a config is
    provided with this message.
    """
    RECONCILE_AND_COMMIT: SetForwardingPipelineConfigRequest.Action.ValueType  # 5
    """Verify, save and realize the given config, while preserving the
    forwarding state in the target. This is an advanced use case to enable
    changes to the P4 forwarding pipeline configuration with minimal traffic
    loss. P4Runtime does not impose any constraints on the duration of the
    traffic loss. The support for this option is not expected to be uniform
    across all P4Runtime targets. A target that does not support this option
    may return an UNIMPLEMENTED error. For targets that support this option,
    an INVALID_ARGUMENT error is returned if no config is provided, or if
    the existing forwarding state cannot be preserved for the given config
    by the target.
    """

    DEVICE_ID_FIELD_NUMBER: builtins.int
    ROLE_ID_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    ELECTION_ID_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    device_id: builtins.int
    role_id: builtins.int
    role: builtins.str
    @property
    def election_id(self) -> global___Uint128: ...
    action: global___SetForwardingPipelineConfigRequest.Action.ValueType
    @property
    def config(self) -> global___ForwardingPipelineConfig: ...
    def __init__(
        self,
        *,
        device_id: builtins.int = ...,
        role_id: builtins.int = ...,
        role: builtins.str = ...,
        election_id: global___Uint128 | None = ...,
        action: global___SetForwardingPipelineConfigRequest.Action.ValueType = ...,
        config: global___ForwardingPipelineConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["config", b"config", "election_id", b"election_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action", b"action", "config", b"config", "device_id", b"device_id", "election_id", b"election_id", "role", b"role", "role_id", b"role_id"]) -> None: ...

global___SetForwardingPipelineConfigRequest = SetForwardingPipelineConfigRequest

@typing_extensions.final
class SetForwardingPipelineConfigResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___SetForwardingPipelineConfigResponse = SetForwardingPipelineConfigResponse

@typing_extensions.final
class ForwardingPipelineConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Cookie(google.protobuf.message.Message):
        """Metadata (cookie) opaque to the target. A control plane may use this field
        to uniquely identify this config. There are no restrictions on how such
        value is computed, or where this is stored on the target, as long as it is
        returned with a GetForwardingPipelineConfig RPC. When reading the cookie,
        we need to distinguish those cases where a cookie is NOT present (e.g. not
        set in the SetForwardingPipelineConfigRequest, therefore we wrap the actual
        uint64 value in a protobuf message.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        COOKIE_FIELD_NUMBER: builtins.int
        cookie: builtins.int
        def __init__(
            self,
            *,
            cookie: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["cookie", b"cookie"]) -> None: ...

    P4INFO_FIELD_NUMBER: builtins.int
    P4_DEVICE_CONFIG_FIELD_NUMBER: builtins.int
    COOKIE_FIELD_NUMBER: builtins.int
    @property
    def p4info(self) -> p4.config.v1.p4info_pb2.P4Info: ...
    p4_device_config: builtins.bytes
    """Target-specific P4 configuration."""
    @property
    def cookie(self) -> global___ForwardingPipelineConfig.Cookie: ...
    def __init__(
        self,
        *,
        p4info: p4.config.v1.p4info_pb2.P4Info | None = ...,
        p4_device_config: builtins.bytes = ...,
        cookie: global___ForwardingPipelineConfig.Cookie | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cookie", b"cookie", "p4info", b"p4info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cookie", b"cookie", "p4_device_config", b"p4_device_config", "p4info", b"p4info"]) -> None: ...

global___ForwardingPipelineConfig = ForwardingPipelineConfig

@typing_extensions.final
class GetForwardingPipelineConfigRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ResponseType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ResponseTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[GetForwardingPipelineConfigRequest._ResponseType.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ALL: GetForwardingPipelineConfigRequest._ResponseType.ValueType  # 0
        """Default behaviour. Returns a ForwardingPipelineConfig with all fields set
        as stored by the target.
        """
        COOKIE_ONLY: GetForwardingPipelineConfigRequest._ResponseType.ValueType  # 1
        """Reply by setting only the cookie field, omitting all other fields."""
        P4INFO_AND_COOKIE: GetForwardingPipelineConfigRequest._ResponseType.ValueType  # 2
        """Reply by setting the p4info and cookie fields."""
        DEVICE_CONFIG_AND_COOKIE: GetForwardingPipelineConfigRequest._ResponseType.ValueType  # 3
        """Reply by setting the p4_device_config and cookie fields."""

    class ResponseType(_ResponseType, metaclass=_ResponseTypeEnumTypeWrapper):
        """Specifies the fields to populate in the response."""

    ALL: GetForwardingPipelineConfigRequest.ResponseType.ValueType  # 0
    """Default behaviour. Returns a ForwardingPipelineConfig with all fields set
    as stored by the target.
    """
    COOKIE_ONLY: GetForwardingPipelineConfigRequest.ResponseType.ValueType  # 1
    """Reply by setting only the cookie field, omitting all other fields."""
    P4INFO_AND_COOKIE: GetForwardingPipelineConfigRequest.ResponseType.ValueType  # 2
    """Reply by setting the p4info and cookie fields."""
    DEVICE_CONFIG_AND_COOKIE: GetForwardingPipelineConfigRequest.ResponseType.ValueType  # 3
    """Reply by setting the p4_device_config and cookie fields."""

    DEVICE_ID_FIELD_NUMBER: builtins.int
    RESPONSE_TYPE_FIELD_NUMBER: builtins.int
    device_id: builtins.int
    response_type: global___GetForwardingPipelineConfigRequest.ResponseType.ValueType
    def __init__(
        self,
        *,
        device_id: builtins.int = ...,
        response_type: global___GetForwardingPipelineConfigRequest.ResponseType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["device_id", b"device_id", "response_type", b"response_type"]) -> None: ...

global___GetForwardingPipelineConfigRequest = GetForwardingPipelineConfigRequest

@typing_extensions.final
class GetForwardingPipelineConfigResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONFIG_FIELD_NUMBER: builtins.int
    @property
    def config(self) -> global___ForwardingPipelineConfig: ...
    def __init__(
        self,
        *,
        config: global___ForwardingPipelineConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["config", b"config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["config", b"config"]) -> None: ...

global___GetForwardingPipelineConfigResponse = GetForwardingPipelineConfigResponse

@typing_extensions.final
class Error(google.protobuf.message.Message):
    """Error message used to report a single P4-entity error for a Write RPC."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CANONICAL_CODE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    SPACE_FIELD_NUMBER: builtins.int
    CODE_FIELD_NUMBER: builtins.int
    DETAILS_FIELD_NUMBER: builtins.int
    canonical_code: builtins.int
    """gRPC canonical error code (see
    https://developers.google.com/maps-booking/reference/grpc-api/status_codes)
    """
    message: builtins.str
    """Detailed error message."""
    space: builtins.str
    """Target and architecture specific space to which this error belongs.
    We encourage using triplet: <target>-<arch>-<vendor>,
    e.g."targetX-psa-vendor1" or "targetY-psa-vendor2".
    """
    code: builtins.int
    """Numeric code drawn from target-specific error space above."""
    @property
    def details(self) -> google.protobuf.any_pb2.Any:
        """Optional: Allows reporting back additional target-specific details on the
        error.
        """
    def __init__(
        self,
        *,
        canonical_code: builtins.int = ...,
        message: builtins.str = ...,
        space: builtins.str = ...,
        code: builtins.int = ...,
        details: google.protobuf.any_pb2.Any | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["details", b"details"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["canonical_code", b"canonical_code", "code", b"code", "details", b"details", "message", b"message", "space", b"space"]) -> None: ...

global___Error = Error

@typing_extensions.final
class CapabilitiesRequest(google.protobuf.message.Message):
    """------------------------------------------------------------------------------"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___CapabilitiesRequest = CapabilitiesRequest

@typing_extensions.final
class CapabilitiesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    P4RUNTIME_API_VERSION_FIELD_NUMBER: builtins.int
    p4runtime_api_version: builtins.str
    """The full semantic version string (e.g. "1.1.0-rc.1") corresponding to the
    version of the P4Runtime API currently implemented by the server.
    """
    def __init__(
        self,
        *,
        p4runtime_api_version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["p4runtime_api_version", b"p4runtime_api_version"]) -> None: ...

global___CapabilitiesResponse = CapabilitiesResponse
