import { AwsCdkPythonApp, CdkConfigCommonOptions } from 'projen/lib/awscdk';
import { GitHubProjectOptions } from 'projen/lib/github';
/**
 * TODO
 *
 * @export
 * @interface ButterneckAwsCdkPythonAppOptions
 * @extends {GitHubProjectOptions}
 * @extends {CdkConfigCommonOptions}
 */
export interface ButterneckAwsCdkPythonAppOptions extends GitHubProjectOptions, CdkConfigCommonOptions {
    /**
       * Name of the python package as used in imports and filenames.
       *
       * Must only consist of alphanumeric characters and underscores.
       *
       * @default ""
       */
    readonly moduleName?: string;
    /**
       * Author's name
       *
       * @default "Filippo Pinton"
       */
    readonly authorName?: string;
    /**
       * Author's e-mail
       *
       * @default "pinton.filippo@protonmail.com"
       */
    readonly authorEmail?: string;
    /**
       * Version of the package.
       *
       * @default "0.0.0"
       * @featured
       */
    readonly version?: string;
    /**
       * Minimum version of the AWS CDK to depend on.
       *
       * @default "2.74.0"
       */
    readonly cdkVersion?: string;
    /**
       * Minimum version of the `constructs` library to depend on.
       *
       * @default "10.0.5".
       */
    readonly constructsVersion?: string;
    /**
       * List of runtime dependencies for this project.
       *
       * Dependencies use the format: `<module>@<semver>`
       *
       * Additional dependencies can be added via `project.addDependency()`.
       *
       * @default "[ 'butterneck-cdk-constructs' ]"
       * @featured
       */
    readonly deps?: string[];
    /**
       * List of dev dependencies for this project.
       *
       * Dependencies use the format: `<module>@<semver>`
       *
       * Additional dependencies can be added via `project.addDevDependency()`.
       *
       * @default []
       * @featured
       */
    readonly devDeps?: string[];
}
/**
 *
 *
 * @export
 * @class ButterneckAwsCdkPythonApp
 * @extends {AwsCdkPythonApp}
 * @pjid awscdk-app-py
 */
export declare class ButterneckAwsCdkPythonApp extends AwsCdkPythonApp {
    constructor(options: ButterneckAwsCdkPythonAppOptions);
}
