"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ButterneckAwsCdkPythonApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const projen_1 = require("projen");
const awscdk_1 = require("projen/lib/awscdk");
/**
 *
 *
 * @export
 * @class ButterneckAwsCdkPythonApp
 * @extends {AwsCdkPythonApp}
 * @pjid awscdk-app-py
 */
class ButterneckAwsCdkPythonApp extends awscdk_1.AwsCdkPythonApp {
    constructor(options) {
        let optionsWithDefaults = {
            ...options,
            // Overridable defaults
            moduleName: options.moduleName ?? '',
            authorName: options.authorName ?? 'Filippo Pinton',
            authorEmail: options.authorEmail ?? 'pinton.filippo@protonmail.com',
            version: options.version ?? '0.0.0',
            cdkVersion: options.cdkVersion ?? '2.74.0',
            // Defaults
            sample: false,
            deps: [
                ...options.deps ?? [],
                ...['butterneck-projen@0.0.4'],
            ],
        };
        super(optionsWithDefaults);
        new ButterneckAppCode(this, 'app.py');
        new ButterneckStackCode(this);
    }
}
exports.ButterneckAwsCdkPythonApp = ButterneckAwsCdkPythonApp;
_a = JSII_RTTI_SYMBOL_1;
ButterneckAwsCdkPythonApp[_a] = { fqn: "butterneck-projen.ButterneckAwsCdkPythonApp", version: "0.0.8" };
/**
 * TODO
 *
 * @class ButterneckAppCode
 * @extends {Component}
 */
class ButterneckAppCode extends projen_1.Component {
    constructor(project, fileName) {
        super(project);
        new projen_1.SampleFile(project, fileName, {
            contents: [
                '#!/usr/bin/env python3',
                'from aws_cdk import App',
                'from stacks.stack import Stack',
                '',
                'app = App()',
                '',
                'Stack(app)',
                '',
                'app.synth()',
                '',
            ].join('\n'),
        });
    }
}
/**
 * TODO
 *
 * @class ButterneckStackCode
 * @extends {Component}
 */
class ButterneckStackCode extends projen_1.Component {
    constructor(project) {
        super(project);
        let stackFile = [
            'from aws_cdk import (',
            '    App,',
            ')',
            'from butterneck_cdk_constructs import ButterneckStack',
            '',
            'class Stack(ButterneckStack):',
            '    def __init__(self, scope: App) -> None:',
            `        super().__init__(scope, '${project.name}')`,
            '',
        ];
        new projen_1.SampleDir(project, 'stacks', {
            files: {
                '__init__.py': '',
                'stack.py': stackFile.join('\n'),
            },
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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