import { GitHubProject, GitHubProjectOptions } from 'projen/lib/github';
import { ButterneckAwsCdkPythonApp, ButterneckAwsCdkPythonAppOptions } from './awscdk-python-app';
import { GoProject, GoProjectOptions } from './go-project';
export interface GoAppOptions extends GitHubProjectOptions {
    readonly infra: ButterneckAwsCdkPythonAppOptions;
    readonly service: GoProjectOptions;
}
/**
 * GoApp Project
 *
 * @export
 * @class GoApp
 * @extends {awscdk.AwsCdkPythonApp}
 * @pjid go-app
 */
export declare class GoApp extends GitHubProject {
    infra: ButterneckAwsCdkPythonApp;
    service: GoProject;
    constructor(options: GoAppOptions);
}
