"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const github_1 = require("projen/lib/github");
const javascript_1 = require("projen/lib/javascript");
const awscdk_python_app_1 = require("./awscdk-python-app");
const go_project_1 = require("./go-project");
/**
 * GoApp Project
 *
 * @export
 * @class GoApp
 * @extends {awscdk.AwsCdkPythonApp}
 * @pjid go-app
 */
class GoApp extends github_1.GitHubProject {
    constructor(options) {
        super(options);
        new javascript_1.Projenrc(this);
        this.infra = new awscdk_python_app_1.ButterneckAwsCdkPythonApp({
            ...options.infra,
            name: options.infra.name ?? options.name,
            parent: this,
            outdir: options.infra.outdir ?? 'infra',
        });
        this.service = new go_project_1.GoProject({
            ...options.service,
            name: options.service.name ?? options.name,
            parent: this,
            outdir: options.service.outdir ?? 'src',
        });
    }
}
exports.GoApp = GoApp;
_a = JSII_RTTI_SYMBOL_1;
GoApp[_a] = { fqn: "butterneck-projen.GoApp", version: "0.0.8" };
//# sourceMappingURL=data:application/json;base64,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