# mypy-boto3-signer

[![PyPI - mypy-boto3-signer](https://img.shields.io/pypi/v/mypy-boto3-signer.svg?color=blue)](https://pypi.org/project/mypy-boto3-signer)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-signer.svg?color=blue)](https://pypi.org/project/mypy-boto3-signer)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.Signer 1.12.10](https://boto3.amazonaws.com/v1/documentation/api/1.12.10/reference/services/signer.html#Signer) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.3](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-signer](#mypy-boto3-signer)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `Signer` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-signer]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import signer
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_signer as signer

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("signer")
client: signer.SignerClient = boto3.client("signer")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: signer.SignerClient = session.client("signer")


# Waiters need type annotation on creation
successful_signing_job_waiter: signer.SuccessfulSigningJobWaiter = client.get_waiter("successful_signing_job")

# Paginators need type annotation on creation
list_signing_jobs_paginator: signer.ListSigningJobsPaginator = client.get_paginator("list_signing_jobs")
list_signing_platforms_paginator: signer.ListSigningPlatformsPaginator = client.get_paginator("list_signing_platforms")
list_signing_profiles_paginator: signer.ListSigningProfilesPaginator = client.get_paginator("list_signing_profiles")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.