
[![Python package](https://github.com/inductiva/inductiva/actions/workflows/python-package.yml/badge.svg)](https://github.com/inductiva/inductiva/actions/workflows/python-package.yml) [![Python version](https://img.shields.io/pypi/pyversions/inductiva.svg)](https://www.python.org/downloads/) [![Documentation](https://img.shields.io/badge/Documentation-blue.svg)](https://docs.inductiva.ai/en/latest/) [![Benchmarks](https://img.shields.io/badge/Benchmarks-blue.svg)](https://benchmarks.inductiva.ai) <a href="https://pypi.org/project/inductiva/"><img src="https://img.shields.io/pypi/v/inductiva" alt="pypi version"></a> ![coverage badge](https://raw.githubusercontent.com/inductiva/inductiva/Inductiva-badges/badges/cov.svg)

![inductiva_banner](https://github.com/inductiva/inductiva/assets/7538022/85569dd8-3beb-4ac3-8cbe-78e300a28fde)

# Inductiva: a Python package for scaling simulations on the Cloud


Welcome to the official Python library for the Inductiva API.

The Inductiva API allows running a set of open-source physical
simulators on the cloud, easily parallelizing simulations, each running
on hundreds of CPU cores.

Inductiva simplifies the complexities of cloud resource management, and software
configuration, offering a straightforward Python interface for running simulations
on state-of-the-art hardware. This allows scientists and engineers to focus their
time and energy on what matters: running simulations that solve real problems.


# System Requirements

- Python >= 3.9 
- pip (or pip3) to install the inductiva package
  
# Getting started

1. Register at:

[https://console.inductiva.ai](https://console.inductiva.ai)

2. Install the Inductiva Python Package
```
pip install inductiva
```
3. Authenticate with your API Key
```
inductiva auth login
```


To find out more, check our [documentation](https://docs.inductiva.ai/).


If you have any questions or suggestions about the API please
[open an issue on the inductiva’s API Client GitHub repo](https://github.com/inductiva/inductiva/issues),
or contact us via [support@inductiva.ai](mailto:support@inductiva.ai).
