# coding: utf-8

"""
    InductivaWebAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import List, Optional, Union
from typing_extensions import Annotated
from inductiva.client.models.available_simulator_versions import AvailableSimulatorVersions
from inductiva.client.models.bulk_simulator_operation import BulkSimulatorOperation
from inductiva.client.models.bulk_simulator_response import BulkSimulatorResponse
from inductiva.client.models.machine_filter_options import MachineFilterOptions
from inductiva.client.models.providers import Providers
from inductiva.client.models.simulator_create import SimulatorCreate
from inductiva.client.models.simulator_response import SimulatorResponse
from inductiva.client.models.simulator_update import SimulatorUpdate
from inductiva.client.models.simulator_with_machine_types_paginated import SimulatorWithMachineTypesPaginated

from inductiva.client.api_client import ApiClient, RequestSerialized
from inductiva.client.api_response import ApiResponse
from inductiva.client.rest import RESTResponseType


class SimulatorsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def bulk_archive_simulators(
        self,
        bulk_simulator_operation: BulkSimulatorOperation,
        archive: Optional[StrictBool] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BulkSimulatorResponse:
        """Bulk Archive Simulators

        Bulk archive/unarchive simulators.

        :param bulk_simulator_operation: (required)
        :type bulk_simulator_operation: BulkSimulatorOperation
        :param archive:
        :type archive: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_archive_simulators_serialize(
            bulk_simulator_operation=bulk_simulator_operation,
            archive=archive,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkSimulatorResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def bulk_archive_simulators_with_http_info(
        self,
        bulk_simulator_operation: BulkSimulatorOperation,
        archive: Optional[StrictBool] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BulkSimulatorResponse]:
        """Bulk Archive Simulators

        Bulk archive/unarchive simulators.

        :param bulk_simulator_operation: (required)
        :type bulk_simulator_operation: BulkSimulatorOperation
        :param archive:
        :type archive: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_archive_simulators_serialize(
            bulk_simulator_operation=bulk_simulator_operation,
            archive=archive,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkSimulatorResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def bulk_archive_simulators_without_preload_content(
        self,
        bulk_simulator_operation: BulkSimulatorOperation,
        archive: Optional[StrictBool] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Bulk Archive Simulators

        Bulk archive/unarchive simulators.

        :param bulk_simulator_operation: (required)
        :type bulk_simulator_operation: BulkSimulatorOperation
        :param archive:
        :type archive: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_archive_simulators_serialize(
            bulk_simulator_operation=bulk_simulator_operation,
            archive=archive,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkSimulatorResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _bulk_archive_simulators_serialize(
        self,
        bulk_simulator_operation,
        archive,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes],
                                List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if archive is not None:

            _query_params.append(('archive', archive))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if bulk_simulator_operation is not None:
            _body_params = bulk_simulator_operation

        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                ['application/json'])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (self.api_client.select_header_content_type(
                ['application/json']))
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ['APIKeyHeader']

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/simulators/bulk/archive',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)

    @validate_call
    def bulk_delete_simulators(
        self,
        bulk_simulator_operation: BulkSimulatorOperation,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BulkSimulatorResponse:
        """Bulk Delete Simulators

        Bulk delete simulators.

        :param bulk_simulator_operation: (required)
        :type bulk_simulator_operation: BulkSimulatorOperation
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_delete_simulators_serialize(
            bulk_simulator_operation=bulk_simulator_operation,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkSimulatorResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def bulk_delete_simulators_with_http_info(
        self,
        bulk_simulator_operation: BulkSimulatorOperation,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BulkSimulatorResponse]:
        """Bulk Delete Simulators

        Bulk delete simulators.

        :param bulk_simulator_operation: (required)
        :type bulk_simulator_operation: BulkSimulatorOperation
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_delete_simulators_serialize(
            bulk_simulator_operation=bulk_simulator_operation,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkSimulatorResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def bulk_delete_simulators_without_preload_content(
        self,
        bulk_simulator_operation: BulkSimulatorOperation,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Bulk Delete Simulators

        Bulk delete simulators.

        :param bulk_simulator_operation: (required)
        :type bulk_simulator_operation: BulkSimulatorOperation
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_delete_simulators_serialize(
            bulk_simulator_operation=bulk_simulator_operation,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkSimulatorResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _bulk_delete_simulators_serialize(
        self,
        bulk_simulator_operation,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes],
                                List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if bulk_simulator_operation is not None:
            _body_params = bulk_simulator_operation

        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                ['application/json'])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (self.api_client.select_header_content_type(
                ['application/json']))
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ['APIKeyHeader']

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/simulators/bulk/delete',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)

    @validate_call
    def create_simulator(
        self,
        simulator_create: SimulatorCreate,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SimulatorResponse:
        """Create Simulator

        Create a new simulator.

        :param simulator_create: (required)
        :type simulator_create: SimulatorCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_simulator_serialize(
            simulator_create=simulator_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "SimulatorResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def create_simulator_with_http_info(
        self,
        simulator_create: SimulatorCreate,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SimulatorResponse]:
        """Create Simulator

        Create a new simulator.

        :param simulator_create: (required)
        :type simulator_create: SimulatorCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_simulator_serialize(
            simulator_create=simulator_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "SimulatorResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def create_simulator_without_preload_content(
        self,
        simulator_create: SimulatorCreate,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Simulator

        Create a new simulator.

        :param simulator_create: (required)
        :type simulator_create: SimulatorCreate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_simulator_serialize(
            simulator_create=simulator_create,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "SimulatorResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_simulator_serialize(
        self,
        simulator_create,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes],
                                List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if simulator_create is not None:
            _body_params = simulator_create

        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                ['application/json'])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (self.api_client.select_header_content_type(
                ['application/json']))
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ['APIKeyHeader']

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/simulators/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)

    @validate_call
    def delete_simulator(
        self,
        simulator_id: StrictStr,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete Simulator

        Delete a simulator.

        :param simulator_id: (required)
        :type simulator_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_simulator_serialize(simulator_id=simulator_id,
                                                  _request_auth=_request_auth,
                                                  _content_type=_content_type,
                                                  _headers=_headers,
                                                  _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def delete_simulator_with_http_info(
        self,
        simulator_id: StrictStr,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete Simulator

        Delete a simulator.

        :param simulator_id: (required)
        :type simulator_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_simulator_serialize(simulator_id=simulator_id,
                                                  _request_auth=_request_auth,
                                                  _content_type=_content_type,
                                                  _headers=_headers,
                                                  _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def delete_simulator_without_preload_content(
        self,
        simulator_id: StrictStr,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete Simulator

        Delete a simulator.

        :param simulator_id: (required)
        :type simulator_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_simulator_serialize(simulator_id=simulator_id,
                                                  _request_auth=_request_auth,
                                                  _content_type=_content_type,
                                                  _headers=_headers,
                                                  _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _delete_simulator_serialize(
        self,
        simulator_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes],
                                List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if simulator_id is not None:
            _path_params['simulator_id'] = simulator_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                ['application/json'])

        # authentication setting
        _auth_settings: List[str] = ['APIKeyHeader']

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/simulators/{simulator_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)

    @validate_call
    def get_machine_filter_options(
        self,
        provider_id: Optional[Providers] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MachineFilterOptions:
        """Get Machine Filter Options

        Get available filter options for machine types.  This endpoint returns all available filter options calculated from the complete dataset of machine types for the given provider.

        :param provider_id:
        :type provider_id: Providers
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_machine_filter_options_serialize(
            provider_id=provider_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MachineFilterOptions",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_machine_filter_options_with_http_info(
        self,
        provider_id: Optional[Providers] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MachineFilterOptions]:
        """Get Machine Filter Options

        Get available filter options for machine types.  This endpoint returns all available filter options calculated from the complete dataset of machine types for the given provider.

        :param provider_id:
        :type provider_id: Providers
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_machine_filter_options_serialize(
            provider_id=provider_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MachineFilterOptions",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_machine_filter_options_without_preload_content(
        self,
        provider_id: Optional[Providers] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Machine Filter Options

        Get available filter options for machine types.  This endpoint returns all available filter options calculated from the complete dataset of machine types for the given provider.

        :param provider_id:
        :type provider_id: Providers
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_machine_filter_options_serialize(
            provider_id=provider_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MachineFilterOptions",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_machine_filter_options_serialize(
        self,
        provider_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes],
                                List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if provider_id is not None:

            _query_params.append(('provider_id', provider_id.value))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                ['application/json'])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/simulators/machine-types/filter-options',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)

    @validate_call
    def get_simulator_specific_filter_options(
        self,
        simulator_name: StrictStr,
        provider_id: Optional[Providers] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MachineFilterOptions:
        """Get Simulator Specific Filter Options

        Get available filter options for machine types specific to a simulator.  This endpoint returns filter options calculated  from ALL available machine types  for the specific simulator (considering processor type, machine class, etc.) without any pagination restrictions.  Args:     simulator_name: Name of the simulator to get filter options for     provider_id: Provider ID to filter by      Returns:     MachineFilterOptions with all      available options for the specific simulator

        :param simulator_name: (required)
        :type simulator_name: str
        :param provider_id:
        :type provider_id: Providers
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_simulator_specific_filter_options_serialize(
            simulator_name=simulator_name,
            provider_id=provider_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MachineFilterOptions",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_simulator_specific_filter_options_with_http_info(
        self,
        simulator_name: StrictStr,
        provider_id: Optional[Providers] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MachineFilterOptions]:
        """Get Simulator Specific Filter Options

        Get available filter options for machine types specific to a simulator.  This endpoint returns filter options calculated  from ALL available machine types  for the specific simulator (considering processor type, machine class, etc.) without any pagination restrictions.  Args:     simulator_name: Name of the simulator to get filter options for     provider_id: Provider ID to filter by      Returns:     MachineFilterOptions with all      available options for the specific simulator

        :param simulator_name: (required)
        :type simulator_name: str
        :param provider_id:
        :type provider_id: Providers
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_simulator_specific_filter_options_serialize(
            simulator_name=simulator_name,
            provider_id=provider_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MachineFilterOptions",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_simulator_specific_filter_options_without_preload_content(
        self,
        simulator_name: StrictStr,
        provider_id: Optional[Providers] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Simulator Specific Filter Options

        Get available filter options for machine types specific to a simulator.  This endpoint returns filter options calculated  from ALL available machine types  for the specific simulator (considering processor type, machine class, etc.) without any pagination restrictions.  Args:     simulator_name: Name of the simulator to get filter options for     provider_id: Provider ID to filter by      Returns:     MachineFilterOptions with all      available options for the specific simulator

        :param simulator_name: (required)
        :type simulator_name: str
        :param provider_id:
        :type provider_id: Providers
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_simulator_specific_filter_options_serialize(
            simulator_name=simulator_name,
            provider_id=provider_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MachineFilterOptions",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_simulator_specific_filter_options_serialize(
        self,
        simulator_name,
        provider_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes],
                                List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if simulator_name is not None:
            _path_params['simulator_name'] = simulator_name
        # process the query parameters
        if provider_id is not None:

            _query_params.append(('provider_id', provider_id.value))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                ['application/json'])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method='GET',
            resource_path=
            '/simulators/{simulator_name}/machine-types/filter-options',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)

    @validate_call
    def get_simulator_with_machine_types(
        self,
        simulator_name: StrictStr,
        machine_families: Optional[List[StrictStr]] = None,
        machine_configs: Optional[List[StrictStr]] = None,
        vcpus_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        memory_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        price_range: Optional[Annotated[
            List[Union[StrictFloat, StrictInt]],
            Field(min_length=2, max_length=2)]] = None,
        gpus_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        gpu_names: Optional[List[StrictStr]] = None,
        zones: Optional[List[StrictStr]] = None,
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        per_page: Optional[Annotated[int,
                                     Field(le=100, strict=True, ge=1)]] = None,
        gpu_only: Optional[StrictBool] = None,
        cpu_only: Optional[StrictBool] = None,
        machine_class: Optional[List[StrictStr]] = None,
        provider_id: Optional[Providers] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SimulatorWithMachineTypesPaginated:
        """Get Simulator With Machine Types

        Get an available machine type for a particular simulator.

        :param simulator_name: (required)
        :type simulator_name: str
        :param machine_families:
        :type machine_families: List[str]
        :param machine_configs:
        :type machine_configs: List[str]
        :param vcpus_range:
        :type vcpus_range: List[int]
        :param memory_range:
        :type memory_range: List[int]
        :param price_range:
        :type price_range: List[float]
        :param gpus_range:
        :type gpus_range: List[int]
        :param gpu_names:
        :type gpu_names: List[str]
        :param zones:
        :type zones: List[str]
        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param gpu_only:
        :type gpu_only: bool
        :param cpu_only:
        :type cpu_only: bool
        :param machine_class:
        :type machine_class: List[str]
        :param provider_id:
        :type provider_id: Providers
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_simulator_with_machine_types_serialize(
            simulator_name=simulator_name,
            machine_families=machine_families,
            machine_configs=machine_configs,
            vcpus_range=vcpus_range,
            memory_range=memory_range,
            price_range=price_range,
            gpus_range=gpus_range,
            gpu_names=gpu_names,
            zones=zones,
            page=page,
            per_page=per_page,
            gpu_only=gpu_only,
            cpu_only=cpu_only,
            machine_class=machine_class,
            provider_id=provider_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SimulatorWithMachineTypesPaginated",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_simulator_with_machine_types_with_http_info(
        self,
        simulator_name: StrictStr,
        machine_families: Optional[List[StrictStr]] = None,
        machine_configs: Optional[List[StrictStr]] = None,
        vcpus_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        memory_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        price_range: Optional[Annotated[
            List[Union[StrictFloat, StrictInt]],
            Field(min_length=2, max_length=2)]] = None,
        gpus_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        gpu_names: Optional[List[StrictStr]] = None,
        zones: Optional[List[StrictStr]] = None,
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        per_page: Optional[Annotated[int,
                                     Field(le=100, strict=True, ge=1)]] = None,
        gpu_only: Optional[StrictBool] = None,
        cpu_only: Optional[StrictBool] = None,
        machine_class: Optional[List[StrictStr]] = None,
        provider_id: Optional[Providers] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SimulatorWithMachineTypesPaginated]:
        """Get Simulator With Machine Types

        Get an available machine type for a particular simulator.

        :param simulator_name: (required)
        :type simulator_name: str
        :param machine_families:
        :type machine_families: List[str]
        :param machine_configs:
        :type machine_configs: List[str]
        :param vcpus_range:
        :type vcpus_range: List[int]
        :param memory_range:
        :type memory_range: List[int]
        :param price_range:
        :type price_range: List[float]
        :param gpus_range:
        :type gpus_range: List[int]
        :param gpu_names:
        :type gpu_names: List[str]
        :param zones:
        :type zones: List[str]
        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param gpu_only:
        :type gpu_only: bool
        :param cpu_only:
        :type cpu_only: bool
        :param machine_class:
        :type machine_class: List[str]
        :param provider_id:
        :type provider_id: Providers
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_simulator_with_machine_types_serialize(
            simulator_name=simulator_name,
            machine_families=machine_families,
            machine_configs=machine_configs,
            vcpus_range=vcpus_range,
            memory_range=memory_range,
            price_range=price_range,
            gpus_range=gpus_range,
            gpu_names=gpu_names,
            zones=zones,
            page=page,
            per_page=per_page,
            gpu_only=gpu_only,
            cpu_only=cpu_only,
            machine_class=machine_class,
            provider_id=provider_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SimulatorWithMachineTypesPaginated",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_simulator_with_machine_types_without_preload_content(
        self,
        simulator_name: StrictStr,
        machine_families: Optional[List[StrictStr]] = None,
        machine_configs: Optional[List[StrictStr]] = None,
        vcpus_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        memory_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        price_range: Optional[Annotated[
            List[Union[StrictFloat, StrictInt]],
            Field(min_length=2, max_length=2)]] = None,
        gpus_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        gpu_names: Optional[List[StrictStr]] = None,
        zones: Optional[List[StrictStr]] = None,
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        per_page: Optional[Annotated[int,
                                     Field(le=100, strict=True, ge=1)]] = None,
        gpu_only: Optional[StrictBool] = None,
        cpu_only: Optional[StrictBool] = None,
        machine_class: Optional[List[StrictStr]] = None,
        provider_id: Optional[Providers] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Simulator With Machine Types

        Get an available machine type for a particular simulator.

        :param simulator_name: (required)
        :type simulator_name: str
        :param machine_families:
        :type machine_families: List[str]
        :param machine_configs:
        :type machine_configs: List[str]
        :param vcpus_range:
        :type vcpus_range: List[int]
        :param memory_range:
        :type memory_range: List[int]
        :param price_range:
        :type price_range: List[float]
        :param gpus_range:
        :type gpus_range: List[int]
        :param gpu_names:
        :type gpu_names: List[str]
        :param zones:
        :type zones: List[str]
        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param gpu_only:
        :type gpu_only: bool
        :param cpu_only:
        :type cpu_only: bool
        :param machine_class:
        :type machine_class: List[str]
        :param provider_id:
        :type provider_id: Providers
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_simulator_with_machine_types_serialize(
            simulator_name=simulator_name,
            machine_families=machine_families,
            machine_configs=machine_configs,
            vcpus_range=vcpus_range,
            memory_range=memory_range,
            price_range=price_range,
            gpus_range=gpus_range,
            gpu_names=gpu_names,
            zones=zones,
            page=page,
            per_page=per_page,
            gpu_only=gpu_only,
            cpu_only=cpu_only,
            machine_class=machine_class,
            provider_id=provider_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SimulatorWithMachineTypesPaginated",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_simulator_with_machine_types_serialize(
        self,
        simulator_name,
        machine_families,
        machine_configs,
        vcpus_range,
        memory_range,
        price_range,
        gpus_range,
        gpu_names,
        zones,
        page,
        per_page,
        gpu_only,
        cpu_only,
        machine_class,
        provider_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'machine_families': 'multi',
            'machine_configs': 'multi',
            'vcpus_range': 'multi',
            'memory_range': 'multi',
            'price_range': 'multi',
            'gpus_range': 'multi',
            'gpu_names': 'multi',
            'zones': 'multi',
            'machine_class': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes],
                                List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if simulator_name is not None:
            _path_params['simulator_name'] = simulator_name
        # process the query parameters
        if machine_families is not None:

            _query_params.append(('machine_families', machine_families))

        if machine_configs is not None:

            _query_params.append(('machine_configs', machine_configs))

        if vcpus_range is not None:

            _query_params.append(('vcpus_range', vcpus_range))

        if memory_range is not None:

            _query_params.append(('memory_range', memory_range))

        if price_range is not None:

            _query_params.append(('price_range', price_range))

        if gpus_range is not None:

            _query_params.append(('gpus_range', gpus_range))

        if gpu_names is not None:

            _query_params.append(('gpu_names', gpu_names))

        if zones is not None:

            _query_params.append(('zones', zones))

        if page is not None:

            _query_params.append(('page', page))

        if per_page is not None:

            _query_params.append(('per_page', per_page))

        if gpu_only is not None:

            _query_params.append(('gpu_only', gpu_only))

        if cpu_only is not None:

            _query_params.append(('cpu_only', cpu_only))

        if machine_class is not None:

            _query_params.append(('machine_class', machine_class))

        if provider_id is not None:

            _query_params.append(('provider_id', provider_id.value))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                ['application/json'])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/simulators/{simulator_name}/machine-types',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)

    @validate_call
    def list_all_machine_types(
        self,
        machine_families: Optional[List[StrictStr]] = None,
        machine_configs: Optional[List[StrictStr]] = None,
        vcpus_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        memory_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        price_range: Optional[Annotated[
            List[Union[StrictFloat, StrictInt]],
            Field(min_length=2, max_length=2)]] = None,
        gpus_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        gpu_names: Optional[List[StrictStr]] = None,
        zones: Optional[List[StrictStr]] = None,
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        per_page: Optional[Annotated[int,
                                     Field(le=100, strict=True, ge=1)]] = None,
        gpu_only: Optional[StrictBool] = None,
        cpu_only: Optional[StrictBool] = None,
        machine_class: Optional[List[StrictStr]] = None,
        provider_id: Optional[Providers] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SimulatorWithMachineTypesPaginated:
        """List All Machine Types

        List available machine types for the given provider and zone.

        :param machine_families:
        :type machine_families: List[str]
        :param machine_configs:
        :type machine_configs: List[str]
        :param vcpus_range:
        :type vcpus_range: List[int]
        :param memory_range:
        :type memory_range: List[int]
        :param price_range:
        :type price_range: List[float]
        :param gpus_range:
        :type gpus_range: List[int]
        :param gpu_names:
        :type gpu_names: List[str]
        :param zones:
        :type zones: List[str]
        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param gpu_only:
        :type gpu_only: bool
        :param cpu_only:
        :type cpu_only: bool
        :param machine_class:
        :type machine_class: List[str]
        :param provider_id:
        :type provider_id: Providers
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_all_machine_types_serialize(
            machine_families=machine_families,
            machine_configs=machine_configs,
            vcpus_range=vcpus_range,
            memory_range=memory_range,
            price_range=price_range,
            gpus_range=gpus_range,
            gpu_names=gpu_names,
            zones=zones,
            page=page,
            per_page=per_page,
            gpu_only=gpu_only,
            cpu_only=cpu_only,
            machine_class=machine_class,
            provider_id=provider_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SimulatorWithMachineTypesPaginated",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_all_machine_types_with_http_info(
        self,
        machine_families: Optional[List[StrictStr]] = None,
        machine_configs: Optional[List[StrictStr]] = None,
        vcpus_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        memory_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        price_range: Optional[Annotated[
            List[Union[StrictFloat, StrictInt]],
            Field(min_length=2, max_length=2)]] = None,
        gpus_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        gpu_names: Optional[List[StrictStr]] = None,
        zones: Optional[List[StrictStr]] = None,
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        per_page: Optional[Annotated[int,
                                     Field(le=100, strict=True, ge=1)]] = None,
        gpu_only: Optional[StrictBool] = None,
        cpu_only: Optional[StrictBool] = None,
        machine_class: Optional[List[StrictStr]] = None,
        provider_id: Optional[Providers] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SimulatorWithMachineTypesPaginated]:
        """List All Machine Types

        List available machine types for the given provider and zone.

        :param machine_families:
        :type machine_families: List[str]
        :param machine_configs:
        :type machine_configs: List[str]
        :param vcpus_range:
        :type vcpus_range: List[int]
        :param memory_range:
        :type memory_range: List[int]
        :param price_range:
        :type price_range: List[float]
        :param gpus_range:
        :type gpus_range: List[int]
        :param gpu_names:
        :type gpu_names: List[str]
        :param zones:
        :type zones: List[str]
        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param gpu_only:
        :type gpu_only: bool
        :param cpu_only:
        :type cpu_only: bool
        :param machine_class:
        :type machine_class: List[str]
        :param provider_id:
        :type provider_id: Providers
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_all_machine_types_serialize(
            machine_families=machine_families,
            machine_configs=machine_configs,
            vcpus_range=vcpus_range,
            memory_range=memory_range,
            price_range=price_range,
            gpus_range=gpus_range,
            gpu_names=gpu_names,
            zones=zones,
            page=page,
            per_page=per_page,
            gpu_only=gpu_only,
            cpu_only=cpu_only,
            machine_class=machine_class,
            provider_id=provider_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SimulatorWithMachineTypesPaginated",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_all_machine_types_without_preload_content(
        self,
        machine_families: Optional[List[StrictStr]] = None,
        machine_configs: Optional[List[StrictStr]] = None,
        vcpus_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        memory_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        price_range: Optional[Annotated[
            List[Union[StrictFloat, StrictInt]],
            Field(min_length=2, max_length=2)]] = None,
        gpus_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        gpu_names: Optional[List[StrictStr]] = None,
        zones: Optional[List[StrictStr]] = None,
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        per_page: Optional[Annotated[int,
                                     Field(le=100, strict=True, ge=1)]] = None,
        gpu_only: Optional[StrictBool] = None,
        cpu_only: Optional[StrictBool] = None,
        machine_class: Optional[List[StrictStr]] = None,
        provider_id: Optional[Providers] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List All Machine Types

        List available machine types for the given provider and zone.

        :param machine_families:
        :type machine_families: List[str]
        :param machine_configs:
        :type machine_configs: List[str]
        :param vcpus_range:
        :type vcpus_range: List[int]
        :param memory_range:
        :type memory_range: List[int]
        :param price_range:
        :type price_range: List[float]
        :param gpus_range:
        :type gpus_range: List[int]
        :param gpu_names:
        :type gpu_names: List[str]
        :param zones:
        :type zones: List[str]
        :param page:
        :type page: int
        :param per_page:
        :type per_page: int
        :param gpu_only:
        :type gpu_only: bool
        :param cpu_only:
        :type cpu_only: bool
        :param machine_class:
        :type machine_class: List[str]
        :param provider_id:
        :type provider_id: Providers
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_all_machine_types_serialize(
            machine_families=machine_families,
            machine_configs=machine_configs,
            vcpus_range=vcpus_range,
            memory_range=memory_range,
            price_range=price_range,
            gpus_range=gpus_range,
            gpu_names=gpu_names,
            zones=zones,
            page=page,
            per_page=per_page,
            gpu_only=gpu_only,
            cpu_only=cpu_only,
            machine_class=machine_class,
            provider_id=provider_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SimulatorWithMachineTypesPaginated",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _list_all_machine_types_serialize(
        self,
        machine_families,
        machine_configs,
        vcpus_range,
        memory_range,
        price_range,
        gpus_range,
        gpu_names,
        zones,
        page,
        per_page,
        gpu_only,
        cpu_only,
        machine_class,
        provider_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'machine_families': 'multi',
            'machine_configs': 'multi',
            'vcpus_range': 'multi',
            'memory_range': 'multi',
            'price_range': 'multi',
            'gpus_range': 'multi',
            'gpu_names': 'multi',
            'zones': 'multi',
            'machine_class': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes],
                                List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if machine_families is not None:

            _query_params.append(('machine_families', machine_families))

        if machine_configs is not None:

            _query_params.append(('machine_configs', machine_configs))

        if vcpus_range is not None:

            _query_params.append(('vcpus_range', vcpus_range))

        if memory_range is not None:

            _query_params.append(('memory_range', memory_range))

        if price_range is not None:

            _query_params.append(('price_range', price_range))

        if gpus_range is not None:

            _query_params.append(('gpus_range', gpus_range))

        if gpu_names is not None:

            _query_params.append(('gpu_names', gpu_names))

        if zones is not None:

            _query_params.append(('zones', zones))

        if page is not None:

            _query_params.append(('page', page))

        if per_page is not None:

            _query_params.append(('per_page', per_page))

        if gpu_only is not None:

            _query_params.append(('gpu_only', gpu_only))

        if cpu_only is not None:

            _query_params.append(('cpu_only', cpu_only))

        if machine_class is not None:

            _query_params.append(('machine_class', machine_class))

        if provider_id is not None:

            _query_params.append(('provider_id', provider_id.value))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                ['application/json'])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/simulators/machine-types',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)

    @validate_call
    def list_available_images(
        self,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AvailableSimulatorVersions:
        """List Available Images

        List available simulator versions with fallback mechanism.  First tries to get images from DockerHub API, if that fails, falls back to the database.  Returns:     A dictionary with the available simulator versions, grouped by branch     (development/production) and simulator name. {     {'development':         {'amr-wind': ['1.4.0'],           ...          'dualsphysics': ['5.2.1']         },     'production':         {'amr-wind': ['1.3.0', '1.4.0'],           ...          'dualsphysics': ['5.2.1']         }     } }

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_available_images_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AvailableSimulatorVersions",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_available_images_with_http_info(
        self,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AvailableSimulatorVersions]:
        """List Available Images

        List available simulator versions with fallback mechanism.  First tries to get images from DockerHub API, if that fails, falls back to the database.  Returns:     A dictionary with the available simulator versions, grouped by branch     (development/production) and simulator name. {     {'development':         {'amr-wind': ['1.4.0'],           ...          'dualsphysics': ['5.2.1']         },     'production':         {'amr-wind': ['1.3.0', '1.4.0'],           ...          'dualsphysics': ['5.2.1']         }     } }

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_available_images_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AvailableSimulatorVersions",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_available_images_without_preload_content(
        self,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Available Images

        List available simulator versions with fallback mechanism.  First tries to get images from DockerHub API, if that fails, falls back to the database.  Returns:     A dictionary with the available simulator versions, grouped by branch     (development/production) and simulator name. {     {'development':         {'amr-wind': ['1.4.0'],           ...          'dualsphysics': ['5.2.1']         },     'production':         {'amr-wind': ['1.3.0', '1.4.0'],           ...          'dualsphysics': ['5.2.1']         }     } }

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_available_images_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AvailableSimulatorVersions",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _list_available_images_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes],
                                List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                ['application/json'])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/simulators/available-images',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)

    @validate_call
    def list_simulators(
        self,
        name: Optional[StrictStr] = None,
        include_archived: Optional[StrictBool] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[SimulatorResponse]:
        """List Simulators

        List all simulators.

        :param name:
        :type name: str
        :param include_archived:
        :type include_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_simulators_serialize(
            name=name,
            include_archived=include_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[SimulatorResponse]",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_simulators_with_http_info(
        self,
        name: Optional[StrictStr] = None,
        include_archived: Optional[StrictBool] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[SimulatorResponse]]:
        """List Simulators

        List all simulators.

        :param name:
        :type name: str
        :param include_archived:
        :type include_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_simulators_serialize(
            name=name,
            include_archived=include_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[SimulatorResponse]",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_simulators_without_preload_content(
        self,
        name: Optional[StrictStr] = None,
        include_archived: Optional[StrictBool] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Simulators

        List all simulators.

        :param name:
        :type name: str
        :param include_archived:
        :type include_archived: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_simulators_serialize(
            name=name,
            include_archived=include_archived,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[SimulatorResponse]",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _list_simulators_serialize(
        self,
        name,
        include_archived,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes],
                                List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if name is not None:

            _query_params.append(('name', name))

        if include_archived is not None:

            _query_params.append(('include_archived', include_archived))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                ['application/json'])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/simulators/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)

    @validate_call
    def update_simulator(
        self,
        simulator_id: StrictStr,
        simulator_update: SimulatorUpdate,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SimulatorResponse:
        """Update Simulator

        Update a simulator.

        :param simulator_id: (required)
        :type simulator_id: str
        :param simulator_update: (required)
        :type simulator_update: SimulatorUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_simulator_serialize(
            simulator_id=simulator_id,
            simulator_update=simulator_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SimulatorResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def update_simulator_with_http_info(
        self,
        simulator_id: StrictStr,
        simulator_update: SimulatorUpdate,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SimulatorResponse]:
        """Update Simulator

        Update a simulator.

        :param simulator_id: (required)
        :type simulator_id: str
        :param simulator_update: (required)
        :type simulator_update: SimulatorUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_simulator_serialize(
            simulator_id=simulator_id,
            simulator_update=simulator_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SimulatorResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def update_simulator_without_preload_content(
        self,
        simulator_id: StrictStr,
        simulator_update: SimulatorUpdate,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update Simulator

        Update a simulator.

        :param simulator_id: (required)
        :type simulator_id: str
        :param simulator_update: (required)
        :type simulator_update: SimulatorUpdate
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_simulator_serialize(
            simulator_id=simulator_id,
            simulator_update=simulator_update,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SimulatorResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _update_simulator_serialize(
        self,
        simulator_id,
        simulator_update,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes],
                                List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if simulator_id is not None:
            _path_params['simulator_id'] = simulator_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if simulator_update is not None:
            _body_params = simulator_update

        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                ['application/json'])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (self.api_client.select_header_content_type(
                ['application/json']))
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ['APIKeyHeader']

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/simulators/{simulator_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)
